/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.update.tables;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Artigosmovimentos;
import org.projectocolibri.api.database.model.Contasbancarias;
import org.projectocolibri.api.database.model.Parametros;
import org.projectocolibri.api.database.model.Templates;
import org.projectocolibri.api.database.query.TransactionalQuery;
import org.projectocolibri.api.database.update.tables.AbstractUpdate;

public final class Version140to141
extends AbstractUpdate {
    public Version140to141(DatabaseManager manager) {
        super(manager);
    }

    public void run(IProgressMonitor monitor) throws Exception {
        new TransactionalQuery<Contasbancarias>(TABLES.contasbancarias, this.manager){

            @Override
            public void process(Contasbancarias model) throws Exception {
                if (model.getCodigopostal() == null) {
                    model.setCodigopostal(this.manager.getEmpresa().getCodigopostal());
                }
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Templates>(TABLES.templates, this.manager){
            final Collection<String> list;
            {
                this.list = Arrays.asList("201", "203");
            }

            @Override
            public void process(Templates model) throws Exception {
                if (this.list.contains(model.getCodigo())) {
                    this.delete(model);
                }
            }
        }.executeTryCatch();
        this.populate(TABLES.templates);
        new TransactionalQuery<Parametros>(TABLES.parametros, this.manager){

            @Override
            public void process(Parametros model) throws Exception {
                if (model.getMbprovider() == 1) {
                    model.setMbprovider(2);
                }
                if (model.getMbidpagamento() == null) {
                    model.setMbidpagamento(this.manager.getLicenca().contains(String.valueOf(Colibri.AUTOR_LEGAL.nif)) ? 1 : 0);
                }
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Artigosmovimentos>(TABLES.artigosmovimentos, this.manager){

            @Override
            public void process(Artigosmovimentos model) throws Exception {
                if (model.getLinhaorigem() != null) {
                    model.setCampo1(model.getLinhaorigem().getCampo1());
                    model.setCampo2(model.getLinhaorigem().getCampo2());
                    model.setCampo3(model.getLinhaorigem().getCampo3());
                    model.setCampo4(model.getLinhaorigem().getCampo4());
                    model.setCampo5(model.getLinhaorigem().getCampo5());
                }
                this.store(model);
            }
        }.execute();
    }
}

