/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.update.tables;

import java.util.Arrays;
import java.util.Collection;
import org.dma.java.security.CaesarCiphers;
import org.eclipse.core.runtime.IProgressMonitor;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Contasbancarias;
import org.projectocolibri.api.database.model.Documentostipos;
import org.projectocolibri.api.database.model.Entidades;
import org.projectocolibri.api.database.model.Entidadesdocumentos;
import org.projectocolibri.api.database.model.Layouts;
import org.projectocolibri.api.database.model.Templates;
import org.projectocolibri.api.database.model.Utilizadores;
import org.projectocolibri.api.database.query.TransactionalQuery;
import org.projectocolibri.api.database.update.tables.AbstractUpdate;
import org.projectocolibri.core.support.PermissionsMap;

public final class Version131to140
extends AbstractUpdate {
    public Version131to140(DatabaseManager manager) {
        super(manager);
    }

    public void run(IProgressMonitor monitor) throws Exception {
        new TransactionalQuery<Utilizadores>(TABLES.utilizadores, this.manager){

            @Override
            public void process(Utilizadores model) throws Exception {
                Utilizadores.COMMANDS command;
                String permissoes = model.getPermissoes();
                Utilizadores.COMMANDS[] cOMMANDSArray = Utilizadores.COMMANDS.values();
                int n = cOMMANDSArray.length;
                int n2 = 0;
                while (n2 < n) {
                    command = cOMMANDSArray[n2];
                    permissoes = permissoes.replace(command.name(), new CaesarCiphers(command.name()).rot13());
                    ++n2;
                }
                permissoes = permissoes.replace("Novo", new CaesarCiphers(Utilizadores.COMMANDS.NovoRegisto.name()).rot13()).replace("Editar", new CaesarCiphers(Utilizadores.COMMANDS.EditarRegisto.name()).rot13()).replace("Anular", new CaesarCiphers(Utilizadores.COMMANDS.AnularRegisto.name()).rot13()).replace("Duplicar", new CaesarCiphers(Utilizadores.COMMANDS.DuplicarRegisto.name()).rot13()).replace("Gravar", new CaesarCiphers(Utilizadores.COMMANDS.GravarRegisto.name()).rot13()).replace("Anonimizar", new CaesarCiphers(Utilizadores.COMMANDS.AnonimizarRegisto.name()).rot13()).replace("Actualizar", new CaesarCiphers(Utilizadores.COMMANDS.ActualizarRegisto.name()).rot13()).replace("Pesquisar", new CaesarCiphers(Utilizadores.COMMANDS.PesquisarRegisto.name()).rot13()).replace("Processar", new CaesarCiphers(Utilizadores.COMMANDS.ProcessarRegisto.name()).rot13()).replace("Comunicar", new CaesarCiphers(Utilizadores.COMMANDS.ComunicarRegisto.name()).rot13()).replace("Copiar", new CaesarCiphers(Utilizadores.COMMANDS.CopiarRegisto.name()).rot13()).replace("Colar", new CaesarCiphers(Utilizadores.COMMANDS.ColarRegisto.name()).rot13()).replace("Importar", new CaesarCiphers(Utilizadores.COMMANDS.ImportarRegisto.name()).rot13()).replace("Exportar", new CaesarCiphers(Utilizadores.COMMANDS.ExportarRegisto.name()).rot13()).replace("Template", new CaesarCiphers(Utilizadores.COMMANDS.EditarTemplate.name()).rot13()).replace("Filtro", new CaesarCiphers(Utilizadores.COMMANDS.EditarFiltro.name()).rot13()).replace("Emitir", new CaesarCiphers(Utilizadores.COMMANDS.EmitirRelatorio.name()).rot13()).replace("Imprimir", new CaesarCiphers(Utilizadores.COMMANDS.ImprimirRelatorio.name()).rot13()).replace("Email", new CaesarCiphers(Utilizadores.COMMANDS.EmailRelatorio.name()).rot13()).replace("Anterior", new CaesarCiphers(Utilizadores.COMMANDS.RegistoAnterior.name()).rot13()).replace("Proximo", new CaesarCiphers(Utilizadores.COMMANDS.ProximoRegisto.name()).rot13()).replace("Adicionar", new CaesarCiphers(Utilizadores.COMMANDS.AdicionarLinha.name()).rot13()).replace("Inserir", new CaesarCiphers(Utilizadores.COMMANDS.InserirLinha.name()).rot13()).replace("Remover", new CaesarCiphers(Utilizadores.COMMANDS.RemoverLinha.name()).rot13());
                cOMMANDSArray = Utilizadores.COMMANDS.values();
                n = cOMMANDSArray.length;
                n2 = 0;
                while (n2 < n) {
                    command = cOMMANDSArray[n2];
                    permissoes = permissoes.replace(new CaesarCiphers(command.name()).rot13(), command.name());
                    ++n2;
                }
                PermissionsMap map = new PermissionsMap(permissoes);
                map.get(TABLES.artigos).add(Utilizadores.COMMANDS.RegistoAnterior);
                map.get(TABLES.artigos).add(Utilizadores.COMMANDS.ProximoRegisto);
                map.get(TABLES.artigosdocumentos).add(Utilizadores.COMMANDS.RegistoAnterior);
                map.get(TABLES.artigosdocumentos).add(Utilizadores.COMMANDS.ProximoRegisto);
                map.get(TABLES.artigosdocumentoslinhas).add(Utilizadores.COMMANDS.MoverCima);
                map.get(TABLES.artigosdocumentoslinhas).add(Utilizadores.COMMANDS.MoverBaixo);
                map.get(TABLES.entidades).add(Utilizadores.COMMANDS.ProcessarRegisto);
                map.get(TABLES.entidades).add(Utilizadores.COMMANDS.RegistoAnterior);
                map.get(TABLES.entidades).add(Utilizadores.COMMANDS.ProximoRegisto);
                map.get(TABLES.entidadesdocumentos).add(Utilizadores.COMMANDS.RegistoAnterior);
                map.get(TABLES.entidadesdocumentos).add(Utilizadores.COMMANDS.ProximoRegisto);
                map.get(TABLES.entidadesdocumentoslinhas).add(Utilizadores.COMMANDS.MoverCima);
                map.get(TABLES.entidadesdocumentoslinhas).add(Utilizadores.COMMANDS.MoverBaixo);
                model.setPermissoes(map);
                model.setChecksum();
                this.store(model);
            }
        }.execute();
        this.populate(TABLES.paises);
        new TransactionalQuery<Contasbancarias>(TABLES.contasbancarias, this.manager){

            @Override
            public void process(Contasbancarias model) throws Exception {
                if (model.getIban() == null) {
                    model.setIban(model.getNib());
                }
                if (model.getCodigopostal() == null) {
                    model.setCodigopostal(this.manager.getEmpresa().getCodigopostal());
                }
                model.clearDeprecated();
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Layouts>(TABLES.layouts, this.manager){

            @Override
            public void process(Layouts model) throws Exception {
                Layouts.RECORDS[] rECORDSArray = new Layouts.RECORDS[]{Layouts.RECORDS.entidades_listagem_telefones, Layouts.RECORDS.entidades_listagem_moradas};
                int n = rECORDSArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Layouts.RECORDS record = rECORDSArray[n2];
                    if (model.equals(record.codigo)) {
                        model.setLayout(record.array);
                        this.store(model);
                    }
                    ++n2;
                }
            }
        }.execute();
        new TransactionalQuery<Templates>(TABLES.templates, this.manager){
            final Collection<String> list;
            {
                this.list = Arrays.asList("503");
            }

            @Override
            public void process(Templates model) throws Exception {
                if (this.list.contains(model.getCodigo())) {
                    this.delete(model);
                }
            }
        }.executeTryCatch();
        this.populate(TABLES.templates);
        new TransactionalQuery<Documentostipos>(TABLES.documentostipos, this.manager){

            @Override
            public void process(Documentostipos model) throws Exception {
                if (model.getTemplate(0).equals("702")) {
                    model.setTemplate(Templates.RECORDS.entidadesdocumentos_factura);
                }
                if (model.getTemplate(0).equals("712")) {
                    model.setTemplate(Templates.RECORDS.entidadesdocumentos_recibo);
                }
                if (model.getTemplate(0).equals("722")) {
                    model.setTemplate(Templates.RECORDS.entidadesdocumentos_lancamento);
                }
                if (model.getTemplate(0).equals("752")) {
                    model.setTemplate(Templates.RECORDS.entidadesdocumentos_guia_transporte);
                }
                if (model.getTemplate(0).equals("762")) {
                    model.setTemplate(Templates.RECORDS.entidadesdocumentos_factura_talao);
                }
                if (model.getTemplate(0).equals("782")) {
                    model.setTemplate(Templates.RECORDS.entidadesdocumentos_factura_exportacao_PT);
                }
                if (model.getTemplate(0).equals("792")) {
                    model.setTemplate(Templates.RECORDS.entidadesdocumentos_factura_exportacao_EN);
                }
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Entidades>(TABLES.entidades, this.manager){

            @Override
            public void process(Entidades model) throws Exception {
                if (model.getIban() == null) {
                    model.setIban(model.getNib());
                }
                model.clearDeprecated();
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Entidadesdocumentos>(TABLES.entidadesdocumentos, this.manager){

            @Override
            public void process(Entidadesdocumentos model) throws Exception {
                if (model.getPaiscarga() == null) {
                    model.setPaiscarga(model.getPais());
                }
                if (model.getPaisdescarga() == null) {
                    model.setPaisdescarga(model.getPais());
                }
                model.clearDeprecated();
                this.store(model);
            }
        }.execute();
    }
}

