/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.update.tables;

import org.eclipse.core.runtime.IProgressMonitor;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Entidades;
import org.projectocolibri.api.database.model.Entidadesmoradas;
import org.projectocolibri.api.database.model.Familias;
import org.projectocolibri.api.database.model.Grupos;
import org.projectocolibri.api.database.query.TransactionalQuery;
import org.projectocolibri.api.database.update.tables.AbstractUpdate;

public final class Version123to130
extends AbstractUpdate {
    public Version123to130(DatabaseManager manager) {
        super(manager);
    }

    public void run(IProgressMonitor monitor) throws Exception {
        new TransactionalQuery<Grupos>(TABLES.grupos, this.manager){

            @Override
            public void process(Grupos model) throws Exception {
                if (model.getTabela() == null) {
                    model.setTabela(0);
                }
                this.store(model);
            }
        }.execute();
        this.populate(TABLES.grupos);
        new TransactionalQuery<Familias>(TABLES.familias, this.manager){

            @Override
            public void process(Familias model) throws Exception {
                if (model.getTabela() == null) {
                    model.setTabela(0);
                }
                this.store(model);
            }
        }.execute();
        this.populate(TABLES.familias);
        this.populate(TABLES.tiposmorada);
        this.populate(TABLES.templates);
        new TransactionalQuery<Entidades>(TABLES.entidades, this.manager){

            @Override
            public void process(Entidades model) throws Exception {
                if (model.getMoradas().isEmpty()) {
                    Entidadesmoradas morada = model.addMoradas();
                    morada.setMorada(model.getMorada());
                    morada.setCodigopostal(model.getCodigopostal());
                    morada.setLocalidade(model.getLocalidade());
                    morada.setPais(model.getPais());
                }
                if (model.getGrupo() == null) {
                    model.setGrupo(this.manager.loadGrupos(1, 0));
                }
                if (model.getFamilia() == null) {
                    model.setFamilia(this.manager.loadFamilias(1, 0));
                }
                this.store(model);
            }
        }.execute();
    }
}

