/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.update.tables;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Armazens;
import org.projectocolibri.api.database.model.Documentosseries;
import org.projectocolibri.api.database.model.Documentostipos;
import org.projectocolibri.api.database.model.Entidadesdocumentos;
import org.projectocolibri.api.database.model.Metodostransporte;
import org.projectocolibri.api.database.model.Utilizadores;
import org.projectocolibri.api.database.model.Viaturas;
import org.projectocolibri.api.database.query.TransactionalQuery;
import org.projectocolibri.api.database.update.tables.AbstractUpdate;
import org.projectocolibri.core.support.PermissionsMap;

public final class Version121to122
extends AbstractUpdate {
    public Version121to122(DatabaseManager manager) {
        super(manager);
    }

    public void run(IProgressMonitor monitor) throws Exception {
        new TransactionalQuery<Utilizadores>(TABLES.utilizadores, this.manager){

            @Override
            public void process(Utilizadores model) throws Exception {
                PermissionsMap map = new PermissionsMap(model.getPermissoes());
                map.get(TABLES.entidades).add(Utilizadores.COMMANDS.ComunicarRegisto);
                model.setPermissoes(map);
                model.setChecksum();
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Metodostransporte>(TABLES.metodostransporte, this.manager){
            final Collection<String> list;
            {
                this.list = Arrays.asList("VA", "EM", "AE");
            }

            @Override
            public void process(Metodostransporte model) throws Exception {
                if (this.list.contains(model.getCodigo())) {
                    this.delete(model);
                }
            }
        }.executeTryCatch();
        this.populate(TABLES.metodostransporte);
        new TransactionalQuery<Armazens>(TABLES.armazens, this.manager){

            @Override
            public void process(Armazens model) throws Exception {
                if (model.getCodigopostal() == null) {
                    model.setCodigopostal(this.manager.getEmpresa().getCodigopostal());
                }
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Viaturas>(TABLES.viaturas, this.manager){
            final Collection<String> list;
            {
                this.list = Arrays.asList("NC", "VC");
            }

            @Override
            public void process(Viaturas model) throws Exception {
                if (this.list.contains(model.getCodigo())) {
                    this.delete(model);
                }
            }
        }.executeTryCatch();
        this.populate(TABLES.viaturas);
        new TransactionalQuery<Documentostipos>(TABLES.documentostipos, this.manager){

            @Override
            public void process(Documentostipos model) throws Exception {
                if (model.isTipodocumentosaft(6) && model.isTipodocumentosaft(7) && model.isTipodocumentosaft(8) && model.isTipodocumentosaft(24)) {
                    model.setEstado(0);
                }
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Documentosseries>(TABLES.documentosseries, this.manager){

            @Override
            public void process(Documentosseries model) throws Exception {
                if (model.getEstado() == null) {
                    model.setEstado(1);
                }
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Entidadesdocumentos>(TABLES.entidadesdocumentos, this.manager){

            @Override
            public void process(Entidadesdocumentos model) throws Exception {
                if (model.getCodigopostalcarga() == null || model.getCodigopostaldescarga() == null) {
                    this.manager.attach(model.getTipodocumento());
                    model.setCodigopostalcarga(model.getTipodocumento().getArmazemcarga().getCodigopostal());
                    model.setCodigopostaldescarga(model.getTipodocumento().getArmazemdescarga().getCodigopostal());
                    if (!model.getTipodocumento().isTipodocumento(2)) {
                        switch (model.getTipodocumento().getMovimentaartigos()) {
                            case 0: {
                                switch (model.getTipodocumento().getTipoentidade().getTipoentidade()) {
                                    case 0: {
                                        model.setCodigopostaldescarga(model.getCodigopostal());
                                        break;
                                    }
                                    case 1: {
                                        model.setCodigopostalcarga(model.getCodigopostal());
                                    }
                                }
                                break;
                            }
                            case 1: {
                                model.setCodigopostaldescarga(model.getCodigopostal());
                                break;
                            }
                            case 2: 
                            case 3: {
                                model.setCodigopostalcarga(model.getCodigopostal());
                            }
                        }
                    }
                }
                if (model.getViatura() == null) {
                    model.setViatura(this.manager.loadViaturas(0));
                }
                this.store(model);
            }
        }.execute();
    }
}

