/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.update.tables;

import java.math.BigDecimal;
import java.sql.Time;
import java.util.Date;
import org.dma.java.math.SIGNUM;
import org.eclipse.core.runtime.IProgressMonitor;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Entidadesdocumentos;
import org.projectocolibri.api.database.model.Entidadesdocumentosatws;
import org.projectocolibri.api.database.model.Entidadesmovimentos;
import org.projectocolibri.api.database.model.Layouts;
import org.projectocolibri.api.database.model.Utilizadores;
import org.projectocolibri.api.database.query.TransactionalQuery;
import org.projectocolibri.api.database.update.tables.AbstractUpdate;
import org.projectocolibri.api.services.at.ATWebserviceResponseType;

public final class Version100to101
extends AbstractUpdate {
    public Version100to101(DatabaseManager manager) {
        super(manager);
    }

    public void run(IProgressMonitor monitor) throws Exception {
        new TransactionalQuery<Entidadesmovimentos>(TABLES.entidadesmovimentos, this.manager){

            @Override
            public void process(Entidadesmovimentos model) throws Exception {
                switch (model.getTipodocumento().getTipodocumento()) {
                    case 1: 
                    case 4: {
                        if (model.getTotalretencoes().signum() == 0 || model.getTiposaldo() != 0 || !model.hasValorpendente() || !model.hasValorjustificado()) break;
                        throw new Exception("Existem facturas com RETEN\u00c7\u00c3O parcialmente justificadas");
                    }
                }
            }
        }.execute();
        new TransactionalQuery<Utilizadores>(TABLES.utilizadores, this.manager){

            @Override
            public void process(Utilizadores model) throws Exception {
                model.setPermissoes(model.getPermissoes().replace("Novalinha", Utilizadores.COMMANDS.AdicionarLinha.name()).replace("Inserirlinha", Utilizadores.COMMANDS.InserirLinha.name()).replace("Removerlinha", Utilizadores.COMMANDS.RemoverLinha.name()));
                model.setChecksum();
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Layouts>(TABLES.layouts, this.manager){

            @Override
            public void process(Layouts model) throws Exception {
                if (model.equals(Layouts.RECORDS.entidadesdocumentoslinhas_recibo.codigo)) {
                    model.setLayout(Layouts.RECORDS.entidadesdocumentoslinhas_recibo.array);
                    this.store(model);
                }
            }
        }.execute();
        this.populate(TABLES.templates);
        this.populate(TABLES.documentostipos);
        new TransactionalQuery<Entidadesdocumentos>(TABLES.entidadesdocumentos, this.manager){

            @Override
            public void process(Entidadesdocumentos model) throws Exception {
                if (model.getPais().isPortugal() && model.getNifToText().isEmpty()) {
                    model.setNif("999999990");
                }
                if (model.getContadorvias() == null) {
                    model.setContadorvias(0);
                }
                if (model.getTotalbruto() == null) {
                    model.setTotalbruto(model.getTotal());
                }
                switch (model.getTipodocumento().getTipodocumento()) {
                    case 1: 
                    case 4: {
                        break;
                    }
                    case 2: {
                        if (model.getTotalretencoes().signum() == 0) break;
                        model.setEstado(2);
                    }
                }
                if (model.getWebservice().isEmpty() && model.getDataenvio() != null && model.getHoraenvio() != null) {
                    Entidadesdocumentosatws ws = model.createWebservice(new ATWebserviceResponseType(model.getReturncode(), model.getReturnmessage(), model.getDocumentcode()));
                    ws.setDataenvio(new Date(model.getDataenvio().getTime()));
                    ws.setHoraenvio(new Time(model.getHoraenvio().getTime()));
                    model.addWebservice(ws);
                }
                this.store(model);
            }
        }.execute();
        new TransactionalQuery<Entidadesmovimentos>(TABLES.entidadesmovimentos, this.manager){

            @Override
            public void process(Entidadesmovimentos model) throws Exception {
                model.setTabelaiva(model.getDocumento().getTabelaiva());
                if (model.getNifToText().isEmpty()) {
                    model.setNif("999999990");
                }
                BigDecimal sinalsaldo = BigDecimal.ZERO;
                block0 : switch (model.getTipodocumento().getMovimentaentidades()) {
                    case 1: {
                        switch (model.getTipodocumento().getTipoentidade().getTipoentidade()) {
                            case 0: {
                                sinalsaldo = SIGNUM.MINUS_ONE.value;
                                break;
                            }
                            case 1: {
                                sinalsaldo = SIGNUM.ONE.value;
                            }
                        }
                        break;
                    }
                    case 2: {
                        switch (model.getTipodocumento().getTipoentidade().getTipoentidade()) {
                            case 0: {
                                sinalsaldo = SIGNUM.ONE.value;
                                break block0;
                            }
                            case 1: {
                                sinalsaldo = SIGNUM.MINUS_ONE.value;
                            }
                        }
                    }
                }
                model.setSinalsaldo(model.getTipodocumento().isTipodocumento(2) ? sinalsaldo : sinalsaldo.negate());
                if (model.getTotalbruto() == null) {
                    model.setTotalbruto(model.getTotal());
                    model.getEntidade().addAcumulados(model.getValordebito(), model.getValorcredito(), model.getTiposaldo(), SIGNUM.MINUS_ONE);
                    switch (model.getTipodocumento().getTipodocumento()) {
                        case 1: 
                        case 4: {
                            if (model.getTotalretencoes().signum() == 0 || model.getTiposaldo() != 0 || !model.hasValorpendente()) break;
                            Entidadesdocumentos documento = model.getDocumento().cloneCopy();
                            documento.setTotalbruto(documento.getTotalliquido().add(documento.getTotaliva()));
                            Entidadesmovimentos movimento2 = new Entidadesmovimentos(documento);
                            model.setValorpendente(movimento2.getValorpendente());
                            model.setValordebito(movimento2.getValordebito());
                            model.setValorcredito(movimento2.getValorcredito());
                            break;
                        }
                    }
                    model.getEntidade().addAcumulados(model.getValordebito(), model.getValorcredito(), model.getTiposaldo(), SIGNUM.ONE);
                }
                this.store(model);
            }
        }.execute();
    }
}

