/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.update;

import org.dma.eclipse.jface.dialogs.message.InformationDialog;
import org.dma.eclipse.jface.dialogs.message.QuestionDialog;
import org.dma.eclipse.jface.dialogs.progress.IProgressAction;
import org.dma.eclipse.jface.dialogs.progress.ProgressSupport;
import org.dma.java.util.MessageList;
import org.dma.java.util.VersionNumber;
import org.projectocolibri.api.Activator;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.update.tables.SchemaUpdate;
import org.projectocolibri.api.database.update.templates.DesignUpdate;
import org.projectocolibri.api.language.LABELS;

public class UpdateManager
extends ProgressSupport {
    private static final long serialVersionUID = 1L;
    private final DatabaseManager manager;

    public UpdateManager(DatabaseManager manager) {
        super(LABELS.info_database_actualizacaoexecucao.toString());
        this.manager = manager;
    }

    public boolean run(boolean silent) throws Exception {
        int index = VERSIONS.indexOf(this.manager.getVersion());
        if (index != -1 && index < VERSIONS.values().length - 1) {
            Package[] packageArray = new Package[]{DesignUpdate.class.getPackage(), SchemaUpdate.class.getPackage()};
            int n = packageArray.length;
            int n2 = 0;
            while (n2 < n) {
                Package Package2 = packageArray[n2];
                int i = index;
                while (i < VERSIONS.values().length - 1) {
                    String className = "Version" + (Object)((Object)VERSIONS.values()[i]) + "to" + (Object)((Object)VERSIONS.values()[i + 1]);
                    Class klass = Activator.classForName(String.valueOf(Package2.getName()) + "." + className);
                    if (klass != null) {
                        this.put((IProgressAction)klass.getConstructor(DatabaseManager.class).newInstance(this.manager), null);
                    }
                    ++i;
                }
                ++n2;
            }
            this.put(new SchemaUpdate(this.manager), null);
            if (!super.run(silent)) {
                return false;
            }
            if (!this.manager.updateVersion()) {
                throw new Exception(LABELS.erro_database_actualizacaofalhada.toString());
            }
            return true;
        }
        return false;
    }

    private RESULT execute(boolean silent) throws Exception {
        if (!this.manager.getLicenca().allows(Colibri.FUNCIONALIDADES.LICENCA_COMERCIAL)) {
            VersionNumber version = VERSIONS.v150.version;
            if (this.manager.getVersion().smallerThan(version) && !Colibri.VERSION_NUMBER.smallerThan(version)) {
                InformationDialog.open((String)(silent ? null : Colibri.FILES.MESSAGES.AVISO_VERSAO_GRATUITA.text));
            }
        }
        if (!QuestionDialog.open((String)LABELS.pergunta_database_actualizar.toString(), (MessageList)(silent ? new MessageList() : new MessageList(new String[]{LABELS.info_operacao_irreversivel.toString(), new MessageList(new String[]{LABELS.DATABASE.toString(), this.manager.getParameters().database}).toString(": "), new MessageList(new String[]{LABELS.VERSAO.toString(), this.manager.getVersion().toString(2)}).toString(": ")})))) {
            return RESULT.ABORTED;
        }
        if (!this.run(silent)) {
            return RESULT.CANCELED;
        }
        return RESULT.SUCCESS;
    }

    public synchronized RESULT execute() throws Exception {
        return this.execute(Colibri.VERSION_TYPE.silent);
    }

    public static enum RESULT {
        IGNORED,
        ABORTED,
        CANCELED,
        SUCCESS;

    }

    public static enum VERSIONS {
        v50(5, 0),
        v51(5, 1),
        v52(5, 2),
        v60(6, 0),
        v62(6, 2),
        v63(6, 3),
        v70(7, 0),
        v71(7, 1),
        v80(8, 0),
        v90(9, 0),
        v91(9, 1),
        v92(9, 2),
        v93(9, 3),
        v94(9, 4),
        v100(10, 0),
        v101(10, 1),
        v102(10, 2),
        v110(11, 0),
        v111(11, 1),
        v112(11, 2),
        v113(11, 3),
        v120(12, 0),
        v121(12, 1),
        v122(12, 2),
        v123(12, 3),
        v130(13, 0),
        v131(13, 1),
        v140(14, 0),
        v141(14, 1),
        v142(14, 2),
        v150(15, 0),
        v151(15, 1),
        v160(16, 0),
        v161(16, 1);

        public final VersionNumber version;

        private VERSIONS(int major, int minor) {
            this(new VersionNumber(major, minor));
        }

        private VERSIONS(VersionNumber version) {
            this.version = version;
        }

        public String toString() {
            return String.valueOf(this.version.major) + this.version.minor;
        }

        public static VersionNumber parse(VersionNumber version) {
            return new VersionNumber(version.major, version.minor);
        }

        public static int indexOf(VersionNumber version) {
            VERSIONS[] vERSIONSArray = VERSIONS.values();
            int n = vERSIONSArray.length;
            int n2 = 0;
            while (n2 < n) {
                VERSIONS value = vERSIONSArray[n2];
                if (VERSIONS.parse(version).equals(value.version)) {
                    return value.ordinal();
                }
                ++n2;
            }
            return -1;
        }
    }
}

