/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.query.builder;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import org.projectocolibri.api.database.filter.FilterFieldMap;
import org.projectocolibri.api.database.filter.FilterMap;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TableFieldKey;
import org.projectocolibri.api.database.query.builder.QueryFieldMap;
import org.projectocolibri.api.database.query.builder.QueryParametersMap;
import org.projectocolibri.api.database.query.builder.QuerySetMap;

public class QueryTableMap
extends ArrayList<QueryFieldMap> {
    private static final long serialVersionUID = 1L;
    private final QueryParametersMap parametersMap = new QueryParametersMap();
    private final Map<FIELDS, QuerySetMap> setMap = new EnumMap<FIELDS, QuerySetMap>(FIELDS.class);

    public QueryParametersMap getParametersMap() {
        return this.parametersMap;
    }

    public QueryTableMap(FilterMap filterMap) {
        filterMap.process();
        for (TableFieldKey fieldKey : filterMap.keySet()) {
            try {
                FilterFieldMap fieldMap = (FilterFieldMap)filterMap.get(fieldKey);
                FIELDS rootField = filterMap.table.map.get((TableFieldKey)fieldKey.root()).field;
                if (rootField.type == FIELDS.TYPES.SET) {
                    QuerySetMap map = this.setMap.get(rootField);
                    if (map == null) {
                        map = new QuerySetMap(filterMap.table, fieldKey);
                        this.setMap.put(rootField, map);
                    }
                    map.add(fieldMap, fieldKey);
                    continue;
                }
                this.add(new QueryFieldMap(filterMap.table, fieldMap, fieldKey, fieldKey.name()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (QuerySetMap querySetMap : this.setMap.values()) {
            if (sb.length() > 0) {
                sb.append(" && ");
            }
            sb.append(querySetMap.toString());
            this.parametersMap.add(querySetMap.getParametersMap());
        }
        for (QueryFieldMap queryFieldMap : this) {
            if (sb.length() > 0) {
                sb.append(" && ");
            }
            sb.append(queryFieldMap.toString());
            this.parametersMap.add(queryFieldMap.getParametersMap());
        }
        return sb.length() == 0 ? null : sb.toString();
    }
}

