/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.query.builder;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import org.projectocolibri.api.database.filter.FilterFieldMap;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.mapper.TableFieldKey;
import org.projectocolibri.api.database.query.builder.QueryFieldMap;
import org.projectocolibri.api.database.query.builder.QueryParametersMap;
import org.projectocolibri.api.database.query.builder.QuerySetTableMap;

public class QuerySetMap
extends ArrayList<QueryFieldMap> {
    private static final long serialVersionUID = 1L;
    private final QueryParametersMap parametersMap = new QueryParametersMap();
    private final Map<FIELDS, QuerySetTableMap> setTableMap = new EnumMap<FIELDS, QuerySetTableMap>(FIELDS.class);
    private final TABLES table;
    private final String varName;
    private final String condition;

    public QueryParametersMap getParametersMap() {
        return this.parametersMap;
    }

    public QuerySetMap(TABLES table, TableFieldKey fieldKey) {
        this.table = table;
        TABLES rootTable = table.map.get((TableFieldKey)fieldKey.root()).field.childTable;
        this.varName = rootTable.varName();
        this.parametersMap.addVariable(rootTable.klass, this.varName);
        this.condition = String.valueOf(fieldKey.root().name()) + ".contains(" + this.varName + ")";
    }

    public void add(FilterFieldMap fieldMap, TableFieldKey fieldKey) {
        if (fieldKey.size() == 3) {
            FIELDS parentField = this.table.map.get((TableFieldKey)fieldKey.parent()).field;
            QuerySetTableMap map = this.setTableMap.get(parentField);
            if (map == null) {
                map = new QuerySetTableMap(this.table, fieldKey);
                this.setTableMap.put(parentField, map);
            }
            map.add(fieldMap, fieldKey);
        } else {
            String fieldName = String.valueOf(this.varName) + "." + fieldKey.field();
            this.add(new QueryFieldMap(this.table, fieldMap, fieldKey, fieldName));
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.condition);
        for (QuerySetTableMap querySetTableMap : this.setTableMap.values()) {
            if (sb.length() > 0) {
                sb.append(" && ");
            }
            sb.append(querySetTableMap.toString());
            this.parametersMap.add(querySetTableMap.getParametersMap());
        }
        for (QueryFieldMap queryFieldMap : this) {
            if (sb.length() > 0) {
                sb.append(" && ");
            }
            sb.append(queryFieldMap.toString());
            this.parametersMap.add(queryFieldMap.getParametersMap());
        }
        return "(" + sb + ")";
    }
}

