/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.query.builder;

import java.util.ArrayList;
import org.dma.java.util.StringList;
import org.projectocolibri.api.database.filter.FilterFieldMap;
import org.projectocolibri.api.database.filter.FilterOperandMap;
import org.projectocolibri.api.database.filter.OPERANDS;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.mapper.TableFieldKey;
import org.projectocolibri.api.database.query.builder.QueryConditionMap;
import org.projectocolibri.api.database.query.builder.QueryParametersMap;

public class QueryFieldMap
extends ArrayList<QueryConditionMap> {
    private static final long serialVersionUID = 1L;
    private final QueryParametersMap parametersMap = new QueryParametersMap();
    private final FilterFieldMap fieldMap;

    public QueryParametersMap getParametersMap() {
        return this.parametersMap;
    }

    public QueryFieldMap(TABLES table, FilterFieldMap fieldMap, TableFieldKey fieldKey, String fieldName) {
        this.fieldMap = fieldMap;
        int count = 0;
        for (FilterOperandMap operand : fieldMap.cloneCopy()) {
            FIELDS field = table.map.get((TableFieldKey)fieldKey).field;
            if (field == FIELDS.entidades_nif || field == FIELDS.entidadesdocumentos_nif || field == FIELDS.entidadesmovimentos_nif) {
                operand.add((Object)OPERANDS.METHODS.COMPACT);
            }
            String parameterName = new StringList(new String[]{"param", fieldKey.name(), String.valueOf(++count)}).concat(".").replace('.', '_');
            this.add(new QueryConditionMap(field.type, operand, fieldName, parameterName));
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        for (QueryConditionMap map : this) {
            if (index > 0) {
                sb.append(" ");
                switch (this.fieldMap.getLogicalOperators(index - 1)) {
                    case AND: {
                        sb.append("&&");
                        break;
                    }
                    case OR: {
                        sb.append("||");
                    }
                }
                sb.append(" ");
            }
            sb.append(map.toString());
            this.parametersMap.add(map.getParametersMap());
            ++index;
        }
        return this.fieldMap.getLogicalOperators().isEmpty() ? sb.toString() : "(" + sb + ")";
    }
}

