/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.dma.java.util.StringList;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.mapper.TableFieldKey;

public class QueryOrdering
extends LinkedHashSet<TableFieldKey> {
    private static final long serialVersionUID = 1L;
    public final DIRECTION direction;

    public QueryOrdering(DIRECTION direction, TableFieldKey ... ordering) {
        this.direction = direction;
        this.addAll(Arrays.asList(ordering));
    }

    QueryOrdering cleanCopy(TABLES table) {
        QueryOrdering ordering = new QueryOrdering(this.direction, new TableFieldKey[0]);
        for (TableFieldKey fieldKey : this) {
            FIELDS rootField = table.map.get((TableFieldKey)fieldKey.root()).field;
            if (rootField.type == FIELDS.TYPES.SET || rootField.format.isVirtual()) continue;
            ordering.add(fieldKey);
        }
        return ordering;
    }

    @Override
    public String toString() {
        return StringList.valueOf((Collection)this).addSuffix(" " + (Object)((Object)this.direction)).concat(",");
    }

    public static enum DIRECTION {
        ASCENDING,
        DESCENDING;

    }
}

