/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.model.persistence;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.jdo.PersistenceManager;
import org.dma.java.math.SIGNUM;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Entidadesdocumentos;
import org.projectocolibri.api.database.model.Entidadesdocumentoslinhas;
import org.projectocolibri.api.database.model.Entidadesmovimentos;

public class EntidadesmovimentosPersistence {
    private final PersistenceManager pm;

    public EntidadesmovimentosPersistence(PersistenceManager pm) {
        this.pm = pm;
    }

    public Collection<Entidadesmovimentos> store(Entidadesdocumentos documento) {
        this.relations(documento, SIGNUM.ONE);
        return documento.getTipodocumento().isMovimentaentidades(0) ? new ArrayList<Entidadesmovimentos>() : Arrays.asList(new Entidadesmovimentos(documento));
    }

    public Collection<Entidadesmovimentos> delete(Entidadesdocumentos documento) {
        this.relations(documento, SIGNUM.MINUS_ONE);
        Entidadesmovimentos movimento = (Entidadesmovimentos)TABLES.entidadesmovimentos.getObjectOrNull(this.pm, Entidadesmovimentos.generateKey(documento.getTipodocumento().getCodigo(), documento.getSeriedocumento().getSerie(), documento.getNumerodocumento()));
        return movimento == null ? new ArrayList<Entidadesmovimentos>() : Arrays.asList(movimento);
    }

    private void relations(Entidadesdocumentos documento, SIGNUM sinal) {
        for (Entidadesdocumentoslinhas linha : documento.getLinhasdocumento()) {
            if (linha.getMovimentoorigem() == null) continue;
            BigDecimal valorjustificado = linha.getLinhaorigem() == null ? linha.getValoriliquidoiva() : linha.getQuantidade().multiply(linha.getLinhaorigem().getPreco());
            Entidadesmovimentos movimentoorigem = (Entidadesmovimentos)TABLES.entidadesmovimentos.getObject(this.pm, linha.getMovimentoorigem().getKey());
            movimentoorigem.addValorjustificado(valorjustificado, sinal);
            this.pm.makePersistent((Object)movimentoorigem);
        }
    }
}

