/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.model.persistence;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import org.dma.java.math.SIGNUM;
import org.dma.java.util.StringUtils;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Artigos;
import org.projectocolibri.api.database.model.Artigoscomposicao;
import org.projectocolibri.api.database.model.Artigosdocumentos;
import org.projectocolibri.api.database.model.Artigosdocumentoslinhas;
import org.projectocolibri.api.database.model.Artigosmovimentos;
import org.projectocolibri.api.database.model.Entidadesdocumentos;
import org.projectocolibri.api.database.model.Entidadesdocumentoslinhas;

public class ArtigosmovimentosPersistence {
    private final PersistenceManager pm;

    public ArtigosmovimentosPersistence(PersistenceManager pm) {
        this.pm = pm;
    }

    public Collection<Artigosmovimentos> store(Artigosdocumentos documento) {
        ArrayList<Artigosmovimentos> col = new ArrayList<Artigosmovimentos>();
        if (!documento.getTipodocumento().isMovimentaartigos(0)) {
            for (Artigosdocumentoslinhas linha : documento.getLinhasdocumento()) {
                if (!linha.hasArtigo()) continue;
                Artigosmovimentos movimento = new Artigosmovimentos(linha);
                col.add(movimento);
                col.addAll(this.producao(movimento));
            }
        }
        return col;
    }

    public Collection<Artigosmovimentos> delete(Artigosdocumentos documento) {
        Query query = TABLES.artigosmovimentos.newQuery(this.pm);
        try {
            query.setFilter(String.valueOf(FIELDS.artigosmovimentos_tipodocumento.name) + "." + FIELDS.documentostipos_codigo.name + "==" + StringUtils.quote((String)documento.getTipodocumento().getCodigo(), (char[])new char[0]) + " && " + FIELDS.artigosmovimentos_seriedocumento.name + "." + FIELDS.documentosseries_serie.name + "==" + StringUtils.quote((String)documento.getSeriedocumento().getSerie(), (char[])new char[0]) + " && " + FIELDS.artigosmovimentos_numerodocumento.name + "==" + documento.getNumerodocumento());
            ArrayList<Artigosmovimentos> arrayList = new ArrayList<Artigosmovimentos>((Collection)query.execute());
            return arrayList;
        }
        finally {
            query.closeAll();
        }
    }

    public Collection<Artigosmovimentos> store(Entidadesdocumentos documento) {
        this.relations(documento, SIGNUM.MINUS_ONE);
        ArrayList<Artigosmovimentos> col = new ArrayList<Artigosmovimentos>();
        if (!documento.getTipodocumento().isMovimentaartigos(0)) {
            for (Entidadesdocumentoslinhas linha : documento.getLinhasdocumento()) {
                if (!linha.hasArtigo()) continue;
                Artigosmovimentos movimento = new Artigosmovimentos(linha);
                col.add(movimento);
                col.addAll(this.producao(movimento));
            }
        }
        return col;
    }

    public Collection<Artigosmovimentos> delete(Entidadesdocumentos documento) {
        this.relations(documento, SIGNUM.ONE);
        Query query = TABLES.artigosmovimentos.newQuery(this.pm);
        try {
            query.setFilter(String.valueOf(FIELDS.artigosmovimentos_tipodocumento.name) + "." + FIELDS.documentostipos_codigo.name + "==" + StringUtils.quote((String)documento.getTipodocumento().getCodigo(), (char[])new char[0]) + " && " + FIELDS.artigosmovimentos_seriedocumento.name + "." + FIELDS.documentosseries_serie.name + "==" + StringUtils.quote((String)documento.getSeriedocumento().getSerie(), (char[])new char[0]) + " && " + FIELDS.artigosmovimentos_numerodocumento.name + "==" + documento.getNumerodocumento());
            ArrayList<Artigosmovimentos> arrayList = new ArrayList<Artigosmovimentos>((Collection)query.execute());
            return arrayList;
        }
        finally {
            query.closeAll();
        }
    }

    private void relations(Entidadesdocumentos documento, SIGNUM sinal) {
        for (Entidadesdocumentoslinhas linha : documento.getLinhasdocumento()) {
            if (linha.getMovimentoorigem2() == null) continue;
            BigDecimal quantidadependente = linha.getQuantidade();
            Artigosmovimentos movimentoorigem = (Artigosmovimentos)TABLES.artigosmovimentos.getObject(this.pm, linha.getMovimentoorigem2().getKey());
            movimentoorigem.addQuantidadependente(quantidadependente, sinal);
            this.pm.makePersistent((Object)movimentoorigem);
        }
    }

    private Collection<Artigosmovimentos> producao(Artigosmovimentos movimento) {
        ArrayList<Artigosmovimentos> col = new ArrayList<Artigosmovimentos>();
        if (!movimento.getTipodocumento().isMovimentaproducao(0)) {
            Artigos artigo = (Artigos)TABLES.artigos.getObject(this.pm, movimento.getArtigo().getCodigo());
            for (Artigoscomposicao linha : artigo.getComposicao()) {
                col.add(movimento.cloneCopy(linha));
            }
        }
        return col;
    }
}

