/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.model.persistence;

import java.math.BigDecimal;
import java.util.Collection;
import javax.jdo.PersistenceManager;
import org.dma.java.math.SIGNUM;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Artigos;
import org.projectocolibri.api.database.model.Artigosdocumentos;
import org.projectocolibri.api.database.model.Artigosmovimentos;
import org.projectocolibri.api.database.model.Entidadesdocumentos;
import org.projectocolibri.api.database.model.Entidadesdocumentoslinhas;

public class ArtigosPersistence {
    private final PersistenceManager pm;

    public ArtigosPersistence(PersistenceManager pm) {
        this.pm = pm;
    }

    public void store(Artigosdocumentos documento, Collection<Artigosmovimentos> col) {
        for (Artigosmovimentos movimento : col) {
            Artigos artigo = movimento.getArtigo();
            artigo.setPrecos(movimento);
            artigo.addAcumulados(movimento.getSaidas(), movimento.getEntradas(), movimento.getTipostock(), SIGNUM.ONE);
            artigo.addExistencias(movimento, SIGNUM.ONE);
        }
    }

    public void delete(Artigosdocumentos documento, Collection<Artigosmovimentos> col) {
        for (Artigosmovimentos movimento : col) {
            Artigos artigo = movimento.getArtigo();
            artigo.addAcumulados(movimento.getSaidas(), movimento.getEntradas(), movimento.getTipostock(), SIGNUM.MINUS_ONE);
            artigo.addExistencias(movimento, SIGNUM.MINUS_ONE);
        }
    }

    public void store(Entidadesdocumentos documento, Collection<Artigosmovimentos> col) {
        this.relations(documento.getLinhasdocumento(), SIGNUM.MINUS_ONE);
        for (Artigosmovimentos movimento : col) {
            Artigos artigo = movimento.getArtigo();
            artigo.setPrecos(movimento);
            artigo.addAcumulados(movimento.getSaidas(), movimento.getEntradas(), movimento.getTipostock(), SIGNUM.ONE);
            artigo.addExistencias(movimento, SIGNUM.ONE);
        }
    }

    public void delete(Entidadesdocumentos documento, Collection<Artigosmovimentos> col) {
        this.relations(documento.getLinhasdocumento(), SIGNUM.ONE);
        for (Artigosmovimentos movimento : col) {
            Artigos artigo = movimento.getArtigo();
            artigo.addAcumulados(movimento.getSaidas(), movimento.getEntradas(), movimento.getTipostock(), SIGNUM.MINUS_ONE);
            artigo.addExistencias(movimento, SIGNUM.MINUS_ONE);
        }
    }

    private void relations(Collection<Entidadesdocumentoslinhas> col, SIGNUM sinal) {
        for (Entidadesdocumentoslinhas linha : col) {
            if (linha.getMovimentoorigem2() == null) continue;
            Artigosmovimentos movimentoorigem = (Artigosmovimentos)TABLES.artigosmovimentos.getObject(this.pm, linha.getMovimentoorigem2().getKey());
            Artigos artigo = movimentoorigem.getArtigo();
            switch (movimentoorigem.getTipodocumento().getMovimentaartigos()) {
                case 1: {
                    artigo.addAcumulados(linha.getQuantidade(), BigDecimal.ZERO, movimentoorigem.getTipostock(), sinal);
                    break;
                }
                case 2: {
                    artigo.addAcumulados(BigDecimal.ZERO, linha.getQuantidade(), movimentoorigem.getTipostock(), sinal);
                    break;
                }
                case 3: {
                    artigo.addAcumulados(linha.getQuantidade(), linha.getQuantidade(), movimentoorigem.getTipostock(), sinal);
                }
            }
        }
    }
}

