/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.model;

import java.util.BitSet;
import javax.jdo.JDODetachedFieldAccessException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.PersistenceManager;
import javax.jdo.identity.IntIdentity;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;
import javax.mail.PasswordAuthentication;
import org.dma.java.email.ServerParameters;
import org.dma.java.util.MessageLine;
import org.dma.java.util.MessageList;
import org.dma.java.util.StringUtils;
import org.dma.java.util.TimeDateUtils;
import org.dma.java.util.VersionNumber;
import org.dma.services.at.proxy.DocumentosServiceHandler;
import org.dma.services.at.proxy.FaturasServiceHandler;
import org.dma.services.at.proxy.SeriesServiceHandler;
import org.dma.services.at.proxy.StockMovementServiceHandler;
import org.dma.services.mb.MultibancoEntity;
import org.dma.services.mb.ifthenpay.IfThenPayEntity;
import org.dma.services.vies.CheckVatHandler;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.IDatabaseModel;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.AbstractModel;
import org.projectocolibri.api.database.model.Armazens;
import org.projectocolibri.api.database.model.Codigosiva;
import org.projectocolibri.api.database.model.Condicoespagamento;
import org.projectocolibri.api.database.model.Contasbancarias;
import org.projectocolibri.api.database.model.Isencoesiva;
import org.projectocolibri.api.database.model.Metodospagamento;
import org.projectocolibri.api.database.model.Moedas;
import org.projectocolibri.api.database.model.Paises;
import org.projectocolibri.api.database.model.Retencoes;
import org.projectocolibri.api.database.model.Unidadesmedida;
import org.projectocolibri.api.database.model.Utilizadores;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.api.services.payment.IPaymentService;
import org.projectocolibri.api.services.payment.IfThenPayService;
import org.projectocolibri.core.CERTIFICATES;

@javax.jdo.annotations.PersistenceCapable
public class Parametros
extends AbstractModel
implements Detachable,
PersistenceCapable {
    private static Parametros instance;
    public static final String[] DATE_PATTERNS;
    public static final int dataregisto_criacao = 0;
    public static final int dataregisto_auxiliar = 1;
    public static final int precocusto_pcm = 0;
    public static final int precocusto_upc = 1;
    public static final int actualizaprecos_naoactualiza = 0;
    public static final int actualizaprecos_precoscusto = 1;
    public static final int actualizaprecos_precoscustovenda = 2;
    public static final int sugestaoprecos_historico = 0;
    public static final int sugestaoprecos_historicogeral = 1;
    public static final int avisafacturasvencidas_naoavisa = 0;
    public static final int avisafacturasvencidas_avisacontinua = 1;
    public static final int avisafacturasvencidas_avisabloqueia = 2;
    public static final int avisalimitecredito_naoavisa = 0;
    public static final int avisalimitecredito_avisacontinua = 1;
    public static final int avisalimitecredito_avisabloqueia = 2;
    public static final int avisastocknegativo_naoavisa = 0;
    public static final int avisastocknegativo_avisacontinua = 1;
    public static final int avisastocknegativo_avisabloqueia = 2;
    public static final int avisastockminimo_naoavisa = 0;
    public static final int avisastockminimo_avisacontinua = 1;
    public static final int avisacomposicao_naoavisa = 0;
    public static final int avisacomposicao_avisacomposicaovazia = 1;
    public static final int avisataxaiva_naoavisa = 0;
    public static final int avisataxaiva_avisataxazero = 1;
    public static final int sendmail_desligado = 0;
    public static final int sendmail_ligado = 1;
    public static final int smtpauthentication_nenhuma = 0;
    public static final int smtpauthentication_password = 1;
    public static final int atwebservice_series = 0;
    public static final int atwebservice_facturas = 1;
    public static final int atwebservice_transporte = 2;
    public static final int atwebservice_facturastransporte = 3;
    public static final int mbprovider_nenhum = 0;
    public static final int mbprovider_generico = 1;
    public static final int mbprovider_ifthenpay = 2;
    public static final int mbidpagamento_numerocliente = 0;
    public static final int mbidpagamento_numerodocumento = 1;
    public static final int mbidpagamento_numeroauxiliar = 2;
    private Integer id;
    private Codigosiva codigoiva;
    private Isencoesiva isencaoiva;
    private Retencoes retencao;
    private Unidadesmedida unidademedida;
    private Condicoespagamento condicaopagamento;
    private Metodospagamento metodopagamento;
    private Paises pais;
    private Moedas moeda;
    private Contasbancarias contabancaria;
    private Armazens armazem;
    private Integer formatodata = 0;
    private Integer dataregisto;
    private Integer decimaisquantidades = 3;
    private Integer decimaisprecos = 6;
    private Integer decimaistotais = 2;
    private Integer precocusto;
    private Integer actualizaprecos;
    private Integer sugestaoprecos;
    private Integer avisafacturasvencidas;
    private Integer avisalimitecredito;
    private Integer avisastocknegativo;
    private Integer avisastockminimo;
    private Integer avisacomposicao;
    private Integer avisataxaiva;
    private Integer sendmail;
    private String smtpserver;
    private String smtpport;
    private Integer smtpsecurity;
    private Integer smtpauthentication;
    private String smtpuser;
    private String smtppassword;
    private String textoemail;
    private Integer mbprovider;
    private String mbentidade;
    private String mbsubentidade;
    private String mbchavebackoffice;
    private Integer mbidpagamento;
    private String atutilizador;
    private String atpassword;
    private Integer atwebservice;
    private String version;
    private Integer mercado;
    private Utilizadores editor;
    protected transient StateManager jdoStateManager;
    protected transient byte jdoFlags;
    protected Object[] jdoDetachedState;
    private static final byte[] jdoFieldFlags;
    private static final Class jdoPersistenceCapableSuperclass;
    private static final Class[] jdoFieldTypes;
    private static final String[] jdoFieldNames;
    private static final int jdoInheritedFieldCount;

    static {
        DATE_PATTERNS = new String[]{String.valueOf(TimeDateUtils.DATE_DAY_PATTERN) + "-" + TimeDateUtils.DATE_MONTH_PATTERN + "-" + TimeDateUtils.DATE_YEAR_PATTERN, String.valueOf(TimeDateUtils.DATE_YEAR_PATTERN) + "-" + TimeDateUtils.DATE_MONTH_PATTERN + "-" + TimeDateUtils.DATE_DAY_PATTERN, String.valueOf(TimeDateUtils.DATE_DAY_PATTERN) + "/" + TimeDateUtils.DATE_MONTH_PATTERN + "/" + TimeDateUtils.DATE_YEAR_PATTERN, String.valueOf(TimeDateUtils.DATE_YEAR_PATTERN) + "/" + TimeDateUtils.DATE_MONTH_PATTERN + "/" + TimeDateUtils.DATE_DAY_PATTERN};
        jdoFieldNames = Parametros.__jdoFieldNamesInit();
        jdoFieldTypes = Parametros.__jdoFieldTypesInit();
        jdoFieldFlags = Parametros.__jdoFieldFlagsInit();
        jdoInheritedFieldCount = Parametros.__jdoGetInheritedFieldCount();
        jdoPersistenceCapableSuperclass = Parametros.__jdoPersistenceCapableSuperclassInit();
        JDOImplHelper.registerClass((Class)Parametros.___jdo$loadClass("org.projectocolibri.api.database.model.Parametros"), (String[])jdoFieldNames, (Class[])jdoFieldTypes, (byte[])jdoFieldFlags, (Class)jdoPersistenceCapableSuperclass, (PersistenceCapable)new Parametros());
    }

    public static Parametros getInstance() {
        if (instance == null) {
            instance = new Parametros();
        }
        return instance;
    }

    private Parametros() {
        super(TABLES.parametros);
    }

    public Parametros(DatabaseManager manager) {
        this(manager, 0);
    }

    private Parametros(DatabaseManager manager, Integer id) {
        super(TABLES.parametros, manager);
        this.id = id;
        this.codigoiva = manager.loadCodigosiva(Colibri.MARKET_TYPE == Colibri.MARKETS.INTERNAL ? "23" : "01");
        this.isencaoiva = manager.loadIsencoesiva();
        this.retencao = manager.loadRetencoes();
        this.unidademedida = manager.loadUnidadesmedida();
        this.condicaopagamento = manager.loadCondicoespagamento();
        this.metodopagamento = manager.loadMetodospagamento();
        this.pais = manager.getEmpresa().getPais();
        this.moeda = manager.loadMoedas();
        this.contabancaria = manager.loadContasbancarias();
        this.armazem = manager.loadArmazens();
        this.dataregisto = 1;
        this.precocusto = 0;
        this.actualizaprecos = 2;
        this.sugestaoprecos = 0;
        this.avisafacturasvencidas = 0;
        this.avisalimitecredito = 0;
        this.avisastocknegativo = 0;
        this.avisastockminimo = 0;
        this.avisacomposicao = 0;
        this.avisataxaiva = 0;
        this.sendmail = 0;
        ServerParameters server = Colibri.CONTROL_SERVER;
        this.smtpserver = server.getHostName();
        this.smtpport = String.valueOf(server.getSmtpPort());
        this.smtpsecurity = server.getSecurity().ordinal();
        this.smtpauthentication = 1;
        this.smtpuser = server.getAuthentication().getUserName();
        this.smtppassword = this.encodeSmtppassword("");
        this.textoemail = "";
        this.mbprovider = 0;
        this.mbentidade = "";
        this.mbsubentidade = "";
        this.mbchavebackoffice = "";
        this.mbidpagamento = manager.getLicenca().contains(String.valueOf(Colibri.AUTOR_LEGAL.nif)) ? 1 : 0;
        this.atutilizador = Utilizadores.USERS.FISCO.user;
        this.atpassword = this.encodeAtpassword(Utilizadores.USERS.FISCO.password);
        this.atwebservice = 0;
        this.setVersion(Colibri.VERSION_NUMBER);
        this.setMercado(Colibri.MARKET_TYPE);
        this.editor = manager.getUtilizador();
    }

    @Override
    public MessageList validate(IDatabaseModel.ACTION action) {
        MessageList error = super.validate(action);
        switch (action) {
            case DELETE: {
                break;
            }
            case STORE: {
                if (!this.isSmtppasswordValid()) {
                    error.add((Object)new MessageLine((Object)LABELS.parametros_node_email).brackets((Object)LABELS.parametros_smtppassword));
                }
                if (!this.isAtutilizadorValid()) {
                    error.add((Object)new MessageLine((Object)LABELS.parametros_node_webservice).brackets((Object)LABELS.parametros_atutilizador));
                }
                if (this.isAtpasswordValid()) break;
                error.add((Object)new MessageLine((Object)LABELS.parametros_node_webservice).brackets((Object)LABELS.parametros_atpassword));
            }
        }
        return error;
    }

    @Override
    public Integer getKey() {
        return Parametros.jdoGetid(this);
    }

    public Integer getId() {
        return Parametros.jdoGetid(this);
    }

    public void setId(Integer id) {
        Integer n = Parametros.jdoGetid(this);
        Integer n2 = id;
        Parametros.jdoSetid(this, n2);
        this.firePropertyChange(FIELDS.parametros_id, (Object)n, (Object)n2);
    }

    public Codigosiva getCodigoiva() {
        return Parametros.jdoGetcodigoiva(this);
    }

    public void setCodigoiva(Codigosiva codigoiva) {
        Codigosiva codigosiva = Parametros.jdoGetcodigoiva(this);
        Codigosiva codigosiva2 = codigoiva;
        Parametros.jdoSetcodigoiva(this, codigosiva2);
        this.firePropertyChange(FIELDS.parametros_codigoiva, (Object)codigosiva, (Object)codigosiva2);
    }

    public boolean isCodigoivaValid() {
        return Parametros.jdoGetcodigoiva(this) != null && Parametros.jdoGetcodigoiva(this).isValid(Parametros.jdoGetisencaoiva(this));
    }

    public Isencoesiva getIsencaoiva() {
        return Parametros.jdoGetisencaoiva(this);
    }

    public void setIsencaoiva(Isencoesiva isencaoiva) {
        Isencoesiva isencoesiva = Parametros.jdoGetisencaoiva(this);
        Isencoesiva isencoesiva2 = isencaoiva;
        Parametros.jdoSetisencaoiva(this, isencoesiva2);
        this.firePropertyChange(FIELDS.parametros_isencaoiva, (Object)isencoesiva, (Object)isencoesiva2);
    }

    public Retencoes getRetencao() {
        return Parametros.jdoGetretencao(this);
    }

    public void setRetencao(Retencoes retencao) {
        Retencoes retencoes = Parametros.jdoGetretencao(this);
        Retencoes retencoes2 = retencao;
        Parametros.jdoSetretencao(this, retencoes2);
        this.firePropertyChange(FIELDS.parametros_retencao, (Object)retencoes, (Object)retencoes2);
    }

    public Unidadesmedida getUnidademedida() {
        return Parametros.jdoGetunidademedida(this);
    }

    public void setUnidademedida(Unidadesmedida unidademedida) {
        Unidadesmedida unidadesmedida = Parametros.jdoGetunidademedida(this);
        Unidadesmedida unidadesmedida2 = unidademedida;
        Parametros.jdoSetunidademedida(this, unidadesmedida2);
        this.firePropertyChange(FIELDS.parametros_unidademedida, (Object)unidadesmedida, (Object)unidadesmedida2);
    }

    public Condicoespagamento getCondicaopagamento() {
        return Parametros.jdoGetcondicaopagamento(this);
    }

    public void setCondicaopagamento(Condicoespagamento condicaopagamento) {
        Condicoespagamento condicoespagamento = Parametros.jdoGetcondicaopagamento(this);
        Condicoespagamento condicoespagamento2 = condicaopagamento;
        Parametros.jdoSetcondicaopagamento(this, condicoespagamento2);
        this.firePropertyChange(FIELDS.parametros_condicaopagamento, (Object)condicoespagamento, (Object)condicoespagamento2);
    }

    public Metodospagamento getMetodopagamento() {
        return Parametros.jdoGetmetodopagamento(this);
    }

    public void setMetodopagamento(Metodospagamento metodopagamento) {
        Metodospagamento metodospagamento = Parametros.jdoGetmetodopagamento(this);
        Metodospagamento metodospagamento2 = metodopagamento;
        Parametros.jdoSetmetodopagamento(this, metodospagamento2);
        this.firePropertyChange(FIELDS.parametros_metodopagamento, (Object)metodospagamento, (Object)metodospagamento2);
    }

    public Paises getPais() {
        return Parametros.jdoGetpais(this);
    }

    public void setPais(Paises pais) {
        Paises paises = Parametros.jdoGetpais(this);
        Paises paises2 = pais;
        Parametros.jdoSetpais(this, paises2);
        this.firePropertyChange(FIELDS.parametros_pais, (Object)paises, (Object)paises2);
    }

    public Moedas getMoeda() {
        return Parametros.jdoGetmoeda(this);
    }

    public void setMoeda(Moedas moeda) {
        Moedas moedas = Parametros.jdoGetmoeda(this);
        Moedas moedas2 = moeda;
        Parametros.jdoSetmoeda(this, moedas2);
        this.firePropertyChange(FIELDS.parametros_moeda, (Object)moedas, (Object)moedas2);
    }

    public Contasbancarias getContabancaria() {
        return Parametros.jdoGetcontabancaria(this);
    }

    public void setContabancaria(Contasbancarias contabancaria) {
        Contasbancarias contasbancarias = Parametros.jdoGetcontabancaria(this);
        Contasbancarias contasbancarias2 = contabancaria;
        Parametros.jdoSetcontabancaria(this, contasbancarias2);
        this.firePropertyChange(FIELDS.parametros_contabancaria, (Object)contasbancarias, (Object)contasbancarias2);
    }

    public Armazens getArmazem() {
        return Parametros.jdoGetarmazem(this);
    }

    public void setArmazem(Armazens armazem) {
        Armazens armazens = Parametros.jdoGetarmazem(this);
        Armazens armazens2 = armazem;
        Parametros.jdoSetarmazem(this, armazens2);
        this.firePropertyChange(FIELDS.parametros_armazem, (Object)armazens, (Object)armazens2);
    }

    public Integer getFormatodata() {
        return Colibri.VERSION_TYPE == Colibri.VERSIONS.SERVER ? 0 : Parametros.jdoGetformatodata(this);
    }

    public String getFormatodataToText() {
        return Parametros.jdoGetformatodata(this) == null ? "" : DATE_PATTERNS[this.getFormatodata()];
    }

    public void setFormatodata(Integer formatodata) {
        Integer n = Parametros.jdoGetformatodata(this);
        Integer n2 = formatodata;
        Parametros.jdoSetformatodata(this, n2);
        this.firePropertyChange(FIELDS.parametros_formatodata, (Object)n, (Object)n2);
    }

    public Integer getDataregisto() {
        return Parametros.jdoGetdataregisto(this);
    }

    public String getDataregistoToText() {
        return Parametros.jdoGetdataregisto(this) == null ? "" : FIELDS.parametros_dataregisto.values[Parametros.jdoGetdataregisto(this)];
    }

    public void setDataregisto(Integer dataregisto) {
        Integer n = Parametros.jdoGetdataregisto(this);
        Integer n2 = dataregisto;
        Parametros.jdoSetdataregisto(this, n2);
        this.firePropertyChange(FIELDS.parametros_dataregisto, (Object)n, (Object)n2);
    }

    public boolean isDataregisto(Integer dataregisto) {
        return Parametros.equals(dataregisto, Parametros.jdoGetdataregisto(this));
    }

    public Integer getDecimaisquantidades() {
        return Parametros.jdoGetdecimaisquantidades(this);
    }

    public String getDecimaisquantidadesToText() {
        return Parametros.jdoGetdecimaisquantidades(this) == null ? "" : Parametros.jdoGetdecimaisquantidades(this).toString();
    }

    public void setDecimaisquantidades(Integer decimaisquantidades) {
        Integer n = Parametros.jdoGetdecimaisquantidades(this);
        Integer n2 = decimaisquantidades;
        Parametros.jdoSetdecimaisquantidades(this, n2);
        this.firePropertyChange(FIELDS.parametros_decimaisquantidades, (Object)n, (Object)n2);
    }

    public boolean isDecimaisquantidadesValid() {
        return Parametros.jdoGetdecimaisquantidades(this) >= 0 && Parametros.jdoGetdecimaisquantidades(this) <= 6;
    }

    public Integer getDecimaisprecos() {
        return Parametros.jdoGetdecimaisprecos(this);
    }

    public String getDecimaisprecosToText() {
        return Parametros.jdoGetdecimaisprecos(this) == null ? "" : Parametros.jdoGetdecimaisprecos(this).toString();
    }

    public void setDecimaisprecos(Integer decimaisprecos) {
        Integer n = Parametros.jdoGetdecimaisprecos(this);
        Integer n2 = decimaisprecos;
        Parametros.jdoSetdecimaisprecos(this, n2);
        this.firePropertyChange(FIELDS.parametros_decimaisprecos, (Object)n, (Object)n2);
    }

    public boolean isDecimaisprecosValid() {
        return Parametros.jdoGetdecimaisprecos(this) >= (Parametros.jdoGetpais(this).isPortugal() ? 2 : 0) && Parametros.jdoGetdecimaisprecos(this) <= 6;
    }

    public Integer getDecimaistotais() {
        return Parametros.jdoGetdecimaistotais(this);
    }

    public String getDecimaistotaisToText() {
        return Parametros.jdoGetdecimaistotais(this) == null ? "" : Parametros.jdoGetdecimaistotais(this).toString();
    }

    public void setDecimaistotais(Integer decimaistotais) {
        Integer n = Parametros.jdoGetdecimaistotais(this);
        Integer n2 = decimaistotais;
        Parametros.jdoSetdecimaistotais(this, n2);
        this.firePropertyChange(FIELDS.parametros_decimaistotais, (Object)n, (Object)n2);
    }

    public boolean isDecimaistotaisValid() {
        return Parametros.jdoGetdecimaistotais(this) >= (Parametros.jdoGetpais(this).isPortugal() ? 2 : 0) && Parametros.jdoGetdecimaistotais(this) <= 2;
    }

    public Integer getPrecocusto() {
        return Parametros.jdoGetprecocusto(this);
    }

    public String getPrecocustoToText() {
        return Parametros.jdoGetprecocusto(this) == null ? "" : FIELDS.parametros_precocusto.values[Parametros.jdoGetprecocusto(this)];
    }

    public void setPrecocusto(Integer precocusto) {
        Integer n = Parametros.jdoGetprecocusto(this);
        Integer n2 = precocusto;
        Parametros.jdoSetprecocusto(this, n2);
        this.firePropertyChange(FIELDS.parametros_precocusto, (Object)n, (Object)n2);
    }

    public boolean isPrecocusto(Integer precocusto) {
        return Parametros.equals(precocusto, Parametros.jdoGetprecocusto(this));
    }

    public Integer getActualizaprecos() {
        return Parametros.jdoGetactualizaprecos(this);
    }

    public String getActualizaprecosToText() {
        return Parametros.jdoGetactualizaprecos(this) == null ? "" : FIELDS.parametros_actualizaprecos.values[Parametros.jdoGetactualizaprecos(this)];
    }

    public void setActualizaprecos(Integer actualizaprecos) {
        Integer n = Parametros.jdoGetactualizaprecos(this);
        Integer n2 = actualizaprecos;
        Parametros.jdoSetactualizaprecos(this, n2);
        this.firePropertyChange(FIELDS.parametros_actualizaprecos, (Object)n, (Object)n2);
    }

    public boolean isActualizaprecos(Integer actualizaprecos) {
        return Parametros.equals(actualizaprecos, Parametros.jdoGetactualizaprecos(this));
    }

    public Integer getSugestaoprecos() {
        return Parametros.jdoGetsugestaoprecos(this);
    }

    public String getSugestaoprecosToText() {
        return Parametros.jdoGetsugestaoprecos(this) == null ? "" : FIELDS.parametros_sugestaoprecos.values[Parametros.jdoGetsugestaoprecos(this)];
    }

    public void setSugestaoprecos(Integer sugestaoprecos) {
        Integer n = Parametros.jdoGetsugestaoprecos(this);
        Integer n2 = sugestaoprecos;
        Parametros.jdoSetsugestaoprecos(this, n2);
        this.firePropertyChange(FIELDS.parametros_sugestaoprecos, (Object)n, (Object)n2);
    }

    public boolean isSugestaoprecos(Integer sugestaoprecos) {
        return Parametros.equals(sugestaoprecos, Parametros.jdoGetsugestaoprecos(this));
    }

    public Integer getAvisafacturasvencidas() {
        return Parametros.jdoGetavisafacturasvencidas(this);
    }

    public String getAvisafacturasvencidasToText() {
        return Parametros.jdoGetavisafacturasvencidas(this) == null ? "" : FIELDS.parametros_avisafacturasvencidas.values[Parametros.jdoGetavisafacturasvencidas(this)];
    }

    public void setAvisafacturasvencidas(Integer avisafacturasvencidas) {
        Integer n = Parametros.jdoGetavisafacturasvencidas(this);
        Integer n2 = avisafacturasvencidas;
        Parametros.jdoSetavisafacturasvencidas(this, n2);
        this.firePropertyChange(FIELDS.parametros_avisafacturasvencidas, (Object)n, (Object)n2);
    }

    public boolean isAvisafacturasvencidas(Integer avisafacturasvencidas) {
        return Parametros.equals(avisafacturasvencidas, Parametros.jdoGetavisafacturasvencidas(this));
    }

    public Integer getAvisalimitecredito() {
        return Parametros.jdoGetavisalimitecredito(this);
    }

    public String getAvisalimitecreditoToText() {
        return Parametros.jdoGetavisalimitecredito(this) == null ? "" : FIELDS.parametros_avisalimitecredito.values[Parametros.jdoGetavisalimitecredito(this)];
    }

    public void setAvisalimitecredito(Integer avisalimitecredito) {
        Integer n = Parametros.jdoGetavisalimitecredito(this);
        Integer n2 = avisalimitecredito;
        Parametros.jdoSetavisalimitecredito(this, n2);
        this.firePropertyChange(FIELDS.parametros_avisalimitecredito, (Object)n, (Object)n2);
    }

    public boolean isAvisalimitecredito(Integer avisalimitecredito) {
        return Parametros.equals(avisalimitecredito, Parametros.jdoGetavisalimitecredito(this));
    }

    public Integer getAvisastocknegativo() {
        return Parametros.jdoGetavisastocknegativo(this);
    }

    public String getAvisastocknegativoToText() {
        return Parametros.jdoGetavisastocknegativo(this) == null ? "" : FIELDS.parametros_avisastocknegativo.values[Parametros.jdoGetavisastocknegativo(this)];
    }

    public void setAvisastocknegativo(Integer avisastocknegativo) {
        Integer n = Parametros.jdoGetavisastocknegativo(this);
        Integer n2 = avisastocknegativo;
        Parametros.jdoSetavisastocknegativo(this, n2);
        this.firePropertyChange(FIELDS.parametros_avisastocknegativo, (Object)n, (Object)n2);
    }

    public boolean isAvisastocknegativo(Integer avisastocknegativo) {
        return Parametros.equals(avisastocknegativo, Parametros.jdoGetavisastocknegativo(this));
    }

    public Integer getAvisastockminimo() {
        return Parametros.jdoGetavisastockminimo(this);
    }

    public String getAvisastockminimoToText() {
        return Parametros.jdoGetavisastockminimo(this) == null ? "" : FIELDS.parametros_avisastockminimo.values[Parametros.jdoGetavisastockminimo(this)];
    }

    public void setAvisastockminimo(Integer avisastockminimo) {
        Integer n = Parametros.jdoGetavisastockminimo(this);
        Integer n2 = avisastockminimo;
        Parametros.jdoSetavisastockminimo(this, n2);
        this.firePropertyChange(FIELDS.parametros_avisastockminimo, (Object)n, (Object)n2);
    }

    public boolean isAvisastockminimo(Integer avisastockminimo) {
        return Parametros.equals(avisastockminimo, Parametros.jdoGetavisastockminimo(this));
    }

    public Integer getAvisacomposicao() {
        return Parametros.jdoGetavisacomposicao(this);
    }

    public String getAvisacomposicaoToText() {
        return Parametros.jdoGetavisacomposicao(this) == null ? "" : FIELDS.parametros_avisacomposicao.values[Parametros.jdoGetavisacomposicao(this)];
    }

    public void setAvisacomposicao(Integer avisacomposicao) {
        Integer n = Parametros.jdoGetavisacomposicao(this);
        Integer n2 = avisacomposicao;
        Parametros.jdoSetavisacomposicao(this, n2);
        this.firePropertyChange(FIELDS.parametros_avisacomposicao, (Object)n, (Object)n2);
    }

    public boolean isAvisacomposicao(Integer avisacomposicao) {
        return Parametros.equals(avisacomposicao, Parametros.jdoGetavisacomposicao(this));
    }

    public Integer getAvisataxaiva() {
        return Parametros.jdoGetavisataxaiva(this);
    }

    public String getAvisataxaivaToText() {
        return Parametros.jdoGetavisataxaiva(this) == null ? "" : FIELDS.parametros_avisataxaiva.values[Parametros.jdoGetavisataxaiva(this)];
    }

    public void setAvisataxaiva(Integer avisataxaiva) {
        Integer n = Parametros.jdoGetavisataxaiva(this);
        Integer n2 = avisataxaiva;
        Parametros.jdoSetavisataxaiva(this, n2);
        this.firePropertyChange(FIELDS.parametros_avisataxaiva, (Object)n, (Object)n2);
    }

    public boolean isAvisataxaiva(Integer avisataxaiva) {
        return Parametros.equals(avisataxaiva, Parametros.jdoGetavisataxaiva(this));
    }

    public Integer getSendmail() {
        return Parametros.jdoGetsendmail(this);
    }

    public String getSendmailToText() {
        return Parametros.jdoGetsendmail(this) == null ? "" : FIELDS.parametros_sendmail.values[Parametros.jdoGetsendmail(this)];
    }

    public void setSendmail(Integer sendmail) {
        Integer n = Parametros.jdoGetsendmail(this);
        Integer n2 = sendmail;
        Parametros.jdoSetsendmail(this, n2);
        this.firePropertyChange(FIELDS.parametros_sendmail, (Object)n, (Object)n2);
    }

    public boolean isSendmail(Integer sendmail) {
        return Parametros.equals(sendmail, Parametros.jdoGetsendmail(this));
    }

    public ServerParameters getMailServer() {
        return new ServerParameters(Parametros.jdoGetsmtpserver(this), this.getSmtpport().intValue(), ServerParameters.SECURITY.get((int)Parametros.jdoGetsmtpsecurity(this)), this.isSmtpauthentication(0) ? null : new PasswordAuthentication(Parametros.jdoGetsmtpuser(this), this.getSmtppassword()));
    }

    public String getSmtpserver() {
        return Parametros.jdoGetsmtpserver(this);
    }

    public String getSmtpserverToText() {
        return Parametros.jdoGetsmtpserver(this) == null ? "" : Parametros.jdoGetsmtpserver(this).toString();
    }

    public void setSmtpserver(String smtpserver) {
        String string = Parametros.jdoGetsmtpserver(this);
        String string2 = smtpserver;
        Parametros.jdoSetsmtpserver(this, string2);
        this.firePropertyChange(FIELDS.parametros_smtpserver, (Object)string, (Object)string2);
    }

    public Integer getSmtpport() {
        return StringUtils.val((String)Parametros.jdoGetsmtpport(this));
    }

    public String getSmtpportToText() {
        return Parametros.jdoGetsmtpport(this) == null ? "" : Parametros.jdoGetsmtpport(this).toString();
    }

    public void setSmtpport(String smtpport) {
        String string = Parametros.jdoGetsmtpport(this);
        String string2 = smtpport;
        Parametros.jdoSetsmtpport(this, string2);
        this.firePropertyChange(FIELDS.parametros_smtpport, (Object)string, (Object)string2);
    }

    public void setSmtpport(Integer smtpport) {
        this.setSmtpport(String.valueOf(smtpport));
    }

    public Integer getSmtpsecurity() {
        return Parametros.jdoGetsmtpsecurity(this);
    }

    public String getSmtpsecurityToText() {
        return Parametros.jdoGetsmtpsecurity(this) == null ? "" : FIELDS.parametros_smtpsecurity.values[Parametros.jdoGetsmtpsecurity(this)];
    }

    public void setSmtpsecurity(Integer smtpsecurity) {
        Integer n = Parametros.jdoGetsmtpsecurity(this);
        Integer n2 = smtpsecurity;
        Parametros.jdoSetsmtpsecurity(this, n2);
        this.firePropertyChange(FIELDS.parametros_smtpsecurity, (Object)n, (Object)n2);
    }

    public boolean isSmtpsecurity(Integer smtpsecurity) {
        return Parametros.equals(smtpsecurity, Parametros.jdoGetsmtpsecurity(this));
    }

    public Integer getSmtpauthentication() {
        return Parametros.jdoGetsmtpauthentication(this);
    }

    public String getSmtpauthenticationToText() {
        return Parametros.jdoGetsmtpauthentication(this) == null ? "" : FIELDS.parametros_smtpauthentication.values[Parametros.jdoGetsmtpauthentication(this)];
    }

    public void setSmtpauthentication(Integer smtpauthentication) {
        Integer n = Parametros.jdoGetsmtpauthentication(this);
        Integer n2 = smtpauthentication;
        Parametros.jdoSetsmtpauthentication(this, n2);
        this.firePropertyChange(FIELDS.parametros_smtpauthentication, (Object)n, (Object)n2);
    }

    public boolean isSmtpauthentication(Integer smtpauthentication) {
        return Parametros.equals(smtpauthentication, Parametros.jdoGetsmtpauthentication(this));
    }

    public String getSmtpuser() {
        return Parametros.jdoGetsmtpuser(this);
    }

    public String getSmtpuserToText() {
        return Parametros.jdoGetsmtpuser(this) == null ? "" : Parametros.jdoGetsmtpuser(this).toString();
    }

    public void setSmtpuser(String smtpuser) {
        String string = Parametros.jdoGetsmtpuser(this);
        String string2 = smtpuser;
        Parametros.jdoSetsmtpuser(this, string2);
        this.firePropertyChange(FIELDS.parametros_smtpuser, (Object)string, (Object)string2);
    }

    public String getSmtppassword() {
        return Colibri.PASSWORD_CIPHER.decode(this.getSmtppasswordToText());
    }

    public String getSmtppasswordToText() {
        return Parametros.jdoGetsmtppassword(this) == null ? "" : Parametros.jdoGetsmtppassword(this).toString();
    }

    public void setSmtppassword(String smtppassword) {
        String string = Parametros.jdoGetsmtppassword(this);
        String string2 = this.encodeSmtppassword(smtppassword);
        Parametros.jdoSetsmtppassword(this, string2);
        this.firePropertyChange(FIELDS.parametros_smtppassword, (Object)string, (Object)string2);
    }

    public boolean isSmtppasswordValid() {
        return Parametros.jdoGetsmtppassword(this) != null;
    }

    private String encodeSmtppassword(String smtppassword) {
        return smtppassword == null ? Parametros.jdoGetsmtppassword(this) : Colibri.PASSWORD_CIPHER.encode(smtppassword);
    }

    public String getTextoemail() {
        return Parametros.jdoGettextoemail(this);
    }

    public String getTextoemailToText() {
        return Parametros.jdoGettextoemail(this) == null ? "" : Parametros.jdoGettextoemail(this).toString();
    }

    public void setTextoemail(String textoemail) {
        String string = Parametros.jdoGettextoemail(this);
        String string2 = textoemail;
        Parametros.jdoSettextoemail(this, string2);
        this.firePropertyChange(FIELDS.parametros_textoemail, (Object)string, (Object)string2);
    }

    public Integer getMbprovider() {
        return Parametros.jdoGetmbprovider(this);
    }

    public String getMbproviderToText() {
        return Parametros.jdoGetmbprovider(this) == null ? "" : FIELDS.parametros_mbprovider.values[Parametros.jdoGetmbprovider(this)];
    }

    public void setMbprovider(Integer mbprovider) {
        Integer n = Parametros.jdoGetmbprovider(this);
        Integer n2 = mbprovider;
        Parametros.jdoSetmbprovider(this, n2);
        this.firePropertyChange(FIELDS.parametros_mbprovider, (Object)n, (Object)n2);
    }

    public boolean isMbprovider(Integer mbprovider) {
        return Parametros.equals(mbprovider, Parametros.jdoGetmbprovider(this));
    }

    public MultibancoEntity getMultibanco() {
        switch (Parametros.jdoGetmbprovider(this)) {
            case 0: {
                break;
            }
            case 1: {
                return new MultibancoEntity(Parametros.jdoGetmbentidade(this));
            }
            case 2: {
                return new IfThenPayEntity(Parametros.jdoGetmbentidade(this), Parametros.jdoGetmbsubentidade(this));
            }
        }
        return null;
    }

    public IPaymentService getPaymentService() {
        switch (Parametros.jdoGetmbprovider(this)) {
            case 1: {
                break;
            }
            case 2: {
                return new IfThenPayService(Parametros.jdoGetmbentidade(this), Parametros.jdoGetmbsubentidade(this), Parametros.jdoGetmbchavebackoffice(this));
            }
        }
        return null;
    }

    public String getMbentidade() {
        return Parametros.jdoGetmbentidade(this);
    }

    public String getMbentidadeToText() {
        return Parametros.jdoGetmbentidade(this) == null ? "" : Parametros.jdoGetmbentidade(this).toString();
    }

    public void setMbentidade(String mbentidade) {
        String string = Parametros.jdoGetmbentidade(this);
        String string2 = mbentidade;
        Parametros.jdoSetmbentidade(this, string2);
        this.firePropertyChange(FIELDS.parametros_mbentidade, (Object)string, (Object)string2);
    }

    public String getMbsubentidade() {
        return Parametros.jdoGetmbsubentidade(this);
    }

    public String getMbsubentidadeToText() {
        return Parametros.jdoGetmbsubentidade(this) == null ? "" : Parametros.jdoGetmbsubentidade(this).toString();
    }

    public void setMbsubentidade(String mbsubentidade) {
        String string = Parametros.jdoGetmbsubentidade(this);
        String string2 = mbsubentidade;
        Parametros.jdoSetmbsubentidade(this, string2);
        this.firePropertyChange(FIELDS.parametros_mbsubentidade, (Object)string, (Object)string2);
    }

    public String getMbchavebackoffice() {
        return Parametros.jdoGetmbchavebackoffice(this);
    }

    public String getMbchavebackofficeToText() {
        return Parametros.jdoGetmbchavebackoffice(this) == null ? "" : Parametros.jdoGetmbchavebackoffice(this).toString();
    }

    public void setMbchavebackoffice(String mbchavebackoffice) {
        String string = Parametros.jdoGetmbchavebackoffice(this);
        String string2 = mbchavebackoffice;
        Parametros.jdoSetmbchavebackoffice(this, string2);
        this.firePropertyChange(FIELDS.parametros_mbchavebackoffice, (Object)string, (Object)string2);
    }

    public Integer getMbidpagamento() {
        return Parametros.jdoGetmbidpagamento(this);
    }

    public String getMbidpagamentoToText() {
        return Parametros.jdoGetmbidpagamento(this) == null ? "" : FIELDS.parametros_mbidpagamento.values[Parametros.jdoGetmbidpagamento(this)];
    }

    public void setMbidpagamento(Integer mbidpagamento) {
        Integer n = Parametros.jdoGetmbidpagamento(this);
        Integer n2 = mbidpagamento;
        Parametros.jdoSetmbidpagamento(this, n2);
        this.firePropertyChange(FIELDS.parametros_mbidpagamento, (Object)n, (Object)n2);
    }

    public boolean isMbidpagamento(Integer mbidpagamento) {
        return Parametros.equals(mbidpagamento, Parametros.jdoGetmbidpagamento(this));
    }

    public String getAtutilizador() {
        return Parametros.jdoGetatutilizador(this);
    }

    public String getAtutilizadorToText() {
        return Parametros.jdoGetatutilizador(this) == null ? "" : Parametros.jdoGetatutilizador(this).toString();
    }

    public void setAtutilizador(String atutilizador) {
        String string = Parametros.jdoGetatutilizador(this);
        String string2 = atutilizador;
        Parametros.jdoSetatutilizador(this, string2);
        this.firePropertyChange(FIELDS.parametros_atutilizador, (Object)string, (Object)string2);
    }

    public boolean isAtutilizadorValid() {
        return FIELDS.parametros_atutilizador.format.isValid(Parametros.jdoGetatutilizador(this)) && (Parametros.jdoGetatutilizador(this).equals(Utilizadores.USERS.FISCO.user) || Parametros.jdoGetatutilizador(this).startsWith(this.manager.getEmpresa().getNifToNumbers()));
    }

    public String getAtpassword() {
        return Colibri.PASSWORD_CIPHER.decode(this.getAtpasswordToText());
    }

    public String getAtpasswordToText() {
        return Parametros.jdoGetatpassword(this) == null ? "" : Parametros.jdoGetatpassword(this).toString();
    }

    public void setAtpassword(String atpassword) {
        String string = Parametros.jdoGetatpassword(this);
        String string2 = this.encodeAtpassword(atpassword);
        Parametros.jdoSetatpassword(this, string2);
        this.firePropertyChange(FIELDS.parametros_atpassword, (Object)string, (Object)string2);
    }

    public boolean isAtpasswordValid() {
        return Parametros.jdoGetatpassword(this) != null;
    }

    private String encodeAtpassword(String atpassword) {
        return atpassword == null ? Parametros.jdoGetatpassword(this) : Colibri.PASSWORD_CIPHER.encode(atpassword);
    }

    public Integer getAtwebservice() {
        return Colibri.VERSION_TYPE == Colibri.VERSIONS.SERVER ? 2 : Parametros.jdoGetatwebservice(this);
    }

    public String getAtwebserviceToText() {
        return Parametros.jdoGetatwebservice(this) == null ? "" : FIELDS.parametros_atwebservice.values[this.getAtwebservice()];
    }

    public void setAtwebservice(Integer atwebservice) {
        Integer n = Parametros.jdoGetatwebservice(this);
        Integer n2 = atwebservice;
        Parametros.jdoSetatwebservice(this, n2);
        this.firePropertyChange(FIELDS.parametros_atwebservice, (Object)n, (Object)n2);
    }

    public boolean isAtwebservice(Integer atwebservice) {
        return Parametros.equals(this.getAtwebservice(), Parametros.jdoGetatwebservice(this));
    }

    public SeriesServiceHandler getSeriesService() {
        return this.manager.getLicenca().isFormacao() ? new SeriesServiceHandler(SeriesServiceHandler.ENDPOINTS.TEST, Utilizadores.USERS.DELTAFIL.user, Utilizadores.USERS.DELTAFIL.password, CERTIFICATES.WEBSERVICE.TEST.cert) : new SeriesServiceHandler(SeriesServiceHandler.ENDPOINTS.PROD, this.getAtutilizador(), this.getAtpassword(), CERTIFICATES.WEBSERVICE.PROD.cert);
    }

    @Deprecated
    public FaturasServiceHandler getFaturasService() {
        return this.manager.getLicenca().isFormacao() ? new FaturasServiceHandler(FaturasServiceHandler.ENDPOINTS.TEST, Utilizadores.USERS.FISCO.user, Utilizadores.USERS.FISCO.password, CERTIFICATES.WEBSERVICE.TEST.cert) : new FaturasServiceHandler(FaturasServiceHandler.ENDPOINTS.PROD, this.getAtutilizador(), this.getAtpassword(), CERTIFICATES.WEBSERVICE.PROD.cert);
    }

    public DocumentosServiceHandler getDocumentosService() {
        return this.manager.getLicenca().isFormacao() ? new DocumentosServiceHandler(DocumentosServiceHandler.ENDPOINTS.TEST, Utilizadores.USERS.FISCO.user, Utilizadores.USERS.FISCO.password, CERTIFICATES.WEBSERVICE.TEST.cert) : new DocumentosServiceHandler(DocumentosServiceHandler.ENDPOINTS.PROD, this.getAtutilizador(), this.getAtpassword(), CERTIFICATES.WEBSERVICE.PROD.cert);
    }

    public StockMovementServiceHandler getStockMovementService() {
        return this.manager.getLicenca().isFormacao() ? new StockMovementServiceHandler(StockMovementServiceHandler.ENDPOINTS.TEST, Utilizadores.USERS.FISCO.user, Utilizadores.USERS.FISCO.password, CERTIFICATES.WEBSERVICE.TEST.cert) : new StockMovementServiceHandler(StockMovementServiceHandler.ENDPOINTS.PROD, this.getAtutilizador(), this.getAtpassword(), CERTIFICATES.WEBSERVICE.PROD.cert);
    }

    public String getVersion() {
        return Parametros.jdoGetversion(this);
    }

    public void setVersion(VersionNumber version) {
        Parametros.jdoSetversion(this, version.toString());
    }

    public Colibri.MARKETS getMercado() {
        try {
            return Colibri.MARKETS.values()[Parametros.jdoGetmercado(this)];
        }
        catch (Exception e) {
            this.setMercado(this.manager.getLicenca().getPaisTitular().equalsIgnoreCase(CheckVatHandler.COUNTRIES.PT.code) ? Colibri.MARKETS.INTERNAL : Colibri.MARKETS.EXTERNAL);
            return this.getMercado();
        }
    }

    private void setMercado(Colibri.MARKETS mercado) {
        Parametros.jdoSetmercado(this, mercado.ordinal());
    }

    public Utilizadores getEditor() {
        return Parametros.jdoGeteditor(this);
    }

    public void setEditor(Utilizadores editor) {
        Parametros.jdoSeteditor(this, editor);
    }

    @Override
    public boolean isEditable(FIELDS field) {
        return !(field == FIELDS.parametros_formatodata && Colibri.VERSION_TYPE == Colibri.VERSIONS.SERVER || field == FIELDS.parametros_decimaisquantidades && Colibri.VERSION_TYPE == Colibri.VERSIONS.SERVER || field == FIELDS.parametros_decimaisprecos && Colibri.VERSION_TYPE == Colibri.VERSIONS.SERVER || field == FIELDS.parametros_decimaistotais && Colibri.VERSION_TYPE == Colibri.VERSIONS.SERVER || field == FIELDS.parametros_atwebservice && Colibri.VERSION_TYPE == Colibri.VERSIONS.SERVER && !this.manager.getUtilizador().isColibri());
    }

    @Override
    public void attach(DatabaseManager manager) {
        manager.attach(new AbstractModel[]{Parametros.jdoGetcodigoiva(this), Parametros.jdoGetisencaoiva(this), Parametros.jdoGetretencao(this), Parametros.jdoGetunidademedida(this), Parametros.jdoGetcondicaopagamento(this), Parametros.jdoGetmetodopagamento(this), Parametros.jdoGetpais(this), Parametros.jdoGetmoeda(this), Parametros.jdoGetcontabancaria(this), Parametros.jdoGetarmazem(this), Parametros.jdoGeteditor(this)});
    }

    public String toString() {
        return String.valueOf(Parametros.jdoGetid(this));
    }

    public void jdoCopyKeyFieldsFromObjectId(PersistenceCapable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof IntIdentity)) {
            throw new ClassCastException("oid is not instanceof javax.jdo.identity.IntIdentity");
        }
        IntIdentity o = (IntIdentity)oid;
        fc.storeObjectField(20, (Object)new Integer(o.getKey()));
    }

    protected void jdoCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof IntIdentity)) {
            throw new ClassCastException("key class is not javax.jdo.identity.IntIdentity or null");
        }
        IntIdentity o = (IntIdentity)oid;
        this.id = new Integer(o.getKey());
    }

    public final void jdoCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final void jdoCopyKeyFieldsToObjectId(PersistenceCapable.ObjectIdFieldSupplier fs, Object object) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final Object jdoGetObjectId() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getObjectId((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[0];
    }

    public final Object jdoGetVersion() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getVersion((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[1];
    }

    protected final void jdoPreSerialize() {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.preSerialize((PersistenceCapable)this);
        }
    }

    public final PersistenceManager jdoGetPersistenceManager() {
        return this.jdoStateManager != null ? this.jdoStateManager.getPersistenceManager((PersistenceCapable)this) : null;
    }

    public final Object jdoGetTransactionalObjectId() {
        return this.jdoStateManager != null ? this.jdoStateManager.getTransactionalObjectId((PersistenceCapable)this) : null;
    }

    public final boolean jdoIsDeleted() {
        return this.jdoStateManager != null ? this.jdoStateManager.isDeleted((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsDirty() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.isDirty((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return false;
        }
        return ((BitSet)this.jdoDetachedState[3]).length() > 0;
    }

    public final boolean jdoIsNew() {
        return this.jdoStateManager != null ? this.jdoStateManager.isNew((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsPersistent() {
        return this.jdoStateManager != null ? this.jdoStateManager.isPersistent((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsTransactional() {
        return this.jdoStateManager != null ? this.jdoStateManager.isTransactional((PersistenceCapable)this) : false;
    }

    public void jdoMakeDirty(String fieldName) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.makeDirty((PersistenceCapable)this, fieldName);
        }
        if (this.jdoIsDetached() && fieldName != null) {
            String fldName = null;
            fldName = fieldName.indexOf(46) >= 0 ? fieldName.substring(fieldName.lastIndexOf(46) + 1) : fieldName;
            int i = 0;
            while (i < jdoFieldNames.length) {
                if (jdoFieldNames[i].equals(fldName)) {
                    if (!((BitSet)this.jdoDetachedState[2]).get(i + jdoInheritedFieldCount)) {
                        throw new JDODetachedFieldAccessException("You have just attempted to access a field/property that hasn't been detached. Please detach it first before performing this operation");
                    }
                    ((BitSet)this.jdoDetachedState[3]).set(i + jdoInheritedFieldCount);
                    return;
                }
                ++i;
            }
        }
    }

    public final Object jdoNewObjectIdInstance() {
        return new IntIdentity(this.getClass(), this.id);
    }

    public final Object jdoNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new IntIdentity(this.getClass(), (Integer)key);
        }
        return new IntIdentity(this.getClass(), (String)key);
    }

    public final void jdoProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void jdoReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.jdoReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void jdoReplaceFlags() {
        if (this.jdoStateManager != null) {
            this.jdoFlags = this.jdoStateManager.replacingFlags((PersistenceCapable)this);
        }
    }

    public final synchronized void jdoReplaceStateManager(StateManager sm) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager = this.jdoStateManager.replacingStateManager((PersistenceCapable)this, sm);
        } else {
            JDOImplHelper.checkAuthorizedStateManager((StateManager)sm);
            this.jdoStateManager = sm;
            this.jdoFlags = 1;
        }
    }

    public final synchronized void jdoReplaceDetachedState() {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        this.jdoDetachedState = this.jdoStateManager.replacingDetachedState((Detachable)this, this.jdoDetachedState);
    }

    public boolean jdoIsDetached() {
        return this.jdoStateManager == null && this.jdoDetachedState != null;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm) {
        Parametros result = new Parametros();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        return result;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm, Object obj) {
        Parametros result = new Parametros();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        result.jdoCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void jdoReplaceField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.actualizaprecos = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 1: {
                this.armazem = (Armazens)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 2: {
                this.atpassword = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 3: {
                this.atutilizador = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 4: {
                this.atwebservice = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 5: {
                this.avisacomposicao = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 6: {
                this.avisafacturasvencidas = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 7: {
                this.avisalimitecredito = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 8: {
                this.avisastockminimo = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 9: {
                this.avisastocknegativo = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 10: {
                this.avisataxaiva = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 11: {
                this.codigoiva = (Codigosiva)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 12: {
                this.condicaopagamento = (Condicoespagamento)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 13: {
                this.contabancaria = (Contasbancarias)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 14: {
                this.dataregisto = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 15: {
                this.decimaisprecos = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 16: {
                this.decimaisquantidades = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 17: {
                this.decimaistotais = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 18: {
                this.editor = (Utilizadores)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 19: {
                this.formatodata = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 20: {
                this.id = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 21: {
                this.isencaoiva = (Isencoesiva)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 22: {
                this.mbchavebackoffice = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 23: {
                this.mbentidade = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 24: {
                this.mbidpagamento = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 25: {
                this.mbprovider = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 26: {
                this.mbsubentidade = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 27: {
                this.mercado = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 28: {
                this.metodopagamento = (Metodospagamento)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 29: {
                this.moeda = (Moedas)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 30: {
                this.pais = (Paises)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 31: {
                this.precocusto = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 32: {
                this.retencao = (Retencoes)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 33: {
                this.sendmail = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 34: {
                this.smtpauthentication = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 35: {
                this.smtppassword = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 36: {
                this.smtpport = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 37: {
                this.smtpsecurity = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 38: {
                this.smtpserver = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 39: {
                this.smtpuser = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 40: {
                this.sugestaoprecos = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 41: {
                this.textoemail = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 42: {
                this.unidademedida = (Unidadesmedida)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 43: {
                this.version = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoProvideField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.actualizaprecos);
                break;
            }
            case 1: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.armazem);
                break;
            }
            case 2: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.atpassword);
                break;
            }
            case 3: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.atutilizador);
                break;
            }
            case 4: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.atwebservice);
                break;
            }
            case 5: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.avisacomposicao);
                break;
            }
            case 6: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.avisafacturasvencidas);
                break;
            }
            case 7: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.avisalimitecredito);
                break;
            }
            case 8: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.avisastockminimo);
                break;
            }
            case 9: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.avisastocknegativo);
                break;
            }
            case 10: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.avisataxaiva);
                break;
            }
            case 11: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.codigoiva);
                break;
            }
            case 12: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.condicaopagamento);
                break;
            }
            case 13: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.contabancaria);
                break;
            }
            case 14: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.dataregisto);
                break;
            }
            case 15: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.decimaisprecos);
                break;
            }
            case 16: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.decimaisquantidades);
                break;
            }
            case 17: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.decimaistotais);
                break;
            }
            case 18: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.editor);
                break;
            }
            case 19: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.formatodata);
                break;
            }
            case 20: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.id);
                break;
            }
            case 21: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.isencaoiva);
                break;
            }
            case 22: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.mbchavebackoffice);
                break;
            }
            case 23: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.mbentidade);
                break;
            }
            case 24: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.mbidpagamento);
                break;
            }
            case 25: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.mbprovider);
                break;
            }
            case 26: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.mbsubentidade);
                break;
            }
            case 27: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.mercado);
                break;
            }
            case 28: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.metodopagamento);
                break;
            }
            case 29: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.moeda);
                break;
            }
            case 30: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.pais);
                break;
            }
            case 31: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.precocusto);
                break;
            }
            case 32: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.retencao);
                break;
            }
            case 33: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.sendmail);
                break;
            }
            case 34: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.smtpauthentication);
                break;
            }
            case 35: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.smtppassword);
                break;
            }
            case 36: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.smtpport);
                break;
            }
            case 37: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.smtpsecurity);
                break;
            }
            case 38: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.smtpserver);
                break;
            }
            case 39: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.smtpuser);
                break;
            }
            case 40: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.sugestaoprecos);
                break;
            }
            case 41: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.textoemail);
                break;
            }
            case 42: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.unidademedida);
                break;
            }
            case 43: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.version);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void jdoCopyField(Parametros obj, int index) {
        switch (index) {
            case 0: {
                this.actualizaprecos = obj.actualizaprecos;
                break;
            }
            case 1: {
                this.armazem = obj.armazem;
                break;
            }
            case 2: {
                this.atpassword = obj.atpassword;
                break;
            }
            case 3: {
                this.atutilizador = obj.atutilizador;
                break;
            }
            case 4: {
                this.atwebservice = obj.atwebservice;
                break;
            }
            case 5: {
                this.avisacomposicao = obj.avisacomposicao;
                break;
            }
            case 6: {
                this.avisafacturasvencidas = obj.avisafacturasvencidas;
                break;
            }
            case 7: {
                this.avisalimitecredito = obj.avisalimitecredito;
                break;
            }
            case 8: {
                this.avisastockminimo = obj.avisastockminimo;
                break;
            }
            case 9: {
                this.avisastocknegativo = obj.avisastocknegativo;
                break;
            }
            case 10: {
                this.avisataxaiva = obj.avisataxaiva;
                break;
            }
            case 11: {
                this.codigoiva = obj.codigoiva;
                break;
            }
            case 12: {
                this.condicaopagamento = obj.condicaopagamento;
                break;
            }
            case 13: {
                this.contabancaria = obj.contabancaria;
                break;
            }
            case 14: {
                this.dataregisto = obj.dataregisto;
                break;
            }
            case 15: {
                this.decimaisprecos = obj.decimaisprecos;
                break;
            }
            case 16: {
                this.decimaisquantidades = obj.decimaisquantidades;
                break;
            }
            case 17: {
                this.decimaistotais = obj.decimaistotais;
                break;
            }
            case 18: {
                this.editor = obj.editor;
                break;
            }
            case 19: {
                this.formatodata = obj.formatodata;
                break;
            }
            case 20: {
                this.id = obj.id;
                break;
            }
            case 21: {
                this.isencaoiva = obj.isencaoiva;
                break;
            }
            case 22: {
                this.mbchavebackoffice = obj.mbchavebackoffice;
                break;
            }
            case 23: {
                this.mbentidade = obj.mbentidade;
                break;
            }
            case 24: {
                this.mbidpagamento = obj.mbidpagamento;
                break;
            }
            case 25: {
                this.mbprovider = obj.mbprovider;
                break;
            }
            case 26: {
                this.mbsubentidade = obj.mbsubentidade;
                break;
            }
            case 27: {
                this.mercado = obj.mercado;
                break;
            }
            case 28: {
                this.metodopagamento = obj.metodopagamento;
                break;
            }
            case 29: {
                this.moeda = obj.moeda;
                break;
            }
            case 30: {
                this.pais = obj.pais;
                break;
            }
            case 31: {
                this.precocusto = obj.precocusto;
                break;
            }
            case 32: {
                this.retencao = obj.retencao;
                break;
            }
            case 33: {
                this.sendmail = obj.sendmail;
                break;
            }
            case 34: {
                this.smtpauthentication = obj.smtpauthentication;
                break;
            }
            case 35: {
                this.smtppassword = obj.smtppassword;
                break;
            }
            case 36: {
                this.smtpport = obj.smtpport;
                break;
            }
            case 37: {
                this.smtpsecurity = obj.smtpsecurity;
                break;
            }
            case 38: {
                this.smtpserver = obj.smtpserver;
                break;
            }
            case 39: {
                this.smtpuser = obj.smtpuser;
                break;
            }
            case 40: {
                this.sugestaoprecos = obj.sugestaoprecos;
                break;
            }
            case 41: {
                this.textoemail = obj.textoemail;
                break;
            }
            case 42: {
                this.unidademedida = obj.unidademedida;
                break;
            }
            case 43: {
                this.version = obj.version;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoCopyFields(Object obj, int[] indices) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof Parametros)) {
            throw new IllegalArgumentException("object is not an object of type org.projectocolibri.api.database.model.Parametros");
        }
        Parametros other = (Parametros)obj;
        if (this.jdoStateManager != other.jdoStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __jdoFieldNamesInit() {
        return new String[]{"actualizaprecos", "armazem", "atpassword", "atutilizador", "atwebservice", "avisacomposicao", "avisafacturasvencidas", "avisalimitecredito", "avisastockminimo", "avisastocknegativo", "avisataxaiva", "codigoiva", "condicaopagamento", "contabancaria", "dataregisto", "decimaisprecos", "decimaisquantidades", "decimaistotais", "editor", "formatodata", "id", "isencaoiva", "mbchavebackoffice", "mbentidade", "mbidpagamento", "mbprovider", "mbsubentidade", "mercado", "metodopagamento", "moeda", "pais", "precocusto", "retencao", "sendmail", "smtpauthentication", "smtppassword", "smtpport", "smtpsecurity", "smtpserver", "smtpuser", "sugestaoprecos", "textoemail", "unidademedida", "version"};
    }

    private static final Class[] __jdoFieldTypesInit() {
        return new Class[]{Parametros.___jdo$loadClass("java.lang.Integer"), Parametros.___jdo$loadClass("org.projectocolibri.api.database.model.Armazens"), Parametros.___jdo$loadClass("java.lang.String"), Parametros.___jdo$loadClass("java.lang.String"), Parametros.___jdo$loadClass("java.lang.Integer"), Parametros.___jdo$loadClass("java.lang.Integer"), Parametros.___jdo$loadClass("java.lang.Integer"), Parametros.___jdo$loadClass("java.lang.Integer"), Parametros.___jdo$loadClass("java.lang.Integer"), Parametros.___jdo$loadClass("java.lang.Integer"), Parametros.___jdo$loadClass("java.lang.Integer"), Parametros.___jdo$loadClass("org.projectocolibri.api.database.model.Codigosiva"), Parametros.___jdo$loadClass("org.projectocolibri.api.database.model.Condicoespagamento"), Parametros.___jdo$loadClass("org.projectocolibri.api.database.model.Contasbancarias"), Parametros.___jdo$loadClass("java.lang.Integer"), Parametros.___jdo$loadClass("java.lang.Integer"), Parametros.___jdo$loadClass("java.lang.Integer"), Parametros.___jdo$loadClass("java.lang.Integer"), Parametros.___jdo$loadClass("org.projectocolibri.api.database.model.Utilizadores"), Parametros.___jdo$loadClass("java.lang.Integer"), Parametros.___jdo$loadClass("java.lang.Integer"), Parametros.___jdo$loadClass("org.projectocolibri.api.database.model.Isencoesiva"), Parametros.___jdo$loadClass("java.lang.String"), Parametros.___jdo$loadClass("java.lang.String"), Parametros.___jdo$loadClass("java.lang.Integer"), Parametros.___jdo$loadClass("java.lang.Integer"), Parametros.___jdo$loadClass("java.lang.String"), Parametros.___jdo$loadClass("java.lang.Integer"), Parametros.___jdo$loadClass("org.projectocolibri.api.database.model.Metodospagamento"), Parametros.___jdo$loadClass("org.projectocolibri.api.database.model.Moedas"), Parametros.___jdo$loadClass("org.projectocolibri.api.database.model.Paises"), Parametros.___jdo$loadClass("java.lang.Integer"), Parametros.___jdo$loadClass("org.projectocolibri.api.database.model.Retencoes"), Parametros.___jdo$loadClass("java.lang.Integer"), Parametros.___jdo$loadClass("java.lang.Integer"), Parametros.___jdo$loadClass("java.lang.String"), Parametros.___jdo$loadClass("java.lang.String"), Parametros.___jdo$loadClass("java.lang.Integer"), Parametros.___jdo$loadClass("java.lang.String"), Parametros.___jdo$loadClass("java.lang.String"), Parametros.___jdo$loadClass("java.lang.Integer"), Parametros.___jdo$loadClass("java.lang.String"), Parametros.___jdo$loadClass("org.projectocolibri.api.database.model.Unidadesmedida"), Parametros.___jdo$loadClass("java.lang.String")};
    }

    private static final byte[] __jdoFieldFlagsInit() {
        return new byte[]{26, 10, 26, 26, 26, 26, 26, 26, 26, 26, 26, 10, 10, 10, 26, 26, 26, 26, 26, 26, 24, 10, 26, 26, 26, 26, 26, 26, 10, 10, 10, 26, 10, 26, 26, 26, 26, 26, 26, 26, 26, 26, 10, 26};
    }

    protected static int __jdoGetInheritedFieldCount() {
        return 0;
    }

    protected static int jdoGetManagedFieldCount() {
        return 44;
    }

    private static Class __jdoPersistenceCapableSuperclassInit() {
        return null;
    }

    public static Class ___jdo$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object jdoSuperClone() throws CloneNotSupportedException {
        Parametros o = (Parametros)super.clone();
        o.jdoFlags = 0;
        o.jdoStateManager = null;
        return o;
    }

    private static Integer jdoGetactualizaprecos(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 0)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 0, (Object)objPC.actualizaprecos);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(0) && !((BitSet)objPC.jdoDetachedState[3]).get(0)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"actualizaprecos\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.actualizaprecos;
    }

    private static void jdoSetactualizaprecos(Parametros objPC, Integer val) {
        if (objPC.jdoStateManager == null) {
            objPC.actualizaprecos = val;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 0, (Object)objPC.actualizaprecos, (Object)val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(0);
        }
    }

    private static Armazens jdoGetarmazem(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 1)) {
            return (Armazens)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 1, (Object)objPC.armazem);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(1) && !((BitSet)objPC.jdoDetachedState[3]).get(1)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"armazem\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.armazem;
    }

    private static void jdoSetarmazem(Parametros objPC, Armazens val) {
        if (objPC.jdoStateManager == null) {
            objPC.armazem = val;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 1, (Object)objPC.armazem, (Object)val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(1);
        }
    }

    private static String jdoGetatpassword(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 2)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 2, objPC.atpassword);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(2) && !((BitSet)objPC.jdoDetachedState[3]).get(2)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"atpassword\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.atpassword;
    }

    private static void jdoSetatpassword(Parametros objPC, String val) {
        if (objPC.jdoStateManager == null) {
            objPC.atpassword = val;
        } else {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 2, objPC.atpassword, val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(2);
        }
    }

    private static String jdoGetatutilizador(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 3)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 3, objPC.atutilizador);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(3) && !((BitSet)objPC.jdoDetachedState[3]).get(3)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"atutilizador\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.atutilizador;
    }

    private static void jdoSetatutilizador(Parametros objPC, String val) {
        if (objPC.jdoStateManager == null) {
            objPC.atutilizador = val;
        } else {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 3, objPC.atutilizador, val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(3);
        }
    }

    private static Integer jdoGetatwebservice(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 4)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 4, (Object)objPC.atwebservice);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(4) && !((BitSet)objPC.jdoDetachedState[3]).get(4)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"atwebservice\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.atwebservice;
    }

    private static void jdoSetatwebservice(Parametros objPC, Integer val) {
        if (objPC.jdoStateManager == null) {
            objPC.atwebservice = val;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 4, (Object)objPC.atwebservice, (Object)val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(4);
        }
    }

    private static Integer jdoGetavisacomposicao(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 5)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 5, (Object)objPC.avisacomposicao);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(5) && !((BitSet)objPC.jdoDetachedState[3]).get(5)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"avisacomposicao\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.avisacomposicao;
    }

    private static void jdoSetavisacomposicao(Parametros objPC, Integer val) {
        if (objPC.jdoStateManager == null) {
            objPC.avisacomposicao = val;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 5, (Object)objPC.avisacomposicao, (Object)val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(5);
        }
    }

    private static Integer jdoGetavisafacturasvencidas(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 6)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 6, (Object)objPC.avisafacturasvencidas);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(6) && !((BitSet)objPC.jdoDetachedState[3]).get(6)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"avisafacturasvencidas\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.avisafacturasvencidas;
    }

    private static void jdoSetavisafacturasvencidas(Parametros objPC, Integer val) {
        if (objPC.jdoStateManager == null) {
            objPC.avisafacturasvencidas = val;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 6, (Object)objPC.avisafacturasvencidas, (Object)val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(6);
        }
    }

    private static Integer jdoGetavisalimitecredito(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 7)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 7, (Object)objPC.avisalimitecredito);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(7) && !((BitSet)objPC.jdoDetachedState[3]).get(7)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"avisalimitecredito\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.avisalimitecredito;
    }

    private static void jdoSetavisalimitecredito(Parametros objPC, Integer val) {
        if (objPC.jdoStateManager == null) {
            objPC.avisalimitecredito = val;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 7, (Object)objPC.avisalimitecredito, (Object)val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(7);
        }
    }

    private static Integer jdoGetavisastockminimo(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 8)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 8, (Object)objPC.avisastockminimo);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(8) && !((BitSet)objPC.jdoDetachedState[3]).get(8)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"avisastockminimo\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.avisastockminimo;
    }

    private static void jdoSetavisastockminimo(Parametros objPC, Integer val) {
        if (objPC.jdoStateManager == null) {
            objPC.avisastockminimo = val;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 8, (Object)objPC.avisastockminimo, (Object)val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(8);
        }
    }

    private static Integer jdoGetavisastocknegativo(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 9)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 9, (Object)objPC.avisastocknegativo);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(9) && !((BitSet)objPC.jdoDetachedState[3]).get(9)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"avisastocknegativo\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.avisastocknegativo;
    }

    private static void jdoSetavisastocknegativo(Parametros objPC, Integer val) {
        if (objPC.jdoStateManager == null) {
            objPC.avisastocknegativo = val;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 9, (Object)objPC.avisastocknegativo, (Object)val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(9);
        }
    }

    private static Integer jdoGetavisataxaiva(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 10)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 10, (Object)objPC.avisataxaiva);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(10) && !((BitSet)objPC.jdoDetachedState[3]).get(10)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"avisataxaiva\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.avisataxaiva;
    }

    private static void jdoSetavisataxaiva(Parametros objPC, Integer val) {
        if (objPC.jdoStateManager == null) {
            objPC.avisataxaiva = val;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 10, (Object)objPC.avisataxaiva, (Object)val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(10);
        }
    }

    private static Codigosiva jdoGetcodigoiva(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 11)) {
            return (Codigosiva)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 11, (Object)objPC.codigoiva);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(11) && !((BitSet)objPC.jdoDetachedState[3]).get(11)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"codigoiva\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.codigoiva;
    }

    private static void jdoSetcodigoiva(Parametros objPC, Codigosiva val) {
        if (objPC.jdoStateManager == null) {
            objPC.codigoiva = val;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 11, (Object)objPC.codigoiva, (Object)val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(11);
        }
    }

    private static Condicoespagamento jdoGetcondicaopagamento(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 12)) {
            return (Condicoespagamento)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 12, (Object)objPC.condicaopagamento);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(12) && !((BitSet)objPC.jdoDetachedState[3]).get(12)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"condicaopagamento\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.condicaopagamento;
    }

    private static void jdoSetcondicaopagamento(Parametros objPC, Condicoespagamento val) {
        if (objPC.jdoStateManager == null) {
            objPC.condicaopagamento = val;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 12, (Object)objPC.condicaopagamento, (Object)val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(12);
        }
    }

    private static Contasbancarias jdoGetcontabancaria(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 13)) {
            return (Contasbancarias)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 13, (Object)objPC.contabancaria);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(13) && !((BitSet)objPC.jdoDetachedState[3]).get(13)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"contabancaria\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.contabancaria;
    }

    private static void jdoSetcontabancaria(Parametros objPC, Contasbancarias val) {
        if (objPC.jdoStateManager == null) {
            objPC.contabancaria = val;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 13, (Object)objPC.contabancaria, (Object)val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(13);
        }
    }

    private static Integer jdoGetdataregisto(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 14)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 14, (Object)objPC.dataregisto);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(14) && !((BitSet)objPC.jdoDetachedState[3]).get(14)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"dataregisto\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.dataregisto;
    }

    private static void jdoSetdataregisto(Parametros objPC, Integer val) {
        if (objPC.jdoStateManager == null) {
            objPC.dataregisto = val;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 14, (Object)objPC.dataregisto, (Object)val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(14);
        }
    }

    private static Integer jdoGetdecimaisprecos(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 15)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 15, (Object)objPC.decimaisprecos);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(15) && !((BitSet)objPC.jdoDetachedState[3]).get(15)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"decimaisprecos\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.decimaisprecos;
    }

    private static void jdoSetdecimaisprecos(Parametros objPC, Integer val) {
        if (objPC.jdoStateManager == null) {
            objPC.decimaisprecos = val;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 15, (Object)objPC.decimaisprecos, (Object)val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(15);
        }
    }

    private static Integer jdoGetdecimaisquantidades(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 16)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 16, (Object)objPC.decimaisquantidades);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(16) && !((BitSet)objPC.jdoDetachedState[3]).get(16)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"decimaisquantidades\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.decimaisquantidades;
    }

    private static void jdoSetdecimaisquantidades(Parametros objPC, Integer val) {
        if (objPC.jdoStateManager == null) {
            objPC.decimaisquantidades = val;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 16, (Object)objPC.decimaisquantidades, (Object)val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(16);
        }
    }

    private static Integer jdoGetdecimaistotais(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 17)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 17, (Object)objPC.decimaistotais);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(17) && !((BitSet)objPC.jdoDetachedState[3]).get(17)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"decimaistotais\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.decimaistotais;
    }

    private static void jdoSetdecimaistotais(Parametros objPC, Integer val) {
        if (objPC.jdoStateManager == null) {
            objPC.decimaistotais = val;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 17, (Object)objPC.decimaistotais, (Object)val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(17);
        }
    }

    private static Utilizadores jdoGeteditor(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 18)) {
            return (Utilizadores)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 18, (Object)objPC.editor);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(18) && !((BitSet)objPC.jdoDetachedState[3]).get(18)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"editor\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.editor;
    }

    private static void jdoSeteditor(Parametros objPC, Utilizadores val) {
        if (objPC.jdoStateManager == null) {
            objPC.editor = val;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 18, (Object)objPC.editor, (Object)val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(18);
        }
    }

    private static Integer jdoGetformatodata(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 19)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 19, (Object)objPC.formatodata);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(19) && !((BitSet)objPC.jdoDetachedState[3]).get(19)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"formatodata\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.formatodata;
    }

    private static void jdoSetformatodata(Parametros objPC, Integer val) {
        if (objPC.jdoStateManager == null) {
            objPC.formatodata = val;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 19, (Object)objPC.formatodata, (Object)val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(19);
        }
    }

    private static Integer jdoGetid(Parametros objPC) {
        return objPC.id;
    }

    private static void jdoSetid(Parametros objPC, Integer val) {
        if (objPC.jdoStateManager == null) {
            objPC.id = val;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 20, (Object)objPC.id, (Object)val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(20);
        }
    }

    private static Isencoesiva jdoGetisencaoiva(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 21)) {
            return (Isencoesiva)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 21, (Object)objPC.isencaoiva);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(21) && !((BitSet)objPC.jdoDetachedState[3]).get(21)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"isencaoiva\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.isencaoiva;
    }

    private static void jdoSetisencaoiva(Parametros objPC, Isencoesiva val) {
        if (objPC.jdoStateManager == null) {
            objPC.isencaoiva = val;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 21, (Object)objPC.isencaoiva, (Object)val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(21);
        }
    }

    private static String jdoGetmbchavebackoffice(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 22)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 22, objPC.mbchavebackoffice);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(22) && !((BitSet)objPC.jdoDetachedState[3]).get(22)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"mbchavebackoffice\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.mbchavebackoffice;
    }

    private static void jdoSetmbchavebackoffice(Parametros objPC, String val) {
        if (objPC.jdoStateManager == null) {
            objPC.mbchavebackoffice = val;
        } else {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 22, objPC.mbchavebackoffice, val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(22);
        }
    }

    private static String jdoGetmbentidade(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 23)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 23, objPC.mbentidade);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(23) && !((BitSet)objPC.jdoDetachedState[3]).get(23)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"mbentidade\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.mbentidade;
    }

    private static void jdoSetmbentidade(Parametros objPC, String val) {
        if (objPC.jdoStateManager == null) {
            objPC.mbentidade = val;
        } else {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 23, objPC.mbentidade, val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(23);
        }
    }

    private static Integer jdoGetmbidpagamento(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 24)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 24, (Object)objPC.mbidpagamento);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(24) && !((BitSet)objPC.jdoDetachedState[3]).get(24)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"mbidpagamento\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.mbidpagamento;
    }

    private static void jdoSetmbidpagamento(Parametros objPC, Integer val) {
        if (objPC.jdoStateManager == null) {
            objPC.mbidpagamento = val;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 24, (Object)objPC.mbidpagamento, (Object)val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(24);
        }
    }

    private static Integer jdoGetmbprovider(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 25)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 25, (Object)objPC.mbprovider);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(25) && !((BitSet)objPC.jdoDetachedState[3]).get(25)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"mbprovider\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.mbprovider;
    }

    private static void jdoSetmbprovider(Parametros objPC, Integer val) {
        if (objPC.jdoStateManager == null) {
            objPC.mbprovider = val;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 25, (Object)objPC.mbprovider, (Object)val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(25);
        }
    }

    private static String jdoGetmbsubentidade(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 26)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 26, objPC.mbsubentidade);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(26) && !((BitSet)objPC.jdoDetachedState[3]).get(26)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"mbsubentidade\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.mbsubentidade;
    }

    private static void jdoSetmbsubentidade(Parametros objPC, String val) {
        if (objPC.jdoStateManager == null) {
            objPC.mbsubentidade = val;
        } else {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 26, objPC.mbsubentidade, val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(26);
        }
    }

    private static Integer jdoGetmercado(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 27)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 27, (Object)objPC.mercado);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(27) && !((BitSet)objPC.jdoDetachedState[3]).get(27)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"mercado\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.mercado;
    }

    private static void jdoSetmercado(Parametros objPC, Integer val) {
        if (objPC.jdoStateManager == null) {
            objPC.mercado = val;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 27, (Object)objPC.mercado, (Object)val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(27);
        }
    }

    private static Metodospagamento jdoGetmetodopagamento(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 28)) {
            return (Metodospagamento)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 28, (Object)objPC.metodopagamento);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(28) && !((BitSet)objPC.jdoDetachedState[3]).get(28)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"metodopagamento\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.metodopagamento;
    }

    private static void jdoSetmetodopagamento(Parametros objPC, Metodospagamento val) {
        if (objPC.jdoStateManager == null) {
            objPC.metodopagamento = val;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 28, (Object)objPC.metodopagamento, (Object)val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(28);
        }
    }

    private static Moedas jdoGetmoeda(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 29)) {
            return (Moedas)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 29, (Object)objPC.moeda);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(29) && !((BitSet)objPC.jdoDetachedState[3]).get(29)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"moeda\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.moeda;
    }

    private static void jdoSetmoeda(Parametros objPC, Moedas val) {
        if (objPC.jdoStateManager == null) {
            objPC.moeda = val;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 29, (Object)objPC.moeda, (Object)val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(29);
        }
    }

    private static Paises jdoGetpais(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 30)) {
            return (Paises)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 30, (Object)objPC.pais);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(30) && !((BitSet)objPC.jdoDetachedState[3]).get(30)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"pais\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.pais;
    }

    private static void jdoSetpais(Parametros objPC, Paises val) {
        if (objPC.jdoStateManager == null) {
            objPC.pais = val;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 30, (Object)objPC.pais, (Object)val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(30);
        }
    }

    private static Integer jdoGetprecocusto(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 31)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 31, (Object)objPC.precocusto);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(31) && !((BitSet)objPC.jdoDetachedState[3]).get(31)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"precocusto\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.precocusto;
    }

    private static void jdoSetprecocusto(Parametros objPC, Integer val) {
        if (objPC.jdoStateManager == null) {
            objPC.precocusto = val;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 31, (Object)objPC.precocusto, (Object)val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(31);
        }
    }

    private static Retencoes jdoGetretencao(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 32)) {
            return (Retencoes)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 32, (Object)objPC.retencao);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(32) && !((BitSet)objPC.jdoDetachedState[3]).get(32)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"retencao\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.retencao;
    }

    private static void jdoSetretencao(Parametros objPC, Retencoes val) {
        if (objPC.jdoStateManager == null) {
            objPC.retencao = val;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 32, (Object)objPC.retencao, (Object)val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(32);
        }
    }

    private static Integer jdoGetsendmail(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 33)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 33, (Object)objPC.sendmail);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(33) && !((BitSet)objPC.jdoDetachedState[3]).get(33)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"sendmail\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.sendmail;
    }

    private static void jdoSetsendmail(Parametros objPC, Integer val) {
        if (objPC.jdoStateManager == null) {
            objPC.sendmail = val;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 33, (Object)objPC.sendmail, (Object)val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(33);
        }
    }

    private static Integer jdoGetsmtpauthentication(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 34)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 34, (Object)objPC.smtpauthentication);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(34) && !((BitSet)objPC.jdoDetachedState[3]).get(34)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"smtpauthentication\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.smtpauthentication;
    }

    private static void jdoSetsmtpauthentication(Parametros objPC, Integer val) {
        if (objPC.jdoStateManager == null) {
            objPC.smtpauthentication = val;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 34, (Object)objPC.smtpauthentication, (Object)val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(34);
        }
    }

    private static String jdoGetsmtppassword(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 35)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 35, objPC.smtppassword);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(35) && !((BitSet)objPC.jdoDetachedState[3]).get(35)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"smtppassword\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.smtppassword;
    }

    private static void jdoSetsmtppassword(Parametros objPC, String val) {
        if (objPC.jdoStateManager == null) {
            objPC.smtppassword = val;
        } else {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 35, objPC.smtppassword, val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(35);
        }
    }

    private static String jdoGetsmtpport(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 36)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 36, objPC.smtpport);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(36) && !((BitSet)objPC.jdoDetachedState[3]).get(36)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"smtpport\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.smtpport;
    }

    private static void jdoSetsmtpport(Parametros objPC, String val) {
        if (objPC.jdoStateManager == null) {
            objPC.smtpport = val;
        } else {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 36, objPC.smtpport, val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(36);
        }
    }

    private static Integer jdoGetsmtpsecurity(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 37)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 37, (Object)objPC.smtpsecurity);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(37) && !((BitSet)objPC.jdoDetachedState[3]).get(37)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"smtpsecurity\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.smtpsecurity;
    }

    private static void jdoSetsmtpsecurity(Parametros objPC, Integer val) {
        if (objPC.jdoStateManager == null) {
            objPC.smtpsecurity = val;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 37, (Object)objPC.smtpsecurity, (Object)val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(37);
        }
    }

    private static String jdoGetsmtpserver(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 38)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 38, objPC.smtpserver);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(38) && !((BitSet)objPC.jdoDetachedState[3]).get(38)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"smtpserver\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.smtpserver;
    }

    private static void jdoSetsmtpserver(Parametros objPC, String val) {
        if (objPC.jdoStateManager == null) {
            objPC.smtpserver = val;
        } else {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 38, objPC.smtpserver, val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(38);
        }
    }

    private static String jdoGetsmtpuser(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 39)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 39, objPC.smtpuser);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(39) && !((BitSet)objPC.jdoDetachedState[3]).get(39)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"smtpuser\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.smtpuser;
    }

    private static void jdoSetsmtpuser(Parametros objPC, String val) {
        if (objPC.jdoStateManager == null) {
            objPC.smtpuser = val;
        } else {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 39, objPC.smtpuser, val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(39);
        }
    }

    private static Integer jdoGetsugestaoprecos(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 40)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 40, (Object)objPC.sugestaoprecos);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(40) && !((BitSet)objPC.jdoDetachedState[3]).get(40)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"sugestaoprecos\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.sugestaoprecos;
    }

    private static void jdoSetsugestaoprecos(Parametros objPC, Integer val) {
        if (objPC.jdoStateManager == null) {
            objPC.sugestaoprecos = val;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 40, (Object)objPC.sugestaoprecos, (Object)val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(40);
        }
    }

    private static String jdoGettextoemail(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 41)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 41, objPC.textoemail);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(41) && !((BitSet)objPC.jdoDetachedState[3]).get(41)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"textoemail\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.textoemail;
    }

    private static void jdoSettextoemail(Parametros objPC, String val) {
        if (objPC.jdoStateManager == null) {
            objPC.textoemail = val;
        } else {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 41, objPC.textoemail, val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(41);
        }
    }

    private static Unidadesmedida jdoGetunidademedida(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 42)) {
            return (Unidadesmedida)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 42, (Object)objPC.unidademedida);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(42) && !((BitSet)objPC.jdoDetachedState[3]).get(42)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"unidademedida\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.unidademedida;
    }

    private static void jdoSetunidademedida(Parametros objPC, Unidadesmedida val) {
        if (objPC.jdoStateManager == null) {
            objPC.unidademedida = val;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 42, (Object)objPC.unidademedida, (Object)val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(42);
        }
    }

    private static String jdoGetversion(Parametros objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 43)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 43, objPC.version);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(43) && !((BitSet)objPC.jdoDetachedState[3]).get(43)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"version\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.version;
    }

    private static void jdoSetversion(Parametros objPC, String val) {
        if (objPC.jdoStateManager == null) {
            objPC.version = val;
        } else {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 43, objPC.version, val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(43);
        }
    }
}

