/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.model;

import java.util.BitSet;
import javax.jdo.JDODetachedFieldAccessException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.PersistenceManager;
import javax.jdo.identity.StringIdentity;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;
import org.apache.commons.lang.WordUtils;
import org.dma.java.input.FieldFormat;
import org.dma.java.util.MessageLine;
import org.dma.java.util.MessageList;
import org.dma.java.util.StringUtils;
import org.dma.services.vies.CheckVatAddress;
import org.dma.services.vies.CheckVatResult;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.IDatabaseModel;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.AbstractModel;
import org.projectocolibri.api.database.model.Codigospostais;
import org.projectocolibri.api.database.model.Entidades;
import org.projectocolibri.api.database.model.Paises;
import org.projectocolibri.api.database.model.Tiposmorada;
import org.projectocolibri.api.language.LABELS;

@javax.jdo.annotations.PersistenceCapable
public class Entidadesmoradas
extends AbstractModel
implements Detachable,
PersistenceCapable {
    private String key;
    private Entidades entidade;
    private Tiposmorada tipomorada;
    private Codigospostais codigopostal;
    private Paises pais;
    private String morada;
    private String localidade;
    private Integer numerolinha;
    protected transient StateManager jdoStateManager;
    protected transient byte jdoFlags;
    protected Object[] jdoDetachedState;
    private static final byte[] jdoFieldFlags;
    private static final Class jdoPersistenceCapableSuperclass;
    private static final Class[] jdoFieldTypes;
    private static final String[] jdoFieldNames;
    private static final int jdoInheritedFieldCount;

    private Entidadesmoradas() {
        super(TABLES.entidadesmoradas);
    }

    private Entidadesmoradas(DatabaseManager manager) {
        super(TABLES.entidadesmoradas, manager);
    }

    public Entidadesmoradas(Entidades entidade, Tiposmorada tipomorada, Paises pais, CheckVatResult result) {
        this(entidade.getManager());
        this.entidade = entidade;
        this.tipomorada = tipomorada;
        Codigospostais codigopostal = this.manager.loadCodigospostais(result.getAddress().getZipcode());
        this.codigopostal = codigopostal == null ? new Codigospostais(this.manager, result.getAddress().getZipcode()) : codigopostal;
        this.pais = pais;
        this.morada = WordUtils.capitalizeFully((String)result.getAddress().getStreet());
        this.localidade = WordUtils.capitalizeFully((String)result.getAddress().getCity());
        this.numerolinha = entidade.getMoradas().size() + 1;
        this.key = this.generateKey();
    }

    public Entidadesmoradas(Entidades entidade, Tiposmorada tipomorada, Codigospostais codigopostal, Paises pais) {
        this(entidade.getManager());
        this.entidade = entidade;
        this.tipomorada = tipomorada;
        this.codigopostal = codigopostal;
        this.pais = pais;
        this.morada = "";
        this.localidade = codigopostal == null ? null : codigopostal.getDescricao();
        this.numerolinha = entidade.getMoradas().size() + 1;
        this.key = this.generateKey();
    }

    @Override
    public Entidadesmoradas cloneCopy() {
        Entidadesmoradas clone = new Entidadesmoradas(this.manager);
        Entidadesmoradas.jdoSetkey(clone, Entidadesmoradas.jdoGetkey(this));
        Entidadesmoradas.jdoSetentidade(clone, Entidadesmoradas.jdoGetentidade(this));
        Entidadesmoradas.jdoSettipomorada(clone, Entidadesmoradas.jdoGettipomorada(this));
        Entidadesmoradas.jdoSetcodigopostal(clone, Entidadesmoradas.jdoGetcodigopostal(this));
        Entidadesmoradas.jdoSetpais(clone, Entidadesmoradas.jdoGetpais(this));
        Entidadesmoradas.jdoSetmorada(clone, Entidadesmoradas.jdoGetmorada(this));
        Entidadesmoradas.jdoSetlocalidade(clone, Entidadesmoradas.jdoGetlocalidade(this));
        Entidadesmoradas.jdoSetnumerolinha(clone, Entidadesmoradas.jdoGetnumerolinha(this));
        return clone;
    }

    Entidadesmoradas cloneCopy(Entidades entidade) {
        Entidadesmoradas clone = this.cloneCopy();
        Entidadesmoradas.jdoSetentidade(clone, entidade);
        clone.setKey();
        return clone;
    }

    @Override
    public MessageList validate(IDatabaseModel.ACTION action) {
        MessageList error = super.validate(action);
        switch (action) {
            case DELETE: {
                break;
            }
            case STORE: {
                if (Entidadesmoradas.jdoGetnumerolinha(this) == 1 && !Entidadesmoradas.jdoGettipomorada(this).isTipo(0)) {
                    error.add((Object)new MessageLine((Object)LABELS.entidadesmoradas_tipomorada));
                }
                if (!this.isCodigopostalValid()) {
                    error.add((Object)new MessageLine((Object)LABELS.entidadesmoradas_codigopostal));
                }
                if (this.isPaisValid()) break;
                error.add((Object)new MessageLine((Object)LABELS.entidadesmoradas_pais));
            }
        }
        return error.prefix((Object)((Object)LABELS.entidadesmoradas_numerolinha) + " " + this.getNumerolinhaToText());
    }

    @Override
    public String getKey() {
        return Entidadesmoradas.jdoGetkey(this);
    }

    public void setKey(String key) {
        String string = Entidadesmoradas.jdoGetkey(this);
        String string2 = key;
        Entidadesmoradas.jdoSetkey(this, string2);
        this.firePropertyChange(FIELDS.entidadesmoradas_key, (Object)string, (Object)string2);
    }

    void setKey() {
        this.setKey(this.generateKey());
    }

    String generateKey() {
        return Entidadesmoradas.jdoGetentidade(this) == null || Entidadesmoradas.jdoGetnumerolinha(this) == null ? null : Entidadesmoradas.generateKey(Entidadesmoradas.jdoGetentidade(this).getKey(), Entidadesmoradas.jdoGetnumerolinha(this));
    }

    public static String generateKey(String entidade, Integer numerolinha) {
        return String.valueOf(entidade) + ":" + numerolinha;
    }

    public Entidades getEntidade() {
        return Entidadesmoradas.jdoGetentidade(this);
    }

    public void setEntidade(Entidades entidade) {
        Entidades entidades = Entidadesmoradas.jdoGetentidade(this);
        Entidades entidades2 = entidade;
        Entidadesmoradas.jdoSetentidade(this, entidades2);
        this.firePropertyChange(FIELDS.entidadesmoradas_entidade, (Object)entidades, (Object)entidades2);
        this.setKey();
    }

    public Tiposmorada getTipomorada() {
        return Entidadesmoradas.jdoGettipomorada(this);
    }

    public void setTipomorada(Tiposmorada tipomorada) {
        Tiposmorada tiposmorada = Entidadesmoradas.jdoGettipomorada(this);
        Tiposmorada tiposmorada2 = tipomorada;
        Entidadesmoradas.jdoSettipomorada(this, tiposmorada2);
        this.firePropertyChange(FIELDS.entidadesmoradas_tipomorada, (Object)tiposmorada, (Object)tiposmorada2);
    }

    public Codigospostais getCodigopostal() {
        return Entidadesmoradas.jdoGetcodigopostal(this);
    }

    public void setCodigopostal(Codigospostais codigopostal) {
        Codigospostais codigospostais = Entidadesmoradas.jdoGetcodigopostal(this);
        Codigospostais codigospostais2 = codigopostal;
        Entidadesmoradas.jdoSetcodigopostal(this, codigospostais2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesmoradas_codigopostal, (Object)codigospostais, (Object)codigospostais2);
        if (Entidadesmoradas.jdoGetentidade((Entidadesmoradas)this).cascade && this.cascade && changed && codigopostal != null) {
            this.setLocalidade(codigopostal.getDescricao());
        }
    }

    public boolean isCodigopostalValid() {
        return !StringUtils.isEmpty((String)Entidadesmoradas.jdoGetlocalidade(this)) && Entidadesmoradas.jdoGetcodigopostal(this) != null && Entidadesmoradas.jdoGetcodigopostal(this).isValid(Entidadesmoradas.jdoGetpais(this));
    }

    public Paises getPais() {
        return Entidadesmoradas.jdoGetpais(this);
    }

    public void setPais(Paises pais) {
        Paises paises = Entidadesmoradas.jdoGetpais(this);
        Paises paises2 = pais;
        Entidadesmoradas.jdoSetpais(this, paises2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesmoradas_pais, (Object)paises, (Object)paises2);
        if (changed && Entidadesmoradas.jdoGetnumerolinha(this).equals(1)) {
            Entidadesmoradas.jdoGetentidade(this).setPais(pais);
        }
    }

    public boolean isPaisValid() {
        return Entidadesmoradas.jdoGetpais(this) != null && (Entidadesmoradas.jdoGetpais(this).equals(Entidadesmoradas.jdoGetentidade(this).getPais()) || Entidadesmoradas.jdoGetnumerolinha(this) > 1);
    }

    public String getMorada() {
        return Entidadesmoradas.jdoGetmorada(this);
    }

    public String getMoradaToText() {
        return Entidadesmoradas.jdoGetmorada(this) == null ? "" : FIELDS.entidadesmoradas_morada.format.format(Entidadesmoradas.jdoGetmorada(this));
    }

    public void setMorada(String morada) {
        String string = Entidadesmoradas.jdoGetmorada(this);
        String string2 = StringUtils.replaceAll((String)morada, (String)FieldFormat.SEPARATOR.SEMICOLON.value, (String)"\n");
        Entidadesmoradas.jdoSetmorada(this, string2);
        this.firePropertyChange(FIELDS.entidadesmoradas_morada, (Object)string, (Object)string2);
    }

    public void setMorada(CheckVatAddress address) {
        this.setMorada(WordUtils.capitalizeFully((String)FIELDS.entidadesmoradas_morada.parse(address.getStreet().replace(FieldFormat.KEYBOARD.LINE_FEED.value, "\n")).toString()));
        Codigospostais codigopostal = this.manager.loadCodigospostais(address.getZipcode());
        this.setCodigopostal(codigopostal == null ? new Codigospostais(this.manager, address.getZipcode()) : codigopostal);
        this.setLocalidade(WordUtils.capitalizeFully((String)FIELDS.entidadesmoradas_localidade.parse(address.getCity()).toString()));
    }

    public String getLocalidade() {
        return Entidadesmoradas.jdoGetlocalidade(this);
    }

    public String getLocalidadeToText() {
        return Entidadesmoradas.jdoGetlocalidade(this) == null ? "" : Entidadesmoradas.jdoGetlocalidade(this).toString();
    }

    public void setLocalidade(String localidade) {
        String string = Entidadesmoradas.jdoGetlocalidade(this);
        String string2 = localidade;
        Entidadesmoradas.jdoSetlocalidade(this, string2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesmoradas_localidade, (Object)string, (Object)string2);
        if (Entidadesmoradas.jdoGetentidade((Entidadesmoradas)this).cascade && this.cascade && changed && Entidadesmoradas.jdoGetcodigopostal(this) != null) {
            Entidadesmoradas.jdoGetcodigopostal(this).setDescricao(localidade);
        }
    }

    public Integer getNumerolinha() {
        return Entidadesmoradas.jdoGetnumerolinha(this);
    }

    public String getNumerolinhaToText() {
        return Entidadesmoradas.jdoGetnumerolinha(this) == null ? "" : Entidadesmoradas.jdoGetnumerolinha(this).toString();
    }

    protected void setNumerolinha(Integer numerolinha) {
        Integer n = Entidadesmoradas.jdoGetnumerolinha(this);
        Integer n2 = numerolinha;
        Entidadesmoradas.jdoSetnumerolinha(this, n2);
        this.firePropertyChange(FIELDS.entidadesmoradas_numerolinha, (Object)n, (Object)n2);
        this.setKey();
    }

    @Override
    public boolean isEditable(FIELDS field) {
        return field != FIELDS.entidadesmoradas_numerolinha;
    }

    @Override
    public void attach(DatabaseManager manager) {
        manager.attach(new AbstractModel[]{Entidadesmoradas.jdoGetentidade(this), Entidadesmoradas.jdoGettipomorada(this), Entidadesmoradas.jdoGetcodigopostal(this), Entidadesmoradas.jdoGetpais(this)});
    }

    public String toString() {
        return Entidadesmoradas.jdoGetkey(this);
    }

    public int hashCode() {
        return Entidadesmoradas.jdoGetkey(this) == null ? 0 : Entidadesmoradas.jdoGetkey(this).hashCode();
    }

    public boolean equals(Object obj) {
        return this.hashCode() == obj.hashCode();
    }

    static {
        jdoFieldNames = Entidadesmoradas.__jdoFieldNamesInit();
        jdoFieldTypes = Entidadesmoradas.__jdoFieldTypesInit();
        jdoFieldFlags = Entidadesmoradas.__jdoFieldFlagsInit();
        jdoInheritedFieldCount = Entidadesmoradas.__jdoGetInheritedFieldCount();
        jdoPersistenceCapableSuperclass = Entidadesmoradas.__jdoPersistenceCapableSuperclassInit();
        JDOImplHelper.registerClass((Class)Entidadesmoradas.___jdo$loadClass("org.projectocolibri.api.database.model.Entidadesmoradas"), (String[])jdoFieldNames, (Class[])jdoFieldTypes, (byte[])jdoFieldFlags, (Class)jdoPersistenceCapableSuperclass, (PersistenceCapable)new Entidadesmoradas());
    }

    public void jdoCopyKeyFieldsFromObjectId(PersistenceCapable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("oid is not instanceof javax.jdo.identity.StringIdentity");
        }
        StringIdentity o = (StringIdentity)oid;
        fc.storeStringField(2, o.getKey());
    }

    protected void jdoCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("key class is not javax.jdo.identity.StringIdentity or null");
        }
        StringIdentity o = (StringIdentity)oid;
        this.key = o.getKey();
    }

    public final void jdoCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final void jdoCopyKeyFieldsToObjectId(PersistenceCapable.ObjectIdFieldSupplier fs, Object object) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final Object jdoGetObjectId() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getObjectId((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[0];
    }

    public final Object jdoGetVersion() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getVersion((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[1];
    }

    protected final void jdoPreSerialize() {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.preSerialize((PersistenceCapable)this);
        }
    }

    public final PersistenceManager jdoGetPersistenceManager() {
        return this.jdoStateManager != null ? this.jdoStateManager.getPersistenceManager((PersistenceCapable)this) : null;
    }

    public final Object jdoGetTransactionalObjectId() {
        return this.jdoStateManager != null ? this.jdoStateManager.getTransactionalObjectId((PersistenceCapable)this) : null;
    }

    public final boolean jdoIsDeleted() {
        return this.jdoStateManager != null ? this.jdoStateManager.isDeleted((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsDirty() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.isDirty((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return false;
        }
        return ((BitSet)this.jdoDetachedState[3]).length() > 0;
    }

    public final boolean jdoIsNew() {
        return this.jdoStateManager != null ? this.jdoStateManager.isNew((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsPersistent() {
        return this.jdoStateManager != null ? this.jdoStateManager.isPersistent((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsTransactional() {
        return this.jdoStateManager != null ? this.jdoStateManager.isTransactional((PersistenceCapable)this) : false;
    }

    public void jdoMakeDirty(String fieldName) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.makeDirty((PersistenceCapable)this, fieldName);
        }
        if (this.jdoIsDetached() && fieldName != null) {
            String fldName = null;
            fldName = fieldName.indexOf(46) >= 0 ? fieldName.substring(fieldName.lastIndexOf(46) + 1) : fieldName;
            int i = 0;
            while (i < jdoFieldNames.length) {
                if (jdoFieldNames[i].equals(fldName)) {
                    if (!((BitSet)this.jdoDetachedState[2]).get(i + jdoInheritedFieldCount)) {
                        throw new JDODetachedFieldAccessException("You have just attempted to access a field/property that hasn't been detached. Please detach it first before performing this operation");
                    }
                    ((BitSet)this.jdoDetachedState[3]).set(i + jdoInheritedFieldCount);
                    return;
                }
                ++i;
            }
        }
    }

    public final Object jdoNewObjectIdInstance() {
        return new StringIdentity(this.getClass(), this.key);
    }

    public final Object jdoNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new StringIdentity(this.getClass(), (String)key);
        }
        return new StringIdentity(this.getClass(), (String)key);
    }

    public final void jdoProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void jdoReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.jdoReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void jdoReplaceFlags() {
        if (this.jdoStateManager != null) {
            this.jdoFlags = this.jdoStateManager.replacingFlags((PersistenceCapable)this);
        }
    }

    public final synchronized void jdoReplaceStateManager(StateManager sm) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager = this.jdoStateManager.replacingStateManager((PersistenceCapable)this, sm);
        } else {
            JDOImplHelper.checkAuthorizedStateManager((StateManager)sm);
            this.jdoStateManager = sm;
            this.jdoFlags = 1;
        }
    }

    public final synchronized void jdoReplaceDetachedState() {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        this.jdoDetachedState = this.jdoStateManager.replacingDetachedState((Detachable)this, this.jdoDetachedState);
    }

    public boolean jdoIsDetached() {
        return this.jdoStateManager == null && this.jdoDetachedState != null;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm) {
        Entidadesmoradas result = new Entidadesmoradas();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        return result;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm, Object obj) {
        Entidadesmoradas result = new Entidadesmoradas();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        result.jdoCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void jdoReplaceField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.codigopostal = (Codigospostais)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 1: {
                this.entidade = (Entidades)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 2: {
                this.key = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 3: {
                this.localidade = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 4: {
                this.morada = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 5: {
                this.numerolinha = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 6: {
                this.pais = (Paises)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 7: {
                this.tipomorada = (Tiposmorada)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoProvideField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.codigopostal);
                break;
            }
            case 1: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.entidade);
                break;
            }
            case 2: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.key);
                break;
            }
            case 3: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.localidade);
                break;
            }
            case 4: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.morada);
                break;
            }
            case 5: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.numerolinha);
                break;
            }
            case 6: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.pais);
                break;
            }
            case 7: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.tipomorada);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void jdoCopyField(Entidadesmoradas obj, int index) {
        switch (index) {
            case 0: {
                this.codigopostal = obj.codigopostal;
                break;
            }
            case 1: {
                this.entidade = obj.entidade;
                break;
            }
            case 2: {
                this.key = obj.key;
                break;
            }
            case 3: {
                this.localidade = obj.localidade;
                break;
            }
            case 4: {
                this.morada = obj.morada;
                break;
            }
            case 5: {
                this.numerolinha = obj.numerolinha;
                break;
            }
            case 6: {
                this.pais = obj.pais;
                break;
            }
            case 7: {
                this.tipomorada = obj.tipomorada;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoCopyFields(Object obj, int[] indices) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof Entidadesmoradas)) {
            throw new IllegalArgumentException("object is not an object of type org.projectocolibri.api.database.model.Entidadesmoradas");
        }
        Entidadesmoradas other = (Entidadesmoradas)obj;
        if (this.jdoStateManager != other.jdoStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __jdoFieldNamesInit() {
        return new String[]{"codigopostal", "entidade", "key", "localidade", "morada", "numerolinha", "pais", "tipomorada"};
    }

    private static final Class[] __jdoFieldTypesInit() {
        return new Class[]{Entidadesmoradas.___jdo$loadClass("org.projectocolibri.api.database.model.Codigospostais"), Entidadesmoradas.___jdo$loadClass("org.projectocolibri.api.database.model.Entidades"), Entidadesmoradas.___jdo$loadClass("java.lang.String"), Entidadesmoradas.___jdo$loadClass("java.lang.String"), Entidadesmoradas.___jdo$loadClass("java.lang.String"), Entidadesmoradas.___jdo$loadClass("java.lang.Integer"), Entidadesmoradas.___jdo$loadClass("org.projectocolibri.api.database.model.Paises"), Entidadesmoradas.___jdo$loadClass("org.projectocolibri.api.database.model.Tiposmorada")};
    }

    private static final byte[] __jdoFieldFlagsInit() {
        return new byte[]{5, 5, 24, 21, 21, 21, 5, 5};
    }

    protected static int __jdoGetInheritedFieldCount() {
        return 0;
    }

    protected static int jdoGetManagedFieldCount() {
        return 8;
    }

    private static Class __jdoPersistenceCapableSuperclassInit() {
        return null;
    }

    public static Class ___jdo$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object jdoSuperClone() throws CloneNotSupportedException {
        Entidadesmoradas o = (Entidadesmoradas)super.clone();
        o.jdoFlags = 0;
        o.jdoStateManager = null;
        return o;
    }

    private static Codigospostais jdoGetcodigopostal(Entidadesmoradas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 0)) {
            return (Codigospostais)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 0, (Object)objPC.codigopostal);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(0)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"codigopostal\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.codigopostal;
    }

    private static void jdoSetcodigopostal(Entidadesmoradas objPC, Codigospostais val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 0, (Object)objPC.codigopostal, (Object)val);
        } else {
            objPC.codigopostal = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(0);
            }
        }
    }

    private static Entidades jdoGetentidade(Entidadesmoradas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 1)) {
            return (Entidades)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 1, (Object)objPC.entidade);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(1)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"entidade\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.entidade;
    }

    private static void jdoSetentidade(Entidadesmoradas objPC, Entidades val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 1, (Object)objPC.entidade, (Object)val);
        } else {
            objPC.entidade = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(1);
            }
        }
    }

    private static String jdoGetkey(Entidadesmoradas objPC) {
        return objPC.key;
    }

    private static void jdoSetkey(Entidadesmoradas objPC, String val) {
        if (objPC.jdoStateManager == null) {
            objPC.key = val;
        } else {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 2, objPC.key, val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(2);
        }
    }

    private static String jdoGetlocalidade(Entidadesmoradas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 3)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 3, objPC.localidade);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(3)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"localidade\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.localidade;
    }

    private static void jdoSetlocalidade(Entidadesmoradas objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 3, objPC.localidade, val);
        } else {
            objPC.localidade = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(3);
            }
        }
    }

    private static String jdoGetmorada(Entidadesmoradas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 4)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 4, objPC.morada);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(4)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"morada\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.morada;
    }

    private static void jdoSetmorada(Entidadesmoradas objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 4, objPC.morada, val);
        } else {
            objPC.morada = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(4);
            }
        }
    }

    private static Integer jdoGetnumerolinha(Entidadesmoradas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 5)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 5, (Object)objPC.numerolinha);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(5)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"numerolinha\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.numerolinha;
    }

    private static void jdoSetnumerolinha(Entidadesmoradas objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 5, (Object)objPC.numerolinha, (Object)val);
        } else {
            objPC.numerolinha = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(5);
            }
        }
    }

    private static Paises jdoGetpais(Entidadesmoradas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 6)) {
            return (Paises)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 6, (Object)objPC.pais);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(6)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"pais\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.pais;
    }

    private static void jdoSetpais(Entidadesmoradas objPC, Paises val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 6, (Object)objPC.pais, (Object)val);
        } else {
            objPC.pais = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(6);
            }
        }
    }

    private static Tiposmorada jdoGettipomorada(Entidadesmoradas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 7)) {
            return (Tiposmorada)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 7, (Object)objPC.tipomorada);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(7)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"tipomorada\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.tipomorada;
    }

    private static void jdoSettipomorada(Entidadesmoradas objPC, Tiposmorada val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 7, (Object)objPC.tipomorada, (Object)val);
        } else {
            objPC.tipomorada = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(7);
            }
        }
    }
}

