/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.model;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.BitSet;
import java.util.Date;
import javax.jdo.JDODetachedFieldAccessException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.PersistenceManager;
import javax.jdo.annotations.NotPersistent;
import javax.jdo.identity.StringIdentity;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;
import org.dma.java.math.BusinessRules;
import org.dma.java.math.MathFormula;
import org.dma.java.math.NumericUtils;
import org.dma.java.util.Debug;
import org.dma.java.util.ErrorList;
import org.dma.java.util.MessageLine;
import org.dma.java.util.MessageList;
import org.dma.java.util.TimeDateUtils;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.IDatabaseModel;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.AbstractModel;
import org.projectocolibri.api.database.model.Armazens;
import org.projectocolibri.api.database.model.Artigos;
import org.projectocolibri.api.database.model.Artigosexistencias;
import org.projectocolibri.api.database.model.Artigosmovimentos;
import org.projectocolibri.api.database.model.Artigosprecos;
import org.projectocolibri.api.database.model.Artigosunidades;
import org.projectocolibri.api.database.model.Codigosiva;
import org.projectocolibri.api.database.model.Cores;
import org.projectocolibri.api.database.model.Entidades;
import org.projectocolibri.api.database.model.Entidadesartigos;
import org.projectocolibri.api.database.model.Entidadesdocumentos;
import org.projectocolibri.api.database.model.Entidadesmovimentos;
import org.projectocolibri.api.database.model.Isencoesiva;
import org.projectocolibri.api.database.model.Tamanhos;
import org.projectocolibri.api.database.model.Unidadesmedida;
import org.projectocolibri.api.language.LABELS;

@javax.jdo.annotations.PersistenceCapable
public class Entidadesdocumentoslinhas
extends AbstractModel
implements Detachable,
PersistenceCapable {
    public static final int tipo_header = 0;
    public static final int tipo_movimento = 1;
    public static final int tipo_comentario = 2;
    public static final int tipo_composicao = 3;
    private String key;
    private Entidadesdocumentoslinhas linhaorigem;
    private Entidadesmovimentos movimentoorigem;
    private Artigosmovimentos movimentoorigem2;
    private Artigosmovimentos movimentoartigos;
    private Entidadesdocumentos documento;
    private Artigos artigo;
    private Unidadesmedida unidademedida;
    private Armazens armazem;
    private Tamanhos tamanho;
    private Cores cor;
    private Codigosiva codigoiva;
    private Isencoesiva isencaoiva;
    private Date datadocumento;
    private String descricao;
    private String numeroserie;
    private String campo1 = "";
    private String campo2 = "";
    private String campo3 = "";
    private String campo4 = "";
    private String campo5 = "";
    private Integer numerolinha;
    private Integer tipo;
    private BigDecimal factor;
    private BigDecimal quantidade;
    private BigDecimal preco;
    private BigDecimal preco2;
    private BigDecimal precoiva;
    private BigDecimal valoriliquido;
    private BigDecimal valoriliquidoiva;
    @NotPersistent
    private BigDecimal valoriliquidoiva2 = BigDecimal.ZERO;
    private BigDecimal percdesconto;
    private BigDecimal percdesconto2;
    private BigDecimal valordesconto;
    private BigDecimal valorliquido;
    private BigDecimal valoriva;
    private BigDecimal valorprodutos;
    private BigDecimal valorservicos;
    private BigDecimal valorretencao;
    private BigDecimal formulaquant;
    private BigDecimal formulavalor1;
    private BigDecimal formulavalor2;
    private BigDecimal formulavalor3;
    private BigDecimal formulavalor4;
    private Boolean deducao;
    protected transient StateManager jdoStateManager;
    protected transient byte jdoFlags;
    protected Object[] jdoDetachedState;
    private static final byte[] jdoFieldFlags;
    private static final Class jdoPersistenceCapableSuperclass;
    private static final Class[] jdoFieldTypes;
    private static final String[] jdoFieldNames;
    private static final int jdoInheritedFieldCount;

    private Entidadesdocumentoslinhas() {
        super(TABLES.entidadesdocumentoslinhas);
    }

    private Entidadesdocumentoslinhas(DatabaseManager manager) {
        super(TABLES.entidadesdocumentoslinhas, manager);
    }

    public Entidadesdocumentoslinhas(Entidadesdocumentos documento, int tipo) {
        this(documento.getManager());
        this.linhaorigem = null;
        this.movimentoorigem = null;
        this.movimentoorigem2 = null;
        this.movimentoartigos = null;
        this.documento = documento;
        this.artigo = null;
        this.unidademedida = this.manager.getParametros().getUnidademedida();
        this.armazem = this.manager.loadArmazens();
        this.tamanho = this.manager.loadTamanhos();
        this.cor = this.manager.loadCores();
        this.codigoiva = documento.getEntidade().isTipoiva(1) ? documento.getEntidade().getCodigoiva() : this.manager.getParametros().getCodigoiva();
        this.isencaoiva = documento.getEntidade().isTipoiva(1) ? documento.getEntidade().getIsencaoiva() : this.manager.getParametros().getIsencaoiva();
        this.datadocumento = documento.getDatacriacao();
        this.descricao = "";
        this.numeroserie = "0";
        this.numerolinha = documento.getLinhasdocumento().size() + 1;
        this.tipo = tipo;
        this.factor = BigDecimal.ONE;
        this.quantidade = BigDecimal.ZERO;
        this.preco = BigDecimal.ZERO;
        this.preco2 = BigDecimal.ZERO;
        this.precoiva = BigDecimal.ZERO;
        this.valoriliquido = BigDecimal.ZERO;
        this.valoriliquidoiva = BigDecimal.ZERO;
        this.percdesconto = this.isTipo(1) ? documento.getEntidade().getDesconto(documento.getTipodocumento()) : BigDecimal.ZERO;
        this.percdesconto2 = BigDecimal.ZERO;
        this.valordesconto = BigDecimal.ZERO;
        this.valorliquido = BigDecimal.ZERO;
        this.valoriva = BigDecimal.ZERO;
        this.valorprodutos = BigDecimal.ZERO;
        this.valorservicos = BigDecimal.ZERO;
        this.valorretencao = BigDecimal.ZERO;
        this.formulaquant = BigDecimal.ZERO;
        this.formulavalor1 = BigDecimal.ZERO;
        this.formulavalor2 = BigDecimal.ZERO;
        this.formulavalor3 = BigDecimal.ZERO;
        this.formulavalor4 = BigDecimal.ZERO;
        this.deducao = false;
        this.key = this.generateKey();
        this.process();
    }

    public Entidadesdocumentoslinhas(Entidadesdocumentos documento, Artigosmovimentos movimento) {
        this(documento.getManager());
        this.linhaorigem = movimento.getLinhaorigem();
        this.movimentoorigem = movimento.getLinhaorigem().getDocumento().getMovimentoentidades();
        this.movimentoorigem2 = movimento;
        this.movimentoartigos = null;
        this.documento = documento;
        this.artigo = movimento.getArtigo();
        this.unidademedida = movimento.getUnidademedida();
        this.armazem = movimento.getArmazem();
        this.tamanho = movimento.getTamanho();
        this.cor = movimento.getCor();
        this.codigoiva = movimento.getCodigoiva();
        this.isencaoiva = movimento.getIsencaoiva();
        this.datadocumento = movimento.getDatadocumento();
        this.descricao = movimento.getDescricao();
        this.numeroserie = movimento.getNumeroserie();
        this.numerolinha = documento.getLinhasdocumento().size() + 1;
        this.tipo = 1;
        this.factor = movimento.getFactor();
        this.quantidade = movimento.getQuantidadependente();
        this.preco = movimento.getPreco();
        this.preco2 = BigDecimal.ZERO;
        this.precoiva = movimento.getPrecoiva();
        this.valoriliquido = movimento.getValoriliquido();
        this.valoriliquidoiva = movimento.getValoriliquidoiva();
        this.percdesconto = movimento.getPercdesconto();
        this.percdesconto2 = movimento.getPercdesconto2();
        this.valordesconto = movimento.getValordesconto();
        this.valorliquido = movimento.getValorliquido();
        this.valoriva = movimento.getValoriva();
        this.valorprodutos = movimento.getValorprodutos();
        this.valorservicos = movimento.getValorservicos();
        this.valorretencao = movimento.getValorretencao();
        this.formulaquant = movimento.getFormulaquant();
        this.formulavalor1 = movimento.getFormulavalor1();
        this.formulavalor2 = movimento.getFormulavalor2();
        this.formulavalor3 = movimento.getFormulavalor3();
        this.formulavalor4 = movimento.getFormulavalor4();
        this.deducao = false;
        this.key = this.generateKey();
        this.process();
    }

    public Entidadesdocumentoslinhas(Entidadesdocumentos documento, Entidadesmovimentos movimento) {
        this(documento.getManager());
        this.linhaorigem = null;
        this.movimentoorigem = movimento;
        this.movimentoorigem2 = null;
        this.movimentoartigos = null;
        this.documento = documento;
        this.artigo = null;
        this.unidademedida = null;
        this.armazem = null;
        this.tamanho = null;
        this.cor = null;
        this.codigoiva = null;
        this.isencaoiva = null;
        this.datadocumento = movimento.getDocumento().getDatadocumento();
        this.descricao = "";
        this.numeroserie = "0";
        this.numerolinha = documento.getLinhasdocumento().size() + 1;
        this.tipo = 1;
        this.factor = BigDecimal.ZERO;
        this.quantidade = BigDecimal.ZERO;
        this.preco = BigDecimal.ZERO;
        this.preco2 = BigDecimal.ZERO;
        this.precoiva = BigDecimal.ZERO;
        this.valoriliquido = BigDecimal.ZERO;
        this.valoriliquidoiva = movimento.getValorpendente();
        this.valoriliquidoiva2 = movimento.getValorpendente();
        this.percdesconto = documento.getEntidade().getDesconto(documento.getTipodocumento());
        this.percdesconto2 = BigDecimal.ZERO;
        this.valordesconto = BigDecimal.ZERO;
        this.valorliquido = BigDecimal.ZERO;
        this.valoriva = BigDecimal.ZERO;
        this.valorprodutos = BigDecimal.ZERO;
        this.valorservicos = BigDecimal.ZERO;
        this.valorretencao = BigDecimal.ZERO;
        this.formulaquant = BigDecimal.ZERO;
        this.formulavalor1 = BigDecimal.ZERO;
        this.formulavalor2 = BigDecimal.ZERO;
        this.formulavalor3 = BigDecimal.ZERO;
        this.formulavalor4 = BigDecimal.ZERO;
        this.deducao = false;
        this.key = this.generateKey();
        this.process();
    }

    @Override
    public Entidadesdocumentoslinhas cloneCopy() {
        Entidadesdocumentoslinhas clone = new Entidadesdocumentoslinhas(this.manager);
        Entidadesdocumentoslinhas.jdoSetkey(clone, Entidadesdocumentoslinhas.jdoGetkey(this));
        Entidadesdocumentoslinhas.jdoSetlinhaorigem(clone, Entidadesdocumentoslinhas.jdoGetlinhaorigem(this));
        Entidadesdocumentoslinhas.jdoSetmovimentoorigem(clone, Entidadesdocumentoslinhas.jdoGetmovimentoorigem(this));
        Entidadesdocumentoslinhas.jdoSetmovimentoorigem2(clone, Entidadesdocumentoslinhas.jdoGetmovimentoorigem2(this));
        Entidadesdocumentoslinhas.jdoSetmovimentoartigos(clone, Entidadesdocumentoslinhas.jdoGetmovimentoartigos(this));
        Entidadesdocumentoslinhas.jdoSetdocumento(clone, Entidadesdocumentoslinhas.jdoGetdocumento(this));
        Entidadesdocumentoslinhas.jdoSetartigo(clone, Entidadesdocumentoslinhas.jdoGetartigo(this));
        Entidadesdocumentoslinhas.jdoSetunidademedida(clone, Entidadesdocumentoslinhas.jdoGetunidademedida(this));
        Entidadesdocumentoslinhas.jdoSetarmazem(clone, Entidadesdocumentoslinhas.jdoGetarmazem(this));
        Entidadesdocumentoslinhas.jdoSettamanho(clone, Entidadesdocumentoslinhas.jdoGettamanho(this));
        Entidadesdocumentoslinhas.jdoSetcor(clone, Entidadesdocumentoslinhas.jdoGetcor(this));
        Entidadesdocumentoslinhas.jdoSetcodigoiva(clone, Entidadesdocumentoslinhas.jdoGetcodigoiva(this));
        Entidadesdocumentoslinhas.jdoSetisencaoiva(clone, Entidadesdocumentoslinhas.jdoGetisencaoiva(this));
        Entidadesdocumentoslinhas.jdoSetdatadocumento(clone, Entidadesdocumentoslinhas.jdoGetdatadocumento(this));
        Entidadesdocumentoslinhas.jdoSetdescricao(clone, Entidadesdocumentoslinhas.jdoGetdescricao(this));
        Entidadesdocumentoslinhas.jdoSetnumeroserie(clone, Entidadesdocumentoslinhas.jdoGetnumeroserie(this));
        Entidadesdocumentoslinhas.jdoSetcampo1(clone, Entidadesdocumentoslinhas.jdoGetcampo1(this));
        Entidadesdocumentoslinhas.jdoSetcampo2(clone, Entidadesdocumentoslinhas.jdoGetcampo2(this));
        Entidadesdocumentoslinhas.jdoSetcampo3(clone, Entidadesdocumentoslinhas.jdoGetcampo3(this));
        Entidadesdocumentoslinhas.jdoSetcampo4(clone, Entidadesdocumentoslinhas.jdoGetcampo4(this));
        Entidadesdocumentoslinhas.jdoSetcampo5(clone, Entidadesdocumentoslinhas.jdoGetcampo5(this));
        Entidadesdocumentoslinhas.jdoSetnumerolinha(clone, Entidadesdocumentoslinhas.jdoGetnumerolinha(this));
        Entidadesdocumentoslinhas.jdoSettipo(clone, Entidadesdocumentoslinhas.jdoGettipo(this));
        Entidadesdocumentoslinhas.jdoSetfactor(clone, Entidadesdocumentoslinhas.jdoGetfactor(this));
        Entidadesdocumentoslinhas.jdoSetquantidade(clone, Entidadesdocumentoslinhas.jdoGetquantidade(this));
        Entidadesdocumentoslinhas.jdoSetpreco(clone, Entidadesdocumentoslinhas.jdoGetpreco(this));
        Entidadesdocumentoslinhas.jdoSetpreco2(clone, Entidadesdocumentoslinhas.jdoGetpreco2(this));
        Entidadesdocumentoslinhas.jdoSetprecoiva(clone, Entidadesdocumentoslinhas.jdoGetprecoiva(this));
        Entidadesdocumentoslinhas.jdoSetpercdesconto(clone, Entidadesdocumentoslinhas.jdoGetpercdesconto(this));
        Entidadesdocumentoslinhas.jdoSetpercdesconto2(clone, Entidadesdocumentoslinhas.jdoGetpercdesconto2(this));
        Entidadesdocumentoslinhas.jdoSetvaloriliquido(clone, Entidadesdocumentoslinhas.jdoGetvaloriliquido(this));
        Entidadesdocumentoslinhas.jdoSetvaloriliquidoiva(clone, Entidadesdocumentoslinhas.jdoGetvaloriliquidoiva(this));
        Entidadesdocumentoslinhas.jdoSetvalordesconto(clone, Entidadesdocumentoslinhas.jdoGetvalordesconto(this));
        Entidadesdocumentoslinhas.jdoSetvalorliquido(clone, Entidadesdocumentoslinhas.jdoGetvalorliquido(this));
        Entidadesdocumentoslinhas.jdoSetvaloriva(clone, Entidadesdocumentoslinhas.jdoGetvaloriva(this));
        Entidadesdocumentoslinhas.jdoSetvalorprodutos(clone, Entidadesdocumentoslinhas.jdoGetvalorprodutos(this));
        Entidadesdocumentoslinhas.jdoSetvalorservicos(clone, Entidadesdocumentoslinhas.jdoGetvalorservicos(this));
        Entidadesdocumentoslinhas.jdoSetvalorretencao(clone, Entidadesdocumentoslinhas.jdoGetvalorretencao(this));
        Entidadesdocumentoslinhas.jdoSetformulaquant(clone, Entidadesdocumentoslinhas.jdoGetformulaquant(this));
        Entidadesdocumentoslinhas.jdoSetformulavalor1(clone, Entidadesdocumentoslinhas.jdoGetformulavalor1(this));
        Entidadesdocumentoslinhas.jdoSetformulavalor2(clone, Entidadesdocumentoslinhas.jdoGetformulavalor2(this));
        Entidadesdocumentoslinhas.jdoSetformulavalor3(clone, Entidadesdocumentoslinhas.jdoGetformulavalor3(this));
        Entidadesdocumentoslinhas.jdoSetformulavalor4(clone, Entidadesdocumentoslinhas.jdoGetformulavalor4(this));
        Entidadesdocumentoslinhas.jdoSetdeducao(clone, Entidadesdocumentoslinhas.jdoGetdeducao(this));
        return clone;
    }

    Entidadesdocumentoslinhas cloneCopy(Entidadesdocumentos documento) {
        Entidadesdocumentoslinhas clone = this.cloneCopy();
        Entidadesdocumentoslinhas.jdoSetdocumento(clone, documento);
        clone.setKey();
        return clone;
    }

    public void removeRelations() {
        Entidadesdocumentoslinhas.jdoSetlinhaorigem(this, null);
        Entidadesdocumentoslinhas.jdoSetmovimentoorigem(this, null);
        Entidadesdocumentoslinhas.jdoSetmovimentoorigem2(this, null);
        Entidadesdocumentoslinhas.jdoSetmovimentoartigos(this, null);
    }

    @Override
    public MessageList validate(IDatabaseModel.ACTION action) {
        MessageList error = super.validate(action);
        switch (action) {
            case DELETE: {
                break;
            }
            case STORE: {
                if (Entidadesdocumentoslinhas.jdoGetdocumento(this).getTipodocumento().isTipodocumento(2)) {
                    if (Entidadesdocumentoslinhas.jdoGetmovimentoorigem(this) != null && !Entidadesdocumentoslinhas.jdoGetmovimentoorigem(this).getEntidade().equals(Entidadesdocumentoslinhas.jdoGetdocumento(this).getEntidade())) {
                        error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentos_entidade));
                    }
                    if (Entidadesdocumentoslinhas.jdoGetmovimentoorigem(this) != null && Entidadesdocumentoslinhas.jdoGetmovimentoorigem(this).getSeriedocumento().getRegimeiva() != Entidadesdocumentoslinhas.jdoGetdocumento(this).getSeriedocumento().getRegimeiva()) {
                        error.add((Object)new MessageLine((Object)LABELS.entidades_regimeiva));
                    }
                    if (!NumericUtils.isLesser((BigDecimal)Entidadesdocumentoslinhas.jdoGetvalorliquido(this), (BigDecimal)BigDecimal.ZERO)) break;
                    error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentoslinhas_valorliquido).smallerThan((Object)0));
                    break;
                }
                if (Entidadesdocumentoslinhas.jdoGetlinhaorigem(this) != null && Entidadesdocumentoslinhas.jdoGetlinhaorigem(this).getDocumento().isEstado(1)) {
                    error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentos_estado).equal((Object)Entidadesdocumentoslinhas.jdoGetlinhaorigem(this).getDocumento().getEstadoToText()));
                }
                if (Entidadesdocumentoslinhas.jdoGetlinhaorigem(this) != null && !Entidadesdocumentoslinhas.jdoGetlinhaorigem(this).getDocumento().getEntidade().equals(Entidadesdocumentoslinhas.jdoGetdocumento(this).getEntidade()) && !Entidadesdocumentoslinhas.jdoGetlinhaorigem(this).getDocumento().isNifGenerico()) {
                    error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentos_entidade).equal((Object)Entidadesdocumentoslinhas.jdoGetlinhaorigem(this).getDocumento().getEntidade().getNumero()));
                }
                if (Entidadesdocumentoslinhas.jdoGetartigo(this) != null && Entidadesdocumentoslinhas.jdoGetartigo(this).isEstado(0)) {
                    error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentoslinhas_artigo).brackets((Object)Entidadesdocumentoslinhas.jdoGetartigo(this).getEstadoToText()));
                }
                if (Entidadesdocumentoslinhas.jdoGetartigo(this) != null && Entidadesdocumentoslinhas.jdoGetfactor(this).signum() == 0) {
                    error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentoslinhas_factor));
                }
                if (Entidadesdocumentoslinhas.jdoGetartigo(this) != null && Entidadesdocumentoslinhas.jdoGetquantidade(this).signum() == 0) {
                    error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentoslinhas_quantidade).equal((Object)0));
                }
                if (Entidadesdocumentoslinhas.jdoGetartigo(this) != null && NumericUtils.isLesser((BigDecimal)Entidadesdocumentoslinhas.jdoGetquantidade(this), (BigDecimal)BigDecimal.ZERO) && Entidadesdocumentoslinhas.jdoGetdocumento(this).isAssinado()) {
                    error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentoslinhas_quantidade).smallerThan((Object)0));
                }
                if (Entidadesdocumentoslinhas.jdoGetnumeroserie(this).isEmpty()) {
                    error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentoslinhas_numeroserie));
                }
                if (!this.isDescricaoValid()) {
                    error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentoslinhas_descricao));
                }
                if (!this.isCodigoivaValid()) {
                    error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentoslinhas_codigoiva));
                }
                if (!this.isIsencaoivaValid()) {
                    error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentoslinhas_isencaoiva));
                }
                if (NumericUtils.isLesser((BigDecimal)Entidadesdocumentoslinhas.jdoGetvalordesconto(this), (BigDecimal)BigDecimal.ZERO)) {
                    error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentoslinhas_valordesconto).smallerThan((Object)0));
                }
                if (NumericUtils.isGreater((BigDecimal)Entidadesdocumentoslinhas.jdoGetvalordesconto(this).abs(), (BigDecimal)Entidadesdocumentoslinhas.jdoGetvaloriliquido(this).abs())) {
                    error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentoslinhas_valordesconto));
                }
                if (NumericUtils.isGreater((BigDecimal)Entidadesdocumentoslinhas.jdoGetvalorprodutos(this).abs(), (BigDecimal)Entidadesdocumentoslinhas.jdoGetvaloriliquido(this).abs())) {
                    error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentoslinhas_valorprodutos));
                }
                if (!NumericUtils.isGreater((BigDecimal)Entidadesdocumentoslinhas.jdoGetvalorservicos(this).abs(), (BigDecimal)Entidadesdocumentoslinhas.jdoGetvaloriliquido(this).abs())) break;
                error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentoslinhas_valorservicos));
            }
        }
        return error.prefix((Object)((Object)LABELS.entidadesdocumentoslinhas_numerolinha) + " " + this.getNumerolinhaToText());
    }

    public ErrorList warnings() {
        ErrorList error = new ErrorList();
        if (!Entidadesdocumentoslinhas.jdoGetdocumento(this).getTipodocumento().isTipodocumento(2)) {
            if (Entidadesdocumentoslinhas.jdoGetdocumento(this).getTipodocumento().isMovimentaartigos(1)) {
                Artigosexistencias existencias;
                if (Entidadesdocumentoslinhas.jdoGetartigo(this) != null && Entidadesdocumentoslinhas.jdoGetartigo(this).isStockminimoReached()) {
                    switch (this.manager.getParametros().getAvisastockminimo()) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            error.warnings().add((Object)new MessageLine((Object)LABELS.artigos_stockreal).smallerThan((Object)LABELS.artigos_stockminimo));
                        }
                    }
                }
                if (Entidadesdocumentoslinhas.jdoGetartigo(this) != null && Entidadesdocumentoslinhas.jdoGetartigo(this).isStocknegativoReached()) {
                    switch (this.manager.getParametros().getAvisastocknegativo()) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            error.warnings().add((Object)new MessageLine((Object)LABELS.artigos_stockreal).smallerThan((Object)0));
                            break;
                        }
                        case 2: {
                            error.errors().add((Object)new MessageLine((Object)LABELS.artigos_stockreal).smallerThan((Object)0));
                        }
                    }
                }
                Artigosexistencias artigosexistencias = existencias = Entidadesdocumentoslinhas.jdoGetartigo(this) == null ? null : Entidadesdocumentoslinhas.jdoGetartigo(this).getExistencias(Artigosexistencias.generateKey(Entidadesdocumentoslinhas.jdoGetartigo(this).getCodigo(), Entidadesdocumentoslinhas.jdoGetarmazem(this).getCodigo(), Entidadesdocumentoslinhas.jdoGetnumeroserie(this), Entidadesdocumentoslinhas.jdoGettamanho(this).getCodigo(), Entidadesdocumentoslinhas.jdoGetcor(this).getCodigo()));
                if (Entidadesdocumentoslinhas.jdoGetdocumento(this).getTipodocumento().isTipostock(0) && existencias != null && existencias.getStock().signum() < 0) {
                    switch (this.manager.getParametros().getAvisastocknegativo()) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            error.warnings().add((Object)new MessageLine((Object)LABELS.artigos_existencias).smallerThan((Object)0));
                            break;
                        }
                        case 2: {
                            error.errors().add((Object)new MessageLine((Object)LABELS.artigos_existencias).smallerThan((Object)0));
                        }
                    }
                }
            }
            if (Entidadesdocumentoslinhas.jdoGetartigo(this) != null && Entidadesdocumentoslinhas.jdoGetartigo(this).getComposicao().isEmpty()) {
                switch (this.manager.getParametros().getAvisacomposicao()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        error.warnings().add((Object)new MessageLine((Object)LABELS.artigos_tab_composicao));
                    }
                }
            }
            if (!Entidadesdocumentoslinhas.jdoGetcodigoiva(this).hasTaxa()) {
                switch (this.manager.getParametros().getAvisataxaiva()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        error.warnings().add(new MessageLine((Object)LABELS.entidadesdocumentoslinhas_codigoiva).equal((Object)0) + "%");
                    }
                }
            }
        }
        return error.prefix((Object)((Object)LABELS.entidadesdocumentoslinhas_numerolinha) + " " + this.getNumerolinhaToText());
    }

    Entidadesdocumentoslinhas process() {
        if (!this.busy) {
            this.busy = true;
            boolean cascade = this.setCascade(false);
            if (Entidadesdocumentoslinhas.jdoGetdocumento(this).getTipodocumento().isTipodocumento(2)) {
                BigDecimal valoriva = Entidadesdocumentoslinhas.jdoGetmovimentoorigem(this) == null ? BigDecimal.ZERO : BusinessRules.proportionalValue((BigDecimal)Entidadesdocumentoslinhas.jdoGetmovimentoorigem(this).getTotalliquidoiva(), (BigDecimal)Entidadesdocumentoslinhas.jdoGetmovimentoorigem(this).getTotaliva(), (BigDecimal)Entidadesdocumentoslinhas.jdoGetvaloriliquidoiva(this));
                BigDecimal valoriliquido = Entidadesdocumentoslinhas.jdoGetvaloriliquidoiva(this).subtract(valoriva);
                BigDecimal valordesconto = BusinessRules.percentageValue((BigDecimal)valoriliquido, (BigDecimal)this.getPercdescontofinal());
                BigDecimal valorliquido = valoriliquido.subtract(valordesconto);
                BigDecimal valorservicos = Entidadesdocumentoslinhas.jdoGetmovimentoorigem(this) == null ? BigDecimal.ZERO : BusinessRules.proportionalValue((BigDecimal)Entidadesdocumentoslinhas.jdoGetmovimentoorigem(this).getTotalliquido(), (BigDecimal)Entidadesdocumentoslinhas.jdoGetmovimentoorigem(this).getTotalservicos(), (BigDecimal)valorliquido);
                BigDecimal valorretencao = Entidadesdocumentoslinhas.jdoGetmovimentoorigem(this) == null ? BigDecimal.ZERO : BusinessRules.proportionalValue((BigDecimal)Entidadesdocumentoslinhas.jdoGetmovimentoorigem(this).getTotalliquido(), (BigDecimal)Entidadesdocumentoslinhas.jdoGetmovimentoorigem(this).getTotalretencoes(), (BigDecimal)valorliquido);
                this.setValoriliquido(FIELDS.entidadesdocumentoslinhas_valoriliquido.format.setScale(valoriliquido, RoundingMode.HALF_EVEN));
                this.setValordesconto(FIELDS.entidadesdocumentoslinhas_valordesconto.format.setScale(valordesconto, RoundingMode.HALF_EVEN));
                this.setValorliquido(FIELDS.entidadesdocumentoslinhas_valorliquido.format.setScale(valorliquido, RoundingMode.HALF_EVEN));
                this.setValoriva(FIELDS.entidadesdocumentoslinhas_valoriva.format.setScale(valoriva, RoundingMode.HALF_UP));
                this.setValorprodutos(BigDecimal.ZERO);
                this.setValorservicos(FIELDS.entidadesdocumentoslinhas_valorservicos.format.setScale(valorservicos, RoundingMode.HALF_EVEN));
                this.setValorretencao(FIELDS.entidadesdocumentoslinhas_valorretencao.format.setScale(valorretencao, RoundingMode.HALF_EVEN));
            } else {
                BigDecimal valoriliquido = Entidadesdocumentoslinhas.jdoGetquantidade(this).multiply(Entidadesdocumentoslinhas.jdoGetpreco(this));
                BigDecimal valoriliquidoiva = Entidadesdocumentoslinhas.jdoGetquantidade(this).multiply(Entidadesdocumentoslinhas.jdoGetprecoiva(this));
                BigDecimal valordesconto = BusinessRules.percentageValue((BigDecimal)valoriliquido, (BigDecimal)this.getPercdescontofinal());
                BigDecimal valorliquido = valoriliquido.subtract(valordesconto);
                BigDecimal valoriva = BusinessRules.percentageValue((BigDecimal)valorliquido, (BigDecimal)Entidadesdocumentoslinhas.jdoGetcodigoiva(this).getTaxa());
                BigDecimal valorprodutos = Entidadesdocumentoslinhas.jdoGetartigo(this) != null && Entidadesdocumentoslinhas.jdoGetartigo(this).isTipo(0) ? valorliquido : BigDecimal.ZERO;
                BigDecimal valorservicos = Entidadesdocumentoslinhas.jdoGetartigo(this) != null && Entidadesdocumentoslinhas.jdoGetartigo(this).isTipo(1) ? valorliquido : BigDecimal.ZERO;
                BigDecimal valorretencao = Entidadesdocumentoslinhas.jdoGetartigo(this) != null && Entidadesdocumentoslinhas.jdoGetdocumento(this).getEntidade() != null && Entidadesdocumentoslinhas.jdoGetdocumento(this).getEntidade().isRetencao(1) ? BusinessRules.percentageValue((BigDecimal)valorservicos, (BigDecimal)Entidadesdocumentoslinhas.jdoGetartigo(this).getRetencao().getTaxa()) : BigDecimal.ZERO;
                this.setValoriliquido(FIELDS.entidadesdocumentoslinhas_valoriliquido.format.setScale(valoriliquido, RoundingMode.HALF_EVEN));
                this.setValoriliquidoiva(FIELDS.entidadesdocumentoslinhas_valoriliquidoiva.format.setScale(valoriliquidoiva, RoundingMode.HALF_EVEN));
                this.setValordesconto(FIELDS.entidadesdocumentoslinhas_valordesconto.format.setScale(valordesconto, RoundingMode.HALF_EVEN));
                this.setValorliquido(FIELDS.entidadesdocumentoslinhas_valorliquido.format.setScale(valorliquido, RoundingMode.HALF_EVEN));
                this.setValoriva(FIELDS.entidadesdocumentoslinhas_valoriva.format.setScale(valoriva, RoundingMode.HALF_UP));
                this.setValorprodutos(FIELDS.entidadesdocumentoslinhas_valorprodutos.format.setScale(valorprodutos, RoundingMode.HALF_EVEN));
                this.setValorservicos(FIELDS.entidadesdocumentoslinhas_valorservicos.format.setScale(valorservicos, RoundingMode.HALF_EVEN));
                if (!this.isEditable(FIELDS.entidadesdocumentoslinhas_valorretencao)) {
                    this.setValorretencao(FIELDS.entidadesdocumentoslinhas_valorretencao.format.setScale(valorretencao, RoundingMode.HALF_EVEN));
                }
            }
            if (Entidadesdocumentoslinhas.jdoGetdocumento((Entidadesdocumentoslinhas)this).cascade) {
                Entidadesdocumentoslinhas.jdoGetdocumento(this).process();
            }
            this.setCascade(cascade);
            this.busy = false;
        }
        return this;
    }

    @Override
    public String getKey() {
        return Entidadesdocumentoslinhas.jdoGetkey(this);
    }

    public void setKey(String key) {
        String string = Entidadesdocumentoslinhas.jdoGetkey(this);
        String string2 = key;
        Entidadesdocumentoslinhas.jdoSetkey(this, string2);
        this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_key, (Object)string, (Object)string2);
    }

    void setKey() {
        this.setKey(this.generateKey());
    }

    String generateKey() {
        return Entidadesdocumentoslinhas.jdoGetdocumento(this) == null || Entidadesdocumentoslinhas.jdoGetnumerolinha(this) == null ? null : Entidadesdocumentoslinhas.generateKey(Entidadesdocumentoslinhas.jdoGetdocumento(this).getKey(), Entidadesdocumentoslinhas.jdoGetnumerolinha(this));
    }

    public static String generateKey(String documento, Integer numerolinha) {
        return String.valueOf(documento) + ":" + numerolinha;
    }

    public Entidadesdocumentoslinhas getLinhaorigem() {
        return Entidadesdocumentoslinhas.jdoGetlinhaorigem(this);
    }

    public void setLinhaorigem(Entidadesdocumentoslinhas linhaorigem) {
        Entidadesdocumentoslinhas entidadesdocumentoslinhas = Entidadesdocumentoslinhas.jdoGetlinhaorigem(this);
        Entidadesdocumentoslinhas entidadesdocumentoslinhas2 = linhaorigem;
        Entidadesdocumentoslinhas.jdoSetlinhaorigem(this, entidadesdocumentoslinhas2);
        this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_linhaorigem, (Object)entidadesdocumentoslinhas, (Object)entidadesdocumentoslinhas2);
    }

    public Entidadesmovimentos getMovimentoorigem() {
        return Entidadesdocumentoslinhas.jdoGetmovimentoorigem(this);
    }

    public void setMovimentoorigem(Entidadesmovimentos movimentoorigem) {
        Entidadesmovimentos entidadesmovimentos = Entidadesdocumentoslinhas.jdoGetmovimentoorigem(this);
        Entidadesmovimentos entidadesmovimentos2 = movimentoorigem;
        Entidadesdocumentoslinhas.jdoSetmovimentoorigem(this, entidadesmovimentos2);
        this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_movimentoorigem, (Object)entidadesmovimentos, (Object)entidadesmovimentos2);
    }

    public Artigosmovimentos getMovimentoorigem2() {
        return Entidadesdocumentoslinhas.jdoGetmovimentoorigem2(this);
    }

    public void setMovimentoorigem2(Artigosmovimentos movimentoorigem2) {
        Artigosmovimentos artigosmovimentos = Entidadesdocumentoslinhas.jdoGetmovimentoorigem2(this);
        Artigosmovimentos artigosmovimentos2 = movimentoorigem2;
        Entidadesdocumentoslinhas.jdoSetmovimentoorigem2(this, artigosmovimentos2);
        this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_movimentoorigem2, (Object)artigosmovimentos, (Object)artigosmovimentos2);
    }

    public Artigosmovimentos getMovimentoartigos() {
        return Entidadesdocumentoslinhas.jdoGetmovimentoartigos(this);
    }

    void setMovimentoartigos(Artigosmovimentos movimentoartigos) {
        Artigosmovimentos artigosmovimentos = Entidadesdocumentoslinhas.jdoGetmovimentoartigos(this);
        Artigosmovimentos artigosmovimentos2 = movimentoartigos;
        Entidadesdocumentoslinhas.jdoSetmovimentoartigos(this, artigosmovimentos2);
        this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_movimentoartigos, (Object)artigosmovimentos, (Object)artigosmovimentos2);
    }

    public Entidadesdocumentos getDocumento() {
        return Entidadesdocumentoslinhas.jdoGetdocumento(this);
    }

    public void setDocumento(Entidadesdocumentos documento) {
        Entidadesdocumentos entidadesdocumentos = Entidadesdocumentoslinhas.jdoGetdocumento(this);
        Entidadesdocumentos entidadesdocumentos2 = documento;
        Entidadesdocumentoslinhas.jdoSetdocumento(this, entidadesdocumentos2);
        this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_documento, (Object)entidadesdocumentos, (Object)entidadesdocumentos2);
        this.setKey();
    }

    public Artigos getArtigo() {
        return Entidadesdocumentoslinhas.jdoGetartigo(this);
    }

    public boolean hasArtigo() {
        return Entidadesdocumentoslinhas.jdoGetartigo(this) != null;
    }

    public void setArtigo(Artigos artigo, Unidadesmedida unidademedida) {
        Artigos artigos = Entidadesdocumentoslinhas.jdoGetartigo(this);
        Artigos artigos2 = artigo;
        Entidadesdocumentoslinhas.jdoSetartigo(this, artigos2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_artigo, (Object)artigos, (Object)artigos2);
        if (Entidadesdocumentoslinhas.jdoGetdocumento((Entidadesdocumentoslinhas)this).cascade && this.cascade && changed && artigo != null) {
            this.setDescricao(artigo.getDescricao());
            this.setQuantidade(BigDecimal.ONE);
            this.setUnidademedida(unidademedida);
            if (Entidadesdocumentoslinhas.jdoGetdocumento(this).getEntidade() != null) {
                switch (Entidadesdocumentoslinhas.jdoGetdocumento(this).getEntidade().getTipoiva()) {
                    case 0: {
                        this.setCodigoiva(artigo);
                        break;
                    }
                    case 1: {
                        this.setCodigoiva(Entidadesdocumentoslinhas.jdoGetdocumento(this).getEntidade());
                    }
                }
            }
            this.setPreco$Entidade();
        }
    }

    public void setArtigo(Artigos artigo) {
        this.setArtigo(artigo, artigo == null ? null : artigo.getUnidades(0).getUnidademedida());
    }

    @Deprecated
    public boolean setArtigo$Codigobarras(String codigo) {
        Artigosunidades unidade = this.manager.loadArtigosunidades$Codigobarras(codigo);
        if (unidade != null) {
            Artigos artigo = this.manager.loadArtigos(unidade.getArtigo().getCodigo(), false);
            this.setArtigo(artigo, unidade.getUnidademedida());
            return true;
        }
        return false;
    }

    public boolean setArtigo(String codigo) {
        Artigos artigo = this.manager.loadArtigos(codigo, false);
        if (artigo != null) {
            this.setArtigo(artigo);
            return true;
        }
        return this.setArtigo$Codigobarras(codigo);
    }

    public Unidadesmedida getUnidademedida() {
        return Entidadesdocumentoslinhas.jdoGetunidademedida(this);
    }

    public void setUnidademedida(Unidadesmedida unidademedida) {
        Unidadesmedida unidadesmedida = Entidadesdocumentoslinhas.jdoGetunidademedida(this);
        Unidadesmedida unidadesmedida2 = unidademedida;
        Entidadesdocumentoslinhas.jdoSetunidademedida(this, unidadesmedida2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_unidademedida, (Object)unidadesmedida, (Object)unidadesmedida2);
        if (Entidadesdocumentoslinhas.jdoGetdocumento((Entidadesdocumentoslinhas)this).cascade && this.cascade && changed && unidademedida != null && Entidadesdocumentoslinhas.jdoGetartigo(this) != null) {
            Artigosunidades unidade = Entidadesdocumentoslinhas.jdoGetartigo(this).getUnidades(unidademedida);
            if (unidade == null) {
                this.setUnidademedida(Entidadesdocumentoslinhas.jdoGetartigo(this).getUnidades(0).getUnidademedida());
            } else {
                this.setFactor(unidade.getFactor());
                this.setQuantidade(unidademedida);
                this.setPreco$Entidade();
            }
        }
    }

    public Armazens getArmazem() {
        return Entidadesdocumentoslinhas.jdoGetarmazem(this);
    }

    public void setArmazem(Armazens armazem) {
        Armazens armazens = Entidadesdocumentoslinhas.jdoGetarmazem(this);
        Armazens armazens2 = armazem;
        Entidadesdocumentoslinhas.jdoSetarmazem(this, armazens2);
        this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_armazem, (Object)armazens, (Object)armazens2);
    }

    public Tamanhos getTamanho() {
        return Entidadesdocumentoslinhas.jdoGettamanho(this);
    }

    public void setTamanho(Tamanhos tamanho) {
        Tamanhos tamanhos = Entidadesdocumentoslinhas.jdoGettamanho(this);
        Tamanhos tamanhos2 = tamanho;
        Entidadesdocumentoslinhas.jdoSettamanho(this, tamanhos2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_tamanho, (Object)tamanhos, (Object)tamanhos2);
        if (Entidadesdocumentoslinhas.jdoGetdocumento((Entidadesdocumentoslinhas)this).cascade && this.cascade && changed && tamanho != null) {
            this.setPreco$Entidade();
        }
    }

    public Cores getCor() {
        return Entidadesdocumentoslinhas.jdoGetcor(this);
    }

    public void setCor(Cores cor) {
        Cores cores = Entidadesdocumentoslinhas.jdoGetcor(this);
        Cores cores2 = cor;
        Entidadesdocumentoslinhas.jdoSetcor(this, cores2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_cor, (Object)cores, (Object)cores2);
        if (Entidadesdocumentoslinhas.jdoGetdocumento((Entidadesdocumentoslinhas)this).cascade && this.cascade && changed && cor != null) {
            this.setPreco$Entidade();
        }
    }

    public Codigosiva getCodigoiva() {
        return Entidadesdocumentoslinhas.jdoGetcodigoiva(this);
    }

    public void setCodigoiva(Codigosiva codigoiva) {
        Codigosiva codigosiva = Entidadesdocumentoslinhas.jdoGetcodigoiva(this);
        Codigosiva codigosiva2 = codigoiva;
        Entidadesdocumentoslinhas.jdoSetcodigoiva(this, codigosiva2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_codigoiva, (Object)codigosiva, (Object)codigosiva2);
        if (Entidadesdocumentoslinhas.jdoGetdocumento((Entidadesdocumentoslinhas)this).cascade && this.cascade && changed && codigoiva != null) {
            this.setPrecoiva(BusinessRules.valueAdded((BigDecimal)Entidadesdocumentoslinhas.jdoGetpreco(this), (BigDecimal)codigoiva.getTaxa()));
            this.setIsencaoiva(codigoiva);
            this.process();
        }
    }

    public void setCodigoiva(Codigosiva codigoiva, Isencoesiva isencao) {
        this.setCodigoiva(codigoiva);
        if (!codigoiva.hasTaxa()) {
            this.setIsencaoiva(isencao);
        }
    }

    private void setCodigoiva(Artigos artigo) {
        this.setCodigoiva(artigo.getCodigoiva(), artigo.getIsencaoiva());
    }

    private void setCodigoiva(Entidades entidade) {
        this.setCodigoiva(entidade.getCodigoiva(), entidade.getIsencaoiva());
    }

    public boolean isCodigoivaValid() {
        return !this.isTipo(1) || Entidadesdocumentoslinhas.jdoGetcodigoiva(this) != null && Entidadesdocumentoslinhas.jdoGetcodigoiva(this).isValid(Entidadesdocumentoslinhas.jdoGetisencaoiva(this));
    }

    public Isencoesiva getIsencaoiva() {
        return Entidadesdocumentoslinhas.jdoGetisencaoiva(this);
    }

    public void setIsencaoiva(Isencoesiva isencaoiva) {
        Isencoesiva isencoesiva = Entidadesdocumentoslinhas.jdoGetisencaoiva(this);
        Isencoesiva isencoesiva2 = isencaoiva;
        Entidadesdocumentoslinhas.jdoSetisencaoiva(this, isencoesiva2);
        this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_isencaoiva, (Object)isencoesiva, (Object)isencoesiva2);
    }

    public void setIsencaoiva(Isencoesiva.MOTIVOS_AT motivo) {
        this.setIsencaoiva(this.manager.loadIsencoesiva(motivo.name()));
    }

    public void setIsencaoiva(Codigosiva codigoiva) {
        switch (codigoiva.getTipotaxa()) {
            default: {
                this.setIsencaoiva(Isencoesiva.MOTIVOS_AT.M00);
                break;
            }
            case 3: {
                this.setIsencaoiva(Isencoesiva.MOTIVOS_AT.M10);
                break;
            }
            case 5: {
                this.setIsencaoiva(Isencoesiva.MOTIVOS_AT.M99);
            }
        }
    }

    public boolean isIsencaoivaValid() {
        return Entidadesdocumentoslinhas.jdoGetisencaoiva(this) == null || Entidadesdocumentoslinhas.jdoGetisencaoiva(this).isValid(Entidadesdocumentoslinhas.jdoGetdocumento(this).getDatacriacao());
    }

    public boolean isIsencaoiva() {
        return this.isTipo(1) && Entidadesdocumentoslinhas.jdoGetisencaoiva(this) != null && !Entidadesdocumentoslinhas.jdoGetisencaoiva(this).isMotivo(Isencoesiva.MOTIVOS_AT.M00) && !Entidadesdocumentoslinhas.jdoGetcodigoiva(this).hasTaxa();
    }

    public Date getDatadocumento() {
        return Entidadesdocumentoslinhas.jdoGetdatadocumento(this);
    }

    public String getDatadocumentoToText() {
        return Entidadesdocumentoslinhas.jdoGetdatadocumento(this) == null ? "" : FIELDS.entidadesdocumentoslinhas_datadocumento.format.format(Entidadesdocumentoslinhas.jdoGetdatadocumento(this));
    }

    public void setDatadocumento(Date datadocumento) {
        Date date = Entidadesdocumentoslinhas.jdoGetdatadocumento(this);
        Date date2 = TimeDateUtils.getDateWithoutTime((Date)datadocumento);
        Entidadesdocumentoslinhas.jdoSetdatadocumento(this, date2);
        this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_datadocumento, (Object)date, (Object)date2);
    }

    @Deprecated
    public Date getDataauxiliar() {
        return Entidadesdocumentoslinhas.jdoGetdatadocumento(this);
    }

    public String getDescricao() {
        return Entidadesdocumentoslinhas.jdoGetdescricao(this);
    }

    public String getDescricaoToText() {
        return Entidadesdocumentoslinhas.jdoGetdescricao(this) == null ? "" : FIELDS.entidadesdocumentoslinhas_descricao.format.format(Entidadesdocumentoslinhas.jdoGetdescricao(this));
    }

    public void setDescricao(String descricao) {
        String string = Entidadesdocumentoslinhas.jdoGetdescricao(this);
        String string2 = descricao;
        Entidadesdocumentoslinhas.jdoSetdescricao(this, string2);
        this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_descricao, (Object)string, (Object)string2);
    }

    public void setDescricao(Entidadesdocumentos documento) {
        this.setDescricao(String.valueOf(documento.getTipodocumento().getDescricao()) + " " + documento.toString() + " " + LABELS.preposicao_de.toString() + " " + documento.getDatacriacaoToText());
    }

    public void setDescricao(Entidadesmovimentos movimento) {
        String descricao = String.valueOf(movimento.getTipodocumento().getDescricao()) + " " + movimento.toString();
        if (Entidadesdocumentoslinhas.jdoGetdocumento(this).getTipodocumento().getTipoentidade().isTipoentidade(1) && !movimento.getNumeroauxiliarToText().isEmpty()) {
            descricao = String.valueOf(descricao) + " (" + movimento.getNumeroauxiliarToText() + " " + LABELS.preposicao_de.toString() + " " + movimento.getDataauxiliarToText() + ")";
        }
        this.setDescricao(descricao);
    }

    public boolean isDescricaoValid() {
        return !Entidadesdocumentoslinhas.jdoGetdescricao(this).isEmpty() || this.isTipo(2);
    }

    public String getNumeroserie() {
        return Entidadesdocumentoslinhas.jdoGetnumeroserie(this);
    }

    public String getNumeroserieToText() {
        return Entidadesdocumentoslinhas.jdoGetnumeroserie(this) == null ? "" : Entidadesdocumentoslinhas.jdoGetnumeroserie(this).toString();
    }

    public void setNumeroserie(String numeroserie) {
        String string = Entidadesdocumentoslinhas.jdoGetnumeroserie(this);
        String string2 = numeroserie;
        Entidadesdocumentoslinhas.jdoSetnumeroserie(this, string2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_numeroserie, (Object)string, (Object)string2);
        if (Entidadesdocumentoslinhas.jdoGetdocumento((Entidadesdocumentoslinhas)this).cascade && this.cascade && changed && numeroserie.isEmpty()) {
            this.setNumeroserie("0");
        }
    }

    public void setNumeroserie(Artigosexistencias existencias) {
        this.setNumeroserie(existencias.getNumeroserie());
        this.setArmazem(existencias.getArmazem());
        this.setTamanho(existencias.getTamanho());
        this.setCor(existencias.getCor());
    }

    public String getCampo1() {
        return Entidadesdocumentoslinhas.jdoGetcampo1(this);
    }

    public String getCampo1ToText() {
        return Entidadesdocumentoslinhas.jdoGetcampo1(this) == null ? "" : Entidadesdocumentoslinhas.jdoGetcampo1(this).toString();
    }

    public void setCampo1(String campo1) {
        String string = Entidadesdocumentoslinhas.jdoGetcampo1(this);
        String string2 = campo1;
        Entidadesdocumentoslinhas.jdoSetcampo1(this, string2);
        this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_campo1, (Object)string, (Object)string2);
    }

    public String getCampo2() {
        return Entidadesdocumentoslinhas.jdoGetcampo2(this);
    }

    public String getCampo2ToText() {
        return Entidadesdocumentoslinhas.jdoGetcampo2(this) == null ? "" : Entidadesdocumentoslinhas.jdoGetcampo2(this).toString();
    }

    public void setCampo2(String campo2) {
        String string = Entidadesdocumentoslinhas.jdoGetcampo2(this);
        String string2 = campo2;
        Entidadesdocumentoslinhas.jdoSetcampo2(this, string2);
        this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_campo2, (Object)string, (Object)string2);
    }

    public String getCampo3() {
        return Entidadesdocumentoslinhas.jdoGetcampo3(this);
    }

    public String getCampo3ToText() {
        return Entidadesdocumentoslinhas.jdoGetcampo3(this) == null ? "" : Entidadesdocumentoslinhas.jdoGetcampo3(this).toString();
    }

    public void setCampo3(String campo3) {
        String string = Entidadesdocumentoslinhas.jdoGetcampo3(this);
        String string2 = campo3;
        Entidadesdocumentoslinhas.jdoSetcampo3(this, string2);
        this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_campo3, (Object)string, (Object)string2);
    }

    public String getCampo4() {
        return Entidadesdocumentoslinhas.jdoGetcampo4(this);
    }

    public String getCampo4ToText() {
        return Entidadesdocumentoslinhas.jdoGetcampo4(this) == null ? "" : Entidadesdocumentoslinhas.jdoGetcampo4(this).toString();
    }

    public void setCampo4(String campo4) {
        String string = Entidadesdocumentoslinhas.jdoGetcampo4(this);
        String string2 = campo4;
        Entidadesdocumentoslinhas.jdoSetcampo4(this, string2);
        this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_campo4, (Object)string, (Object)string2);
    }

    public String getCampo5() {
        return Entidadesdocumentoslinhas.jdoGetcampo5(this);
    }

    public String getCampo5ToText() {
        return Entidadesdocumentoslinhas.jdoGetcampo5(this) == null ? "" : Entidadesdocumentoslinhas.jdoGetcampo5(this).toString();
    }

    public void setCampo5(String campo5) {
        String string = Entidadesdocumentoslinhas.jdoGetcampo5(this);
        String string2 = campo5;
        Entidadesdocumentoslinhas.jdoSetcampo5(this, string2);
        this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_campo5, (Object)string, (Object)string2);
    }

    public Integer getNumerolinha() {
        return Entidadesdocumentoslinhas.jdoGetnumerolinha(this);
    }

    public String getNumerolinhaToText() {
        return Entidadesdocumentoslinhas.jdoGetnumerolinha(this) == null ? "" : Entidadesdocumentoslinhas.jdoGetnumerolinha(this).toString();
    }

    protected void setNumerolinha(Integer numerolinha) {
        Integer n = Entidadesdocumentoslinhas.jdoGetnumerolinha(this);
        Integer n2 = numerolinha;
        Entidadesdocumentoslinhas.jdoSetnumerolinha(this, n2);
        this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_numerolinha, (Object)n, (Object)n2);
        this.setKey();
    }

    public Integer getTipo() {
        return Entidadesdocumentoslinhas.jdoGettipo(this);
    }

    public String getTipoToText() {
        return Entidadesdocumentoslinhas.jdoGettipo(this) == null ? "" : FIELDS.entidadesdocumentoslinhas_tipo.values[Entidadesdocumentoslinhas.jdoGettipo(this)];
    }

    public void setTipo(Integer tipo) {
        Integer n = Entidadesdocumentoslinhas.jdoGettipo(this);
        Integer n2 = tipo;
        Entidadesdocumentoslinhas.jdoSettipo(this, n2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_tipo, (Object)n, (Object)n2);
        if (Entidadesdocumentoslinhas.jdoGetdocumento((Entidadesdocumentoslinhas)this).cascade && this.cascade && changed) {
            this.setPercdesconto(this.isTipo(1) && Entidadesdocumentoslinhas.jdoGetdocumento(this).getEntidade() != null ? Entidadesdocumentoslinhas.jdoGetdocumento(this).getEntidade().getDesconto(Entidadesdocumentoslinhas.jdoGetdocumento(this).getTipodocumento()) : BigDecimal.ZERO);
        }
    }

    public boolean isTipo(Integer tipo) {
        return Entidadesdocumentoslinhas.equals(tipo, Entidadesdocumentoslinhas.jdoGettipo(this));
    }

    public BigDecimal getFactor() {
        return Entidadesdocumentoslinhas.jdoGetfactor(this);
    }

    public String getFactorToText() {
        return Entidadesdocumentoslinhas.jdoGetfactor(this) == null ? "" : FIELDS.entidadesdocumentoslinhas_factor.format.format(Entidadesdocumentoslinhas.jdoGetfactor(this));
    }

    public void setFactor(BigDecimal factor) {
        BigDecimal bigDecimal = Entidadesdocumentoslinhas.jdoGetfactor(this);
        BigDecimal bigDecimal2 = factor;
        Entidadesdocumentoslinhas.jdoSetfactor(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_factor, (Object)bigDecimal, (Object)bigDecimal2);
        if (Entidadesdocumentoslinhas.jdoGetdocumento((Entidadesdocumentoslinhas)this).cascade && this.cascade && changed) {
            this.setPreco$Entidade();
        }
    }

    public BigDecimal getQuantidade() {
        return Entidadesdocumentoslinhas.jdoGetquantidade(this);
    }

    public String getQuantidadeToText() {
        return Entidadesdocumentoslinhas.jdoGetquantidade(this) == null ? "" : FIELDS.entidadesdocumentoslinhas_quantidade.format.format(Entidadesdocumentoslinhas.jdoGetquantidade(this));
    }

    public void setQuantidade(BigDecimal quantidade) {
        BigDecimal bigDecimal = Entidadesdocumentoslinhas.jdoGetquantidade(this);
        BigDecimal bigDecimal2 = quantidade;
        Entidadesdocumentoslinhas.jdoSetquantidade(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_quantidade, (Object)bigDecimal, (Object)bigDecimal2);
        if (Entidadesdocumentoslinhas.jdoGetdocumento((Entidadesdocumentoslinhas)this).cascade && this.cascade && changed) {
            this.setTipo(quantidade.signum() == 0 ? 2 : 1);
            this.process();
        }
    }

    public void addQuantidade(BigDecimal quantidade) {
        this.setQuantidade(Entidadesdocumentoslinhas.jdoGetquantidade(this).add(quantidade));
    }

    public boolean hasQuantidade() {
        return Entidadesdocumentoslinhas.jdoGetquantidade(this).signum() != 0;
    }

    public void setQuantidade(Unidadesmedida unidademedida) {
        if (unidademedida != null && !unidademedida.getFormulaToText().isEmpty()) {
            Debug.out((String)"formula", (Object)unidademedida.getFormulaToText());
            MathFormula mf = new MathFormula(unidademedida.getFormulaToText(), true);
            BigDecimal valor = mf.eval(new MathFormula.FormulaSymbol[]{new MathFormula.FormulaSymbol(unidademedida.getVariavel1(), Entidadesdocumentoslinhas.jdoGetformulavalor1(this)), new MathFormula.FormulaSymbol(unidademedida.getVariavel2(), Entidadesdocumentoslinhas.jdoGetformulavalor2(this)), new MathFormula.FormulaSymbol(unidademedida.getVariavel3(), Entidadesdocumentoslinhas.jdoGetformulavalor3(this)), new MathFormula.FormulaSymbol(unidademedida.getVariavel4(), Entidadesdocumentoslinhas.jdoGetformulavalor4(this))});
            Debug.out((String)"valor", (Object)valor);
            this.setQuantidade(Entidadesdocumentoslinhas.jdoGetformulaquant(this).multiply(valor));
        }
    }

    public BigDecimal getPrecocusto() {
        return Entidadesdocumentoslinhas.jdoGetartigo(this) == null ? BigDecimal.ZERO : Entidadesdocumentoslinhas.jdoGetartigo(this).getPrecocusto(Entidadesdocumentoslinhas.jdoGetunidademedida(this));
    }

    public String getPrecocustoToText() {
        return FIELDS.entidadesdocumentoslinhas_precocusto.format.format(this.getPrecocusto());
    }

    public BigDecimal getPreco() {
        return Entidadesdocumentoslinhas.jdoGetpreco(this);
    }

    public String getPrecoToText() {
        return Entidadesdocumentoslinhas.jdoGetpreco(this) == null ? "" : FIELDS.entidadesdocumentoslinhas_preco.format.format(Entidadesdocumentoslinhas.jdoGetpreco(this));
    }

    public void setPreco(BigDecimal preco) {
        BigDecimal bigDecimal = Entidadesdocumentoslinhas.jdoGetpreco(this);
        BigDecimal bigDecimal2 = preco;
        Entidadesdocumentoslinhas.jdoSetpreco(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_preco, (Object)bigDecimal, (Object)bigDecimal2);
        if (Entidadesdocumentoslinhas.jdoGetdocumento((Entidadesdocumentoslinhas)this).cascade && this.cascade && changed) {
            this.setPreco2(preco.multiply(Entidadesdocumentoslinhas.jdoGetdocumento(this).getCambio().getCambio()));
            if (Entidadesdocumentoslinhas.jdoGetcodigoiva(this) != null) {
                this.setPrecoiva(BusinessRules.valueAdded((BigDecimal)preco, (BigDecimal)Entidadesdocumentoslinhas.jdoGetcodigoiva(this).getTaxa()));
            }
            this.process();
        }
    }

    public void setPreco(Entidadesartigos artigo) {
        this.setPreco(artigo.getPreco());
        this.setPercdesconto(artigo.getPercdesconto());
        this.setPercdesconto2(artigo.getPercdesconto2());
        this.setUnidademedida(artigo.getUnidademedida());
    }

    private boolean setPreco$Historico() {
        Entidadesartigos artigo;
        Entidadesartigos entidadesartigos = artigo = Entidadesdocumentoslinhas.jdoGetartigo(this) == null ? null : this.manager.loadEntidadesartigos(Entidadesartigos.generateKey(Entidadesdocumentoslinhas.jdoGetdocumento(this).getEntidade().getKey(), Entidadesdocumentoslinhas.jdoGetartigo(this).getCodigo(), Entidadesdocumentoslinhas.jdoGetunidademedida(this).getCodigo()));
        if (artigo != null) {
            this.setPreco(artigo);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setPreco$Entidade() {
        if (Entidadesdocumentoslinhas.jdoGetdocumento(this).getTipodocumento().isTipodocumento(2) || Entidadesdocumentoslinhas.jdoGetdocumento(this).getEntidade() == null) return;
        block0 : switch (Entidadesdocumentoslinhas.jdoGetdocumento(this).getEntidade().getTipopreco()) {
            case 0: {
                if (Entidadesdocumentoslinhas.jdoGetartigo(this) == null) return;
                switch (Entidadesdocumentoslinhas.jdoGetdocumento(this).getTipoentidade().getTipoentidade()) {
                    case 0: {
                        Artigosprecos preco = Entidadesdocumentoslinhas.jdoGetartigo(this).getPrecos(Artigosprecos.generateKey(Entidadesdocumentoslinhas.jdoGetartigo(this).getCodigo(), Entidadesdocumentoslinhas.jdoGetdocumento(this).getEntidade().getPrecario().getCodigo(), Entidadesdocumentoslinhas.jdoGetunidademedida(this).getCodigo(), Entidadesdocumentoslinhas.jdoGettamanho(this).getCodigo(), Entidadesdocumentoslinhas.jdoGetcor(this).getCodigo()));
                        this.setPreco(preco == null ? Entidadesdocumentoslinhas.jdoGetartigo(this).getPrecoupv().multiply(Entidadesdocumentoslinhas.jdoGetfactor(this)) : preco.getPrecopvp());
                        return;
                    }
                    case 1: {
                        this.setPreco(Entidadesdocumentoslinhas.jdoGetartigo(this).getPrecocusto(Entidadesdocumentoslinhas.jdoGetunidademedida(this)));
                    }
                }
                return;
            }
            case 1: {
                if (Entidadesdocumentoslinhas.jdoGetartigo(this) == null) return;
                switch (this.manager.getParametros().getSugestaoprecos()) {
                    case 0: {
                        this.setPreco$Historico();
                        break block0;
                    }
                    case 1: {
                        if (this.setPreco$Historico()) return;
                        switch (Entidadesdocumentoslinhas.jdoGetdocumento(this).getTipoentidade().getTipoentidade()) {
                            case 0: {
                                this.setPreco(Entidadesdocumentoslinhas.jdoGetartigo(this).getPrecoupv().multiply(Entidadesdocumentoslinhas.jdoGetfactor(this)));
                                break block0;
                            }
                            case 1: {
                                this.setPreco(Entidadesdocumentoslinhas.jdoGetartigo(this).getPrecoupc().multiply(Entidadesdocumentoslinhas.jdoGetfactor(this)));
                            }
                        }
                    }
                }
            }
        }
    }

    public BigDecimal getPreco2() {
        return Entidadesdocumentoslinhas.jdoGetpreco2(this);
    }

    public String getPreco2ToText() {
        return Entidadesdocumentoslinhas.jdoGetpreco2(this) == null ? "" : FIELDS.entidadesdocumentoslinhas_preco2.format.format(Entidadesdocumentoslinhas.jdoGetpreco2(this));
    }

    public void setPreco2(BigDecimal preco2) {
        BigDecimal bigDecimal = Entidadesdocumentoslinhas.jdoGetpreco2(this);
        BigDecimal bigDecimal2 = preco2;
        Entidadesdocumentoslinhas.jdoSetpreco2(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_preco2, (Object)bigDecimal, (Object)bigDecimal2);
        if (Entidadesdocumentoslinhas.jdoGetdocumento((Entidadesdocumentoslinhas)this).cascade && this.cascade && changed) {
            this.setPreco(preco2.divide(Entidadesdocumentoslinhas.jdoGetdocumento(this).getCambio().getCambio(), MathContext.DECIMAL64));
            this.process();
        }
    }

    public BigDecimal getPrecoiva() {
        return Entidadesdocumentoslinhas.jdoGetprecoiva(this);
    }

    public String getPrecoivaToText() {
        return Entidadesdocumentoslinhas.jdoGetprecoiva(this) == null ? "" : FIELDS.entidadesdocumentoslinhas_precoiva.format.format(Entidadesdocumentoslinhas.jdoGetprecoiva(this));
    }

    public void setPrecoiva(BigDecimal precoiva) {
        BigDecimal bigDecimal = Entidadesdocumentoslinhas.jdoGetprecoiva(this);
        BigDecimal bigDecimal2 = FIELDS.entidadesdocumentoslinhas_precoiva.format.setScale(precoiva, RoundingMode.HALF_UP);
        Entidadesdocumentoslinhas.jdoSetprecoiva(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_precoiva, (Object)bigDecimal, (Object)bigDecimal2);
        if (Entidadesdocumentoslinhas.jdoGetdocumento((Entidadesdocumentoslinhas)this).cascade && this.cascade && changed) {
            if (Entidadesdocumentoslinhas.jdoGetcodigoiva(this) != null) {
                this.setPreco(BusinessRules.valueExcluded((BigDecimal)Entidadesdocumentoslinhas.jdoGetprecoiva(this), (BigDecimal)Entidadesdocumentoslinhas.jdoGetcodigoiva(this).getTaxa()));
            }
            this.process();
        }
    }

    public BigDecimal getPrecoliquido() {
        return this.hasQuantidade() ? Entidadesdocumentoslinhas.jdoGetvalorliquido(this).divide(Entidadesdocumentoslinhas.jdoGetquantidade(this), MathContext.DECIMAL64) : BigDecimal.ZERO;
    }

    public String getPrecoliquidoToText() {
        return FIELDS.entidadesdocumentoslinhas_precoliquido.format.format(this.getPrecoliquido());
    }

    public BigDecimal getValoriliquido() {
        return Entidadesdocumentoslinhas.jdoGetvaloriliquido(this);
    }

    public String getValoriliquidoToText() {
        return Entidadesdocumentoslinhas.jdoGetvaloriliquido(this) == null ? "" : FIELDS.entidadesdocumentoslinhas_valoriliquido.format.format(Entidadesdocumentoslinhas.jdoGetvaloriliquido(this));
    }

    public void setValoriliquido(BigDecimal valoriliquido) {
        BigDecimal bigDecimal = Entidadesdocumentoslinhas.jdoGetvaloriliquido(this);
        BigDecimal bigDecimal2 = valoriliquido;
        Entidadesdocumentoslinhas.jdoSetvaloriliquido(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_valoriliquido, (Object)bigDecimal, (Object)bigDecimal2);
        if (Entidadesdocumentoslinhas.jdoGetdocumento((Entidadesdocumentoslinhas)this).cascade && this.cascade && changed) {
            if (this.hasQuantidade()) {
                this.setPreco(valoriliquido.divide(Entidadesdocumentoslinhas.jdoGetquantidade(this), MathContext.DECIMAL64));
            }
            this.process();
        }
    }

    public BigDecimal getValoriliquidoiva() {
        return Entidadesdocumentoslinhas.jdoGetvaloriliquidoiva(this);
    }

    public String getValoriliquidoivaToText() {
        return Entidadesdocumentoslinhas.jdoGetvaloriliquidoiva(this) == null ? "" : FIELDS.entidadesdocumentoslinhas_valoriliquidoiva.format.format(Entidadesdocumentoslinhas.jdoGetvaloriliquidoiva(this));
    }

    public void setValoriliquidoiva(BigDecimal valoriliquidoiva) {
        BigDecimal bigDecimal = Entidadesdocumentoslinhas.jdoGetvaloriliquidoiva(this);
        BigDecimal bigDecimal2 = valoriliquidoiva;
        Entidadesdocumentoslinhas.jdoSetvaloriliquidoiva(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_valoriliquidoiva, (Object)bigDecimal, (Object)bigDecimal2);
        if (Entidadesdocumentoslinhas.jdoGetdocumento((Entidadesdocumentoslinhas)this).cascade && this.cascade && changed) {
            if (this.hasQuantidade()) {
                this.setPrecoiva(valoriliquidoiva.divide(Entidadesdocumentoslinhas.jdoGetquantidade(this), MathContext.DECIMAL64));
            }
            this.process();
        }
    }

    @Deprecated
    public BigDecimal getValorpagar() {
        return this.valoriliquidoiva2;
    }

    public BigDecimal getValoriliquidoiva2() {
        return this.valoriliquidoiva2;
    }

    public void setValoriliquidoiva2(BigDecimal valoriliquidoiva2) {
        this.valoriliquidoiva2 = valoriliquidoiva2;
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_valoriliquidoiva2, (Object)this.valoriliquidoiva2, (Object)this.valoriliquidoiva2);
        if (Entidadesdocumentoslinhas.jdoGetdocumento((Entidadesdocumentoslinhas)this).cascade && this.cascade && changed && Entidadesdocumentoslinhas.jdoGetmovimentoorigem(this) != null) {
            BigDecimal valoriliquidoiva = BusinessRules.proportionalValue((BigDecimal)Entidadesdocumentoslinhas.jdoGetmovimentoorigem(this).getTotal(), (BigDecimal)Entidadesdocumentoslinhas.jdoGetmovimentoorigem(this).getTotalbruto(), (BigDecimal)valoriliquidoiva2);
            this.setValoriliquidoiva(valoriliquidoiva.signum() == 0 ? Entidadesdocumentoslinhas.jdoGetmovimentoorigem(this).getValorpendente() : valoriliquidoiva.min(Entidadesdocumentoslinhas.jdoGetmovimentoorigem(this).getValorpendente()));
        }
    }

    public BigDecimal getPercdesconto() {
        return Entidadesdocumentoslinhas.jdoGetpercdesconto(this);
    }

    public String getPercdescontoToText() {
        return Entidadesdocumentoslinhas.jdoGetpercdesconto(this) == null ? "" : FIELDS.entidadesdocumentoslinhas_percdesconto.format.format(Entidadesdocumentoslinhas.jdoGetpercdesconto(this));
    }

    public void setPercdesconto(BigDecimal percdesconto) {
        BigDecimal bigDecimal = Entidadesdocumentoslinhas.jdoGetpercdesconto(this);
        BigDecimal bigDecimal2 = percdesconto;
        Entidadesdocumentoslinhas.jdoSetpercdesconto(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_percdesconto, (Object)bigDecimal, (Object)bigDecimal2);
        if (Entidadesdocumentoslinhas.jdoGetdocumento((Entidadesdocumentoslinhas)this).cascade && this.cascade && changed) {
            this.process();
        }
    }

    public BigDecimal getPercdesconto2() {
        return Entidadesdocumentoslinhas.jdoGetpercdesconto2(this);
    }

    public String getPercdesconto2ToText() {
        return Entidadesdocumentoslinhas.jdoGetpercdesconto2(this) == null ? "" : FIELDS.entidadesdocumentoslinhas_percdesconto2.format.format(Entidadesdocumentoslinhas.jdoGetpercdesconto2(this));
    }

    public void setPercdesconto2(BigDecimal percdesconto2) {
        BigDecimal bigDecimal = Entidadesdocumentoslinhas.jdoGetpercdesconto2(this);
        BigDecimal bigDecimal2 = percdesconto2;
        Entidadesdocumentoslinhas.jdoSetpercdesconto2(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_percdesconto2, (Object)bigDecimal, (Object)bigDecimal2);
        if (Entidadesdocumentoslinhas.jdoGetdocumento((Entidadesdocumentoslinhas)this).cascade && this.cascade && changed) {
            this.process();
        }
    }

    public BigDecimal getPercdescontofinal() {
        return BusinessRules.addedPercentages((BigDecimal)Entidadesdocumentoslinhas.jdoGetpercdesconto(this), (BigDecimal)Entidadesdocumentoslinhas.jdoGetpercdesconto2(this));
    }

    public String getPercdescontofinalToText() {
        return FIELDS.entidadesdocumentoslinhas_percdescontofinal.format.format(this.getPercdescontofinal());
    }

    public BigDecimal getValordesconto() {
        return Entidadesdocumentoslinhas.jdoGetvalordesconto(this);
    }

    public String getValordescontoToText() {
        return Entidadesdocumentoslinhas.jdoGetvalordesconto(this) == null ? "" : FIELDS.entidadesdocumentoslinhas_valordesconto.format.format(Entidadesdocumentoslinhas.jdoGetvalordesconto(this));
    }

    public void setValordesconto(BigDecimal valordesconto) {
        BigDecimal bigDecimal = Entidadesdocumentoslinhas.jdoGetvalordesconto(this);
        BigDecimal bigDecimal2 = valordesconto;
        Entidadesdocumentoslinhas.jdoSetvalordesconto(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_valordesconto, (Object)bigDecimal, (Object)bigDecimal2);
        if (Entidadesdocumentoslinhas.jdoGetdocumento((Entidadesdocumentoslinhas)this).cascade && this.cascade && changed) {
            this.setPercdesconto(BusinessRules.valuePercentage((BigDecimal)Entidadesdocumentoslinhas.jdoGetvaloriliquido(this), (BigDecimal)valordesconto));
            this.process();
        }
    }

    public BigDecimal getValorliquido() {
        return Entidadesdocumentoslinhas.jdoGetvalorliquido(this);
    }

    public String getValorliquidoToText() {
        return Entidadesdocumentoslinhas.jdoGetvalorliquido(this) == null ? "" : FIELDS.entidadesdocumentoslinhas_valorliquido.format.format(Entidadesdocumentoslinhas.jdoGetvalorliquido(this));
    }

    public void setValorliquido(BigDecimal valorliquido) {
        BigDecimal bigDecimal = Entidadesdocumentoslinhas.jdoGetvalorliquido(this);
        BigDecimal bigDecimal2 = valorliquido;
        Entidadesdocumentoslinhas.jdoSetvalorliquido(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_valorliquido, (Object)bigDecimal, (Object)bigDecimal2);
        if (Entidadesdocumentoslinhas.jdoGetdocumento((Entidadesdocumentoslinhas)this).cascade && this.cascade && changed) {
            this.process();
        }
    }

    public BigDecimal getValorliquidoiva() {
        return Entidadesdocumentoslinhas.jdoGetvalorliquido(this).add(Entidadesdocumentoslinhas.jdoGetvaloriva(this));
    }

    public String getValorliquidoivaToText() {
        return FIELDS.entidadesdocumentoslinhas_valorliquidoiva.format.format(this.getValorliquidoiva());
    }

    public BigDecimal getValoriva() {
        return Entidadesdocumentoslinhas.jdoGetvaloriva(this);
    }

    public String getValorivaToText() {
        return Entidadesdocumentoslinhas.jdoGetvaloriva(this) == null ? "" : FIELDS.entidadesdocumentoslinhas_valoriva.format.format(Entidadesdocumentoslinhas.jdoGetvaloriva(this));
    }

    public void setValoriva(BigDecimal valoriva) {
        BigDecimal bigDecimal = Entidadesdocumentoslinhas.jdoGetvaloriva(this);
        BigDecimal bigDecimal2 = valoriva;
        Entidadesdocumentoslinhas.jdoSetvaloriva(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_valoriva, (Object)bigDecimal, (Object)bigDecimal2);
        if (Entidadesdocumentoslinhas.jdoGetdocumento((Entidadesdocumentoslinhas)this).cascade && this.cascade && changed) {
            this.process();
        }
    }

    public BigDecimal getValorprodutos() {
        return Entidadesdocumentoslinhas.jdoGetvalorprodutos(this);
    }

    public String getValorprodutosToText() {
        return Entidadesdocumentoslinhas.jdoGetvalorprodutos(this) == null ? "" : FIELDS.entidadesdocumentoslinhas_valorprodutos.format.format(Entidadesdocumentoslinhas.jdoGetvalorprodutos(this));
    }

    public void setValorprodutos(BigDecimal valorprodutos) {
        BigDecimal bigDecimal = Entidadesdocumentoslinhas.jdoGetvalorprodutos(this);
        BigDecimal bigDecimal2 = valorprodutos;
        Entidadesdocumentoslinhas.jdoSetvalorprodutos(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_valorprodutos, (Object)bigDecimal, (Object)bigDecimal2);
        if (Entidadesdocumentoslinhas.jdoGetdocumento((Entidadesdocumentoslinhas)this).cascade && this.cascade && changed) {
            this.process();
        }
    }

    public BigDecimal getValorservicos() {
        return Entidadesdocumentoslinhas.jdoGetvalorservicos(this);
    }

    public String getValorservicosToText() {
        return Entidadesdocumentoslinhas.jdoGetvalorservicos(this) == null ? "" : FIELDS.entidadesdocumentoslinhas_valorservicos.format.format(Entidadesdocumentoslinhas.jdoGetvalorservicos(this));
    }

    public void setValorservicos(BigDecimal valorservicos) {
        BigDecimal bigDecimal = Entidadesdocumentoslinhas.jdoGetvalorservicos(this);
        BigDecimal bigDecimal2 = valorservicos;
        Entidadesdocumentoslinhas.jdoSetvalorservicos(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_valorservicos, (Object)bigDecimal, (Object)bigDecimal2);
        if (Entidadesdocumentoslinhas.jdoGetdocumento((Entidadesdocumentoslinhas)this).cascade && this.cascade && changed) {
            this.process();
        }
    }

    public BigDecimal getValorretencao() {
        return Entidadesdocumentoslinhas.jdoGetvalorretencao(this);
    }

    public String getValorretencaoToText() {
        return Entidadesdocumentoslinhas.jdoGetvalorretencao(this) == null ? "" : FIELDS.entidadesdocumentoslinhas_valorretencao.format.format(Entidadesdocumentoslinhas.jdoGetvalorretencao(this));
    }

    public void setValorretencao(BigDecimal valorretencao) {
        BigDecimal bigDecimal = Entidadesdocumentoslinhas.jdoGetvalorretencao(this);
        BigDecimal bigDecimal2 = valorretencao;
        Entidadesdocumentoslinhas.jdoSetvalorretencao(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_valorretencao, (Object)bigDecimal, (Object)bigDecimal2);
        if (Entidadesdocumentoslinhas.jdoGetdocumento((Entidadesdocumentoslinhas)this).cascade && this.cascade && changed) {
            this.process();
        }
    }

    public BigDecimal getFormulaquant() {
        return Entidadesdocumentoslinhas.jdoGetformulaquant(this);
    }

    public String getFormulaquantToText() {
        return Entidadesdocumentoslinhas.jdoGetformulaquant(this) == null ? "" : FIELDS.entidadesdocumentoslinhas_formulaquant.format.format(Entidadesdocumentoslinhas.jdoGetformulaquant(this));
    }

    public void setFormulaquant(BigDecimal formulaquant) {
        BigDecimal bigDecimal = Entidadesdocumentoslinhas.jdoGetformulaquant(this);
        BigDecimal bigDecimal2 = formulaquant;
        Entidadesdocumentoslinhas.jdoSetformulaquant(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_formulaquant, (Object)bigDecimal, (Object)bigDecimal2);
        if (Entidadesdocumentoslinhas.jdoGetdocumento((Entidadesdocumentoslinhas)this).cascade && this.cascade && changed) {
            this.setQuantidade(Entidadesdocumentoslinhas.jdoGetunidademedida(this));
            this.process();
        }
    }

    public BigDecimal getFormulavalor1() {
        return Entidadesdocumentoslinhas.jdoGetformulavalor1(this);
    }

    public String getFormulavalor1ToText() {
        return Entidadesdocumentoslinhas.jdoGetformulavalor1(this) == null ? "" : FIELDS.entidadesdocumentoslinhas_formulavalor1.format.format(Entidadesdocumentoslinhas.jdoGetformulavalor1(this));
    }

    public void setFormulavalor1(BigDecimal formulavalor1) {
        BigDecimal bigDecimal = Entidadesdocumentoslinhas.jdoGetformulavalor1(this);
        BigDecimal bigDecimal2 = formulavalor1;
        Entidadesdocumentoslinhas.jdoSetformulavalor1(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_formulavalor1, (Object)bigDecimal, (Object)bigDecimal2);
        if (Entidadesdocumentoslinhas.jdoGetdocumento((Entidadesdocumentoslinhas)this).cascade && this.cascade && changed) {
            this.setQuantidade(Entidadesdocumentoslinhas.jdoGetunidademedida(this));
            this.process();
        }
    }

    public BigDecimal getFormulavalor2() {
        return Entidadesdocumentoslinhas.jdoGetformulavalor2(this);
    }

    public String getFormulavalor2ToText() {
        return Entidadesdocumentoslinhas.jdoGetformulavalor2(this) == null ? "" : FIELDS.entidadesdocumentoslinhas_formulavalor2.format.format(Entidadesdocumentoslinhas.jdoGetformulavalor2(this));
    }

    public void setFormulavalor2(BigDecimal formulavalor2) {
        BigDecimal bigDecimal = Entidadesdocumentoslinhas.jdoGetformulavalor2(this);
        BigDecimal bigDecimal2 = formulavalor2;
        Entidadesdocumentoslinhas.jdoSetformulavalor2(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_formulavalor2, (Object)bigDecimal, (Object)bigDecimal2);
        if (Entidadesdocumentoslinhas.jdoGetdocumento((Entidadesdocumentoslinhas)this).cascade && this.cascade && changed) {
            this.setQuantidade(Entidadesdocumentoslinhas.jdoGetunidademedida(this));
            this.process();
        }
    }

    public BigDecimal getFormulavalor3() {
        return Entidadesdocumentoslinhas.jdoGetformulavalor3(this);
    }

    public String getFormulavalor3ToText() {
        return Entidadesdocumentoslinhas.jdoGetformulavalor3(this) == null ? "" : FIELDS.entidadesdocumentoslinhas_formulavalor3.format.format(Entidadesdocumentoslinhas.jdoGetformulavalor3(this));
    }

    public void setFormulavalor3(BigDecimal formulavalor3) {
        BigDecimal bigDecimal = Entidadesdocumentoslinhas.jdoGetformulavalor3(this);
        BigDecimal bigDecimal2 = formulavalor3;
        Entidadesdocumentoslinhas.jdoSetformulavalor3(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_formulavalor3, (Object)bigDecimal, (Object)bigDecimal2);
        if (Entidadesdocumentoslinhas.jdoGetdocumento((Entidadesdocumentoslinhas)this).cascade && this.cascade && changed) {
            this.setQuantidade(Entidadesdocumentoslinhas.jdoGetunidademedida(this));
            this.process();
        }
    }

    public BigDecimal getFormulavalor4() {
        return Entidadesdocumentoslinhas.jdoGetformulavalor4(this);
    }

    public String getFormulavalor4ToText() {
        return Entidadesdocumentoslinhas.jdoGetformulavalor4(this) == null ? "" : FIELDS.entidadesdocumentoslinhas_formulavalor4.format.format(Entidadesdocumentoslinhas.jdoGetformulavalor4(this));
    }

    public void setFormulavalor4(BigDecimal formulavalor4) {
        BigDecimal bigDecimal = Entidadesdocumentoslinhas.jdoGetformulavalor4(this);
        BigDecimal bigDecimal2 = formulavalor4;
        Entidadesdocumentoslinhas.jdoSetformulavalor4(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_formulavalor4, (Object)bigDecimal, (Object)bigDecimal2);
        if (Entidadesdocumentoslinhas.jdoGetdocumento((Entidadesdocumentoslinhas)this).cascade && this.cascade && changed) {
            this.setQuantidade(Entidadesdocumentoslinhas.jdoGetunidademedida(this));
            this.process();
        }
    }

    public Boolean getDeducao() {
        return Entidadesdocumentoslinhas.jdoGetdeducao(this);
    }

    public String getDeducaoToText() {
        return Entidadesdocumentoslinhas.jdoGetdeducao(this) == null ? "" : Entidadesdocumentoslinhas.jdoGetdeducao(this).toString();
    }

    public void setDeducao(Boolean deducao) {
        Boolean bl = Entidadesdocumentoslinhas.jdoGetdeducao(this);
        Boolean bl2 = deducao;
        Entidadesdocumentoslinhas.jdoSetdeducao(this, bl2);
        this.firePropertyChange(FIELDS.entidadesdocumentoslinhas_deducao, (Object)bl, (Object)bl2);
    }

    @Override
    public boolean isEditable(FIELDS field) {
        switch (Entidadesdocumentoslinhas.jdoGetdocumento(this).getEstado()) {
            case 0: {
                switch (Entidadesdocumentoslinhas.jdoGettipo(this)) {
                    case 0: {
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        switch (field) {
                            case entidadesdocumentoslinhas_datadocumento: {
                                return true;
                            }
                            case entidadesdocumentoslinhas_artigo: {
                                return !Entidadesdocumentoslinhas.jdoGetdocumento(this).getTipodocumento().isTipodocumento(2);
                            }
                            case entidadesdocumentoslinhas_descricao: {
                                return true;
                            }
                            case entidadesdocumentoslinhas_unidademedida: {
                                return !Entidadesdocumentoslinhas.jdoGetdocumento(this).getTipodocumento().isTipodocumento(2);
                            }
                            case entidadesdocumentoslinhas_armazem: {
                                return !Entidadesdocumentoslinhas.jdoGetdocumento(this).getTipodocumento().isTipodocumento(2);
                            }
                            case entidadesdocumentoslinhas_tamanho: {
                                return !Entidadesdocumentoslinhas.jdoGetdocumento(this).getTipodocumento().isTipodocumento(2);
                            }
                            case entidadesdocumentoslinhas_cor: {
                                return !Entidadesdocumentoslinhas.jdoGetdocumento(this).getTipodocumento().isTipodocumento(2);
                            }
                            case entidadesdocumentoslinhas_numeroserie: {
                                return true;
                            }
                            case entidadesdocumentoslinhas_codigoiva: {
                                return !Entidadesdocumentoslinhas.jdoGetdocumento(this).getTipodocumento().isTipodocumento(2);
                            }
                            case entidadesdocumentoslinhas_isencaoiva: {
                                return !Entidadesdocumentoslinhas.jdoGetdocumento(this).getTipodocumento().isTipodocumento(2) && Colibri.MARKET_TYPE == Colibri.MARKETS.INTERNAL;
                            }
                            case entidadesdocumentoslinhas_quantidade: {
                                return !Entidadesdocumentoslinhas.jdoGetdocumento(this).getTipodocumento().isTipodocumento(2);
                            }
                            case entidadesdocumentoslinhas_preco: {
                                return !Entidadesdocumentoslinhas.jdoGetdocumento(this).getTipodocumento().isTipodocumento(2);
                            }
                            case entidadesdocumentoslinhas_preco2: {
                                return !Entidadesdocumentoslinhas.jdoGetdocumento(this).getTipodocumento().isTipodocumento(2);
                            }
                            case entidadesdocumentoslinhas_precoiva: {
                                return !Entidadesdocumentoslinhas.jdoGetdocumento(this).getTipodocumento().isTipodocumento(2);
                            }
                            case entidadesdocumentoslinhas_valoriliquido: {
                                return !Entidadesdocumentoslinhas.jdoGetdocumento(this).getTipodocumento().isTipodocumento(2);
                            }
                            case entidadesdocumentoslinhas_valoriliquidoiva: {
                                return !Entidadesdocumentoslinhas.jdoGetdocumento(this).getTipodocumento().isTipodocumento(2);
                            }
                            case entidadesdocumentoslinhas_valoriliquidoiva2: {
                                return Entidadesdocumentoslinhas.jdoGetdocumento(this).getTipodocumento().isTipodocumento(2);
                            }
                            case entidadesdocumentoslinhas_percdesconto: {
                                return true;
                            }
                            case entidadesdocumentoslinhas_percdesconto2: {
                                return true;
                            }
                            case entidadesdocumentoslinhas_valordesconto: {
                                return true;
                            }
                            case entidadesdocumentoslinhas_valorretencao: {
                                return Entidadesdocumentoslinhas.jdoGetartigo(this) != null && Entidadesdocumentoslinhas.jdoGetartigo(this).isTipo(2);
                            }
                            case entidadesdocumentoslinhas_formulaquant: {
                                return true;
                            }
                            case entidadesdocumentoslinhas_formulavalor1: {
                                return true;
                            }
                            case entidadesdocumentoslinhas_formulavalor2: {
                                return true;
                            }
                            case entidadesdocumentoslinhas_formulavalor3: {
                                return true;
                            }
                            case entidadesdocumentoslinhas_formulavalor4: {
                                return true;
                            }
                            case entidadesdocumentoslinhas_campo1: {
                                return true;
                            }
                            case entidadesdocumentoslinhas_campo2: {
                                return true;
                            }
                            case entidadesdocumentoslinhas_campo3: {
                                return true;
                            }
                            case entidadesdocumentoslinhas_campo4: {
                                return true;
                            }
                            case entidadesdocumentoslinhas_campo5: {
                                return true;
                            }
                        }
                    }
                }
                break;
            }
        }
        return false;
    }

    @Override
    public void attach(DatabaseManager manager) {
        manager.attach(new AbstractModel[]{Entidadesdocumentoslinhas.jdoGetlinhaorigem(this), Entidadesdocumentoslinhas.jdoGetmovimentoorigem(this), Entidadesdocumentoslinhas.jdoGetmovimentoorigem2(this), Entidadesdocumentoslinhas.jdoGetmovimentoartigos(this), Entidadesdocumentoslinhas.jdoGetdocumento(this), Entidadesdocumentoslinhas.jdoGetartigo(this), Entidadesdocumentoslinhas.jdoGetunidademedida(this), Entidadesdocumentoslinhas.jdoGetarmazem(this), Entidadesdocumentoslinhas.jdoGettamanho(this), Entidadesdocumentoslinhas.jdoGetcor(this), Entidadesdocumentoslinhas.jdoGetcodigoiva(this), Entidadesdocumentoslinhas.jdoGetisencaoiva(this)});
    }

    public String toString() {
        return Entidadesdocumentoslinhas.jdoGetkey(this);
    }

    public int hashCode() {
        return Entidadesdocumentoslinhas.jdoGetkey(this) == null ? 0 : Entidadesdocumentoslinhas.jdoGetkey(this).hashCode();
    }

    public boolean equals(Object obj) {
        return this.hashCode() == obj.hashCode();
    }

    static {
        jdoFieldNames = Entidadesdocumentoslinhas.__jdoFieldNamesInit();
        jdoFieldTypes = Entidadesdocumentoslinhas.__jdoFieldTypesInit();
        jdoFieldFlags = Entidadesdocumentoslinhas.__jdoFieldFlagsInit();
        jdoInheritedFieldCount = Entidadesdocumentoslinhas.__jdoGetInheritedFieldCount();
        jdoPersistenceCapableSuperclass = Entidadesdocumentoslinhas.__jdoPersistenceCapableSuperclassInit();
        JDOImplHelper.registerClass((Class)Entidadesdocumentoslinhas.___jdo$loadClass("org.projectocolibri.api.database.model.Entidadesdocumentoslinhas"), (String[])jdoFieldNames, (Class[])jdoFieldTypes, (byte[])jdoFieldFlags, (Class)jdoPersistenceCapableSuperclass, (PersistenceCapable)new Entidadesdocumentoslinhas());
    }

    public void jdoCopyKeyFieldsFromObjectId(PersistenceCapable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("oid is not instanceof javax.jdo.identity.StringIdentity");
        }
        StringIdentity o = (StringIdentity)oid;
        fc.storeStringField(20, o.getKey());
    }

    protected void jdoCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("key class is not javax.jdo.identity.StringIdentity or null");
        }
        StringIdentity o = (StringIdentity)oid;
        this.key = o.getKey();
    }

    public final void jdoCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final void jdoCopyKeyFieldsToObjectId(PersistenceCapable.ObjectIdFieldSupplier fs, Object object) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final Object jdoGetObjectId() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getObjectId((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[0];
    }

    public final Object jdoGetVersion() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getVersion((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[1];
    }

    protected final void jdoPreSerialize() {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.preSerialize((PersistenceCapable)this);
        }
    }

    public final PersistenceManager jdoGetPersistenceManager() {
        return this.jdoStateManager != null ? this.jdoStateManager.getPersistenceManager((PersistenceCapable)this) : null;
    }

    public final Object jdoGetTransactionalObjectId() {
        return this.jdoStateManager != null ? this.jdoStateManager.getTransactionalObjectId((PersistenceCapable)this) : null;
    }

    public final boolean jdoIsDeleted() {
        return this.jdoStateManager != null ? this.jdoStateManager.isDeleted((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsDirty() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.isDirty((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return false;
        }
        return ((BitSet)this.jdoDetachedState[3]).length() > 0;
    }

    public final boolean jdoIsNew() {
        return this.jdoStateManager != null ? this.jdoStateManager.isNew((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsPersistent() {
        return this.jdoStateManager != null ? this.jdoStateManager.isPersistent((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsTransactional() {
        return this.jdoStateManager != null ? this.jdoStateManager.isTransactional((PersistenceCapable)this) : false;
    }

    public void jdoMakeDirty(String fieldName) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.makeDirty((PersistenceCapable)this, fieldName);
        }
        if (this.jdoIsDetached() && fieldName != null) {
            String fldName = null;
            fldName = fieldName.indexOf(46) >= 0 ? fieldName.substring(fieldName.lastIndexOf(46) + 1) : fieldName;
            int i = 0;
            while (i < jdoFieldNames.length) {
                if (jdoFieldNames[i].equals(fldName)) {
                    if (!((BitSet)this.jdoDetachedState[2]).get(i + jdoInheritedFieldCount)) {
                        throw new JDODetachedFieldAccessException("You have just attempted to access a field/property that hasn't been detached. Please detach it first before performing this operation");
                    }
                    ((BitSet)this.jdoDetachedState[3]).set(i + jdoInheritedFieldCount);
                    return;
                }
                ++i;
            }
        }
    }

    public final Object jdoNewObjectIdInstance() {
        return new StringIdentity(this.getClass(), this.key);
    }

    public final Object jdoNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new StringIdentity(this.getClass(), (String)key);
        }
        return new StringIdentity(this.getClass(), (String)key);
    }

    public final void jdoProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void jdoReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.jdoReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void jdoReplaceFlags() {
        if (this.jdoStateManager != null) {
            this.jdoFlags = this.jdoStateManager.replacingFlags((PersistenceCapable)this);
        }
    }

    public final synchronized void jdoReplaceStateManager(StateManager sm) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager = this.jdoStateManager.replacingStateManager((PersistenceCapable)this, sm);
        } else {
            JDOImplHelper.checkAuthorizedStateManager((StateManager)sm);
            this.jdoStateManager = sm;
            this.jdoFlags = 1;
        }
    }

    public final synchronized void jdoReplaceDetachedState() {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        this.jdoDetachedState = this.jdoStateManager.replacingDetachedState((Detachable)this, this.jdoDetachedState);
    }

    public boolean jdoIsDetached() {
        return this.jdoStateManager == null && this.jdoDetachedState != null;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm) {
        Entidadesdocumentoslinhas result = new Entidadesdocumentoslinhas();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        return result;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm, Object obj) {
        Entidadesdocumentoslinhas result = new Entidadesdocumentoslinhas();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        result.jdoCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void jdoReplaceField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.armazem = (Armazens)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 1: {
                this.artigo = (Artigos)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 2: {
                this.campo1 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 3: {
                this.campo2 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 4: {
                this.campo3 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 5: {
                this.campo4 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 6: {
                this.campo5 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 7: {
                this.codigoiva = (Codigosiva)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 8: {
                this.cor = (Cores)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 9: {
                this.datadocumento = (Date)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 10: {
                this.deducao = (Boolean)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 11: {
                this.descricao = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 12: {
                this.documento = (Entidadesdocumentos)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 13: {
                this.factor = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 14: {
                this.formulaquant = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 15: {
                this.formulavalor1 = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 16: {
                this.formulavalor2 = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 17: {
                this.formulavalor3 = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 18: {
                this.formulavalor4 = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 19: {
                this.isencaoiva = (Isencoesiva)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 20: {
                this.key = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 21: {
                this.linhaorigem = (Entidadesdocumentoslinhas)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 22: {
                this.movimentoartigos = (Artigosmovimentos)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 23: {
                this.movimentoorigem = (Entidadesmovimentos)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 24: {
                this.movimentoorigem2 = (Artigosmovimentos)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 25: {
                this.numerolinha = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 26: {
                this.numeroserie = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 27: {
                this.percdesconto = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 28: {
                this.percdesconto2 = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 29: {
                this.preco = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 30: {
                this.preco2 = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 31: {
                this.precoiva = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 32: {
                this.quantidade = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 33: {
                this.tamanho = (Tamanhos)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 34: {
                this.tipo = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 35: {
                this.unidademedida = (Unidadesmedida)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 36: {
                this.valordesconto = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 37: {
                this.valoriliquido = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 38: {
                this.valoriliquidoiva = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 39: {
                this.valoriva = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 40: {
                this.valorliquido = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 41: {
                this.valorprodutos = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 42: {
                this.valorretencao = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 43: {
                this.valorservicos = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoProvideField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.armazem);
                break;
            }
            case 1: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.artigo);
                break;
            }
            case 2: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.campo1);
                break;
            }
            case 3: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.campo2);
                break;
            }
            case 4: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.campo3);
                break;
            }
            case 5: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.campo4);
                break;
            }
            case 6: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.campo5);
                break;
            }
            case 7: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.codigoiva);
                break;
            }
            case 8: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.cor);
                break;
            }
            case 9: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.datadocumento);
                break;
            }
            case 10: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.deducao);
                break;
            }
            case 11: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.descricao);
                break;
            }
            case 12: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.documento);
                break;
            }
            case 13: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.factor);
                break;
            }
            case 14: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.formulaquant);
                break;
            }
            case 15: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.formulavalor1);
                break;
            }
            case 16: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.formulavalor2);
                break;
            }
            case 17: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.formulavalor3);
                break;
            }
            case 18: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.formulavalor4);
                break;
            }
            case 19: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.isencaoiva);
                break;
            }
            case 20: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.key);
                break;
            }
            case 21: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.linhaorigem);
                break;
            }
            case 22: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.movimentoartigos);
                break;
            }
            case 23: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.movimentoorigem);
                break;
            }
            case 24: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.movimentoorigem2);
                break;
            }
            case 25: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.numerolinha);
                break;
            }
            case 26: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.numeroserie);
                break;
            }
            case 27: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.percdesconto);
                break;
            }
            case 28: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.percdesconto2);
                break;
            }
            case 29: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.preco);
                break;
            }
            case 30: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.preco2);
                break;
            }
            case 31: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.precoiva);
                break;
            }
            case 32: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.quantidade);
                break;
            }
            case 33: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.tamanho);
                break;
            }
            case 34: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.tipo);
                break;
            }
            case 35: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.unidademedida);
                break;
            }
            case 36: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.valordesconto);
                break;
            }
            case 37: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.valoriliquido);
                break;
            }
            case 38: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.valoriliquidoiva);
                break;
            }
            case 39: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.valoriva);
                break;
            }
            case 40: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.valorliquido);
                break;
            }
            case 41: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.valorprodutos);
                break;
            }
            case 42: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.valorretencao);
                break;
            }
            case 43: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.valorservicos);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void jdoCopyField(Entidadesdocumentoslinhas obj, int index) {
        switch (index) {
            case 0: {
                this.armazem = obj.armazem;
                break;
            }
            case 1: {
                this.artigo = obj.artigo;
                break;
            }
            case 2: {
                this.campo1 = obj.campo1;
                break;
            }
            case 3: {
                this.campo2 = obj.campo2;
                break;
            }
            case 4: {
                this.campo3 = obj.campo3;
                break;
            }
            case 5: {
                this.campo4 = obj.campo4;
                break;
            }
            case 6: {
                this.campo5 = obj.campo5;
                break;
            }
            case 7: {
                this.codigoiva = obj.codigoiva;
                break;
            }
            case 8: {
                this.cor = obj.cor;
                break;
            }
            case 9: {
                this.datadocumento = obj.datadocumento;
                break;
            }
            case 10: {
                this.deducao = obj.deducao;
                break;
            }
            case 11: {
                this.descricao = obj.descricao;
                break;
            }
            case 12: {
                this.documento = obj.documento;
                break;
            }
            case 13: {
                this.factor = obj.factor;
                break;
            }
            case 14: {
                this.formulaquant = obj.formulaquant;
                break;
            }
            case 15: {
                this.formulavalor1 = obj.formulavalor1;
                break;
            }
            case 16: {
                this.formulavalor2 = obj.formulavalor2;
                break;
            }
            case 17: {
                this.formulavalor3 = obj.formulavalor3;
                break;
            }
            case 18: {
                this.formulavalor4 = obj.formulavalor4;
                break;
            }
            case 19: {
                this.isencaoiva = obj.isencaoiva;
                break;
            }
            case 20: {
                this.key = obj.key;
                break;
            }
            case 21: {
                this.linhaorigem = obj.linhaorigem;
                break;
            }
            case 22: {
                this.movimentoartigos = obj.movimentoartigos;
                break;
            }
            case 23: {
                this.movimentoorigem = obj.movimentoorigem;
                break;
            }
            case 24: {
                this.movimentoorigem2 = obj.movimentoorigem2;
                break;
            }
            case 25: {
                this.numerolinha = obj.numerolinha;
                break;
            }
            case 26: {
                this.numeroserie = obj.numeroserie;
                break;
            }
            case 27: {
                this.percdesconto = obj.percdesconto;
                break;
            }
            case 28: {
                this.percdesconto2 = obj.percdesconto2;
                break;
            }
            case 29: {
                this.preco = obj.preco;
                break;
            }
            case 30: {
                this.preco2 = obj.preco2;
                break;
            }
            case 31: {
                this.precoiva = obj.precoiva;
                break;
            }
            case 32: {
                this.quantidade = obj.quantidade;
                break;
            }
            case 33: {
                this.tamanho = obj.tamanho;
                break;
            }
            case 34: {
                this.tipo = obj.tipo;
                break;
            }
            case 35: {
                this.unidademedida = obj.unidademedida;
                break;
            }
            case 36: {
                this.valordesconto = obj.valordesconto;
                break;
            }
            case 37: {
                this.valoriliquido = obj.valoriliquido;
                break;
            }
            case 38: {
                this.valoriliquidoiva = obj.valoriliquidoiva;
                break;
            }
            case 39: {
                this.valoriva = obj.valoriva;
                break;
            }
            case 40: {
                this.valorliquido = obj.valorliquido;
                break;
            }
            case 41: {
                this.valorprodutos = obj.valorprodutos;
                break;
            }
            case 42: {
                this.valorretencao = obj.valorretencao;
                break;
            }
            case 43: {
                this.valorservicos = obj.valorservicos;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoCopyFields(Object obj, int[] indices) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof Entidadesdocumentoslinhas)) {
            throw new IllegalArgumentException("object is not an object of type org.projectocolibri.api.database.model.Entidadesdocumentoslinhas");
        }
        Entidadesdocumentoslinhas other = (Entidadesdocumentoslinhas)obj;
        if (this.jdoStateManager != other.jdoStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __jdoFieldNamesInit() {
        return new String[]{"armazem", "artigo", "campo1", "campo2", "campo3", "campo4", "campo5", "codigoiva", "cor", "datadocumento", "deducao", "descricao", "documento", "factor", "formulaquant", "formulavalor1", "formulavalor2", "formulavalor3", "formulavalor4", "isencaoiva", "key", "linhaorigem", "movimentoartigos", "movimentoorigem", "movimentoorigem2", "numerolinha", "numeroserie", "percdesconto", "percdesconto2", "preco", "preco2", "precoiva", "quantidade", "tamanho", "tipo", "unidademedida", "valordesconto", "valoriliquido", "valoriliquidoiva", "valoriva", "valorliquido", "valorprodutos", "valorretencao", "valorservicos"};
    }

    private static final Class[] __jdoFieldTypesInit() {
        return new Class[]{Entidadesdocumentoslinhas.___jdo$loadClass("org.projectocolibri.api.database.model.Armazens"), Entidadesdocumentoslinhas.___jdo$loadClass("org.projectocolibri.api.database.model.Artigos"), Entidadesdocumentoslinhas.___jdo$loadClass("java.lang.String"), Entidadesdocumentoslinhas.___jdo$loadClass("java.lang.String"), Entidadesdocumentoslinhas.___jdo$loadClass("java.lang.String"), Entidadesdocumentoslinhas.___jdo$loadClass("java.lang.String"), Entidadesdocumentoslinhas.___jdo$loadClass("java.lang.String"), Entidadesdocumentoslinhas.___jdo$loadClass("org.projectocolibri.api.database.model.Codigosiva"), Entidadesdocumentoslinhas.___jdo$loadClass("org.projectocolibri.api.database.model.Cores"), Entidadesdocumentoslinhas.___jdo$loadClass("java.util.Date"), Entidadesdocumentoslinhas.___jdo$loadClass("java.lang.Boolean"), Entidadesdocumentoslinhas.___jdo$loadClass("java.lang.String"), Entidadesdocumentoslinhas.___jdo$loadClass("org.projectocolibri.api.database.model.Entidadesdocumentos"), Entidadesdocumentoslinhas.___jdo$loadClass("java.math.BigDecimal"), Entidadesdocumentoslinhas.___jdo$loadClass("java.math.BigDecimal"), Entidadesdocumentoslinhas.___jdo$loadClass("java.math.BigDecimal"), Entidadesdocumentoslinhas.___jdo$loadClass("java.math.BigDecimal"), Entidadesdocumentoslinhas.___jdo$loadClass("java.math.BigDecimal"), Entidadesdocumentoslinhas.___jdo$loadClass("java.math.BigDecimal"), Entidadesdocumentoslinhas.___jdo$loadClass("org.projectocolibri.api.database.model.Isencoesiva"), Entidadesdocumentoslinhas.___jdo$loadClass("java.lang.String"), Entidadesdocumentoslinhas.___jdo$loadClass("org.projectocolibri.api.database.model.Entidadesdocumentoslinhas"), Entidadesdocumentoslinhas.___jdo$loadClass("org.projectocolibri.api.database.model.Artigosmovimentos"), Entidadesdocumentoslinhas.___jdo$loadClass("org.projectocolibri.api.database.model.Entidadesmovimentos"), Entidadesdocumentoslinhas.___jdo$loadClass("org.projectocolibri.api.database.model.Artigosmovimentos"), Entidadesdocumentoslinhas.___jdo$loadClass("java.lang.Integer"), Entidadesdocumentoslinhas.___jdo$loadClass("java.lang.String"), Entidadesdocumentoslinhas.___jdo$loadClass("java.math.BigDecimal"), Entidadesdocumentoslinhas.___jdo$loadClass("java.math.BigDecimal"), Entidadesdocumentoslinhas.___jdo$loadClass("java.math.BigDecimal"), Entidadesdocumentoslinhas.___jdo$loadClass("java.math.BigDecimal"), Entidadesdocumentoslinhas.___jdo$loadClass("java.math.BigDecimal"), Entidadesdocumentoslinhas.___jdo$loadClass("java.math.BigDecimal"), Entidadesdocumentoslinhas.___jdo$loadClass("org.projectocolibri.api.database.model.Tamanhos"), Entidadesdocumentoslinhas.___jdo$loadClass("java.lang.Integer"), Entidadesdocumentoslinhas.___jdo$loadClass("org.projectocolibri.api.database.model.Unidadesmedida"), Entidadesdocumentoslinhas.___jdo$loadClass("java.math.BigDecimal"), Entidadesdocumentoslinhas.___jdo$loadClass("java.math.BigDecimal"), Entidadesdocumentoslinhas.___jdo$loadClass("java.math.BigDecimal"), Entidadesdocumentoslinhas.___jdo$loadClass("java.math.BigDecimal"), Entidadesdocumentoslinhas.___jdo$loadClass("java.math.BigDecimal"), Entidadesdocumentoslinhas.___jdo$loadClass("java.math.BigDecimal"), Entidadesdocumentoslinhas.___jdo$loadClass("java.math.BigDecimal"), Entidadesdocumentoslinhas.___jdo$loadClass("java.math.BigDecimal")};
    }

    private static final byte[] __jdoFieldFlagsInit() {
        return new byte[]{5, 5, 21, 21, 21, 21, 21, 5, 5, 21, 21, 21, 5, 21, 21, 21, 21, 21, 21, 5, 24, 5, 5, 5, 5, 21, 21, 21, 21, 21, 21, 21, 21, 5, 21, 5, 21, 21, 21, 21, 21, 21, 21, 21};
    }

    protected static int __jdoGetInheritedFieldCount() {
        return 0;
    }

    protected static int jdoGetManagedFieldCount() {
        return 44;
    }

    private static Class __jdoPersistenceCapableSuperclassInit() {
        return null;
    }

    public static Class ___jdo$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object jdoSuperClone() throws CloneNotSupportedException {
        Entidadesdocumentoslinhas o = (Entidadesdocumentoslinhas)super.clone();
        o.jdoFlags = 0;
        o.jdoStateManager = null;
        return o;
    }

    private static Armazens jdoGetarmazem(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 0)) {
            return (Armazens)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 0, (Object)objPC.armazem);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(0)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"armazem\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.armazem;
    }

    private static void jdoSetarmazem(Entidadesdocumentoslinhas objPC, Armazens val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 0, (Object)objPC.armazem, (Object)val);
        } else {
            objPC.armazem = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(0);
            }
        }
    }

    private static Artigos jdoGetartigo(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 1)) {
            return (Artigos)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 1, (Object)objPC.artigo);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(1)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"artigo\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.artigo;
    }

    private static void jdoSetartigo(Entidadesdocumentoslinhas objPC, Artigos val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 1, (Object)objPC.artigo, (Object)val);
        } else {
            objPC.artigo = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(1);
            }
        }
    }

    private static String jdoGetcampo1(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 2)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 2, objPC.campo1);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(2)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"campo1\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.campo1;
    }

    private static void jdoSetcampo1(Entidadesdocumentoslinhas objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 2, objPC.campo1, val);
        } else {
            objPC.campo1 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(2);
            }
        }
    }

    private static String jdoGetcampo2(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 3)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 3, objPC.campo2);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(3)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"campo2\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.campo2;
    }

    private static void jdoSetcampo2(Entidadesdocumentoslinhas objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 3, objPC.campo2, val);
        } else {
            objPC.campo2 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(3);
            }
        }
    }

    private static String jdoGetcampo3(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 4)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 4, objPC.campo3);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(4)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"campo3\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.campo3;
    }

    private static void jdoSetcampo3(Entidadesdocumentoslinhas objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 4, objPC.campo3, val);
        } else {
            objPC.campo3 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(4);
            }
        }
    }

    private static String jdoGetcampo4(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 5)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 5, objPC.campo4);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(5)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"campo4\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.campo4;
    }

    private static void jdoSetcampo4(Entidadesdocumentoslinhas objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 5, objPC.campo4, val);
        } else {
            objPC.campo4 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(5);
            }
        }
    }

    private static String jdoGetcampo5(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 6)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 6, objPC.campo5);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(6)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"campo5\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.campo5;
    }

    private static void jdoSetcampo5(Entidadesdocumentoslinhas objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 6, objPC.campo5, val);
        } else {
            objPC.campo5 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(6);
            }
        }
    }

    private static Codigosiva jdoGetcodigoiva(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 7)) {
            return (Codigosiva)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 7, (Object)objPC.codigoiva);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(7)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"codigoiva\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.codigoiva;
    }

    private static void jdoSetcodigoiva(Entidadesdocumentoslinhas objPC, Codigosiva val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 7, (Object)objPC.codigoiva, (Object)val);
        } else {
            objPC.codigoiva = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(7);
            }
        }
    }

    private static Cores jdoGetcor(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 8)) {
            return (Cores)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 8, (Object)objPC.cor);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(8)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"cor\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.cor;
    }

    private static void jdoSetcor(Entidadesdocumentoslinhas objPC, Cores val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 8, (Object)objPC.cor, (Object)val);
        } else {
            objPC.cor = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(8);
            }
        }
    }

    private static Date jdoGetdatadocumento(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 9)) {
            return (Date)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 9, (Object)objPC.datadocumento);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(9)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"datadocumento\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.datadocumento;
    }

    private static void jdoSetdatadocumento(Entidadesdocumentoslinhas objPC, Date val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 9, (Object)objPC.datadocumento, (Object)val);
        } else {
            objPC.datadocumento = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(9);
            }
        }
    }

    private static Boolean jdoGetdeducao(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 10)) {
            return (Boolean)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 10, (Object)objPC.deducao);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(10)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"deducao\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.deducao;
    }

    private static void jdoSetdeducao(Entidadesdocumentoslinhas objPC, Boolean val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 10, (Object)objPC.deducao, (Object)val);
        } else {
            objPC.deducao = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(10);
            }
        }
    }

    private static String jdoGetdescricao(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 11)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 11, objPC.descricao);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(11)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"descricao\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.descricao;
    }

    private static void jdoSetdescricao(Entidadesdocumentoslinhas objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 11, objPC.descricao, val);
        } else {
            objPC.descricao = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(11);
            }
        }
    }

    private static Entidadesdocumentos jdoGetdocumento(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 12)) {
            return (Entidadesdocumentos)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 12, (Object)objPC.documento);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(12)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"documento\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.documento;
    }

    private static void jdoSetdocumento(Entidadesdocumentoslinhas objPC, Entidadesdocumentos val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 12, (Object)objPC.documento, (Object)val);
        } else {
            objPC.documento = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(12);
            }
        }
    }

    private static BigDecimal jdoGetfactor(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 13)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 13, (Object)objPC.factor);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(13)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"factor\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.factor;
    }

    private static void jdoSetfactor(Entidadesdocumentoslinhas objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 13, (Object)objPC.factor, (Object)val);
        } else {
            objPC.factor = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(13);
            }
        }
    }

    private static BigDecimal jdoGetformulaquant(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 14)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 14, (Object)objPC.formulaquant);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(14)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"formulaquant\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.formulaquant;
    }

    private static void jdoSetformulaquant(Entidadesdocumentoslinhas objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 14, (Object)objPC.formulaquant, (Object)val);
        } else {
            objPC.formulaquant = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(14);
            }
        }
    }

    private static BigDecimal jdoGetformulavalor1(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 15)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 15, (Object)objPC.formulavalor1);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(15)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"formulavalor1\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.formulavalor1;
    }

    private static void jdoSetformulavalor1(Entidadesdocumentoslinhas objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 15, (Object)objPC.formulavalor1, (Object)val);
        } else {
            objPC.formulavalor1 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(15);
            }
        }
    }

    private static BigDecimal jdoGetformulavalor2(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 16)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 16, (Object)objPC.formulavalor2);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(16)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"formulavalor2\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.formulavalor2;
    }

    private static void jdoSetformulavalor2(Entidadesdocumentoslinhas objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 16, (Object)objPC.formulavalor2, (Object)val);
        } else {
            objPC.formulavalor2 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(16);
            }
        }
    }

    private static BigDecimal jdoGetformulavalor3(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 17)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 17, (Object)objPC.formulavalor3);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(17)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"formulavalor3\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.formulavalor3;
    }

    private static void jdoSetformulavalor3(Entidadesdocumentoslinhas objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 17, (Object)objPC.formulavalor3, (Object)val);
        } else {
            objPC.formulavalor3 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(17);
            }
        }
    }

    private static BigDecimal jdoGetformulavalor4(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 18)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 18, (Object)objPC.formulavalor4);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(18)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"formulavalor4\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.formulavalor4;
    }

    private static void jdoSetformulavalor4(Entidadesdocumentoslinhas objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 18, (Object)objPC.formulavalor4, (Object)val);
        } else {
            objPC.formulavalor4 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(18);
            }
        }
    }

    private static Isencoesiva jdoGetisencaoiva(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 19)) {
            return (Isencoesiva)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 19, (Object)objPC.isencaoiva);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(19)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"isencaoiva\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.isencaoiva;
    }

    private static void jdoSetisencaoiva(Entidadesdocumentoslinhas objPC, Isencoesiva val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 19, (Object)objPC.isencaoiva, (Object)val);
        } else {
            objPC.isencaoiva = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(19);
            }
        }
    }

    private static String jdoGetkey(Entidadesdocumentoslinhas objPC) {
        return objPC.key;
    }

    private static void jdoSetkey(Entidadesdocumentoslinhas objPC, String val) {
        if (objPC.jdoStateManager == null) {
            objPC.key = val;
        } else {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 20, objPC.key, val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(20);
        }
    }

    private static Entidadesdocumentoslinhas jdoGetlinhaorigem(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 21)) {
            return (Entidadesdocumentoslinhas)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 21, (Object)objPC.linhaorigem);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(21)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"linhaorigem\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.linhaorigem;
    }

    private static void jdoSetlinhaorigem(Entidadesdocumentoslinhas objPC, Entidadesdocumentoslinhas val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 21, (Object)objPC.linhaorigem, (Object)val);
        } else {
            objPC.linhaorigem = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(21);
            }
        }
    }

    private static Artigosmovimentos jdoGetmovimentoartigos(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 22)) {
            return (Artigosmovimentos)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 22, (Object)objPC.movimentoartigos);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(22)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"movimentoartigos\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.movimentoartigos;
    }

    private static void jdoSetmovimentoartigos(Entidadesdocumentoslinhas objPC, Artigosmovimentos val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 22, (Object)objPC.movimentoartigos, (Object)val);
        } else {
            objPC.movimentoartigos = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(22);
            }
        }
    }

    private static Entidadesmovimentos jdoGetmovimentoorigem(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 23)) {
            return (Entidadesmovimentos)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 23, (Object)objPC.movimentoorigem);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(23)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"movimentoorigem\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.movimentoorigem;
    }

    private static void jdoSetmovimentoorigem(Entidadesdocumentoslinhas objPC, Entidadesmovimentos val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 23, (Object)objPC.movimentoorigem, (Object)val);
        } else {
            objPC.movimentoorigem = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(23);
            }
        }
    }

    private static Artigosmovimentos jdoGetmovimentoorigem2(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 24)) {
            return (Artigosmovimentos)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 24, (Object)objPC.movimentoorigem2);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(24)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"movimentoorigem2\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.movimentoorigem2;
    }

    private static void jdoSetmovimentoorigem2(Entidadesdocumentoslinhas objPC, Artigosmovimentos val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 24, (Object)objPC.movimentoorigem2, (Object)val);
        } else {
            objPC.movimentoorigem2 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(24);
            }
        }
    }

    private static Integer jdoGetnumerolinha(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 25)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 25, (Object)objPC.numerolinha);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(25)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"numerolinha\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.numerolinha;
    }

    private static void jdoSetnumerolinha(Entidadesdocumentoslinhas objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 25, (Object)objPC.numerolinha, (Object)val);
        } else {
            objPC.numerolinha = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(25);
            }
        }
    }

    private static String jdoGetnumeroserie(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 26)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 26, objPC.numeroserie);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(26)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"numeroserie\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.numeroserie;
    }

    private static void jdoSetnumeroserie(Entidadesdocumentoslinhas objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 26, objPC.numeroserie, val);
        } else {
            objPC.numeroserie = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(26);
            }
        }
    }

    private static BigDecimal jdoGetpercdesconto(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 27)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 27, (Object)objPC.percdesconto);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(27)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"percdesconto\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.percdesconto;
    }

    private static void jdoSetpercdesconto(Entidadesdocumentoslinhas objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 27, (Object)objPC.percdesconto, (Object)val);
        } else {
            objPC.percdesconto = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(27);
            }
        }
    }

    private static BigDecimal jdoGetpercdesconto2(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 28)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 28, (Object)objPC.percdesconto2);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(28)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"percdesconto2\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.percdesconto2;
    }

    private static void jdoSetpercdesconto2(Entidadesdocumentoslinhas objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 28, (Object)objPC.percdesconto2, (Object)val);
        } else {
            objPC.percdesconto2 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(28);
            }
        }
    }

    private static BigDecimal jdoGetpreco(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 29)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 29, (Object)objPC.preco);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(29)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"preco\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.preco;
    }

    private static void jdoSetpreco(Entidadesdocumentoslinhas objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 29, (Object)objPC.preco, (Object)val);
        } else {
            objPC.preco = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(29);
            }
        }
    }

    private static BigDecimal jdoGetpreco2(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 30)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 30, (Object)objPC.preco2);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(30)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"preco2\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.preco2;
    }

    private static void jdoSetpreco2(Entidadesdocumentoslinhas objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 30, (Object)objPC.preco2, (Object)val);
        } else {
            objPC.preco2 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(30);
            }
        }
    }

    private static BigDecimal jdoGetprecoiva(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 31)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 31, (Object)objPC.precoiva);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(31)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"precoiva\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.precoiva;
    }

    private static void jdoSetprecoiva(Entidadesdocumentoslinhas objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 31, (Object)objPC.precoiva, (Object)val);
        } else {
            objPC.precoiva = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(31);
            }
        }
    }

    private static BigDecimal jdoGetquantidade(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 32)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 32, (Object)objPC.quantidade);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(32)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"quantidade\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.quantidade;
    }

    private static void jdoSetquantidade(Entidadesdocumentoslinhas objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 32, (Object)objPC.quantidade, (Object)val);
        } else {
            objPC.quantidade = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(32);
            }
        }
    }

    private static Tamanhos jdoGettamanho(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 33)) {
            return (Tamanhos)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 33, (Object)objPC.tamanho);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(33)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"tamanho\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.tamanho;
    }

    private static void jdoSettamanho(Entidadesdocumentoslinhas objPC, Tamanhos val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 33, (Object)objPC.tamanho, (Object)val);
        } else {
            objPC.tamanho = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(33);
            }
        }
    }

    private static Integer jdoGettipo(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 34)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 34, (Object)objPC.tipo);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(34)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"tipo\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.tipo;
    }

    private static void jdoSettipo(Entidadesdocumentoslinhas objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 34, (Object)objPC.tipo, (Object)val);
        } else {
            objPC.tipo = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(34);
            }
        }
    }

    private static Unidadesmedida jdoGetunidademedida(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 35)) {
            return (Unidadesmedida)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 35, (Object)objPC.unidademedida);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(35)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"unidademedida\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.unidademedida;
    }

    private static void jdoSetunidademedida(Entidadesdocumentoslinhas objPC, Unidadesmedida val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 35, (Object)objPC.unidademedida, (Object)val);
        } else {
            objPC.unidademedida = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(35);
            }
        }
    }

    private static BigDecimal jdoGetvalordesconto(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 36)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 36, (Object)objPC.valordesconto);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(36)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"valordesconto\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.valordesconto;
    }

    private static void jdoSetvalordesconto(Entidadesdocumentoslinhas objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 36, (Object)objPC.valordesconto, (Object)val);
        } else {
            objPC.valordesconto = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(36);
            }
        }
    }

    private static BigDecimal jdoGetvaloriliquido(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 37)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 37, (Object)objPC.valoriliquido);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(37)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"valoriliquido\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.valoriliquido;
    }

    private static void jdoSetvaloriliquido(Entidadesdocumentoslinhas objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 37, (Object)objPC.valoriliquido, (Object)val);
        } else {
            objPC.valoriliquido = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(37);
            }
        }
    }

    private static BigDecimal jdoGetvaloriliquidoiva(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 38)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 38, (Object)objPC.valoriliquidoiva);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(38)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"valoriliquidoiva\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.valoriliquidoiva;
    }

    private static void jdoSetvaloriliquidoiva(Entidadesdocumentoslinhas objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 38, (Object)objPC.valoriliquidoiva, (Object)val);
        } else {
            objPC.valoriliquidoiva = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(38);
            }
        }
    }

    private static BigDecimal jdoGetvaloriva(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 39)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 39, (Object)objPC.valoriva);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(39)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"valoriva\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.valoriva;
    }

    private static void jdoSetvaloriva(Entidadesdocumentoslinhas objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 39, (Object)objPC.valoriva, (Object)val);
        } else {
            objPC.valoriva = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(39);
            }
        }
    }

    private static BigDecimal jdoGetvalorliquido(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 40)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 40, (Object)objPC.valorliquido);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(40)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"valorliquido\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.valorliquido;
    }

    private static void jdoSetvalorliquido(Entidadesdocumentoslinhas objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 40, (Object)objPC.valorliquido, (Object)val);
        } else {
            objPC.valorliquido = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(40);
            }
        }
    }

    private static BigDecimal jdoGetvalorprodutos(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 41)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 41, (Object)objPC.valorprodutos);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(41)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"valorprodutos\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.valorprodutos;
    }

    private static void jdoSetvalorprodutos(Entidadesdocumentoslinhas objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 41, (Object)objPC.valorprodutos, (Object)val);
        } else {
            objPC.valorprodutos = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(41);
            }
        }
    }

    private static BigDecimal jdoGetvalorretencao(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 42)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 42, (Object)objPC.valorretencao);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(42)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"valorretencao\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.valorretencao;
    }

    private static void jdoSetvalorretencao(Entidadesdocumentoslinhas objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 42, (Object)objPC.valorretencao, (Object)val);
        } else {
            objPC.valorretencao = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(42);
            }
        }
    }

    private static BigDecimal jdoGetvalorservicos(Entidadesdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 43)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 43, (Object)objPC.valorservicos);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(43)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"valorservicos\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.valorservicos;
    }

    private static void jdoSetvalorservicos(Entidadesdocumentoslinhas objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 43, (Object)objPC.valorservicos, (Object)val);
        } else {
            objPC.valorservicos = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(43);
            }
        }
    }
}

