/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.model;

import java.math.BigDecimal;
import java.util.BitSet;
import java.util.Date;
import javax.jdo.JDODetachedFieldAccessException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.PersistenceManager;
import javax.jdo.identity.StringIdentity;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;
import org.dma.java.util.MessageLine;
import org.dma.java.util.MessageList;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.IDatabaseModel;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.AbstractModel;
import org.projectocolibri.api.database.model.Contasbancarias;
import org.projectocolibri.api.database.model.Entidadesdocumentos;
import org.projectocolibri.api.database.model.Metodospagamento;
import org.projectocolibri.api.language.LABELS;

@javax.jdo.annotations.PersistenceCapable
public class Entidadesdocumentosentregas
extends AbstractModel
implements Detachable,
PersistenceCapable {
    public static final int estadoprocessamento_pendente = 0;
    public static final int estadoprocessamento_confirmado = 1;
    public static final int estadoprocessamento_importado = 2;
    public static final int estadoprocessamento_alterado = 3;
    private String key;
    private Entidadesdocumentos documento;
    private Metodospagamento metodopagamento;
    private Contasbancarias contabancaria;
    private Date dataprocessamento;
    private String descricao;
    private String referencia;
    private Integer numerolinha;
    private Integer movimentabanco;
    private Integer estadoprocessamento;
    private BigDecimal valor;
    protected transient StateManager jdoStateManager;
    protected transient byte jdoFlags;
    protected Object[] jdoDetachedState;
    private static final byte[] jdoFieldFlags;
    private static final Class jdoPersistenceCapableSuperclass;
    private static final Class[] jdoFieldTypes;
    private static final String[] jdoFieldNames;
    private static final int jdoInheritedFieldCount;

    private Entidadesdocumentosentregas() {
        super(TABLES.entidadesdocumentosentregas);
    }

    private Entidadesdocumentosentregas(DatabaseManager manager) {
        super(TABLES.entidadesdocumentosentregas, manager);
    }

    public Entidadesdocumentosentregas(Entidadesdocumentos documento, Metodospagamento metodopagamento) {
        this(documento.getManager());
        this.documento = documento;
        this.metodopagamento = metodopagamento;
        this.contabancaria = this.manager.getParametros().getContabancaria();
        this.dataprocessamento = documento.getDatacriacao();
        this.descricao = metodopagamento.getDescricao();
        this.referencia = "";
        this.numerolinha = documento.getEntregaspagamento().size() + 1;
        this.movimentabanco = documento.getTipodocumento().getMovimentabancos();
        this.estadoprocessamento = 0;
        this.valor = documento.getTotal().subtract(documento.getTotalentregue());
        this.key = this.generateKey();
    }

    @Override
    public Entidadesdocumentosentregas cloneCopy() {
        Entidadesdocumentosentregas clone = new Entidadesdocumentosentregas(this.manager);
        Entidadesdocumentosentregas.jdoSetkey(clone, Entidadesdocumentosentregas.jdoGetkey(this));
        Entidadesdocumentosentregas.jdoSetdocumento(clone, Entidadesdocumentosentregas.jdoGetdocumento(this));
        Entidadesdocumentosentregas.jdoSetmetodopagamento(clone, Entidadesdocumentosentregas.jdoGetmetodopagamento(this));
        Entidadesdocumentosentregas.jdoSetcontabancaria(clone, Entidadesdocumentosentregas.jdoGetcontabancaria(this));
        Entidadesdocumentosentregas.jdoSetdataprocessamento(clone, Entidadesdocumentosentregas.jdoGetdataprocessamento(this));
        Entidadesdocumentosentregas.jdoSetdescricao(clone, Entidadesdocumentosentregas.jdoGetdescricao(this));
        Entidadesdocumentosentregas.jdoSetreferencia(clone, Entidadesdocumentosentregas.jdoGetreferencia(this));
        Entidadesdocumentosentregas.jdoSetnumerolinha(clone, Entidadesdocumentosentregas.jdoGetnumerolinha(this));
        Entidadesdocumentosentregas.jdoSetmovimentabanco(clone, Entidadesdocumentosentregas.jdoGetmovimentabanco(this));
        Entidadesdocumentosentregas.jdoSetestadoprocessamento(clone, Entidadesdocumentosentregas.jdoGetestadoprocessamento(this));
        Entidadesdocumentosentregas.jdoSetvalor(clone, Entidadesdocumentosentregas.jdoGetvalor(this));
        return clone;
    }

    Entidadesdocumentosentregas cloneCopy(Entidadesdocumentos documento) {
        Entidadesdocumentosentregas clone = this.cloneCopy();
        Entidadesdocumentosentregas.jdoSetdocumento(clone, documento);
        clone.setKey();
        return clone;
    }

    @Override
    public MessageList validate(IDatabaseModel.ACTION action) {
        MessageList error = super.validate(action);
        switch (action) {
            case DELETE: {
                break;
            }
            case STORE: {
                if (this.isMovimentabancoValid()) break;
                error.add((Object)new MessageLine((Object)LABELS.documentostipos_movimentabancos));
            }
        }
        return error.prefix((Object)((Object)LABELS.entidadesdocumentosentregas_numerolinha) + " " + this.getNumerolinhaToText());
    }

    @Override
    public String getKey() {
        return Entidadesdocumentosentregas.jdoGetkey(this);
    }

    public void setKey(String key) {
        String string = Entidadesdocumentosentregas.jdoGetkey(this);
        String string2 = key;
        Entidadesdocumentosentregas.jdoSetkey(this, string2);
        this.firePropertyChange(FIELDS.entidadesdocumentosentregas_key, (Object)string, (Object)string2);
    }

    void setKey() {
        this.setKey(this.generateKey());
    }

    String generateKey() {
        return Entidadesdocumentosentregas.jdoGetdocumento(this) == null || Entidadesdocumentosentregas.jdoGetnumerolinha(this) == null ? null : Entidadesdocumentosentregas.generateKey(Entidadesdocumentosentregas.jdoGetdocumento(this).getKey(), Entidadesdocumentosentregas.jdoGetnumerolinha(this));
    }

    public static String generateKey(String documento, Integer numerolinha) {
        return String.valueOf(documento) + ":" + numerolinha;
    }

    public Entidadesdocumentos getDocumento() {
        return Entidadesdocumentosentregas.jdoGetdocumento(this);
    }

    public void setDocumento(Entidadesdocumentos documento) {
        Entidadesdocumentos entidadesdocumentos = Entidadesdocumentosentregas.jdoGetdocumento(this);
        Entidadesdocumentos entidadesdocumentos2 = documento;
        Entidadesdocumentosentregas.jdoSetdocumento(this, entidadesdocumentos2);
        this.firePropertyChange(FIELDS.entidadesdocumentosentregas_documento, (Object)entidadesdocumentos, (Object)entidadesdocumentos2);
        this.setKey();
    }

    public Metodospagamento getMetodopagamento() {
        return Entidadesdocumentosentregas.jdoGetmetodopagamento(this);
    }

    public void setMetodopagamento(Metodospagamento metodopagamento) {
        Metodospagamento metodospagamento = Entidadesdocumentosentregas.jdoGetmetodopagamento(this);
        Metodospagamento metodospagamento2 = metodopagamento;
        Entidadesdocumentosentregas.jdoSetmetodopagamento(this, metodospagamento2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentosentregas_metodopagamento, (Object)metodospagamento, (Object)metodospagamento2);
        if (Entidadesdocumentosentregas.jdoGetdocumento((Entidadesdocumentosentregas)this).cascade && this.cascade && changed && metodopagamento != null) {
            this.setDescricao(metodopagamento.getDescricao());
            if (this.isEstadoprocessamento(2)) {
                this.setEstadoprocessamento(3);
            }
        }
    }

    public Contasbancarias getContabancaria() {
        return Entidadesdocumentosentregas.jdoGetcontabancaria(this);
    }

    public void setContabancaria(Contasbancarias contabancaria) {
        Contasbancarias contasbancarias = Entidadesdocumentosentregas.jdoGetcontabancaria(this);
        Contasbancarias contasbancarias2 = contabancaria;
        Entidadesdocumentosentregas.jdoSetcontabancaria(this, contasbancarias2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentosentregas_contabancaria, (Object)contasbancarias, (Object)contasbancarias2);
        if (Entidadesdocumentosentregas.jdoGetdocumento((Entidadesdocumentosentregas)this).cascade && this.cascade && changed && this.isEstadoprocessamento(2)) {
            this.setEstadoprocessamento(3);
        }
    }

    public Date getDataprocessamento() {
        return Entidadesdocumentosentregas.jdoGetdataprocessamento(this);
    }

    public String getDataprocessamentoToText() {
        return Entidadesdocumentosentregas.jdoGetdataprocessamento(this) == null ? "" : Entidadesdocumentosentregas.jdoGetdataprocessamento(this).toString();
    }

    public void setDataprocessamento(Date dataprocessamento) {
        Date date = Entidadesdocumentosentregas.jdoGetdataprocessamento(this);
        Date date2 = dataprocessamento;
        Entidadesdocumentosentregas.jdoSetdataprocessamento(this, date2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentosentregas_dataprocessamento, (Object)date, (Object)date2);
        if (Entidadesdocumentosentregas.jdoGetdocumento((Entidadesdocumentosentregas)this).cascade && this.cascade && changed && this.isEstadoprocessamento(2)) {
            this.setEstadoprocessamento(3);
        }
    }

    public String getDescricao() {
        return Entidadesdocumentosentregas.jdoGetdescricao(this);
    }

    public String getDescricaoToText() {
        return Entidadesdocumentosentregas.jdoGetdescricao(this) == null ? "" : Entidadesdocumentosentregas.jdoGetdescricao(this).toString();
    }

    public void setDescricao(String descricao) {
        String string = Entidadesdocumentosentregas.jdoGetdescricao(this);
        String string2 = descricao;
        Entidadesdocumentosentregas.jdoSetdescricao(this, string2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentosentregas_descricao, (Object)string, (Object)string2);
        if (Entidadesdocumentosentregas.jdoGetdocumento((Entidadesdocumentosentregas)this).cascade && this.cascade && changed && this.isEstadoprocessamento(2)) {
            this.setEstadoprocessamento(3);
        }
    }

    public String getReferencia() {
        return Entidadesdocumentosentregas.jdoGetreferencia(this);
    }

    public String getReferenciaToText() {
        return Entidadesdocumentosentregas.jdoGetreferencia(this) == null ? "" : Entidadesdocumentosentregas.jdoGetreferencia(this).toString();
    }

    public void setReferencia(String referencia) {
        String string = Entidadesdocumentosentregas.jdoGetreferencia(this);
        String string2 = referencia;
        Entidadesdocumentosentregas.jdoSetreferencia(this, string2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentosentregas_referencia, (Object)string, (Object)string2);
        if (Entidadesdocumentosentregas.jdoGetdocumento((Entidadesdocumentosentregas)this).cascade && this.cascade && changed && this.isEstadoprocessamento(2)) {
            this.setEstadoprocessamento(3);
        }
    }

    public Integer getNumerolinha() {
        return Entidadesdocumentosentregas.jdoGetnumerolinha(this);
    }

    public String getNumerolinhaToText() {
        return Entidadesdocumentosentregas.jdoGetnumerolinha(this) == null ? "" : Entidadesdocumentosentregas.jdoGetnumerolinha(this).toString();
    }

    protected void setNumerolinha(Integer numerolinha) {
        Integer n = Entidadesdocumentosentregas.jdoGetnumerolinha(this);
        Integer n2 = numerolinha;
        Entidadesdocumentosentregas.jdoSetnumerolinha(this, n2);
        this.firePropertyChange(FIELDS.entidadesdocumentosentregas_numerolinha, (Object)n, (Object)n2);
        this.setKey();
    }

    public Integer getMovimentabanco() {
        return Entidadesdocumentosentregas.jdoGetmovimentabanco(this);
    }

    public boolean isMovimentabanco(Integer movimentabanco) {
        return Entidadesdocumentosentregas.equals(movimentabanco, Entidadesdocumentosentregas.jdoGetmovimentabanco(this));
    }

    public String getMovimentabancoToText() {
        return Entidadesdocumentosentregas.jdoGetmovimentabanco(this) == null ? "" : FIELDS.entidadesdocumentosentregas_movimentabanco.values[Entidadesdocumentosentregas.jdoGetmovimentabanco(this)];
    }

    public void setMovimentabanco(Integer movimentabanco) {
        Integer n = Entidadesdocumentosentregas.jdoGetmovimentabanco(this);
        Integer n2 = movimentabanco;
        Entidadesdocumentosentregas.jdoSetmovimentabanco(this, n2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentosentregas_movimentabanco, (Object)n, (Object)n2);
        if (Entidadesdocumentosentregas.jdoGetdocumento((Entidadesdocumentosentregas)this).cascade && this.cascade && changed && this.isEstadoprocessamento(2)) {
            this.setEstadoprocessamento(3);
        }
    }

    public boolean isMovimentabancoValid() {
        if (!this.isMovimentabanco(0)) {
            try {
                return this.isMovimentabanco(Entidadesdocumentosentregas.jdoGetdocumento(this).getTipodocumento().getMovimentabancos());
            }
            catch (JDODetachedFieldAccessException jDODetachedFieldAccessException) {
                // empty catch block
            }
        }
        return true;
    }

    public Integer getEstadoprocessamento() {
        return Entidadesdocumentosentregas.jdoGetestadoprocessamento(this);
    }

    public boolean isEstadoprocessamento(Integer estadoprocessamento) {
        return Entidadesdocumentosentregas.equals(estadoprocessamento, Entidadesdocumentosentregas.jdoGetestadoprocessamento(this));
    }

    public String getEstadoprocessamentoToText() {
        return Entidadesdocumentosentregas.jdoGetestadoprocessamento(this) == null ? "" : FIELDS.entidadesdocumentosentregas_estadoprocessamento.values[Entidadesdocumentosentregas.jdoGetestadoprocessamento(this)];
    }

    public void setEstadoprocessamento(Integer estadoprocessamento) {
        Integer n = Entidadesdocumentosentregas.jdoGetestadoprocessamento(this);
        Integer n2 = estadoprocessamento;
        Entidadesdocumentosentregas.jdoSetestadoprocessamento(this, n2);
        this.firePropertyChange(FIELDS.entidadesdocumentosentregas_estadoprocessamento, (Object)n, (Object)n2);
    }

    public BigDecimal getValor() {
        return Entidadesdocumentosentregas.jdoGetvalor(this);
    }

    public String getValorToText() {
        return Entidadesdocumentosentregas.jdoGetvalor(this) == null ? "" : FIELDS.entidadesdocumentosentregas_valor.format.format(Entidadesdocumentosentregas.jdoGetvalor(this));
    }

    public void setValor(BigDecimal valor) {
        BigDecimal bigDecimal = Entidadesdocumentosentregas.jdoGetvalor(this);
        BigDecimal bigDecimal2 = valor;
        Entidadesdocumentosentregas.jdoSetvalor(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentosentregas_valor, (Object)bigDecimal, (Object)bigDecimal2);
        if (Entidadesdocumentosentregas.jdoGetdocumento((Entidadesdocumentosentregas)this).cascade && this.cascade && changed) {
            if (this.isEstadoprocessamento(2)) {
                this.setEstadoprocessamento(3);
            }
            Entidadesdocumentosentregas.jdoGetdocumento(this).process();
        }
    }

    @Override
    public boolean isEditable(FIELDS field) {
        block0 : switch (Entidadesdocumentosentregas.jdoGetdocumento(this).getEstado()) {
            case 0: {
                switch (Entidadesdocumentosentregas.jdoGetestadoprocessamento(this)) {
                    case 1: {
                        break block0;
                    }
                    case 0: 
                    case 2: 
                    case 3: {
                        return field != FIELDS.entidadesdocumentosentregas_numerolinha && field != FIELDS.entidadesdocumentosentregas_estadoprocessamento;
                    }
                }
                break;
            }
        }
        return false;
    }

    @Override
    public void attach(DatabaseManager manager) {
        manager.attach(new AbstractModel[]{Entidadesdocumentosentregas.jdoGetdocumento(this), Entidadesdocumentosentregas.jdoGetmetodopagamento(this), Entidadesdocumentosentregas.jdoGetcontabancaria(this)});
    }

    public String toString() {
        return Entidadesdocumentosentregas.jdoGetkey(this);
    }

    public int hashCode() {
        return Entidadesdocumentosentregas.jdoGetkey(this) == null ? 0 : Entidadesdocumentosentregas.jdoGetkey(this).hashCode();
    }

    public boolean equals(Object obj) {
        return this.hashCode() == obj.hashCode();
    }

    static {
        jdoFieldNames = Entidadesdocumentosentregas.__jdoFieldNamesInit();
        jdoFieldTypes = Entidadesdocumentosentregas.__jdoFieldTypesInit();
        jdoFieldFlags = Entidadesdocumentosentregas.__jdoFieldFlagsInit();
        jdoInheritedFieldCount = Entidadesdocumentosentregas.__jdoGetInheritedFieldCount();
        jdoPersistenceCapableSuperclass = Entidadesdocumentosentregas.__jdoPersistenceCapableSuperclassInit();
        JDOImplHelper.registerClass((Class)Entidadesdocumentosentregas.___jdo$loadClass("org.projectocolibri.api.database.model.Entidadesdocumentosentregas"), (String[])jdoFieldNames, (Class[])jdoFieldTypes, (byte[])jdoFieldFlags, (Class)jdoPersistenceCapableSuperclass, (PersistenceCapable)new Entidadesdocumentosentregas());
    }

    public void jdoCopyKeyFieldsFromObjectId(PersistenceCapable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("oid is not instanceof javax.jdo.identity.StringIdentity");
        }
        StringIdentity o = (StringIdentity)oid;
        fc.storeStringField(5, o.getKey());
    }

    protected void jdoCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("key class is not javax.jdo.identity.StringIdentity or null");
        }
        StringIdentity o = (StringIdentity)oid;
        this.key = o.getKey();
    }

    public final void jdoCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final void jdoCopyKeyFieldsToObjectId(PersistenceCapable.ObjectIdFieldSupplier fs, Object object) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final Object jdoGetObjectId() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getObjectId((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[0];
    }

    public final Object jdoGetVersion() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getVersion((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[1];
    }

    protected final void jdoPreSerialize() {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.preSerialize((PersistenceCapable)this);
        }
    }

    public final PersistenceManager jdoGetPersistenceManager() {
        return this.jdoStateManager != null ? this.jdoStateManager.getPersistenceManager((PersistenceCapable)this) : null;
    }

    public final Object jdoGetTransactionalObjectId() {
        return this.jdoStateManager != null ? this.jdoStateManager.getTransactionalObjectId((PersistenceCapable)this) : null;
    }

    public final boolean jdoIsDeleted() {
        return this.jdoStateManager != null ? this.jdoStateManager.isDeleted((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsDirty() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.isDirty((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return false;
        }
        return ((BitSet)this.jdoDetachedState[3]).length() > 0;
    }

    public final boolean jdoIsNew() {
        return this.jdoStateManager != null ? this.jdoStateManager.isNew((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsPersistent() {
        return this.jdoStateManager != null ? this.jdoStateManager.isPersistent((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsTransactional() {
        return this.jdoStateManager != null ? this.jdoStateManager.isTransactional((PersistenceCapable)this) : false;
    }

    public void jdoMakeDirty(String fieldName) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.makeDirty((PersistenceCapable)this, fieldName);
        }
        if (this.jdoIsDetached() && fieldName != null) {
            String fldName = null;
            fldName = fieldName.indexOf(46) >= 0 ? fieldName.substring(fieldName.lastIndexOf(46) + 1) : fieldName;
            int i = 0;
            while (i < jdoFieldNames.length) {
                if (jdoFieldNames[i].equals(fldName)) {
                    if (!((BitSet)this.jdoDetachedState[2]).get(i + jdoInheritedFieldCount)) {
                        throw new JDODetachedFieldAccessException("You have just attempted to access a field/property that hasn't been detached. Please detach it first before performing this operation");
                    }
                    ((BitSet)this.jdoDetachedState[3]).set(i + jdoInheritedFieldCount);
                    return;
                }
                ++i;
            }
        }
    }

    public final Object jdoNewObjectIdInstance() {
        return new StringIdentity(this.getClass(), this.key);
    }

    public final Object jdoNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new StringIdentity(this.getClass(), (String)key);
        }
        return new StringIdentity(this.getClass(), (String)key);
    }

    public final void jdoProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void jdoReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.jdoReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void jdoReplaceFlags() {
        if (this.jdoStateManager != null) {
            this.jdoFlags = this.jdoStateManager.replacingFlags((PersistenceCapable)this);
        }
    }

    public final synchronized void jdoReplaceStateManager(StateManager sm) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager = this.jdoStateManager.replacingStateManager((PersistenceCapable)this, sm);
        } else {
            JDOImplHelper.checkAuthorizedStateManager((StateManager)sm);
            this.jdoStateManager = sm;
            this.jdoFlags = 1;
        }
    }

    public final synchronized void jdoReplaceDetachedState() {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        this.jdoDetachedState = this.jdoStateManager.replacingDetachedState((Detachable)this, this.jdoDetachedState);
    }

    public boolean jdoIsDetached() {
        return this.jdoStateManager == null && this.jdoDetachedState != null;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm) {
        Entidadesdocumentosentregas result = new Entidadesdocumentosentregas();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        return result;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm, Object obj) {
        Entidadesdocumentosentregas result = new Entidadesdocumentosentregas();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        result.jdoCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void jdoReplaceField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.contabancaria = (Contasbancarias)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 1: {
                this.dataprocessamento = (Date)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 2: {
                this.descricao = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 3: {
                this.documento = (Entidadesdocumentos)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 4: {
                this.estadoprocessamento = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 5: {
                this.key = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 6: {
                this.metodopagamento = (Metodospagamento)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 7: {
                this.movimentabanco = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 8: {
                this.numerolinha = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 9: {
                this.referencia = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 10: {
                this.valor = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoProvideField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.contabancaria);
                break;
            }
            case 1: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.dataprocessamento);
                break;
            }
            case 2: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.descricao);
                break;
            }
            case 3: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.documento);
                break;
            }
            case 4: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.estadoprocessamento);
                break;
            }
            case 5: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.key);
                break;
            }
            case 6: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.metodopagamento);
                break;
            }
            case 7: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.movimentabanco);
                break;
            }
            case 8: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.numerolinha);
                break;
            }
            case 9: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.referencia);
                break;
            }
            case 10: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.valor);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void jdoCopyField(Entidadesdocumentosentregas obj, int index) {
        switch (index) {
            case 0: {
                this.contabancaria = obj.contabancaria;
                break;
            }
            case 1: {
                this.dataprocessamento = obj.dataprocessamento;
                break;
            }
            case 2: {
                this.descricao = obj.descricao;
                break;
            }
            case 3: {
                this.documento = obj.documento;
                break;
            }
            case 4: {
                this.estadoprocessamento = obj.estadoprocessamento;
                break;
            }
            case 5: {
                this.key = obj.key;
                break;
            }
            case 6: {
                this.metodopagamento = obj.metodopagamento;
                break;
            }
            case 7: {
                this.movimentabanco = obj.movimentabanco;
                break;
            }
            case 8: {
                this.numerolinha = obj.numerolinha;
                break;
            }
            case 9: {
                this.referencia = obj.referencia;
                break;
            }
            case 10: {
                this.valor = obj.valor;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoCopyFields(Object obj, int[] indices) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof Entidadesdocumentosentregas)) {
            throw new IllegalArgumentException("object is not an object of type org.projectocolibri.api.database.model.Entidadesdocumentosentregas");
        }
        Entidadesdocumentosentregas other = (Entidadesdocumentosentregas)obj;
        if (this.jdoStateManager != other.jdoStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __jdoFieldNamesInit() {
        return new String[]{"contabancaria", "dataprocessamento", "descricao", "documento", "estadoprocessamento", "key", "metodopagamento", "movimentabanco", "numerolinha", "referencia", "valor"};
    }

    private static final Class[] __jdoFieldTypesInit() {
        return new Class[]{Entidadesdocumentosentregas.___jdo$loadClass("org.projectocolibri.api.database.model.Contasbancarias"), Entidadesdocumentosentregas.___jdo$loadClass("java.util.Date"), Entidadesdocumentosentregas.___jdo$loadClass("java.lang.String"), Entidadesdocumentosentregas.___jdo$loadClass("org.projectocolibri.api.database.model.Entidadesdocumentos"), Entidadesdocumentosentregas.___jdo$loadClass("java.lang.Integer"), Entidadesdocumentosentregas.___jdo$loadClass("java.lang.String"), Entidadesdocumentosentregas.___jdo$loadClass("org.projectocolibri.api.database.model.Metodospagamento"), Entidadesdocumentosentregas.___jdo$loadClass("java.lang.Integer"), Entidadesdocumentosentregas.___jdo$loadClass("java.lang.Integer"), Entidadesdocumentosentregas.___jdo$loadClass("java.lang.String"), Entidadesdocumentosentregas.___jdo$loadClass("java.math.BigDecimal")};
    }

    private static final byte[] __jdoFieldFlagsInit() {
        return new byte[]{5, 21, 21, 5, 21, 24, 5, 21, 21, 21, 21};
    }

    protected static int __jdoGetInheritedFieldCount() {
        return 0;
    }

    protected static int jdoGetManagedFieldCount() {
        return 11;
    }

    private static Class __jdoPersistenceCapableSuperclassInit() {
        return null;
    }

    public static Class ___jdo$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object jdoSuperClone() throws CloneNotSupportedException {
        Entidadesdocumentosentregas o = (Entidadesdocumentosentregas)super.clone();
        o.jdoFlags = 0;
        o.jdoStateManager = null;
        return o;
    }

    private static Contasbancarias jdoGetcontabancaria(Entidadesdocumentosentregas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 0)) {
            return (Contasbancarias)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 0, (Object)objPC.contabancaria);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(0)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"contabancaria\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.contabancaria;
    }

    private static void jdoSetcontabancaria(Entidadesdocumentosentregas objPC, Contasbancarias val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 0, (Object)objPC.contabancaria, (Object)val);
        } else {
            objPC.contabancaria = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(0);
            }
        }
    }

    private static Date jdoGetdataprocessamento(Entidadesdocumentosentregas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 1)) {
            return (Date)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 1, (Object)objPC.dataprocessamento);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(1)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"dataprocessamento\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.dataprocessamento;
    }

    private static void jdoSetdataprocessamento(Entidadesdocumentosentregas objPC, Date val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 1, (Object)objPC.dataprocessamento, (Object)val);
        } else {
            objPC.dataprocessamento = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(1);
            }
        }
    }

    private static String jdoGetdescricao(Entidadesdocumentosentregas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 2)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 2, objPC.descricao);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(2)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"descricao\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.descricao;
    }

    private static void jdoSetdescricao(Entidadesdocumentosentregas objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 2, objPC.descricao, val);
        } else {
            objPC.descricao = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(2);
            }
        }
    }

    private static Entidadesdocumentos jdoGetdocumento(Entidadesdocumentosentregas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 3)) {
            return (Entidadesdocumentos)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 3, (Object)objPC.documento);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(3)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"documento\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.documento;
    }

    private static void jdoSetdocumento(Entidadesdocumentosentregas objPC, Entidadesdocumentos val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 3, (Object)objPC.documento, (Object)val);
        } else {
            objPC.documento = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(3);
            }
        }
    }

    private static Integer jdoGetestadoprocessamento(Entidadesdocumentosentregas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 4)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 4, (Object)objPC.estadoprocessamento);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(4)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"estadoprocessamento\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.estadoprocessamento;
    }

    private static void jdoSetestadoprocessamento(Entidadesdocumentosentregas objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 4, (Object)objPC.estadoprocessamento, (Object)val);
        } else {
            objPC.estadoprocessamento = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(4);
            }
        }
    }

    private static String jdoGetkey(Entidadesdocumentosentregas objPC) {
        return objPC.key;
    }

    private static void jdoSetkey(Entidadesdocumentosentregas objPC, String val) {
        if (objPC.jdoStateManager == null) {
            objPC.key = val;
        } else {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 5, objPC.key, val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(5);
        }
    }

    private static Metodospagamento jdoGetmetodopagamento(Entidadesdocumentosentregas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 6)) {
            return (Metodospagamento)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 6, (Object)objPC.metodopagamento);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(6)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"metodopagamento\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.metodopagamento;
    }

    private static void jdoSetmetodopagamento(Entidadesdocumentosentregas objPC, Metodospagamento val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 6, (Object)objPC.metodopagamento, (Object)val);
        } else {
            objPC.metodopagamento = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(6);
            }
        }
    }

    private static Integer jdoGetmovimentabanco(Entidadesdocumentosentregas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 7)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 7, (Object)objPC.movimentabanco);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(7)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"movimentabanco\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.movimentabanco;
    }

    private static void jdoSetmovimentabanco(Entidadesdocumentosentregas objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 7, (Object)objPC.movimentabanco, (Object)val);
        } else {
            objPC.movimentabanco = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(7);
            }
        }
    }

    private static Integer jdoGetnumerolinha(Entidadesdocumentosentregas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 8)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 8, (Object)objPC.numerolinha);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(8)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"numerolinha\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.numerolinha;
    }

    private static void jdoSetnumerolinha(Entidadesdocumentosentregas objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 8, (Object)objPC.numerolinha, (Object)val);
        } else {
            objPC.numerolinha = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(8);
            }
        }
    }

    private static String jdoGetreferencia(Entidadesdocumentosentregas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 9)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 9, objPC.referencia);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(9)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"referencia\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.referencia;
    }

    private static void jdoSetreferencia(Entidadesdocumentosentregas objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 9, objPC.referencia, val);
        } else {
            objPC.referencia = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(9);
            }
        }
    }

    private static BigDecimal jdoGetvalor(Entidadesdocumentosentregas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 10)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 10, (Object)objPC.valor);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(10)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"valor\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.valor;
    }

    private static void jdoSetvalor(Entidadesdocumentosentregas objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 10, (Object)objPC.valor, (Object)val);
        } else {
            objPC.valor = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(10);
            }
        }
    }
}

