/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.jdo.JDODetachedFieldAccessException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.PersistenceManager;
import javax.jdo.identity.StringIdentity;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;
import org.apache.commons.lang.WordUtils;
import org.dma.java.email.EmailAddress;
import org.dma.java.email.EmailRecipients;
import org.dma.java.math.NumericUtils;
import org.dma.java.math.SIGNUM;
import org.dma.java.util.ErrorList;
import org.dma.java.util.MessageLine;
import org.dma.java.util.MessageList;
import org.dma.java.util.StringUtils;
import org.dma.java.util.TimeDateUtils;
import org.dma.services.vies.CheckVatResult;
import org.dma.services.vies.VatNumber;
import org.iban4j.Iban;
import org.iban4j.IbanUtil;
import org.iban4j.UnsupportedCountryException;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.IDatabaseModel;
import org.projectocolibri.api.database.filter.FilterMapRule;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.mapper.TableFieldKey;
import org.projectocolibri.api.database.model.AbstractModel;
import org.projectocolibri.api.database.model.Codigosiva;
import org.projectocolibri.api.database.model.Codigospostais;
import org.projectocolibri.api.database.model.Condicoespagamento;
import org.projectocolibri.api.database.model.Documentostipos;
import org.projectocolibri.api.database.model.Entidadesdocumentos;
import org.projectocolibri.api.database.model.Entidadesmoradas;
import org.projectocolibri.api.database.model.Entidadestipos;
import org.projectocolibri.api.database.model.Familias;
import org.projectocolibri.api.database.model.Grupos;
import org.projectocolibri.api.database.model.Isencoesiva;
import org.projectocolibri.api.database.model.Metodospagamento;
import org.projectocolibri.api.database.model.Moedas;
import org.projectocolibri.api.database.model.Paises;
import org.projectocolibri.api.database.model.Precarios;
import org.projectocolibri.api.database.model.Utilizadores;
import org.projectocolibri.api.database.model.Vendedores;
import org.projectocolibri.api.database.query.QueryDefinition;
import org.projectocolibri.api.database.query.QueryOrdering;
import org.projectocolibri.api.language.LABELS;

@javax.jdo.annotations.PersistenceCapable
public class Entidades
extends AbstractModel
implements Detachable,
PersistenceCapable {
    public static final String NIF_CONSUMIDOR_FINAL = "999999990";
    public static final int tipopreco_artigo = 0;
    public static final int tipopreco_ultimo = 1;
    public static final int retencao_naosujeito = 0;
    public static final int retencao_sujeito = 1;
    public static final int tipoiva_artigo = 0;
    public static final int tipoiva_fixo = 1;
    public static final int sendmail_desligado = 0;
    public static final int sendmail_automatico = 1;
    public static final int estado_inactivo = 0;
    public static final int estado_activo = 1;
    private String key;
    private Utilizadores autor;
    private Utilizadores editor;
    private Entidadestipos tipoentidade;
    @Deprecated
    private Codigospostais codigopostal;
    private Paises pais;
    private Grupos grupo;
    private Familias familia;
    private Vendedores vendedor;
    private Condicoespagamento condicaopagamento;
    private Metodospagamento metodopagamento;
    private Moedas moeda;
    private Precarios precario;
    private Codigosiva codigoiva;
    private Isencoesiva isencaoiva;
    private Date datacriacao;
    private Date dataalteracao;
    private String nome;
    @Deprecated
    private String morada;
    @Deprecated
    private String localidade;
    private String nif;
    private String zona;
    private String telefone;
    private String telefone2;
    private String telemovel;
    private String fax;
    private String email;
    private String email2;
    private String url;
    private String responsavel;
    private String nomebanco;
    @Deprecated
    private String nib;
    private String iban;
    private String obs;
    private String campo1 = "";
    private String campo2 = "";
    private String campo3 = "";
    private String campo4 = "";
    private String campo5 = "";
    private String campo6 = "";
    private String campo7 = "";
    private String campo8 = "";
    private String campo9 = "";
    private String campo10 = "";
    private Integer numero;
    private Integer tipopreco;
    private Integer retencao;
    private Integer regimeiva;
    private Integer tipoiva;
    private Integer sendmail;
    private Integer estado;
    private BigDecimal descontofactura;
    private BigDecimal descontorecibo;
    private BigDecimal limitecredito;
    private BigDecimal totaldebito = BigDecimal.ZERO;
    private BigDecimal totalcredito = BigDecimal.ZERO;
    private BigDecimal saldoreal = BigDecimal.ZERO;
    private BigDecimal saldopendente = BigDecimal.ZERO;
    private BigDecimal saldoprevisto = BigDecimal.ZERO;
    private List<Entidadesmoradas> moradas = new ArrayList<Entidadesmoradas>();
    protected transient StateManager jdoStateManager;
    protected transient byte jdoFlags;
    protected Object[] jdoDetachedState;
    private static final byte[] jdoFieldFlags;
    private static final Class jdoPersistenceCapableSuperclass;
    private static final Class[] jdoFieldTypes;
    private static final String[] jdoFieldNames;
    private static final int jdoInheritedFieldCount;

    public Entidadesdocumentos createDocumento(String tipodocumento) {
        return this.createDocumento(tipodocumento, TimeDateUtils.getCurrentDate());
    }

    public Entidadesdocumentos createDocumento(String tipodocumento, Date datacriacao) {
        Entidadesdocumentos documento = new Entidadesdocumentos(this.manager, tipodocumento, datacriacao);
        documento.setEntidade(this);
        return documento;
    }

    private Entidades() {
        super(TABLES.entidades);
    }

    private Entidades(DatabaseManager manager) {
        super(TABLES.entidades, manager);
    }

    public Entidades(DatabaseManager manager, String tipoentidade) {
        this(manager, tipoentidade, null);
    }

    public Entidades(DatabaseManager manager, String tipoentidade, Integer numero) {
        this(manager, manager.loadEntidadestipos(tipoentidade), numero);
    }

    protected Entidades(DatabaseManager manager, Entidadestipos tipoentidade, Integer numero) {
        this(manager);
        this.autor = manager.getUtilizador();
        this.editor = manager.getUtilizador();
        this.tipoentidade = tipoentidade;
        this.pais = manager.getParametros().getPais();
        this.grupo = manager.loadGrupos(1, 0);
        this.familia = manager.loadFamilias(1, 0);
        this.vendedor = manager.loadVendedores(0);
        this.condicaopagamento = manager.getParametros().getCondicaopagamento();
        this.metodopagamento = manager.getParametros().getMetodopagamento();
        this.moeda = manager.getParametros().getMoeda();
        this.precario = manager.loadPrecarios();
        this.codigoiva = manager.getParametros().getCodigoiva();
        this.isencaoiva = manager.getParametros().getIsencaoiva();
        this.datacriacao = TimeDateUtils.getDateWithoutTime();
        this.dataalteracao = TimeDateUtils.getCurrentDate();
        this.nome = "";
        this.nif = NIF_CONSUMIDOR_FINAL;
        this.zona = "";
        this.telefone = "";
        this.telefone2 = "";
        this.telemovel = "";
        this.fax = "";
        this.email = "";
        this.email2 = "";
        this.url = "";
        this.responsavel = "";
        this.nomebanco = "";
        this.iban = "";
        this.obs = "";
        this.numero = numero == null ? this.getNumero$Default() : numero;
        this.tipopreco = 0;
        this.retencao = 0;
        this.regimeiva = 0;
        this.tipoiva = 0;
        this.sendmail = 0;
        this.estado = 1;
        this.descontofactura = BigDecimal.ZERO;
        this.descontorecibo = BigDecimal.ZERO;
        this.limitecredito = BigDecimal.ZERO;
        this.key = this.generateKey();
        this.addMoradas();
    }

    public void clearDeprecated() {
        Entidades.jdoSetcodigopostal(this, null);
        Entidades.jdoSetmorada(this, null);
        Entidades.jdoSetlocalidade(this, null);
        Entidades.jdoSetnib(this, null);
    }

    public void anonymize() {
        this.setZona("");
        this.setTelefone("");
        this.setTelefone2("");
        this.setTelemovel("");
        this.setFax("");
        this.setEmail("");
        this.setEmail2("");
        this.setUrl("");
        this.setResponsavel("");
        this.setNomebanco("");
        this.setIban("");
        this.setLimitecredito(BigDecimal.ZERO);
        this.setCampo1("");
        this.setCampo2("");
        this.setCampo3("");
        this.setCampo4("");
        this.setCampo5("");
        this.setCampo6("");
        this.setCampo7("");
        this.setCampo8("");
        this.setCampo9("");
        this.setCampo10("");
        this.setObs(new MessageLine((Object)((Object)((Object)LABELS.operacao_registo_anonimizar) + " " + (Object)((Object)LABELS.preposicao_em))).brackets((Object)TimeDateUtils.getCurrentDate()).toString());
    }

    @Override
    public Entidades cloneCopy() {
        Entidades clone = new Entidades(this.manager);
        Entidades.jdoSetkey(clone, Entidades.jdoGetkey(this));
        Entidades.jdoSetautor(clone, Entidades.jdoGetautor(this));
        Entidades.jdoSeteditor(clone, Entidades.jdoGeteditor(this));
        Entidades.jdoSettipoentidade(clone, Entidades.jdoGettipoentidade(this));
        Entidades.jdoSetcodigopostal(clone, Entidades.jdoGetcodigopostal(this));
        Entidades.jdoSetpais(clone, Entidades.jdoGetpais(this));
        Entidades.jdoSetgrupo(clone, Entidades.jdoGetgrupo(this));
        Entidades.jdoSetfamilia(clone, Entidades.jdoGetfamilia(this));
        Entidades.jdoSetvendedor(clone, Entidades.jdoGetvendedor(this));
        Entidades.jdoSetcondicaopagamento(clone, Entidades.jdoGetcondicaopagamento(this));
        Entidades.jdoSetmetodopagamento(clone, Entidades.jdoGetmetodopagamento(this));
        Entidades.jdoSetmoeda(clone, Entidades.jdoGetmoeda(this));
        Entidades.jdoSetprecario(clone, Entidades.jdoGetprecario(this));
        Entidades.jdoSetcodigoiva(clone, Entidades.jdoGetcodigoiva(this));
        Entidades.jdoSetisencaoiva(clone, Entidades.jdoGetisencaoiva(this));
        Entidades.jdoSetdatacriacao(clone, Entidades.jdoGetdatacriacao(this));
        Entidades.jdoSetdataalteracao(clone, Entidades.jdoGetdataalteracao(this));
        Entidades.jdoSetnome(clone, Entidades.jdoGetnome(this));
        Entidades.jdoSetmorada(clone, Entidades.jdoGetmorada(this));
        Entidades.jdoSetlocalidade(clone, Entidades.jdoGetlocalidade(this));
        Entidades.jdoSetnif(clone, Entidades.jdoGetnif(this));
        Entidades.jdoSetzona(clone, Entidades.jdoGetzona(this));
        Entidades.jdoSettelefone(clone, Entidades.jdoGettelefone(this));
        Entidades.jdoSettelefone2(clone, Entidades.jdoGettelefone2(this));
        Entidades.jdoSettelemovel(clone, Entidades.jdoGettelemovel(this));
        Entidades.jdoSetfax(clone, Entidades.jdoGetfax(this));
        Entidades.jdoSetemail(clone, Entidades.jdoGetemail(this));
        Entidades.jdoSetemail2(clone, Entidades.jdoGetemail2(this));
        Entidades.jdoSeturl(clone, Entidades.jdoGeturl(this));
        Entidades.jdoSetresponsavel(clone, Entidades.jdoGetresponsavel(this));
        Entidades.jdoSetnomebanco(clone, Entidades.jdoGetnomebanco(this));
        Entidades.jdoSetnib(clone, Entidades.jdoGetnib(this));
        Entidades.jdoSetiban(clone, Entidades.jdoGetiban(this));
        Entidades.jdoSetobs(clone, Entidades.jdoGetobs(this));
        Entidades.jdoSetcampo1(clone, Entidades.jdoGetcampo1(this));
        Entidades.jdoSetcampo2(clone, Entidades.jdoGetcampo2(this));
        Entidades.jdoSetcampo3(clone, Entidades.jdoGetcampo3(this));
        Entidades.jdoSetcampo4(clone, Entidades.jdoGetcampo4(this));
        Entidades.jdoSetcampo5(clone, Entidades.jdoGetcampo5(this));
        Entidades.jdoSetcampo6(clone, Entidades.jdoGetcampo6(this));
        Entidades.jdoSetcampo7(clone, Entidades.jdoGetcampo7(this));
        Entidades.jdoSetcampo8(clone, Entidades.jdoGetcampo8(this));
        Entidades.jdoSetcampo9(clone, Entidades.jdoGetcampo9(this));
        Entidades.jdoSetcampo10(clone, Entidades.jdoGetcampo10(this));
        Entidades.jdoSetnumero(clone, Entidades.jdoGetnumero(this));
        Entidades.jdoSetregimeiva(clone, Entidades.jdoGetregimeiva(this));
        Entidades.jdoSettipoiva(clone, Entidades.jdoGettipoiva(this));
        Entidades.jdoSettipopreco(clone, Entidades.jdoGettipopreco(this));
        Entidades.jdoSetretencao(clone, Entidades.jdoGetretencao(this));
        Entidades.jdoSetsendmail(clone, Entidades.jdoGetsendmail(this));
        Entidades.jdoSetestado(clone, Entidades.jdoGetestado(this));
        Entidades.jdoSetdescontofactura(clone, Entidades.jdoGetdescontofactura(this));
        Entidades.jdoSetdescontorecibo(clone, Entidades.jdoGetdescontorecibo(this));
        Entidades.jdoSetlimitecredito(clone, Entidades.jdoGetlimitecredito(this));
        Entidades.jdoSettotaldebito(clone, Entidades.jdoGettotaldebito(this));
        Entidades.jdoSettotalcredito(clone, Entidades.jdoGettotalcredito(this));
        Entidades.jdoSetsaldoreal(clone, Entidades.jdoGetsaldoreal(this));
        Entidades.jdoSetsaldopendente(clone, Entidades.jdoGetsaldopendente(this));
        Entidades.jdoSetsaldoprevisto(clone, Entidades.jdoGetsaldoprevisto(this));
        ArrayList<Entidadesmoradas> moradas = new ArrayList<Entidadesmoradas>();
        for (Entidadesmoradas linha : Entidades.jdoGetmoradas(this)) {
            moradas.add(linha.cloneCopy(clone));
        }
        Entidades.jdoSetmoradas(clone, moradas);
        return clone;
    }

    public Entidades cleanCopy() {
        Entidades clone = this.cloneCopy();
        Entidades.jdoSetautor(clone, this.manager.getUtilizador());
        Entidades.jdoSeteditor(clone, this.manager.getUtilizador());
        Entidades.jdoSetdatacriacao(clone, TimeDateUtils.getCurrentDate());
        Entidades.jdoSetdataalteracao(clone, TimeDateUtils.getCurrentDate());
        Entidades.jdoSettotaldebito(clone, BigDecimal.ZERO);
        Entidades.jdoSettotalcredito(clone, BigDecimal.ZERO);
        Entidades.jdoSetsaldoreal(clone, BigDecimal.ZERO);
        Entidades.jdoSetsaldopendente(clone, BigDecimal.ZERO);
        Entidades.jdoSetsaldoprevisto(clone, BigDecimal.ZERO);
        Entidades.jdoSetnumero(clone, clone.getNumero$Default());
        clone.setKey();
        clone.markDirty();
        return clone;
    }

    @Override
    public MessageList validate(IDatabaseModel.ACTION action) {
        return this.validate(action, null);
    }

    public MessageList validate(IDatabaseModel.ACTION action, Entidades stored) {
        MessageList error = super.validate(action);
        for (Entidadesmoradas linha : Entidades.jdoGetmoradas(this)) {
            error.add(linha.validate(action));
        }
        switch (action) {
            case DELETE: {
                if (this.hasTotaldebito()) {
                    error.add((Object)new MessageLine((Object)LABELS.entidades_totaldebito).notEqual((Object)0));
                }
                if (!this.hasTotalcredito()) break;
                error.add((Object)new MessageLine((Object)LABELS.entidades_totalcredito).notEqual((Object)0));
                break;
            }
            case STORE: {
                error.add(this.validate(stored, FIELDS.entidades_totaldebito, FIELDS.entidades_totalcredito, FIELDS.entidades_saldoreal, FIELDS.entidades_saldopendente, FIELDS.entidades_saldoprevisto));
                if (Entidades.jdoGetmoradas(this).size() == 0) {
                    error.add((Object)new MessageLine((Object)LABELS.entidades_moradas));
                }
                if (!this.isNumeroValid()) {
                    error.add((Object)new MessageLine((Object)LABELS.entidades_numero));
                }
                if (!this.isNifValid()) {
                    error.add((Object)new MessageLine((Object)LABELS.entidades_nif));
                }
                if (stored != null && !stored.isNifEditable() && !this.isNifEqual(stored)) {
                    error.add((Object)new MessageLine((Object)LABELS.entidades_nif).notEqual((Object)stored.getNif()));
                }
                if (stored != null && !this.isNomeEditable() && !Entidades.jdoGetnome(this).equals(stored.getNome())) {
                    error.add((Object)new MessageLine((Object)LABELS.entidades_nome));
                }
                if (!this.isPaisValid()) {
                    error.add(LABELS.entidades_pais.toString());
                }
                if (this.isCodigoivaValid()) break;
                error.add((Object)new MessageLine((Object)LABELS.entidades_codigoiva));
            }
        }
        return error;
    }

    public ErrorList warnings(PersistenceManager pm) {
        Integer numero;
        ErrorList error = new ErrorList();
        String nif = this.getNifParsed();
        QueryDefinition query = new QueryDefinition(TABLES.entidades, new QueryOrdering(QueryOrdering.DIRECTION.ASCENDING, new TableFieldKey(FIELDS.entidades_numero)));
        query.addRule(new FilterMapRule(FIELDS.entidades_tipoentidade, FIELDS.entidadestipos_codigo).equal(Entidades.jdoGettipoentidade(this).getCodigo())).addRule(new FilterMapRule(FIELDS.entidades_pais, FIELDS.paises_codigo).equal(Entidades.jdoGetpais(this).getCodigo())).addRule(new FilterMapRule(FIELDS.entidades_nif).compact().equal(nif).or().equal(String.valueOf(Entidades.jdoGetpais(this).getCodigo()) + nif));
        ArrayList col = new ArrayList(query.execute(pm));
        query.close();
        col.remove(this);
        Integer n = numero = col.isEmpty() ? null : ((Entidades)col.iterator().next()).getNumero();
        if (numero != null) {
            error.warnings().add((Object)new MessageLine((Object)LABELS.erro_campo_existe.format(String.valueOf(LABELS.entidades_nif.toString()) + " " + nif)).brackets((Object)(String.valueOf(Entidades.jdoGettipoentidade(this).getTipoentidadeToText()) + " " + numero)));
        }
        return error;
    }

    @Override
    public String getKey() {
        return Entidades.jdoGetkey(this);
    }

    public void setKey(String key) {
        String string = Entidades.jdoGetkey(this);
        String string2 = key;
        Entidades.jdoSetkey(this, string2);
        this.firePropertyChange(FIELDS.entidades_key, (Object)string, (Object)string2);
    }

    void setKey() {
        this.setKey(this.generateKey());
        for (Entidadesmoradas linha : Entidades.jdoGetmoradas(this)) {
            linha.setKey();
        }
    }

    String generateKey() {
        return Entidades.jdoGettipoentidade(this) == null || Entidades.jdoGetnumero(this) == null ? null : Entidades.generateKey(Entidades.jdoGettipoentidade(this).getCodigo(), Entidades.jdoGetnumero(this));
    }

    public static String generateKey(String tipoentidade, Integer numero) {
        return String.valueOf(tipoentidade) + ":" + numero;
    }

    public Utilizadores getAutor() {
        return Entidades.jdoGetautor(this);
    }

    public void setAutor(Utilizadores autor) {
        Utilizadores utilizadores = Entidades.jdoGetautor(this);
        Utilizadores utilizadores2 = autor;
        Entidades.jdoSetautor(this, utilizadores2);
        this.firePropertyChange(FIELDS.entidades_autor, (Object)utilizadores, (Object)utilizadores2);
    }

    public Utilizadores getEditor() {
        return Entidades.jdoGeteditor(this);
    }

    public void setEditor(Utilizadores editor) {
        Utilizadores utilizadores = Entidades.jdoGeteditor(this);
        Utilizadores utilizadores2 = editor;
        Entidades.jdoSeteditor(this, utilizadores2);
        this.firePropertyChange(FIELDS.entidades_editor, (Object)utilizadores, (Object)utilizadores2);
    }

    public Entidadestipos getTipoentidade() {
        return Entidades.jdoGettipoentidade(this);
    }

    public void setTipoentidade(Entidadestipos tipoentidade) {
        Entidadestipos entidadestipos = Entidades.jdoGettipoentidade(this);
        Entidadestipos entidadestipos2 = tipoentidade;
        Entidades.jdoSettipoentidade(this, entidadestipos2);
        this.firePropertyChange(FIELDS.entidades_tipoentidade, (Object)entidadestipos, (Object)entidadestipos2);
        this.setKey();
    }

    public Codigospostais getCodigopostal() {
        return Entidades.jdoGetmoradas(this).isEmpty() ? Entidades.jdoGetcodigopostal(this) : ((Entidadesmoradas)Entidades.jdoGetmoradas(this).get(0)).getCodigopostal();
    }

    public void setCodigopostal(Codigospostais codigopostal) {
        if (!Entidades.jdoGetmoradas(this).isEmpty()) {
            ((Entidadesmoradas)Entidades.jdoGetmoradas(this).get(0)).setCodigopostal(codigopostal);
        }
    }

    public boolean isCodigopostalValid() {
        return !Entidades.jdoGetmoradas(this).isEmpty() && ((Entidadesmoradas)Entidades.jdoGetmoradas(this).get(0)).isCodigopostalValid();
    }

    public Paises getPais() {
        return Entidades.jdoGetpais(this);
    }

    public void setPais(Paises pais) {
        Paises paises = Entidades.jdoGetpais(this);
        Paises paises2 = pais;
        Entidades.jdoSetpais(this, paises2);
        boolean changed = this.firePropertyChange(FIELDS.entidades_pais, (Object)paises, (Object)paises2);
        if (changed && !Entidades.jdoGetmoradas(this).isEmpty()) {
            ((Entidadesmoradas)Entidades.jdoGetmoradas(this).get(0)).setPais(pais);
        }
    }

    public boolean isPaisValid() {
        return !Entidades.jdoGetmoradas(this).isEmpty() && ((Entidadesmoradas)Entidades.jdoGetmoradas(this).get(0)).isPaisValid();
    }

    public Grupos getGrupo() {
        return Entidades.jdoGetgrupo(this);
    }

    public void setGrupo(Grupos grupo) {
        Grupos grupos = Entidades.jdoGetgrupo(this);
        Grupos grupos2 = grupo;
        Entidades.jdoSetgrupo(this, grupos2);
        this.firePropertyChange(FIELDS.entidades_grupo, (Object)grupos, (Object)grupos2);
    }

    public Familias getFamilia() {
        return Entidades.jdoGetfamilia(this);
    }

    public void setFamilia(Familias familia) {
        Familias familias = Entidades.jdoGetfamilia(this);
        Familias familias2 = familia;
        Entidades.jdoSetfamilia(this, familias2);
        this.firePropertyChange(FIELDS.entidades_familia, (Object)familias, (Object)familias2);
    }

    public Vendedores getVendedor() {
        return Entidades.jdoGetvendedor(this);
    }

    public void setVendedor(Vendedores vendedor) {
        Vendedores vendedores = Entidades.jdoGetvendedor(this);
        Vendedores vendedores2 = vendedor;
        Entidades.jdoSetvendedor(this, vendedores2);
        this.firePropertyChange(FIELDS.entidades_vendedor, (Object)vendedores, (Object)vendedores2);
    }

    public Condicoespagamento getCondicaopagamento() {
        return Entidades.jdoGetcondicaopagamento(this);
    }

    public void setCondicaopagamento(Condicoespagamento condicaopagamento) {
        Condicoespagamento condicoespagamento = Entidades.jdoGetcondicaopagamento(this);
        Condicoespagamento condicoespagamento2 = condicaopagamento;
        Entidades.jdoSetcondicaopagamento(this, condicoespagamento2);
        this.firePropertyChange(FIELDS.entidades_condicaopagamento, (Object)condicoespagamento, (Object)condicoespagamento2);
    }

    public Metodospagamento getMetodopagamento() {
        return Entidades.jdoGetmetodopagamento(this);
    }

    public void setMetodopagamento(Metodospagamento metodopagamento) {
        Metodospagamento metodospagamento = Entidades.jdoGetmetodopagamento(this);
        Metodospagamento metodospagamento2 = metodopagamento;
        Entidades.jdoSetmetodopagamento(this, metodospagamento2);
        this.firePropertyChange(FIELDS.entidades_metodopagamento, (Object)metodospagamento, (Object)metodospagamento2);
    }

    public Moedas getMoeda() {
        return Entidades.jdoGetmoeda(this);
    }

    public void setMoeda(Moedas moeda) {
        Moedas moedas = Entidades.jdoGetmoeda(this);
        Moedas moedas2 = moeda;
        Entidades.jdoSetmoeda(this, moedas2);
        this.firePropertyChange(FIELDS.entidades_moeda, (Object)moedas, (Object)moedas2);
    }

    public Precarios getPrecario() {
        return Entidades.jdoGetprecario(this);
    }

    public void setPrecario(Precarios precario) {
        Precarios precarios = Entidades.jdoGetprecario(this);
        Precarios precarios2 = precario;
        Entidades.jdoSetprecario(this, precarios2);
        this.firePropertyChange(FIELDS.entidades_precario, (Object)precarios, (Object)precarios2);
    }

    public boolean isPrecarioAvailable() {
        return Entidades.jdoGettipoentidade(this).isTipoentidade(0);
    }

    public Codigosiva getCodigoiva() {
        return Entidades.jdoGetcodigoiva(this);
    }

    public void setCodigoiva(Codigosiva codigoiva) {
        Codigosiva codigosiva = Entidades.jdoGetcodigoiva(this);
        Codigosiva codigosiva2 = codigoiva;
        Entidades.jdoSetcodigoiva(this, codigosiva2);
        this.firePropertyChange(FIELDS.entidades_codigoiva, (Object)codigosiva, (Object)codigosiva2);
    }

    public boolean isCodigoivaValid() {
        return this.isTipoiva(0) || Entidades.jdoGetcodigoiva(this) != null && Entidades.jdoGetcodigoiva(this).isValid(Entidades.jdoGetisencaoiva(this));
    }

    public Isencoesiva getIsencaoiva() {
        return Entidades.jdoGetisencaoiva(this);
    }

    public void setIsencaoiva(Isencoesiva isencaoiva) {
        Isencoesiva isencoesiva = Entidades.jdoGetisencaoiva(this);
        Isencoesiva isencoesiva2 = isencaoiva;
        Entidades.jdoSetisencaoiva(this, isencoesiva2);
        this.firePropertyChange(FIELDS.entidades_isencaoiva, (Object)isencoesiva, (Object)isencoesiva2);
    }

    public Date getDatacriacao() {
        return Entidades.jdoGetdatacriacao(this);
    }

    public String getDatacriacaoToText() {
        return Entidades.jdoGetdatacriacao(this) == null ? "" : FIELDS.entidades_datacriacao.format.format(Entidades.jdoGetdatacriacao(this));
    }

    public void setDatacriacao(Date datacriacao) {
        Date date = Entidades.jdoGetdatacriacao(this);
        Date date2 = TimeDateUtils.getDateWithoutTime((Date)datacriacao);
        Entidades.jdoSetdatacriacao(this, date2);
        this.firePropertyChange(FIELDS.entidades_datacriacao, (Object)date, (Object)date2);
    }

    public Date getDataalteracao() {
        return Entidades.jdoGetdataalteracao(this);
    }

    public String getDataalteracaoToText() {
        return Entidades.jdoGetdataalteracao(this) == null ? "" : FIELDS.entidades_dataalteracao.format.format(Entidades.jdoGetdataalteracao(this));
    }

    public void setDataalteracao(Date dataalteracao) {
        Date date = Entidades.jdoGetdataalteracao(this);
        Date date2 = dataalteracao;
        Entidades.jdoSetdataalteracao(this, date2);
        this.firePropertyChange(FIELDS.entidades_dataalteracao, (Object)date, (Object)date2);
    }

    public String getNome() {
        return Entidades.jdoGetnome(this);
    }

    public String getNomeToText() {
        return Entidades.jdoGetnome(this) == null ? "" : Entidades.jdoGetnome(this).toString();
    }

    public void setNome(String nome) {
        String string = Entidades.jdoGetnome(this);
        String string2 = nome;
        Entidades.jdoSetnome(this, string2);
        this.firePropertyChange(FIELDS.entidades_nome, (Object)string, (Object)string2);
    }

    public boolean isNomeEditable() {
        return !this.isNifGenerico() || this.manager.getUtilizador().isColibri();
    }

    public String getMorada() {
        return Entidades.jdoGetmoradas(this).isEmpty() ? Entidades.jdoGetmorada(this) : ((Entidadesmoradas)Entidades.jdoGetmoradas(this).get(0)).getMorada();
    }

    public String getMoradaToText() {
        return Entidades.jdoGetmoradas(this).isEmpty() ? "" : ((Entidadesmoradas)Entidades.jdoGetmoradas(this).get(0)).getMoradaToText();
    }

    public void setMorada(String morada) {
        if (!Entidades.jdoGetmoradas(this).isEmpty()) {
            ((Entidadesmoradas)Entidades.jdoGetmoradas(this).get(0)).setMorada(morada);
        }
    }

    public void setMorada(Entidadesmoradas morada) {
        this.setMorada(morada.getMorada());
        this.setCodigopostal(morada.getCodigopostal());
        this.setLocalidade(morada.getLocalidade());
        this.setPais(morada.getPais());
    }

    public void setVatResult(CheckVatResult result) {
        this.setNome(WordUtils.capitalizeFully((String)FIELDS.entidades_nome.format.parse(result.getName()).toString()));
        Entidadesmoradas morada = (Entidadesmoradas)Entidades.jdoGetmoradas(this).get(0);
        morada.setMorada(result.getAddress());
        this.setMorada(morada);
    }

    public String getLocalidade() {
        return Entidades.jdoGetmoradas(this).isEmpty() ? Entidades.jdoGetlocalidade(this) : ((Entidadesmoradas)Entidades.jdoGetmoradas(this).get(0)).getLocalidade();
    }

    public String getLocalidadeToText() {
        return Entidades.jdoGetmoradas(this).isEmpty() ? "" : ((Entidadesmoradas)Entidades.jdoGetmoradas(this).get(0)).getLocalidadeToText();
    }

    public void setLocalidade(String localidade) {
        if (!Entidades.jdoGetmoradas(this).isEmpty()) {
            ((Entidadesmoradas)Entidades.jdoGetmoradas(this).get(0)).setLocalidade(localidade);
        }
    }

    public String getNif() {
        return Entidades.jdoGetnif(this);
    }

    public String getNifToText() {
        return Entidades.jdoGetnif(this) == null ? "" : Entidades.jdoGetnif(this).toString();
    }

    public void setNif(String nif) {
        String string = Entidades.jdoGetnif(this);
        String string2 = nif;
        Entidades.jdoSetnif(this, string2);
        this.firePropertyChange(FIELDS.entidades_nif, (Object)string, (Object)string2);
    }

    public String getNifToNumbers() {
        return StringUtils.numbers((String)this.getNifToText());
    }

    public Integer getNifToInteger() {
        return StringUtils.val((String)this.getNifToNumbers());
    }

    public String getNifParsed() {
        return Entidades.jdoGetpais(this) == null ? Entidades.jdoGetnif(this) : Entidades.jdoGetpais(this).parseNif(Entidades.jdoGetnif(this));
    }

    public boolean isNifEqual(Paises pais, String nif) {
        return pais != null && pais.equals(pais) && pais.parseNif(nif).equals(this.getNifParsed());
    }

    public boolean isNifEqual(Entidades other) {
        return other.isNifEqual(Entidades.jdoGetpais(this), Entidades.jdoGetnif(this));
    }

    public boolean isNifValid() {
        return Entidades.jdoGetpais(this) != null && Entidades.jdoGetpais(this).isNifValid(Entidades.jdoGetnif(this));
    }

    public boolean isNifGenerico() {
        return Entidades.jdoGetpais(this) != null && Entidades.jdoGetpais(this).isNifGenerico(Entidades.jdoGetnif(this));
    }

    public boolean isNifEditable() {
        return !this.isNifValid() || this.isNifGenerico() || !this.hasTotaldebito() && !this.hasTotalcredito();
    }

    public boolean existsNif() {
        Collection<Integer> col = this.manager.getEntidadesCollection$Numero(Entidades.jdoGettipoentidade(this).getCodigo(), Entidades.jdoGetpais(this).getCodigo(), Entidades.jdoGetnif(this), new int[0]);
        col.remove(Entidades.jdoGetnumero(this));
        return !col.isEmpty();
    }

    public CheckVatResult checkNif() throws Exception {
        return new VatNumber(Entidades.jdoGetpais(this).getCodigo(), Entidades.jdoGetnif(this)).query();
    }

    public NIF_TYPE getNIFType() {
        return NIF_TYPE.get(Entidades.jdoGetpais(this), this.getNifParsed());
    }

    public String getZona() {
        return this.parseRGPDValue(Entidades.jdoGetzona(this));
    }

    public String getZonaToText() {
        return Entidades.jdoGetzona(this) == null ? "" : Entidades.jdoGetzona(this).toString();
    }

    public void setZona(String zona) {
        String string = Entidades.jdoGetzona(this);
        String string2 = this.getRGPDValue(Entidades.jdoGetzona(this), zona);
        Entidades.jdoSetzona(this, string2);
        this.firePropertyChange(FIELDS.entidades_zona, (Object)string, (Object)string2);
    }

    public String getTelefone() {
        return this.parseRGPDValue(Entidades.jdoGettelefone(this));
    }

    public String getTelefoneToText() {
        return Entidades.jdoGettelefone(this) == null ? "" : Entidades.jdoGettelefone(this).toString();
    }

    public void setTelefone(String telefone) {
        String string = Entidades.jdoGettelefone(this);
        String string2 = this.getRGPDValue(Entidades.jdoGettelefone(this), telefone);
        Entidades.jdoSettelefone(this, string2);
        this.firePropertyChange(FIELDS.entidades_telefone, (Object)string, (Object)string2);
    }

    public String getTelefone2() {
        return this.parseRGPDValue(Entidades.jdoGettelefone2(this));
    }

    public String getTelefone2ToText() {
        return Entidades.jdoGettelefone2(this) == null ? "" : Entidades.jdoGettelefone2(this).toString();
    }

    public void setTelefone2(String telefone2) {
        String string = Entidades.jdoGettelefone2(this);
        String string2 = this.getRGPDValue(Entidades.jdoGettelefone2(this), telefone2);
        Entidades.jdoSettelefone2(this, string2);
        this.firePropertyChange(FIELDS.entidades_telefone2, (Object)string, (Object)string2);
    }

    public String getTelemovel() {
        return this.parseRGPDValue(Entidades.jdoGettelemovel(this));
    }

    public String getTelemovelToText() {
        return Entidades.jdoGettelemovel(this) == null ? "" : Entidades.jdoGettelemovel(this).toString();
    }

    public void setTelemovel(String telemovel) {
        String string = Entidades.jdoGettelemovel(this);
        String string2 = this.getRGPDValue(Entidades.jdoGettelemovel(this), telemovel);
        Entidades.jdoSettelemovel(this, string2);
        this.firePropertyChange(FIELDS.entidades_telemovel, (Object)string, (Object)string2);
    }

    public String getFax() {
        return this.parseRGPDValue(Entidades.jdoGetfax(this));
    }

    public String getFaxToText() {
        return Entidades.jdoGetfax(this) == null ? "" : Entidades.jdoGetfax(this).toString();
    }

    public void setFax(String fax) {
        String string = Entidades.jdoGetfax(this);
        String string2 = this.getRGPDValue(Entidades.jdoGetfax(this), fax);
        Entidades.jdoSetfax(this, string2);
        this.firePropertyChange(FIELDS.entidades_fax, (Object)string, (Object)string2);
    }

    public String getEmail() {
        return this.parseRGPDValue(Entidades.jdoGetemail(this));
    }

    public String getEmailToText() {
        return Entidades.jdoGetemail(this) == null ? "" : Entidades.jdoGetemail(this).toString();
    }

    public void setEmail(String email) {
        String string = Entidades.jdoGetemail(this);
        String string2 = this.getRGPDValue(Entidades.jdoGetemail(this), email);
        Entidades.jdoSetemail(this, string2);
        this.firePropertyChange(FIELDS.entidades_email, (Object)string, (Object)string2);
    }

    public EmailAddress getEmailAddress() {
        return this.getEmailToText().isEmpty() ? null : new EmailAddress(Entidades.jdoGetemail(this), Entidades.jdoGetnome(this));
    }

    public boolean isEmailValid() {
        EmailAddress address = this.getEmailAddress();
        return address == null || address.isValid();
    }

    public String getEmail2() {
        return this.parseRGPDValue(Entidades.jdoGetemail2(this));
    }

    public String getEmail2ToText() {
        return Entidades.jdoGetemail2(this) == null ? "" : Entidades.jdoGetemail2(this).toString();
    }

    public void setEmail2(String email2) {
        String string = Entidades.jdoGetemail2(this);
        String string2 = this.getRGPDValue(Entidades.jdoGetemail2(this), email2);
        Entidades.jdoSetemail2(this, string2);
        this.firePropertyChange(FIELDS.entidades_email2, (Object)string, (Object)string2);
    }

    public EmailAddress getEmail2Address() {
        return this.getEmail2ToText().isEmpty() ? null : new EmailAddress(Entidades.jdoGetemail2(this), Entidades.jdoGetnome(this));
    }

    public boolean isEmail2Valid() {
        EmailAddress address = this.getEmail2Address();
        return address == null || address.isValid();
    }

    public EmailRecipients getEmailRecipients() {
        EmailRecipients recipients = new EmailRecipients();
        EmailAddress[] emailAddressArray = new EmailAddress[]{this.getEmailAddress(), this.getEmail2Address()};
        int n = emailAddressArray.length;
        int n2 = 0;
        while (n2 < n) {
            EmailAddress address = emailAddressArray[n2];
            if (address != null) {
                recipients.add(address);
            }
            ++n2;
        }
        return recipients;
    }

    public String getUrl() {
        return this.parseRGPDValue(Entidades.jdoGeturl(this));
    }

    public String getUrlToText() {
        return Entidades.jdoGeturl(this) == null ? "" : Entidades.jdoGeturl(this).toString();
    }

    public void setUrl(String url) {
        String string = Entidades.jdoGeturl(this);
        String string2 = this.getRGPDValue(Entidades.jdoGeturl(this), url);
        Entidades.jdoSeturl(this, string2);
        this.firePropertyChange(FIELDS.entidades_url, (Object)string, (Object)string2);
    }

    public String getResponsavel() {
        return this.parseRGPDValue(Entidades.jdoGetresponsavel(this));
    }

    public String getResponsavelToText() {
        return Entidades.jdoGetresponsavel(this) == null ? "" : Entidades.jdoGetresponsavel(this).toString();
    }

    public void setResponsavel(String responsavel) {
        String string = Entidades.jdoGetresponsavel(this);
        String string2 = this.getRGPDValue(Entidades.jdoGetresponsavel(this), responsavel);
        Entidades.jdoSetresponsavel(this, string2);
        this.firePropertyChange(FIELDS.entidades_responsavel, (Object)string, (Object)string2);
    }

    public String getNomebanco() {
        return this.parseRGPDValue(Entidades.jdoGetnomebanco(this));
    }

    public String getNomebancoToText() {
        return Entidades.jdoGetnomebanco(this) == null ? "" : Entidades.jdoGetnomebanco(this).toString();
    }

    public void setNomebanco(String nomebanco) {
        String string = Entidades.jdoGetnomebanco(this);
        String string2 = this.getRGPDValue(Entidades.jdoGetnomebanco(this), nomebanco);
        Entidades.jdoSetnomebanco(this, string2);
        this.firePropertyChange(FIELDS.entidades_nomebanco, (Object)string, (Object)string2);
    }

    public String getIban() {
        return this.parseRGPDValue(Entidades.jdoGetiban(this));
    }

    public String getIbanToText() {
        if (Entidades.jdoGetiban(this) != null) {
            try {
                String compacted = StringUtils.compact((String)Entidades.jdoGetiban(this)).toUpperCase();
                return Iban.valueOf((String)compacted).toFormattedString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    public void setIban(String iban) {
        String string = Entidades.jdoGetiban(this);
        String string2 = this.getRGPDValue(Entidades.jdoGetiban(this), iban);
        Entidades.jdoSetiban(this, string2);
        this.firePropertyChange(FIELDS.entidades_iban, (Object)string, (Object)string2);
    }

    public boolean isIbanValid() {
        if (!StringUtils.isEmpty((String)Entidades.jdoGetiban(this))) {
            try {
                String compacted = StringUtils.compact((String)Entidades.jdoGetiban(this)).toUpperCase();
                IbanUtil.validate((String)compacted);
            }
            catch (UnsupportedCountryException compacted) {
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    @Deprecated
    public String getNib() {
        if (Entidades.jdoGetnib(this) == null) {
            try {
                String compacted = Entidades.jdoGetiban(this) == null ? "" : StringUtils.compact((String)Entidades.jdoGetiban(this)).toUpperCase();
                return Iban.valueOf((String)compacted).getBban();
            }
            catch (Exception e) {
                return this.getIbanToText();
            }
        }
        return Entidades.jdoGetnib(this);
    }

    public String getObs() {
        return this.parseRGPDValue(Entidades.jdoGetobs(this));
    }

    public String getObsToText() {
        return Entidades.jdoGetobs(this) == null ? "" : FIELDS.entidades_obs.format.format(Entidades.jdoGetobs(this));
    }

    public void setObs(String obs) {
        String string = Entidades.jdoGetobs(this);
        String string2 = this.getRGPDValue(Entidades.jdoGetobs(this), obs);
        Entidades.jdoSetobs(this, string2);
        this.firePropertyChange(FIELDS.entidades_obs, (Object)string, (Object)string2);
    }

    public String getCampo1() {
        return this.parseRGPDValue(Entidades.jdoGetcampo1(this));
    }

    public String getCampo1ToText() {
        return Entidades.jdoGetcampo1(this) == null ? "" : Entidades.jdoGetcampo1(this).toString();
    }

    public void setCampo1(String campo1) {
        String string = Entidades.jdoGetcampo1(this);
        String string2 = this.getRGPDValue(Entidades.jdoGetcampo1(this), campo1);
        Entidades.jdoSetcampo1(this, string2);
        this.firePropertyChange(FIELDS.entidades_campo1, (Object)string, (Object)string2);
    }

    public String getCampo2() {
        return this.parseRGPDValue(Entidades.jdoGetcampo2(this));
    }

    public String getCampo2ToText() {
        return Entidades.jdoGetcampo2(this) == null ? "" : Entidades.jdoGetcampo2(this).toString();
    }

    public void setCampo2(String campo2) {
        String string = Entidades.jdoGetcampo2(this);
        String string2 = this.getRGPDValue(Entidades.jdoGetcampo2(this), campo2);
        Entidades.jdoSetcampo2(this, string2);
        this.firePropertyChange(FIELDS.entidades_campo2, (Object)string, (Object)string2);
    }

    public String getCampo3() {
        return this.parseRGPDValue(Entidades.jdoGetcampo3(this));
    }

    public String getCampo3ToText() {
        return Entidades.jdoGetcampo3(this) == null ? "" : Entidades.jdoGetcampo3(this).toString();
    }

    public void setCampo3(String campo3) {
        String string = Entidades.jdoGetcampo3(this);
        String string2 = this.getRGPDValue(Entidades.jdoGetcampo3(this), campo3);
        Entidades.jdoSetcampo3(this, string2);
        this.firePropertyChange(FIELDS.entidades_campo3, (Object)string, (Object)string2);
    }

    public String getCampo4() {
        return this.parseRGPDValue(Entidades.jdoGetcampo4(this));
    }

    public String getCampo4ToText() {
        return Entidades.jdoGetcampo4(this) == null ? "" : Entidades.jdoGetcampo4(this).toString();
    }

    public void setCampo4(String campo4) {
        String string = Entidades.jdoGetcampo4(this);
        String string2 = this.getRGPDValue(Entidades.jdoGetcampo4(this), campo4);
        Entidades.jdoSetcampo4(this, string2);
        this.firePropertyChange(FIELDS.entidades_campo4, (Object)string, (Object)string2);
    }

    public String getCampo5() {
        return this.parseRGPDValue(Entidades.jdoGetcampo5(this));
    }

    public String getCampo5ToText() {
        return Entidades.jdoGetcampo5(this) == null ? "" : Entidades.jdoGetcampo5(this).toString();
    }

    public void setCampo5(String campo5) {
        String string = Entidades.jdoGetcampo5(this);
        String string2 = this.getRGPDValue(Entidades.jdoGetcampo5(this), campo5);
        Entidades.jdoSetcampo5(this, string2);
        this.firePropertyChange(FIELDS.entidades_campo5, (Object)string, (Object)string2);
    }

    public String getCampo6() {
        return this.parseRGPDValue(Entidades.jdoGetcampo6(this));
    }

    public String getCampo6ToText() {
        return Entidades.jdoGetcampo6(this) == null ? "" : Entidades.jdoGetcampo6(this).toString();
    }

    public void setCampo6(String campo6) {
        String string = Entidades.jdoGetcampo6(this);
        String string2 = this.getRGPDValue(Entidades.jdoGetcampo6(this), campo6);
        Entidades.jdoSetcampo6(this, string2);
        this.firePropertyChange(FIELDS.entidades_campo6, (Object)string, (Object)string2);
    }

    public String getCampo7() {
        return this.parseRGPDValue(Entidades.jdoGetcampo7(this));
    }

    public String getCampo7ToText() {
        return Entidades.jdoGetcampo7(this) == null ? "" : Entidades.jdoGetcampo7(this).toString();
    }

    public void setCampo7(String campo7) {
        String string = Entidades.jdoGetcampo7(this);
        String string2 = this.getRGPDValue(Entidades.jdoGetcampo7(this), campo7);
        Entidades.jdoSetcampo7(this, string2);
        this.firePropertyChange(FIELDS.entidades_campo7, (Object)string, (Object)string2);
    }

    public String getCampo8() {
        return this.parseRGPDValue(Entidades.jdoGetcampo8(this));
    }

    public String getCampo8ToText() {
        return Entidades.jdoGetcampo8(this) == null ? "" : Entidades.jdoGetcampo8(this).toString();
    }

    public void setCampo8(String campo8) {
        String string = Entidades.jdoGetcampo8(this);
        String string2 = this.getRGPDValue(Entidades.jdoGetcampo8(this), campo8);
        Entidades.jdoSetcampo8(this, string2);
        this.firePropertyChange(FIELDS.entidades_campo8, (Object)string, (Object)string2);
    }

    public String getCampo9() {
        return this.parseRGPDValue(Entidades.jdoGetcampo9(this));
    }

    public String getCampo9ToText() {
        return Entidades.jdoGetcampo9(this) == null ? "" : Entidades.jdoGetcampo9(this).toString();
    }

    public void setCampo9(String campo9) {
        String string = Entidades.jdoGetcampo9(this);
        String string2 = this.getRGPDValue(Entidades.jdoGetcampo9(this), campo9);
        Entidades.jdoSetcampo9(this, string2);
        this.firePropertyChange(FIELDS.entidades_campo9, (Object)string, (Object)string2);
    }

    public String getCampo10() {
        return this.parseRGPDValue(Entidades.jdoGetcampo10(this));
    }

    public String getCampo10ToText() {
        return Entidades.jdoGetcampo10(this) == null ? "" : Entidades.jdoGetcampo10(this).toString();
    }

    public void setCampo10(String campo10) {
        String string = Entidades.jdoGetcampo10(this);
        String string2 = this.getRGPDValue(Entidades.jdoGetcampo10(this), campo10);
        Entidades.jdoSetcampo10(this, string2);
        this.firePropertyChange(FIELDS.entidades_campo10, (Object)string, (Object)string2);
    }

    public Integer getNumero() {
        return Entidades.jdoGetnumero(this);
    }

    public String getNumeroToText() {
        return Entidades.jdoGetnumero(this) == null ? "" : Entidades.jdoGetnumero(this).toString();
    }

    public void setNumero(Integer numero) {
        Integer n = Entidades.jdoGetnumero(this);
        Integer n2 = numero;
        Entidades.jdoSetnumero(this, n2);
        this.firePropertyChange(FIELDS.entidades_numero, (Object)n, (Object)n2);
        this.setKey();
    }

    public Integer getNumero$Next() {
        return this.manager.getEntidades$NextNumero(Entidades.jdoGettipoentidade(this).getCodigo());
    }

    public Integer getNumero$Default() {
        return Colibri.VERSION_TYPE == Colibri.VERSIONS.SERVER ? -1 : this.getNumero$Next();
    }

    public boolean isNumeroValid() {
        boolean valid = FIELDS.entidades_numero.isValid(Entidades.jdoGetnumero(this));
        return valid || this.isEdited();
    }

    @Deprecated
    public Integer getTerritorio() {
        return null;
    }

    public Integer getTipopreco() {
        return Entidades.jdoGettipopreco(this);
    }

    public String getTipoprecoToText() {
        return Entidades.jdoGettipopreco(this) == null ? "" : FIELDS.entidades_tipopreco.values[Entidades.jdoGettipopreco(this)];
    }

    public void setTipopreco(Integer tipopreco) {
        Integer n = Entidades.jdoGettipopreco(this);
        Integer n2 = tipopreco;
        Entidades.jdoSettipopreco(this, n2);
        this.firePropertyChange(FIELDS.entidades_tipopreco, (Object)n, (Object)n2);
    }

    public boolean isTipopreco(Integer tipopreco) {
        return Entidades.equals(tipopreco, Entidades.jdoGettipopreco(this));
    }

    public Integer getRetencao() {
        return Entidades.jdoGetretencao(this);
    }

    public String getRetencaoToText() {
        return Entidades.jdoGetretencao(this) == null ? "" : FIELDS.entidades_retencao.values[Entidades.jdoGetretencao(this)];
    }

    public void setRetencao(Integer retencao) {
        Integer n = Entidades.jdoGetretencao(this);
        Integer n2 = retencao;
        Entidades.jdoSetretencao(this, n2);
        this.firePropertyChange(FIELDS.entidades_retencao, (Object)n, (Object)n2);
    }

    public boolean isRetencao(Integer retencao) {
        return Entidades.equals(retencao, Entidades.jdoGetretencao(this));
    }

    public Integer getRegimeiva() {
        return Entidades.jdoGetregimeiva(this);
    }

    public String getRegimeivaToText() {
        return Entidades.jdoGetregimeiva(this) == null ? "" : FIELDS.entidades_regimeiva.values[Entidades.jdoGetregimeiva(this)];
    }

    public void setRegimeiva(Integer regimeiva) {
        Integer n = Entidades.jdoGetregimeiva(this);
        Integer n2 = regimeiva;
        Entidades.jdoSetregimeiva(this, n2);
        this.firePropertyChange(FIELDS.entidades_regimeiva, (Object)n, (Object)n2);
    }

    public boolean isRegimeiva(Integer regimeiva) {
        return Entidades.equals(regimeiva, Entidades.jdoGetregimeiva(this));
    }

    public Integer getTipoiva() {
        return Entidades.jdoGettipoiva(this);
    }

    public String getTipoivaToText() {
        return Entidades.jdoGettipoiva(this) == null ? "" : FIELDS.entidades_tipoiva.values[Entidades.jdoGettipoiva(this)];
    }

    public void setTipoiva(Integer tipoiva) {
        Integer n = Entidades.jdoGettipoiva(this);
        Integer n2 = tipoiva;
        Entidades.jdoSettipoiva(this, n2);
        this.firePropertyChange(FIELDS.entidades_tipoiva, (Object)n, (Object)n2);
    }

    public boolean isTipoiva(Integer tipoiva) {
        return Entidades.equals(tipoiva, Entidades.jdoGettipoiva(this));
    }

    public Integer getSendmail() {
        return Entidades.jdoGetsendmail(this);
    }

    public String getSendmailToText() {
        return Entidades.jdoGetsendmail(this) == null ? "" : FIELDS.entidades_sendmail.values[Entidades.jdoGetsendmail(this)];
    }

    public void setSendmail(Integer sendmail) {
        Integer n = Entidades.jdoGetsendmail(this);
        Integer n2 = sendmail;
        Entidades.jdoSetsendmail(this, n2);
        this.firePropertyChange(FIELDS.entidades_sendmail, (Object)n, (Object)n2);
    }

    public boolean isSendmail(Integer sendmail) {
        return Entidades.equals(sendmail, Entidades.jdoGetsendmail(this));
    }

    public boolean hasSendmail() {
        return !this.manager.getParametros().isSendmail(0) && !this.isSendmail(0);
    }

    public Integer getEstado() {
        return Entidades.jdoGetestado(this);
    }

    public String getEstadoToText() {
        return Entidades.jdoGetestado(this) == null ? "" : FIELDS.entidades_estado.values[Entidades.jdoGetestado(this)];
    }

    public void setEstado(Integer estado) {
        Integer n = Entidades.jdoGetestado(this);
        Integer n2 = estado;
        Entidades.jdoSetestado(this, n2);
        this.firePropertyChange(FIELDS.entidades_estado, (Object)n, (Object)n2);
    }

    public boolean isEstado(Integer estado) {
        return Entidades.equals(estado, Entidades.jdoGetestado(this));
    }

    public BigDecimal getDescontofactura() {
        return Entidades.jdoGetdescontofactura(this);
    }

    public String getDescontofacturaToText() {
        return Entidades.jdoGetdescontofactura(this) == null ? "" : FIELDS.entidades_descontofactura.format.format(Entidades.jdoGetdescontofactura(this));
    }

    public void setDescontofactura(BigDecimal descontofactura) {
        BigDecimal bigDecimal = Entidades.jdoGetdescontofactura(this);
        BigDecimal bigDecimal2 = descontofactura;
        Entidades.jdoSetdescontofactura(this, bigDecimal2);
        this.firePropertyChange(FIELDS.entidades_descontofactura, (Object)bigDecimal, (Object)bigDecimal2);
    }

    public BigDecimal getDescontorecibo() {
        return Entidades.jdoGetdescontorecibo(this);
    }

    public String getDescontoreciboToText() {
        return Entidades.jdoGetdescontorecibo(this) == null ? "" : FIELDS.entidades_descontorecibo.format.format(Entidades.jdoGetdescontorecibo(this));
    }

    public void setDescontorecibo(BigDecimal descontorecibo) {
        BigDecimal bigDecimal = Entidades.jdoGetdescontorecibo(this);
        BigDecimal bigDecimal2 = descontorecibo;
        Entidades.jdoSetdescontorecibo(this, bigDecimal2);
        this.firePropertyChange(FIELDS.entidades_descontorecibo, (Object)bigDecimal, (Object)bigDecimal2);
    }

    public BigDecimal getDesconto(Documentostipos tipodocumento) {
        return tipodocumento.isTipodocumento(2) ? Entidades.jdoGetdescontorecibo(this) : Entidades.jdoGetdescontofactura(this);
    }

    public BigDecimal getLimitecredito() {
        return this.parseRGPDValue(Entidades.jdoGetlimitecredito(this));
    }

    public String getLimitecreditoToText() {
        return Entidades.jdoGetlimitecredito(this) == null ? "" : FIELDS.entidades_limitecredito.format.format(Entidades.jdoGetlimitecredito(this));
    }

    public void setLimitecredito(BigDecimal limitecredito) {
        BigDecimal bigDecimal = Entidades.jdoGetlimitecredito(this);
        BigDecimal bigDecimal2 = this.getRGPDValue(Entidades.jdoGetlimitecredito(this), limitecredito);
        Entidades.jdoSetlimitecredito(this, bigDecimal2);
        this.firePropertyChange(FIELDS.entidades_limitecredito, (Object)bigDecimal, (Object)bigDecimal2);
    }

    public boolean hasLimitecredito() {
        return Entidades.jdoGetlimitecredito(this).signum() != 0;
    }

    public boolean isLimitecreditoReached() {
        return this.hasLimitecredito() && NumericUtils.isGreater((BigDecimal)Entidades.jdoGetsaldoprevisto(this), (BigDecimal)Entidades.jdoGetlimitecredito(this));
    }

    public BigDecimal getTotaldebito() {
        return Entidades.jdoGettotaldebito(this);
    }

    public String getTotaldebitoToText() {
        return Entidades.jdoGettotaldebito(this) == null ? "" : FIELDS.entidades_totaldebito.format.format(Entidades.jdoGettotaldebito(this));
    }

    public void setTotaldebito(BigDecimal totaldebito) {
        BigDecimal bigDecimal = Entidades.jdoGettotaldebito(this);
        BigDecimal bigDecimal2 = totaldebito;
        Entidades.jdoSettotaldebito(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.entidades_totaldebito, (Object)bigDecimal, (Object)bigDecimal2);
        if (changed && this.cascade) {
            this.setSaldoreal(totaldebito.subtract(Entidades.jdoGettotalcredito(this)));
        }
    }

    public boolean hasTotaldebito() {
        return Entidades.jdoGettotaldebito(this).signum() != 0;
    }

    public BigDecimal getTotalcredito() {
        return Entidades.jdoGettotalcredito(this);
    }

    public String getTotalcreditoToText() {
        return Entidades.jdoGettotalcredito(this) == null ? "" : FIELDS.entidades_totalcredito.format.format(Entidades.jdoGettotalcredito(this));
    }

    public void setTotalcredito(BigDecimal totalcredito) {
        BigDecimal bigDecimal = Entidades.jdoGettotalcredito(this);
        BigDecimal bigDecimal2 = totalcredito;
        Entidades.jdoSettotalcredito(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.entidades_totalcredito, (Object)bigDecimal, (Object)bigDecimal2);
        if (changed && this.cascade) {
            this.setSaldoreal(Entidades.jdoGettotaldebito(this).subtract(totalcredito));
        }
    }

    public boolean hasTotalcredito() {
        return Entidades.jdoGettotalcredito(this).signum() != 0;
    }

    public void addAcumulados(BigDecimal debito, BigDecimal credito, Integer tiposaldo, SIGNUM sinal) {
        switch (tiposaldo) {
            case 0: {
                this.setTotaldebito(Entidades.jdoGettotaldebito(this).add(debito.multiply(sinal.value)));
                this.setTotalcredito(Entidades.jdoGettotalcredito(this).add(credito.multiply(sinal.value)));
                break;
            }
            case 1: {
                this.setSaldopendente(Entidades.jdoGetsaldopendente(this).add(debito.subtract(credito).multiply(sinal.value)));
            }
        }
    }

    public BigDecimal getSaldoreal() {
        return Entidades.jdoGetsaldoreal(this);
    }

    public String getSaldorealToText() {
        return Entidades.jdoGetsaldoreal(this) == null ? "" : FIELDS.entidades_saldoreal.format.format(Entidades.jdoGetsaldoreal(this));
    }

    public void setSaldoreal(BigDecimal saldoreal) {
        BigDecimal bigDecimal = Entidades.jdoGetsaldoreal(this);
        BigDecimal bigDecimal2 = saldoreal;
        Entidades.jdoSetsaldoreal(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.entidades_saldoreal, (Object)bigDecimal, (Object)bigDecimal2);
        if (changed && this.cascade) {
            this.setSaldoprevisto(saldoreal.add(Entidades.jdoGetsaldopendente(this)));
        }
    }

    public BigDecimal getSaldopendente() {
        return Entidades.jdoGetsaldopendente(this);
    }

    public String getSaldopendenteToText() {
        return Entidades.jdoGetsaldopendente(this) == null ? "" : FIELDS.entidades_saldopendente.format.format(Entidades.jdoGetsaldopendente(this));
    }

    public void setSaldopendente(BigDecimal saldopendente) {
        BigDecimal bigDecimal = Entidades.jdoGetsaldopendente(this);
        BigDecimal bigDecimal2 = saldopendente;
        Entidades.jdoSetsaldopendente(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.entidades_saldopendente, (Object)bigDecimal, (Object)bigDecimal2);
        if (changed && this.cascade) {
            this.setSaldoprevisto(Entidades.jdoGetsaldoreal(this).add(saldopendente));
        }
    }

    public BigDecimal getSaldoprevisto() {
        return Entidades.jdoGetsaldoprevisto(this);
    }

    public String getSaldoprevistoToText() {
        return Entidades.jdoGetsaldoprevisto(this) == null ? "" : FIELDS.entidades_saldoprevisto.format.format(Entidades.jdoGetsaldoprevisto(this));
    }

    public void setSaldoprevisto(BigDecimal saldoprevisto) {
        BigDecimal bigDecimal = Entidades.jdoGetsaldoprevisto(this);
        BigDecimal bigDecimal2 = saldoprevisto;
        Entidades.jdoSetsaldoprevisto(this, bigDecimal2);
        this.firePropertyChange(FIELDS.entidades_saldoprevisto, (Object)bigDecimal, (Object)bigDecimal2);
    }

    public Entidadesmoradas createMoradas() {
        return new Entidadesmoradas(this, this.manager.loadTiposmorada(), this.manager.getEmpresa().getCodigopostal(), Entidades.jdoGetpais(this));
    }

    public Entidadesmoradas createMoradas(String tipomorada, String codigopostal, String pais) {
        return new Entidadesmoradas(this, this.manager.loadTiposmorada(tipomorada), this.manager.loadCodigospostais(codigopostal), this.manager.loadPaises(pais));
    }

    public Collection<Entidadesmoradas> getMoradas() {
        return Collections.unmodifiableList(Entidades.jdoGetmoradas(this));
    }

    public Entidadesmoradas getMoradas(int index) {
        return index >= Entidades.jdoGetmoradas(this).size() ? null : (Entidadesmoradas)Entidades.jdoGetmoradas(this).get(index);
    }

    public Entidadesmoradas getMoradas(String key) {
        for (Entidadesmoradas linha : Entidades.jdoGetmoradas(this)) {
            if (!linha.getKey().equals(key)) continue;
            return linha;
        }
        return null;
    }

    public Entidadesmoradas getMoradas$Tipo(int tipo) {
        for (Entidadesmoradas linha : Entidades.jdoGetmoradas(this)) {
            if (!linha.getTipomorada().isTipo(tipo)) continue;
            return linha;
        }
        return null;
    }

    public void setMoradas(Collection<Entidadesmoradas> moradas) {
        Entidades.jdoGetmoradas(this).clear();
        this.addMoradas(moradas);
    }

    public Entidadesmoradas addMoradas() {
        return this.addMoradas(this.createMoradas());
    }

    public Entidadesmoradas addMoradas(String tipomorada, String codigopostal, String pais) {
        Entidadesmoradas morada = this.createMoradas(tipomorada, codigopostal, pais);
        return morada.getKey() == null ? null : this.addMoradas(morada);
    }

    public Entidadesmoradas addMoradas(Entidadesmoradas moradas) {
        if (moradas != null) {
            this.addMoradas(Arrays.asList(moradas));
        }
        return moradas;
    }

    public void addMoradas(Collection<Entidadesmoradas> moradas) {
        int index = Entidades.jdoGetmoradas(this).size();
        for (Entidadesmoradas linha : moradas) {
            linha.setNumerolinha(++index);
            linha.setEntidade(this);
        }
        Entidades.jdoGetmoradas(this).addAll(moradas);
    }

    public void removeMoradas() {
        this.removeMoradas(Entidades.jdoGetmoradas(this));
    }

    public void removeMoradas(int index) {
        this.removeMoradas(this.getMoradas(index));
    }

    public void removeMoradas(Entidadesmoradas moradas) {
        this.removeMoradas(Arrays.asList(moradas));
    }

    public void removeMoradas(Collection<Entidadesmoradas> moradas) {
        Entidades.jdoGetmoradas(this).removeAll(moradas);
        int index = 0;
        for (Entidadesmoradas linha : Entidades.jdoGetmoradas(this)) {
            linha.setNumerolinha(++index);
        }
    }

    @Override
    public boolean isEditable(FIELDS field) {
        return !(field == FIELDS.entidades_autor || field == FIELDS.entidades_editor || field == FIELDS.entidades_datacriacao || field == FIELDS.entidades_dataalteracao || field == FIELDS.entidades_numero && this.isEdited() || field == FIELDS.entidades_nome && this.isEdited() && !this.isNomeEditable() || field == FIELDS.entidades_nif && this.isEdited() && !this.isNifEditable() || field == FIELDS.entidades_totaldebito || field == FIELDS.entidades_totalcredito || field == FIELDS.entidades_saldoreal || field == FIELDS.entidades_saldopendente || field == FIELDS.entidades_saldoprevisto);
    }

    @Override
    public void attach(DatabaseManager manager) {
        manager.attach(Entidades.jdoGetmoradas(this));
        manager.attach(new AbstractModel[]{Entidades.jdoGetautor(this), Entidades.jdoGeteditor(this), Entidades.jdoGettipoentidade(this), Entidades.jdoGetcodigopostal(this), Entidades.jdoGetpais(this), Entidades.jdoGetgrupo(this), Entidades.jdoGetfamilia(this), Entidades.jdoGetvendedor(this), Entidades.jdoGetcondicaopagamento(this), Entidades.jdoGetmetodopagamento(this), Entidades.jdoGetmoeda(this), Entidades.jdoGetprecario(this), Entidades.jdoGetcodigoiva(this), Entidades.jdoGetisencaoiva(this)});
    }

    @Override
    public boolean isDirty() {
        return super.isDirty() || this.isDirty(Entidades.jdoGetmoradas(this));
    }

    public String toString() {
        return String.valueOf(Entidades.jdoGetkey(this)) + " - " + Entidades.jdoGetnome(this);
    }

    public int hashCode() {
        return Entidades.jdoGetkey(this) == null ? 0 : Entidades.jdoGetkey(this).hashCode();
    }

    public boolean equals(Object obj) {
        return this.hashCode() == obj.hashCode();
    }

    static {
        jdoFieldNames = Entidades.__jdoFieldNamesInit();
        jdoFieldTypes = Entidades.__jdoFieldTypesInit();
        jdoFieldFlags = Entidades.__jdoFieldFlagsInit();
        jdoInheritedFieldCount = Entidades.__jdoGetInheritedFieldCount();
        jdoPersistenceCapableSuperclass = Entidades.__jdoPersistenceCapableSuperclassInit();
        JDOImplHelper.registerClass((Class)Entidades.___jdo$loadClass("org.projectocolibri.api.database.model.Entidades"), (String[])jdoFieldNames, (Class[])jdoFieldTypes, (byte[])jdoFieldFlags, (Class)jdoPersistenceCapableSuperclass, (PersistenceCapable)new Entidades());
    }

    public void jdoCopyKeyFieldsFromObjectId(PersistenceCapable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("oid is not instanceof javax.jdo.identity.StringIdentity");
        }
        StringIdentity o = (StringIdentity)oid;
        fc.storeStringField(27, o.getKey());
    }

    protected void jdoCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("key class is not javax.jdo.identity.StringIdentity or null");
        }
        StringIdentity o = (StringIdentity)oid;
        this.key = o.getKey();
    }

    public final void jdoCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final void jdoCopyKeyFieldsToObjectId(PersistenceCapable.ObjectIdFieldSupplier fs, Object object) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final Object jdoGetObjectId() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getObjectId((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[0];
    }

    public final Object jdoGetVersion() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getVersion((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[1];
    }

    protected final void jdoPreSerialize() {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.preSerialize((PersistenceCapable)this);
        }
    }

    public final PersistenceManager jdoGetPersistenceManager() {
        return this.jdoStateManager != null ? this.jdoStateManager.getPersistenceManager((PersistenceCapable)this) : null;
    }

    public final Object jdoGetTransactionalObjectId() {
        return this.jdoStateManager != null ? this.jdoStateManager.getTransactionalObjectId((PersistenceCapable)this) : null;
    }

    public final boolean jdoIsDeleted() {
        return this.jdoStateManager != null ? this.jdoStateManager.isDeleted((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsDirty() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.isDirty((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return false;
        }
        return ((BitSet)this.jdoDetachedState[3]).length() > 0;
    }

    public final boolean jdoIsNew() {
        return this.jdoStateManager != null ? this.jdoStateManager.isNew((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsPersistent() {
        return this.jdoStateManager != null ? this.jdoStateManager.isPersistent((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsTransactional() {
        return this.jdoStateManager != null ? this.jdoStateManager.isTransactional((PersistenceCapable)this) : false;
    }

    public void jdoMakeDirty(String fieldName) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.makeDirty((PersistenceCapable)this, fieldName);
        }
        if (this.jdoIsDetached() && fieldName != null) {
            String fldName = null;
            fldName = fieldName.indexOf(46) >= 0 ? fieldName.substring(fieldName.lastIndexOf(46) + 1) : fieldName;
            int i = 0;
            while (i < jdoFieldNames.length) {
                if (jdoFieldNames[i].equals(fldName)) {
                    if (!((BitSet)this.jdoDetachedState[2]).get(i + jdoInheritedFieldCount)) {
                        throw new JDODetachedFieldAccessException("You have just attempted to access a field/property that hasn't been detached. Please detach it first before performing this operation");
                    }
                    ((BitSet)this.jdoDetachedState[3]).set(i + jdoInheritedFieldCount);
                    return;
                }
                ++i;
            }
        }
    }

    public final Object jdoNewObjectIdInstance() {
        return new StringIdentity(this.getClass(), this.key);
    }

    public final Object jdoNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new StringIdentity(this.getClass(), (String)key);
        }
        return new StringIdentity(this.getClass(), (String)key);
    }

    public final void jdoProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void jdoReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.jdoReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void jdoReplaceFlags() {
        if (this.jdoStateManager != null) {
            this.jdoFlags = this.jdoStateManager.replacingFlags((PersistenceCapable)this);
        }
    }

    public final synchronized void jdoReplaceStateManager(StateManager sm) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager = this.jdoStateManager.replacingStateManager((PersistenceCapable)this, sm);
        } else {
            JDOImplHelper.checkAuthorizedStateManager((StateManager)sm);
            this.jdoStateManager = sm;
            this.jdoFlags = 1;
        }
    }

    public final synchronized void jdoReplaceDetachedState() {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        this.jdoDetachedState = this.jdoStateManager.replacingDetachedState((Detachable)this, this.jdoDetachedState);
    }

    public boolean jdoIsDetached() {
        return this.jdoStateManager == null && this.jdoDetachedState != null;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm) {
        Entidades result = new Entidades();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        return result;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm, Object obj) {
        Entidades result = new Entidades();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        result.jdoCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void jdoReplaceField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.autor = (Utilizadores)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 1: {
                this.campo1 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 2: {
                this.campo10 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 3: {
                this.campo2 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 4: {
                this.campo3 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 5: {
                this.campo4 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 6: {
                this.campo5 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 7: {
                this.campo6 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 8: {
                this.campo7 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 9: {
                this.campo8 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 10: {
                this.campo9 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 11: {
                this.codigoiva = (Codigosiva)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 12: {
                this.codigopostal = (Codigospostais)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 13: {
                this.condicaopagamento = (Condicoespagamento)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 14: {
                this.dataalteracao = (Date)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 15: {
                this.datacriacao = (Date)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 16: {
                this.descontofactura = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 17: {
                this.descontorecibo = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 18: {
                this.editor = (Utilizadores)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 19: {
                this.email = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 20: {
                this.email2 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 21: {
                this.estado = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 22: {
                this.familia = (Familias)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 23: {
                this.fax = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 24: {
                this.grupo = (Grupos)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 25: {
                this.iban = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 26: {
                this.isencaoiva = (Isencoesiva)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 27: {
                this.key = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 28: {
                this.limitecredito = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 29: {
                this.localidade = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 30: {
                this.metodopagamento = (Metodospagamento)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 31: {
                this.moeda = (Moedas)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 32: {
                this.morada = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 33: {
                this.moradas = (List)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 34: {
                this.nib = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 35: {
                this.nif = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 36: {
                this.nome = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 37: {
                this.nomebanco = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 38: {
                this.numero = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 39: {
                this.obs = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 40: {
                this.pais = (Paises)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 41: {
                this.precario = (Precarios)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 42: {
                this.regimeiva = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 43: {
                this.responsavel = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 44: {
                this.retencao = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 45: {
                this.saldopendente = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 46: {
                this.saldoprevisto = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 47: {
                this.saldoreal = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 48: {
                this.sendmail = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 49: {
                this.telefone = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 50: {
                this.telefone2 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 51: {
                this.telemovel = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 52: {
                this.tipoentidade = (Entidadestipos)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 53: {
                this.tipoiva = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 54: {
                this.tipopreco = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 55: {
                this.totalcredito = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 56: {
                this.totaldebito = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 57: {
                this.url = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 58: {
                this.vendedor = (Vendedores)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 59: {
                this.zona = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoProvideField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.autor);
                break;
            }
            case 1: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.campo1);
                break;
            }
            case 2: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.campo10);
                break;
            }
            case 3: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.campo2);
                break;
            }
            case 4: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.campo3);
                break;
            }
            case 5: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.campo4);
                break;
            }
            case 6: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.campo5);
                break;
            }
            case 7: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.campo6);
                break;
            }
            case 8: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.campo7);
                break;
            }
            case 9: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.campo8);
                break;
            }
            case 10: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.campo9);
                break;
            }
            case 11: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.codigoiva);
                break;
            }
            case 12: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.codigopostal);
                break;
            }
            case 13: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.condicaopagamento);
                break;
            }
            case 14: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.dataalteracao);
                break;
            }
            case 15: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.datacriacao);
                break;
            }
            case 16: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.descontofactura);
                break;
            }
            case 17: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.descontorecibo);
                break;
            }
            case 18: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.editor);
                break;
            }
            case 19: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.email);
                break;
            }
            case 20: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.email2);
                break;
            }
            case 21: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.estado);
                break;
            }
            case 22: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.familia);
                break;
            }
            case 23: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.fax);
                break;
            }
            case 24: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.grupo);
                break;
            }
            case 25: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.iban);
                break;
            }
            case 26: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.isencaoiva);
                break;
            }
            case 27: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.key);
                break;
            }
            case 28: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.limitecredito);
                break;
            }
            case 29: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.localidade);
                break;
            }
            case 30: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.metodopagamento);
                break;
            }
            case 31: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.moeda);
                break;
            }
            case 32: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.morada);
                break;
            }
            case 33: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, this.moradas);
                break;
            }
            case 34: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.nib);
                break;
            }
            case 35: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.nif);
                break;
            }
            case 36: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.nome);
                break;
            }
            case 37: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.nomebanco);
                break;
            }
            case 38: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.numero);
                break;
            }
            case 39: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.obs);
                break;
            }
            case 40: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.pais);
                break;
            }
            case 41: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.precario);
                break;
            }
            case 42: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.regimeiva);
                break;
            }
            case 43: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.responsavel);
                break;
            }
            case 44: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.retencao);
                break;
            }
            case 45: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.saldopendente);
                break;
            }
            case 46: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.saldoprevisto);
                break;
            }
            case 47: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.saldoreal);
                break;
            }
            case 48: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.sendmail);
                break;
            }
            case 49: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.telefone);
                break;
            }
            case 50: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.telefone2);
                break;
            }
            case 51: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.telemovel);
                break;
            }
            case 52: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.tipoentidade);
                break;
            }
            case 53: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.tipoiva);
                break;
            }
            case 54: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.tipopreco);
                break;
            }
            case 55: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.totalcredito);
                break;
            }
            case 56: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.totaldebito);
                break;
            }
            case 57: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.url);
                break;
            }
            case 58: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.vendedor);
                break;
            }
            case 59: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.zona);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void jdoCopyField(Entidades obj, int index) {
        switch (index) {
            case 0: {
                this.autor = obj.autor;
                break;
            }
            case 1: {
                this.campo1 = obj.campo1;
                break;
            }
            case 2: {
                this.campo10 = obj.campo10;
                break;
            }
            case 3: {
                this.campo2 = obj.campo2;
                break;
            }
            case 4: {
                this.campo3 = obj.campo3;
                break;
            }
            case 5: {
                this.campo4 = obj.campo4;
                break;
            }
            case 6: {
                this.campo5 = obj.campo5;
                break;
            }
            case 7: {
                this.campo6 = obj.campo6;
                break;
            }
            case 8: {
                this.campo7 = obj.campo7;
                break;
            }
            case 9: {
                this.campo8 = obj.campo8;
                break;
            }
            case 10: {
                this.campo9 = obj.campo9;
                break;
            }
            case 11: {
                this.codigoiva = obj.codigoiva;
                break;
            }
            case 12: {
                this.codigopostal = obj.codigopostal;
                break;
            }
            case 13: {
                this.condicaopagamento = obj.condicaopagamento;
                break;
            }
            case 14: {
                this.dataalteracao = obj.dataalteracao;
                break;
            }
            case 15: {
                this.datacriacao = obj.datacriacao;
                break;
            }
            case 16: {
                this.descontofactura = obj.descontofactura;
                break;
            }
            case 17: {
                this.descontorecibo = obj.descontorecibo;
                break;
            }
            case 18: {
                this.editor = obj.editor;
                break;
            }
            case 19: {
                this.email = obj.email;
                break;
            }
            case 20: {
                this.email2 = obj.email2;
                break;
            }
            case 21: {
                this.estado = obj.estado;
                break;
            }
            case 22: {
                this.familia = obj.familia;
                break;
            }
            case 23: {
                this.fax = obj.fax;
                break;
            }
            case 24: {
                this.grupo = obj.grupo;
                break;
            }
            case 25: {
                this.iban = obj.iban;
                break;
            }
            case 26: {
                this.isencaoiva = obj.isencaoiva;
                break;
            }
            case 27: {
                this.key = obj.key;
                break;
            }
            case 28: {
                this.limitecredito = obj.limitecredito;
                break;
            }
            case 29: {
                this.localidade = obj.localidade;
                break;
            }
            case 30: {
                this.metodopagamento = obj.metodopagamento;
                break;
            }
            case 31: {
                this.moeda = obj.moeda;
                break;
            }
            case 32: {
                this.morada = obj.morada;
                break;
            }
            case 33: {
                this.moradas = obj.moradas;
                break;
            }
            case 34: {
                this.nib = obj.nib;
                break;
            }
            case 35: {
                this.nif = obj.nif;
                break;
            }
            case 36: {
                this.nome = obj.nome;
                break;
            }
            case 37: {
                this.nomebanco = obj.nomebanco;
                break;
            }
            case 38: {
                this.numero = obj.numero;
                break;
            }
            case 39: {
                this.obs = obj.obs;
                break;
            }
            case 40: {
                this.pais = obj.pais;
                break;
            }
            case 41: {
                this.precario = obj.precario;
                break;
            }
            case 42: {
                this.regimeiva = obj.regimeiva;
                break;
            }
            case 43: {
                this.responsavel = obj.responsavel;
                break;
            }
            case 44: {
                this.retencao = obj.retencao;
                break;
            }
            case 45: {
                this.saldopendente = obj.saldopendente;
                break;
            }
            case 46: {
                this.saldoprevisto = obj.saldoprevisto;
                break;
            }
            case 47: {
                this.saldoreal = obj.saldoreal;
                break;
            }
            case 48: {
                this.sendmail = obj.sendmail;
                break;
            }
            case 49: {
                this.telefone = obj.telefone;
                break;
            }
            case 50: {
                this.telefone2 = obj.telefone2;
                break;
            }
            case 51: {
                this.telemovel = obj.telemovel;
                break;
            }
            case 52: {
                this.tipoentidade = obj.tipoentidade;
                break;
            }
            case 53: {
                this.tipoiva = obj.tipoiva;
                break;
            }
            case 54: {
                this.tipopreco = obj.tipopreco;
                break;
            }
            case 55: {
                this.totalcredito = obj.totalcredito;
                break;
            }
            case 56: {
                this.totaldebito = obj.totaldebito;
                break;
            }
            case 57: {
                this.url = obj.url;
                break;
            }
            case 58: {
                this.vendedor = obj.vendedor;
                break;
            }
            case 59: {
                this.zona = obj.zona;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoCopyFields(Object obj, int[] indices) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof Entidades)) {
            throw new IllegalArgumentException("object is not an object of type org.projectocolibri.api.database.model.Entidades");
        }
        Entidades other = (Entidades)obj;
        if (this.jdoStateManager != other.jdoStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __jdoFieldNamesInit() {
        return new String[]{"autor", "campo1", "campo10", "campo2", "campo3", "campo4", "campo5", "campo6", "campo7", "campo8", "campo9", "codigoiva", "codigopostal", "condicaopagamento", "dataalteracao", "datacriacao", "descontofactura", "descontorecibo", "editor", "email", "email2", "estado", "familia", "fax", "grupo", "iban", "isencaoiva", "key", "limitecredito", "localidade", "metodopagamento", "moeda", "morada", "moradas", "nib", "nif", "nome", "nomebanco", "numero", "obs", "pais", "precario", "regimeiva", "responsavel", "retencao", "saldopendente", "saldoprevisto", "saldoreal", "sendmail", "telefone", "telefone2", "telemovel", "tipoentidade", "tipoiva", "tipopreco", "totalcredito", "totaldebito", "url", "vendedor", "zona"};
    }

    private static final Class[] __jdoFieldTypesInit() {
        return new Class[]{Entidades.___jdo$loadClass("org.projectocolibri.api.database.model.Utilizadores"), Entidades.___jdo$loadClass("java.lang.String"), Entidades.___jdo$loadClass("java.lang.String"), Entidades.___jdo$loadClass("java.lang.String"), Entidades.___jdo$loadClass("java.lang.String"), Entidades.___jdo$loadClass("java.lang.String"), Entidades.___jdo$loadClass("java.lang.String"), Entidades.___jdo$loadClass("java.lang.String"), Entidades.___jdo$loadClass("java.lang.String"), Entidades.___jdo$loadClass("java.lang.String"), Entidades.___jdo$loadClass("java.lang.String"), Entidades.___jdo$loadClass("org.projectocolibri.api.database.model.Codigosiva"), Entidades.___jdo$loadClass("org.projectocolibri.api.database.model.Codigospostais"), Entidades.___jdo$loadClass("org.projectocolibri.api.database.model.Condicoespagamento"), Entidades.___jdo$loadClass("java.util.Date"), Entidades.___jdo$loadClass("java.util.Date"), Entidades.___jdo$loadClass("java.math.BigDecimal"), Entidades.___jdo$loadClass("java.math.BigDecimal"), Entidades.___jdo$loadClass("org.projectocolibri.api.database.model.Utilizadores"), Entidades.___jdo$loadClass("java.lang.String"), Entidades.___jdo$loadClass("java.lang.String"), Entidades.___jdo$loadClass("java.lang.Integer"), Entidades.___jdo$loadClass("org.projectocolibri.api.database.model.Familias"), Entidades.___jdo$loadClass("java.lang.String"), Entidades.___jdo$loadClass("org.projectocolibri.api.database.model.Grupos"), Entidades.___jdo$loadClass("java.lang.String"), Entidades.___jdo$loadClass("org.projectocolibri.api.database.model.Isencoesiva"), Entidades.___jdo$loadClass("java.lang.String"), Entidades.___jdo$loadClass("java.math.BigDecimal"), Entidades.___jdo$loadClass("java.lang.String"), Entidades.___jdo$loadClass("org.projectocolibri.api.database.model.Metodospagamento"), Entidades.___jdo$loadClass("org.projectocolibri.api.database.model.Moedas"), Entidades.___jdo$loadClass("java.lang.String"), Entidades.___jdo$loadClass("java.util.List"), Entidades.___jdo$loadClass("java.lang.String"), Entidades.___jdo$loadClass("java.lang.String"), Entidades.___jdo$loadClass("java.lang.String"), Entidades.___jdo$loadClass("java.lang.String"), Entidades.___jdo$loadClass("java.lang.Integer"), Entidades.___jdo$loadClass("java.lang.String"), Entidades.___jdo$loadClass("org.projectocolibri.api.database.model.Paises"), Entidades.___jdo$loadClass("org.projectocolibri.api.database.model.Precarios"), Entidades.___jdo$loadClass("java.lang.Integer"), Entidades.___jdo$loadClass("java.lang.String"), Entidades.___jdo$loadClass("java.lang.Integer"), Entidades.___jdo$loadClass("java.math.BigDecimal"), Entidades.___jdo$loadClass("java.math.BigDecimal"), Entidades.___jdo$loadClass("java.math.BigDecimal"), Entidades.___jdo$loadClass("java.lang.Integer"), Entidades.___jdo$loadClass("java.lang.String"), Entidades.___jdo$loadClass("java.lang.String"), Entidades.___jdo$loadClass("java.lang.String"), Entidades.___jdo$loadClass("org.projectocolibri.api.database.model.Entidadestipos"), Entidades.___jdo$loadClass("java.lang.Integer"), Entidades.___jdo$loadClass("java.lang.Integer"), Entidades.___jdo$loadClass("java.math.BigDecimal"), Entidades.___jdo$loadClass("java.math.BigDecimal"), Entidades.___jdo$loadClass("java.lang.String"), Entidades.___jdo$loadClass("org.projectocolibri.api.database.model.Vendedores"), Entidades.___jdo$loadClass("java.lang.String")};
    }

    private static final byte[] __jdoFieldFlagsInit() {
        return new byte[]{21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 5, 5, 5, 21, 21, 21, 21, 21, 21, 21, 21, 5, 21, 5, 21, 5, 24, 21, 21, 5, 5, 21, 5, 21, 21, 21, 21, 21, 21, 5, 5, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 5, 21};
    }

    protected static int __jdoGetInheritedFieldCount() {
        return 0;
    }

    protected static int jdoGetManagedFieldCount() {
        return 60;
    }

    private static Class __jdoPersistenceCapableSuperclassInit() {
        return null;
    }

    public static Class ___jdo$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object jdoSuperClone() throws CloneNotSupportedException {
        Entidades o = (Entidades)super.clone();
        o.jdoFlags = 0;
        o.jdoStateManager = null;
        return o;
    }

    private static Utilizadores jdoGetautor(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 0)) {
            return (Utilizadores)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 0, (Object)objPC.autor);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(0)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"autor\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.autor;
    }

    private static void jdoSetautor(Entidades objPC, Utilizadores val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 0, (Object)objPC.autor, (Object)val);
        } else {
            objPC.autor = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(0);
            }
        }
    }

    private static String jdoGetcampo1(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 1)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 1, objPC.campo1);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(1)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"campo1\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.campo1;
    }

    private static void jdoSetcampo1(Entidades objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 1, objPC.campo1, val);
        } else {
            objPC.campo1 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(1);
            }
        }
    }

    private static String jdoGetcampo10(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 2)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 2, objPC.campo10);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(2)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"campo10\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.campo10;
    }

    private static void jdoSetcampo10(Entidades objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 2, objPC.campo10, val);
        } else {
            objPC.campo10 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(2);
            }
        }
    }

    private static String jdoGetcampo2(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 3)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 3, objPC.campo2);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(3)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"campo2\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.campo2;
    }

    private static void jdoSetcampo2(Entidades objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 3, objPC.campo2, val);
        } else {
            objPC.campo2 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(3);
            }
        }
    }

    private static String jdoGetcampo3(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 4)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 4, objPC.campo3);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(4)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"campo3\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.campo3;
    }

    private static void jdoSetcampo3(Entidades objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 4, objPC.campo3, val);
        } else {
            objPC.campo3 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(4);
            }
        }
    }

    private static String jdoGetcampo4(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 5)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 5, objPC.campo4);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(5)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"campo4\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.campo4;
    }

    private static void jdoSetcampo4(Entidades objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 5, objPC.campo4, val);
        } else {
            objPC.campo4 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(5);
            }
        }
    }

    private static String jdoGetcampo5(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 6)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 6, objPC.campo5);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(6)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"campo5\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.campo5;
    }

    private static void jdoSetcampo5(Entidades objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 6, objPC.campo5, val);
        } else {
            objPC.campo5 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(6);
            }
        }
    }

    private static String jdoGetcampo6(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 7)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 7, objPC.campo6);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(7)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"campo6\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.campo6;
    }

    private static void jdoSetcampo6(Entidades objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 7, objPC.campo6, val);
        } else {
            objPC.campo6 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(7);
            }
        }
    }

    private static String jdoGetcampo7(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 8)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 8, objPC.campo7);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(8)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"campo7\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.campo7;
    }

    private static void jdoSetcampo7(Entidades objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 8, objPC.campo7, val);
        } else {
            objPC.campo7 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(8);
            }
        }
    }

    private static String jdoGetcampo8(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 9)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 9, objPC.campo8);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(9)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"campo8\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.campo8;
    }

    private static void jdoSetcampo8(Entidades objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 9, objPC.campo8, val);
        } else {
            objPC.campo8 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(9);
            }
        }
    }

    private static String jdoGetcampo9(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 10)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 10, objPC.campo9);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(10)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"campo9\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.campo9;
    }

    private static void jdoSetcampo9(Entidades objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 10, objPC.campo9, val);
        } else {
            objPC.campo9 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(10);
            }
        }
    }

    private static Codigosiva jdoGetcodigoiva(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 11)) {
            return (Codigosiva)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 11, (Object)objPC.codigoiva);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(11)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"codigoiva\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.codigoiva;
    }

    private static void jdoSetcodigoiva(Entidades objPC, Codigosiva val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 11, (Object)objPC.codigoiva, (Object)val);
        } else {
            objPC.codigoiva = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(11);
            }
        }
    }

    private static Codigospostais jdoGetcodigopostal(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 12)) {
            return (Codigospostais)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 12, (Object)objPC.codigopostal);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(12)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"codigopostal\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.codigopostal;
    }

    private static void jdoSetcodigopostal(Entidades objPC, Codigospostais val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 12, (Object)objPC.codigopostal, (Object)val);
        } else {
            objPC.codigopostal = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(12);
            }
        }
    }

    private static Condicoespagamento jdoGetcondicaopagamento(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 13)) {
            return (Condicoespagamento)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 13, (Object)objPC.condicaopagamento);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(13)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"condicaopagamento\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.condicaopagamento;
    }

    private static void jdoSetcondicaopagamento(Entidades objPC, Condicoespagamento val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 13, (Object)objPC.condicaopagamento, (Object)val);
        } else {
            objPC.condicaopagamento = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(13);
            }
        }
    }

    private static Date jdoGetdataalteracao(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 14)) {
            return (Date)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 14, (Object)objPC.dataalteracao);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(14)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"dataalteracao\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.dataalteracao;
    }

    private static void jdoSetdataalteracao(Entidades objPC, Date val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 14, (Object)objPC.dataalteracao, (Object)val);
        } else {
            objPC.dataalteracao = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(14);
            }
        }
    }

    private static Date jdoGetdatacriacao(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 15)) {
            return (Date)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 15, (Object)objPC.datacriacao);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(15)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"datacriacao\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.datacriacao;
    }

    private static void jdoSetdatacriacao(Entidades objPC, Date val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 15, (Object)objPC.datacriacao, (Object)val);
        } else {
            objPC.datacriacao = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(15);
            }
        }
    }

    private static BigDecimal jdoGetdescontofactura(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 16)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 16, (Object)objPC.descontofactura);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(16)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"descontofactura\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.descontofactura;
    }

    private static void jdoSetdescontofactura(Entidades objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 16, (Object)objPC.descontofactura, (Object)val);
        } else {
            objPC.descontofactura = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(16);
            }
        }
    }

    private static BigDecimal jdoGetdescontorecibo(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 17)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 17, (Object)objPC.descontorecibo);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(17)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"descontorecibo\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.descontorecibo;
    }

    private static void jdoSetdescontorecibo(Entidades objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 17, (Object)objPC.descontorecibo, (Object)val);
        } else {
            objPC.descontorecibo = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(17);
            }
        }
    }

    private static Utilizadores jdoGeteditor(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 18)) {
            return (Utilizadores)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 18, (Object)objPC.editor);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(18)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"editor\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.editor;
    }

    private static void jdoSeteditor(Entidades objPC, Utilizadores val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 18, (Object)objPC.editor, (Object)val);
        } else {
            objPC.editor = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(18);
            }
        }
    }

    private static String jdoGetemail(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 19)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 19, objPC.email);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(19)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"email\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.email;
    }

    private static void jdoSetemail(Entidades objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 19, objPC.email, val);
        } else {
            objPC.email = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(19);
            }
        }
    }

    private static String jdoGetemail2(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 20)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 20, objPC.email2);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(20)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"email2\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.email2;
    }

    private static void jdoSetemail2(Entidades objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 20, objPC.email2, val);
        } else {
            objPC.email2 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(20);
            }
        }
    }

    private static Integer jdoGetestado(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 21)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 21, (Object)objPC.estado);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(21)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"estado\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.estado;
    }

    private static void jdoSetestado(Entidades objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 21, (Object)objPC.estado, (Object)val);
        } else {
            objPC.estado = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(21);
            }
        }
    }

    private static Familias jdoGetfamilia(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 22)) {
            return (Familias)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 22, (Object)objPC.familia);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(22)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"familia\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.familia;
    }

    private static void jdoSetfamilia(Entidades objPC, Familias val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 22, (Object)objPC.familia, (Object)val);
        } else {
            objPC.familia = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(22);
            }
        }
    }

    private static String jdoGetfax(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 23)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 23, objPC.fax);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(23)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"fax\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.fax;
    }

    private static void jdoSetfax(Entidades objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 23, objPC.fax, val);
        } else {
            objPC.fax = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(23);
            }
        }
    }

    private static Grupos jdoGetgrupo(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 24)) {
            return (Grupos)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 24, (Object)objPC.grupo);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(24)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"grupo\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.grupo;
    }

    private static void jdoSetgrupo(Entidades objPC, Grupos val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 24, (Object)objPC.grupo, (Object)val);
        } else {
            objPC.grupo = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(24);
            }
        }
    }

    private static String jdoGetiban(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 25)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 25, objPC.iban);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(25)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"iban\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.iban;
    }

    private static void jdoSetiban(Entidades objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 25, objPC.iban, val);
        } else {
            objPC.iban = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(25);
            }
        }
    }

    private static Isencoesiva jdoGetisencaoiva(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 26)) {
            return (Isencoesiva)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 26, (Object)objPC.isencaoiva);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(26)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"isencaoiva\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.isencaoiva;
    }

    private static void jdoSetisencaoiva(Entidades objPC, Isencoesiva val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 26, (Object)objPC.isencaoiva, (Object)val);
        } else {
            objPC.isencaoiva = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(26);
            }
        }
    }

    private static String jdoGetkey(Entidades objPC) {
        return objPC.key;
    }

    private static void jdoSetkey(Entidades objPC, String val) {
        if (objPC.jdoStateManager == null) {
            objPC.key = val;
        } else {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 27, objPC.key, val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(27);
        }
    }

    private static BigDecimal jdoGetlimitecredito(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 28)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 28, (Object)objPC.limitecredito);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(28)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"limitecredito\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.limitecredito;
    }

    private static void jdoSetlimitecredito(Entidades objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 28, (Object)objPC.limitecredito, (Object)val);
        } else {
            objPC.limitecredito = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(28);
            }
        }
    }

    private static String jdoGetlocalidade(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 29)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 29, objPC.localidade);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(29)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"localidade\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.localidade;
    }

    private static void jdoSetlocalidade(Entidades objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 29, objPC.localidade, val);
        } else {
            objPC.localidade = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(29);
            }
        }
    }

    private static Metodospagamento jdoGetmetodopagamento(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 30)) {
            return (Metodospagamento)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 30, (Object)objPC.metodopagamento);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(30)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"metodopagamento\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.metodopagamento;
    }

    private static void jdoSetmetodopagamento(Entidades objPC, Metodospagamento val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 30, (Object)objPC.metodopagamento, (Object)val);
        } else {
            objPC.metodopagamento = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(30);
            }
        }
    }

    private static Moedas jdoGetmoeda(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 31)) {
            return (Moedas)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 31, (Object)objPC.moeda);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(31)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"moeda\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.moeda;
    }

    private static void jdoSetmoeda(Entidades objPC, Moedas val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 31, (Object)objPC.moeda, (Object)val);
        } else {
            objPC.moeda = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(31);
            }
        }
    }

    private static String jdoGetmorada(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 32)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 32, objPC.morada);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(32)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"morada\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.morada;
    }

    private static void jdoSetmorada(Entidades objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 32, objPC.morada, val);
        } else {
            objPC.morada = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(32);
            }
        }
    }

    private static List jdoGetmoradas(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 33)) {
            return (List)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 33, objPC.moradas);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(33)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"moradas\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.moradas;
    }

    private static void jdoSetmoradas(Entidades objPC, List val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 33, objPC.moradas, (Object)val);
        } else {
            objPC.moradas = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(33);
            }
        }
    }

    private static String jdoGetnib(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 34)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 34, objPC.nib);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(34)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"nib\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.nib;
    }

    private static void jdoSetnib(Entidades objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 34, objPC.nib, val);
        } else {
            objPC.nib = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(34);
            }
        }
    }

    private static String jdoGetnif(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 35)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 35, objPC.nif);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(35)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"nif\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.nif;
    }

    private static void jdoSetnif(Entidades objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 35, objPC.nif, val);
        } else {
            objPC.nif = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(35);
            }
        }
    }

    private static String jdoGetnome(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 36)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 36, objPC.nome);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(36)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"nome\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.nome;
    }

    private static void jdoSetnome(Entidades objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 36, objPC.nome, val);
        } else {
            objPC.nome = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(36);
            }
        }
    }

    private static String jdoGetnomebanco(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 37)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 37, objPC.nomebanco);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(37)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"nomebanco\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.nomebanco;
    }

    private static void jdoSetnomebanco(Entidades objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 37, objPC.nomebanco, val);
        } else {
            objPC.nomebanco = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(37);
            }
        }
    }

    private static Integer jdoGetnumero(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 38)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 38, (Object)objPC.numero);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(38)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"numero\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.numero;
    }

    private static void jdoSetnumero(Entidades objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 38, (Object)objPC.numero, (Object)val);
        } else {
            objPC.numero = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(38);
            }
        }
    }

    private static String jdoGetobs(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 39)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 39, objPC.obs);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(39)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"obs\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.obs;
    }

    private static void jdoSetobs(Entidades objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 39, objPC.obs, val);
        } else {
            objPC.obs = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(39);
            }
        }
    }

    private static Paises jdoGetpais(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 40)) {
            return (Paises)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 40, (Object)objPC.pais);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(40)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"pais\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.pais;
    }

    private static void jdoSetpais(Entidades objPC, Paises val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 40, (Object)objPC.pais, (Object)val);
        } else {
            objPC.pais = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(40);
            }
        }
    }

    private static Precarios jdoGetprecario(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 41)) {
            return (Precarios)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 41, (Object)objPC.precario);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(41)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"precario\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.precario;
    }

    private static void jdoSetprecario(Entidades objPC, Precarios val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 41, (Object)objPC.precario, (Object)val);
        } else {
            objPC.precario = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(41);
            }
        }
    }

    private static Integer jdoGetregimeiva(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 42)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 42, (Object)objPC.regimeiva);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(42)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"regimeiva\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.regimeiva;
    }

    private static void jdoSetregimeiva(Entidades objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 42, (Object)objPC.regimeiva, (Object)val);
        } else {
            objPC.regimeiva = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(42);
            }
        }
    }

    private static String jdoGetresponsavel(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 43)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 43, objPC.responsavel);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(43)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"responsavel\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.responsavel;
    }

    private static void jdoSetresponsavel(Entidades objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 43, objPC.responsavel, val);
        } else {
            objPC.responsavel = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(43);
            }
        }
    }

    private static Integer jdoGetretencao(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 44)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 44, (Object)objPC.retencao);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(44)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"retencao\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.retencao;
    }

    private static void jdoSetretencao(Entidades objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 44, (Object)objPC.retencao, (Object)val);
        } else {
            objPC.retencao = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(44);
            }
        }
    }

    private static BigDecimal jdoGetsaldopendente(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 45)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 45, (Object)objPC.saldopendente);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(45)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"saldopendente\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.saldopendente;
    }

    private static void jdoSetsaldopendente(Entidades objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 45, (Object)objPC.saldopendente, (Object)val);
        } else {
            objPC.saldopendente = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(45);
            }
        }
    }

    private static BigDecimal jdoGetsaldoprevisto(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 46)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 46, (Object)objPC.saldoprevisto);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(46)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"saldoprevisto\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.saldoprevisto;
    }

    private static void jdoSetsaldoprevisto(Entidades objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 46, (Object)objPC.saldoprevisto, (Object)val);
        } else {
            objPC.saldoprevisto = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(46);
            }
        }
    }

    private static BigDecimal jdoGetsaldoreal(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 47)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 47, (Object)objPC.saldoreal);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(47)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"saldoreal\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.saldoreal;
    }

    private static void jdoSetsaldoreal(Entidades objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 47, (Object)objPC.saldoreal, (Object)val);
        } else {
            objPC.saldoreal = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(47);
            }
        }
    }

    private static Integer jdoGetsendmail(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 48)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 48, (Object)objPC.sendmail);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(48)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"sendmail\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.sendmail;
    }

    private static void jdoSetsendmail(Entidades objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 48, (Object)objPC.sendmail, (Object)val);
        } else {
            objPC.sendmail = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(48);
            }
        }
    }

    private static String jdoGettelefone(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 49)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 49, objPC.telefone);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(49)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"telefone\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.telefone;
    }

    private static void jdoSettelefone(Entidades objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 49, objPC.telefone, val);
        } else {
            objPC.telefone = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(49);
            }
        }
    }

    private static String jdoGettelefone2(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 50)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 50, objPC.telefone2);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(50)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"telefone2\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.telefone2;
    }

    private static void jdoSettelefone2(Entidades objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 50, objPC.telefone2, val);
        } else {
            objPC.telefone2 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(50);
            }
        }
    }

    private static String jdoGettelemovel(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 51)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 51, objPC.telemovel);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(51)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"telemovel\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.telemovel;
    }

    private static void jdoSettelemovel(Entidades objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 51, objPC.telemovel, val);
        } else {
            objPC.telemovel = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(51);
            }
        }
    }

    private static Entidadestipos jdoGettipoentidade(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 52)) {
            return (Entidadestipos)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 52, (Object)objPC.tipoentidade);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(52)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"tipoentidade\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.tipoentidade;
    }

    private static void jdoSettipoentidade(Entidades objPC, Entidadestipos val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 52, (Object)objPC.tipoentidade, (Object)val);
        } else {
            objPC.tipoentidade = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(52);
            }
        }
    }

    private static Integer jdoGettipoiva(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 53)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 53, (Object)objPC.tipoiva);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(53)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"tipoiva\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.tipoiva;
    }

    private static void jdoSettipoiva(Entidades objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 53, (Object)objPC.tipoiva, (Object)val);
        } else {
            objPC.tipoiva = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(53);
            }
        }
    }

    private static Integer jdoGettipopreco(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 54)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 54, (Object)objPC.tipopreco);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(54)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"tipopreco\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.tipopreco;
    }

    private static void jdoSettipopreco(Entidades objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 54, (Object)objPC.tipopreco, (Object)val);
        } else {
            objPC.tipopreco = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(54);
            }
        }
    }

    private static BigDecimal jdoGettotalcredito(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 55)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 55, (Object)objPC.totalcredito);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(55)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"totalcredito\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.totalcredito;
    }

    private static void jdoSettotalcredito(Entidades objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 55, (Object)objPC.totalcredito, (Object)val);
        } else {
            objPC.totalcredito = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(55);
            }
        }
    }

    private static BigDecimal jdoGettotaldebito(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 56)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 56, (Object)objPC.totaldebito);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(56)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"totaldebito\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.totaldebito;
    }

    private static void jdoSettotaldebito(Entidades objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 56, (Object)objPC.totaldebito, (Object)val);
        } else {
            objPC.totaldebito = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(56);
            }
        }
    }

    private static String jdoGeturl(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 57)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 57, objPC.url);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(57)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"url\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.url;
    }

    private static void jdoSeturl(Entidades objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 57, objPC.url, val);
        } else {
            objPC.url = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(57);
            }
        }
    }

    private static Vendedores jdoGetvendedor(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 58)) {
            return (Vendedores)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 58, (Object)objPC.vendedor);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(58)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"vendedor\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.vendedor;
    }

    private static void jdoSetvendedor(Entidades objPC, Vendedores val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 58, (Object)objPC.vendedor, (Object)val);
        } else {
            objPC.vendedor = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(58);
            }
        }
    }

    private static String jdoGetzona(Entidades objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 59)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 59, objPC.zona);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(59)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"zona\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.zona;
    }

    private static void jdoSetzona(Entidades objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 59, objPC.zona, val);
        } else {
            objPC.zona = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(59);
            }
        }
    }

    public static enum NIF_TYPE {
        PS,
        NRS,
        PC,
        OAPCRL,
        OUTROS,
        ESTRANGEIRO;


        public static NIF_TYPE get(Paises pais, String nif) {
            int digit;
            int n = digit = nif.length() == 0 ? 0 : StringUtils.num((char)nif.charAt(0));
            if (pais != null && pais.isPortugal()) {
                switch (digit) {
                    case 1: 
                    case 2: 
                    case 3: {
                        return PS;
                    }
                    case 4: {
                        return NRS;
                    }
                    case 5: {
                        return PC;
                    }
                    case 6: {
                        return OAPCRL;
                    }
                    case 7: 
                    case 8: 
                    case 9: {
                        return OUTROS;
                    }
                }
            }
            return ESTRANGEIRO;
        }
    }

    public static enum RECORDS {
        consumidor_final(Entidadestipos.RECORDS.cliente.codigo, 0, LABELS.CONSUMIDOR_FINAL.toString(), LABELS.DESCONHECIDO.toString(), "999999990");

        public final String key;
        public final String tipoentidade;
        public final int numero;
        public final String nome;
        public final String morada;
        public final String nif;

        private RECORDS(String tipoentidade, int numero, String nome, String morada, String nif) {
            this.key = Entidades.generateKey(tipoentidade, numero);
            this.tipoentidade = tipoentidade;
            this.numero = numero;
            this.nome = nome;
            this.morada = morada;
            this.nif = nif;
        }

        public static Collection<Entidades> create(DatabaseManager manager) {
            ArrayList<Entidades> col = new ArrayList<Entidades>();
            RECORDS[] rECORDSArray = RECORDS.values();
            int n = rECORDSArray.length;
            int n2 = 0;
            while (n2 < n) {
                RECORDS record = rECORDSArray[n2];
                Entidades entidade = new Entidades(manager, record.tipoentidade, (Integer)record.numero);
                entidade.setNome(record.nome);
                entidade.setMorada(record.morada);
                col.add(entidade);
                ++n2;
            }
            return col;
        }
    }
}

