/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.jdo.JDODetachedFieldAccessException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.PersistenceManager;
import javax.jdo.identity.StringIdentity;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;
import org.dma.java.util.ErrorList;
import org.dma.java.util.MessageLine;
import org.dma.java.util.MessageList;
import org.dma.java.util.StringList;
import org.dma.java.util.TimeDateUtils;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.birt.report.BIRTReport;
import org.projectocolibri.api.birt.report.BIRTReportCopies;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.IDatabaseModel;
import org.projectocolibri.api.database.mapper.DEFAULTS;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.AbstractModel;
import org.projectocolibri.api.database.model.Armazens;
import org.projectocolibri.api.database.model.Documentosseries;
import org.projectocolibri.api.database.model.Entidadestipos;
import org.projectocolibri.api.database.model.Layouts;
import org.projectocolibri.api.database.model.Templates;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.api.language.Label;
import org.projectocolibri.core.support.printer.PRINTERS;

@javax.jdo.annotations.PersistenceCapable
public class Documentostipos
extends AbstractModel
implements Detachable,
PersistenceCapable {
    public static final int estado_inactivo = 0;
    public static final int estado_activo = 1;
    public static final int tabela_artigosdocumentos = 0;
    public static final int tabela_entidadesdocumentos = 1;
    public static final int tipodocumento_nenhum = 0;
    public static final int tipodocumento_facturacao = 1;
    public static final int tipodocumento_liquidacao = 2;
    public static final int tipodocumento_facturacaoliquidacao = 3;
    public static final int tipodocumento_rectificativo = 4;
    public static final int tipodocumento_transporte = 5;
    public static final int tipodocumentosaft_interno = 0;
    public static final int tipodocumentosaft_factura = 1;
    public static final int tipodocumentosaft_facturasimplificada = 2;
    public static final int tipodocumentosaft_facturarecibo = 3;
    public static final int tipodocumentosaft_notadebito = 4;
    public static final int tipodocumentosaft_notacredito = 5;
    @Deprecated
    public static final int tipodocumentosaft_vendadinheiro = 6;
    @Deprecated
    public static final int tipodocumentosaft_talaovenda = 7;
    @Deprecated
    public static final int tipodocumentosaft_talaodevolucao = 8;
    @Deprecated
    public static final int tipodocumentosaft_alienacaoactivos = 9;
    @Deprecated
    public static final int tipodocumentosaft_devolucaoactivos = 10;
    public static final int tipodocumentosaft_guiaremessa = 11;
    public static final int tipodocumentosaft_guiatransporte = 12;
    public static final int tipodocumentosaft_guiaativosproprios = 13;
    public static final int tipodocumentosaft_guiaconsignacao = 14;
    public static final int tipodocumentosaft_guiadevolucaocliente = 15;
    public static final int tipodocumentosaft_consultamesa = 16;
    public static final int tipodocumentosaft_creditoconsignacao = 17;
    public static final int tipodocumentosaft_facturaconsignacao = 18;
    public static final int tipodocumentosaft_folhaobra = 19;
    public static final int tipodocumentosaft_notaencomenda = 20;
    public static final int tipodocumentosaft_orcamento = 21;
    public static final int tipodocumentosaft_proforma = 22;
    public static final int tipodocumentosaft_documentoconferencia = 23;
    @Deprecated
    public static final int tipodocumentosaft_conferenciaentrega = 24;
    public static final int tipodocumentosaft_recibonormal = 25;
    public static final int tipodocumentosaft_recibocaixa = 26;
    public static final int copias_nenhuma = 0;
    public static final int copias_original = 1;
    public static final int copias_duplicado = 2;
    public static final int copias_triplicado = 3;
    public static final int copias_quadruplicado = 4;
    public static final int copias_quintuplicado = 5;
    public static final int movimentaartigos_naomovimenta = 0;
    public static final int movimentaartigos_saida = 1;
    public static final int movimentaartigos_entrada = 2;
    public static final int movimentaartigos_saidaentrada = 3;
    public static final int movimentaproducao_naomovimenta = 0;
    public static final int movimentaproducao_saida = 1;
    public static final int movimentaproducao_entrada = 2;
    public static final int tipostock_stockreal = 0;
    public static final int tipostock_stockexterior = 1;
    public static final int tipostock_stockencomendado = 2;
    public static final int tipostock_stockreservado = 3;
    public static final int quantidadependente_nao = 0;
    public static final int quantidadependente_sim = 1;
    public static final int movimentaentidades_naomovimenta = 0;
    public static final int movimentaentidades_debito = 1;
    public static final int movimentaentidades_credito = 2;
    public static final int movimentaentidades_debitocredito = 3;
    public static final int tiposaldo_saldoreal = 0;
    public static final int tiposaldo_saldopendente = 1;
    public static final int valorpendente_nao = 0;
    public static final int valorpendente_sim = 1;
    public static final int movimentabancos_naomovimenta = 0;
    public static final int movimentabancos_debito = 1;
    public static final int movimentabancos_credito = 2;
    public static final int movimentabancos_debitocredito = 3;
    public static final int tipocarregamento_nenhum = 0;
    public static final int tipocarregamento_detalhado = 1;
    public static final int tipocarregamento_agregado = 2;
    public static final int tipomercado_nacional = 0;
    public static final int tipomercado_estrangeiro = 1;
    public static final int actualizaprecoscusto_naoactualiza = 0;
    public static final int actualizaprecoscusto_pcm = 1;
    public static final int actualizaprecoscusto_upc = 2;
    public static final int actualizaprecoscusto_pcmupc = 3;
    public static final int arredondaprecoscusto_naoarredonda = 0;
    public static final int arredondaprecoscusto_arredonda = 1;
    public static final int actualizaprecosvenda_naoactualiza = 0;
    public static final int actualizaprecosvenda_sempre = 1;
    public static final int actualizaprecosvenda_aumentocusto = 2;
    public static final int arredondaprecosvenda_naoarredonda = 0;
    public static final int arredondaprecosvenda_arredonda = 1;
    public static final int arredondatotais_naoarredonda = 0;
    public static final int arredondatotais_arredonda = 1;
    private Entidadestipos tipoentidade;
    private Layouts layout;
    private String codigo;
    private String descricao;
    private String titulo;
    private String impressora;
    private String textoemail;
    private Integer estado;
    private Integer tabela;
    private Integer tipodocumento;
    private Integer tipodocumentosaft;
    @Deprecated
    private Integer vias;
    private Integer copias;
    @Deprecated
    private Integer viasemail;
    private Integer copiasemail;
    private Integer movimentaartigos;
    private Integer movimentaproducao;
    @Deprecated
    private Integer stockartigos;
    private Integer tipostock;
    private Integer quantidadependente;
    private Integer movimentaentidades;
    @Deprecated
    private Integer saldoentidades;
    private Integer tiposaldo;
    private Integer valorpendente;
    private Integer movimentabancos;
    private Integer tipocarregamento;
    @Deprecated
    private Integer tipomercado;
    private Integer actualizaprecoscusto;
    private Integer arredondaprecoscusto;
    private Integer actualizaprecosvenda;
    private Integer arredondaprecosvenda;
    private Integer arredondatotais;
    private Set<Templates> template = new LinkedHashSet<Templates>();
    private Set<Documentosseries> series = new LinkedHashSet<Documentosseries>();
    protected transient StateManager jdoStateManager;
    protected transient byte jdoFlags;
    protected Object[] jdoDetachedState;
    private static final byte[] jdoFieldFlags;
    private static final Class jdoPersistenceCapableSuperclass;
    private static final Class[] jdoFieldTypes;
    private static final String[] jdoFieldNames;
    private static final int jdoInheritedFieldCount;

    public void print() {
        System.out.println("---SERIES---");
        for (Documentosseries linha : this.getSeries()) {
            System.out.print("KEY=" + linha.getKey());
            System.out.print("; LINHA=" + linha.getNumerolinha());
            System.out.println("; NUMERO=" + linha.getNumero());
        }
    }

    private Documentostipos() {
        super(TABLES.documentostipos);
    }

    private Documentostipos(DatabaseManager manager) {
        super(TABLES.documentostipos, manager);
    }

    public Documentostipos(DatabaseManager manager, String codigo, Integer tabela) {
        this(manager, codigo, "", tabela, 0, 0);
    }

    public Documentostipos(DatabaseManager manager, String codigo, String descricao, Integer tabela, Integer tipodocumento, Integer tipodocumentosaft) {
        this(manager);
        this.tipoentidade = tabela == 0 ? null : manager.loadEntidadestipos();
        this.layout = null;
        this.codigo = codigo;
        this.descricao = descricao;
        this.titulo = "";
        this.impressora = manager.getLicenca().allows(Colibri.FUNCIONALIDADES.IMPRESSAO_DIRECTA) ? PRINTERS.DEFAULT.name : PRINTERS.DIALOG.name;
        this.textoemail = manager.isPopulated() ? manager.getParametros().getTextoemail() : "";
        this.estado = 1;
        this.tabela = tabela;
        this.tipodocumento = tipodocumento;
        this.tipodocumentosaft = tipodocumentosaft;
        this.copias = 0;
        this.copiasemail = 0;
        this.movimentaartigos = 0;
        this.movimentaproducao = 0;
        this.tipostock = 0;
        this.quantidadependente = 0;
        this.movimentaentidades = 0;
        this.tiposaldo = 0;
        this.valorpendente = 0;
        this.movimentabancos = 0;
        this.tipocarregamento = 0;
        this.tipomercado = 0;
        this.actualizaprecoscusto = 0;
        this.arredondaprecoscusto = 0;
        this.actualizaprecosvenda = 0;
        this.arredondaprecosvenda = 0;
        this.arredondatotais = 0;
        this.template = new LinkedHashSet<Templates>();
        this.addSeries();
    }

    @Override
    public Documentostipos cloneCopy() {
        Documentostipos clone = new Documentostipos(this.manager);
        Documentostipos.jdoSettipoentidade(clone, Documentostipos.jdoGettipoentidade(this));
        Documentostipos.jdoSetlayout(clone, Documentostipos.jdoGetlayout(this));
        Documentostipos.jdoSetcodigo(clone, Documentostipos.jdoGetcodigo(this));
        Documentostipos.jdoSetdescricao(clone, Documentostipos.jdoGetdescricao(this));
        Documentostipos.jdoSettitulo(clone, Documentostipos.jdoGettitulo(this));
        Documentostipos.jdoSetimpressora(clone, Documentostipos.jdoGetimpressora(this));
        Documentostipos.jdoSettextoemail(clone, Documentostipos.jdoGettextoemail(this));
        Documentostipos.jdoSetestado(clone, Documentostipos.jdoGetestado(this));
        Documentostipos.jdoSettabela(clone, Documentostipos.jdoGettabela(this));
        Documentostipos.jdoSettipodocumento(clone, Documentostipos.jdoGettipodocumento(this));
        Documentostipos.jdoSettipodocumentosaft(clone, Documentostipos.jdoGettipodocumentosaft(this));
        Documentostipos.jdoSetcopias(clone, Documentostipos.jdoGetcopias(this));
        Documentostipos.jdoSetcopiasemail(clone, Documentostipos.jdoGetcopiasemail(this));
        Documentostipos.jdoSetmovimentaartigos(clone, Documentostipos.jdoGetmovimentaartigos(this));
        Documentostipos.jdoSetmovimentaproducao(clone, Documentostipos.jdoGetmovimentaproducao(this));
        Documentostipos.jdoSettipostock(clone, Documentostipos.jdoGettipostock(this));
        Documentostipos.jdoSetquantidadependente(clone, Documentostipos.jdoGetquantidadependente(this));
        Documentostipos.jdoSetmovimentaentidades(clone, Documentostipos.jdoGetmovimentaentidades(this));
        Documentostipos.jdoSettiposaldo(clone, Documentostipos.jdoGettiposaldo(this));
        Documentostipos.jdoSetvalorpendente(clone, Documentostipos.jdoGetvalorpendente(this));
        Documentostipos.jdoSetmovimentabancos(clone, Documentostipos.jdoGetmovimentabancos(this));
        Documentostipos.jdoSettipocarregamento(clone, Documentostipos.jdoGettipocarregamento(this));
        Documentostipos.jdoSettipomercado(clone, Documentostipos.jdoGettipomercado(this));
        Documentostipos.jdoSetactualizaprecoscusto(clone, Documentostipos.jdoGetactualizaprecoscusto(this));
        Documentostipos.jdoSetactualizaprecosvenda(clone, Documentostipos.jdoGetactualizaprecosvenda(this));
        Documentostipos.jdoSetarredondaprecosvenda(clone, Documentostipos.jdoGetarredondaprecosvenda(this));
        Documentostipos.jdoSetarredondaprecoscusto(clone, Documentostipos.jdoGetarredondaprecoscusto(this));
        Documentostipos.jdoSetarredondatotais(clone, Documentostipos.jdoGetarredondatotais(this));
        Documentostipos.jdoSettemplate(clone, new LinkedHashSet(Documentostipos.jdoGettemplate(this)));
        LinkedHashSet<Documentosseries> series = new LinkedHashSet<Documentosseries>();
        for (Documentosseries linha : Documentostipos.jdoGetseries(this)) {
            series.add(linha.cloneCopy(clone));
        }
        Documentostipos.jdoSetseries(clone, series);
        return clone;
    }

    public Documentostipos cleanCopy() {
        Documentostipos clone = this.cloneCopy();
        clone.removeSeries();
        clone.addSeries();
        clone.markDirty();
        return clone;
    }

    @Override
    public MessageList validate(IDatabaseModel.ACTION action) {
        MessageList error = super.validate(action);
        for (Documentosseries linha : this.getSeries()) {
            error.add(linha.validate(action));
        }
        switch (action) {
            case DELETE: {
                if (Documentostipos.jdoGetseries(this).isEmpty()) break;
                error.add((Object)new MessageLine((Object)LABELS.documentostipos_series));
                break;
            }
            case STORE: {
                if (!this.isCodigoValid()) {
                    error.add((Object)new MessageLine((Object)LABELS.documentostipos_codigo));
                }
                if (!this.isTipodocumentosaftValid()) {
                    error.add((Object)new MessageLine((Object)LABELS.documentostipos_tipodocumentosaft));
                }
                if (Documentostipos.jdoGetlayout(this) == null) {
                    error.add((Object)new MessageLine((Object)LABELS.documentostipos_layout).brackets((Object)LABELS.valor_vazio));
                }
                if (!Documentostipos.jdoGettemplate(this).isEmpty()) break;
                error.add((Object)new MessageLine((Object)LABELS.documentostipos_template).brackets((Object)LABELS.valor_vazio));
            }
        }
        return error;
    }

    public ErrorList warnings(PersistenceManager pm) {
        ErrorList error = new ErrorList();
        for (Templates template : Documentostipos.jdoGettemplate(this)) {
            if (this.isTemplateLegal(template)) continue;
            error.warnings().add((Object)new MessageLine((Object)LABELS.info_template_ilegal));
        }
        return error;
    }

    public Entidadestipos getTipoentidade() {
        return Documentostipos.jdoGettipoentidade(this);
    }

    public void setTipoentidade(Entidadestipos tipoentidade) {
        Entidadestipos entidadestipos = Documentostipos.jdoGettipoentidade(this);
        Entidadestipos entidadestipos2 = tipoentidade;
        Documentostipos.jdoSettipoentidade(this, entidadestipos2);
        this.firePropertyChange(FIELDS.documentostipos_tipoentidade, (Object)entidadestipos, (Object)entidadestipos2);
    }

    public Layouts getLayout() {
        return Documentostipos.jdoGetlayout(this);
    }

    public void setLayout(Layouts layout) {
        Layouts layouts = Documentostipos.jdoGetlayout(this);
        Layouts layouts2 = layout;
        Documentostipos.jdoSetlayout(this, layouts2);
        this.firePropertyChange(FIELDS.documentostipos_layout, (Object)layouts, (Object)layouts2);
    }

    @Override
    public String getKey() {
        return Documentostipos.jdoGetcodigo(this);
    }

    public String getCodigo() {
        return Documentostipos.jdoGetcodigo(this);
    }

    public String getCodigoToText() {
        return Documentostipos.jdoGetcodigo(this) == null ? "" : Documentostipos.jdoGetcodigo(this).toString();
    }

    public void setCodigo(String codigo) {
        String string = Documentostipos.jdoGetcodigo(this);
        String string2 = codigo;
        Documentostipos.jdoSetcodigo(this, string2);
        this.firePropertyChange(FIELDS.documentostipos_codigo, (Object)string, (Object)string2);
        for (Documentosseries linha : Documentostipos.jdoGetseries(this)) {
            linha.setKey();
        }
    }

    public boolean isCodigoValid() {
        RECORDS record = RECORDS.get(Documentostipos.jdoGetcodigo(this));
        return record != null || this.manager.getLicenca().allows(Colibri.FUNCIONALIDADES.LICENCA_COMERCIAL);
    }

    public String getDescricao() {
        return Documentostipos.jdoGetdescricao(this);
    }

    public String getDescricaoToText() {
        return Documentostipos.jdoGetdescricao(this) == null ? "" : Documentostipos.jdoGetdescricao(this).toString();
    }

    public void setDescricao(String descricao) {
        String string = Documentostipos.jdoGetdescricao(this);
        String string2 = descricao;
        Documentostipos.jdoSetdescricao(this, string2);
        this.firePropertyChange(FIELDS.documentostipos_descricao, (Object)string, (Object)string2);
    }

    public String getTitulo() {
        return Documentostipos.jdoGettitulo(this);
    }

    public String getTituloToText() {
        return Documentostipos.jdoGettitulo(this) == null || Documentostipos.jdoGettitulo(this).isEmpty() ? this.getDescricaoToText() : Documentostipos.jdoGettitulo(this).toString();
    }

    public void setTitulo(String titulo) {
        String string = Documentostipos.jdoGettitulo(this);
        String string2 = titulo;
        Documentostipos.jdoSettitulo(this, string2);
        this.firePropertyChange(FIELDS.documentostipos_titulo, (Object)string, (Object)string2);
    }

    public String getImpressora() {
        return this.manager.getLicenca().allows(Colibri.FUNCIONALIDADES.IMPRESSAO_DIRECTA) ? Documentostipos.jdoGetimpressora(this) : PRINTERS.DIALOG.name;
    }

    public String getImpressoraToText() {
        PRINTERS printer = PRINTERS.get(Documentostipos.jdoGetimpressora(this));
        if (printer != null) {
            return printer.label;
        }
        return Documentostipos.jdoGetimpressora(this) == null ? "" : Documentostipos.jdoGetimpressora(this).toString();
    }

    public void setImpressora(String impressora) {
        String string = Documentostipos.jdoGetimpressora(this);
        String string2 = impressora;
        Documentostipos.jdoSetimpressora(this, string2);
        this.firePropertyChange(FIELDS.documentostipos_impressora, (Object)string, (Object)string2);
    }

    public String getTextoemail() {
        return Documentostipos.jdoGettextoemail(this);
    }

    public String getTextoemailToText() {
        return Documentostipos.jdoGettextoemail(this) == null ? "" : Documentostipos.jdoGettextoemail(this).toString();
    }

    public void setTextoemail(String textoemail) {
        String string = Documentostipos.jdoGettextoemail(this);
        String string2 = textoemail;
        Documentostipos.jdoSettextoemail(this, string2);
        this.firePropertyChange(FIELDS.documentostipos_textoemail, (Object)string, (Object)string2);
    }

    public Integer getEstado() {
        return Documentostipos.jdoGetestado(this);
    }

    public String getEstadoToText() {
        return Documentostipos.jdoGetestado(this) == null ? "" : FIELDS.documentostipos_estado.values[Documentostipos.jdoGetestado(this)];
    }

    public void setEstado(Integer estado) {
        Integer n = Documentostipos.jdoGetestado(this);
        Integer n2 = estado;
        Documentostipos.jdoSetestado(this, n2);
        this.firePropertyChange(FIELDS.documentostipos_estado, (Object)n, (Object)n2);
    }

    public boolean isEstado(Integer estado) {
        return Documentostipos.equals(estado, Documentostipos.jdoGetestado(this));
    }

    public Integer getTabela() {
        return Documentostipos.jdoGettabela(this);
    }

    public String getTabelaToText() {
        return Documentostipos.jdoGettabela(this) == null ? "" : FIELDS.documentostipos_tabela.values[Documentostipos.jdoGettabela(this)];
    }

    public void setTabela(Integer tabela) {
        Integer n = Documentostipos.jdoGettabela(this);
        Integer n2 = tabela;
        Documentostipos.jdoSettabela(this, n2);
        boolean changed = this.firePropertyChange(FIELDS.documentostipos_tabela, (Object)n, (Object)n2);
        if (changed && this.cascade) {
            switch (tabela) {
                case 0: {
                    this.setTipoentidade(null);
                    break;
                }
                case 1: {
                    this.setTipoentidade(this.manager.loadEntidadestipos());
                }
            }
        }
    }

    public boolean isTabela(Integer tabela) {
        return Documentostipos.equals(tabela, Documentostipos.jdoGettabela(this));
    }

    public Integer getTabela$Layouts() {
        switch (Documentostipos.jdoGettabela(this)) {
            case 0: {
                return 3;
            }
            case 1: {
                return 7;
            }
        }
        throw new IllegalArgumentException();
    }

    public Integer getTabela$Templates() {
        switch (Documentostipos.jdoGettabela(this)) {
            case 0: {
                return 2;
            }
            case 1: {
                return 5;
            }
        }
        throw new IllegalArgumentException();
    }

    public Integer getTabela$Pesquisas() {
        switch (Documentostipos.jdoGettipodocumento(this)) {
            case 0: {
                return -1;
            }
            case 1: 
            case 3: 
            case 5: {
                return 1;
            }
            case 2: {
                return 4;
            }
            case 4: {
                return 5;
            }
        }
        throw new IllegalArgumentException();
    }

    public Integer getTipodocumento() {
        return Documentostipos.jdoGettipodocumento(this);
    }

    public String getTipodocumentoToText() {
        return Documentostipos.jdoGettipodocumento(this) == null ? "" : FIELDS.documentostipos_tipodocumento.values[Documentostipos.jdoGettipodocumento(this)];
    }

    public void setTipodocumento(Integer tipodocumento) {
        Integer n = Documentostipos.jdoGettipodocumento(this);
        Integer n2 = tipodocumento;
        Documentostipos.jdoSettipodocumento(this, n2);
        this.firePropertyChange(FIELDS.documentostipos_tipodocumento, (Object)n, (Object)n2);
    }

    public boolean isTipodocumento(Integer tipodocumento) {
        return Documentostipos.equals(tipodocumento, Documentostipos.jdoGettipodocumento(this));
    }

    public boolean isTipodocumentoEditable() {
        return this.manager.getUtilizador().isColibri();
    }

    public Integer getTipodocumentosaft() {
        return Documentostipos.jdoGettipodocumentosaft(this);
    }

    public String getTipodocumentosaftToText() {
        return Documentostipos.jdoGettipodocumentosaft(this) == null ? "" : FIELDS.documentostipos_tipodocumentosaft.values[Documentostipos.jdoGettipodocumentosaft(this)];
    }

    public void setTipodocumentosaft(Integer tipodocumentosaft) {
        Integer n = Documentostipos.jdoGettipodocumentosaft(this);
        Integer n2 = tipodocumentosaft;
        Documentostipos.jdoSettipodocumentosaft(this, n2);
        this.firePropertyChange(FIELDS.documentostipos_tipodocumentosaft, (Object)n, (Object)n2);
    }

    public boolean isTipodocumentosaft(Integer tipodocumentosaft) {
        return Documentostipos.equals(tipodocumentosaft, Documentostipos.jdoGettipodocumentosaft(this));
    }

    public boolean isTipodocumentosaftCertificado() {
        return Colibri.MARKET_TYPE == Colibri.MARKETS.INTERNAL && !this.isTipodocumentosaft(0);
    }

    public boolean isTipodocumentosaftValid() {
        return !SAFT_DOCUMENT_TYPE.isDeprecated(Documentostipos.jdoGettipodocumentosaft(this)) || this.isEstado(0);
    }

    public boolean isTipodocumentosaftEditable() {
        return !this.isTipodocumentosaftCertificado() || this.manager.getUtilizador().isColibri() || !RECORDS.contains(Documentostipos.jdoGetcodigo(this)) && !this.hasUsedSeries() && !this.hasRegisteredSeries();
    }

    public SAFT_DOCUMENT_TYPE getSAFTDocumentType() {
        return SAFT_DOCUMENT_TYPE.get(Documentostipos.jdoGettipodocumentosaft(this));
    }

    public SAFT_MOVEMENT_GROUP getSAFTMovementClass() {
        SAFT_MOVEMENT_GROUP type = SAFT_MOVEMENT_GROUP.get(Documentostipos.jdoGettipodocumentosaft(this));
        if (type == SAFT_MOVEMENT_GROUP.NONE) {
            switch (Documentostipos.jdoGetmovimentaentidades(this)) {
                case 1: {
                    return SAFT_MOVEMENT_GROUP.DEBIT;
                }
                case 2: {
                    return SAFT_MOVEMENT_GROUP.CREDIT;
                }
            }
        }
        return type;
    }

    public SAFT_DOCUMENT_GROUP getSAFTDocumentGroup() {
        return SAFT_DOCUMENT_GROUP.get(Documentostipos.jdoGettipodocumentosaft(this));
    }

    public SERVICE_DOCUMENT_GROUP getServiceDocumentGroup() {
        return SERVICE_DOCUMENT_GROUP.get(Documentostipos.jdoGettipodocumentosaft(this));
    }

    public CIUS_DOCUMENT_GROUP getCIUSDocumentGroup() {
        return CIUS_DOCUMENT_GROUP.get(Documentostipos.jdoGettipodocumentosaft(this));
    }

    @Deprecated
    public Integer getVias() {
        return Documentostipos.jdoGetvias(this) == null ? Documentostipos.jdoGetcopias(this) : Documentostipos.jdoGetvias(this);
    }

    public Integer getCopias() {
        return Documentostipos.jdoGetcopias(this);
    }

    public String getCopiasToText() {
        return Documentostipos.jdoGetcopias(this) == null ? "" : FIELDS.documentostipos_copias.values[Documentostipos.jdoGetcopias(this)];
    }

    public void setCopias(Integer copias) {
        Integer n = Documentostipos.jdoGetcopias(this);
        Integer n2 = copias;
        Documentostipos.jdoSetcopias(this, n2);
        this.firePropertyChange(FIELDS.documentostipos_copias, (Object)n, (Object)n2);
    }

    public boolean isCopias(Integer copias) {
        return Documentostipos.equals(copias, Documentostipos.jdoGetcopias(this));
    }

    @Deprecated
    public Integer getViasemail() {
        return Documentostipos.jdoGetviasemail(this) == null ? Documentostipos.jdoGetcopiasemail(this) : Documentostipos.jdoGetviasemail(this);
    }

    public Integer getCopiasemail() {
        return Documentostipos.jdoGetcopiasemail(this);
    }

    public String getCopiasemailToText() {
        return Documentostipos.jdoGetcopiasemail(this) == null ? "" : Documentostipos.jdoGetcopiasemail(this).toString();
    }

    public void setCopiasemail(Integer copiasemail) {
        Integer n = Documentostipos.jdoGetcopiasemail(this);
        Integer n2 = copiasemail;
        Documentostipos.jdoSetcopiasemail(this, n2);
        this.firePropertyChange(FIELDS.documentostipos_copiasemail, (Object)n, (Object)n2);
    }

    public boolean isCopiasemailValid() {
        return this.isCopias(0) || Documentostipos.jdoGetcopiasemail(this) <= Documentostipos.jdoGetcopias(this);
    }

    public BIRTReportCopies getReportCopies(BIRTReport.REPORT_ACTIONS action) {
        switch (action) {
            case PREVIEW: {
                return new BIRTReportCopies(Documentostipos.jdoGetcopias(this));
            }
            case PRINT: {
                return new BIRTReportCopies(Documentostipos.jdoGetcopiasemail(this) + 1, Documentostipos.jdoGetcopias(this));
            }
            case EMAIL: {
                return new BIRTReportCopies(Documentostipos.jdoGetcopiasemail(this) <= Documentostipos.jdoGetcopias(this) ? Documentostipos.jdoGetcopiasemail(this) : Documentostipos.jdoGetcopias(this));
            }
            case EMBED: {
                return new BIRTReportCopies(1);
            }
            case ARCHIVE: {
                return this.getReportCopies(BIRTReport.REPORT_ACTIONS.PREVIEW);
            }
        }
        return new BIRTReportCopies();
    }

    public Integer getMovimentaartigos() {
        return Documentostipos.jdoGetmovimentaartigos(this);
    }

    public String getMovimentaartigosToText() {
        return Documentostipos.jdoGetmovimentaartigos(this) == null ? "" : FIELDS.documentostipos_movimentaartigos.values[Documentostipos.jdoGetmovimentaartigos(this)];
    }

    public void setMovimentaartigos(Integer movimentaartigos) {
        Integer n = Documentostipos.jdoGetmovimentaartigos(this);
        Integer n2 = movimentaartigos;
        Documentostipos.jdoSetmovimentaartigos(this, n2);
        this.firePropertyChange(FIELDS.documentostipos_movimentaartigos, (Object)n, (Object)n2);
    }

    public boolean isMovimentaartigos(Integer movimentaartigos) {
        return Documentostipos.equals(movimentaartigos, Documentostipos.jdoGetmovimentaartigos(this));
    }

    public boolean isMovimentaartigosEditable() {
        return !this.hasUsedSeries();
    }

    public Armazens getArmazemcarga() {
        if (!this.isTipodocumento(2)) {
            switch (Documentostipos.jdoGetmovimentaartigos(this)) {
                case 0: {
                    switch (Documentostipos.jdoGettipoentidade(this).getTipoentidade()) {
                        case 0: {
                            return this.manager.getParametros().getArmazem();
                        }
                        case 1: {
                            return new Armazens(this.manager, "");
                        }
                    }
                    break;
                }
                case 1: 
                case 3: {
                    return this.manager.getParametros().getArmazem();
                }
            }
        }
        return new Armazens(this.manager, "");
    }

    public Armazens getArmazemdescarga() {
        if (!this.isTipodocumento(2)) {
            switch (Documentostipos.jdoGetmovimentaartigos(this)) {
                case 0: {
                    switch (Documentostipos.jdoGettipoentidade(this).getTipoentidade()) {
                        case 0: {
                            return new Armazens(this.manager, "");
                        }
                        case 1: {
                            return this.manager.getParametros().getArmazem();
                        }
                    }
                    break;
                }
                case 2: 
                case 3: {
                    return this.manager.getParametros().getArmazem();
                }
            }
        }
        return new Armazens(this.manager, "");
    }

    public Integer getMovimentaproducao() {
        return Documentostipos.jdoGetmovimentaproducao(this);
    }

    public String getMovimentaproducaoToText() {
        return Documentostipos.jdoGetmovimentaproducao(this) == null ? "" : FIELDS.documentostipos_movimentaproducao.values[Documentostipos.jdoGetmovimentaproducao(this)];
    }

    public void setMovimentaproducao(Integer movimentaproducao) {
        Integer n = Documentostipos.jdoGetmovimentaproducao(this);
        Integer n2 = movimentaproducao;
        Documentostipos.jdoSetmovimentaproducao(this, n2);
        this.firePropertyChange(FIELDS.documentostipos_movimentaproducao, (Object)n, (Object)n2);
    }

    public boolean isMovimentaproducao(Integer movimentaproducao) {
        return Documentostipos.equals(movimentaproducao, Documentostipos.jdoGetmovimentaproducao(this));
    }

    @Deprecated
    public Integer getStockartigos() {
        return Documentostipos.jdoGetstockartigos(this) == null ? Documentostipos.jdoGettipostock(this) : Documentostipos.jdoGetstockartigos(this);
    }

    public Integer getTipostock() {
        return Documentostipos.jdoGettipostock(this);
    }

    public String getTipostockToText() {
        return Documentostipos.jdoGettipostock(this) == null ? "" : FIELDS.documentostipos_tipostock.values[Documentostipos.jdoGettipostock(this)];
    }

    public void setTipostock(Integer tipostock) {
        Integer n = Documentostipos.jdoGettipostock(this);
        Integer n2 = tipostock;
        Documentostipos.jdoSettipostock(this, n2);
        this.firePropertyChange(FIELDS.documentostipos_tipostock, (Object)n, (Object)n2);
    }

    public boolean isTipostock(Integer tipostock) {
        return Documentostipos.equals(tipostock, Documentostipos.jdoGettipostock(this));
    }

    public Integer getQuantidadependente() {
        return Documentostipos.jdoGetquantidadependente(this);
    }

    public String getQuantidadependenteToText() {
        return Documentostipos.jdoGetquantidadependente(this) == null ? "" : FIELDS.documentostipos_quantidadependente.values[Documentostipos.jdoGetquantidadependente(this)];
    }

    public void setQuantidadependente(Integer quantidadependente) {
        Integer n = Documentostipos.jdoGetquantidadependente(this);
        Integer n2 = quantidadependente;
        Documentostipos.jdoSetquantidadependente(this, n2);
        this.firePropertyChange(FIELDS.documentostipos_quantidadependente, (Object)n, (Object)n2);
    }

    public boolean isQuantidadependente(Integer quantidadependente) {
        return Documentostipos.equals(quantidadependente, Documentostipos.jdoGetquantidadependente(this));
    }

    public Integer getMovimentaentidades() {
        return Documentostipos.jdoGetmovimentaentidades(this);
    }

    public String getMovimentaentidadesToText() {
        return Documentostipos.jdoGetmovimentaentidades(this) == null ? "" : FIELDS.documentostipos_movimentaentidades.values[Documentostipos.jdoGetmovimentaentidades(this)];
    }

    public void setMovimentaentidades(Integer movimentaentidades) {
        Integer n = Documentostipos.jdoGetmovimentaentidades(this);
        Integer n2 = movimentaentidades;
        Documentostipos.jdoSetmovimentaentidades(this, n2);
        this.firePropertyChange(FIELDS.documentostipos_movimentaentidades, (Object)n, (Object)n2);
    }

    public boolean isMovimentaentidades(Integer movimentaentidades) {
        return Documentostipos.equals(movimentaentidades, Documentostipos.jdoGetmovimentaentidades(this));
    }

    public boolean isMovimentaentidadesEditable() {
        return !this.hasUsedSeries();
    }

    @Deprecated
    public Integer getSaldoentidades() {
        return Documentostipos.jdoGetsaldoentidades(this) == null ? Documentostipos.jdoGettiposaldo(this) : Documentostipos.jdoGetsaldoentidades(this);
    }

    public Integer getTiposaldo() {
        return Documentostipos.jdoGettiposaldo(this);
    }

    public String getTiposaldoToText() {
        return Documentostipos.jdoGettiposaldo(this) == null ? "" : FIELDS.documentostipos_tiposaldo.values[Documentostipos.jdoGettiposaldo(this)];
    }

    public void setTiposaldo(Integer tiposaldo) {
        Integer n = Documentostipos.jdoGettiposaldo(this);
        Integer n2 = tiposaldo;
        Documentostipos.jdoSettiposaldo(this, n2);
        this.firePropertyChange(FIELDS.documentostipos_tiposaldo, (Object)n, (Object)n2);
    }

    public boolean isTiposaldo(Integer tiposaldo) {
        return Documentostipos.equals(tiposaldo, Documentostipos.jdoGettiposaldo(this));
    }

    public Integer getValorpendente() {
        return Documentostipos.jdoGetvalorpendente(this);
    }

    public String getValorpendenteToText() {
        return Documentostipos.jdoGetvalorpendente(this) == null ? "" : FIELDS.documentostipos_valorpendente.values[Documentostipos.jdoGetvalorpendente(this)];
    }

    public void setValorpendente(Integer valorpendente) {
        Integer n = Documentostipos.jdoGetvalorpendente(this);
        Integer n2 = valorpendente;
        Documentostipos.jdoSetvalorpendente(this, n2);
        this.firePropertyChange(FIELDS.documentostipos_valorpendente, (Object)n, (Object)n2);
    }

    public boolean isValorpendente(Integer valorpendente) {
        return Documentostipos.equals(valorpendente, Documentostipos.jdoGetvalorpendente(this));
    }

    public Integer getMovimentabancos() {
        return Documentostipos.jdoGetmovimentabancos(this);
    }

    public String getMovimentabancosToText() {
        return Documentostipos.jdoGetmovimentabancos(this) == null ? "" : FIELDS.documentostipos_movimentabancos.values[Documentostipos.jdoGetmovimentabancos(this)];
    }

    public void setMovimentabancos(Integer movimentabancos) {
        Integer n = Documentostipos.jdoGetmovimentabancos(this);
        Integer n2 = movimentabancos;
        Documentostipos.jdoSetmovimentabancos(this, n2);
        this.firePropertyChange(FIELDS.documentostipos_movimentabancos, (Object)n, (Object)n2);
    }

    public boolean isMovimentabancos(Integer movimentabancos) {
        return Documentostipos.equals(movimentabancos, Documentostipos.jdoGetmovimentabancos(this));
    }

    public Integer getTipocarregamento() {
        return Documentostipos.jdoGettipocarregamento(this);
    }

    public String getTipocarregamentoToText() {
        return Documentostipos.jdoGettipocarregamento(this) == null ? "" : FIELDS.documentostipos_tipocarregamento.values[Documentostipos.jdoGettipocarregamento(this)];
    }

    public void setTipocarregamento(Integer tipocarregamento) {
        Integer n = Documentostipos.jdoGettipocarregamento(this);
        Integer n2 = tipocarregamento;
        Documentostipos.jdoSettipocarregamento(this, n2);
        this.firePropertyChange(FIELDS.documentostipos_tipocarregamento, (Object)n, (Object)n2);
    }

    public boolean isTipocarregamento(Integer tipocarregamento) {
        return Documentostipos.equals(tipocarregamento, Documentostipos.jdoGettipocarregamento(this));
    }

    @Deprecated
    public Integer getFormacarregamento() {
        return null;
    }

    @Deprecated
    public Integer getTipomercado() {
        return Documentostipos.jdoGettipomercado(this);
    }

    @Deprecated
    public String getTipomercadoToText() {
        return Documentostipos.jdoGettipomercado(this) == null ? "" : FIELDS.documentostipos_tipomercado.values[Documentostipos.jdoGettipomercado(this)];
    }

    @Deprecated
    public void setTipomercado(Integer tipomercado) {
        Integer n = Documentostipos.jdoGettipomercado(this);
        Integer n2 = tipomercado;
        Documentostipos.jdoSettipomercado(this, n2);
        this.firePropertyChange(FIELDS.documentostipos_tipomercado, (Object)n, (Object)n2);
    }

    @Deprecated
    public boolean isTipomercado(Integer tipomercado) {
        return Documentostipos.equals(tipomercado, Documentostipos.jdoGettipomercado(this));
    }

    @Deprecated
    public Integer getDocumentopos() {
        return null;
    }

    public Integer getActualizaprecoscusto() {
        return Documentostipos.jdoGetactualizaprecoscusto(this);
    }

    public String getActualizaprecoscustoToText() {
        return Documentostipos.jdoGetactualizaprecoscusto(this) == null ? "" : FIELDS.documentostipos_actualizaprecoscusto.values[Documentostipos.jdoGetactualizaprecoscusto(this)];
    }

    public void setActualizaprecoscusto(Integer actualizaprecoscusto) {
        Integer n = Documentostipos.jdoGetactualizaprecoscusto(this);
        Integer n2 = actualizaprecoscusto;
        Documentostipos.jdoSetactualizaprecoscusto(this, n2);
        this.firePropertyChange(FIELDS.documentostipos_actualizaprecoscusto, (Object)n, (Object)n2);
    }

    public boolean isActualizaprecoscusto(Integer actualizaprecoscusto) {
        return Documentostipos.equals(actualizaprecoscusto, Documentostipos.jdoGetactualizaprecoscusto(this));
    }

    public Integer getArredondaprecoscusto() {
        return Documentostipos.jdoGetarredondaprecoscusto(this);
    }

    public String getArredondaprecoscustoToText() {
        return Documentostipos.jdoGetarredondaprecoscusto(this) == null ? "" : FIELDS.documentostipos_arredondaprecoscusto.values[Documentostipos.jdoGetarredondaprecoscusto(this)];
    }

    public void setArredondaprecoscusto(Integer arredondaprecoscusto) {
        Integer n = Documentostipos.jdoGetarredondaprecoscusto(this);
        Integer n2 = arredondaprecoscusto;
        Documentostipos.jdoSetarredondaprecoscusto(this, n2);
        this.firePropertyChange(FIELDS.documentostipos_arredondaprecoscusto, (Object)n, (Object)n2);
    }

    public boolean isArredondaprecoscusto(Integer arredondaprecoscusto) {
        return Documentostipos.equals(arredondaprecoscusto, Documentostipos.jdoGetarredondaprecoscusto(this));
    }

    public Integer getActualizaprecosvenda() {
        return Documentostipos.jdoGetactualizaprecosvenda(this);
    }

    public String getActualizaprecosvendaToText() {
        return Documentostipos.jdoGetactualizaprecosvenda(this) == null ? "" : FIELDS.documentostipos_actualizaprecosvenda.values[Documentostipos.jdoGetactualizaprecosvenda(this)];
    }

    public void setActualizaprecosvenda(Integer actualizaprecosvenda) {
        Integer n = Documentostipos.jdoGetactualizaprecosvenda(this);
        Integer n2 = actualizaprecosvenda;
        Documentostipos.jdoSetactualizaprecosvenda(this, n2);
        this.firePropertyChange(FIELDS.documentostipos_actualizaprecosvenda, (Object)n, (Object)n2);
    }

    public boolean isActualizaprecosvenda(Integer actualizaprecosvenda) {
        return Documentostipos.equals(actualizaprecosvenda, Documentostipos.jdoGetactualizaprecosvenda(this));
    }

    public Integer getArredondaprecosvenda() {
        return Documentostipos.jdoGetarredondaprecosvenda(this);
    }

    public String getArredondaprecosvendaToText() {
        return Documentostipos.jdoGetarredondaprecosvenda(this) == null ? "" : FIELDS.documentostipos_arredondaprecosvenda.values[Documentostipos.jdoGetarredondaprecosvenda(this)];
    }

    public void setArredondaprecosvenda(Integer arredondaprecosvenda) {
        Integer n = Documentostipos.jdoGetarredondaprecosvenda(this);
        Integer n2 = arredondaprecosvenda;
        Documentostipos.jdoSetarredondaprecosvenda(this, n2);
        this.firePropertyChange(FIELDS.documentostipos_arredondaprecosvenda, (Object)n, (Object)n2);
    }

    public boolean isArredondaprecosvenda(Integer arredondaprecosvenda) {
        return Documentostipos.equals(arredondaprecosvenda, Documentostipos.jdoGetarredondaprecosvenda(this));
    }

    public Integer getArredondatotais() {
        return Documentostipos.jdoGetarredondatotais(this);
    }

    public String getArredondatotaisToText() {
        return Documentostipos.jdoGetarredondatotais(this) == null ? "" : FIELDS.documentostipos_arredondatotais.values[Documentostipos.jdoGetarredondatotais(this)];
    }

    public void setArredondatotais(Integer arredondatotais) {
        Integer n = Documentostipos.jdoGetarredondatotais(this);
        Integer n2 = arredondatotais;
        Documentostipos.jdoSetarredondatotais(this, n2);
        this.firePropertyChange(FIELDS.documentostipos_arredondatotais, (Object)n, (Object)n2);
    }

    public boolean isArredondatotais(Integer arredondatotais) {
        return Documentostipos.equals(arredondatotais, Documentostipos.jdoGetarredondatotais(this));
    }

    public Collection<Templates> getTemplate() {
        return Documentostipos.jdoGettemplate(this);
    }

    public Templates getTemplate(int index) {
        return index >= Documentostipos.jdoGettemplate(this).size() ? null : (Templates)new ArrayList(Documentostipos.jdoGettemplate(this)).get(index);
    }

    public void setTemplate(Templates.RECORDS record) {
        this.setTemplate(this.manager.loadTemplates(record.codigo, false));
    }

    public void setTemplate(Templates template) {
        this.setTemplate(template == null ? new ArrayList<Templates>() : Arrays.asList(template));
    }

    public void setTemplate(Collection<Templates> template) {
        this.firePropertyChange(FIELDS.documentostipos_template, (Object)Documentostipos.jdoGettemplate(this), template);
        Documentostipos.jdoGettemplate(this).clear();
        Documentostipos.jdoGettemplate(this).addAll(template);
    }

    public boolean isTemplateLegal(Templates template) {
        return !this.isTipodocumentosaftCertificado() || template.isLegal();
    }

    public Documentosseries createSeries() {
        String serie;
        Integer regimeiva = this.isTipodocumentosaft(26) ? 1 : 0;
        int value = Documentosseries.getYear();
        do {
            serie = Documentosseries.generateSerie(value++, 0, regimeiva);
        } while (this.getSeries(Documentosseries.generateKey(Documentostipos.jdoGetcodigo(this), serie)) != null);
        return new Documentosseries(this, serie, 0, regimeiva);
    }

    private List<Documentosseries> sortedSeries() {
        ArrayList<Documentosseries> list = new ArrayList<Documentosseries>(Documentostipos.jdoGetseries(this));
        Collections.sort(list);
        return list;
    }

    public Collection<Documentosseries> getSeries() {
        return Collections.unmodifiableList(this.sortedSeries());
    }

    public Documentosseries getSeries(int index) {
        return index >= Documentostipos.jdoGetseries(this).size() ? null : this.sortedSeries().get(index);
    }

    public Documentosseries getSeries(String key) {
        for (Documentosseries linha : Documentostipos.jdoGetseries(this)) {
            if (!linha.getKey().equals(key)) continue;
            return linha;
        }
        return null;
    }

    public void setSeries(Collection<Documentosseries> series) {
        Documentostipos.jdoGetseries(this).clear();
        this.addSeries(series);
    }

    public Documentosseries addSeries() {
        return this.addSeries(this.createSeries());
    }

    public Documentosseries addSeries(Documentosseries series) {
        if (series != null) {
            this.addSeries(Arrays.asList(series));
        }
        return series;
    }

    public boolean insertSeries() {
        return this.insertSeries(this.createSeries());
    }

    public boolean insertSeries(Documentosseries series) {
        if (this.addSeries(Arrays.asList(series))) {
            series.setNumerolinha(0);
            for (Documentosseries serie : Documentostipos.jdoGetseries(this)) {
                serie.setNumerolinha(serie.getNumerolinha() + 1);
            }
            return true;
        }
        return false;
    }

    public boolean addSeries(Collection<Documentosseries> series) {
        int index = Documentostipos.jdoGetseries(this).size();
        for (Documentosseries linha : series) {
            linha.setNumerolinha(++index);
            linha.setTipodocumento(this);
        }
        return Documentostipos.jdoGetseries(this).addAll(series);
    }

    public void removeSeries() {
        this.removeSeries(Documentostipos.jdoGetseries(this));
    }

    public void removeSeries(int index) {
        this.removeSeries(this.getSeries(index));
    }

    public void removeSeries(Documentosseries series) {
        this.removeSeries(Arrays.asList(series));
    }

    public void removeSeries(Collection<Documentosseries> series) {
        Documentostipos.jdoGetseries(this).removeAll(series);
        int index = 0;
        for (Documentosseries linha : this.getSeries()) {
            linha.setNumerolinha(++index);
        }
    }

    public boolean hasUsedSeries() {
        for (Documentosseries linha : Documentostipos.jdoGetseries(this)) {
            if (linha.getNumero() <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasRegisteredSeries() {
        for (Documentosseries linha : Documentostipos.jdoGetseries(this)) {
            if (!linha.hasCodigovalidacao()) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    private boolean containsCodigovalidacao(Documentosseries serie) {
        for (Documentosseries linha : Documentostipos.jdoGetseries(this)) {
            if (linha.equals(serie) || !linha.hasCodigovalidacao() || !linha.getCodigovalidacao().equals(serie.getCodigovalidacao())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEditable(FIELDS field) {
        return !(!super.isEditable(field) || field == FIELDS.documentostipos_tabela && this.isEdited() || field == FIELDS.documentostipos_tipoentidade && this.isEdited() || field == FIELDS.documentostipos_tipodocumento && this.isEdited() && !this.isTipodocumentoEditable() || field == FIELDS.documentostipos_tipodocumentosaft && this.isEdited() && !this.isTipodocumentosaftEditable() || field == FIELDS.documentostipos_movimentaartigos && this.isEdited() || field == FIELDS.documentostipos_movimentaproducao && this.isEdited() || field == FIELDS.documentostipos_tipostock && this.isEdited() || field == FIELDS.documentostipos_quantidadependente && this.isEdited() || field == FIELDS.documentostipos_movimentaentidades && this.isEdited() || field == FIELDS.documentostipos_tiposaldo && this.isEdited() || field == FIELDS.documentostipos_valorpendente && this.isEdited() || field == FIELDS.documentostipos_movimentabancos && this.isEdited() || field == FIELDS.documentostipos_tipocarregamento && this.isEdited() || field == FIELDS.documentostipos_tipomercado && this.isEdited());
    }

    @Override
    public void attach(DatabaseManager manager) {
        manager.attach(Documentostipos.jdoGettemplate(this));
        manager.attach(Documentostipos.jdoGetseries(this));
        manager.attach(new AbstractModel[]{Documentostipos.jdoGettipoentidade(this), Documentostipos.jdoGetlayout(this)});
    }

    @Override
    public boolean isDirty() {
        return super.isDirty() || this.isDirty(Documentostipos.jdoGettemplate(this)) || this.isDirty(Documentostipos.jdoGetseries(this));
    }

    public String toString() {
        return String.valueOf(Documentostipos.jdoGetcodigo(this)) + " - " + Documentostipos.jdoGetdescricao(this);
    }

    public int hashCode() {
        return Documentostipos.jdoGetcodigo(this) == null ? 0 : Documentostipos.jdoGetcodigo(this).hashCode();
    }

    public boolean equals(Object obj) {
        return this.hashCode() == obj.hashCode();
    }

    static {
        jdoFieldNames = Documentostipos.__jdoFieldNamesInit();
        jdoFieldTypes = Documentostipos.__jdoFieldTypesInit();
        jdoFieldFlags = Documentostipos.__jdoFieldFlagsInit();
        jdoInheritedFieldCount = Documentostipos.__jdoGetInheritedFieldCount();
        jdoPersistenceCapableSuperclass = Documentostipos.__jdoPersistenceCapableSuperclassInit();
        JDOImplHelper.registerClass((Class)Documentostipos.___jdo$loadClass("org.projectocolibri.api.database.model.Documentostipos"), (String[])jdoFieldNames, (Class[])jdoFieldTypes, (byte[])jdoFieldFlags, (Class)jdoPersistenceCapableSuperclass, (PersistenceCapable)new Documentostipos());
    }

    public void jdoCopyKeyFieldsFromObjectId(PersistenceCapable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("oid is not instanceof javax.jdo.identity.StringIdentity");
        }
        StringIdentity o = (StringIdentity)oid;
        fc.storeStringField(5, o.getKey());
    }

    protected void jdoCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("key class is not javax.jdo.identity.StringIdentity or null");
        }
        StringIdentity o = (StringIdentity)oid;
        this.codigo = o.getKey();
    }

    public final void jdoCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final void jdoCopyKeyFieldsToObjectId(PersistenceCapable.ObjectIdFieldSupplier fs, Object object) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final Object jdoGetObjectId() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getObjectId((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[0];
    }

    public final Object jdoGetVersion() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getVersion((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[1];
    }

    protected final void jdoPreSerialize() {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.preSerialize((PersistenceCapable)this);
        }
    }

    public final PersistenceManager jdoGetPersistenceManager() {
        return this.jdoStateManager != null ? this.jdoStateManager.getPersistenceManager((PersistenceCapable)this) : null;
    }

    public final Object jdoGetTransactionalObjectId() {
        return this.jdoStateManager != null ? this.jdoStateManager.getTransactionalObjectId((PersistenceCapable)this) : null;
    }

    public final boolean jdoIsDeleted() {
        return this.jdoStateManager != null ? this.jdoStateManager.isDeleted((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsDirty() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.isDirty((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return false;
        }
        return ((BitSet)this.jdoDetachedState[3]).length() > 0;
    }

    public final boolean jdoIsNew() {
        return this.jdoStateManager != null ? this.jdoStateManager.isNew((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsPersistent() {
        return this.jdoStateManager != null ? this.jdoStateManager.isPersistent((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsTransactional() {
        return this.jdoStateManager != null ? this.jdoStateManager.isTransactional((PersistenceCapable)this) : false;
    }

    public void jdoMakeDirty(String fieldName) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.makeDirty((PersistenceCapable)this, fieldName);
        }
        if (this.jdoIsDetached() && fieldName != null) {
            String fldName = null;
            fldName = fieldName.indexOf(46) >= 0 ? fieldName.substring(fieldName.lastIndexOf(46) + 1) : fieldName;
            int i = 0;
            while (i < jdoFieldNames.length) {
                if (jdoFieldNames[i].equals(fldName)) {
                    if (!((BitSet)this.jdoDetachedState[2]).get(i + jdoInheritedFieldCount)) {
                        throw new JDODetachedFieldAccessException("You have just attempted to access a field/property that hasn't been detached. Please detach it first before performing this operation");
                    }
                    ((BitSet)this.jdoDetachedState[3]).set(i + jdoInheritedFieldCount);
                    return;
                }
                ++i;
            }
        }
    }

    public final Object jdoNewObjectIdInstance() {
        return new StringIdentity(this.getClass(), this.codigo);
    }

    public final Object jdoNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new StringIdentity(this.getClass(), (String)key);
        }
        return new StringIdentity(this.getClass(), (String)key);
    }

    public final void jdoProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void jdoReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.jdoReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void jdoReplaceFlags() {
        if (this.jdoStateManager != null) {
            this.jdoFlags = this.jdoStateManager.replacingFlags((PersistenceCapable)this);
        }
    }

    public final synchronized void jdoReplaceStateManager(StateManager sm) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager = this.jdoStateManager.replacingStateManager((PersistenceCapable)this, sm);
        } else {
            JDOImplHelper.checkAuthorizedStateManager((StateManager)sm);
            this.jdoStateManager = sm;
            this.jdoFlags = 1;
        }
    }

    public final synchronized void jdoReplaceDetachedState() {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        this.jdoDetachedState = this.jdoStateManager.replacingDetachedState((Detachable)this, this.jdoDetachedState);
    }

    public boolean jdoIsDetached() {
        return this.jdoStateManager == null && this.jdoDetachedState != null;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm) {
        Documentostipos result = new Documentostipos();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        return result;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm, Object obj) {
        Documentostipos result = new Documentostipos();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        result.jdoCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void jdoReplaceField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.actualizaprecoscusto = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 1: {
                this.actualizaprecosvenda = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 2: {
                this.arredondaprecoscusto = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 3: {
                this.arredondaprecosvenda = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 4: {
                this.arredondatotais = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 5: {
                this.codigo = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 6: {
                this.copias = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 7: {
                this.copiasemail = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 8: {
                this.descricao = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 9: {
                this.estado = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 10: {
                this.impressora = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 11: {
                this.layout = (Layouts)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 12: {
                this.movimentaartigos = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 13: {
                this.movimentabancos = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 14: {
                this.movimentaentidades = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 15: {
                this.movimentaproducao = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 16: {
                this.quantidadependente = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 17: {
                this.saldoentidades = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 18: {
                this.series = (Set)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 19: {
                this.stockartigos = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 20: {
                this.tabela = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 21: {
                this.template = (Set)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 22: {
                this.textoemail = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 23: {
                this.tipocarregamento = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 24: {
                this.tipodocumento = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 25: {
                this.tipodocumentosaft = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 26: {
                this.tipoentidade = (Entidadestipos)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 27: {
                this.tipomercado = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 28: {
                this.tiposaldo = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 29: {
                this.tipostock = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 30: {
                this.titulo = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 31: {
                this.valorpendente = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 32: {
                this.vias = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 33: {
                this.viasemail = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoProvideField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.actualizaprecoscusto);
                break;
            }
            case 1: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.actualizaprecosvenda);
                break;
            }
            case 2: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.arredondaprecoscusto);
                break;
            }
            case 3: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.arredondaprecosvenda);
                break;
            }
            case 4: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.arredondatotais);
                break;
            }
            case 5: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.codigo);
                break;
            }
            case 6: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.copias);
                break;
            }
            case 7: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.copiasemail);
                break;
            }
            case 8: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.descricao);
                break;
            }
            case 9: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.estado);
                break;
            }
            case 10: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.impressora);
                break;
            }
            case 11: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.layout);
                break;
            }
            case 12: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.movimentaartigos);
                break;
            }
            case 13: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.movimentabancos);
                break;
            }
            case 14: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.movimentaentidades);
                break;
            }
            case 15: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.movimentaproducao);
                break;
            }
            case 16: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.quantidadependente);
                break;
            }
            case 17: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.saldoentidades);
                break;
            }
            case 18: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, this.series);
                break;
            }
            case 19: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.stockartigos);
                break;
            }
            case 20: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.tabela);
                break;
            }
            case 21: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, this.template);
                break;
            }
            case 22: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.textoemail);
                break;
            }
            case 23: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.tipocarregamento);
                break;
            }
            case 24: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.tipodocumento);
                break;
            }
            case 25: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.tipodocumentosaft);
                break;
            }
            case 26: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.tipoentidade);
                break;
            }
            case 27: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.tipomercado);
                break;
            }
            case 28: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.tiposaldo);
                break;
            }
            case 29: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.tipostock);
                break;
            }
            case 30: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.titulo);
                break;
            }
            case 31: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.valorpendente);
                break;
            }
            case 32: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.vias);
                break;
            }
            case 33: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.viasemail);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void jdoCopyField(Documentostipos obj, int index) {
        switch (index) {
            case 0: {
                this.actualizaprecoscusto = obj.actualizaprecoscusto;
                break;
            }
            case 1: {
                this.actualizaprecosvenda = obj.actualizaprecosvenda;
                break;
            }
            case 2: {
                this.arredondaprecoscusto = obj.arredondaprecoscusto;
                break;
            }
            case 3: {
                this.arredondaprecosvenda = obj.arredondaprecosvenda;
                break;
            }
            case 4: {
                this.arredondatotais = obj.arredondatotais;
                break;
            }
            case 5: {
                this.codigo = obj.codigo;
                break;
            }
            case 6: {
                this.copias = obj.copias;
                break;
            }
            case 7: {
                this.copiasemail = obj.copiasemail;
                break;
            }
            case 8: {
                this.descricao = obj.descricao;
                break;
            }
            case 9: {
                this.estado = obj.estado;
                break;
            }
            case 10: {
                this.impressora = obj.impressora;
                break;
            }
            case 11: {
                this.layout = obj.layout;
                break;
            }
            case 12: {
                this.movimentaartigos = obj.movimentaartigos;
                break;
            }
            case 13: {
                this.movimentabancos = obj.movimentabancos;
                break;
            }
            case 14: {
                this.movimentaentidades = obj.movimentaentidades;
                break;
            }
            case 15: {
                this.movimentaproducao = obj.movimentaproducao;
                break;
            }
            case 16: {
                this.quantidadependente = obj.quantidadependente;
                break;
            }
            case 17: {
                this.saldoentidades = obj.saldoentidades;
                break;
            }
            case 18: {
                this.series = obj.series;
                break;
            }
            case 19: {
                this.stockartigos = obj.stockartigos;
                break;
            }
            case 20: {
                this.tabela = obj.tabela;
                break;
            }
            case 21: {
                this.template = obj.template;
                break;
            }
            case 22: {
                this.textoemail = obj.textoemail;
                break;
            }
            case 23: {
                this.tipocarregamento = obj.tipocarregamento;
                break;
            }
            case 24: {
                this.tipodocumento = obj.tipodocumento;
                break;
            }
            case 25: {
                this.tipodocumentosaft = obj.tipodocumentosaft;
                break;
            }
            case 26: {
                this.tipoentidade = obj.tipoentidade;
                break;
            }
            case 27: {
                this.tipomercado = obj.tipomercado;
                break;
            }
            case 28: {
                this.tiposaldo = obj.tiposaldo;
                break;
            }
            case 29: {
                this.tipostock = obj.tipostock;
                break;
            }
            case 30: {
                this.titulo = obj.titulo;
                break;
            }
            case 31: {
                this.valorpendente = obj.valorpendente;
                break;
            }
            case 32: {
                this.vias = obj.vias;
                break;
            }
            case 33: {
                this.viasemail = obj.viasemail;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoCopyFields(Object obj, int[] indices) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof Documentostipos)) {
            throw new IllegalArgumentException("object is not an object of type org.projectocolibri.api.database.model.Documentostipos");
        }
        Documentostipos other = (Documentostipos)obj;
        if (this.jdoStateManager != other.jdoStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __jdoFieldNamesInit() {
        return new String[]{"actualizaprecoscusto", "actualizaprecosvenda", "arredondaprecoscusto", "arredondaprecosvenda", "arredondatotais", "codigo", "copias", "copiasemail", "descricao", "estado", "impressora", "layout", "movimentaartigos", "movimentabancos", "movimentaentidades", "movimentaproducao", "quantidadependente", "saldoentidades", "series", "stockartigos", "tabela", "template", "textoemail", "tipocarregamento", "tipodocumento", "tipodocumentosaft", "tipoentidade", "tipomercado", "tiposaldo", "tipostock", "titulo", "valorpendente", "vias", "viasemail"};
    }

    private static final Class[] __jdoFieldTypesInit() {
        return new Class[]{Documentostipos.___jdo$loadClass("java.lang.Integer"), Documentostipos.___jdo$loadClass("java.lang.Integer"), Documentostipos.___jdo$loadClass("java.lang.Integer"), Documentostipos.___jdo$loadClass("java.lang.Integer"), Documentostipos.___jdo$loadClass("java.lang.Integer"), Documentostipos.___jdo$loadClass("java.lang.String"), Documentostipos.___jdo$loadClass("java.lang.Integer"), Documentostipos.___jdo$loadClass("java.lang.Integer"), Documentostipos.___jdo$loadClass("java.lang.String"), Documentostipos.___jdo$loadClass("java.lang.Integer"), Documentostipos.___jdo$loadClass("java.lang.String"), Documentostipos.___jdo$loadClass("org.projectocolibri.api.database.model.Layouts"), Documentostipos.___jdo$loadClass("java.lang.Integer"), Documentostipos.___jdo$loadClass("java.lang.Integer"), Documentostipos.___jdo$loadClass("java.lang.Integer"), Documentostipos.___jdo$loadClass("java.lang.Integer"), Documentostipos.___jdo$loadClass("java.lang.Integer"), Documentostipos.___jdo$loadClass("java.lang.Integer"), Documentostipos.___jdo$loadClass("java.util.Set"), Documentostipos.___jdo$loadClass("java.lang.Integer"), Documentostipos.___jdo$loadClass("java.lang.Integer"), Documentostipos.___jdo$loadClass("java.util.Set"), Documentostipos.___jdo$loadClass("java.lang.String"), Documentostipos.___jdo$loadClass("java.lang.Integer"), Documentostipos.___jdo$loadClass("java.lang.Integer"), Documentostipos.___jdo$loadClass("java.lang.Integer"), Documentostipos.___jdo$loadClass("org.projectocolibri.api.database.model.Entidadestipos"), Documentostipos.___jdo$loadClass("java.lang.Integer"), Documentostipos.___jdo$loadClass("java.lang.Integer"), Documentostipos.___jdo$loadClass("java.lang.Integer"), Documentostipos.___jdo$loadClass("java.lang.String"), Documentostipos.___jdo$loadClass("java.lang.Integer"), Documentostipos.___jdo$loadClass("java.lang.Integer"), Documentostipos.___jdo$loadClass("java.lang.Integer")};
    }

    private static final byte[] __jdoFieldFlagsInit() {
        return new byte[]{21, 21, 21, 21, 21, 24, 21, 21, 21, 21, 21, 5, 21, 21, 21, 21, 21, 21, 5, 21, 21, 5, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21};
    }

    protected static int __jdoGetInheritedFieldCount() {
        return 0;
    }

    protected static int jdoGetManagedFieldCount() {
        return 34;
    }

    private static Class __jdoPersistenceCapableSuperclassInit() {
        return null;
    }

    public static Class ___jdo$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object jdoSuperClone() throws CloneNotSupportedException {
        Documentostipos o = (Documentostipos)super.clone();
        o.jdoFlags = 0;
        o.jdoStateManager = null;
        return o;
    }

    private static Integer jdoGetactualizaprecoscusto(Documentostipos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 0)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 0, (Object)objPC.actualizaprecoscusto);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(0)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"actualizaprecoscusto\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.actualizaprecoscusto;
    }

    private static void jdoSetactualizaprecoscusto(Documentostipos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 0, (Object)objPC.actualizaprecoscusto, (Object)val);
        } else {
            objPC.actualizaprecoscusto = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(0);
            }
        }
    }

    private static Integer jdoGetactualizaprecosvenda(Documentostipos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 1)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 1, (Object)objPC.actualizaprecosvenda);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(1)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"actualizaprecosvenda\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.actualizaprecosvenda;
    }

    private static void jdoSetactualizaprecosvenda(Documentostipos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 1, (Object)objPC.actualizaprecosvenda, (Object)val);
        } else {
            objPC.actualizaprecosvenda = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(1);
            }
        }
    }

    private static Integer jdoGetarredondaprecoscusto(Documentostipos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 2)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 2, (Object)objPC.arredondaprecoscusto);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(2)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"arredondaprecoscusto\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.arredondaprecoscusto;
    }

    private static void jdoSetarredondaprecoscusto(Documentostipos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 2, (Object)objPC.arredondaprecoscusto, (Object)val);
        } else {
            objPC.arredondaprecoscusto = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(2);
            }
        }
    }

    private static Integer jdoGetarredondaprecosvenda(Documentostipos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 3)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 3, (Object)objPC.arredondaprecosvenda);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(3)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"arredondaprecosvenda\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.arredondaprecosvenda;
    }

    private static void jdoSetarredondaprecosvenda(Documentostipos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 3, (Object)objPC.arredondaprecosvenda, (Object)val);
        } else {
            objPC.arredondaprecosvenda = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(3);
            }
        }
    }

    private static Integer jdoGetarredondatotais(Documentostipos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 4)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 4, (Object)objPC.arredondatotais);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(4)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"arredondatotais\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.arredondatotais;
    }

    private static void jdoSetarredondatotais(Documentostipos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 4, (Object)objPC.arredondatotais, (Object)val);
        } else {
            objPC.arredondatotais = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(4);
            }
        }
    }

    private static String jdoGetcodigo(Documentostipos objPC) {
        return objPC.codigo;
    }

    private static void jdoSetcodigo(Documentostipos objPC, String val) {
        if (objPC.jdoStateManager == null) {
            objPC.codigo = val;
        } else {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 5, objPC.codigo, val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(5);
        }
    }

    private static Integer jdoGetcopias(Documentostipos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 6)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 6, (Object)objPC.copias);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(6)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"copias\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.copias;
    }

    private static void jdoSetcopias(Documentostipos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 6, (Object)objPC.copias, (Object)val);
        } else {
            objPC.copias = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(6);
            }
        }
    }

    private static Integer jdoGetcopiasemail(Documentostipos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 7)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 7, (Object)objPC.copiasemail);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(7)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"copiasemail\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.copiasemail;
    }

    private static void jdoSetcopiasemail(Documentostipos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 7, (Object)objPC.copiasemail, (Object)val);
        } else {
            objPC.copiasemail = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(7);
            }
        }
    }

    private static String jdoGetdescricao(Documentostipos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 8)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 8, objPC.descricao);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(8)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"descricao\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.descricao;
    }

    private static void jdoSetdescricao(Documentostipos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 8, objPC.descricao, val);
        } else {
            objPC.descricao = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(8);
            }
        }
    }

    private static Integer jdoGetestado(Documentostipos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 9)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 9, (Object)objPC.estado);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(9)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"estado\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.estado;
    }

    private static void jdoSetestado(Documentostipos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 9, (Object)objPC.estado, (Object)val);
        } else {
            objPC.estado = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(9);
            }
        }
    }

    private static String jdoGetimpressora(Documentostipos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 10)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 10, objPC.impressora);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(10)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"impressora\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.impressora;
    }

    private static void jdoSetimpressora(Documentostipos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 10, objPC.impressora, val);
        } else {
            objPC.impressora = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(10);
            }
        }
    }

    private static Layouts jdoGetlayout(Documentostipos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 11)) {
            return (Layouts)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 11, (Object)objPC.layout);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(11)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"layout\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.layout;
    }

    private static void jdoSetlayout(Documentostipos objPC, Layouts val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 11, (Object)objPC.layout, (Object)val);
        } else {
            objPC.layout = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(11);
            }
        }
    }

    private static Integer jdoGetmovimentaartigos(Documentostipos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 12)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 12, (Object)objPC.movimentaartigos);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(12)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"movimentaartigos\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.movimentaartigos;
    }

    private static void jdoSetmovimentaartigos(Documentostipos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 12, (Object)objPC.movimentaartigos, (Object)val);
        } else {
            objPC.movimentaartigos = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(12);
            }
        }
    }

    private static Integer jdoGetmovimentabancos(Documentostipos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 13)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 13, (Object)objPC.movimentabancos);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(13)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"movimentabancos\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.movimentabancos;
    }

    private static void jdoSetmovimentabancos(Documentostipos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 13, (Object)objPC.movimentabancos, (Object)val);
        } else {
            objPC.movimentabancos = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(13);
            }
        }
    }

    private static Integer jdoGetmovimentaentidades(Documentostipos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 14)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 14, (Object)objPC.movimentaentidades);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(14)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"movimentaentidades\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.movimentaentidades;
    }

    private static void jdoSetmovimentaentidades(Documentostipos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 14, (Object)objPC.movimentaentidades, (Object)val);
        } else {
            objPC.movimentaentidades = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(14);
            }
        }
    }

    private static Integer jdoGetmovimentaproducao(Documentostipos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 15)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 15, (Object)objPC.movimentaproducao);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(15)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"movimentaproducao\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.movimentaproducao;
    }

    private static void jdoSetmovimentaproducao(Documentostipos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 15, (Object)objPC.movimentaproducao, (Object)val);
        } else {
            objPC.movimentaproducao = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(15);
            }
        }
    }

    private static Integer jdoGetquantidadependente(Documentostipos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 16)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 16, (Object)objPC.quantidadependente);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(16)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"quantidadependente\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.quantidadependente;
    }

    private static void jdoSetquantidadependente(Documentostipos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 16, (Object)objPC.quantidadependente, (Object)val);
        } else {
            objPC.quantidadependente = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(16);
            }
        }
    }

    private static Integer jdoGetsaldoentidades(Documentostipos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 17)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 17, (Object)objPC.saldoentidades);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(17)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"saldoentidades\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.saldoentidades;
    }

    private static void jdoSetsaldoentidades(Documentostipos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 17, (Object)objPC.saldoentidades, (Object)val);
        } else {
            objPC.saldoentidades = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(17);
            }
        }
    }

    private static Set jdoGetseries(Documentostipos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 18)) {
            return (Set)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 18, objPC.series);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(18)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"series\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.series;
    }

    private static void jdoSetseries(Documentostipos objPC, Set val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 18, objPC.series, (Object)val);
        } else {
            objPC.series = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(18);
            }
        }
    }

    private static Integer jdoGetstockartigos(Documentostipos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 19)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 19, (Object)objPC.stockartigos);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(19)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"stockartigos\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.stockartigos;
    }

    private static void jdoSetstockartigos(Documentostipos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 19, (Object)objPC.stockartigos, (Object)val);
        } else {
            objPC.stockartigos = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(19);
            }
        }
    }

    private static Integer jdoGettabela(Documentostipos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 20)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 20, (Object)objPC.tabela);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(20)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"tabela\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.tabela;
    }

    private static void jdoSettabela(Documentostipos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 20, (Object)objPC.tabela, (Object)val);
        } else {
            objPC.tabela = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(20);
            }
        }
    }

    private static Set jdoGettemplate(Documentostipos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 21)) {
            return (Set)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 21, objPC.template);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(21)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"template\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.template;
    }

    private static void jdoSettemplate(Documentostipos objPC, Set val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 21, objPC.template, (Object)val);
        } else {
            objPC.template = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(21);
            }
        }
    }

    private static String jdoGettextoemail(Documentostipos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 22)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 22, objPC.textoemail);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(22)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"textoemail\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.textoemail;
    }

    private static void jdoSettextoemail(Documentostipos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 22, objPC.textoemail, val);
        } else {
            objPC.textoemail = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(22);
            }
        }
    }

    private static Integer jdoGettipocarregamento(Documentostipos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 23)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 23, (Object)objPC.tipocarregamento);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(23)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"tipocarregamento\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.tipocarregamento;
    }

    private static void jdoSettipocarregamento(Documentostipos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 23, (Object)objPC.tipocarregamento, (Object)val);
        } else {
            objPC.tipocarregamento = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(23);
            }
        }
    }

    private static Integer jdoGettipodocumento(Documentostipos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 24)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 24, (Object)objPC.tipodocumento);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(24)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"tipodocumento\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.tipodocumento;
    }

    private static void jdoSettipodocumento(Documentostipos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 24, (Object)objPC.tipodocumento, (Object)val);
        } else {
            objPC.tipodocumento = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(24);
            }
        }
    }

    private static Integer jdoGettipodocumentosaft(Documentostipos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 25)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 25, (Object)objPC.tipodocumentosaft);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(25)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"tipodocumentosaft\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.tipodocumentosaft;
    }

    private static void jdoSettipodocumentosaft(Documentostipos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 25, (Object)objPC.tipodocumentosaft, (Object)val);
        } else {
            objPC.tipodocumentosaft = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(25);
            }
        }
    }

    private static Entidadestipos jdoGettipoentidade(Documentostipos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 26)) {
            return (Entidadestipos)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 26, (Object)objPC.tipoentidade);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(26)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"tipoentidade\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.tipoentidade;
    }

    private static void jdoSettipoentidade(Documentostipos objPC, Entidadestipos val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 26, (Object)objPC.tipoentidade, (Object)val);
        } else {
            objPC.tipoentidade = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(26);
            }
        }
    }

    private static Integer jdoGettipomercado(Documentostipos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 27)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 27, (Object)objPC.tipomercado);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(27)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"tipomercado\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.tipomercado;
    }

    private static void jdoSettipomercado(Documentostipos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 27, (Object)objPC.tipomercado, (Object)val);
        } else {
            objPC.tipomercado = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(27);
            }
        }
    }

    private static Integer jdoGettiposaldo(Documentostipos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 28)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 28, (Object)objPC.tiposaldo);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(28)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"tiposaldo\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.tiposaldo;
    }

    private static void jdoSettiposaldo(Documentostipos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 28, (Object)objPC.tiposaldo, (Object)val);
        } else {
            objPC.tiposaldo = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(28);
            }
        }
    }

    private static Integer jdoGettipostock(Documentostipos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 29)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 29, (Object)objPC.tipostock);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(29)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"tipostock\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.tipostock;
    }

    private static void jdoSettipostock(Documentostipos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 29, (Object)objPC.tipostock, (Object)val);
        } else {
            objPC.tipostock = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(29);
            }
        }
    }

    private static String jdoGettitulo(Documentostipos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 30)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 30, objPC.titulo);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(30)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"titulo\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.titulo;
    }

    private static void jdoSettitulo(Documentostipos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 30, objPC.titulo, val);
        } else {
            objPC.titulo = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(30);
            }
        }
    }

    private static Integer jdoGetvalorpendente(Documentostipos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 31)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 31, (Object)objPC.valorpendente);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(31)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"valorpendente\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.valorpendente;
    }

    private static void jdoSetvalorpendente(Documentostipos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 31, (Object)objPC.valorpendente, (Object)val);
        } else {
            objPC.valorpendente = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(31);
            }
        }
    }

    private static Integer jdoGetvias(Documentostipos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 32)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 32, (Object)objPC.vias);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(32)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"vias\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.vias;
    }

    private static void jdoSetvias(Documentostipos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 32, (Object)objPC.vias, (Object)val);
        } else {
            objPC.vias = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(32);
            }
        }
    }

    private static Integer jdoGetviasemail(Documentostipos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 33)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 33, (Object)objPC.viasemail);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(33)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"viasemail\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.viasemail;
    }

    private static void jdoSetviasemail(Documentostipos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 33, (Object)objPC.viasemail, (Object)val);
        } else {
            objPC.viasemail = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(33);
            }
        }
    }

    public static enum CIUS_DOCUMENT_GROUP {
        UNKNOWN(new SAFT_DOCUMENT_TYPE[0]),
        INVOICE(SAFT_DOCUMENT_TYPE.FACTURA, SAFT_DOCUMENT_TYPE.FACTURA_SIMPLIFICADA, SAFT_DOCUMENT_TYPE.FACTURA_RECIBO, SAFT_DOCUMENT_TYPE.VENDA_DINHEIRO, SAFT_DOCUMENT_TYPE.TALAO_VENDA),
        CREDIT(SAFT_DOCUMENT_TYPE.NOTA_CREDITO, SAFT_DOCUMENT_TYPE.TALAO_DEVOLUCAO, SAFT_DOCUMENT_TYPE.ALIENACAO_ACTIVOS, SAFT_DOCUMENT_TYPE.DEVOLUCAO_ACTIVOS),
        DEBIT(SAFT_DOCUMENT_TYPE.NOTA_DEBITO);

        public final Collection<SAFT_DOCUMENT_TYPE> types;

        private CIUS_DOCUMENT_GROUP(SAFT_DOCUMENT_TYPE ... types) {
            this.types = Arrays.asList(types);
        }

        public static CIUS_DOCUMENT_GROUP get(int tipodocumentosaft) {
            SAFT_DOCUMENT_TYPE type = SAFT_DOCUMENT_TYPE.get(tipodocumentosaft);
            CIUS_DOCUMENT_GROUP[] cIUS_DOCUMENT_GROUPArray = CIUS_DOCUMENT_GROUP.values();
            int n = cIUS_DOCUMENT_GROUPArray.length;
            int n2 = 0;
            while (n2 < n) {
                CIUS_DOCUMENT_GROUP value = cIUS_DOCUMENT_GROUPArray[n2];
                if (value.types.contains((Object)type)) {
                    return value;
                }
                ++n2;
            }
            return UNKNOWN;
        }
    }

    public static enum RECORDS {
        artigos_entrada_armazem("AEN", 0, 0, 0, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, null, Layouts.RECORDS.artigosdocumentoslinhas_entrada_armazem, Templates.RECORDS.artigosdocumentos_movimento_armazem),
        artigos_saida_armazem("ASA", 0, 0, 0, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, null, Layouts.RECORDS.artigosdocumentoslinhas_entrada_armazem, Templates.RECORDS.artigosdocumentos_movimento_armazem),
        artigos_transferencia_armazens("ATR", 0, 0, 0, 2, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, null, Layouts.RECORDS.artigosdocumentoslinhas_transferencia_armazens, Templates.RECORDS.artigosdocumentos_movimento_armazem),
        clientes_factura("CFA", 1, 1, 1, 3, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, Entidadestipos.RECORDS.cliente, Layouts.RECORDS.entidadesdocumentoslinhas_factura, Templates.RECORDS.entidadesdocumentos_factura),
        clientes_factura_exportacao("CFE", 1, 1, 1, 3, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 1, 1, Entidadestipos.RECORDS.cliente, Layouts.RECORDS.entidadesdocumentoslinhas_factura, Templates.RECORDS.entidadesdocumentos_factura_exportacao_PT),
        clientes_factura_recibo("CFR", 1, 3, 3, 3, 1, 0, 0, 0, 1, 0, 0, 2, 1, 0, 0, 0, 0, 1, 0, Entidadestipos.RECORDS.cliente, Layouts.RECORDS.entidadesdocumentoslinhas_factura_iva, Templates.RECORDS.entidadesdocumentos_factura),
        clientes_nota_debito("CND", 1, 4, 4, 3, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, Entidadestipos.RECORDS.cliente, Layouts.RECORDS.entidadesdocumentoslinhas_factura, Templates.RECORDS.entidadesdocumentos_factura),
        clientes_nota_credito("CNC", 1, 4, 5, 3, 2, 0, 0, 0, 2, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, Entidadestipos.RECORDS.cliente, Layouts.RECORDS.entidadesdocumentoslinhas_factura, Templates.RECORDS.entidadesdocumentos_factura),
        clientes_recibo("CRE", 1, 2, 25, 2, 0, 0, 0, 0, 2, 0, 0, 2, 1, 0, 0, 0, 0, 0, 0, Entidadestipos.RECORDS.cliente, Layouts.RECORDS.entidadesdocumentoslinhas_recibo, Templates.RECORDS.entidadesdocumentos_recibo),
        clientes_recibo_caixa("CRC", 1, 2, 26, 2, 0, 0, 0, 0, 2, 0, 0, 2, 1, 0, 0, 0, 0, 0, 0, Entidadestipos.RECORDS.cliente, Layouts.RECORDS.entidadesdocumentoslinhas_recibo, Templates.RECORDS.entidadesdocumentos_recibo),
        clientes_encomenda("CEN", 1, 1, 20, 3, 1, 0, 2, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 1, 0, Entidadestipos.RECORDS.cliente, Layouts.RECORDS.entidadesdocumentoslinhas_factura, Templates.RECORDS.entidadesdocumentos_factura),
        clientes_guia_remessa("CGR", 1, 1, 11, 3, 1, 0, 1, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 1, 0, Entidadestipos.RECORDS.cliente, Layouts.RECORDS.entidadesdocumentoslinhas_factura, Templates.RECORDS.entidadesdocumentos_factura),
        clientes_guia_devolucao("CGD", 1, 1, 15, 3, 3, 0, 1, 0, 3, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, Entidadestipos.RECORDS.cliente, Layouts.RECORDS.entidadesdocumentoslinhas_factura, Templates.RECORDS.entidadesdocumentos_factura),
        clientes_guia_transporte("CGT", 1, 5, 12, 3, 1, 0, 1, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 1, 0, Entidadestipos.RECORDS.cliente, Layouts.RECORDS.entidadesdocumentoslinhas_factura, Templates.RECORDS.entidadesdocumentos_guia_transporte),
        clientes_lancamento_debito("CLD", 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, Entidadestipos.RECORDS.cliente, Layouts.RECORDS.entidadesdocumentoslinhas_lancamento, Templates.RECORDS.entidadesdocumentos_lancamento),
        clientes_lancamento_credito("CLC", 1, 0, 0, 1, 0, 0, 0, 0, 2, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, Entidadestipos.RECORDS.cliente, Layouts.RECORDS.entidadesdocumentoslinhas_lancamento, Templates.RECORDS.entidadesdocumentos_lancamento),
        clientes_fecho_documentos("CXD", 1, 5, 0, 0, 3, 0, 1, 0, 3, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, Entidadestipos.RECORDS.cliente, Layouts.RECORDS.entidadesdocumentoslinhas_factura, Templates.RECORDS.entidadesdocumentos_guia_transporte),
        fornecedores_factura("FFA", 1, 1, 0, 1, 2, 0, 0, 0, 2, 0, 1, 0, 1, 3, 0, 0, 0, 1, 0, Entidadestipos.RECORDS.fornecedor, Layouts.RECORDS.entidadesdocumentoslinhas_factura, Templates.RECORDS.entidadesdocumentos_factura),
        fornecedores_factura_recibo("FFR", 1, 3, 0, 1, 2, 0, 0, 0, 2, 0, 0, 1, 1, 3, 0, 0, 0, 1, 0, Entidadestipos.RECORDS.fornecedor, Layouts.RECORDS.entidadesdocumentoslinhas_factura_iva, Templates.RECORDS.entidadesdocumentos_factura),
        fornecedores_nota_debito("FND", 1, 4, 0, 3, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, Entidadestipos.RECORDS.fornecedor, Layouts.RECORDS.entidadesdocumentoslinhas_factura, Templates.RECORDS.entidadesdocumentos_factura),
        fornecedores_nota_credito("FNC", 1, 4, 0, 3, 2, 0, 0, 0, 2, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, Entidadestipos.RECORDS.fornecedor, Layouts.RECORDS.entidadesdocumentoslinhas_factura, Templates.RECORDS.entidadesdocumentos_factura),
        fornecedores_pagamento("FRE", 1, 2, 0, 2, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, Entidadestipos.RECORDS.fornecedor, Layouts.RECORDS.entidadesdocumentoslinhas_recibo, Templates.RECORDS.entidadesdocumentos_recibo),
        fornecedores_encomenda("FEN", 1, 1, 0, 3, 2, 0, 2, 1, 2, 1, 1, 0, 1, 0, 0, 0, 0, 1, 0, Entidadestipos.RECORDS.fornecedor, Layouts.RECORDS.entidadesdocumentoslinhas_factura, Templates.RECORDS.entidadesdocumentos_factura),
        fornecedores_guia_remessa("FGR", 1, 1, 0, 1, 2, 0, 1, 1, 2, 1, 1, 0, 1, 0, 0, 0, 0, 1, 0, Entidadestipos.RECORDS.fornecedor, Layouts.RECORDS.entidadesdocumentoslinhas_factura, Templates.RECORDS.entidadesdocumentos_factura),
        fornecedores_guia_transporte("FGT", 1, 5, 12, 3, 1, 0, 1, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 1, 0, Entidadestipos.RECORDS.fornecedor, Layouts.RECORDS.entidadesdocumentoslinhas_factura, Templates.RECORDS.entidadesdocumentos_guia_transporte),
        fornecedores_lancamento_debito("FLD", 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, Entidadestipos.RECORDS.fornecedor, Layouts.RECORDS.entidadesdocumentoslinhas_lancamento, Templates.RECORDS.entidadesdocumentos_lancamento),
        fornecedores_lancamento_credito("FLC", 1, 0, 0, 1, 0, 0, 0, 0, 2, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, Entidadestipos.RECORDS.fornecedor, Layouts.RECORDS.entidadesdocumentoslinhas_lancamento, Templates.RECORDS.entidadesdocumentos_lancamento),
        fornecedores_fecho_documentos("FXD", 1, 5, 0, 0, 3, 0, 1, 0, 3, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, Entidadestipos.RECORDS.fornecedor, Layouts.RECORDS.entidadesdocumentoslinhas_factura, Templates.RECORDS.entidadesdocumentos_guia_transporte);

        public final String codigo;
        public final int tabela;
        public final int tipodocumento;
        public final int tipodocumentosaft;
        public final int copias;
        public final int movimentaartigos;
        public final int movimentaproducao;
        public final int tipostock;
        public final int quantidadependente;
        public final int movimentaentidades;
        public final int tiposaldo;
        public final int valorpendente;
        public final int movimentabancos;
        public final int tipocarregamento;
        public final int actualizaprecoscusto;
        public final int arredondaprecoscusto;
        public final int actualizaprecosvenda;
        public final int arredondaprecosvenda;
        public final int arredondatotais;
        @Deprecated
        public final int tipomercado;
        public final Entidadestipos.RECORDS tipoentidade;
        public final Layouts.RECORDS layout;
        public final Templates.RECORDS template;

        public static RECORDS get(String codigo) {
            RECORDS[] rECORDSArray = RECORDS.values();
            int n = rECORDSArray.length;
            int n2 = 0;
            while (n2 < n) {
                RECORDS record = rECORDSArray[n2];
                if (codigo.equals(record.codigo)) {
                    return record;
                }
                ++n2;
            }
            return null;
        }

        public static boolean contains(String codigo) {
            return RECORDS.get(codigo) != null;
        }

        private RECORDS(String codigo, int tabela, int tipodocumento, int tipodocumentosaft, int copias, int movimentaartigos, int movimentaproducao, int tipostock, int quantidadependente, int movimentaentidades, int tiposaldo, int valorpendente, int movimentabancos, int tipocarregamento, int actualizaprecoscusto, int arredondaprecoscusto, int actualizaprecosvenda, int arredondaprecosvenda, int arredondatotais, int tipomercado, Entidadestipos.RECORDS tipoentidade, Layouts.RECORDS layout, Templates.RECORDS template) {
            this.codigo = codigo;
            this.tabela = tabela;
            this.tipodocumento = tipodocumento;
            this.tipodocumentosaft = tipodocumentosaft;
            this.copias = copias;
            this.movimentaartigos = movimentaartigos;
            this.movimentaproducao = movimentaproducao;
            this.tipostock = tipostock;
            this.quantidadependente = quantidadependente;
            this.movimentaentidades = movimentaentidades;
            this.tiposaldo = tiposaldo;
            this.valorpendente = valorpendente;
            this.movimentabancos = movimentabancos;
            this.tipocarregamento = tipocarregamento;
            this.actualizaprecoscusto = actualizaprecoscusto;
            this.arredondaprecoscusto = arredondaprecoscusto;
            this.actualizaprecosvenda = actualizaprecosvenda;
            this.arredondaprecosvenda = arredondaprecosvenda;
            this.arredondatotais = arredondatotais;
            this.tipomercado = tipomercado;
            this.tipoentidade = tipoentidade;
            this.layout = layout;
            this.template = template;
        }

        public Documentostipos create(DatabaseManager manager, String descricao, String titulo) {
            Documentostipos tipodocumento = new Documentostipos(manager, this.codigo, descricao, this.tabela, this.tipodocumento, this.tipodocumentosaft);
            tipodocumento.setTitulo(titulo);
            tipodocumento.setEstado(this.tipodocumentosaft == 26 ? 0 : 1);
            tipodocumento.setTipoentidade(this.tipoentidade == null ? null : manager.loadEntidadestipos(this.tipoentidade.codigo));
            tipodocumento.setLayout(manager.loadLayouts(this.layout.codigo));
            tipodocumento.setTemplate(this.template);
            tipodocumento.setCopias(this.copias);
            tipodocumento.setMovimentaartigos(this.movimentaartigos);
            tipodocumento.setMovimentaproducao(this.movimentaproducao);
            tipodocumento.setTipostock(this.tipostock);
            tipodocumento.setQuantidadependente(this.quantidadependente);
            tipodocumento.setMovimentaentidades(this.movimentaentidades);
            tipodocumento.setTiposaldo(this.tiposaldo);
            tipodocumento.setValorpendente(this.valorpendente);
            tipodocumento.setMovimentabancos(this.movimentabancos);
            tipodocumento.setTipocarregamento(this.tipocarregamento);
            tipodocumento.setTipomercado(this.tipomercado);
            tipodocumento.setActualizaprecoscusto(this.actualizaprecoscusto);
            tipodocumento.setActualizaprecosvenda(this.actualizaprecosvenda);
            tipodocumento.setArredondaprecoscusto(this.arredondaprecoscusto);
            tipodocumento.setArredondaprecosvenda(this.arredondaprecosvenda);
            tipodocumento.setArredondatotais(this.arredondatotais);
            return tipodocumento;
        }

        public static Documentostipos create(DatabaseManager manager, String codigo, String descricao, String titulo) {
            RECORDS record = RECORDS.get(codigo);
            if (record == null) {
                throw new IllegalArgumentException(codigo);
            }
            return record.create(manager, descricao, titulo);
        }
    }

    public static enum SAFT_DOCUMENT_GROUP {
        UNKNOWN(new SAFT_DOCUMENT_TYPE[0]),
        INVOICE(SAFT_DOCUMENT_TYPE.FACTURA, SAFT_DOCUMENT_TYPE.FACTURA_SIMPLIFICADA, SAFT_DOCUMENT_TYPE.FACTURA_RECIBO, SAFT_DOCUMENT_TYPE.NOTA_DEBITO, SAFT_DOCUMENT_TYPE.NOTA_CREDITO, SAFT_DOCUMENT_TYPE.VENDA_DINHEIRO, SAFT_DOCUMENT_TYPE.TALAO_VENDA, SAFT_DOCUMENT_TYPE.TALAO_DEVOLUCAO, SAFT_DOCUMENT_TYPE.ALIENACAO_ACTIVOS, SAFT_DOCUMENT_TYPE.DEVOLUCAO_ACTIVOS),
        MOVEMENT(SAFT_DOCUMENT_TYPE.GUIA_REMESSA, SAFT_DOCUMENT_TYPE.GUIA_TRANSPORTE, SAFT_DOCUMENT_TYPE.GUIA_ATIVOS_PROPRIOS, SAFT_DOCUMENT_TYPE.GUIA_CONSIGNACAO, SAFT_DOCUMENT_TYPE.GUIA_DEVOLUCAO_CLIENTE),
        WORKING(SAFT_DOCUMENT_TYPE.CONSULTA_MESA, SAFT_DOCUMENT_TYPE.CREDITO_CONSIGNACAO, SAFT_DOCUMENT_TYPE.FACTURA_CONSIGNACAO, SAFT_DOCUMENT_TYPE.FOLHA_OBRA, SAFT_DOCUMENT_TYPE.NOTA_ENCOMENDA, SAFT_DOCUMENT_TYPE.ORCAMENTO, SAFT_DOCUMENT_TYPE.PROFORMA, SAFT_DOCUMENT_TYPE.DOCUMENTO_CONFERENCIA, SAFT_DOCUMENT_TYPE.CONFERENCIA_ENTREGA),
        PAYMENT(SAFT_DOCUMENT_TYPE.RECIBO_NORMAL, SAFT_DOCUMENT_TYPE.RECIBO_CAIXA);

        public final Collection<SAFT_DOCUMENT_TYPE> types;

        private SAFT_DOCUMENT_GROUP(SAFT_DOCUMENT_TYPE ... types) {
            this.types = Arrays.asList(types);
        }

        public static SAFT_DOCUMENT_GROUP get(int tipodocumentosaft) {
            SAFT_DOCUMENT_TYPE type = SAFT_DOCUMENT_TYPE.get(tipodocumentosaft);
            SAFT_DOCUMENT_GROUP[] sAFT_DOCUMENT_GROUPArray = SAFT_DOCUMENT_GROUP.values();
            int n = sAFT_DOCUMENT_GROUPArray.length;
            int n2 = 0;
            while (n2 < n) {
                SAFT_DOCUMENT_GROUP value = sAFT_DOCUMENT_GROUPArray[n2];
                if (value.types.contains((Object)type)) {
                    return value;
                }
                ++n2;
            }
            return UNKNOWN;
        }
    }

    public static enum SAFT_DOCUMENT_TYPE {
        INTERNO(0, new Label(Colibri.LANGUAGE_BUNDLE.bundle, "Interno", "Internal")),
        FACTURA(1, new Label(Colibri.LANGUAGE_BUNDLE.bundle, "Factura", "Invoice")),
        FACTURA_SIMPLIFICADA(2, new Label(Colibri.LANGUAGE_BUNDLE.bundle, "Factura Simplificada", "Simplified Invoice")),
        FACTURA_RECIBO(3, new Label(Colibri.LANGUAGE_BUNDLE.bundle, "Factura-Recibo", "Receipt-Invoice")),
        NOTA_DEBITO(4, new Label(Colibri.LANGUAGE_BUNDLE.bundle, "Nota de D\u00e9bito", "Debit Note")),
        NOTA_CREDITO(5, new Label(Colibri.LANGUAGE_BUNDLE.bundle, "Nota de Cr\u00e9dito", "Credit Note")),
        VENDA_DINHEIRO(6, TimeDateUtils.getCalendar((int)2012, (int)11, (int)31), new Label(Colibri.LANGUAGE_BUNDLE.bundle, "Venda a Dinheiro", "Cash Ticket")),
        TALAO_VENDA(7, TimeDateUtils.getCalendar((int)2012, (int)11, (int)31), new Label(Colibri.LANGUAGE_BUNDLE.bundle, "Tal\u00e3o de Venda", "Sale Ticket")),
        TALAO_DEVOLUCAO(8, TimeDateUtils.getCalendar((int)2012, (int)11, (int)31), new Label(Colibri.LANGUAGE_BUNDLE.bundle, "Tal\u00e3o de Devolu\u00e7\u00e3o", "Return Ticket")),
        ALIENACAO_ACTIVOS(9, TimeDateUtils.getCalendar((int)2012, (int)11, (int)31), new Label(Colibri.LANGUAGE_BUNDLE.bundle, "Aliena\u00e7\u00e3o de Activos", "Asset Sale")),
        DEVOLUCAO_ACTIVOS(10, TimeDateUtils.getCalendar((int)2012, (int)11, (int)31), new Label(Colibri.LANGUAGE_BUNDLE.bundle, "Devolu\u00e7\u00e3o de Activos", "Asset Return")),
        GUIA_REMESSA(11, new Label(Colibri.LANGUAGE_BUNDLE.bundle, "Guia de Remessa", "Delivery Guide")),
        GUIA_TRANSPORTE(12, new Label(Colibri.LANGUAGE_BUNDLE.bundle, "Guia de Transporte", "Transport Guide")),
        GUIA_ATIVOS_PROPRIOS(13, new Label(Colibri.LANGUAGE_BUNDLE.bundle, "Guia de Movimenta\u00e7\u00e3o (ativos fixos)", "Moving Guide (fixed assets)")),
        GUIA_CONSIGNACAO(14, new Label(Colibri.LANGUAGE_BUNDLE.bundle, "Guia de Consigna\u00e7\u00e3o", "Consignment Guide")),
        GUIA_DEVOLUCAO_CLIENTE(15, new Label(Colibri.LANGUAGE_BUNDLE.bundle, "Guia de Devolu\u00e7\u00e3o (pelo cliente)", "Return Guide (by customer)")),
        CONSULTA_MESA(16, new Label(Colibri.LANGUAGE_BUNDLE.bundle, "Consulta de Mesa", "Table Consultation")),
        CREDITO_CONSIGNACAO(17, new Label(Colibri.LANGUAGE_BUNDLE.bundle, "Credito de Consigna\u00e7\u00e3o", "Consignment Credit")),
        FACTURA_CONSIGNACAO(18, new Label(Colibri.LANGUAGE_BUNDLE.bundle, "Fatura de Consigna\u00e7\u00e3o (art.38\u00ba do CIVA)", "Consignment Invoice (art.38 of CIVA)")),
        FOLHA_OBRA(19, new Label(Colibri.LANGUAGE_BUNDLE.bundle, "Folha de Obra", "Worksheet")),
        NOTA_ENCOMENDA(20, new Label(Colibri.LANGUAGE_BUNDLE.bundle, "Nota de Encomenda", "Order Note")),
        ORCAMENTO(21, new Label(Colibri.LANGUAGE_BUNDLE.bundle, "Or\u00e7amento", "Quote")),
        PROFORMA(22, new Label(Colibri.LANGUAGE_BUNDLE.bundle, "Pr\u00f3-forma", "Formality")),
        DOCUMENTO_CONFERENCIA(23, new Label(Colibri.LANGUAGE_BUNDLE.bundle, "Documento de Confer\u00eancia", "Conference Document")),
        CONFERENCIA_ENTREGA(24, TimeDateUtils.getCalendar((int)2017, (int)5, (int)30), new Label(Colibri.LANGUAGE_BUNDLE.bundle, "Documento de Confer\u00eancia", "Conference Document")),
        RECIBO_NORMAL(25, new Label(Colibri.LANGUAGE_BUNDLE.bundle, "Recibo (Regime Geral)", "Receipt (Normal Regimen)")),
        RECIBO_CAIXA(26, new Label(Colibri.LANGUAGE_BUNDLE.bundle, "Recibo (Regime IVA Caixa)", "Receipt (VAT Regimen)"));

        private static final Collection<SAFT_DOCUMENT_TYPE> DEPRECATED;
        public static final String[] NAMES;
        private final int tipodocumentosaft;
        private final Calendar before;
        private final Label label;

        static {
            DEPRECATED = Arrays.asList(VENDA_DINHEIRO, TALAO_VENDA, TALAO_DEVOLUCAO, ALIENACAO_ACTIVOS, DEVOLUCAO_ACTIVOS, CONFERENCIA_ENTREGA);
            NAMES = StringList.valueOf((Object[])SAFT_DOCUMENT_TYPE.values()).toArray();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.label.toString());
            if (this.before != null) {
                sb.append(" [");
                sb.append(new Label(Colibri.LANGUAGE_BUNDLE.bundle, "at\u00e9", "before").toString());
                sb.append(" ");
                sb.append(TimeDateUtils.getDateFormatted((Calendar)this.before, (String)DEFAULTS.DATE.pattern));
                sb.append("]");
            }
            return sb.toString();
        }

        private SAFT_DOCUMENT_TYPE(int tipodocumentosaft, Label label) {
            this(tipodocumentosaft, null, label);
        }

        private SAFT_DOCUMENT_TYPE(int tipodocumentosaft, Calendar before, Label label) {
            this.tipodocumentosaft = tipodocumentosaft;
            this.before = before;
            this.label = label;
        }

        public static SAFT_DOCUMENT_TYPE get(int tipodocumentosaft) {
            SAFT_DOCUMENT_TYPE[] sAFT_DOCUMENT_TYPEArray = SAFT_DOCUMENT_TYPE.values();
            int n = sAFT_DOCUMENT_TYPEArray.length;
            int n2 = 0;
            while (n2 < n) {
                SAFT_DOCUMENT_TYPE value = sAFT_DOCUMENT_TYPEArray[n2];
                if (value.tipodocumentosaft == tipodocumentosaft) {
                    return value;
                }
                ++n2;
            }
            return INTERNO;
        }

        public static boolean isDeprecated(int tipodocumentosaft) {
            SAFT_DOCUMENT_TYPE type = SAFT_DOCUMENT_TYPE.get(tipodocumentosaft);
            return DEPRECATED.contains((Object)type);
        }
    }

    public static enum SAFT_MOVEMENT_GROUP {
        NONE(new SAFT_DOCUMENT_TYPE[0]),
        DEBIT(SAFT_DOCUMENT_TYPE.NOTA_CREDITO, SAFT_DOCUMENT_TYPE.TALAO_DEVOLUCAO, SAFT_DOCUMENT_TYPE.DEVOLUCAO_ACTIVOS, SAFT_DOCUMENT_TYPE.GUIA_DEVOLUCAO_CLIENTE, SAFT_DOCUMENT_TYPE.CREDITO_CONSIGNACAO),
        CREDIT(SAFT_DOCUMENT_TYPE.FACTURA, SAFT_DOCUMENT_TYPE.FACTURA_SIMPLIFICADA, SAFT_DOCUMENT_TYPE.FACTURA_RECIBO, SAFT_DOCUMENT_TYPE.NOTA_DEBITO, SAFT_DOCUMENT_TYPE.VENDA_DINHEIRO, SAFT_DOCUMENT_TYPE.TALAO_VENDA, SAFT_DOCUMENT_TYPE.ALIENACAO_ACTIVOS, SAFT_DOCUMENT_TYPE.GUIA_REMESSA, SAFT_DOCUMENT_TYPE.GUIA_TRANSPORTE, SAFT_DOCUMENT_TYPE.GUIA_ATIVOS_PROPRIOS, SAFT_DOCUMENT_TYPE.GUIA_CONSIGNACAO, SAFT_DOCUMENT_TYPE.CONSULTA_MESA, SAFT_DOCUMENT_TYPE.FACTURA_CONSIGNACAO, SAFT_DOCUMENT_TYPE.FOLHA_OBRA, SAFT_DOCUMENT_TYPE.NOTA_ENCOMENDA, SAFT_DOCUMENT_TYPE.ORCAMENTO, SAFT_DOCUMENT_TYPE.PROFORMA, SAFT_DOCUMENT_TYPE.DOCUMENTO_CONFERENCIA, SAFT_DOCUMENT_TYPE.CONFERENCIA_ENTREGA);

        public final Collection<SAFT_DOCUMENT_TYPE> types;

        private SAFT_MOVEMENT_GROUP(SAFT_DOCUMENT_TYPE ... types) {
            this.types = Arrays.asList(types);
        }

        private static SAFT_MOVEMENT_GROUP get(int tipodocumentosaft) {
            SAFT_DOCUMENT_TYPE type = SAFT_DOCUMENT_TYPE.get(tipodocumentosaft);
            SAFT_MOVEMENT_GROUP[] sAFT_MOVEMENT_GROUPArray = SAFT_MOVEMENT_GROUP.values();
            int n = sAFT_MOVEMENT_GROUPArray.length;
            int n2 = 0;
            while (n2 < n) {
                SAFT_MOVEMENT_GROUP value = sAFT_MOVEMENT_GROUPArray[n2];
                if (value.types.contains((Object)type)) {
                    return value;
                }
                ++n2;
            }
            return NONE;
        }
    }

    public static enum SERVICE_DOCUMENT_GROUP {
        UNSUPPORTED(COMMUNICATION_TYPE.NONE, new SAFT_DOCUMENT_TYPE[0]),
        INVOICE(COMMUNICATION_TYPE.DEFERRED, SAFT_DOCUMENT_TYPE.FACTURA, SAFT_DOCUMENT_TYPE.FACTURA_SIMPLIFICADA, SAFT_DOCUMENT_TYPE.FACTURA_RECIBO, SAFT_DOCUMENT_TYPE.NOTA_DEBITO, SAFT_DOCUMENT_TYPE.NOTA_CREDITO),
        MOVEMENT(COMMUNICATION_TYPE.REALTIME, SAFT_DOCUMENT_TYPE.GUIA_REMESSA, SAFT_DOCUMENT_TYPE.GUIA_TRANSPORTE, SAFT_DOCUMENT_TYPE.GUIA_ATIVOS_PROPRIOS, SAFT_DOCUMENT_TYPE.GUIA_CONSIGNACAO, SAFT_DOCUMENT_TYPE.GUIA_DEVOLUCAO_CLIENTE);

        public final COMMUNICATION_TYPE communication;
        public final Collection<SAFT_DOCUMENT_TYPE> types;

        private SERVICE_DOCUMENT_GROUP(COMMUNICATION_TYPE communication, SAFT_DOCUMENT_TYPE ... types) {
            this.communication = communication;
            this.types = Arrays.asList(types);
        }

        private static SERVICE_DOCUMENT_GROUP get(int tipodocumentosaft) {
            SAFT_DOCUMENT_TYPE type = SAFT_DOCUMENT_TYPE.get(tipodocumentosaft);
            SERVICE_DOCUMENT_GROUP[] sERVICE_DOCUMENT_GROUPArray = SERVICE_DOCUMENT_GROUP.values();
            int n = sERVICE_DOCUMENT_GROUPArray.length;
            int n2 = 0;
            while (n2 < n) {
                SERVICE_DOCUMENT_GROUP value = sERVICE_DOCUMENT_GROUPArray[n2];
                if (value.types.contains((Object)type)) {
                    return value;
                }
                ++n2;
            }
            return UNSUPPORTED;
        }

        public static enum COMMUNICATION_TYPE {
            NONE,
            REALTIME,
            DEFERRED;

        }
    }
}

