/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.model;

import java.math.BigDecimal;
import java.util.BitSet;
import javax.jdo.JDODetachedFieldAccessException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.PersistenceManager;
import javax.jdo.identity.StringIdentity;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;
import org.dma.java.util.MessageLine;
import org.dma.java.util.MessageList;
import org.dma.java.util.StringUtils;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.IDatabaseModel;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.AbstractModel;
import org.projectocolibri.api.database.model.Isencoesiva;
import org.projectocolibri.api.language.LABELS;

@javax.jdo.annotations.PersistenceCapable
public class Codigosiva
extends AbstractModel
implements Detachable,
PersistenceCapable {
    public static final String CODIGO_TAXA_ISENTA = "01";
    public static final String CODIGO_TAXA_REDUZIDA = "06";
    public static final String CODIGO_TAXA_NORMAL = "23";
    public static final String CODIGO_NAO_SUJEITO = "NS";
    public static final int tipotaxa_normal = 0;
    public static final int tipotaxa_reduzida = 1;
    public static final int tipotaxa_intermedia = 2;
    public static final int tipotaxa_isenta = 3;
    public static final int tipotaxa_outras = 4;
    public static final int tipotaxa_naosujeito = 5;
    public static final int espacofiscal_continente = 0;
    public static final int espacofiscal_madeira = 1;
    public static final int espacofiscal_acores = 2;
    public static final int espacofiscal_outros = 3;
    private String codigo;
    private String descricao;
    private Integer tipotaxa;
    private Integer espacofiscal;
    private BigDecimal taxa;
    protected transient StateManager jdoStateManager;
    protected transient byte jdoFlags;
    protected Object[] jdoDetachedState;
    private static final byte[] jdoFieldFlags;
    private static final Class jdoPersistenceCapableSuperclass;
    private static final Class[] jdoFieldTypes;
    private static final String[] jdoFieldNames;
    private static final int jdoInheritedFieldCount;

    private Codigosiva() {
        super(TABLES.codigosiva);
    }

    private Codigosiva(DatabaseManager manager) {
        super(TABLES.codigosiva, manager);
    }

    public Codigosiva(DatabaseManager manager, String codigo) {
        this(manager, codigo, "", 4, 0, BigDecimal.ZERO);
    }

    public Codigosiva(DatabaseManager manager, String codigo, String descricao, int tipotaxa, int espacofiscal, BigDecimal taxa) {
        this(manager);
        this.codigo = codigo;
        this.descricao = descricao;
        this.tipotaxa = tipotaxa;
        this.espacofiscal = espacofiscal;
        this.taxa = taxa;
    }

    @Override
    public Codigosiva cloneCopy() {
        Codigosiva clone = new Codigosiva(this.manager);
        Codigosiva.jdoSetcodigo(clone, Codigosiva.jdoGetcodigo(this));
        Codigosiva.jdoSetdescricao(clone, Codigosiva.jdoGetdescricao(this));
        Codigosiva.jdoSettipotaxa(clone, Codigosiva.jdoGettipotaxa(this));
        Codigosiva.jdoSetespacofiscal(clone, Codigosiva.jdoGetespacofiscal(this));
        Codigosiva.jdoSettaxa(clone, Codigosiva.jdoGettaxa(this));
        return clone;
    }

    @Override
    public MessageList validate(IDatabaseModel.ACTION action) {
        MessageList error = super.validate(action);
        switch (action) {
            case DELETE: {
                break;
            }
            case STORE: {
                if (this.isValid()) break;
                error.add((Object)new MessageLine((Object)LABELS.codigosiva_taxa));
            }
        }
        return error;
    }

    public boolean isValid() {
        switch (Codigosiva.jdoGettipotaxa(this)) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                return this.hasTaxa();
            }
            case 3: 
            case 5: {
                return !this.hasTaxa();
            }
        }
        return true;
    }

    public boolean isValid(Isencoesiva isencaoiva) {
        if (isencaoiva != null) {
            switch (Codigosiva.jdoGettipotaxa(this)) {
                case 0: 
                case 1: 
                case 2: 
                case 4: {
                    return isencaoiva.isMotivo(Isencoesiva.MOTIVOS_AT.M00);
                }
                case 3: {
                    return !isencaoiva.isMotivo(Isencoesiva.MOTIVOS_AT.M00) && !isencaoiva.isMotivo(Isencoesiva.MOTIVOS_AT.M99);
                }
                case 5: {
                    return isencaoiva.isMotivo(Isencoesiva.MOTIVOS_AT.M99);
                }
            }
        }
        return Colibri.MARKET_TYPE == Colibri.MARKETS.EXTERNAL;
    }

    @Override
    public String getKey() {
        return Codigosiva.jdoGetcodigo(this);
    }

    public String getCodigo() {
        return Codigosiva.jdoGetcodigo(this);
    }

    public String getCodigoToText() {
        return Codigosiva.jdoGetcodigo(this) == null ? "" : Codigosiva.jdoGetcodigo(this).toString();
    }

    public void setCodigo(String codigo) {
        String string = Codigosiva.jdoGetcodigo(this);
        String string2 = codigo;
        Codigosiva.jdoSetcodigo(this, string2);
        this.firePropertyChange(FIELDS.codigosiva_codigo, (Object)string, (Object)string2);
    }

    public String generateCodigo() {
        String codigo = this.isTipotaxa(5) ? CODIGO_NAO_SUJEITO : StringUtils.padLeft((String)StringUtils.left((String)Codigosiva.jdoGettaxa(this).toBigInteger().toString(), (int)FIELDS.codigosiva_taxa.format.getSize().size), (int)FIELDS.codigosiva_taxa.format.getSize().size, (char)'0');
        switch (Codigosiva.jdoGetespacofiscal(this)) {
            case 0: {
                break;
            }
            case 1: {
                return String.valueOf(codigo) + "M";
            }
            case 2: {
                return String.valueOf(codigo) + "A";
            }
            case 3: {
                return String.valueOf(codigo) + "O";
            }
        }
        return codigo;
    }

    public String getDescricao() {
        return Codigosiva.jdoGetdescricao(this);
    }

    public String getDescricaoToText() {
        return Codigosiva.jdoGetdescricao(this) == null ? "" : Codigosiva.jdoGetdescricao(this).toString();
    }

    public void setDescricao(String descricao) {
        String string = Codigosiva.jdoGetdescricao(this);
        String string2 = descricao;
        Codigosiva.jdoSetdescricao(this, string2);
        this.firePropertyChange(FIELDS.codigosiva_descricao, (Object)string, (Object)string2);
    }

    public Integer getTipotaxa() {
        return Codigosiva.jdoGettipotaxa(this);
    }

    public String getTipotaxaToText() {
        return Codigosiva.jdoGettipotaxa(this) == null ? "" : FIELDS.codigosiva_tipotaxa.values[Codigosiva.jdoGettipotaxa(this)];
    }

    public void setTipotaxa(Integer tipotaxa) {
        Integer n = Codigosiva.jdoGettipotaxa(this);
        Integer n2 = tipotaxa;
        Codigosiva.jdoSettipotaxa(this, n2);
        boolean changed = this.firePropertyChange(FIELDS.codigosiva_tipotaxa, (Object)n, (Object)n2);
        if (changed && this.cascade && !this.isEdited()) {
            this.setCodigo(this.generateCodigo());
        }
    }

    public boolean isTipotaxa(Integer tipotaxa) {
        return Codigosiva.equals(tipotaxa, Codigosiva.jdoGettipotaxa(this));
    }

    public Integer getEspacofiscal() {
        return Codigosiva.jdoGetespacofiscal(this);
    }

    public String getEspacofiscalToText() {
        return Codigosiva.jdoGetespacofiscal(this) == null ? "" : FIELDS.codigosiva_espacofiscal.values[Codigosiva.jdoGetespacofiscal(this)];
    }

    public void setEspacofiscal(Integer espacofiscal) {
        Integer n = Codigosiva.jdoGetespacofiscal(this);
        Integer n2 = espacofiscal;
        Codigosiva.jdoSetespacofiscal(this, n2);
        boolean changed = this.firePropertyChange(FIELDS.codigosiva_espacofiscal, (Object)n, (Object)n2);
        if (changed && this.cascade && !this.isEdited()) {
            this.setCodigo(this.generateCodigo());
        }
    }

    public boolean isEspacofiscal(Integer espacofiscal) {
        return Codigosiva.equals(espacofiscal, Codigosiva.jdoGetespacofiscal(this));
    }

    public BigDecimal getTaxa() {
        return Codigosiva.jdoGettaxa(this);
    }

    public String getTaxaToText() {
        return Codigosiva.jdoGettaxa(this) == null ? "" : FIELDS.codigosiva_taxa.format.format(Codigosiva.jdoGettaxa(this));
    }

    public void setTaxa(BigDecimal taxa) {
        BigDecimal bigDecimal = Codigosiva.jdoGettaxa(this);
        BigDecimal bigDecimal2 = taxa;
        Codigosiva.jdoSettaxa(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.codigosiva_taxa, (Object)bigDecimal, (Object)bigDecimal2);
        if (changed && this.cascade && !this.isEdited()) {
            this.setCodigo(this.generateCodigo());
        }
    }

    public boolean hasTaxa() {
        return Codigosiva.jdoGettaxa(this).signum() != 0;
    }

    @Override
    public boolean isEditable(FIELDS field) {
        return !(!super.isEditable(field) || field == FIELDS.codigosiva_tipotaxa && this.isEdited() || field == FIELDS.codigosiva_espacofiscal && this.isEdited() || field == FIELDS.codigosiva_taxa && this.isEdited());
    }

    public String toString() {
        return String.valueOf(Codigosiva.jdoGetcodigo(this)) + " - " + Codigosiva.jdoGetdescricao(this);
    }

    public int hashCode() {
        return Codigosiva.jdoGetcodigo(this) == null ? 0 : Codigosiva.jdoGetcodigo(this).hashCode();
    }

    public boolean equals(Object obj) {
        return this.hashCode() == obj.hashCode();
    }

    static {
        jdoFieldNames = Codigosiva.__jdoFieldNamesInit();
        jdoFieldTypes = Codigosiva.__jdoFieldTypesInit();
        jdoFieldFlags = Codigosiva.__jdoFieldFlagsInit();
        jdoInheritedFieldCount = Codigosiva.__jdoGetInheritedFieldCount();
        jdoPersistenceCapableSuperclass = Codigosiva.__jdoPersistenceCapableSuperclassInit();
        JDOImplHelper.registerClass((Class)Codigosiva.___jdo$loadClass("org.projectocolibri.api.database.model.Codigosiva"), (String[])jdoFieldNames, (Class[])jdoFieldTypes, (byte[])jdoFieldFlags, (Class)jdoPersistenceCapableSuperclass, (PersistenceCapable)new Codigosiva());
    }

    public void jdoCopyKeyFieldsFromObjectId(PersistenceCapable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("oid is not instanceof javax.jdo.identity.StringIdentity");
        }
        StringIdentity o = (StringIdentity)oid;
        fc.storeStringField(0, o.getKey());
    }

    protected void jdoCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("key class is not javax.jdo.identity.StringIdentity or null");
        }
        StringIdentity o = (StringIdentity)oid;
        this.codigo = o.getKey();
    }

    public final void jdoCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final void jdoCopyKeyFieldsToObjectId(PersistenceCapable.ObjectIdFieldSupplier fs, Object object) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final Object jdoGetObjectId() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getObjectId((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[0];
    }

    public final Object jdoGetVersion() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getVersion((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[1];
    }

    protected final void jdoPreSerialize() {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.preSerialize((PersistenceCapable)this);
        }
    }

    public final PersistenceManager jdoGetPersistenceManager() {
        return this.jdoStateManager != null ? this.jdoStateManager.getPersistenceManager((PersistenceCapable)this) : null;
    }

    public final Object jdoGetTransactionalObjectId() {
        return this.jdoStateManager != null ? this.jdoStateManager.getTransactionalObjectId((PersistenceCapable)this) : null;
    }

    public final boolean jdoIsDeleted() {
        return this.jdoStateManager != null ? this.jdoStateManager.isDeleted((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsDirty() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.isDirty((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return false;
        }
        return ((BitSet)this.jdoDetachedState[3]).length() > 0;
    }

    public final boolean jdoIsNew() {
        return this.jdoStateManager != null ? this.jdoStateManager.isNew((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsPersistent() {
        return this.jdoStateManager != null ? this.jdoStateManager.isPersistent((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsTransactional() {
        return this.jdoStateManager != null ? this.jdoStateManager.isTransactional((PersistenceCapable)this) : false;
    }

    public void jdoMakeDirty(String fieldName) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.makeDirty((PersistenceCapable)this, fieldName);
        }
        if (this.jdoIsDetached() && fieldName != null) {
            String fldName = null;
            fldName = fieldName.indexOf(46) >= 0 ? fieldName.substring(fieldName.lastIndexOf(46) + 1) : fieldName;
            int i = 0;
            while (i < jdoFieldNames.length) {
                if (jdoFieldNames[i].equals(fldName)) {
                    if (!((BitSet)this.jdoDetachedState[2]).get(i + jdoInheritedFieldCount)) {
                        throw new JDODetachedFieldAccessException("You have just attempted to access a field/property that hasn't been detached. Please detach it first before performing this operation");
                    }
                    ((BitSet)this.jdoDetachedState[3]).set(i + jdoInheritedFieldCount);
                    return;
                }
                ++i;
            }
        }
    }

    public final Object jdoNewObjectIdInstance() {
        return new StringIdentity(this.getClass(), this.codigo);
    }

    public final Object jdoNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new StringIdentity(this.getClass(), (String)key);
        }
        return new StringIdentity(this.getClass(), (String)key);
    }

    public final void jdoProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void jdoReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.jdoReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void jdoReplaceFlags() {
        if (this.jdoStateManager != null) {
            this.jdoFlags = this.jdoStateManager.replacingFlags((PersistenceCapable)this);
        }
    }

    public final synchronized void jdoReplaceStateManager(StateManager sm) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager = this.jdoStateManager.replacingStateManager((PersistenceCapable)this, sm);
        } else {
            JDOImplHelper.checkAuthorizedStateManager((StateManager)sm);
            this.jdoStateManager = sm;
            this.jdoFlags = 1;
        }
    }

    public final synchronized void jdoReplaceDetachedState() {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        this.jdoDetachedState = this.jdoStateManager.replacingDetachedState((Detachable)this, this.jdoDetachedState);
    }

    public boolean jdoIsDetached() {
        return this.jdoStateManager == null && this.jdoDetachedState != null;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm) {
        Codigosiva result = new Codigosiva();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        return result;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm, Object obj) {
        Codigosiva result = new Codigosiva();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        result.jdoCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void jdoReplaceField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.codigo = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 1: {
                this.descricao = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 2: {
                this.espacofiscal = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 3: {
                this.taxa = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 4: {
                this.tipotaxa = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoProvideField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.codigo);
                break;
            }
            case 1: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.descricao);
                break;
            }
            case 2: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.espacofiscal);
                break;
            }
            case 3: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.taxa);
                break;
            }
            case 4: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.tipotaxa);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void jdoCopyField(Codigosiva obj, int index) {
        switch (index) {
            case 0: {
                this.codigo = obj.codigo;
                break;
            }
            case 1: {
                this.descricao = obj.descricao;
                break;
            }
            case 2: {
                this.espacofiscal = obj.espacofiscal;
                break;
            }
            case 3: {
                this.taxa = obj.taxa;
                break;
            }
            case 4: {
                this.tipotaxa = obj.tipotaxa;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoCopyFields(Object obj, int[] indices) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof Codigosiva)) {
            throw new IllegalArgumentException("object is not an object of type org.projectocolibri.api.database.model.Codigosiva");
        }
        Codigosiva other = (Codigosiva)obj;
        if (this.jdoStateManager != other.jdoStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __jdoFieldNamesInit() {
        return new String[]{"codigo", "descricao", "espacofiscal", "taxa", "tipotaxa"};
    }

    private static final Class[] __jdoFieldTypesInit() {
        return new Class[]{Codigosiva.___jdo$loadClass("java.lang.String"), Codigosiva.___jdo$loadClass("java.lang.String"), Codigosiva.___jdo$loadClass("java.lang.Integer"), Codigosiva.___jdo$loadClass("java.math.BigDecimal"), Codigosiva.___jdo$loadClass("java.lang.Integer")};
    }

    private static final byte[] __jdoFieldFlagsInit() {
        return new byte[]{24, 21, 21, 21, 21};
    }

    protected static int __jdoGetInheritedFieldCount() {
        return 0;
    }

    protected static int jdoGetManagedFieldCount() {
        return 5;
    }

    private static Class __jdoPersistenceCapableSuperclassInit() {
        return null;
    }

    public static Class ___jdo$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object jdoSuperClone() throws CloneNotSupportedException {
        Codigosiva o = (Codigosiva)super.clone();
        o.jdoFlags = 0;
        o.jdoStateManager = null;
        return o;
    }

    private static String jdoGetcodigo(Codigosiva objPC) {
        return objPC.codigo;
    }

    private static void jdoSetcodigo(Codigosiva objPC, String val) {
        if (objPC.jdoStateManager == null) {
            objPC.codigo = val;
        } else {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 0, objPC.codigo, val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(0);
        }
    }

    private static String jdoGetdescricao(Codigosiva objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 1)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 1, objPC.descricao);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(1)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"descricao\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.descricao;
    }

    private static void jdoSetdescricao(Codigosiva objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 1, objPC.descricao, val);
        } else {
            objPC.descricao = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(1);
            }
        }
    }

    private static Integer jdoGetespacofiscal(Codigosiva objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 2)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 2, (Object)objPC.espacofiscal);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(2)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"espacofiscal\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.espacofiscal;
    }

    private static void jdoSetespacofiscal(Codigosiva objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 2, (Object)objPC.espacofiscal, (Object)val);
        } else {
            objPC.espacofiscal = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(2);
            }
        }
    }

    private static BigDecimal jdoGettaxa(Codigosiva objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 3)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 3, (Object)objPC.taxa);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(3)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"taxa\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.taxa;
    }

    private static void jdoSettaxa(Codigosiva objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 3, (Object)objPC.taxa, (Object)val);
        } else {
            objPC.taxa = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(3);
            }
        }
    }

    private static Integer jdoGettipotaxa(Codigosiva objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 4)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 4, (Object)objPC.tipotaxa);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(4)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"tipotaxa\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.tipotaxa;
    }

    private static void jdoSettipotaxa(Codigosiva objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 4, (Object)objPC.tipotaxa, (Object)val);
        } else {
            objPC.tipotaxa = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(4);
            }
        }
    }
}

