/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.model;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.BitSet;
import java.util.Date;
import javax.jdo.JDODetachedFieldAccessException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.PersistenceManager;
import javax.jdo.annotations.NotPersistent;
import javax.jdo.identity.StringIdentity;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;
import org.dma.java.math.BusinessRules;
import org.dma.java.math.SIGNUM;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.AbstractModel;
import org.projectocolibri.api.database.model.Armazens;
import org.projectocolibri.api.database.model.Artigos;
import org.projectocolibri.api.database.model.Artigoscomposicao;
import org.projectocolibri.api.database.model.Artigosdocumentos;
import org.projectocolibri.api.database.model.Artigosdocumentoslinhas;
import org.projectocolibri.api.database.model.Artigosunidades;
import org.projectocolibri.api.database.model.Codigosiva;
import org.projectocolibri.api.database.model.Cores;
import org.projectocolibri.api.database.model.Documentosseries;
import org.projectocolibri.api.database.model.Documentostipos;
import org.projectocolibri.api.database.model.Entidades;
import org.projectocolibri.api.database.model.Entidadesdocumentoslinhas;
import org.projectocolibri.api.database.model.Entidadestipos;
import org.projectocolibri.api.database.model.Isencoesiva;
import org.projectocolibri.api.database.model.Moedas;
import org.projectocolibri.api.database.model.Moedascambios;
import org.projectocolibri.api.database.model.Tamanhos;
import org.projectocolibri.api.database.model.Unidadesmedida;
import org.projectocolibri.api.database.model.Utilizadores;
import org.projectocolibri.xml.beans.saft.ATMessageFormatter;

@javax.jdo.annotations.PersistenceCapable
public class Artigosmovimentos
extends AbstractModel
implements Detachable,
PersistenceCapable {
    private String key;
    private Utilizadores autor;
    private Entidadesdocumentoslinhas linhaorigem;
    private Documentostipos tipodocumento;
    private Documentosseries seriedocumento;
    private Entidades entidade;
    private Artigos artigo;
    private Unidadesmedida unidademedida;
    private Armazens armazemdestino;
    private Armazens armazem;
    private Tamanhos tamanho;
    private Cores cor;
    private Codigosiva codigoiva;
    private Isencoesiva isencaoiva;
    @Deprecated
    private Date datacriacao;
    private Date datadocumento;
    private String numeroauxiliar;
    private String descricao;
    private String numeroserie;
    private String campo1 = "";
    private String campo2 = "";
    private String campo3 = "";
    private String campo4 = "";
    private String campo5 = "";
    private Integer numerodocumento;
    private Integer numerolinha;
    private Integer numerolinhaproducao;
    private Integer tipostock;
    private BigDecimal factor;
    private BigDecimal quantidade;
    private BigDecimal preco;
    @NotPersistent
    private BigDecimal precobase;
    @NotPersistent
    private BigDecimal precobaseliquido;
    private BigDecimal precoiva;
    private BigDecimal precopcm;
    private BigDecimal valoriliquido;
    private BigDecimal valoriliquidoiva;
    private BigDecimal percdesconto;
    private BigDecimal percdesconto2;
    private BigDecimal valordesconto;
    private BigDecimal valorliquido;
    private BigDecimal valoriva;
    private BigDecimal valorprodutos;
    private BigDecimal valorservicos;
    private BigDecimal valorretencao;
    private BigDecimal quantidadependente = BigDecimal.ZERO;
    private BigDecimal saidas = BigDecimal.ZERO;
    private BigDecimal entradas = BigDecimal.ZERO;
    private BigDecimal sinalstock = BigDecimal.ZERO;
    protected transient StateManager jdoStateManager;
    protected transient byte jdoFlags;
    protected Object[] jdoDetachedState;
    private static final byte[] jdoFieldFlags;
    private static final Class jdoPersistenceCapableSuperclass;
    private static final Class[] jdoFieldTypes;
    private static final String[] jdoFieldNames;
    private static final int jdoInheritedFieldCount;

    private Artigosmovimentos() {
        super(TABLES.artigosmovimentos);
    }

    private Artigosmovimentos(DatabaseManager manager) {
        super(TABLES.artigosmovimentos, manager);
    }

    public Artigosmovimentos(Artigosdocumentoslinhas linha) {
        this(linha.getManager());
        this.autor = linha.getDocumento().getAutor();
        this.linhaorigem = null;
        this.tipodocumento = linha.getDocumento().getTipodocumento();
        this.seriedocumento = linha.getDocumento().getSeriedocumento();
        this.entidade = null;
        this.artigo = linha.getArtigo();
        this.unidademedida = linha.getUnidademedida();
        this.armazemdestino = linha.getArmazemdestino();
        this.armazem = linha.getArmazem();
        this.tamanho = linha.getTamanho();
        this.cor = linha.getCor();
        this.codigoiva = linha.getArtigo().getCodigoiva();
        this.isencaoiva = linha.getArtigo().getIsencaoiva();
        this.datadocumento = linha.getDocumento().getDatacriacao();
        this.numeroauxiliar = linha.getDocumento().getNumeroauxiliar();
        this.descricao = linha.getDescricao();
        this.numeroserie = linha.getNumeroserie();
        this.numerodocumento = linha.getDocumento().getNumerodocumento();
        this.numerolinha = linha.getNumerolinha();
        this.numerolinhaproducao = 0;
        this.tipostock = linha.getDocumento().getTipodocumento().getTipostock();
        this.factor = linha.getFactor();
        this.quantidade = linha.getQuantidade();
        this.preco = linha.getPreco();
        this.precoiva = BigDecimal.ZERO;
        this.precopcm = linha.getArtigo().getPrecopcm();
        this.valoriliquido = linha.getValoriliquido();
        this.valoriliquidoiva = BigDecimal.ZERO;
        this.percdesconto = BigDecimal.ZERO;
        this.percdesconto2 = BigDecimal.ZERO;
        this.valordesconto = BigDecimal.ZERO;
        this.valorliquido = linha.getValoriliquido();
        this.valoriva = BigDecimal.ZERO;
        this.valorprodutos = BigDecimal.ZERO;
        this.valorservicos = BigDecimal.ZERO;
        this.valorretencao = BigDecimal.ZERO;
        this.key = this.generateKey();
        switch (this.tipodocumento.getMovimentaartigos()) {
            case 1: {
                this.saidas = this.quantidade.multiply(this.factor);
                break;
            }
            case 2: {
                this.entradas = this.quantidade.multiply(this.factor);
                break;
            }
            case 3: {
                this.saidas = this.entradas = this.quantidade.multiply(this.factor);
            }
        }
        switch (this.tipodocumento.getMovimentaartigos()) {
            case 1: {
                this.sinalstock = SIGNUM.MINUS_ONE.value;
                break;
            }
            case 2: {
                this.sinalstock = SIGNUM.ONE.value;
            }
        }
    }

    public Artigosmovimentos(Entidadesdocumentoslinhas linha) {
        this(linha.getManager());
        linha.setMovimentoartigos(this);
        this.autor = linha.getDocumento().getAutor();
        this.linhaorigem = linha;
        this.tipodocumento = linha.getDocumento().getTipodocumento();
        this.seriedocumento = linha.getDocumento().getSeriedocumento();
        this.entidade = linha.getDocumento().getEntidade();
        this.artigo = linha.getArtigo();
        this.unidademedida = linha.getUnidademedida();
        this.armazemdestino = null;
        this.armazem = linha.getArmazem();
        this.tamanho = linha.getTamanho();
        this.cor = linha.getCor();
        this.codigoiva = linha.getCodigoiva();
        this.isencaoiva = linha.getIsencaoiva();
        this.datadocumento = linha.getDocumento().getDatadocumento();
        this.numeroauxiliar = linha.getDocumento().getNumeroauxiliar();
        this.descricao = linha.getDescricao();
        this.numeroserie = linha.getNumeroserie();
        this.campo1 = linha.getCampo1();
        this.campo2 = linha.getCampo2();
        this.campo3 = linha.getCampo3();
        this.campo4 = linha.getCampo4();
        this.campo5 = linha.getCampo5();
        this.numerodocumento = linha.getDocumento().getNumerodocumento();
        this.numerolinha = linha.getNumerolinha();
        this.numerolinhaproducao = 0;
        this.tipostock = linha.getDocumento().getTipodocumento().getTipostock();
        this.factor = linha.getFactor();
        this.quantidade = linha.getQuantidade();
        this.preco = linha.getPreco();
        this.precoiva = linha.getPrecoiva();
        this.precopcm = linha.getArtigo().getPrecopcm();
        this.valoriliquido = linha.getValoriliquido();
        this.valoriliquidoiva = linha.getValoriliquidoiva();
        this.percdesconto = linha.getPercdesconto();
        this.percdesconto2 = linha.getPercdesconto2();
        this.valordesconto = linha.getValordesconto();
        this.valorliquido = linha.getValorliquido();
        this.valoriva = linha.getValoriva();
        this.valorprodutos = linha.getValorprodutos();
        this.valorservicos = linha.getValorservicos();
        this.valorretencao = linha.getValorretencao();
        this.key = this.generateKey();
        switch (this.tipodocumento.getQuantidadependente()) {
            case 1: {
                this.quantidadependente = this.quantidade.multiply(this.factor);
                break;
            }
        }
        switch (this.tipodocumento.getMovimentaartigos()) {
            case 1: {
                this.saidas = this.quantidade.multiply(this.factor);
                break;
            }
            case 2: {
                this.entradas = this.quantidade.multiply(this.factor);
                break;
            }
            case 3: {
                this.saidas = this.entradas = this.quantidade.multiply(this.factor);
            }
        }
        switch (this.tipodocumento.getMovimentaartigos()) {
            case 1: {
                this.sinalstock = SIGNUM.MINUS_ONE.value;
                break;
            }
            case 2: {
                this.sinalstock = SIGNUM.ONE.value;
            }
        }
    }

    public void clearDeprecated() {
        Artigosmovimentos.jdoSetdatacriacao(this, null);
    }

    public Artigosmovimentos cloneCopy(Artigoscomposicao linha) {
        Artigosmovimentos clone = new Artigosmovimentos(this.manager);
        Artigosmovimentos.jdoSetautor(clone, Artigosmovimentos.jdoGetautor(this));
        Artigosmovimentos.jdoSetlinhaorigem(clone, Artigosmovimentos.jdoGetlinhaorigem(this));
        Artigosmovimentos.jdoSettipodocumento(clone, Artigosmovimentos.jdoGettipodocumento(this));
        Artigosmovimentos.jdoSetseriedocumento(clone, Artigosmovimentos.jdoGetseriedocumento(this));
        Artigosmovimentos.jdoSetentidade(clone, Artigosmovimentos.jdoGetentidade(this));
        Artigosmovimentos.jdoSetartigo(clone, linha.getComponente());
        Artigosmovimentos.jdoSetunidademedida(clone, linha.getUnidademedida());
        Artigosmovimentos.jdoSetarmazemdestino(clone, null);
        Artigosmovimentos.jdoSetarmazem(clone, Artigosmovimentos.jdoGetarmazem(this));
        Artigosmovimentos.jdoSettamanho(clone, Artigosmovimentos.jdoGettamanho(this));
        Artigosmovimentos.jdoSetcor(clone, Artigosmovimentos.jdoGetcor(this));
        Artigosmovimentos.jdoSetcodigoiva(clone, Artigosmovimentos.jdoGetcodigoiva(this));
        Artigosmovimentos.jdoSetisencaoiva(clone, Artigosmovimentos.jdoGetisencaoiva(this));
        Artigosmovimentos.jdoSetdatadocumento(clone, Artigosmovimentos.jdoGetdatadocumento(this));
        Artigosmovimentos.jdoSetnumeroauxiliar(clone, "");
        Artigosmovimentos.jdoSetdescricao(clone, linha.getDescricao());
        Artigosmovimentos.jdoSetnumeroserie(clone, "0");
        Artigosmovimentos.jdoSetcampo1(clone, Artigosmovimentos.jdoGetcampo1(this));
        Artigosmovimentos.jdoSetcampo2(clone, Artigosmovimentos.jdoGetcampo2(this));
        Artigosmovimentos.jdoSetcampo3(clone, Artigosmovimentos.jdoGetcampo3(this));
        Artigosmovimentos.jdoSetcampo4(clone, Artigosmovimentos.jdoGetcampo4(this));
        Artigosmovimentos.jdoSetcampo5(clone, Artigosmovimentos.jdoGetcampo5(this));
        Artigosmovimentos.jdoSetnumerodocumento(clone, Artigosmovimentos.jdoGetnumerodocumento(this));
        Artigosmovimentos.jdoSetnumerolinha(clone, Artigosmovimentos.jdoGetnumerolinha(this));
        Artigosmovimentos.jdoSetnumerolinhaproducao(clone, linha.getNumerolinha());
        Artigosmovimentos.jdoSettipostock(clone, 0);
        Artigosunidades unidade = linha.getComponente().getUnidades(linha.getUnidademedida());
        Artigosmovimentos.jdoSetfactor(clone, unidade == null ? BigDecimal.ONE : unidade.getFactor());
        Artigosmovimentos.jdoSetquantidade(clone, Artigosmovimentos.jdoGetquantidade(this).multiply(Artigosmovimentos.jdoGetfactor(this)).multiply(linha.getQuantidade()));
        Artigosmovimentos.jdoSetpreco(clone, linha.getPrecocusto());
        Artigosmovimentos.jdoSetprecoiva(clone, Artigosmovimentos.jdoGetprecoiva(this));
        Artigosmovimentos.jdoSetprecopcm(clone, Artigosmovimentos.jdoGetprecopcm(this));
        Artigosmovimentos.jdoSetvaloriliquido(clone, Artigosmovimentos.jdoGetquantidade(clone).multiply(Artigosmovimentos.jdoGetpreco(clone)));
        Artigosmovimentos.jdoSetvaloriliquidoiva(clone, BigDecimal.ZERO);
        Artigosmovimentos.jdoSetpercdesconto(clone, Artigosmovimentos.jdoGetpercdesconto(this));
        Artigosmovimentos.jdoSetpercdesconto2(clone, Artigosmovimentos.jdoGetpercdesconto2(this));
        Artigosmovimentos.jdoSetvalordesconto(clone, BigDecimal.ZERO);
        Artigosmovimentos.jdoSetvalorliquido(clone, BigDecimal.ZERO);
        Artigosmovimentos.jdoSetvaloriva(clone, BigDecimal.ZERO);
        Artigosmovimentos.jdoSetvalorprodutos(clone, BigDecimal.ZERO);
        Artigosmovimentos.jdoSetvalorservicos(clone, BigDecimal.ZERO);
        Artigosmovimentos.jdoSetvalorretencao(clone, BigDecimal.ZERO);
        switch (Artigosmovimentos.jdoGettipodocumento(this).getMovimentaproducao()) {
            case 1: {
                Artigosmovimentos.jdoSetsaidas(clone, Artigosmovimentos.jdoGetquantidade(clone).multiply(Artigosmovimentos.jdoGetfactor(clone)));
                break;
            }
            case 2: {
                Artigosmovimentos.jdoSetentradas(clone, Artigosmovimentos.jdoGetquantidade(clone).multiply(Artigosmovimentos.jdoGetfactor(clone)));
            }
        }
        switch (Artigosmovimentos.jdoGettipodocumento(this).getMovimentaproducao()) {
            case 1: {
                Artigosmovimentos.jdoSetsinalstock(clone, SIGNUM.MINUS_ONE.value);
                break;
            }
            case 2: {
                Artigosmovimentos.jdoSetsinalstock(clone, SIGNUM.ONE.value);
            }
        }
        clone.setKey();
        return clone;
    }

    @Override
    public String getKey() {
        return Artigosmovimentos.jdoGetkey(this);
    }

    public void setKey(String key) {
        String string = Artigosmovimentos.jdoGetkey(this);
        String string2 = key;
        Artigosmovimentos.jdoSetkey(this, string2);
        this.firePropertyChange(FIELDS.artigosmovimentos_key, (Object)string, (Object)string2);
    }

    void setKey() {
        this.setKey(this.generateKey());
    }

    String generateKey() {
        return Artigosmovimentos.jdoGettipodocumento(this) == null || Artigosmovimentos.jdoGetseriedocumento(this) == null || Artigosmovimentos.jdoGetnumerodocumento(this) == null || Artigosmovimentos.jdoGetnumerolinha(this) == null || Artigosmovimentos.jdoGetnumerolinhaproducao(this) == null ? null : this.generateKey(Artigosmovimentos.jdoGettipodocumento(this).getCodigo(), Artigosmovimentos.jdoGetseriedocumento(this).getSerie(), Artigosmovimentos.jdoGetnumerodocumento(this), Artigosmovimentos.jdoGetnumerolinha(this), Artigosmovimentos.jdoGetnumerolinhaproducao(this));
    }

    private String generateKey(String tipodocumento, String serie, Integer numerodocumento, Integer numerolinha, Integer numerolinhaproducao) {
        return String.valueOf(Artigosdocumentoslinhas.generateKey(Artigosdocumentos.generateKey(tipodocumento, serie, numerodocumento), numerolinha)) + ":" + numerolinhaproducao;
    }

    public Utilizadores getAutor() {
        return Artigosmovimentos.jdoGetautor(this);
    }

    public void setAutor(Utilizadores autor) {
        Utilizadores utilizadores = Artigosmovimentos.jdoGetautor(this);
        Utilizadores utilizadores2 = autor;
        Artigosmovimentos.jdoSetautor(this, utilizadores2);
        this.firePropertyChange(FIELDS.artigosmovimentos_autor, (Object)utilizadores, (Object)utilizadores2);
    }

    public Entidadesdocumentoslinhas getLinhaorigem() {
        return Artigosmovimentos.jdoGetlinhaorigem(this);
    }

    public void setLinhaorigem(Entidadesdocumentoslinhas linhaorigem) {
        Entidadesdocumentoslinhas entidadesdocumentoslinhas = Artigosmovimentos.jdoGetlinhaorigem(this);
        Entidadesdocumentoslinhas entidadesdocumentoslinhas2 = linhaorigem;
        Artigosmovimentos.jdoSetlinhaorigem(this, entidadesdocumentoslinhas2);
        this.firePropertyChange(FIELDS.artigosmovimentos_linhaorigem, (Object)entidadesdocumentoslinhas, (Object)entidadesdocumentoslinhas2);
    }

    public Documentostipos getTipodocumento() {
        return Artigosmovimentos.jdoGettipodocumento(this);
    }

    public void setTipodocumento(Documentostipos tipodocumento) {
        Documentostipos documentostipos = Artigosmovimentos.jdoGettipodocumento(this);
        Documentostipos documentostipos2 = tipodocumento;
        Artigosmovimentos.jdoSettipodocumento(this, documentostipos2);
        this.firePropertyChange(FIELDS.artigosmovimentos_tipodocumento, (Object)documentostipos, (Object)documentostipos2);
        this.setKey();
    }

    @Deprecated
    public Entidadestipos getTipoentidade() {
        return Artigosmovimentos.jdoGettipodocumento(this).getTipoentidade();
    }

    public Documentosseries getSeriedocumento() {
        return Artigosmovimentos.jdoGetseriedocumento(this);
    }

    public void setSeriedocumento(Documentosseries seriedocumento) {
        Documentosseries documentosseries = Artigosmovimentos.jdoGetseriedocumento(this);
        Documentosseries documentosseries2 = seriedocumento;
        Artigosmovimentos.jdoSetseriedocumento(this, documentosseries2);
        this.firePropertyChange(FIELDS.artigosmovimentos_seriedocumento, (Object)documentosseries, (Object)documentosseries2);
        this.setKey();
    }

    public Entidades getEntidade() {
        return Artigosmovimentos.jdoGetentidade(this);
    }

    public void setEntidade(Entidades entidade) {
        Entidades entidades = Artigosmovimentos.jdoGetentidade(this);
        Entidades entidades2 = entidade;
        Artigosmovimentos.jdoSetentidade(this, entidades2);
        this.firePropertyChange(FIELDS.artigosmovimentos_entidade, (Object)entidades, (Object)entidades2);
    }

    public Artigos getArtigo() {
        return Artigosmovimentos.jdoGetartigo(this);
    }

    public void setArtigo(Artigos artigo) {
        Artigos artigos = Artigosmovimentos.jdoGetartigo(this);
        Artigos artigos2 = artigo;
        Artigosmovimentos.jdoSetartigo(this, artigos2);
        this.firePropertyChange(FIELDS.artigosmovimentos_artigo, (Object)artigos, (Object)artigos2);
    }

    public Unidadesmedida getUnidademedida() {
        return Artigosmovimentos.jdoGetunidademedida(this);
    }

    public void setUnidademedida(Unidadesmedida unidademedida) {
        Unidadesmedida unidadesmedida = Artigosmovimentos.jdoGetunidademedida(this);
        Unidadesmedida unidadesmedida2 = unidademedida;
        Artigosmovimentos.jdoSetunidademedida(this, unidadesmedida2);
        this.firePropertyChange(FIELDS.artigosmovimentos_unidademedida, (Object)unidadesmedida, (Object)unidadesmedida2);
    }

    public Armazens getArmazemdestino() {
        return Artigosmovimentos.jdoGetarmazemdestino(this);
    }

    public void setArmazemdestino(Armazens armazemdestino) {
        Armazens armazens = Artigosmovimentos.jdoGetarmazemdestino(this);
        Armazens armazens2 = armazemdestino;
        Artigosmovimentos.jdoSetarmazemdestino(this, armazens2);
        this.firePropertyChange(FIELDS.artigosmovimentos_armazemdestino, (Object)armazens, (Object)armazens2);
    }

    public Armazens getArmazem() {
        return Artigosmovimentos.jdoGetarmazem(this);
    }

    public void setArmazem(Armazens armazem) {
        Armazens armazens = Artigosmovimentos.jdoGetarmazem(this);
        Armazens armazens2 = armazem;
        Artigosmovimentos.jdoSetarmazem(this, armazens2);
        this.firePropertyChange(FIELDS.artigosmovimentos_armazem, (Object)armazens, (Object)armazens2);
    }

    public Tamanhos getTamanho() {
        return Artigosmovimentos.jdoGettamanho(this);
    }

    public void setTamanho(Tamanhos tamanho) {
        Tamanhos tamanhos = Artigosmovimentos.jdoGettamanho(this);
        Tamanhos tamanhos2 = tamanho;
        Artigosmovimentos.jdoSettamanho(this, tamanhos2);
        this.firePropertyChange(FIELDS.artigosmovimentos_tamanho, (Object)tamanhos, (Object)tamanhos2);
    }

    public Cores getCor() {
        return Artigosmovimentos.jdoGetcor(this);
    }

    public void setCor(Cores cor) {
        Cores cores = Artigosmovimentos.jdoGetcor(this);
        Cores cores2 = cor;
        Artigosmovimentos.jdoSetcor(this, cores2);
        this.firePropertyChange(FIELDS.artigosmovimentos_cor, (Object)cores, (Object)cores2);
    }

    public Codigosiva getCodigoiva() {
        return Artigosmovimentos.jdoGetcodigoiva(this);
    }

    public void setCodigoiva(Codigosiva codigoiva) {
        Codigosiva codigosiva = Artigosmovimentos.jdoGetcodigoiva(this);
        Codigosiva codigosiva2 = codigoiva;
        Artigosmovimentos.jdoSetcodigoiva(this, codigosiva2);
        this.firePropertyChange(FIELDS.artigosmovimentos_codigoiva, (Object)codigosiva, (Object)codigosiva2);
    }

    public Isencoesiva getIsencaoiva() {
        return Artigosmovimentos.jdoGetisencaoiva(this);
    }

    public void setIsencaoiva(Isencoesiva isencaoiva) {
        Isencoesiva isencoesiva = Artigosmovimentos.jdoGetisencaoiva(this);
        Isencoesiva isencoesiva2 = isencaoiva;
        Artigosmovimentos.jdoSetisencaoiva(this, isencoesiva2);
        this.firePropertyChange(FIELDS.artigosmovimentos_isencaoiva, (Object)isencoesiva, (Object)isencoesiva2);
    }

    @Deprecated
    public Moedas getMoeda() {
        return null;
    }

    @Deprecated
    public Moedascambios getCambio() {
        return null;
    }

    @Deprecated
    public Date getDatacriacao() {
        return Artigosmovimentos.jdoGetdatacriacao(this) == null ? Artigosmovimentos.jdoGetdatadocumento(this) : Artigosmovimentos.jdoGetdatacriacao(this);
    }

    public Date getDatadocumento() {
        return Artigosmovimentos.jdoGetdatadocumento(this);
    }

    public String getDatadocumentoToText() {
        return Artigosmovimentos.jdoGetdatadocumento(this) == null ? "" : FIELDS.artigosmovimentos_datadocumento.format.format(Artigosmovimentos.jdoGetdatadocumento(this));
    }

    public void setDatadocumento(Date datadocumento) {
        Date date = Artigosmovimentos.jdoGetdatadocumento(this);
        Date date2 = datadocumento;
        Artigosmovimentos.jdoSetdatadocumento(this, date2);
        this.firePropertyChange(FIELDS.artigosmovimentos_datadocumento, (Object)date, (Object)date2);
    }

    public String getNumeroauxiliar() {
        return Artigosmovimentos.jdoGetnumeroauxiliar(this);
    }

    public String getNumeroauxiliarToText() {
        return Artigosmovimentos.jdoGetnumeroauxiliar(this) == null ? "" : Artigosmovimentos.jdoGetnumeroauxiliar(this).toString();
    }

    public void setNumeroauxiliar(String numeroauxiliar) {
        String string = Artigosmovimentos.jdoGetnumeroauxiliar(this);
        String string2 = numeroauxiliar;
        Artigosmovimentos.jdoSetnumeroauxiliar(this, string2);
        this.firePropertyChange(FIELDS.artigosmovimentos_numeroauxiliar, (Object)string, (Object)string2);
    }

    public String getDescricao() {
        return Artigosmovimentos.jdoGetdescricao(this);
    }

    public String getDescricaoToText() {
        return Artigosmovimentos.jdoGetdescricao(this) == null ? "" : Artigosmovimentos.jdoGetdescricao(this).toString();
    }

    public void setDescricao(String descricao) {
        String string = Artigosmovimentos.jdoGetdescricao(this);
        String string2 = descricao;
        Artigosmovimentos.jdoSetdescricao(this, string2);
        this.firePropertyChange(FIELDS.artigosmovimentos_descricao, (Object)string, (Object)string2);
    }

    public String getNumeroserie() {
        return Artigosmovimentos.jdoGetnumeroserie(this);
    }

    public String getNumeroserieToText() {
        return Artigosmovimentos.jdoGetnumeroserie(this) == null ? "" : Artigosmovimentos.jdoGetnumeroserie(this).toString();
    }

    public void setNumeroserie(String numeroserie) {
        String string = Artigosmovimentos.jdoGetnumeroserie(this);
        String string2 = numeroserie;
        Artigosmovimentos.jdoSetnumeroserie(this, string2);
        this.firePropertyChange(FIELDS.artigosmovimentos_numeroserie, (Object)string, (Object)string2);
    }

    public String getCampo1() {
        return Artigosmovimentos.jdoGetcampo1(this);
    }

    public String getCampo1ToText() {
        return Artigosmovimentos.jdoGetcampo1(this) == null ? "" : Artigosmovimentos.jdoGetcampo1(this).toString();
    }

    public void setCampo1(String campo1) {
        String string = Artigosmovimentos.jdoGetcampo1(this);
        String string2 = campo1;
        Artigosmovimentos.jdoSetcampo1(this, string2);
        this.firePropertyChange(FIELDS.artigosmovimentos_campo1, (Object)string, (Object)string2);
    }

    public String getCampo2() {
        return Artigosmovimentos.jdoGetcampo2(this);
    }

    public String getCampo2ToText() {
        return Artigosmovimentos.jdoGetcampo2(this) == null ? "" : Artigosmovimentos.jdoGetcampo2(this).toString();
    }

    public void setCampo2(String campo2) {
        String string = Artigosmovimentos.jdoGetcampo2(this);
        String string2 = campo2;
        Artigosmovimentos.jdoSetcampo2(this, string2);
        this.firePropertyChange(FIELDS.artigosmovimentos_campo2, (Object)string, (Object)string2);
    }

    public String getCampo3() {
        return Artigosmovimentos.jdoGetcampo3(this);
    }

    public String getCampo3ToText() {
        return Artigosmovimentos.jdoGetcampo3(this) == null ? "" : Artigosmovimentos.jdoGetcampo3(this).toString();
    }

    public void setCampo3(String campo3) {
        String string = Artigosmovimentos.jdoGetcampo3(this);
        String string2 = campo3;
        Artigosmovimentos.jdoSetcampo3(this, string2);
        this.firePropertyChange(FIELDS.artigosmovimentos_campo3, (Object)string, (Object)string2);
    }

    public String getCampo4() {
        return Artigosmovimentos.jdoGetcampo4(this);
    }

    public String getCampo4ToText() {
        return Artigosmovimentos.jdoGetcampo4(this) == null ? "" : Artigosmovimentos.jdoGetcampo4(this).toString();
    }

    public void setCampo4(String campo4) {
        String string = Artigosmovimentos.jdoGetcampo4(this);
        String string2 = campo4;
        Artigosmovimentos.jdoSetcampo4(this, string2);
        this.firePropertyChange(FIELDS.artigosmovimentos_campo4, (Object)string, (Object)string2);
    }

    public String getCampo5() {
        return Artigosmovimentos.jdoGetcampo5(this);
    }

    public String getCampo5ToText() {
        return Artigosmovimentos.jdoGetcampo5(this) == null ? "" : Artigosmovimentos.jdoGetcampo5(this).toString();
    }

    public void setCampo5(String campo5) {
        String string = Artigosmovimentos.jdoGetcampo5(this);
        String string2 = campo5;
        Artigosmovimentos.jdoSetcampo5(this, string2);
        this.firePropertyChange(FIELDS.artigosmovimentos_campo5, (Object)string, (Object)string2);
    }

    public Integer getNumerodocumento() {
        return Artigosmovimentos.jdoGetnumerodocumento(this);
    }

    public String getNumerodocumentoToText() {
        return Artigosmovimentos.jdoGetnumerodocumento(this) == null ? "" : Artigosmovimentos.jdoGetnumerodocumento(this).toString();
    }

    public void setNumerodocumento(Integer numerodocumento) {
        Integer n = Artigosmovimentos.jdoGetnumerodocumento(this);
        Integer n2 = numerodocumento;
        Artigosmovimentos.jdoSetnumerodocumento(this, n2);
        this.firePropertyChange(FIELDS.artigosmovimentos_numerodocumento, (Object)n, (Object)n2);
        this.setKey();
    }

    public Integer getNumerolinha() {
        return Artigosmovimentos.jdoGetnumerolinha(this);
    }

    public String getNumerolinhaToText() {
        return Artigosmovimentos.jdoGetnumerolinha(this) == null ? "" : Artigosmovimentos.jdoGetnumerolinha(this).toString();
    }

    protected void setNumerolinha(Integer numerolinha) {
        Integer n = Artigosmovimentos.jdoGetnumerolinha(this);
        Integer n2 = numerolinha;
        Artigosmovimentos.jdoSetnumerolinha(this, n2);
        this.firePropertyChange(FIELDS.artigosmovimentos_numerolinha, (Object)n, (Object)n2);
        this.setKey();
    }

    public Integer getNumerolinhaproducao() {
        return Artigosmovimentos.jdoGetnumerolinhaproducao(this);
    }

    public String getNumerolinhaproducaoToText() {
        return Artigosmovimentos.jdoGetnumerolinhaproducao(this) == null ? "" : Artigosmovimentos.jdoGetnumerolinhaproducao(this).toString();
    }

    protected void setNumerolinhaproducao(Integer numerolinhaproducao) {
        Integer n = Artigosmovimentos.jdoGetnumerolinhaproducao(this);
        Integer n2 = numerolinhaproducao;
        Artigosmovimentos.jdoSetnumerolinhaproducao(this, n2);
        this.firePropertyChange(FIELDS.artigosmovimentos_numerolinhaproducao, (Object)n, (Object)n2);
        this.setKey();
    }

    public Integer getTipostock() {
        return Artigosmovimentos.jdoGettipostock(this);
    }

    public String getTipostockToText() {
        return Artigosmovimentos.jdoGettipostock(this) == null ? "" : Artigosmovimentos.jdoGettipostock(this).toString();
    }

    public void setTipostock(Integer tipostock) {
        Integer n = Artigosmovimentos.jdoGettipostock(this);
        Integer n2 = tipostock;
        Artigosmovimentos.jdoSettipostock(this, n2);
        this.firePropertyChange(FIELDS.artigosmovimentos_tipostock, (Object)n, (Object)n2);
    }

    public boolean isTipostock(Integer tipostock) {
        return Artigosmovimentos.equals(tipostock, Artigosmovimentos.jdoGettipostock(this));
    }

    @Deprecated
    public Integer getEstado() {
        return null;
    }

    public BigDecimal getFactor() {
        return Artigosmovimentos.jdoGetfactor(this);
    }

    public String getFactorToText() {
        return Artigosmovimentos.jdoGetfactor(this) == null ? "" : FIELDS.artigosmovimentos_factor.format.format(Artigosmovimentos.jdoGetfactor(this));
    }

    public void setFactor(BigDecimal factor) {
        BigDecimal bigDecimal = Artigosmovimentos.jdoGetfactor(this);
        BigDecimal bigDecimal2 = factor;
        Artigosmovimentos.jdoSetfactor(this, bigDecimal2);
        this.firePropertyChange(FIELDS.artigosmovimentos_factor, (Object)bigDecimal, (Object)bigDecimal2);
    }

    public BigDecimal getQuantidade() {
        return Artigosmovimentos.jdoGetquantidade(this);
    }

    public String getQuantidadeToText() {
        return Artigosmovimentos.jdoGetquantidade(this) == null ? "" : FIELDS.artigosmovimentos_quantidade.format.format(Artigosmovimentos.jdoGetquantidade(this));
    }

    public void setQuantidade(BigDecimal quantidade) {
        BigDecimal bigDecimal = Artigosmovimentos.jdoGetquantidade(this);
        BigDecimal bigDecimal2 = quantidade;
        Artigosmovimentos.jdoSetquantidade(this, bigDecimal2);
        this.firePropertyChange(FIELDS.artigosmovimentos_quantidade, (Object)bigDecimal, (Object)bigDecimal2);
    }

    public BigDecimal getPreco() {
        return Artigosmovimentos.jdoGetpreco(this);
    }

    public String getPrecoToText() {
        return Artigosmovimentos.jdoGetpreco(this) == null ? "" : FIELDS.artigosmovimentos_preco.format.format(Artigosmovimentos.jdoGetpreco(this));
    }

    public void setPreco(BigDecimal preco) {
        BigDecimal bigDecimal = Artigosmovimentos.jdoGetpreco(this);
        BigDecimal bigDecimal2 = preco;
        Artigosmovimentos.jdoSetpreco(this, bigDecimal2);
        this.firePropertyChange(FIELDS.artigosmovimentos_preco, (Object)bigDecimal, (Object)bigDecimal2);
    }

    public BigDecimal getPrecobase() {
        return Artigosmovimentos.jdoGetpreco(this).divide(Artigosmovimentos.jdoGetfactor(this), MathContext.DECIMAL64);
    }

    public String getPrecobaseToText() {
        return FIELDS.artigosmovimentos_precobase.format.format(this.getPrecobase());
    }

    public BigDecimal getPrecobaseliquido() {
        return BusinessRules.netValue((BigDecimal)this.getPrecobase(), (BigDecimal)this.getPercdescontofinal());
    }

    public String getPrecobaseliquidoToText() {
        return FIELDS.artigosmovimentos_precobaseliquido.format.format(this.getPrecobaseliquido());
    }

    public BigDecimal getPrecoiva() {
        return Artigosmovimentos.jdoGetprecoiva(this);
    }

    public String getPrecoivaToText() {
        return Artigosmovimentos.jdoGetprecoiva(this) == null ? "" : FIELDS.artigosmovimentos_precoiva.format.format(Artigosmovimentos.jdoGetprecoiva(this));
    }

    public void setPrecoiva(BigDecimal precoiva) {
        BigDecimal bigDecimal = Artigosmovimentos.jdoGetprecoiva(this);
        BigDecimal bigDecimal2 = precoiva;
        Artigosmovimentos.jdoSetprecoiva(this, bigDecimal2);
        this.firePropertyChange(FIELDS.artigosmovimentos_precoiva, (Object)bigDecimal, (Object)bigDecimal2);
    }

    public BigDecimal getPrecopcm() {
        return Artigosmovimentos.jdoGetprecopcm(this);
    }

    public String getPrecopcmToText() {
        return Artigosmovimentos.jdoGetprecopcm(this) == null ? "" : FIELDS.artigosmovimentos_precopcm.format.format(Artigosmovimentos.jdoGetprecopcm(this));
    }

    public void setPrecopcm(BigDecimal precopcm) {
        BigDecimal bigDecimal = Artigosmovimentos.jdoGetprecopcm(this);
        BigDecimal bigDecimal2 = precopcm;
        Artigosmovimentos.jdoSetprecopcm(this, bigDecimal2);
        this.firePropertyChange(FIELDS.artigosmovimentos_precopcm, (Object)bigDecimal, (Object)bigDecimal2);
    }

    public BigDecimal getValoriliquido() {
        return Artigosmovimentos.jdoGetvaloriliquido(this);
    }

    public String getValoriliquidoToText() {
        return Artigosmovimentos.jdoGetvaloriliquido(this) == null ? "" : FIELDS.artigosmovimentos_valoriliquido.format.format(Artigosmovimentos.jdoGetvaloriliquido(this));
    }

    public void setValoriliquido(BigDecimal valoriliquido) {
        BigDecimal bigDecimal = Artigosmovimentos.jdoGetvaloriliquido(this);
        BigDecimal bigDecimal2 = valoriliquido;
        Artigosmovimentos.jdoSetvaloriliquido(this, bigDecimal2);
        this.firePropertyChange(FIELDS.artigosmovimentos_valoriliquido, (Object)bigDecimal, (Object)bigDecimal2);
    }

    public BigDecimal getValoriliquidoiva() {
        return Artigosmovimentos.jdoGetvaloriliquidoiva(this);
    }

    public String getValoriliquidoivaToText() {
        return Artigosmovimentos.jdoGetvaloriliquidoiva(this) == null ? "" : FIELDS.artigosmovimentos_valoriliquidoiva.format.format(Artigosmovimentos.jdoGetvaloriliquidoiva(this));
    }

    public void setValoriliquidoiva(BigDecimal valoriliquidoiva) {
        BigDecimal bigDecimal = Artigosmovimentos.jdoGetvaloriliquidoiva(this);
        BigDecimal bigDecimal2 = valoriliquidoiva;
        Artigosmovimentos.jdoSetvaloriliquidoiva(this, bigDecimal2);
        this.firePropertyChange(FIELDS.artigosmovimentos_valoriliquidoiva, (Object)bigDecimal, (Object)bigDecimal2);
    }

    public BigDecimal getPercdesconto() {
        return Artigosmovimentos.jdoGetpercdesconto(this);
    }

    public String getPercdescontoToText() {
        return Artigosmovimentos.jdoGetpercdesconto(this) == null ? "" : FIELDS.artigosmovimentos_percdesconto.format.format(Artigosmovimentos.jdoGetpercdesconto(this));
    }

    public void setPercdesconto(BigDecimal percdesconto) {
        BigDecimal bigDecimal = Artigosmovimentos.jdoGetpercdesconto(this);
        BigDecimal bigDecimal2 = percdesconto;
        Artigosmovimentos.jdoSetpercdesconto(this, bigDecimal2);
        this.firePropertyChange(FIELDS.artigosmovimentos_percdesconto, (Object)bigDecimal, (Object)bigDecimal2);
    }

    public BigDecimal getPercdesconto2() {
        return Artigosmovimentos.jdoGetpercdesconto2(this);
    }

    public String getPercdesconto2ToText() {
        return Artigosmovimentos.jdoGetpercdesconto2(this) == null ? "" : FIELDS.artigosmovimentos_percdesconto2.format.format(Artigosmovimentos.jdoGetpercdesconto2(this));
    }

    public void setPercdesconto2(BigDecimal percdesconto2) {
        BigDecimal bigDecimal = Artigosmovimentos.jdoGetpercdesconto2(this);
        BigDecimal bigDecimal2 = percdesconto2;
        Artigosmovimentos.jdoSetpercdesconto2(this, bigDecimal2);
        this.firePropertyChange(FIELDS.artigosmovimentos_percdesconto2, (Object)bigDecimal, (Object)bigDecimal2);
    }

    public BigDecimal getPercdescontofinal() {
        return BusinessRules.addedPercentages((BigDecimal)Artigosmovimentos.jdoGetpercdesconto(this), (BigDecimal)Artigosmovimentos.jdoGetpercdesconto2(this));
    }

    public String getPercdescontofinalToText() {
        return FIELDS.artigosmovimentos_percdescontofinal.format.format(this.getPercdescontofinal());
    }

    public BigDecimal getValordesconto() {
        return Artigosmovimentos.jdoGetvalordesconto(this);
    }

    public String getValordescontoToText() {
        return Artigosmovimentos.jdoGetvalordesconto(this) == null ? "" : FIELDS.artigosmovimentos_valordesconto.format.format(Artigosmovimentos.jdoGetvalordesconto(this));
    }

    public void setValordesconto(BigDecimal valordesconto) {
        BigDecimal bigDecimal = Artigosmovimentos.jdoGetvalordesconto(this);
        BigDecimal bigDecimal2 = valordesconto;
        Artigosmovimentos.jdoSetvalordesconto(this, bigDecimal2);
        this.firePropertyChange(FIELDS.artigosmovimentos_valordesconto, (Object)bigDecimal, (Object)bigDecimal2);
    }

    public BigDecimal getValorliquido() {
        return Artigosmovimentos.jdoGetvalorliquido(this);
    }

    public String getValorliquidoToText() {
        return Artigosmovimentos.jdoGetvalorliquido(this) == null ? "" : FIELDS.artigosmovimentos_valorliquido.format.format(Artigosmovimentos.jdoGetvalorliquido(this));
    }

    public void setValorliquido(BigDecimal valorliquido) {
        BigDecimal bigDecimal = Artigosmovimentos.jdoGetvalorliquido(this);
        BigDecimal bigDecimal2 = valorliquido;
        Artigosmovimentos.jdoSetvalorliquido(this, bigDecimal2);
        this.firePropertyChange(FIELDS.artigosmovimentos_valorliquido, (Object)bigDecimal, (Object)bigDecimal2);
    }

    public BigDecimal getValoriva() {
        return Artigosmovimentos.jdoGetvaloriva(this);
    }

    public String getValorivaToText() {
        return Artigosmovimentos.jdoGetvaloriva(this) == null ? "" : FIELDS.artigosmovimentos_valoriva.format.format(Artigosmovimentos.jdoGetvaloriva(this));
    }

    public void setValoriva(BigDecimal valoriva) {
        BigDecimal bigDecimal = Artigosmovimentos.jdoGetvaloriva(this);
        BigDecimal bigDecimal2 = valoriva;
        Artigosmovimentos.jdoSetvaloriva(this, bigDecimal2);
        this.firePropertyChange(FIELDS.artigosmovimentos_valoriva, (Object)bigDecimal, (Object)bigDecimal2);
    }

    public BigDecimal getValorprodutos() {
        return Artigosmovimentos.jdoGetvalorprodutos(this);
    }

    public String getValorprodutosToText() {
        return Artigosmovimentos.jdoGetvalorprodutos(this) == null ? "" : FIELDS.artigosmovimentos_valorprodutos.format.format(Artigosmovimentos.jdoGetvalorprodutos(this));
    }

    public void setValorprodutos(BigDecimal valorprodutos) {
        BigDecimal bigDecimal = Artigosmovimentos.jdoGetvalorprodutos(this);
        BigDecimal bigDecimal2 = valorprodutos;
        Artigosmovimentos.jdoSetvalorprodutos(this, bigDecimal2);
        this.firePropertyChange(FIELDS.artigosmovimentos_valorprodutos, (Object)bigDecimal, (Object)bigDecimal2);
    }

    public BigDecimal getValorservicos() {
        return Artigosmovimentos.jdoGetvalorservicos(this);
    }

    public String getValorservicosToText() {
        return Artigosmovimentos.jdoGetvalorservicos(this) == null ? "" : FIELDS.artigosmovimentos_valorservicos.format.format(Artigosmovimentos.jdoGetvalorservicos(this));
    }

    public void setValorservicos(BigDecimal valorservicos) {
        BigDecimal bigDecimal = Artigosmovimentos.jdoGetvalorservicos(this);
        BigDecimal bigDecimal2 = valorservicos;
        Artigosmovimentos.jdoSetvalorservicos(this, bigDecimal2);
        this.firePropertyChange(FIELDS.artigosmovimentos_valorservicos, (Object)bigDecimal, (Object)bigDecimal2);
    }

    public BigDecimal getValorretencao() {
        return Artigosmovimentos.jdoGetvalorretencao(this);
    }

    public String getValorretencaoToText() {
        return Artigosmovimentos.jdoGetvalorretencao(this) == null ? "" : FIELDS.artigosmovimentos_valorretencao.format.format(Artigosmovimentos.jdoGetvalorretencao(this));
    }

    public void setValorretencao(BigDecimal valorretencao) {
        BigDecimal bigDecimal = Artigosmovimentos.jdoGetvalorretencao(this);
        BigDecimal bigDecimal2 = valorretencao;
        Artigosmovimentos.jdoSetvalorretencao(this, bigDecimal2);
        this.firePropertyChange(FIELDS.artigosmovimentos_valorretencao, (Object)bigDecimal, (Object)bigDecimal2);
    }

    @Deprecated
    public BigDecimal getFormulaquant() {
        return Artigosmovimentos.jdoGetlinhaorigem(this) == null ? BigDecimal.ZERO : Artigosmovimentos.jdoGetlinhaorigem(this).getFormulaquant();
    }

    @Deprecated
    public BigDecimal getFormulavalor1() {
        return Artigosmovimentos.jdoGetlinhaorigem(this) == null ? BigDecimal.ZERO : Artigosmovimentos.jdoGetlinhaorigem(this).getFormulavalor1();
    }

    @Deprecated
    public BigDecimal getFormulavalor2() {
        return Artigosmovimentos.jdoGetlinhaorigem(this) == null ? BigDecimal.ZERO : Artigosmovimentos.jdoGetlinhaorigem(this).getFormulavalor2();
    }

    @Deprecated
    public BigDecimal getFormulavalor3() {
        return Artigosmovimentos.jdoGetlinhaorigem(this) == null ? BigDecimal.ZERO : Artigosmovimentos.jdoGetlinhaorigem(this).getFormulavalor3();
    }

    @Deprecated
    public BigDecimal getFormulavalor4() {
        return Artigosmovimentos.jdoGetlinhaorigem(this) == null ? BigDecimal.ZERO : Artigosmovimentos.jdoGetlinhaorigem(this).getFormulavalor4();
    }

    public BigDecimal getQuantidadependente() {
        return Artigosmovimentos.jdoGetquantidadependente(this);
    }

    public String getQuantidadependenteToText() {
        return Artigosmovimentos.jdoGetquantidadependente(this) == null ? "" : FIELDS.artigosmovimentos_quantidadependente.format.format(Artigosmovimentos.jdoGetquantidadependente(this));
    }

    public void setQuantidadependente(BigDecimal quantidadependente) {
        BigDecimal bigDecimal = Artigosmovimentos.jdoGetquantidadependente(this);
        BigDecimal bigDecimal2 = quantidadependente;
        Artigosmovimentos.jdoSetquantidadependente(this, bigDecimal2);
        this.firePropertyChange(FIELDS.artigosmovimentos_quantidadependente, (Object)bigDecimal, (Object)bigDecimal2);
    }

    public void addQuantidadependente(BigDecimal quantidadependente, SIGNUM sinal) {
        this.setQuantidadependente(Artigosmovimentos.jdoGetquantidadependente(this).add(quantidadependente.multiply(sinal.value)));
    }

    public BigDecimal getSaidas() {
        return Artigosmovimentos.jdoGetsaidas(this);
    }

    public String getSaidasToText() {
        return Artigosmovimentos.jdoGetsaidas(this) == null ? "" : FIELDS.artigosmovimentos_saidas.format.format(Artigosmovimentos.jdoGetsaidas(this));
    }

    public void setSaidas(BigDecimal saidas) {
        BigDecimal bigDecimal = Artigosmovimentos.jdoGetsaidas(this);
        BigDecimal bigDecimal2 = saidas;
        Artigosmovimentos.jdoSetsaidas(this, bigDecimal2);
        this.firePropertyChange(FIELDS.artigosmovimentos_saidas, (Object)bigDecimal, (Object)bigDecimal2);
    }

    public BigDecimal getEntradas() {
        return Artigosmovimentos.jdoGetentradas(this);
    }

    public String getEntradasToText() {
        return Artigosmovimentos.jdoGetentradas(this) == null ? "" : FIELDS.artigosmovimentos_entradas.format.format(Artigosmovimentos.jdoGetentradas(this));
    }

    public void setEntradas(BigDecimal entradas) {
        BigDecimal bigDecimal = Artigosmovimentos.jdoGetentradas(this);
        BigDecimal bigDecimal2 = entradas;
        Artigosmovimentos.jdoSetentradas(this, bigDecimal2);
        this.firePropertyChange(FIELDS.artigosmovimentos_entradas, (Object)bigDecimal, (Object)bigDecimal2);
    }

    public BigDecimal getSinalstock() {
        return Artigosmovimentos.jdoGetsinalstock(this);
    }

    public String getSinalToText() {
        return Artigosmovimentos.jdoGetsinalstock(this) == null ? "" : FIELDS.artigosmovimentos_sinalstock.format.format(Artigosmovimentos.jdoGetsinalstock(this));
    }

    public void setSinalstock(BigDecimal sinalstock) {
        BigDecimal bigDecimal = Artigosmovimentos.jdoGetsinalstock(this);
        BigDecimal bigDecimal2 = sinalstock;
        Artigosmovimentos.jdoSetsinalstock(this, bigDecimal2);
        this.firePropertyChange(FIELDS.artigosmovimentos_sinalstock, (Object)bigDecimal, (Object)bigDecimal2);
    }

    @Override
    public void attach(DatabaseManager manager) {
        manager.attach(new AbstractModel[]{Artigosmovimentos.jdoGetautor(this), Artigosmovimentos.jdoGetlinhaorigem(this), Artigosmovimentos.jdoGettipodocumento(this), Artigosmovimentos.jdoGetseriedocumento(this), Artigosmovimentos.jdoGetentidade(this), Artigosmovimentos.jdoGetartigo(this), Artigosmovimentos.jdoGetunidademedida(this), Artigosmovimentos.jdoGetarmazemdestino(this), Artigosmovimentos.jdoGetarmazem(this), Artigosmovimentos.jdoGettamanho(this), Artigosmovimentos.jdoGetcor(this), Artigosmovimentos.jdoGetcodigoiva(this), Artigosmovimentos.jdoGetisencaoiva(this)});
    }

    public String toString() {
        return ATMessageFormatter.getInvoiceNo(Artigosmovimentos.jdoGettipodocumento(this) == null ? null : Artigosmovimentos.jdoGettipodocumento(this).getCodigo(), Artigosmovimentos.jdoGetseriedocumento(this) == null ? null : Artigosmovimentos.jdoGetseriedocumento(this).getSerie(), Artigosmovimentos.jdoGetnumerodocumento(this));
    }

    public int hashCode() {
        return Artigosmovimentos.jdoGetkey(this) == null ? 0 : Artigosmovimentos.jdoGetkey(this).hashCode();
    }

    public boolean equals(Object obj) {
        return this.hashCode() == obj.hashCode();
    }

    static {
        jdoFieldNames = Artigosmovimentos.__jdoFieldNamesInit();
        jdoFieldTypes = Artigosmovimentos.__jdoFieldTypesInit();
        jdoFieldFlags = Artigosmovimentos.__jdoFieldFlagsInit();
        jdoInheritedFieldCount = Artigosmovimentos.__jdoGetInheritedFieldCount();
        jdoPersistenceCapableSuperclass = Artigosmovimentos.__jdoPersistenceCapableSuperclassInit();
        JDOImplHelper.registerClass((Class)Artigosmovimentos.___jdo$loadClass("org.projectocolibri.api.database.model.Artigosmovimentos"), (String[])jdoFieldNames, (Class[])jdoFieldTypes, (byte[])jdoFieldFlags, (Class)jdoPersistenceCapableSuperclass, (PersistenceCapable)new Artigosmovimentos());
    }

    public void jdoCopyKeyFieldsFromObjectId(PersistenceCapable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("oid is not instanceof javax.jdo.identity.StringIdentity");
        }
        StringIdentity o = (StringIdentity)oid;
        fc.storeStringField(18, o.getKey());
    }

    protected void jdoCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("key class is not javax.jdo.identity.StringIdentity or null");
        }
        StringIdentity o = (StringIdentity)oid;
        this.key = o.getKey();
    }

    public final void jdoCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final void jdoCopyKeyFieldsToObjectId(PersistenceCapable.ObjectIdFieldSupplier fs, Object object) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final Object jdoGetObjectId() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getObjectId((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[0];
    }

    public final Object jdoGetVersion() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getVersion((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[1];
    }

    protected final void jdoPreSerialize() {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.preSerialize((PersistenceCapable)this);
        }
    }

    public final PersistenceManager jdoGetPersistenceManager() {
        return this.jdoStateManager != null ? this.jdoStateManager.getPersistenceManager((PersistenceCapable)this) : null;
    }

    public final Object jdoGetTransactionalObjectId() {
        return this.jdoStateManager != null ? this.jdoStateManager.getTransactionalObjectId((PersistenceCapable)this) : null;
    }

    public final boolean jdoIsDeleted() {
        return this.jdoStateManager != null ? this.jdoStateManager.isDeleted((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsDirty() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.isDirty((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return false;
        }
        return ((BitSet)this.jdoDetachedState[3]).length() > 0;
    }

    public final boolean jdoIsNew() {
        return this.jdoStateManager != null ? this.jdoStateManager.isNew((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsPersistent() {
        return this.jdoStateManager != null ? this.jdoStateManager.isPersistent((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsTransactional() {
        return this.jdoStateManager != null ? this.jdoStateManager.isTransactional((PersistenceCapable)this) : false;
    }

    public void jdoMakeDirty(String fieldName) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.makeDirty((PersistenceCapable)this, fieldName);
        }
        if (this.jdoIsDetached() && fieldName != null) {
            String fldName = null;
            fldName = fieldName.indexOf(46) >= 0 ? fieldName.substring(fieldName.lastIndexOf(46) + 1) : fieldName;
            int i = 0;
            while (i < jdoFieldNames.length) {
                if (jdoFieldNames[i].equals(fldName)) {
                    if (!((BitSet)this.jdoDetachedState[2]).get(i + jdoInheritedFieldCount)) {
                        throw new JDODetachedFieldAccessException("You have just attempted to access a field/property that hasn't been detached. Please detach it first before performing this operation");
                    }
                    ((BitSet)this.jdoDetachedState[3]).set(i + jdoInheritedFieldCount);
                    return;
                }
                ++i;
            }
        }
    }

    public final Object jdoNewObjectIdInstance() {
        return new StringIdentity(this.getClass(), this.key);
    }

    public final Object jdoNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new StringIdentity(this.getClass(), (String)key);
        }
        return new StringIdentity(this.getClass(), (String)key);
    }

    public final void jdoProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void jdoReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.jdoReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void jdoReplaceFlags() {
        if (this.jdoStateManager != null) {
            this.jdoFlags = this.jdoStateManager.replacingFlags((PersistenceCapable)this);
        }
    }

    public final synchronized void jdoReplaceStateManager(StateManager sm) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager = this.jdoStateManager.replacingStateManager((PersistenceCapable)this, sm);
        } else {
            JDOImplHelper.checkAuthorizedStateManager((StateManager)sm);
            this.jdoStateManager = sm;
            this.jdoFlags = 1;
        }
    }

    public final synchronized void jdoReplaceDetachedState() {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        this.jdoDetachedState = this.jdoStateManager.replacingDetachedState((Detachable)this, this.jdoDetachedState);
    }

    public boolean jdoIsDetached() {
        return this.jdoStateManager == null && this.jdoDetachedState != null;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm) {
        Artigosmovimentos result = new Artigosmovimentos();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        return result;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm, Object obj) {
        Artigosmovimentos result = new Artigosmovimentos();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        result.jdoCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void jdoReplaceField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.armazem = (Armazens)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 1: {
                this.armazemdestino = (Armazens)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 2: {
                this.artigo = (Artigos)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 3: {
                this.autor = (Utilizadores)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 4: {
                this.campo1 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 5: {
                this.campo2 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 6: {
                this.campo3 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 7: {
                this.campo4 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 8: {
                this.campo5 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 9: {
                this.codigoiva = (Codigosiva)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 10: {
                this.cor = (Cores)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 11: {
                this.datacriacao = (Date)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 12: {
                this.datadocumento = (Date)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 13: {
                this.descricao = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 14: {
                this.entidade = (Entidades)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 15: {
                this.entradas = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 16: {
                this.factor = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 17: {
                this.isencaoiva = (Isencoesiva)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 18: {
                this.key = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 19: {
                this.linhaorigem = (Entidadesdocumentoslinhas)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 20: {
                this.numeroauxiliar = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 21: {
                this.numerodocumento = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 22: {
                this.numerolinha = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 23: {
                this.numerolinhaproducao = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 24: {
                this.numeroserie = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 25: {
                this.percdesconto = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 26: {
                this.percdesconto2 = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 27: {
                this.preco = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 28: {
                this.precoiva = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 29: {
                this.precopcm = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 30: {
                this.quantidade = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 31: {
                this.quantidadependente = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 32: {
                this.saidas = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 33: {
                this.seriedocumento = (Documentosseries)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 34: {
                this.sinalstock = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 35: {
                this.tamanho = (Tamanhos)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 36: {
                this.tipodocumento = (Documentostipos)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 37: {
                this.tipostock = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 38: {
                this.unidademedida = (Unidadesmedida)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 39: {
                this.valordesconto = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 40: {
                this.valoriliquido = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 41: {
                this.valoriliquidoiva = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 42: {
                this.valoriva = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 43: {
                this.valorliquido = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 44: {
                this.valorprodutos = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 45: {
                this.valorretencao = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 46: {
                this.valorservicos = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoProvideField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.armazem);
                break;
            }
            case 1: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.armazemdestino);
                break;
            }
            case 2: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.artigo);
                break;
            }
            case 3: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.autor);
                break;
            }
            case 4: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.campo1);
                break;
            }
            case 5: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.campo2);
                break;
            }
            case 6: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.campo3);
                break;
            }
            case 7: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.campo4);
                break;
            }
            case 8: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.campo5);
                break;
            }
            case 9: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.codigoiva);
                break;
            }
            case 10: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.cor);
                break;
            }
            case 11: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.datacriacao);
                break;
            }
            case 12: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.datadocumento);
                break;
            }
            case 13: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.descricao);
                break;
            }
            case 14: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.entidade);
                break;
            }
            case 15: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.entradas);
                break;
            }
            case 16: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.factor);
                break;
            }
            case 17: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.isencaoiva);
                break;
            }
            case 18: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.key);
                break;
            }
            case 19: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.linhaorigem);
                break;
            }
            case 20: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.numeroauxiliar);
                break;
            }
            case 21: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.numerodocumento);
                break;
            }
            case 22: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.numerolinha);
                break;
            }
            case 23: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.numerolinhaproducao);
                break;
            }
            case 24: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.numeroserie);
                break;
            }
            case 25: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.percdesconto);
                break;
            }
            case 26: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.percdesconto2);
                break;
            }
            case 27: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.preco);
                break;
            }
            case 28: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.precoiva);
                break;
            }
            case 29: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.precopcm);
                break;
            }
            case 30: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.quantidade);
                break;
            }
            case 31: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.quantidadependente);
                break;
            }
            case 32: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.saidas);
                break;
            }
            case 33: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.seriedocumento);
                break;
            }
            case 34: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.sinalstock);
                break;
            }
            case 35: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.tamanho);
                break;
            }
            case 36: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.tipodocumento);
                break;
            }
            case 37: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.tipostock);
                break;
            }
            case 38: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.unidademedida);
                break;
            }
            case 39: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.valordesconto);
                break;
            }
            case 40: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.valoriliquido);
                break;
            }
            case 41: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.valoriliquidoiva);
                break;
            }
            case 42: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.valoriva);
                break;
            }
            case 43: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.valorliquido);
                break;
            }
            case 44: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.valorprodutos);
                break;
            }
            case 45: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.valorretencao);
                break;
            }
            case 46: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.valorservicos);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void jdoCopyField(Artigosmovimentos obj, int index) {
        switch (index) {
            case 0: {
                this.armazem = obj.armazem;
                break;
            }
            case 1: {
                this.armazemdestino = obj.armazemdestino;
                break;
            }
            case 2: {
                this.artigo = obj.artigo;
                break;
            }
            case 3: {
                this.autor = obj.autor;
                break;
            }
            case 4: {
                this.campo1 = obj.campo1;
                break;
            }
            case 5: {
                this.campo2 = obj.campo2;
                break;
            }
            case 6: {
                this.campo3 = obj.campo3;
                break;
            }
            case 7: {
                this.campo4 = obj.campo4;
                break;
            }
            case 8: {
                this.campo5 = obj.campo5;
                break;
            }
            case 9: {
                this.codigoiva = obj.codigoiva;
                break;
            }
            case 10: {
                this.cor = obj.cor;
                break;
            }
            case 11: {
                this.datacriacao = obj.datacriacao;
                break;
            }
            case 12: {
                this.datadocumento = obj.datadocumento;
                break;
            }
            case 13: {
                this.descricao = obj.descricao;
                break;
            }
            case 14: {
                this.entidade = obj.entidade;
                break;
            }
            case 15: {
                this.entradas = obj.entradas;
                break;
            }
            case 16: {
                this.factor = obj.factor;
                break;
            }
            case 17: {
                this.isencaoiva = obj.isencaoiva;
                break;
            }
            case 18: {
                this.key = obj.key;
                break;
            }
            case 19: {
                this.linhaorigem = obj.linhaorigem;
                break;
            }
            case 20: {
                this.numeroauxiliar = obj.numeroauxiliar;
                break;
            }
            case 21: {
                this.numerodocumento = obj.numerodocumento;
                break;
            }
            case 22: {
                this.numerolinha = obj.numerolinha;
                break;
            }
            case 23: {
                this.numerolinhaproducao = obj.numerolinhaproducao;
                break;
            }
            case 24: {
                this.numeroserie = obj.numeroserie;
                break;
            }
            case 25: {
                this.percdesconto = obj.percdesconto;
                break;
            }
            case 26: {
                this.percdesconto2 = obj.percdesconto2;
                break;
            }
            case 27: {
                this.preco = obj.preco;
                break;
            }
            case 28: {
                this.precoiva = obj.precoiva;
                break;
            }
            case 29: {
                this.precopcm = obj.precopcm;
                break;
            }
            case 30: {
                this.quantidade = obj.quantidade;
                break;
            }
            case 31: {
                this.quantidadependente = obj.quantidadependente;
                break;
            }
            case 32: {
                this.saidas = obj.saidas;
                break;
            }
            case 33: {
                this.seriedocumento = obj.seriedocumento;
                break;
            }
            case 34: {
                this.sinalstock = obj.sinalstock;
                break;
            }
            case 35: {
                this.tamanho = obj.tamanho;
                break;
            }
            case 36: {
                this.tipodocumento = obj.tipodocumento;
                break;
            }
            case 37: {
                this.tipostock = obj.tipostock;
                break;
            }
            case 38: {
                this.unidademedida = obj.unidademedida;
                break;
            }
            case 39: {
                this.valordesconto = obj.valordesconto;
                break;
            }
            case 40: {
                this.valoriliquido = obj.valoriliquido;
                break;
            }
            case 41: {
                this.valoriliquidoiva = obj.valoriliquidoiva;
                break;
            }
            case 42: {
                this.valoriva = obj.valoriva;
                break;
            }
            case 43: {
                this.valorliquido = obj.valorliquido;
                break;
            }
            case 44: {
                this.valorprodutos = obj.valorprodutos;
                break;
            }
            case 45: {
                this.valorretencao = obj.valorretencao;
                break;
            }
            case 46: {
                this.valorservicos = obj.valorservicos;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoCopyFields(Object obj, int[] indices) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof Artigosmovimentos)) {
            throw new IllegalArgumentException("object is not an object of type org.projectocolibri.api.database.model.Artigosmovimentos");
        }
        Artigosmovimentos other = (Artigosmovimentos)obj;
        if (this.jdoStateManager != other.jdoStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __jdoFieldNamesInit() {
        return new String[]{"armazem", "armazemdestino", "artigo", "autor", "campo1", "campo2", "campo3", "campo4", "campo5", "codigoiva", "cor", "datacriacao", "datadocumento", "descricao", "entidade", "entradas", "factor", "isencaoiva", "key", "linhaorigem", "numeroauxiliar", "numerodocumento", "numerolinha", "numerolinhaproducao", "numeroserie", "percdesconto", "percdesconto2", "preco", "precoiva", "precopcm", "quantidade", "quantidadependente", "saidas", "seriedocumento", "sinalstock", "tamanho", "tipodocumento", "tipostock", "unidademedida", "valordesconto", "valoriliquido", "valoriliquidoiva", "valoriva", "valorliquido", "valorprodutos", "valorretencao", "valorservicos"};
    }

    private static final Class[] __jdoFieldTypesInit() {
        return new Class[]{Artigosmovimentos.___jdo$loadClass("org.projectocolibri.api.database.model.Armazens"), Artigosmovimentos.___jdo$loadClass("org.projectocolibri.api.database.model.Armazens"), Artigosmovimentos.___jdo$loadClass("org.projectocolibri.api.database.model.Artigos"), Artigosmovimentos.___jdo$loadClass("org.projectocolibri.api.database.model.Utilizadores"), Artigosmovimentos.___jdo$loadClass("java.lang.String"), Artigosmovimentos.___jdo$loadClass("java.lang.String"), Artigosmovimentos.___jdo$loadClass("java.lang.String"), Artigosmovimentos.___jdo$loadClass("java.lang.String"), Artigosmovimentos.___jdo$loadClass("java.lang.String"), Artigosmovimentos.___jdo$loadClass("org.projectocolibri.api.database.model.Codigosiva"), Artigosmovimentos.___jdo$loadClass("org.projectocolibri.api.database.model.Cores"), Artigosmovimentos.___jdo$loadClass("java.util.Date"), Artigosmovimentos.___jdo$loadClass("java.util.Date"), Artigosmovimentos.___jdo$loadClass("java.lang.String"), Artigosmovimentos.___jdo$loadClass("org.projectocolibri.api.database.model.Entidades"), Artigosmovimentos.___jdo$loadClass("java.math.BigDecimal"), Artigosmovimentos.___jdo$loadClass("java.math.BigDecimal"), Artigosmovimentos.___jdo$loadClass("org.projectocolibri.api.database.model.Isencoesiva"), Artigosmovimentos.___jdo$loadClass("java.lang.String"), Artigosmovimentos.___jdo$loadClass("org.projectocolibri.api.database.model.Entidadesdocumentoslinhas"), Artigosmovimentos.___jdo$loadClass("java.lang.String"), Artigosmovimentos.___jdo$loadClass("java.lang.Integer"), Artigosmovimentos.___jdo$loadClass("java.lang.Integer"), Artigosmovimentos.___jdo$loadClass("java.lang.Integer"), Artigosmovimentos.___jdo$loadClass("java.lang.String"), Artigosmovimentos.___jdo$loadClass("java.math.BigDecimal"), Artigosmovimentos.___jdo$loadClass("java.math.BigDecimal"), Artigosmovimentos.___jdo$loadClass("java.math.BigDecimal"), Artigosmovimentos.___jdo$loadClass("java.math.BigDecimal"), Artigosmovimentos.___jdo$loadClass("java.math.BigDecimal"), Artigosmovimentos.___jdo$loadClass("java.math.BigDecimal"), Artigosmovimentos.___jdo$loadClass("java.math.BigDecimal"), Artigosmovimentos.___jdo$loadClass("java.math.BigDecimal"), Artigosmovimentos.___jdo$loadClass("org.projectocolibri.api.database.model.Documentosseries"), Artigosmovimentos.___jdo$loadClass("java.math.BigDecimal"), Artigosmovimentos.___jdo$loadClass("org.projectocolibri.api.database.model.Tamanhos"), Artigosmovimentos.___jdo$loadClass("org.projectocolibri.api.database.model.Documentostipos"), Artigosmovimentos.___jdo$loadClass("java.lang.Integer"), Artigosmovimentos.___jdo$loadClass("org.projectocolibri.api.database.model.Unidadesmedida"), Artigosmovimentos.___jdo$loadClass("java.math.BigDecimal"), Artigosmovimentos.___jdo$loadClass("java.math.BigDecimal"), Artigosmovimentos.___jdo$loadClass("java.math.BigDecimal"), Artigosmovimentos.___jdo$loadClass("java.math.BigDecimal"), Artigosmovimentos.___jdo$loadClass("java.math.BigDecimal"), Artigosmovimentos.___jdo$loadClass("java.math.BigDecimal"), Artigosmovimentos.___jdo$loadClass("java.math.BigDecimal"), Artigosmovimentos.___jdo$loadClass("java.math.BigDecimal")};
    }

    private static final byte[] __jdoFieldFlagsInit() {
        return new byte[]{5, 5, 5, 26, 21, 21, 21, 21, 21, 5, 5, 21, 21, 21, 5, 21, 21, 5, 24, 5, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 5, 21, 5, 5, 21, 5, 21, 21, 21, 21, 21, 21, 21, 21};
    }

    protected static int __jdoGetInheritedFieldCount() {
        return 0;
    }

    protected static int jdoGetManagedFieldCount() {
        return 47;
    }

    private static Class __jdoPersistenceCapableSuperclassInit() {
        return null;
    }

    public static Class ___jdo$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object jdoSuperClone() throws CloneNotSupportedException {
        Artigosmovimentos o = (Artigosmovimentos)super.clone();
        o.jdoFlags = 0;
        o.jdoStateManager = null;
        return o;
    }

    private static Armazens jdoGetarmazem(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 0)) {
            return (Armazens)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 0, (Object)objPC.armazem);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(0)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"armazem\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.armazem;
    }

    private static void jdoSetarmazem(Artigosmovimentos objPC, Armazens val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 0, (Object)objPC.armazem, (Object)val);
        } else {
            objPC.armazem = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(0);
            }
        }
    }

    private static Armazens jdoGetarmazemdestino(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 1)) {
            return (Armazens)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 1, (Object)objPC.armazemdestino);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(1)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"armazemdestino\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.armazemdestino;
    }

    private static void jdoSetarmazemdestino(Artigosmovimentos objPC, Armazens val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 1, (Object)objPC.armazemdestino, (Object)val);
        } else {
            objPC.armazemdestino = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(1);
            }
        }
    }

    private static Artigos jdoGetartigo(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 2)) {
            return (Artigos)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 2, (Object)objPC.artigo);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(2)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"artigo\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.artigo;
    }

    private static void jdoSetartigo(Artigosmovimentos objPC, Artigos val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 2, (Object)objPC.artigo, (Object)val);
        } else {
            objPC.artigo = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(2);
            }
        }
    }

    private static Utilizadores jdoGetautor(Artigosmovimentos objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 3)) {
            return (Utilizadores)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 3, (Object)objPC.autor);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(3) && !((BitSet)objPC.jdoDetachedState[3]).get(3)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"autor\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.autor;
    }

    private static void jdoSetautor(Artigosmovimentos objPC, Utilizadores val) {
        if (objPC.jdoStateManager == null) {
            objPC.autor = val;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 3, (Object)objPC.autor, (Object)val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(3);
        }
    }

    private static String jdoGetcampo1(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 4)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 4, objPC.campo1);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(4)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"campo1\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.campo1;
    }

    private static void jdoSetcampo1(Artigosmovimentos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 4, objPC.campo1, val);
        } else {
            objPC.campo1 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(4);
            }
        }
    }

    private static String jdoGetcampo2(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 5)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 5, objPC.campo2);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(5)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"campo2\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.campo2;
    }

    private static void jdoSetcampo2(Artigosmovimentos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 5, objPC.campo2, val);
        } else {
            objPC.campo2 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(5);
            }
        }
    }

    private static String jdoGetcampo3(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 6)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 6, objPC.campo3);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(6)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"campo3\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.campo3;
    }

    private static void jdoSetcampo3(Artigosmovimentos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 6, objPC.campo3, val);
        } else {
            objPC.campo3 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(6);
            }
        }
    }

    private static String jdoGetcampo4(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 7)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 7, objPC.campo4);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(7)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"campo4\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.campo4;
    }

    private static void jdoSetcampo4(Artigosmovimentos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 7, objPC.campo4, val);
        } else {
            objPC.campo4 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(7);
            }
        }
    }

    private static String jdoGetcampo5(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 8)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 8, objPC.campo5);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(8)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"campo5\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.campo5;
    }

    private static void jdoSetcampo5(Artigosmovimentos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 8, objPC.campo5, val);
        } else {
            objPC.campo5 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(8);
            }
        }
    }

    private static Codigosiva jdoGetcodigoiva(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 9)) {
            return (Codigosiva)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 9, (Object)objPC.codigoiva);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(9)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"codigoiva\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.codigoiva;
    }

    private static void jdoSetcodigoiva(Artigosmovimentos objPC, Codigosiva val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 9, (Object)objPC.codigoiva, (Object)val);
        } else {
            objPC.codigoiva = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(9);
            }
        }
    }

    private static Cores jdoGetcor(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 10)) {
            return (Cores)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 10, (Object)objPC.cor);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(10)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"cor\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.cor;
    }

    private static void jdoSetcor(Artigosmovimentos objPC, Cores val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 10, (Object)objPC.cor, (Object)val);
        } else {
            objPC.cor = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(10);
            }
        }
    }

    private static Date jdoGetdatacriacao(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 11)) {
            return (Date)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 11, (Object)objPC.datacriacao);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(11)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"datacriacao\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.datacriacao;
    }

    private static void jdoSetdatacriacao(Artigosmovimentos objPC, Date val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 11, (Object)objPC.datacriacao, (Object)val);
        } else {
            objPC.datacriacao = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(11);
            }
        }
    }

    private static Date jdoGetdatadocumento(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 12)) {
            return (Date)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 12, (Object)objPC.datadocumento);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(12)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"datadocumento\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.datadocumento;
    }

    private static void jdoSetdatadocumento(Artigosmovimentos objPC, Date val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 12, (Object)objPC.datadocumento, (Object)val);
        } else {
            objPC.datadocumento = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(12);
            }
        }
    }

    private static String jdoGetdescricao(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 13)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 13, objPC.descricao);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(13)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"descricao\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.descricao;
    }

    private static void jdoSetdescricao(Artigosmovimentos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 13, objPC.descricao, val);
        } else {
            objPC.descricao = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(13);
            }
        }
    }

    private static Entidades jdoGetentidade(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 14)) {
            return (Entidades)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 14, (Object)objPC.entidade);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(14)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"entidade\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.entidade;
    }

    private static void jdoSetentidade(Artigosmovimentos objPC, Entidades val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 14, (Object)objPC.entidade, (Object)val);
        } else {
            objPC.entidade = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(14);
            }
        }
    }

    private static BigDecimal jdoGetentradas(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 15)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 15, (Object)objPC.entradas);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(15)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"entradas\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.entradas;
    }

    private static void jdoSetentradas(Artigosmovimentos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 15, (Object)objPC.entradas, (Object)val);
        } else {
            objPC.entradas = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(15);
            }
        }
    }

    private static BigDecimal jdoGetfactor(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 16)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 16, (Object)objPC.factor);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(16)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"factor\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.factor;
    }

    private static void jdoSetfactor(Artigosmovimentos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 16, (Object)objPC.factor, (Object)val);
        } else {
            objPC.factor = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(16);
            }
        }
    }

    private static Isencoesiva jdoGetisencaoiva(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 17)) {
            return (Isencoesiva)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 17, (Object)objPC.isencaoiva);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(17)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"isencaoiva\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.isencaoiva;
    }

    private static void jdoSetisencaoiva(Artigosmovimentos objPC, Isencoesiva val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 17, (Object)objPC.isencaoiva, (Object)val);
        } else {
            objPC.isencaoiva = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(17);
            }
        }
    }

    private static String jdoGetkey(Artigosmovimentos objPC) {
        return objPC.key;
    }

    private static void jdoSetkey(Artigosmovimentos objPC, String val) {
        if (objPC.jdoStateManager == null) {
            objPC.key = val;
        } else {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 18, objPC.key, val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(18);
        }
    }

    private static Entidadesdocumentoslinhas jdoGetlinhaorigem(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 19)) {
            return (Entidadesdocumentoslinhas)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 19, (Object)objPC.linhaorigem);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(19)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"linhaorigem\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.linhaorigem;
    }

    private static void jdoSetlinhaorigem(Artigosmovimentos objPC, Entidadesdocumentoslinhas val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 19, (Object)objPC.linhaorigem, (Object)val);
        } else {
            objPC.linhaorigem = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(19);
            }
        }
    }

    private static String jdoGetnumeroauxiliar(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 20)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 20, objPC.numeroauxiliar);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(20)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"numeroauxiliar\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.numeroauxiliar;
    }

    private static void jdoSetnumeroauxiliar(Artigosmovimentos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 20, objPC.numeroauxiliar, val);
        } else {
            objPC.numeroauxiliar = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(20);
            }
        }
    }

    private static Integer jdoGetnumerodocumento(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 21)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 21, (Object)objPC.numerodocumento);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(21)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"numerodocumento\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.numerodocumento;
    }

    private static void jdoSetnumerodocumento(Artigosmovimentos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 21, (Object)objPC.numerodocumento, (Object)val);
        } else {
            objPC.numerodocumento = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(21);
            }
        }
    }

    private static Integer jdoGetnumerolinha(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 22)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 22, (Object)objPC.numerolinha);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(22)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"numerolinha\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.numerolinha;
    }

    private static void jdoSetnumerolinha(Artigosmovimentos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 22, (Object)objPC.numerolinha, (Object)val);
        } else {
            objPC.numerolinha = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(22);
            }
        }
    }

    private static Integer jdoGetnumerolinhaproducao(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 23)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 23, (Object)objPC.numerolinhaproducao);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(23)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"numerolinhaproducao\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.numerolinhaproducao;
    }

    private static void jdoSetnumerolinhaproducao(Artigosmovimentos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 23, (Object)objPC.numerolinhaproducao, (Object)val);
        } else {
            objPC.numerolinhaproducao = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(23);
            }
        }
    }

    private static String jdoGetnumeroserie(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 24)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 24, objPC.numeroserie);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(24)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"numeroserie\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.numeroserie;
    }

    private static void jdoSetnumeroserie(Artigosmovimentos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 24, objPC.numeroserie, val);
        } else {
            objPC.numeroserie = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(24);
            }
        }
    }

    private static BigDecimal jdoGetpercdesconto(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 25)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 25, (Object)objPC.percdesconto);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(25)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"percdesconto\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.percdesconto;
    }

    private static void jdoSetpercdesconto(Artigosmovimentos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 25, (Object)objPC.percdesconto, (Object)val);
        } else {
            objPC.percdesconto = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(25);
            }
        }
    }

    private static BigDecimal jdoGetpercdesconto2(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 26)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 26, (Object)objPC.percdesconto2);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(26)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"percdesconto2\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.percdesconto2;
    }

    private static void jdoSetpercdesconto2(Artigosmovimentos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 26, (Object)objPC.percdesconto2, (Object)val);
        } else {
            objPC.percdesconto2 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(26);
            }
        }
    }

    private static BigDecimal jdoGetpreco(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 27)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 27, (Object)objPC.preco);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(27)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"preco\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.preco;
    }

    private static void jdoSetpreco(Artigosmovimentos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 27, (Object)objPC.preco, (Object)val);
        } else {
            objPC.preco = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(27);
            }
        }
    }

    private static BigDecimal jdoGetprecoiva(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 28)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 28, (Object)objPC.precoiva);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(28)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"precoiva\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.precoiva;
    }

    private static void jdoSetprecoiva(Artigosmovimentos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 28, (Object)objPC.precoiva, (Object)val);
        } else {
            objPC.precoiva = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(28);
            }
        }
    }

    private static BigDecimal jdoGetprecopcm(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 29)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 29, (Object)objPC.precopcm);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(29)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"precopcm\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.precopcm;
    }

    private static void jdoSetprecopcm(Artigosmovimentos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 29, (Object)objPC.precopcm, (Object)val);
        } else {
            objPC.precopcm = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(29);
            }
        }
    }

    private static BigDecimal jdoGetquantidade(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 30)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 30, (Object)objPC.quantidade);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(30)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"quantidade\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.quantidade;
    }

    private static void jdoSetquantidade(Artigosmovimentos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 30, (Object)objPC.quantidade, (Object)val);
        } else {
            objPC.quantidade = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(30);
            }
        }
    }

    private static BigDecimal jdoGetquantidadependente(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 31)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 31, (Object)objPC.quantidadependente);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(31)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"quantidadependente\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.quantidadependente;
    }

    private static void jdoSetquantidadependente(Artigosmovimentos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 31, (Object)objPC.quantidadependente, (Object)val);
        } else {
            objPC.quantidadependente = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(31);
            }
        }
    }

    private static BigDecimal jdoGetsaidas(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 32)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 32, (Object)objPC.saidas);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(32)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"saidas\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.saidas;
    }

    private static void jdoSetsaidas(Artigosmovimentos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 32, (Object)objPC.saidas, (Object)val);
        } else {
            objPC.saidas = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(32);
            }
        }
    }

    private static Documentosseries jdoGetseriedocumento(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 33)) {
            return (Documentosseries)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 33, (Object)objPC.seriedocumento);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(33)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"seriedocumento\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.seriedocumento;
    }

    private static void jdoSetseriedocumento(Artigosmovimentos objPC, Documentosseries val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 33, (Object)objPC.seriedocumento, (Object)val);
        } else {
            objPC.seriedocumento = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(33);
            }
        }
    }

    private static BigDecimal jdoGetsinalstock(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 34)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 34, (Object)objPC.sinalstock);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(34)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"sinalstock\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.sinalstock;
    }

    private static void jdoSetsinalstock(Artigosmovimentos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 34, (Object)objPC.sinalstock, (Object)val);
        } else {
            objPC.sinalstock = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(34);
            }
        }
    }

    private static Tamanhos jdoGettamanho(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 35)) {
            return (Tamanhos)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 35, (Object)objPC.tamanho);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(35)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"tamanho\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.tamanho;
    }

    private static void jdoSettamanho(Artigosmovimentos objPC, Tamanhos val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 35, (Object)objPC.tamanho, (Object)val);
        } else {
            objPC.tamanho = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(35);
            }
        }
    }

    private static Documentostipos jdoGettipodocumento(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 36)) {
            return (Documentostipos)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 36, (Object)objPC.tipodocumento);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(36)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"tipodocumento\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.tipodocumento;
    }

    private static void jdoSettipodocumento(Artigosmovimentos objPC, Documentostipos val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 36, (Object)objPC.tipodocumento, (Object)val);
        } else {
            objPC.tipodocumento = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(36);
            }
        }
    }

    private static Integer jdoGettipostock(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 37)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 37, (Object)objPC.tipostock);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(37)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"tipostock\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.tipostock;
    }

    private static void jdoSettipostock(Artigosmovimentos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 37, (Object)objPC.tipostock, (Object)val);
        } else {
            objPC.tipostock = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(37);
            }
        }
    }

    private static Unidadesmedida jdoGetunidademedida(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 38)) {
            return (Unidadesmedida)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 38, (Object)objPC.unidademedida);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(38)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"unidademedida\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.unidademedida;
    }

    private static void jdoSetunidademedida(Artigosmovimentos objPC, Unidadesmedida val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 38, (Object)objPC.unidademedida, (Object)val);
        } else {
            objPC.unidademedida = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(38);
            }
        }
    }

    private static BigDecimal jdoGetvalordesconto(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 39)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 39, (Object)objPC.valordesconto);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(39)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"valordesconto\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.valordesconto;
    }

    private static void jdoSetvalordesconto(Artigosmovimentos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 39, (Object)objPC.valordesconto, (Object)val);
        } else {
            objPC.valordesconto = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(39);
            }
        }
    }

    private static BigDecimal jdoGetvaloriliquido(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 40)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 40, (Object)objPC.valoriliquido);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(40)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"valoriliquido\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.valoriliquido;
    }

    private static void jdoSetvaloriliquido(Artigosmovimentos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 40, (Object)objPC.valoriliquido, (Object)val);
        } else {
            objPC.valoriliquido = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(40);
            }
        }
    }

    private static BigDecimal jdoGetvaloriliquidoiva(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 41)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 41, (Object)objPC.valoriliquidoiva);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(41)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"valoriliquidoiva\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.valoriliquidoiva;
    }

    private static void jdoSetvaloriliquidoiva(Artigosmovimentos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 41, (Object)objPC.valoriliquidoiva, (Object)val);
        } else {
            objPC.valoriliquidoiva = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(41);
            }
        }
    }

    private static BigDecimal jdoGetvaloriva(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 42)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 42, (Object)objPC.valoriva);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(42)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"valoriva\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.valoriva;
    }

    private static void jdoSetvaloriva(Artigosmovimentos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 42, (Object)objPC.valoriva, (Object)val);
        } else {
            objPC.valoriva = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(42);
            }
        }
    }

    private static BigDecimal jdoGetvalorliquido(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 43)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 43, (Object)objPC.valorliquido);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(43)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"valorliquido\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.valorliquido;
    }

    private static void jdoSetvalorliquido(Artigosmovimentos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 43, (Object)objPC.valorliquido, (Object)val);
        } else {
            objPC.valorliquido = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(43);
            }
        }
    }

    private static BigDecimal jdoGetvalorprodutos(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 44)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 44, (Object)objPC.valorprodutos);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(44)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"valorprodutos\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.valorprodutos;
    }

    private static void jdoSetvalorprodutos(Artigosmovimentos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 44, (Object)objPC.valorprodutos, (Object)val);
        } else {
            objPC.valorprodutos = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(44);
            }
        }
    }

    private static BigDecimal jdoGetvalorretencao(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 45)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 45, (Object)objPC.valorretencao);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(45)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"valorretencao\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.valorretencao;
    }

    private static void jdoSetvalorretencao(Artigosmovimentos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 45, (Object)objPC.valorretencao, (Object)val);
        } else {
            objPC.valorretencao = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(45);
            }
        }
    }

    private static BigDecimal jdoGetvalorservicos(Artigosmovimentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 46)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 46, (Object)objPC.valorservicos);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(46)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"valorservicos\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.valorservicos;
    }

    private static void jdoSetvalorservicos(Artigosmovimentos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 46, (Object)objPC.valorservicos, (Object)val);
        } else {
            objPC.valorservicos = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(46);
            }
        }
    }
}

