/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.model;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.BitSet;
import javax.jdo.JDODetachedFieldAccessException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.PersistenceManager;
import javax.jdo.identity.StringIdentity;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;
import org.dma.java.util.ErrorList;
import org.dma.java.util.MessageLine;
import org.dma.java.util.MessageList;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.IDatabaseModel;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.AbstractModel;
import org.projectocolibri.api.database.model.Armazens;
import org.projectocolibri.api.database.model.Artigos;
import org.projectocolibri.api.database.model.Artigosdocumentos;
import org.projectocolibri.api.database.model.Artigosunidades;
import org.projectocolibri.api.database.model.Cores;
import org.projectocolibri.api.database.model.Tamanhos;
import org.projectocolibri.api.database.model.Unidadesmedida;
import org.projectocolibri.api.language.LABELS;

@javax.jdo.annotations.PersistenceCapable
public class Artigosdocumentoslinhas
extends AbstractModel
implements Detachable,
PersistenceCapable {
    private String key;
    private Artigosdocumentos documento;
    private Artigos artigo;
    private Unidadesmedida unidademedida;
    private Armazens armazemdestino;
    private Armazens armazem;
    private Tamanhos tamanho;
    private Cores cor;
    private String descricao;
    private String numeroserie;
    private Integer numerolinha;
    private BigDecimal factor;
    private BigDecimal quantidade;
    private BigDecimal preco;
    private BigDecimal valoriliquido;
    private BigDecimal formulaquant;
    private BigDecimal formulavalor1;
    private BigDecimal formulavalor2;
    private BigDecimal formulavalor3;
    private BigDecimal formulavalor4;
    protected transient StateManager jdoStateManager;
    protected transient byte jdoFlags;
    protected Object[] jdoDetachedState;
    private static final byte[] jdoFieldFlags;
    private static final Class jdoPersistenceCapableSuperclass;
    private static final Class[] jdoFieldTypes;
    private static final String[] jdoFieldNames;
    private static final int jdoInheritedFieldCount;

    private Artigosdocumentoslinhas() {
        super(TABLES.artigosdocumentoslinhas);
    }

    private Artigosdocumentoslinhas(DatabaseManager manager) {
        super(TABLES.artigosdocumentoslinhas, manager);
    }

    public Artigosdocumentoslinhas(Artigosdocumentos documento) {
        this(documento.getManager());
        this.documento = documento;
        this.artigo = null;
        this.unidademedida = this.manager.getParametros().getUnidademedida();
        this.armazemdestino = null;
        this.armazem = this.manager.loadArmazens();
        this.tamanho = this.manager.loadTamanhos();
        this.cor = this.manager.loadCores();
        this.descricao = "";
        this.numeroserie = "0";
        this.numerolinha = documento.getLinhasdocumento().size() + 1;
        this.factor = BigDecimal.ONE;
        this.quantidade = BigDecimal.ZERO;
        this.preco = BigDecimal.ZERO;
        this.valoriliquido = BigDecimal.ZERO;
        this.formulaquant = BigDecimal.ZERO;
        this.formulavalor1 = BigDecimal.ZERO;
        this.formulavalor2 = BigDecimal.ZERO;
        this.formulavalor3 = BigDecimal.ZERO;
        this.formulavalor4 = BigDecimal.ZERO;
        this.key = this.generateKey();
        this.process();
    }

    @Override
    public Artigosdocumentoslinhas cloneCopy() {
        Artigosdocumentoslinhas clone = new Artigosdocumentoslinhas(this.manager);
        Artigosdocumentoslinhas.jdoSetkey(clone, Artigosdocumentoslinhas.jdoGetkey(this));
        Artigosdocumentoslinhas.jdoSetdocumento(clone, Artigosdocumentoslinhas.jdoGetdocumento(this));
        Artigosdocumentoslinhas.jdoSetartigo(clone, Artigosdocumentoslinhas.jdoGetartigo(this));
        Artigosdocumentoslinhas.jdoSetunidademedida(clone, Artigosdocumentoslinhas.jdoGetunidademedida(this));
        Artigosdocumentoslinhas.jdoSetarmazemdestino(clone, Artigosdocumentoslinhas.jdoGetarmazemdestino(this));
        Artigosdocumentoslinhas.jdoSetarmazem(clone, Artigosdocumentoslinhas.jdoGetarmazem(this));
        Artigosdocumentoslinhas.jdoSettamanho(clone, Artigosdocumentoslinhas.jdoGettamanho(this));
        Artigosdocumentoslinhas.jdoSetcor(clone, Artigosdocumentoslinhas.jdoGetcor(this));
        Artigosdocumentoslinhas.jdoSetdescricao(clone, Artigosdocumentoslinhas.jdoGetdescricao(this));
        Artigosdocumentoslinhas.jdoSetnumeroserie(clone, Artigosdocumentoslinhas.jdoGetnumeroserie(this));
        Artigosdocumentoslinhas.jdoSetnumerolinha(clone, Artigosdocumentoslinhas.jdoGetnumerolinha(this));
        Artigosdocumentoslinhas.jdoSetfactor(clone, Artigosdocumentoslinhas.jdoGetfactor(this));
        Artigosdocumentoslinhas.jdoSetquantidade(clone, Artigosdocumentoslinhas.jdoGetquantidade(this));
        Artigosdocumentoslinhas.jdoSetpreco(clone, Artigosdocumentoslinhas.jdoGetpreco(this));
        Artigosdocumentoslinhas.jdoSetvaloriliquido(clone, Artigosdocumentoslinhas.jdoGetvaloriliquido(this));
        Artigosdocumentoslinhas.jdoSetformulaquant(clone, Artigosdocumentoslinhas.jdoGetformulaquant(this));
        Artigosdocumentoslinhas.jdoSetformulavalor1(clone, Artigosdocumentoslinhas.jdoGetformulavalor1(this));
        Artigosdocumentoslinhas.jdoSetformulavalor2(clone, Artigosdocumentoslinhas.jdoGetformulavalor2(this));
        Artigosdocumentoslinhas.jdoSetformulavalor3(clone, Artigosdocumentoslinhas.jdoGetformulavalor3(this));
        Artigosdocumentoslinhas.jdoSetformulavalor4(clone, Artigosdocumentoslinhas.jdoGetformulavalor4(this));
        return clone;
    }

    Artigosdocumentoslinhas cloneCopy(Artigosdocumentos documento) {
        Artigosdocumentoslinhas clone = this.cloneCopy();
        Artigosdocumentoslinhas.jdoSetdocumento(clone, documento);
        clone.setKey();
        return clone;
    }

    @Override
    public MessageList validate(IDatabaseModel.ACTION action) {
        MessageList error = super.validate(action);
        switch (action) {
            case DELETE: {
                break;
            }
            case STORE: {
                if (Artigosdocumentoslinhas.jdoGetartigo(this) != null && Artigosdocumentoslinhas.jdoGetartigo(this).isEstado(0)) {
                    error.add((Object)new MessageLine((Object)LABELS.artigosdocumentoslinhas_artigo).brackets((Object)Artigosdocumentoslinhas.jdoGetartigo(this).getEstadoToText()));
                }
                if (Artigosdocumentoslinhas.jdoGetartigo(this) != null && !this.hasQuantidade()) {
                    error.add((Object)new MessageLine((Object)LABELS.artigosdocumentoslinhas_quantidade).equal((Object)0));
                }
                if (Artigosdocumentoslinhas.jdoGetartigo(this) != null && Artigosdocumentoslinhas.jdoGetdocumento(this).getTipodocumento().isMovimentaartigos(3) && Artigosdocumentoslinhas.jdoGetarmazemdestino(this) != null && Artigosdocumentoslinhas.jdoGetarmazem(this).equals(Artigosdocumentoslinhas.jdoGetarmazemdestino(this))) {
                    error.add((Object)new MessageLine((Object)LABELS.artigosdocumentoslinhas_armazemdestino));
                }
                if (!Artigosdocumentoslinhas.jdoGetnumeroserie(this).isEmpty()) break;
                error.add((Object)new MessageLine((Object)LABELS.artigosdocumentoslinhas_numeroserie));
            }
        }
        return error.prefix((Object)((Object)LABELS.artigosdocumentoslinhas_numerolinha) + " " + this.getNumerolinhaToText());
    }

    public ErrorList warnings() {
        return new ErrorList();
    }

    Artigosdocumentoslinhas process() {
        if (!this.busy) {
            this.busy = true;
            boolean cascade = this.setCascade(false);
            this.setValoriliquido(Artigosdocumentoslinhas.jdoGetquantidade(this).multiply(Artigosdocumentoslinhas.jdoGetpreco(this)));
            if (Artigosdocumentoslinhas.jdoGetdocumento((Artigosdocumentoslinhas)this).cascade) {
                Artigosdocumentoslinhas.jdoGetdocumento(this).process();
            }
            this.setCascade(cascade);
            this.busy = false;
        }
        return this;
    }

    @Override
    public String getKey() {
        return Artigosdocumentoslinhas.jdoGetkey(this);
    }

    public void setKey(String key) {
        String string = Artigosdocumentoslinhas.jdoGetkey(this);
        String string2 = key;
        Artigosdocumentoslinhas.jdoSetkey(this, string2);
        this.firePropertyChange(FIELDS.artigosdocumentoslinhas_key, (Object)string, (Object)string2);
    }

    void setKey() {
        this.setKey(this.generateKey());
    }

    String generateKey() {
        return Artigosdocumentoslinhas.jdoGetdocumento(this) == null || Artigosdocumentoslinhas.jdoGetnumerolinha(this) == null ? null : Artigosdocumentoslinhas.generateKey(Artigosdocumentoslinhas.jdoGetdocumento(this).generateKey(), Artigosdocumentoslinhas.jdoGetnumerolinha(this));
    }

    public static String generateKey(String documento, Integer numerolinha) {
        return String.valueOf(documento) + ":" + numerolinha;
    }

    public Artigosdocumentos getDocumento() {
        return Artigosdocumentoslinhas.jdoGetdocumento(this);
    }

    public void setDocumento(Artigosdocumentos documento) {
        Artigosdocumentos artigosdocumentos = Artigosdocumentoslinhas.jdoGetdocumento(this);
        Artigosdocumentos artigosdocumentos2 = documento;
        Artigosdocumentoslinhas.jdoSetdocumento(this, artigosdocumentos2);
        this.firePropertyChange(FIELDS.artigosdocumentoslinhas_documento, (Object)artigosdocumentos, (Object)artigosdocumentos2);
        this.setKey();
    }

    public Artigos getArtigo() {
        return Artigosdocumentoslinhas.jdoGetartigo(this);
    }

    public boolean hasArtigo() {
        return Artigosdocumentoslinhas.jdoGetartigo(this) != null;
    }

    public void setArtigo(Artigos artigo, Unidadesmedida unidademedida) {
        Artigos artigos = Artigosdocumentoslinhas.jdoGetartigo(this);
        Artigos artigos2 = artigo;
        Artigosdocumentoslinhas.jdoSetartigo(this, artigos2);
        boolean changed = this.firePropertyChange(FIELDS.artigosdocumentoslinhas_artigo, (Object)artigos, (Object)artigos2);
        if (Artigosdocumentoslinhas.jdoGetdocumento((Artigosdocumentoslinhas)this).cascade && this.cascade && changed && artigo != null) {
            this.setDescricao(artigo.getDescricao());
            this.setQuantidade(BigDecimal.ONE);
            this.setUnidademedida(unidademedida);
            this.setPreco(artigo.getPrecocusto(Artigosdocumentoslinhas.jdoGetfactor(this)));
        }
    }

    public void setArtigo(Artigos artigo) {
        this.setArtigo(artigo, artigo == null ? null : artigo.getUnidades(0).getUnidademedida());
    }

    @Deprecated
    public boolean setArtigo$Codigobarras(String codigo) {
        Artigosunidades unidade = this.manager.loadArtigosunidades$Codigobarras(codigo);
        if (unidade != null) {
            Artigos artigo = this.manager.loadArtigos(unidade.getArtigo().getCodigo(), false);
            this.setArtigo(artigo, unidade.getUnidademedida());
            return true;
        }
        return false;
    }

    public boolean setArtigo(String codigo) {
        Artigos artigo = this.manager.loadArtigos(codigo, false);
        if (artigo != null) {
            this.setArtigo(artigo);
            return true;
        }
        return this.setArtigo$Codigobarras(codigo);
    }

    public Unidadesmedida getUnidademedida() {
        return Artigosdocumentoslinhas.jdoGetunidademedida(this);
    }

    public void setUnidademedida(Unidadesmedida unidademedida) {
        Unidadesmedida unidadesmedida = Artigosdocumentoslinhas.jdoGetunidademedida(this);
        Unidadesmedida unidadesmedida2 = unidademedida;
        Artigosdocumentoslinhas.jdoSetunidademedida(this, unidadesmedida2);
        boolean changed = this.firePropertyChange(FIELDS.artigosdocumentoslinhas_unidademedida, (Object)unidadesmedida, (Object)unidadesmedida2);
        if (Artigosdocumentoslinhas.jdoGetdocumento((Artigosdocumentoslinhas)this).cascade && this.cascade && changed && unidademedida != null && Artigosdocumentoslinhas.jdoGetartigo(this) != null) {
            Artigosunidades unidade = Artigosdocumentoslinhas.jdoGetartigo(this).getUnidades(unidademedida);
            if (unidade == null) {
                this.setUnidademedida(Artigosdocumentoslinhas.jdoGetartigo(this).getUnidades(0).getUnidademedida());
            } else {
                this.setFactor(unidade.getFactor());
            }
        }
    }

    public Armazens getArmazemdestino() {
        return Artigosdocumentoslinhas.jdoGetarmazemdestino(this);
    }

    public void setArmazemdestino(Armazens armazemdestino) {
        Armazens armazens = Artigosdocumentoslinhas.jdoGetarmazemdestino(this);
        Armazens armazens2 = armazemdestino;
        Artigosdocumentoslinhas.jdoSetarmazemdestino(this, armazens2);
        this.firePropertyChange(FIELDS.artigosdocumentoslinhas_armazemdestino, (Object)armazens, (Object)armazens2);
    }

    public Armazens getArmazem() {
        return Artigosdocumentoslinhas.jdoGetarmazem(this);
    }

    public void setArmazem(Armazens armazem) {
        Armazens armazens = Artigosdocumentoslinhas.jdoGetarmazem(this);
        Armazens armazens2 = armazem;
        Artigosdocumentoslinhas.jdoSetarmazem(this, armazens2);
        this.firePropertyChange(FIELDS.artigosdocumentoslinhas_armazem, (Object)armazens, (Object)armazens2);
    }

    public Tamanhos getTamanho() {
        return Artigosdocumentoslinhas.jdoGettamanho(this);
    }

    public void setTamanho(Tamanhos tamanho) {
        Tamanhos tamanhos = Artigosdocumentoslinhas.jdoGettamanho(this);
        Tamanhos tamanhos2 = tamanho;
        Artigosdocumentoslinhas.jdoSettamanho(this, tamanhos2);
        this.firePropertyChange(FIELDS.artigosdocumentoslinhas_tamanho, (Object)tamanhos, (Object)tamanhos2);
    }

    public Cores getCor() {
        return Artigosdocumentoslinhas.jdoGetcor(this);
    }

    public void setCor(Cores cor) {
        Cores cores = Artigosdocumentoslinhas.jdoGetcor(this);
        Cores cores2 = cor;
        Artigosdocumentoslinhas.jdoSetcor(this, cores2);
        this.firePropertyChange(FIELDS.artigosdocumentoslinhas_cor, (Object)cores, (Object)cores2);
    }

    public String getDescricao() {
        return Artigosdocumentoslinhas.jdoGetdescricao(this);
    }

    public String getDescricaoToText() {
        return Artigosdocumentoslinhas.jdoGetdescricao(this) == null ? "" : Artigosdocumentoslinhas.jdoGetdescricao(this).toString();
    }

    public void setDescricao(String descricao) {
        String string = Artigosdocumentoslinhas.jdoGetdescricao(this);
        String string2 = descricao;
        Artigosdocumentoslinhas.jdoSetdescricao(this, string2);
        this.firePropertyChange(FIELDS.artigosdocumentoslinhas_descricao, (Object)string, (Object)string2);
    }

    public String getNumeroserie() {
        return Artigosdocumentoslinhas.jdoGetnumeroserie(this);
    }

    public String getNumeroserieToText() {
        return Artigosdocumentoslinhas.jdoGetnumeroserie(this) == null ? "" : Artigosdocumentoslinhas.jdoGetnumeroserie(this).toString();
    }

    public void setNumeroserie(String numeroserie) {
        String string = Artigosdocumentoslinhas.jdoGetnumeroserie(this);
        String string2 = numeroserie;
        Artigosdocumentoslinhas.jdoSetnumeroserie(this, string2);
        boolean changed = this.firePropertyChange(FIELDS.artigosdocumentoslinhas_numeroserie, (Object)string, (Object)string2);
        if (Artigosdocumentoslinhas.jdoGetdocumento((Artigosdocumentoslinhas)this).cascade && this.cascade && changed && numeroserie.isEmpty()) {
            this.setNumeroserie("0");
        }
    }

    public Integer getNumerolinha() {
        return Artigosdocumentoslinhas.jdoGetnumerolinha(this);
    }

    public String getNumerolinhaToText() {
        return Artigosdocumentoslinhas.jdoGetnumerolinha(this) == null ? "" : Artigosdocumentoslinhas.jdoGetnumerolinha(this).toString();
    }

    protected void setNumerolinha(Integer numerolinha) {
        Integer n = Artigosdocumentoslinhas.jdoGetnumerolinha(this);
        Integer n2 = numerolinha;
        Artigosdocumentoslinhas.jdoSetnumerolinha(this, n2);
        this.firePropertyChange(FIELDS.artigosdocumentoslinhas_numerolinha, (Object)n, (Object)n2);
        this.setKey();
    }

    public BigDecimal getFactor() {
        return Artigosdocumentoslinhas.jdoGetfactor(this);
    }

    public String getFactorToText() {
        return Artigosdocumentoslinhas.jdoGetfactor(this) == null ? "" : FIELDS.artigosdocumentoslinhas_factor.format.format(Artigosdocumentoslinhas.jdoGetfactor(this));
    }

    public void setFactor(BigDecimal factor) {
        BigDecimal bigDecimal = Artigosdocumentoslinhas.jdoGetfactor(this);
        BigDecimal bigDecimal2 = factor;
        Artigosdocumentoslinhas.jdoSetfactor(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.artigosdocumentoslinhas_factor, (Object)bigDecimal, (Object)bigDecimal2);
        if (Artigosdocumentoslinhas.jdoGetdocumento((Artigosdocumentoslinhas)this).cascade && this.cascade && changed && Artigosdocumentoslinhas.jdoGetartigo(this) != null) {
            this.setPreco(Artigosdocumentoslinhas.jdoGetartigo(this).getPrecocusto(factor));
        }
    }

    public BigDecimal getQuantidade() {
        return Artigosdocumentoslinhas.jdoGetquantidade(this);
    }

    public String getQuantidadeToText() {
        return Artigosdocumentoslinhas.jdoGetquantidade(this) == null ? "" : FIELDS.artigosdocumentoslinhas_quantidade.format.format(Artigosdocumentoslinhas.jdoGetquantidade(this));
    }

    public void setQuantidade(BigDecimal quantidade) {
        BigDecimal bigDecimal = Artigosdocumentoslinhas.jdoGetquantidade(this);
        BigDecimal bigDecimal2 = quantidade;
        Artigosdocumentoslinhas.jdoSetquantidade(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.artigosdocumentoslinhas_quantidade, (Object)bigDecimal, (Object)bigDecimal2);
        if (Artigosdocumentoslinhas.jdoGetdocumento((Artigosdocumentoslinhas)this).cascade && this.cascade && changed) {
            this.process();
        }
    }

    public BigDecimal addQuantidade(BigDecimal quantidade) {
        this.setQuantidade(Artigosdocumentoslinhas.jdoGetquantidade(this).add(quantidade));
        return Artigosdocumentoslinhas.jdoGetquantidade(this);
    }

    public boolean hasQuantidade() {
        return Artigosdocumentoslinhas.jdoGetquantidade(this).signum() != 0;
    }

    public BigDecimal getPreco() {
        return Artigosdocumentoslinhas.jdoGetpreco(this);
    }

    public String getPrecoToText() {
        return Artigosdocumentoslinhas.jdoGetpreco(this) == null ? "" : FIELDS.artigosdocumentoslinhas_preco.format.format(Artigosdocumentoslinhas.jdoGetpreco(this));
    }

    public void setPreco(BigDecimal preco) {
        BigDecimal bigDecimal = Artigosdocumentoslinhas.jdoGetpreco(this);
        BigDecimal bigDecimal2 = preco;
        Artigosdocumentoslinhas.jdoSetpreco(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.artigosdocumentoslinhas_preco, (Object)bigDecimal, (Object)bigDecimal2);
        if (Artigosdocumentoslinhas.jdoGetdocumento((Artigosdocumentoslinhas)this).cascade && this.cascade && changed) {
            this.process();
        }
    }

    public BigDecimal getValoriliquido() {
        return Artigosdocumentoslinhas.jdoGetvaloriliquido(this);
    }

    public String getValoriliquidoToText() {
        return Artigosdocumentoslinhas.jdoGetvaloriliquido(this) == null ? "" : FIELDS.artigosdocumentoslinhas_valoriliquido.format.format(Artigosdocumentoslinhas.jdoGetvaloriliquido(this));
    }

    public void setValoriliquido(BigDecimal valoriliquido) {
        BigDecimal bigDecimal = Artigosdocumentoslinhas.jdoGetvaloriliquido(this);
        BigDecimal bigDecimal2 = valoriliquido;
        Artigosdocumentoslinhas.jdoSetvaloriliquido(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.artigosdocumentoslinhas_valoriliquido, (Object)bigDecimal, (Object)bigDecimal2);
        if (Artigosdocumentoslinhas.jdoGetdocumento((Artigosdocumentoslinhas)this).cascade && this.cascade && changed) {
            if (this.hasQuantidade()) {
                this.setPreco(valoriliquido.divide(Artigosdocumentoslinhas.jdoGetquantidade(this), MathContext.DECIMAL64));
            }
            this.process();
        }
    }

    public BigDecimal getFormulaquant() {
        return Artigosdocumentoslinhas.jdoGetformulaquant(this);
    }

    public String getFormulaquantToText() {
        return Artigosdocumentoslinhas.jdoGetformulaquant(this) == null ? "" : FIELDS.artigosdocumentoslinhas_formulaquant.format.format(Artigosdocumentoslinhas.jdoGetformulaquant(this));
    }

    public void setFormulaquant(BigDecimal formulaquant) {
        BigDecimal bigDecimal = Artigosdocumentoslinhas.jdoGetformulaquant(this);
        BigDecimal bigDecimal2 = formulaquant;
        Artigosdocumentoslinhas.jdoSetformulaquant(this, bigDecimal2);
        this.firePropertyChange(FIELDS.artigosdocumentoslinhas_formulaquant, (Object)bigDecimal, (Object)bigDecimal2);
    }

    public BigDecimal getFormulavalor1() {
        return Artigosdocumentoslinhas.jdoGetformulavalor1(this);
    }

    public String getFormulavalor1ToText() {
        return Artigosdocumentoslinhas.jdoGetformulavalor1(this) == null ? "" : FIELDS.artigosdocumentoslinhas_formulavalor1.format.format(Artigosdocumentoslinhas.jdoGetformulavalor1(this));
    }

    public void setFormulavalor1(BigDecimal formulavalor1) {
        BigDecimal bigDecimal = Artigosdocumentoslinhas.jdoGetformulavalor1(this);
        BigDecimal bigDecimal2 = formulavalor1;
        Artigosdocumentoslinhas.jdoSetformulavalor1(this, bigDecimal2);
        this.firePropertyChange(FIELDS.artigosdocumentoslinhas_formulavalor1, (Object)bigDecimal, (Object)bigDecimal2);
    }

    public BigDecimal getFormulavalor2() {
        return Artigosdocumentoslinhas.jdoGetformulavalor2(this);
    }

    public String getFormulavalor2ToText() {
        return Artigosdocumentoslinhas.jdoGetformulavalor2(this) == null ? "" : FIELDS.artigosdocumentoslinhas_formulavalor2.format.format(Artigosdocumentoslinhas.jdoGetformulavalor2(this));
    }

    public void setFormulavalor2(BigDecimal formulavalor2) {
        BigDecimal bigDecimal = Artigosdocumentoslinhas.jdoGetformulavalor2(this);
        BigDecimal bigDecimal2 = formulavalor2;
        Artigosdocumentoslinhas.jdoSetformulavalor2(this, bigDecimal2);
        this.firePropertyChange(FIELDS.artigosdocumentoslinhas_formulavalor2, (Object)bigDecimal, (Object)bigDecimal2);
    }

    public BigDecimal getFormulavalor3() {
        return Artigosdocumentoslinhas.jdoGetformulavalor3(this);
    }

    public String getFormulavalor3ToText() {
        return Artigosdocumentoslinhas.jdoGetformulavalor3(this) == null ? "" : FIELDS.artigosdocumentoslinhas_formulavalor3.format.format(Artigosdocumentoslinhas.jdoGetformulavalor3(this));
    }

    public void setFormulavalor3(BigDecimal formulavalor3) {
        BigDecimal bigDecimal = Artigosdocumentoslinhas.jdoGetformulavalor3(this);
        BigDecimal bigDecimal2 = formulavalor3;
        Artigosdocumentoslinhas.jdoSetformulavalor3(this, bigDecimal2);
        this.firePropertyChange(FIELDS.artigosdocumentoslinhas_formulavalor3, (Object)bigDecimal, (Object)bigDecimal2);
    }

    public BigDecimal getFormulavalor4() {
        return Artigosdocumentoslinhas.jdoGetformulavalor4(this);
    }

    public String getFormulavalor4ToText() {
        return Artigosdocumentoslinhas.jdoGetformulavalor4(this) == null ? "" : FIELDS.artigosdocumentoslinhas_formulavalor4.format.format(Artigosdocumentoslinhas.jdoGetformulavalor4(this));
    }

    public void setFormulavalor4(BigDecimal formulavalor4) {
        BigDecimal bigDecimal = Artigosdocumentoslinhas.jdoGetformulavalor4(this);
        BigDecimal bigDecimal2 = formulavalor4;
        Artigosdocumentoslinhas.jdoSetformulavalor4(this, bigDecimal2);
        this.firePropertyChange(FIELDS.artigosdocumentoslinhas_formulavalor4, (Object)bigDecimal, (Object)bigDecimal2);
    }

    @Override
    public boolean isEditable(FIELDS field) {
        return field != FIELDS.artigosdocumentoslinhas_numerolinha;
    }

    @Override
    public void attach(DatabaseManager manager) {
        manager.attach(new AbstractModel[]{Artigosdocumentoslinhas.jdoGetdocumento(this), Artigosdocumentoslinhas.jdoGetartigo(this), Artigosdocumentoslinhas.jdoGetunidademedida(this), Artigosdocumentoslinhas.jdoGetarmazemdestino(this), Artigosdocumentoslinhas.jdoGetarmazem(this), Artigosdocumentoslinhas.jdoGettamanho(this), Artigosdocumentoslinhas.jdoGetcor(this)});
    }

    public String toString() {
        return Artigosdocumentoslinhas.jdoGetkey(this);
    }

    public int hashCode() {
        return Artigosdocumentoslinhas.jdoGetkey(this) == null ? 0 : Artigosdocumentoslinhas.jdoGetkey(this).hashCode();
    }

    public boolean equals(Object obj) {
        return this.hashCode() == obj.hashCode();
    }

    static {
        jdoFieldNames = Artigosdocumentoslinhas.__jdoFieldNamesInit();
        jdoFieldTypes = Artigosdocumentoslinhas.__jdoFieldTypesInit();
        jdoFieldFlags = Artigosdocumentoslinhas.__jdoFieldFlagsInit();
        jdoInheritedFieldCount = Artigosdocumentoslinhas.__jdoGetInheritedFieldCount();
        jdoPersistenceCapableSuperclass = Artigosdocumentoslinhas.__jdoPersistenceCapableSuperclassInit();
        JDOImplHelper.registerClass((Class)Artigosdocumentoslinhas.___jdo$loadClass("org.projectocolibri.api.database.model.Artigosdocumentoslinhas"), (String[])jdoFieldNames, (Class[])jdoFieldTypes, (byte[])jdoFieldFlags, (Class)jdoPersistenceCapableSuperclass, (PersistenceCapable)new Artigosdocumentoslinhas());
    }

    public void jdoCopyKeyFieldsFromObjectId(PersistenceCapable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("oid is not instanceof javax.jdo.identity.StringIdentity");
        }
        StringIdentity o = (StringIdentity)oid;
        fc.storeStringField(12, o.getKey());
    }

    protected void jdoCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("key class is not javax.jdo.identity.StringIdentity or null");
        }
        StringIdentity o = (StringIdentity)oid;
        this.key = o.getKey();
    }

    public final void jdoCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final void jdoCopyKeyFieldsToObjectId(PersistenceCapable.ObjectIdFieldSupplier fs, Object object) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final Object jdoGetObjectId() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getObjectId((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[0];
    }

    public final Object jdoGetVersion() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getVersion((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[1];
    }

    protected final void jdoPreSerialize() {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.preSerialize((PersistenceCapable)this);
        }
    }

    public final PersistenceManager jdoGetPersistenceManager() {
        return this.jdoStateManager != null ? this.jdoStateManager.getPersistenceManager((PersistenceCapable)this) : null;
    }

    public final Object jdoGetTransactionalObjectId() {
        return this.jdoStateManager != null ? this.jdoStateManager.getTransactionalObjectId((PersistenceCapable)this) : null;
    }

    public final boolean jdoIsDeleted() {
        return this.jdoStateManager != null ? this.jdoStateManager.isDeleted((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsDirty() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.isDirty((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return false;
        }
        return ((BitSet)this.jdoDetachedState[3]).length() > 0;
    }

    public final boolean jdoIsNew() {
        return this.jdoStateManager != null ? this.jdoStateManager.isNew((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsPersistent() {
        return this.jdoStateManager != null ? this.jdoStateManager.isPersistent((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsTransactional() {
        return this.jdoStateManager != null ? this.jdoStateManager.isTransactional((PersistenceCapable)this) : false;
    }

    public void jdoMakeDirty(String fieldName) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.makeDirty((PersistenceCapable)this, fieldName);
        }
        if (this.jdoIsDetached() && fieldName != null) {
            String fldName = null;
            fldName = fieldName.indexOf(46) >= 0 ? fieldName.substring(fieldName.lastIndexOf(46) + 1) : fieldName;
            int i = 0;
            while (i < jdoFieldNames.length) {
                if (jdoFieldNames[i].equals(fldName)) {
                    if (!((BitSet)this.jdoDetachedState[2]).get(i + jdoInheritedFieldCount)) {
                        throw new JDODetachedFieldAccessException("You have just attempted to access a field/property that hasn't been detached. Please detach it first before performing this operation");
                    }
                    ((BitSet)this.jdoDetachedState[3]).set(i + jdoInheritedFieldCount);
                    return;
                }
                ++i;
            }
        }
    }

    public final Object jdoNewObjectIdInstance() {
        return new StringIdentity(this.getClass(), this.key);
    }

    public final Object jdoNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new StringIdentity(this.getClass(), (String)key);
        }
        return new StringIdentity(this.getClass(), (String)key);
    }

    public final void jdoProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void jdoReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.jdoReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void jdoReplaceFlags() {
        if (this.jdoStateManager != null) {
            this.jdoFlags = this.jdoStateManager.replacingFlags((PersistenceCapable)this);
        }
    }

    public final synchronized void jdoReplaceStateManager(StateManager sm) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager = this.jdoStateManager.replacingStateManager((PersistenceCapable)this, sm);
        } else {
            JDOImplHelper.checkAuthorizedStateManager((StateManager)sm);
            this.jdoStateManager = sm;
            this.jdoFlags = 1;
        }
    }

    public final synchronized void jdoReplaceDetachedState() {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        this.jdoDetachedState = this.jdoStateManager.replacingDetachedState((Detachable)this, this.jdoDetachedState);
    }

    public boolean jdoIsDetached() {
        return this.jdoStateManager == null && this.jdoDetachedState != null;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm) {
        Artigosdocumentoslinhas result = new Artigosdocumentoslinhas();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        return result;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm, Object obj) {
        Artigosdocumentoslinhas result = new Artigosdocumentoslinhas();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        result.jdoCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void jdoReplaceField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.armazem = (Armazens)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 1: {
                this.armazemdestino = (Armazens)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 2: {
                this.artigo = (Artigos)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 3: {
                this.cor = (Cores)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 4: {
                this.descricao = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 5: {
                this.documento = (Artigosdocumentos)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 6: {
                this.factor = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 7: {
                this.formulaquant = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 8: {
                this.formulavalor1 = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 9: {
                this.formulavalor2 = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 10: {
                this.formulavalor3 = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 11: {
                this.formulavalor4 = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 12: {
                this.key = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 13: {
                this.numerolinha = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 14: {
                this.numeroserie = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 15: {
                this.preco = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 16: {
                this.quantidade = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 17: {
                this.tamanho = (Tamanhos)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 18: {
                this.unidademedida = (Unidadesmedida)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 19: {
                this.valoriliquido = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoProvideField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.armazem);
                break;
            }
            case 1: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.armazemdestino);
                break;
            }
            case 2: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.artigo);
                break;
            }
            case 3: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.cor);
                break;
            }
            case 4: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.descricao);
                break;
            }
            case 5: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.documento);
                break;
            }
            case 6: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.factor);
                break;
            }
            case 7: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.formulaquant);
                break;
            }
            case 8: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.formulavalor1);
                break;
            }
            case 9: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.formulavalor2);
                break;
            }
            case 10: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.formulavalor3);
                break;
            }
            case 11: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.formulavalor4);
                break;
            }
            case 12: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.key);
                break;
            }
            case 13: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.numerolinha);
                break;
            }
            case 14: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.numeroserie);
                break;
            }
            case 15: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.preco);
                break;
            }
            case 16: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.quantidade);
                break;
            }
            case 17: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.tamanho);
                break;
            }
            case 18: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.unidademedida);
                break;
            }
            case 19: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.valoriliquido);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void jdoCopyField(Artigosdocumentoslinhas obj, int index) {
        switch (index) {
            case 0: {
                this.armazem = obj.armazem;
                break;
            }
            case 1: {
                this.armazemdestino = obj.armazemdestino;
                break;
            }
            case 2: {
                this.artigo = obj.artigo;
                break;
            }
            case 3: {
                this.cor = obj.cor;
                break;
            }
            case 4: {
                this.descricao = obj.descricao;
                break;
            }
            case 5: {
                this.documento = obj.documento;
                break;
            }
            case 6: {
                this.factor = obj.factor;
                break;
            }
            case 7: {
                this.formulaquant = obj.formulaquant;
                break;
            }
            case 8: {
                this.formulavalor1 = obj.formulavalor1;
                break;
            }
            case 9: {
                this.formulavalor2 = obj.formulavalor2;
                break;
            }
            case 10: {
                this.formulavalor3 = obj.formulavalor3;
                break;
            }
            case 11: {
                this.formulavalor4 = obj.formulavalor4;
                break;
            }
            case 12: {
                this.key = obj.key;
                break;
            }
            case 13: {
                this.numerolinha = obj.numerolinha;
                break;
            }
            case 14: {
                this.numeroserie = obj.numeroserie;
                break;
            }
            case 15: {
                this.preco = obj.preco;
                break;
            }
            case 16: {
                this.quantidade = obj.quantidade;
                break;
            }
            case 17: {
                this.tamanho = obj.tamanho;
                break;
            }
            case 18: {
                this.unidademedida = obj.unidademedida;
                break;
            }
            case 19: {
                this.valoriliquido = obj.valoriliquido;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoCopyFields(Object obj, int[] indices) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof Artigosdocumentoslinhas)) {
            throw new IllegalArgumentException("object is not an object of type org.projectocolibri.api.database.model.Artigosdocumentoslinhas");
        }
        Artigosdocumentoslinhas other = (Artigosdocumentoslinhas)obj;
        if (this.jdoStateManager != other.jdoStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __jdoFieldNamesInit() {
        return new String[]{"armazem", "armazemdestino", "artigo", "cor", "descricao", "documento", "factor", "formulaquant", "formulavalor1", "formulavalor2", "formulavalor3", "formulavalor4", "key", "numerolinha", "numeroserie", "preco", "quantidade", "tamanho", "unidademedida", "valoriliquido"};
    }

    private static final Class[] __jdoFieldTypesInit() {
        return new Class[]{Artigosdocumentoslinhas.___jdo$loadClass("org.projectocolibri.api.database.model.Armazens"), Artigosdocumentoslinhas.___jdo$loadClass("org.projectocolibri.api.database.model.Armazens"), Artigosdocumentoslinhas.___jdo$loadClass("org.projectocolibri.api.database.model.Artigos"), Artigosdocumentoslinhas.___jdo$loadClass("org.projectocolibri.api.database.model.Cores"), Artigosdocumentoslinhas.___jdo$loadClass("java.lang.String"), Artigosdocumentoslinhas.___jdo$loadClass("org.projectocolibri.api.database.model.Artigosdocumentos"), Artigosdocumentoslinhas.___jdo$loadClass("java.math.BigDecimal"), Artigosdocumentoslinhas.___jdo$loadClass("java.math.BigDecimal"), Artigosdocumentoslinhas.___jdo$loadClass("java.math.BigDecimal"), Artigosdocumentoslinhas.___jdo$loadClass("java.math.BigDecimal"), Artigosdocumentoslinhas.___jdo$loadClass("java.math.BigDecimal"), Artigosdocumentoslinhas.___jdo$loadClass("java.math.BigDecimal"), Artigosdocumentoslinhas.___jdo$loadClass("java.lang.String"), Artigosdocumentoslinhas.___jdo$loadClass("java.lang.Integer"), Artigosdocumentoslinhas.___jdo$loadClass("java.lang.String"), Artigosdocumentoslinhas.___jdo$loadClass("java.math.BigDecimal"), Artigosdocumentoslinhas.___jdo$loadClass("java.math.BigDecimal"), Artigosdocumentoslinhas.___jdo$loadClass("org.projectocolibri.api.database.model.Tamanhos"), Artigosdocumentoslinhas.___jdo$loadClass("org.projectocolibri.api.database.model.Unidadesmedida"), Artigosdocumentoslinhas.___jdo$loadClass("java.math.BigDecimal")};
    }

    private static final byte[] __jdoFieldFlagsInit() {
        return new byte[]{5, 5, 5, 5, 21, 5, 21, 21, 21, 21, 21, 21, 24, 21, 21, 21, 21, 5, 5, 21};
    }

    protected static int __jdoGetInheritedFieldCount() {
        return 0;
    }

    protected static int jdoGetManagedFieldCount() {
        return 20;
    }

    private static Class __jdoPersistenceCapableSuperclassInit() {
        return null;
    }

    public static Class ___jdo$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object jdoSuperClone() throws CloneNotSupportedException {
        Artigosdocumentoslinhas o = (Artigosdocumentoslinhas)super.clone();
        o.jdoFlags = 0;
        o.jdoStateManager = null;
        return o;
    }

    private static Armazens jdoGetarmazem(Artigosdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 0)) {
            return (Armazens)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 0, (Object)objPC.armazem);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(0)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"armazem\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.armazem;
    }

    private static void jdoSetarmazem(Artigosdocumentoslinhas objPC, Armazens val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 0, (Object)objPC.armazem, (Object)val);
        } else {
            objPC.armazem = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(0);
            }
        }
    }

    private static Armazens jdoGetarmazemdestino(Artigosdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 1)) {
            return (Armazens)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 1, (Object)objPC.armazemdestino);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(1)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"armazemdestino\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.armazemdestino;
    }

    private static void jdoSetarmazemdestino(Artigosdocumentoslinhas objPC, Armazens val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 1, (Object)objPC.armazemdestino, (Object)val);
        } else {
            objPC.armazemdestino = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(1);
            }
        }
    }

    private static Artigos jdoGetartigo(Artigosdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 2)) {
            return (Artigos)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 2, (Object)objPC.artigo);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(2)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"artigo\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.artigo;
    }

    private static void jdoSetartigo(Artigosdocumentoslinhas objPC, Artigos val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 2, (Object)objPC.artigo, (Object)val);
        } else {
            objPC.artigo = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(2);
            }
        }
    }

    private static Cores jdoGetcor(Artigosdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 3)) {
            return (Cores)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 3, (Object)objPC.cor);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(3)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"cor\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.cor;
    }

    private static void jdoSetcor(Artigosdocumentoslinhas objPC, Cores val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 3, (Object)objPC.cor, (Object)val);
        } else {
            objPC.cor = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(3);
            }
        }
    }

    private static String jdoGetdescricao(Artigosdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 4)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 4, objPC.descricao);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(4)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"descricao\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.descricao;
    }

    private static void jdoSetdescricao(Artigosdocumentoslinhas objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 4, objPC.descricao, val);
        } else {
            objPC.descricao = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(4);
            }
        }
    }

    private static Artigosdocumentos jdoGetdocumento(Artigosdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 5)) {
            return (Artigosdocumentos)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 5, (Object)objPC.documento);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(5)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"documento\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.documento;
    }

    private static void jdoSetdocumento(Artigosdocumentoslinhas objPC, Artigosdocumentos val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 5, (Object)objPC.documento, (Object)val);
        } else {
            objPC.documento = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(5);
            }
        }
    }

    private static BigDecimal jdoGetfactor(Artigosdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 6)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 6, (Object)objPC.factor);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(6)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"factor\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.factor;
    }

    private static void jdoSetfactor(Artigosdocumentoslinhas objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 6, (Object)objPC.factor, (Object)val);
        } else {
            objPC.factor = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(6);
            }
        }
    }

    private static BigDecimal jdoGetformulaquant(Artigosdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 7)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 7, (Object)objPC.formulaquant);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(7)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"formulaquant\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.formulaquant;
    }

    private static void jdoSetformulaquant(Artigosdocumentoslinhas objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 7, (Object)objPC.formulaquant, (Object)val);
        } else {
            objPC.formulaquant = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(7);
            }
        }
    }

    private static BigDecimal jdoGetformulavalor1(Artigosdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 8)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 8, (Object)objPC.formulavalor1);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(8)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"formulavalor1\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.formulavalor1;
    }

    private static void jdoSetformulavalor1(Artigosdocumentoslinhas objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 8, (Object)objPC.formulavalor1, (Object)val);
        } else {
            objPC.formulavalor1 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(8);
            }
        }
    }

    private static BigDecimal jdoGetformulavalor2(Artigosdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 9)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 9, (Object)objPC.formulavalor2);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(9)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"formulavalor2\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.formulavalor2;
    }

    private static void jdoSetformulavalor2(Artigosdocumentoslinhas objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 9, (Object)objPC.formulavalor2, (Object)val);
        } else {
            objPC.formulavalor2 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(9);
            }
        }
    }

    private static BigDecimal jdoGetformulavalor3(Artigosdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 10)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 10, (Object)objPC.formulavalor3);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(10)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"formulavalor3\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.formulavalor3;
    }

    private static void jdoSetformulavalor3(Artigosdocumentoslinhas objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 10, (Object)objPC.formulavalor3, (Object)val);
        } else {
            objPC.formulavalor3 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(10);
            }
        }
    }

    private static BigDecimal jdoGetformulavalor4(Artigosdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 11)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 11, (Object)objPC.formulavalor4);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(11)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"formulavalor4\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.formulavalor4;
    }

    private static void jdoSetformulavalor4(Artigosdocumentoslinhas objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 11, (Object)objPC.formulavalor4, (Object)val);
        } else {
            objPC.formulavalor4 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(11);
            }
        }
    }

    private static String jdoGetkey(Artigosdocumentoslinhas objPC) {
        return objPC.key;
    }

    private static void jdoSetkey(Artigosdocumentoslinhas objPC, String val) {
        if (objPC.jdoStateManager == null) {
            objPC.key = val;
        } else {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 12, objPC.key, val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(12);
        }
    }

    private static Integer jdoGetnumerolinha(Artigosdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 13)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 13, (Object)objPC.numerolinha);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(13)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"numerolinha\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.numerolinha;
    }

    private static void jdoSetnumerolinha(Artigosdocumentoslinhas objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 13, (Object)objPC.numerolinha, (Object)val);
        } else {
            objPC.numerolinha = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(13);
            }
        }
    }

    private static String jdoGetnumeroserie(Artigosdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 14)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 14, objPC.numeroserie);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(14)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"numeroserie\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.numeroserie;
    }

    private static void jdoSetnumeroserie(Artigosdocumentoslinhas objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 14, objPC.numeroserie, val);
        } else {
            objPC.numeroserie = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(14);
            }
        }
    }

    private static BigDecimal jdoGetpreco(Artigosdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 15)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 15, (Object)objPC.preco);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(15)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"preco\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.preco;
    }

    private static void jdoSetpreco(Artigosdocumentoslinhas objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 15, (Object)objPC.preco, (Object)val);
        } else {
            objPC.preco = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(15);
            }
        }
    }

    private static BigDecimal jdoGetquantidade(Artigosdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 16)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 16, (Object)objPC.quantidade);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(16)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"quantidade\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.quantidade;
    }

    private static void jdoSetquantidade(Artigosdocumentoslinhas objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 16, (Object)objPC.quantidade, (Object)val);
        } else {
            objPC.quantidade = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(16);
            }
        }
    }

    private static Tamanhos jdoGettamanho(Artigosdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 17)) {
            return (Tamanhos)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 17, (Object)objPC.tamanho);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(17)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"tamanho\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.tamanho;
    }

    private static void jdoSettamanho(Artigosdocumentoslinhas objPC, Tamanhos val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 17, (Object)objPC.tamanho, (Object)val);
        } else {
            objPC.tamanho = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(17);
            }
        }
    }

    private static Unidadesmedida jdoGetunidademedida(Artigosdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 18)) {
            return (Unidadesmedida)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 18, (Object)objPC.unidademedida);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(18)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"unidademedida\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.unidademedida;
    }

    private static void jdoSetunidademedida(Artigosdocumentoslinhas objPC, Unidadesmedida val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 18, (Object)objPC.unidademedida, (Object)val);
        } else {
            objPC.unidademedida = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(18);
            }
        }
    }

    private static BigDecimal jdoGetvaloriliquido(Artigosdocumentoslinhas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 19)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 19, (Object)objPC.valoriliquido);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(19)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"valoriliquido\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.valoriliquido;
    }

    private static void jdoSetvaloriliquido(Artigosdocumentoslinhas objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 19, (Object)objPC.valoriliquido, (Object)val);
        } else {
            objPC.valoriliquido = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(19);
            }
        }
    }
}

