/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.jdo.JDODetachedFieldAccessException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.PersistenceManager;
import javax.jdo.identity.StringIdentity;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;
import org.dma.java.util.ErrorList;
import org.dma.java.util.MessageLine;
import org.dma.java.util.MessageList;
import org.dma.java.util.TimeDateUtils;
import org.dma.services.mb.MultibancoRef;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.birt.render.BIRTRender;
import org.projectocolibri.api.birt.report.BIRTReport;
import org.projectocolibri.api.birt.report.BIRTReportCopies;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.IDatabaseModel;
import org.projectocolibri.api.database.IDocumentoModel;
import org.projectocolibri.api.database.filter.FilterMap;
import org.projectocolibri.api.database.filter.FilterMapRule;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.AbstractModel;
import org.projectocolibri.api.database.model.Artigosdocumentoslinhas;
import org.projectocolibri.api.database.model.Documentosseries;
import org.projectocolibri.api.database.model.Documentostipos;
import org.projectocolibri.api.database.model.Templates;
import org.projectocolibri.api.database.model.Utilizadores;
import org.projectocolibri.api.database.model.paste.ArtigosdocumentosPaste;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.xml.beans.saft.ATMessageFormatter;

@javax.jdo.annotations.PersistenceCapable
public class Artigosdocumentos
extends AbstractModel
implements IDocumentoModel,
Detachable,
PersistenceCapable {
    private String key;
    private Utilizadores autor;
    private Utilizadores editor;
    private Templates template;
    private Documentostipos tipodocumento;
    private Documentosseries seriedocumento;
    private Date datasistema;
    private Date datacriacao;
    private Date dataauxiliar;
    private Date datacarga;
    private Time horacarga;
    private Date datadescarga;
    private Time horadescarga;
    private String numeroauxiliar;
    private String expedicao;
    private String matricula;
    private String localcarga;
    private String localdescarga;
    private String obs;
    private Integer numerodocumento;
    private BigDecimal total;
    private List<Artigosdocumentoslinhas> linhasdocumento = new ArrayList<Artigosdocumentoslinhas>();
    protected transient StateManager jdoStateManager;
    protected transient byte jdoFlags;
    protected Object[] jdoDetachedState;
    private static final byte[] jdoFieldFlags;
    private static final Class jdoPersistenceCapableSuperclass;
    private static final Class[] jdoFieldTypes;
    private static final String[] jdoFieldNames;
    private static final int jdoInheritedFieldCount;

    public ArtigosdocumentosPaste paste() {
        return new ArtigosdocumentosPaste(this);
    }

    private Artigosdocumentos() {
        super(TABLES.artigosdocumentos);
    }

    private Artigosdocumentos(DatabaseManager manager) {
        super(TABLES.artigosdocumentos, manager);
    }

    public Artigosdocumentos(DatabaseManager manager, String tipodocumento) {
        this(manager, tipodocumento, TimeDateUtils.getCurrentDate());
    }

    public Artigosdocumentos(DatabaseManager manager, String tipodocumento, Date datacriacao) {
        this(manager, manager.loadDocumentostipos(tipodocumento), datacriacao);
    }

    protected Artigosdocumentos(DatabaseManager manager, Documentostipos tipodocumento, Date datacriacao) {
        this(manager);
        this.autor = manager.getUtilizador();
        this.editor = manager.getUtilizador();
        this.template = tipodocumento.getTemplate(0);
        this.tipodocumento = tipodocumento;
        this.seriedocumento = manager.loadDocumentosseries(tipodocumento.getCodigo(), 0);
        this.datasistema = TimeDateUtils.getDateWithoutTime((Date)datacriacao);
        this.datacriacao = TimeDateUtils.getDateWithoutTime((Date)datacriacao);
        this.dataauxiliar = TimeDateUtils.getDateWithoutTime((Date)datacriacao);
        this.datacarga = TimeDateUtils.getDateWithoutTime((Date)datacriacao);
        this.horacarga = TimeDateUtils.getTimeWithoutSeconds((Date)datacriacao);
        this.datadescarga = TimeDateUtils.getDateWithoutTime((Date)datacriacao);
        this.horadescarga = TimeDateUtils.getTimeWithoutSeconds((Date)datacriacao);
        this.numeroauxiliar = "";
        this.expedicao = "";
        this.matricula = "";
        this.localcarga = tipodocumento.getArmazemcarga().getMorada();
        this.localdescarga = tipodocumento.getArmazemdescarga().getMorada();
        this.obs = "";
        this.numerodocumento = this.getNumerodocumento$Default();
        this.total = BigDecimal.ZERO;
        this.key = this.generateKey();
    }

    @Override
    public Artigosdocumentos cloneCopy() {
        Artigosdocumentos clone = new Artigosdocumentos(this.manager);
        Artigosdocumentos.jdoSetkey(clone, Artigosdocumentos.jdoGetkey(this));
        Artigosdocumentos.jdoSetautor(clone, Artigosdocumentos.jdoGetautor(this));
        Artigosdocumentos.jdoSeteditor(clone, Artigosdocumentos.jdoGeteditor(this));
        Artigosdocumentos.jdoSettemplate(clone, Artigosdocumentos.jdoGettemplate(this));
        Artigosdocumentos.jdoSettipodocumento(clone, Artigosdocumentos.jdoGettipodocumento(this));
        Artigosdocumentos.jdoSetseriedocumento(clone, Artigosdocumentos.jdoGetseriedocumento(this));
        Artigosdocumentos.jdoSetdatasistema(clone, Artigosdocumentos.jdoGetdatasistema(this));
        Artigosdocumentos.jdoSetdatacriacao(clone, Artigosdocumentos.jdoGetdatacriacao(this));
        Artigosdocumentos.jdoSetdataauxiliar(clone, Artigosdocumentos.jdoGetdataauxiliar(this));
        Artigosdocumentos.jdoSetdatacarga(clone, Artigosdocumentos.jdoGetdatacarga(this));
        Artigosdocumentos.jdoSethoracarga(clone, Artigosdocumentos.jdoGethoracarga(this));
        Artigosdocumentos.jdoSetdatadescarga(clone, Artigosdocumentos.jdoGetdatadescarga(this));
        Artigosdocumentos.jdoSethoradescarga(clone, Artigosdocumentos.jdoGethoradescarga(this));
        Artigosdocumentos.jdoSetnumeroauxiliar(clone, Artigosdocumentos.jdoGetnumeroauxiliar(this));
        Artigosdocumentos.jdoSetexpedicao(clone, Artigosdocumentos.jdoGetexpedicao(this));
        Artigosdocumentos.jdoSetmatricula(clone, Artigosdocumentos.jdoGetmatricula(this));
        Artigosdocumentos.jdoSetlocalcarga(clone, Artigosdocumentos.jdoGetlocalcarga(this));
        Artigosdocumentos.jdoSetlocaldescarga(clone, Artigosdocumentos.jdoGetlocaldescarga(this));
        Artigosdocumentos.jdoSetobs(clone, Artigosdocumentos.jdoGetobs(this));
        Artigosdocumentos.jdoSetnumerodocumento(clone, Artigosdocumentos.jdoGetnumerodocumento(this));
        Artigosdocumentos.jdoSettotal(clone, Artigosdocumentos.jdoGettotal(this));
        ArrayList<Artigosdocumentoslinhas> linhasdocumento = new ArrayList<Artigosdocumentoslinhas>();
        for (Artigosdocumentoslinhas linha : Artigosdocumentos.jdoGetlinhasdocumento(this)) {
            linhasdocumento.add(linha.cloneCopy(clone));
        }
        Artigosdocumentos.jdoSetlinhasdocumento(clone, linhasdocumento);
        return clone;
    }

    public Artigosdocumentos cleanCopy() {
        Artigosdocumentos clone = this.cloneCopy();
        Artigosdocumentos.jdoSetseriedocumento(clone, this.manager.loadDocumentosseries(Artigosdocumentos.jdoGettipodocumento(this).getCodigo(), 0));
        Artigosdocumentos.jdoSetautor(clone, this.manager.getUtilizador());
        Artigosdocumentos.jdoSeteditor(clone, this.manager.getUtilizador());
        Artigosdocumentos.jdoSettemplate(clone, Artigosdocumentos.jdoGettipodocumento(clone).getTemplate(0));
        Date datacriacao = TimeDateUtils.getCurrentDate();
        Artigosdocumentos.jdoSetdatasistema(clone, TimeDateUtils.getDateWithoutTime((Date)datacriacao));
        Artigosdocumentos.jdoSetdatacriacao(clone, TimeDateUtils.getDateWithoutTime((Date)datacriacao));
        Artigosdocumentos.jdoSetdataauxiliar(clone, TimeDateUtils.getDateWithoutTime((Date)datacriacao));
        Artigosdocumentos.jdoSetdatacarga(clone, TimeDateUtils.getDateWithoutTime((Date)datacriacao));
        Artigosdocumentos.jdoSethoracarga(clone, TimeDateUtils.getTimeWithoutSeconds((Date)datacriacao));
        Artigosdocumentos.jdoSetdatadescarga(clone, TimeDateUtils.getDateWithoutTime((Date)datacriacao));
        Artigosdocumentos.jdoSethoradescarga(clone, TimeDateUtils.getTimeWithoutSeconds((Date)datacriacao));
        Artigosdocumentos.jdoSetnumerodocumento(clone, clone.getNumerodocumento$Default());
        clone.setKey();
        clone.markDirty();
        return clone;
    }

    @Override
    public MessageList validate(IDatabaseModel.ACTION action) {
        MessageList error = super.validate(action);
        for (Artigosdocumentoslinhas linha : Artigosdocumentos.jdoGetlinhasdocumento(this)) {
            error.add(linha.validate(action));
        }
        switch (action) {
            case DELETE: {
                break;
            }
            case STORE: {
                Artigosdocumentos clone = this.cloneCopy().process();
                for (Artigosdocumentoslinhas linha : Artigosdocumentos.jdoGetlinhasdocumento(this)) {
                    error.add(linha.validate(clone.getLinhasdocumento(linha.getKey()), new FIELDS[0]).prefix(LABELS.artigosdocumentos_linhasdocumento.toString()));
                }
                error.add(this.validate(clone, new FIELDS[0]));
                if (Artigosdocumentos.jdoGetlinhasdocumento(this).size() == 0) {
                    error.add((Object)new MessageLine((Object)LABELS.artigosdocumentos_linhasdocumento).brackets((Object)LABELS.valor_vazio));
                }
                if (!this.isSeriedocumentoValid()) {
                    error.add((Object)new MessageLine((Object)LABELS.artigosdocumentos_seriedocumento));
                }
                if (!this.isNumerodocumentoValid()) {
                    error.add((Object)new MessageLine((Object)LABELS.artigosdocumentos_numerodocumento));
                }
                if (this.isNumeroauxiliarValid()) break;
                error.add((Object)new MessageLine((Object)LABELS.artigosdocumentos_numeroauxiliar));
            }
        }
        return error;
    }

    public ErrorList warnings() {
        ErrorList error = new ErrorList();
        for (Artigosdocumentoslinhas linha : Artigosdocumentos.jdoGetlinhasdocumento(this)) {
            error.add(linha.warnings());
        }
        return error;
    }

    Artigosdocumentos process() {
        if (!this.busy) {
            this.busy = true;
            boolean cascade = this.setCascade(false);
            BigDecimal totaliliquido = BigDecimal.ZERO;
            for (Artigosdocumentoslinhas linha : Artigosdocumentos.jdoGetlinhasdocumento(this)) {
                totaliliquido = totaliliquido.add(linha.getValoriliquido());
            }
            this.setTotal(FIELDS.artigosdocumentos_total.format.setScale(totaliliquido, RoundingMode.HALF_EVEN));
            this.setCascade(cascade);
            this.busy = false;
        }
        return this;
    }

    @Override
    public BIRTReport createReport() {
        return new BIRTReport(Artigosdocumentos.jdoGettemplate(this)){

            @Override
            public FilterMap getFilterMap() {
                return new FilterMap(TABLES.artigosdocumentos).addRule(new FilterMapRule(FIELDS.artigosdocumentos_key).equal(Artigosdocumentos.jdoGetkey(Artigosdocumentos.this)));
            }
        };
    }

    @Override
    public Artigosdocumentos reportCopy() {
        return this.cloneCopy();
    }

    @Override
    public BIRTReportCopies getReportCopies(BIRTReport.REPORT_ACTIONS action) {
        return Artigosdocumentos.jdoGettipodocumento(this).getReportCopies(action);
    }

    @Override
    public BIRTRender.BACKGROUND getReportBackground() {
        return this.manager.getLicenca().isFormacao() ? BIRTRender.BACKGROUND.DRAFT : BIRTRender.BACKGROUND.NONE;
    }

    @Override
    public String getReportTtitle() {
        return Artigosdocumentos.jdoGettipodocumento(this).getTituloToText();
    }

    @Override
    public String getReportMessage() {
        return PROCESSADO_COMPUTADOR;
    }

    @Override
    public MultibancoRef getMultibanco() {
        return MultibancoRef.DEFAULT;
    }

    @Override
    public String getATCUD() {
        return "";
    }

    @Override
    public byte[] getATQRCode() {
        return null;
    }

    @Override
    public String getDocumentcode() {
        return "";
    }

    @Override
    public Integer getContadorvias() {
        return 0;
    }

    @Override
    public void incrementContadorvias() {
    }

    @Override
    public String getKey() {
        return Artigosdocumentos.jdoGetkey(this);
    }

    public void setKey(String key) {
        String string = Artigosdocumentos.jdoGetkey(this);
        String string2 = key;
        Artigosdocumentos.jdoSetkey(this, string2);
        this.firePropertyChange(FIELDS.artigosdocumentos_key, (Object)string, (Object)string2);
    }

    void setKey() {
        this.setKey(this.generateKey());
        for (Artigosdocumentoslinhas linha : Artigosdocumentos.jdoGetlinhasdocumento(this)) {
            linha.setKey();
        }
    }

    String generateKey() {
        return Artigosdocumentos.jdoGettipodocumento(this) == null || Artigosdocumentos.jdoGetseriedocumento(this) == null || Artigosdocumentos.jdoGetnumerodocumento(this) == null ? null : Artigosdocumentos.generateKey(Artigosdocumentos.jdoGettipodocumento(this).getCodigo(), Artigosdocumentos.jdoGetseriedocumento(this).getSerie(), Artigosdocumentos.jdoGetnumerodocumento(this));
    }

    public static String generateKey(String tipodocumento, String serie, Integer numerodocumento) {
        return String.valueOf(Documentosseries.generateKey(tipodocumento, serie)) + ":" + numerodocumento;
    }

    public Utilizadores getAutor() {
        return Artigosdocumentos.jdoGetautor(this);
    }

    public void setAutor(Utilizadores autor) {
        Utilizadores utilizadores = Artigosdocumentos.jdoGetautor(this);
        Utilizadores utilizadores2 = autor;
        Artigosdocumentos.jdoSetautor(this, utilizadores2);
        this.firePropertyChange(FIELDS.artigosdocumentos_autor, (Object)utilizadores, (Object)utilizadores2);
    }

    public Utilizadores getEditor() {
        return Artigosdocumentos.jdoGeteditor(this);
    }

    public void setEditor(Utilizadores editor) {
        Utilizadores utilizadores = Artigosdocumentos.jdoGeteditor(this);
        Utilizadores utilizadores2 = editor;
        Artigosdocumentos.jdoSeteditor(this, utilizadores2);
        this.firePropertyChange(FIELDS.artigosdocumentos_editor, (Object)utilizadores, (Object)utilizadores2);
    }

    @Override
    public Templates getTemplate() {
        return Artigosdocumentos.jdoGettemplate(this);
    }

    public void setTemplate(Templates template) {
        Templates templates = Artigosdocumentos.jdoGettemplate(this);
        Templates templates2 = template;
        Artigosdocumentos.jdoSettemplate(this, templates2);
        this.firePropertyChange(FIELDS.artigosdocumentos_template, (Object)templates, (Object)templates2);
    }

    public Documentostipos getTipodocumento() {
        return Artigosdocumentos.jdoGettipodocumento(this);
    }

    public void setTipodocumento(Documentostipos tipodocumento) {
        Documentostipos documentostipos = Artigosdocumentos.jdoGettipodocumento(this);
        Documentostipos documentostipos2 = tipodocumento;
        Artigosdocumentos.jdoSettipodocumento(this, documentostipos2);
        this.firePropertyChange(FIELDS.artigosdocumentos_tipodocumento, (Object)documentostipos, (Object)documentostipos2);
        this.setKey();
    }

    public Documentosseries getSeriedocumento() {
        return Artigosdocumentos.jdoGetseriedocumento(this);
    }

    public void setSeriedocumento(Documentosseries seriedocumento) {
        Documentosseries documentosseries = Artigosdocumentos.jdoGetseriedocumento(this);
        Documentosseries documentosseries2 = seriedocumento;
        Artigosdocumentos.jdoSetseriedocumento(this, documentosseries2);
        boolean changed = this.firePropertyChange(FIELDS.artigosdocumentos_seriedocumento, (Object)documentosseries, (Object)documentosseries2);
        if (changed && this.cascade && seriedocumento != null) {
            this.setNumerodocumento(this.getNumerodocumento$Default());
        }
    }

    public boolean isSeriedocumentoValid() {
        return Artigosdocumentos.jdoGetseriedocumento(this) != null && Artigosdocumentos.jdoGetseriedocumento(this).isEstado(1);
    }

    public Date getDatasistema() {
        return Artigosdocumentos.jdoGetdatasistema(this);
    }

    public String getDatasistemaToText() {
        return Artigosdocumentos.jdoGetdatasistema(this) == null ? "" : FIELDS.artigosdocumentos_datasistema.format.format(Artigosdocumentos.jdoGetdatasistema(this));
    }

    public void setDatasistema(Date datasistema) {
        Date date = Artigosdocumentos.jdoGetdatasistema(this);
        Date date2 = TimeDateUtils.getDateWithoutTime((Date)datasistema);
        Artigosdocumentos.jdoSetdatasistema(this, date2);
        this.firePropertyChange(FIELDS.artigosdocumentos_datasistema, (Object)date, (Object)date2);
    }

    public void setDatasistema() {
        this.setDatasistema(TimeDateUtils.getCurrentDate());
    }

    @Override
    public Date getDatacriacao() {
        return Artigosdocumentos.jdoGetdatacriacao(this);
    }

    public String getDatacriacaoToText() {
        return Artigosdocumentos.jdoGetdatacriacao(this) == null ? "" : FIELDS.artigosdocumentos_datacriacao.format.format(Artigosdocumentos.jdoGetdatacriacao(this));
    }

    public void setDatacriacao(Date datacriacao) {
        Date date = Artigosdocumentos.jdoGetdatacriacao(this);
        Date date2 = TimeDateUtils.getDateWithoutTime((Date)datacriacao);
        Artigosdocumentos.jdoSetdatacriacao(this, date2);
        boolean changed = this.firePropertyChange(FIELDS.artigosdocumentos_datacriacao, (Object)date, (Object)date2);
        if (changed && this.cascade && datacriacao != null) {
            this.setDataauxiliar(datacriacao);
            this.setDatacarga(datacriacao);
            this.setDatadescarga(datacriacao);
        }
    }

    public Date getDataauxiliar() {
        return Artigosdocumentos.jdoGetdataauxiliar(this);
    }

    public String getDataauxiliarToText() {
        return Artigosdocumentos.jdoGetdataauxiliar(this) == null ? "" : FIELDS.artigosdocumentos_dataauxiliar.format.format(Artigosdocumentos.jdoGetdataauxiliar(this));
    }

    public void setDataauxiliar(Date dataauxiliar) {
        Date date = Artigosdocumentos.jdoGetdataauxiliar(this);
        Date date2 = TimeDateUtils.getDateWithoutTime((Date)dataauxiliar);
        Artigosdocumentos.jdoSetdataauxiliar(this, date2);
        this.firePropertyChange(FIELDS.artigosdocumentos_dataauxiliar, (Object)date, (Object)date2);
    }

    public Date getDatacarga() {
        return Artigosdocumentos.jdoGetdatacarga(this);
    }

    public String getDatacargaToText() {
        return Artigosdocumentos.jdoGetdatacarga(this) == null ? "" : FIELDS.artigosdocumentos_datacarga.format.format(Artigosdocumentos.jdoGetdatacarga(this));
    }

    public void setDatacarga(Date datacarga) {
        Date date = Artigosdocumentos.jdoGetdatacarga(this);
        Date date2 = TimeDateUtils.getDateWithoutTime((Date)datacarga);
        Artigosdocumentos.jdoSetdatacarga(this, date2);
        this.firePropertyChange(FIELDS.artigosdocumentos_datacarga, (Object)date, (Object)date2);
    }

    public Time getHoracarga() {
        return Artigosdocumentos.jdoGethoracarga(this);
    }

    public String getHoracargaToText() {
        return Artigosdocumentos.jdoGethoracarga(this) == null ? "" : FIELDS.artigosdocumentos_horacarga.format.format(Artigosdocumentos.jdoGethoracarga(this));
    }

    public void setHoracarga(Time horacarga) {
        Time time = Artigosdocumentos.jdoGethoracarga(this);
        Time time2 = TimeDateUtils.getTimeWithoutSeconds((Time)horacarga);
        Artigosdocumentos.jdoSethoracarga(this, time2);
        this.firePropertyChange(FIELDS.artigosdocumentos_horacarga, (Object)time, (Object)time2);
    }

    public Date getDatadescarga() {
        return Artigosdocumentos.jdoGetdatadescarga(this);
    }

    public String getDatadescargaToText() {
        return Artigosdocumentos.jdoGetdatadescarga(this) == null ? "" : FIELDS.artigosdocumentos_datadescarga.format.format(Artigosdocumentos.jdoGetdatadescarga(this));
    }

    public void setDatadescarga(Date datadescarga) {
        Date date = Artigosdocumentos.jdoGetdatadescarga(this);
        Date date2 = TimeDateUtils.getDateWithoutTime((Date)datadescarga);
        Artigosdocumentos.jdoSetdatadescarga(this, date2);
        this.firePropertyChange(FIELDS.artigosdocumentos_datadescarga, (Object)date, (Object)date2);
    }

    public Time getHoradescarga() {
        return Artigosdocumentos.jdoGethoradescarga(this);
    }

    public String getHoradescargaToText() {
        return Artigosdocumentos.jdoGethoradescarga(this) == null ? "" : FIELDS.artigosdocumentos_horadescarga.format.format(Artigosdocumentos.jdoGethoradescarga(this));
    }

    public void setHoradescarga(Time horadescarga) {
        Time time = Artigosdocumentos.jdoGethoradescarga(this);
        Time time2 = TimeDateUtils.getTimeWithoutSeconds((Time)horadescarga);
        Artigosdocumentos.jdoSethoradescarga(this, time2);
        this.firePropertyChange(FIELDS.artigosdocumentos_horadescarga, (Object)time, (Object)time2);
    }

    public String getNumeroauxiliar() {
        return Artigosdocumentos.jdoGetnumeroauxiliar(this);
    }

    public String getNumeroauxiliarToText() {
        return Artigosdocumentos.jdoGetnumeroauxiliar(this) == null ? "" : Artigosdocumentos.jdoGetnumeroauxiliar(this).toString();
    }

    public void setNumeroauxiliar(String numeroauxiliar) {
        String string = Artigosdocumentos.jdoGetnumeroauxiliar(this);
        String string2 = numeroauxiliar;
        Artigosdocumentos.jdoSetnumeroauxiliar(this, string2);
        this.firePropertyChange(FIELDS.artigosdocumentos_numeroauxiliar, (Object)string, (Object)string2);
    }

    public boolean isNumeroauxiliarValid() {
        return FIELDS.artigosdocumentos_numeroauxiliar.isValid(Artigosdocumentos.jdoGetnumeroauxiliar(this));
    }

    public String getExpedicao() {
        return Artigosdocumentos.jdoGetexpedicao(this);
    }

    public String getExpedicaoToText() {
        return Artigosdocumentos.jdoGetexpedicao(this) == null ? "" : Artigosdocumentos.jdoGetexpedicao(this).toString();
    }

    public void setExpedicao(String expedicao) {
        String string = Artigosdocumentos.jdoGetexpedicao(this);
        String string2 = expedicao;
        Artigosdocumentos.jdoSetexpedicao(this, string2);
        this.firePropertyChange(FIELDS.artigosdocumentos_expedicao, (Object)string, (Object)string2);
    }

    public String getMatricula() {
        return Artigosdocumentos.jdoGetmatricula(this);
    }

    public String getMatriculaToText() {
        return Artigosdocumentos.jdoGetmatricula(this) == null ? "" : Artigosdocumentos.jdoGetmatricula(this).toString();
    }

    public void setMatricula(String matricula) {
        String string = Artigosdocumentos.jdoGetmatricula(this);
        String string2 = matricula;
        Artigosdocumentos.jdoSetmatricula(this, string2);
        this.firePropertyChange(FIELDS.artigosdocumentos_matricula, (Object)string, (Object)string2);
    }

    public String getLocalcarga() {
        return Artigosdocumentos.jdoGetlocalcarga(this);
    }

    public String getLocalcargaToText() {
        return Artigosdocumentos.jdoGetlocalcarga(this) == null ? "" : FIELDS.artigosdocumentos_localcarga.format.format(Artigosdocumentos.jdoGetlocalcarga(this));
    }

    public void setLocalcarga(String localcarga) {
        String string = Artigosdocumentos.jdoGetlocalcarga(this);
        String string2 = localcarga;
        Artigosdocumentos.jdoSetlocalcarga(this, string2);
        this.firePropertyChange(FIELDS.artigosdocumentos_localcarga, (Object)string, (Object)string2);
    }

    public String getLocaldescarga() {
        return Artigosdocumentos.jdoGetlocaldescarga(this);
    }

    public String getLocaldescargaToText() {
        return Artigosdocumentos.jdoGetlocaldescarga(this) == null ? "" : FIELDS.artigosdocumentos_localdescarga.format.format(Artigosdocumentos.jdoGetlocaldescarga(this));
    }

    public void setLocaldescarga(String localdescarga) {
        String string = Artigosdocumentos.jdoGetlocaldescarga(this);
        String string2 = localdescarga;
        Artigosdocumentos.jdoSetlocaldescarga(this, string2);
        this.firePropertyChange(FIELDS.artigosdocumentos_localdescarga, (Object)string, (Object)string2);
    }

    public String getObs() {
        return Artigosdocumentos.jdoGetobs(this);
    }

    public String getObsToText() {
        return Artigosdocumentos.jdoGetobs(this) == null ? "" : FIELDS.artigosdocumentos_obs.format.format(Artigosdocumentos.jdoGetobs(this));
    }

    public void setObs(String obs) {
        String string = Artigosdocumentos.jdoGetobs(this);
        String string2 = obs;
        Artigosdocumentos.jdoSetobs(this, string2);
        this.firePropertyChange(FIELDS.artigosdocumentos_obs, (Object)string, (Object)string2);
    }

    public Integer getNumerodocumento() {
        return Artigosdocumentos.jdoGetnumerodocumento(this);
    }

    public String getNumerodocumentoToText() {
        return Artigosdocumentos.jdoGetnumerodocumento(this) == null ? "" : Artigosdocumentos.jdoGetnumerodocumento(this).toString();
    }

    public void setNumerodocumento(Integer numerodocumento) {
        Integer n = Artigosdocumentos.jdoGetnumerodocumento(this);
        Integer n2 = numerodocumento;
        Artigosdocumentos.jdoSetnumerodocumento(this, n2);
        this.firePropertyChange(FIELDS.artigosdocumentos_numerodocumento, (Object)n, (Object)n2);
        this.setKey();
    }

    public Integer getNumerodocumento$Next() {
        return this.manager.getDocumentosseries$NextNumero(Artigosdocumentos.jdoGettipodocumento(this).getCodigo(), Artigosdocumentos.jdoGetseriedocumento(this) == null ? null : Artigosdocumentos.jdoGetseriedocumento(this).getSerie());
    }

    public Integer getNumerodocumento$Default() {
        return Colibri.VERSION_TYPE == Colibri.VERSIONS.SERVER ? -1 : this.getNumerodocumento$Next();
    }

    public boolean isNumerodocumentoValid() {
        return FIELDS.artigosdocumentos_numerodocumento.isValid(Artigosdocumentos.jdoGetnumerodocumento(this)) && Artigosdocumentos.jdoGetnumerodocumento(this) > 0 && Artigosdocumentos.jdoGetseriedocumento(this) != null && Artigosdocumentos.jdoGetnumerodocumento(this) <= Artigosdocumentos.jdoGetseriedocumento(this).getNumero() + 1;
    }

    public BigDecimal getTotal() {
        return Artigosdocumentos.jdoGettotal(this);
    }

    public String getTotalToText() {
        return Artigosdocumentos.jdoGettotal(this) == null ? "" : FIELDS.artigosdocumentos_total.format.format(Artigosdocumentos.jdoGettotal(this));
    }

    public void setTotal(BigDecimal total) {
        BigDecimal bigDecimal = Artigosdocumentos.jdoGettotal(this);
        BigDecimal bigDecimal2 = total;
        Artigosdocumentos.jdoSettotal(this, bigDecimal2);
        this.firePropertyChange(FIELDS.artigosdocumentos_total, (Object)bigDecimal, (Object)bigDecimal2);
    }

    @Override
    public BigDecimal getTotalcambio() {
        return this.getTotal();
    }

    @Override
    public String getTotalextenso() {
        return this.manager.getParametros().getMoeda().getExtenso(Artigosdocumentos.jdoGettotal(this));
    }

    public Artigosdocumentoslinhas createLinhasdocumento() {
        return new Artigosdocumentoslinhas(this);
    }

    public Collection<Artigosdocumentoslinhas> getLinhasdocumento() {
        return Collections.unmodifiableList(Artigosdocumentos.jdoGetlinhasdocumento(this));
    }

    public Artigosdocumentoslinhas getLinhasdocumento(int index) {
        return index >= Artigosdocumentos.jdoGetlinhasdocumento(this).size() ? null : (Artigosdocumentoslinhas)Artigosdocumentos.jdoGetlinhasdocumento(this).get(index);
    }

    public Artigosdocumentoslinhas getLinhasdocumento(String key) {
        for (Artigosdocumentoslinhas linha : Artigosdocumentos.jdoGetlinhasdocumento(this)) {
            if (!linha.getKey().equals(key)) continue;
            return linha;
        }
        return null;
    }

    public void setLinhasdocumento(Collection<Artigosdocumentoslinhas> linhasdocumento) {
        Artigosdocumentos.jdoGetlinhasdocumento(this).clear();
        this.addLinhasdocumento(linhasdocumento);
    }

    public Artigosdocumentoslinhas addLinhasdocumento() {
        return this.addLinhasdocumento(this.createLinhasdocumento());
    }

    public Artigosdocumentoslinhas addLinhasdocumento(int index) {
        if (index >= 0 && index <= Artigosdocumentos.jdoGetlinhasdocumento(this).size()) {
            ArrayList<Artigosdocumentoslinhas> linhasdocumento = new ArrayList<Artigosdocumentoslinhas>(Artigosdocumentos.jdoGetlinhasdocumento(this));
            Artigosdocumentoslinhas linha = this.createLinhasdocumento();
            linhasdocumento.add(index, linha);
            this.setLinhasdocumento(linhasdocumento);
            return linha;
        }
        return this.addLinhasdocumento();
    }

    public Artigosdocumentoslinhas addLinhasdocumento(Artigosdocumentoslinhas linhasdocumento) {
        this.addLinhasdocumento((Collection<Artigosdocumentoslinhas>)(linhasdocumento == null ? Collections.EMPTY_LIST : Arrays.asList(linhasdocumento)));
        return linhasdocumento;
    }

    public void addLinhasdocumento(Collection<Artigosdocumentoslinhas> linhasdocumento) {
        int index = Artigosdocumentos.jdoGetlinhasdocumento(this).size();
        for (Artigosdocumentoslinhas linha : linhasdocumento) {
            linha.setNumerolinha(++index);
            linha.setDocumento(this);
        }
        boolean changed = Artigosdocumentos.jdoGetlinhasdocumento(this).addAll(linhasdocumento);
        if (changed && this.cascade) {
            this.process();
        }
    }

    public void removeLinhasdocumento() {
        this.removeLinhasdocumento(Artigosdocumentos.jdoGetlinhasdocumento(this));
    }

    public void removeLinhasdocumento(int index) {
        this.removeLinhasdocumento(this.getLinhasdocumento(index));
    }

    public void removeLinhasdocumento(Artigosdocumentoslinhas linhasdocumento) {
        this.removeLinhasdocumento(Arrays.asList(linhasdocumento));
    }

    public void removeLinhasdocumento(Collection<Artigosdocumentoslinhas> linhasdocumento) {
        Artigosdocumentos.jdoGetlinhasdocumento(this).removeAll(linhasdocumento);
        int index = 0;
        for (Artigosdocumentoslinhas linha : Artigosdocumentos.jdoGetlinhasdocumento(this)) {
            linha.setNumerolinha(++index);
        }
        if (this.cascade) {
            this.process();
        }
    }

    @Override
    public boolean isEditable(FIELDS field) {
        return !(field == FIELDS.artigosdocumentos_autor || field == FIELDS.artigosdocumentos_editor || field == FIELDS.artigosdocumentos_datasistema || field == FIELDS.artigosdocumentos_seriedocumento && this.isEdited() || field == FIELDS.artigosdocumentos_numerodocumento && this.isEdited() || field == FIELDS.artigosdocumentos_total);
    }

    @Override
    public void attach(DatabaseManager manager) {
        manager.attach(Artigosdocumentos.jdoGetlinhasdocumento(this));
        manager.attach(new AbstractModel[]{Artigosdocumentos.jdoGetautor(this), Artigosdocumentos.jdoGeteditor(this), Artigosdocumentos.jdoGettemplate(this), Artigosdocumentos.jdoGettipodocumento(this), Artigosdocumentos.jdoGetseriedocumento(this)});
    }

    @Override
    public boolean isDirty() {
        return super.isDirty() || this.isDirty(Artigosdocumentos.jdoGetlinhasdocumento(this));
    }

    public String toString() {
        return ATMessageFormatter.getInvoiceNo(Artigosdocumentos.jdoGettipodocumento(this) == null ? null : Artigosdocumentos.jdoGettipodocumento(this).getCodigo(), Artigosdocumentos.jdoGetseriedocumento(this) == null ? null : Artigosdocumentos.jdoGetseriedocumento(this).getSerie(), Artigosdocumentos.jdoGetnumerodocumento(this));
    }

    public int hashCode() {
        return Artigosdocumentos.jdoGetkey(this) == null ? 0 : Artigosdocumentos.jdoGetkey(this).hashCode();
    }

    public boolean equals(Object obj) {
        return this.hashCode() == obj.hashCode();
    }

    static {
        jdoFieldNames = Artigosdocumentos.__jdoFieldNamesInit();
        jdoFieldTypes = Artigosdocumentos.__jdoFieldTypesInit();
        jdoFieldFlags = Artigosdocumentos.__jdoFieldFlagsInit();
        jdoInheritedFieldCount = Artigosdocumentos.__jdoGetInheritedFieldCount();
        jdoPersistenceCapableSuperclass = Artigosdocumentos.__jdoPersistenceCapableSuperclassInit();
        JDOImplHelper.registerClass((Class)Artigosdocumentos.___jdo$loadClass("org.projectocolibri.api.database.model.Artigosdocumentos"), (String[])jdoFieldNames, (Class[])jdoFieldTypes, (byte[])jdoFieldFlags, (Class)jdoPersistenceCapableSuperclass, (PersistenceCapable)new Artigosdocumentos());
    }

    public void jdoCopyKeyFieldsFromObjectId(PersistenceCapable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("oid is not instanceof javax.jdo.identity.StringIdentity");
        }
        StringIdentity o = (StringIdentity)oid;
        fc.storeStringField(10, o.getKey());
    }

    protected void jdoCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("key class is not javax.jdo.identity.StringIdentity or null");
        }
        StringIdentity o = (StringIdentity)oid;
        this.key = o.getKey();
    }

    public final void jdoCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final void jdoCopyKeyFieldsToObjectId(PersistenceCapable.ObjectIdFieldSupplier fs, Object object) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final Object jdoGetObjectId() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getObjectId((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[0];
    }

    public final Object jdoGetVersion() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getVersion((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[1];
    }

    protected final void jdoPreSerialize() {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.preSerialize((PersistenceCapable)this);
        }
    }

    public final PersistenceManager jdoGetPersistenceManager() {
        return this.jdoStateManager != null ? this.jdoStateManager.getPersistenceManager((PersistenceCapable)this) : null;
    }

    public final Object jdoGetTransactionalObjectId() {
        return this.jdoStateManager != null ? this.jdoStateManager.getTransactionalObjectId((PersistenceCapable)this) : null;
    }

    public final boolean jdoIsDeleted() {
        return this.jdoStateManager != null ? this.jdoStateManager.isDeleted((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsDirty() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.isDirty((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return false;
        }
        return ((BitSet)this.jdoDetachedState[3]).length() > 0;
    }

    public final boolean jdoIsNew() {
        return this.jdoStateManager != null ? this.jdoStateManager.isNew((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsPersistent() {
        return this.jdoStateManager != null ? this.jdoStateManager.isPersistent((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsTransactional() {
        return this.jdoStateManager != null ? this.jdoStateManager.isTransactional((PersistenceCapable)this) : false;
    }

    public void jdoMakeDirty(String fieldName) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.makeDirty((PersistenceCapable)this, fieldName);
        }
        if (this.jdoIsDetached() && fieldName != null) {
            String fldName = null;
            fldName = fieldName.indexOf(46) >= 0 ? fieldName.substring(fieldName.lastIndexOf(46) + 1) : fieldName;
            int i = 0;
            while (i < jdoFieldNames.length) {
                if (jdoFieldNames[i].equals(fldName)) {
                    if (!((BitSet)this.jdoDetachedState[2]).get(i + jdoInheritedFieldCount)) {
                        throw new JDODetachedFieldAccessException("You have just attempted to access a field/property that hasn't been detached. Please detach it first before performing this operation");
                    }
                    ((BitSet)this.jdoDetachedState[3]).set(i + jdoInheritedFieldCount);
                    return;
                }
                ++i;
            }
        }
    }

    public final Object jdoNewObjectIdInstance() {
        return new StringIdentity(this.getClass(), this.key);
    }

    public final Object jdoNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new StringIdentity(this.getClass(), (String)key);
        }
        return new StringIdentity(this.getClass(), (String)key);
    }

    public final void jdoProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void jdoReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.jdoReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void jdoReplaceFlags() {
        if (this.jdoStateManager != null) {
            this.jdoFlags = this.jdoStateManager.replacingFlags((PersistenceCapable)this);
        }
    }

    public final synchronized void jdoReplaceStateManager(StateManager sm) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager = this.jdoStateManager.replacingStateManager((PersistenceCapable)this, sm);
        } else {
            JDOImplHelper.checkAuthorizedStateManager((StateManager)sm);
            this.jdoStateManager = sm;
            this.jdoFlags = 1;
        }
    }

    public final synchronized void jdoReplaceDetachedState() {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        this.jdoDetachedState = this.jdoStateManager.replacingDetachedState((Detachable)this, this.jdoDetachedState);
    }

    public boolean jdoIsDetached() {
        return this.jdoStateManager == null && this.jdoDetachedState != null;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm) {
        Artigosdocumentos result = new Artigosdocumentos();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        return result;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm, Object obj) {
        Artigosdocumentos result = new Artigosdocumentos();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        result.jdoCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void jdoReplaceField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.autor = (Utilizadores)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 1: {
                this.dataauxiliar = (Date)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 2: {
                this.datacarga = (Date)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 3: {
                this.datacriacao = (Date)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 4: {
                this.datadescarga = (Date)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 5: {
                this.datasistema = (Date)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 6: {
                this.editor = (Utilizadores)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 7: {
                this.expedicao = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 8: {
                this.horacarga = (Time)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 9: {
                this.horadescarga = (Time)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 10: {
                this.key = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 11: {
                this.linhasdocumento = (List)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 12: {
                this.localcarga = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 13: {
                this.localdescarga = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 14: {
                this.matricula = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 15: {
                this.numeroauxiliar = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 16: {
                this.numerodocumento = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 17: {
                this.obs = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 18: {
                this.seriedocumento = (Documentosseries)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 19: {
                this.template = (Templates)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 20: {
                this.tipodocumento = (Documentostipos)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 21: {
                this.total = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoProvideField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.autor);
                break;
            }
            case 1: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.dataauxiliar);
                break;
            }
            case 2: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.datacarga);
                break;
            }
            case 3: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.datacriacao);
                break;
            }
            case 4: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.datadescarga);
                break;
            }
            case 5: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.datasistema);
                break;
            }
            case 6: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.editor);
                break;
            }
            case 7: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.expedicao);
                break;
            }
            case 8: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.horacarga);
                break;
            }
            case 9: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.horadescarga);
                break;
            }
            case 10: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.key);
                break;
            }
            case 11: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, this.linhasdocumento);
                break;
            }
            case 12: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.localcarga);
                break;
            }
            case 13: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.localdescarga);
                break;
            }
            case 14: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.matricula);
                break;
            }
            case 15: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.numeroauxiliar);
                break;
            }
            case 16: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.numerodocumento);
                break;
            }
            case 17: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.obs);
                break;
            }
            case 18: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.seriedocumento);
                break;
            }
            case 19: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.template);
                break;
            }
            case 20: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.tipodocumento);
                break;
            }
            case 21: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.total);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void jdoCopyField(Artigosdocumentos obj, int index) {
        switch (index) {
            case 0: {
                this.autor = obj.autor;
                break;
            }
            case 1: {
                this.dataauxiliar = obj.dataauxiliar;
                break;
            }
            case 2: {
                this.datacarga = obj.datacarga;
                break;
            }
            case 3: {
                this.datacriacao = obj.datacriacao;
                break;
            }
            case 4: {
                this.datadescarga = obj.datadescarga;
                break;
            }
            case 5: {
                this.datasistema = obj.datasistema;
                break;
            }
            case 6: {
                this.editor = obj.editor;
                break;
            }
            case 7: {
                this.expedicao = obj.expedicao;
                break;
            }
            case 8: {
                this.horacarga = obj.horacarga;
                break;
            }
            case 9: {
                this.horadescarga = obj.horadescarga;
                break;
            }
            case 10: {
                this.key = obj.key;
                break;
            }
            case 11: {
                this.linhasdocumento = obj.linhasdocumento;
                break;
            }
            case 12: {
                this.localcarga = obj.localcarga;
                break;
            }
            case 13: {
                this.localdescarga = obj.localdescarga;
                break;
            }
            case 14: {
                this.matricula = obj.matricula;
                break;
            }
            case 15: {
                this.numeroauxiliar = obj.numeroauxiliar;
                break;
            }
            case 16: {
                this.numerodocumento = obj.numerodocumento;
                break;
            }
            case 17: {
                this.obs = obj.obs;
                break;
            }
            case 18: {
                this.seriedocumento = obj.seriedocumento;
                break;
            }
            case 19: {
                this.template = obj.template;
                break;
            }
            case 20: {
                this.tipodocumento = obj.tipodocumento;
                break;
            }
            case 21: {
                this.total = obj.total;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoCopyFields(Object obj, int[] indices) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof Artigosdocumentos)) {
            throw new IllegalArgumentException("object is not an object of type org.projectocolibri.api.database.model.Artigosdocumentos");
        }
        Artigosdocumentos other = (Artigosdocumentos)obj;
        if (this.jdoStateManager != other.jdoStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __jdoFieldNamesInit() {
        return new String[]{"autor", "dataauxiliar", "datacarga", "datacriacao", "datadescarga", "datasistema", "editor", "expedicao", "horacarga", "horadescarga", "key", "linhasdocumento", "localcarga", "localdescarga", "matricula", "numeroauxiliar", "numerodocumento", "obs", "seriedocumento", "template", "tipodocumento", "total"};
    }

    private static final Class[] __jdoFieldTypesInit() {
        return new Class[]{Artigosdocumentos.___jdo$loadClass("org.projectocolibri.api.database.model.Utilizadores"), Artigosdocumentos.___jdo$loadClass("java.util.Date"), Artigosdocumentos.___jdo$loadClass("java.util.Date"), Artigosdocumentos.___jdo$loadClass("java.util.Date"), Artigosdocumentos.___jdo$loadClass("java.util.Date"), Artigosdocumentos.___jdo$loadClass("java.util.Date"), Artigosdocumentos.___jdo$loadClass("org.projectocolibri.api.database.model.Utilizadores"), Artigosdocumentos.___jdo$loadClass("java.lang.String"), Artigosdocumentos.___jdo$loadClass("java.sql.Time"), Artigosdocumentos.___jdo$loadClass("java.sql.Time"), Artigosdocumentos.___jdo$loadClass("java.lang.String"), Artigosdocumentos.___jdo$loadClass("java.util.List"), Artigosdocumentos.___jdo$loadClass("java.lang.String"), Artigosdocumentos.___jdo$loadClass("java.lang.String"), Artigosdocumentos.___jdo$loadClass("java.lang.String"), Artigosdocumentos.___jdo$loadClass("java.lang.String"), Artigosdocumentos.___jdo$loadClass("java.lang.Integer"), Artigosdocumentos.___jdo$loadClass("java.lang.String"), Artigosdocumentos.___jdo$loadClass("org.projectocolibri.api.database.model.Documentosseries"), Artigosdocumentos.___jdo$loadClass("org.projectocolibri.api.database.model.Templates"), Artigosdocumentos.___jdo$loadClass("org.projectocolibri.api.database.model.Documentostipos"), Artigosdocumentos.___jdo$loadClass("java.math.BigDecimal")};
    }

    private static final byte[] __jdoFieldFlagsInit() {
        return new byte[]{21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 24, 5, 21, 21, 21, 21, 21, 21, 5, 5, 5, 21};
    }

    protected static int __jdoGetInheritedFieldCount() {
        return 0;
    }

    protected static int jdoGetManagedFieldCount() {
        return 22;
    }

    private static Class __jdoPersistenceCapableSuperclassInit() {
        return null;
    }

    public static Class ___jdo$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object jdoSuperClone() throws CloneNotSupportedException {
        Artigosdocumentos o = (Artigosdocumentos)super.clone();
        o.jdoFlags = 0;
        o.jdoStateManager = null;
        return o;
    }

    private static Utilizadores jdoGetautor(Artigosdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 0)) {
            return (Utilizadores)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 0, (Object)objPC.autor);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(0)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"autor\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.autor;
    }

    private static void jdoSetautor(Artigosdocumentos objPC, Utilizadores val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 0, (Object)objPC.autor, (Object)val);
        } else {
            objPC.autor = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(0);
            }
        }
    }

    private static Date jdoGetdataauxiliar(Artigosdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 1)) {
            return (Date)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 1, (Object)objPC.dataauxiliar);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(1)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"dataauxiliar\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.dataauxiliar;
    }

    private static void jdoSetdataauxiliar(Artigosdocumentos objPC, Date val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 1, (Object)objPC.dataauxiliar, (Object)val);
        } else {
            objPC.dataauxiliar = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(1);
            }
        }
    }

    private static Date jdoGetdatacarga(Artigosdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 2)) {
            return (Date)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 2, (Object)objPC.datacarga);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(2)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"datacarga\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.datacarga;
    }

    private static void jdoSetdatacarga(Artigosdocumentos objPC, Date val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 2, (Object)objPC.datacarga, (Object)val);
        } else {
            objPC.datacarga = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(2);
            }
        }
    }

    private static Date jdoGetdatacriacao(Artigosdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 3)) {
            return (Date)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 3, (Object)objPC.datacriacao);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(3)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"datacriacao\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.datacriacao;
    }

    private static void jdoSetdatacriacao(Artigosdocumentos objPC, Date val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 3, (Object)objPC.datacriacao, (Object)val);
        } else {
            objPC.datacriacao = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(3);
            }
        }
    }

    private static Date jdoGetdatadescarga(Artigosdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 4)) {
            return (Date)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 4, (Object)objPC.datadescarga);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(4)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"datadescarga\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.datadescarga;
    }

    private static void jdoSetdatadescarga(Artigosdocumentos objPC, Date val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 4, (Object)objPC.datadescarga, (Object)val);
        } else {
            objPC.datadescarga = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(4);
            }
        }
    }

    private static Date jdoGetdatasistema(Artigosdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 5)) {
            return (Date)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 5, (Object)objPC.datasistema);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(5)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"datasistema\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.datasistema;
    }

    private static void jdoSetdatasistema(Artigosdocumentos objPC, Date val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 5, (Object)objPC.datasistema, (Object)val);
        } else {
            objPC.datasistema = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(5);
            }
        }
    }

    private static Utilizadores jdoGeteditor(Artigosdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 6)) {
            return (Utilizadores)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 6, (Object)objPC.editor);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(6)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"editor\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.editor;
    }

    private static void jdoSeteditor(Artigosdocumentos objPC, Utilizadores val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 6, (Object)objPC.editor, (Object)val);
        } else {
            objPC.editor = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(6);
            }
        }
    }

    private static String jdoGetexpedicao(Artigosdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 7)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 7, objPC.expedicao);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(7)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"expedicao\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.expedicao;
    }

    private static void jdoSetexpedicao(Artigosdocumentos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 7, objPC.expedicao, val);
        } else {
            objPC.expedicao = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(7);
            }
        }
    }

    private static Time jdoGethoracarga(Artigosdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 8)) {
            return (Time)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 8, (Object)objPC.horacarga);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(8)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"horacarga\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.horacarga;
    }

    private static void jdoSethoracarga(Artigosdocumentos objPC, Time val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 8, (Object)objPC.horacarga, (Object)val);
        } else {
            objPC.horacarga = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(8);
            }
        }
    }

    private static Time jdoGethoradescarga(Artigosdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 9)) {
            return (Time)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 9, (Object)objPC.horadescarga);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(9)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"horadescarga\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.horadescarga;
    }

    private static void jdoSethoradescarga(Artigosdocumentos objPC, Time val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 9, (Object)objPC.horadescarga, (Object)val);
        } else {
            objPC.horadescarga = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(9);
            }
        }
    }

    private static String jdoGetkey(Artigosdocumentos objPC) {
        return objPC.key;
    }

    private static void jdoSetkey(Artigosdocumentos objPC, String val) {
        if (objPC.jdoStateManager == null) {
            objPC.key = val;
        } else {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 10, objPC.key, val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(10);
        }
    }

    private static List jdoGetlinhasdocumento(Artigosdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 11)) {
            return (List)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 11, objPC.linhasdocumento);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(11)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"linhasdocumento\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.linhasdocumento;
    }

    private static void jdoSetlinhasdocumento(Artigosdocumentos objPC, List val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 11, objPC.linhasdocumento, (Object)val);
        } else {
            objPC.linhasdocumento = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(11);
            }
        }
    }

    private static String jdoGetlocalcarga(Artigosdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 12)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 12, objPC.localcarga);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(12)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"localcarga\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.localcarga;
    }

    private static void jdoSetlocalcarga(Artigosdocumentos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 12, objPC.localcarga, val);
        } else {
            objPC.localcarga = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(12);
            }
        }
    }

    private static String jdoGetlocaldescarga(Artigosdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 13)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 13, objPC.localdescarga);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(13)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"localdescarga\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.localdescarga;
    }

    private static void jdoSetlocaldescarga(Artigosdocumentos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 13, objPC.localdescarga, val);
        } else {
            objPC.localdescarga = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(13);
            }
        }
    }

    private static String jdoGetmatricula(Artigosdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 14)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 14, objPC.matricula);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(14)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"matricula\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.matricula;
    }

    private static void jdoSetmatricula(Artigosdocumentos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 14, objPC.matricula, val);
        } else {
            objPC.matricula = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(14);
            }
        }
    }

    private static String jdoGetnumeroauxiliar(Artigosdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 15)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 15, objPC.numeroauxiliar);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(15)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"numeroauxiliar\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.numeroauxiliar;
    }

    private static void jdoSetnumeroauxiliar(Artigosdocumentos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 15, objPC.numeroauxiliar, val);
        } else {
            objPC.numeroauxiliar = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(15);
            }
        }
    }

    private static Integer jdoGetnumerodocumento(Artigosdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 16)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 16, (Object)objPC.numerodocumento);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(16)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"numerodocumento\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.numerodocumento;
    }

    private static void jdoSetnumerodocumento(Artigosdocumentos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 16, (Object)objPC.numerodocumento, (Object)val);
        } else {
            objPC.numerodocumento = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(16);
            }
        }
    }

    private static String jdoGetobs(Artigosdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 17)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 17, objPC.obs);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(17)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"obs\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.obs;
    }

    private static void jdoSetobs(Artigosdocumentos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 17, objPC.obs, val);
        } else {
            objPC.obs = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(17);
            }
        }
    }

    private static Documentosseries jdoGetseriedocumento(Artigosdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 18)) {
            return (Documentosseries)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 18, (Object)objPC.seriedocumento);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(18)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"seriedocumento\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.seriedocumento;
    }

    private static void jdoSetseriedocumento(Artigosdocumentos objPC, Documentosseries val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 18, (Object)objPC.seriedocumento, (Object)val);
        } else {
            objPC.seriedocumento = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(18);
            }
        }
    }

    private static Templates jdoGettemplate(Artigosdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 19)) {
            return (Templates)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 19, (Object)objPC.template);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(19)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"template\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.template;
    }

    private static void jdoSettemplate(Artigosdocumentos objPC, Templates val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 19, (Object)objPC.template, (Object)val);
        } else {
            objPC.template = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(19);
            }
        }
    }

    private static Documentostipos jdoGettipodocumento(Artigosdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 20)) {
            return (Documentostipos)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 20, (Object)objPC.tipodocumento);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(20)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"tipodocumento\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.tipodocumento;
    }

    private static void jdoSettipodocumento(Artigosdocumentos objPC, Documentostipos val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 20, (Object)objPC.tipodocumento, (Object)val);
        } else {
            objPC.tipodocumento = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(20);
            }
        }
    }

    private static BigDecimal jdoGettotal(Artigosdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 21)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 21, (Object)objPC.total);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(21)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"total\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.total;
    }

    private static void jdoSettotal(Artigosdocumentos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 21, (Object)objPC.total, (Object)val);
        } else {
            objPC.total = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(21);
            }
        }
    }
}

