/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.jdo.JDODetachedFieldAccessException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.PersistenceManager;
import javax.jdo.identity.StringIdentity;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;
import org.dma.java.input.FieldFormat;
import org.dma.java.io.ByteFile;
import org.dma.java.math.BusinessRules;
import org.dma.java.math.NumericUtils;
import org.dma.java.math.SIGNUM;
import org.dma.java.util.ErrorList;
import org.dma.java.util.MessageLine;
import org.dma.java.util.MessageList;
import org.dma.java.util.StringUtils;
import org.dma.java.util.TimeDateUtils;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.IDatabaseModel;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.AbstractModel;
import org.projectocolibri.api.database.model.Armazens;
import org.projectocolibri.api.database.model.Artigoscomposicao;
import org.projectocolibri.api.database.model.Artigosexistencias;
import org.projectocolibri.api.database.model.Artigosmovimentos;
import org.projectocolibri.api.database.model.Artigosprecos;
import org.projectocolibri.api.database.model.Artigosunidades;
import org.projectocolibri.api.database.model.Codigosiva;
import org.projectocolibri.api.database.model.Familias;
import org.projectocolibri.api.database.model.Grupos;
import org.projectocolibri.api.database.model.Isencoesiva;
import org.projectocolibri.api.database.model.Retencoes;
import org.projectocolibri.api.database.model.Unidadesmedida;
import org.projectocolibri.api.database.model.Utilizadores;
import org.projectocolibri.api.database.model.paste.ArtigosPaste;
import org.projectocolibri.api.language.LABELS;

@javax.jdo.annotations.PersistenceCapable
public class Artigos
extends AbstractModel
implements Detachable,
PersistenceCapable {
    public static final String NUMERO_SERIE = "0";
    public static final char[] BARCODE_SUFFIX = new char[]{FieldFormat.KEYBOARD.CARRIAGE_RETURN.code, FieldFormat.KEYBOARD.LINE_FEED.code, FieldFormat.KEYBOARD.TAB.code};
    public static final int tipo_produto = 0;
    public static final int tipo_servico = 1;
    public static final int tipo_imposto = 2;
    public static final int categoria_mercadorias = 0;
    public static final int categoria_materiasprimas = 1;
    public static final int categoria_produtosacabados = 2;
    public static final int categoria_subprodutos = 3;
    public static final int categoria_trabalhoscurso = 4;
    public static final int tipocusto_acumulado = 0;
    public static final int tipocusto_producao = 1;
    public static final int botao_nao = 0;
    public static final int botao_sim = 1;
    public static final int estado_inactivo = 0;
    public static final int estado_activo = 1;
    private Utilizadores autor;
    private Utilizadores editor;
    private Retencoes retencao;
    private Codigosiva codigoiva;
    private Isencoesiva isencaoiva;
    private Grupos grupo;
    private Familias familia;
    @Deprecated
    private Familias familia2;
    private Date datacriacao;
    private Date dataalteracao;
    private String codigo;
    private String descricao;
    private String descricao2;
    private String intrastat;
    private String obs;
    private String campo1 = "";
    private String campo2 = "";
    private String campo3 = "";
    private String campo4 = "";
    private String campo5 = "";
    private String campo6 = "";
    private String campo7 = "";
    private String campo8 = "";
    private String campo9 = "";
    private String campo10 = "";
    private Integer tipo;
    private Integer categoria;
    private Integer tipocusto;
    private Integer botao;
    private Integer estado;
    private BigDecimal stockminimo;
    private BigDecimal saidas = BigDecimal.ZERO;
    private BigDecimal entradas = BigDecimal.ZERO;
    private BigDecimal stockreal = BigDecimal.ZERO;
    private BigDecimal stockexterior = BigDecimal.ZERO;
    private BigDecimal stockencomendado = BigDecimal.ZERO;
    private BigDecimal stockreservado = BigDecimal.ZERO;
    private BigDecimal stockprevisto = BigDecimal.ZERO;
    private BigDecimal precoupc = BigDecimal.ZERO;
    private BigDecimal precoupv = BigDecimal.ZERO;
    private BigDecimal precopcm = BigDecimal.ZERO;
    private BigDecimal custoproducao = BigDecimal.ZERO;
    private byte[] imagem;
    private List<Artigosunidades> unidades = new ArrayList<Artigosunidades>();
    private List<Artigosprecos> precos = new ArrayList<Artigosprecos>();
    private List<Artigoscomposicao> composicao = new ArrayList<Artigoscomposicao>();
    private List<Artigosexistencias> existencias = new ArrayList<Artigosexistencias>();
    protected transient StateManager jdoStateManager;
    protected transient byte jdoFlags;
    protected Object[] jdoDetachedState;
    private static final byte[] jdoFieldFlags;
    private static final Class jdoPersistenceCapableSuperclass;
    private static final Class[] jdoFieldTypes;
    private static final String[] jdoFieldNames;
    private static final int jdoInheritedFieldCount;

    static {
        jdoFieldNames = Artigos.__jdoFieldNamesInit();
        jdoFieldTypes = Artigos.__jdoFieldTypesInit();
        jdoFieldFlags = Artigos.__jdoFieldFlagsInit();
        jdoInheritedFieldCount = Artigos.__jdoGetInheritedFieldCount();
        jdoPersistenceCapableSuperclass = Artigos.__jdoPersistenceCapableSuperclassInit();
        JDOImplHelper.registerClass((Class)Artigos.___jdo$loadClass("org.projectocolibri.api.database.model.Artigos"), (String[])jdoFieldNames, (Class[])jdoFieldTypes, (byte[])jdoFieldFlags, (Class)jdoPersistenceCapableSuperclass, (PersistenceCapable)new Artigos());
    }

    @Deprecated
    public Integer getGestaostock() {
        return 2;
    }

    public ArtigosPaste paste() {
        return new ArtigosPaste(this);
    }

    private Artigos() {
        super(TABLES.artigos);
    }

    private Artigos(DatabaseManager manager) {
        super(TABLES.artigos, manager);
    }

    public Artigos(DatabaseManager manager, String codigo) {
        this(manager, codigo, "");
    }

    public Artigos(DatabaseManager manager, String codigo, String descricao) {
        this(manager);
        this.autor = manager.getUtilizador();
        this.editor = manager.getUtilizador();
        this.retencao = manager.getParametros().getRetencao();
        this.codigoiva = manager.getParametros().getCodigoiva();
        this.isencaoiva = manager.getParametros().getIsencaoiva();
        this.grupo = manager.loadGrupos(0, 0);
        this.familia = manager.loadFamilias(0, 0);
        this.familia2 = null;
        this.datacriacao = TimeDateUtils.getDateWithoutTime();
        this.dataalteracao = TimeDateUtils.getCurrentDate();
        this.codigo = codigo.toUpperCase();
        this.descricao = descricao;
        this.descricao2 = "";
        this.intrastat = "";
        this.obs = "";
        this.tipo = 0;
        this.categoria = 0;
        this.tipocusto = 0;
        this.botao = 1;
        this.estado = 1;
        this.stockminimo = BigDecimal.ZERO;
    }

    @Override
    public Artigos cloneCopy() {
        Artigos clone = new Artigos(this.manager);
        Artigos.jdoSetautor(clone, Artigos.jdoGetautor(this));
        Artigos.jdoSeteditor(clone, Artigos.jdoGeteditor(this));
        Artigos.jdoSetretencao(clone, Artigos.jdoGetretencao(this));
        Artigos.jdoSetcodigoiva(clone, Artigos.jdoGetcodigoiva(this));
        Artigos.jdoSetisencaoiva(clone, Artigos.jdoGetisencaoiva(this));
        Artigos.jdoSetgrupo(clone, Artigos.jdoGetgrupo(this));
        Artigos.jdoSetfamilia(clone, Artigos.jdoGetfamilia(this));
        Artigos.jdoSetfamilia2(clone, Artigos.jdoGetfamilia2(this));
        Artigos.jdoSetdataalteracao(clone, Artigos.jdoGetdataalteracao(this));
        Artigos.jdoSetdatacriacao(clone, Artigos.jdoGetdatacriacao(this));
        Artigos.jdoSetcodigo(clone, Artigos.jdoGetcodigo(this));
        Artigos.jdoSetdescricao(clone, Artigos.jdoGetdescricao(this));
        Artigos.jdoSetdescricao2(clone, Artigos.jdoGetdescricao2(this));
        Artigos.jdoSetintrastat(clone, Artigos.jdoGetintrastat(this));
        Artigos.jdoSetobs(clone, Artigos.jdoGetobs(this));
        Artigos.jdoSetcampo1(clone, Artigos.jdoGetcampo1(this));
        Artigos.jdoSetcampo2(clone, Artigos.jdoGetcampo2(this));
        Artigos.jdoSetcampo3(clone, Artigos.jdoGetcampo3(this));
        Artigos.jdoSetcampo4(clone, Artigos.jdoGetcampo4(this));
        Artigos.jdoSetcampo5(clone, Artigos.jdoGetcampo5(this));
        Artigos.jdoSetcampo6(clone, Artigos.jdoGetcampo6(this));
        Artigos.jdoSetcampo7(clone, Artigos.jdoGetcampo7(this));
        Artigos.jdoSetcampo8(clone, Artigos.jdoGetcampo8(this));
        Artigos.jdoSetcampo9(clone, Artigos.jdoGetcampo9(this));
        Artigos.jdoSetcampo10(clone, Artigos.jdoGetcampo10(this));
        Artigos.jdoSettipo(clone, Artigos.jdoGettipo(this));
        Artigos.jdoSetcategoria(clone, Artigos.jdoGetcategoria(this));
        Artigos.jdoSettipocusto(clone, Artigos.jdoGettipocusto(this));
        Artigos.jdoSetbotao(clone, Artigos.jdoGetbotao(this));
        Artigos.jdoSetestado(clone, Artigos.jdoGetestado(this));
        Artigos.jdoSetstockminimo(clone, Artigos.jdoGetstockminimo(this));
        Artigos.jdoSetsaidas(clone, Artigos.jdoGetsaidas(this));
        Artigos.jdoSetentradas(clone, Artigos.jdoGetentradas(this));
        Artigos.jdoSetstockreal(clone, Artigos.jdoGetstockreal(this));
        Artigos.jdoSetstockexterior(clone, Artigos.jdoGetstockexterior(this));
        Artigos.jdoSetstockencomendado(clone, Artigos.jdoGetstockencomendado(this));
        Artigos.jdoSetstockreservado(clone, Artigos.jdoGetstockreservado(this));
        Artigos.jdoSetstockprevisto(clone, Artigos.jdoGetstockprevisto(this));
        Artigos.jdoSetprecoupc(clone, Artigos.jdoGetprecoupc(this));
        Artigos.jdoSetprecoupv(clone, Artigos.jdoGetprecoupv(this));
        Artigos.jdoSetprecopcm(clone, Artigos.jdoGetprecopcm(this));
        Artigos.jdoSetcustoproducao(clone, Artigos.jdoGetcustoproducao(this));
        Artigos.jdoSetimagem(clone, this.getImagem());
        ArrayList<Artigosunidades> unidades = new ArrayList<Artigosunidades>();
        for (Artigosunidades linha : Artigos.jdoGetunidades(this)) {
            unidades.add(linha.cloneCopy(clone));
        }
        Artigos.jdoSetunidades(clone, unidades);
        ArrayList<Artigosprecos> precos = new ArrayList<Artigosprecos>();
        for (Artigosprecos linha : Artigos.jdoGetprecos(this)) {
            precos.add(linha.cloneCopy(clone));
        }
        Artigos.jdoSetprecos(clone, precos);
        ArrayList<Artigoscomposicao> composicao = new ArrayList<Artigoscomposicao>();
        for (Artigoscomposicao linha : Artigos.jdoGetcomposicao(this)) {
            composicao.add(linha.cloneCopy(clone));
        }
        Artigos.jdoSetcomposicao(clone, composicao);
        ArrayList<Artigosexistencias> existencias = new ArrayList<Artigosexistencias>();
        for (Artigosexistencias linha : Artigos.jdoGetexistencias(this)) {
            existencias.add(linha.cloneCopy(clone));
        }
        Artigos.jdoSetexistencias(clone, existencias);
        return clone;
    }

    public Artigos cleanCopy() {
        Artigos clone = this.cloneCopy();
        clone.removeExistencias();
        Artigos.jdoSetautor(clone, this.manager.getUtilizador());
        Artigos.jdoSeteditor(clone, this.manager.getUtilizador());
        Artigos.jdoSetdatacriacao(clone, TimeDateUtils.getCurrentDate());
        Artigos.jdoSetdataalteracao(clone, TimeDateUtils.getCurrentDate());
        Artigos.jdoSetsaidas(clone, BigDecimal.ZERO);
        Artigos.jdoSetentradas(clone, BigDecimal.ZERO);
        Artigos.jdoSetstockreal(clone, BigDecimal.ZERO);
        Artigos.jdoSetstockexterior(clone, BigDecimal.ZERO);
        Artigos.jdoSetstockreservado(clone, BigDecimal.ZERO);
        Artigos.jdoSetstockencomendado(clone, BigDecimal.ZERO);
        Artigos.jdoSetstockprevisto(clone, BigDecimal.ZERO);
        Artigos.jdoSetprecoupc(clone, BigDecimal.ZERO);
        Artigos.jdoSetprecoupv(clone, BigDecimal.ZERO);
        Artigos.jdoSetprecopcm(clone, BigDecimal.ZERO);
        clone.markDirty();
        return clone;
    }

    @Override
    public MessageList validate(IDatabaseModel.ACTION action) {
        return this.validate(action, null);
    }

    public MessageList validate(IDatabaseModel.ACTION action, Artigos stored) {
        MessageList error = super.validate(action);
        for (AbstractModel linha : Artigos.jdoGetunidades(this)) {
            error.add(((Artigosunidades)linha).validate(action));
        }
        for (AbstractModel linha : Artigos.jdoGetprecos(this)) {
            error.add(((Artigosprecos)linha).validate(action));
        }
        for (AbstractModel linha : Artigos.jdoGetcomposicao(this)) {
            error.add(((Artigoscomposicao)linha).validate(action));
        }
        for (AbstractModel linha : Artigos.jdoGetexistencias(this)) {
            error.add(linha.validate(action));
        }
        switch (action) {
            case DELETE: {
                if (this.hasSaidas()) {
                    error.add((Object)new MessageLine((Object)LABELS.artigos_saidas).notEqual((Object)0));
                }
                if (!this.hasEntradas()) break;
                error.add((Object)new MessageLine((Object)LABELS.artigos_entradas).notEqual((Object)0));
                break;
            }
            case STORE: {
                error.add(this.validate(stored, FIELDS.artigos_saidas, FIELDS.artigos_entradas, FIELDS.artigos_stockreal, FIELDS.artigos_stockexterior, FIELDS.artigos_stockencomendado, FIELDS.artigos_stockreservado, FIELDS.artigos_stockprevisto, FIELDS.artigos_precoupc, FIELDS.artigos_precoupv, FIELDS.artigos_precopcm));
                Artigos clone = this.cloneCopy().process();
                error.add(this.validate(clone, new FIELDS[0]));
                if (!this.isCodigoValid()) {
                    error.add((Object)new MessageLine((Object)LABELS.artigos_codigo));
                }
                if (!this.isDescricaoValid()) {
                    error.add((Object)new MessageLine((Object)LABELS.artigos_descricao));
                }
                if (!this.isCodigoivaValid()) {
                    error.add((Object)new MessageLine((Object)LABELS.artigos_codigoiva));
                }
                if (!this.isUnidadesValid()) {
                    error.add((Object)new MessageLine((Object)LABELS.artigos_unidades));
                }
                if (this.isPrecosValid()) break;
                error.add((Object)new MessageLine((Object)LABELS.artigos_precos));
            }
        }
        return error;
    }

    public ErrorList warnings() {
        return new ErrorList();
    }

    Artigos process() {
        if (!this.busy) {
            this.busy = true;
            boolean cascade = this.setCascade(false);
            BigDecimal custoproducao = BigDecimal.ZERO;
            for (Artigoscomposicao linha : Artigos.jdoGetcomposicao(this)) {
                custoproducao = custoproducao.add(linha.getValortotal());
            }
            this.setCustoproducao(FIELDS.artigos_custoproducao.format.setScale(custoproducao, RoundingMode.HALF_EVEN));
            this.setCascade(cascade);
            this.busy = false;
        }
        return this;
    }

    public Utilizadores getAutor() {
        return Artigos.jdoGetautor(this);
    }

    public void setAutor(Utilizadores autor) {
        Utilizadores utilizadores = Artigos.jdoGetautor(this);
        Utilizadores utilizadores2 = autor;
        Artigos.jdoSetautor(this, utilizadores2);
        this.firePropertyChange(FIELDS.artigos_autor, (Object)utilizadores, (Object)utilizadores2);
    }

    public Utilizadores getEditor() {
        return Artigos.jdoGeteditor(this);
    }

    public void setEditor(Utilizadores editor) {
        Utilizadores utilizadores = Artigos.jdoGeteditor(this);
        Utilizadores utilizadores2 = editor;
        Artigos.jdoSeteditor(this, utilizadores2);
        this.firePropertyChange(FIELDS.artigos_editor, (Object)utilizadores, (Object)utilizadores2);
    }

    public Retencoes getRetencao() {
        return Artigos.jdoGetretencao(this);
    }

    public void setRetencao(Retencoes retencao) {
        Retencoes retencoes = Artigos.jdoGetretencao(this);
        Retencoes retencoes2 = retencao;
        Artigos.jdoSetretencao(this, retencoes2);
        this.firePropertyChange(FIELDS.artigos_retencao, (Object)retencoes, (Object)retencoes2);
    }

    public Codigosiva getCodigoiva() {
        return Artigos.jdoGetcodigoiva(this);
    }

    public void setCodigoiva(Codigosiva codigoiva) {
        Codigosiva codigosiva = Artigos.jdoGetcodigoiva(this);
        Codigosiva codigosiva2 = codigoiva;
        Artigos.jdoSetcodigoiva(this, codigosiva2);
        boolean changed = this.firePropertyChange(FIELDS.artigos_codigoiva, (Object)codigosiva, (Object)codigosiva2);
        if (changed && this.cascade && codigoiva != null) {
            this.setPrecoiva$Precopvp();
        }
    }

    public boolean isCodigoivaValid() {
        return Artigos.jdoGetcodigoiva(this) != null && Artigos.jdoGetcodigoiva(this).isValid(Artigos.jdoGetisencaoiva(this));
    }

    public Isencoesiva getIsencaoiva() {
        return Artigos.jdoGetisencaoiva(this);
    }

    public void setIsencaoiva(Isencoesiva isencaoiva) {
        Isencoesiva isencoesiva = Artigos.jdoGetisencaoiva(this);
        Isencoesiva isencoesiva2 = isencaoiva;
        Artigos.jdoSetisencaoiva(this, isencoesiva2);
        this.firePropertyChange(FIELDS.artigos_isencaoiva, (Object)isencoesiva, (Object)isencoesiva2);
    }

    public Grupos getGrupo() {
        return Artigos.jdoGetgrupo(this);
    }

    public void setGrupo(Grupos grupo) {
        Grupos grupos = Artigos.jdoGetgrupo(this);
        Grupos grupos2 = grupo;
        Artigos.jdoSetgrupo(this, grupos2);
        this.firePropertyChange(FIELDS.artigos_grupo, (Object)grupos, (Object)grupos2);
    }

    public Familias getFamilia() {
        return Artigos.jdoGetfamilia(this);
    }

    public void setFamilia(Familias familia) {
        Familias familias = Artigos.jdoGetfamilia(this);
        Familias familias2 = familia;
        Artigos.jdoSetfamilia(this, familias2);
        this.firePropertyChange(FIELDS.artigos_familia, (Object)familias, (Object)familias2);
    }

    @Deprecated
    public Familias getFamilia2() {
        return Artigos.jdoGetfamilia2(this);
    }

    @Deprecated
    public void setFamilia2(Familias familia) {
        Familias familias = Artigos.jdoGetfamilia2(this);
        Familias familias2 = Artigos.jdoGetfamilia2(this);
        Artigos.jdoSetfamilia2(this, familias2);
        this.firePropertyChange(FIELDS.artigos_familia2, (Object)familias, (Object)familias2);
    }

    public Date getDatacriacao() {
        return Artigos.jdoGetdatacriacao(this);
    }

    public String getDatacriacaoToText() {
        return Artigos.jdoGetdatacriacao(this) == null ? "" : FIELDS.artigos_datacriacao.format.format(Artigos.jdoGetdatacriacao(this));
    }

    public void setDatacriacao(Date datacriacao) {
        Date date = Artigos.jdoGetdatacriacao(this);
        Date date2 = TimeDateUtils.getDateWithoutTime((Date)datacriacao);
        Artigos.jdoSetdatacriacao(this, date2);
        this.firePropertyChange(FIELDS.artigos_datacriacao, (Object)date, (Object)date2);
    }

    public Date getDataalteracao() {
        return Artigos.jdoGetdataalteracao(this);
    }

    public String getDataalteracaoToText() {
        return Artigos.jdoGetdataalteracao(this) == null ? "" : FIELDS.artigos_dataalteracao.format.format(Artigos.jdoGetdataalteracao(this));
    }

    public void setDataalteracao(Date dataalteracao) {
        Date date = Artigos.jdoGetdataalteracao(this);
        Date date2 = dataalteracao;
        Artigos.jdoSetdataalteracao(this, date2);
        this.firePropertyChange(FIELDS.artigos_dataalteracao, (Object)date, (Object)date2);
    }

    @Override
    public String getKey() {
        return Artigos.jdoGetcodigo(this);
    }

    public String getCodigo() {
        return Artigos.jdoGetcodigo(this);
    }

    public String getCodigoToText() {
        return Artigos.jdoGetcodigo(this) == null ? "" : Artigos.jdoGetcodigo(this).toString();
    }

    public void setCodigo(String codigo) {
        String string = Artigos.jdoGetcodigo(this);
        String string2 = codigo;
        Artigos.jdoSetcodigo(this, string2);
        this.firePropertyChange(FIELDS.artigos_codigo, (Object)string, (Object)string2);
        for (AbstractModel linha : Artigos.jdoGetunidades(this)) {
            ((Artigosunidades)linha).setKey();
        }
        for (AbstractModel linha : Artigos.jdoGetprecos(this)) {
            ((Artigosprecos)linha).setKey();
        }
        for (AbstractModel linha : Artigos.jdoGetcomposicao(this)) {
            ((Artigoscomposicao)linha).setKey();
        }
        for (AbstractModel linha : Artigos.jdoGetexistencias(this)) {
            ((Artigosexistencias)linha).setKey();
        }
    }

    public boolean isCodigoValid() {
        boolean valid;
        boolean bl = valid = !StringUtils.contains((String)Artigos.jdoGetcodigo(this), (char[])new char[]{'?'});
        return valid || this.isEdited();
    }

    public String getDescricao() {
        return Artigos.jdoGetdescricao(this);
    }

    public String getDescricaoToText() {
        return Artigos.jdoGetdescricao(this) == null ? "" : Artigos.jdoGetdescricao(this).toString();
    }

    public void setDescricao(String descricao) {
        String string = Artigos.jdoGetdescricao(this);
        String string2 = descricao;
        Artigos.jdoSetdescricao(this, string2);
        this.firePropertyChange(FIELDS.artigos_descricao, (Object)string, (Object)string2);
    }

    public boolean isDescricaoValid() {
        boolean valid;
        boolean bl = valid = FIELDS.artigos_descricao.isValid(Artigos.jdoGetdescricao(this)) && Artigos.jdoGetdescricao(this).length() >= 2;
        return valid || this.isEdited();
    }

    public boolean isDescricaoEditable() {
        return !this.hasEntradas() && !this.hasSaidas() || this.manager.getUtilizador().isColibri();
    }

    public String getDescricao2() {
        return Artigos.jdoGetdescricao2(this);
    }

    public String getDescricao2ToText() {
        return Artigos.jdoGetdescricao2(this) == null ? "" : Artigos.jdoGetdescricao2(this).toString();
    }

    public void setDescricao2(String descricao2) {
        String string = Artigos.jdoGetdescricao2(this);
        String string2 = descricao2;
        Artigos.jdoSetdescricao2(this, string2);
        this.firePropertyChange(FIELDS.artigos_descricao2, (Object)string, (Object)string2);
    }

    public String getIntrastat() {
        return Artigos.jdoGetintrastat(this);
    }

    public String getIntrastatToText() {
        return Artigos.jdoGetintrastat(this) == null ? "" : Artigos.jdoGetintrastat(this).toString();
    }

    public void setIntrastat(String intrastat) {
        String string = Artigos.jdoGetintrastat(this);
        String string2 = intrastat;
        Artigos.jdoSetintrastat(this, string2);
        this.firePropertyChange(FIELDS.artigos_intrastat, (Object)string, (Object)string2);
    }

    public String getObs() {
        return Artigos.jdoGetobs(this);
    }

    public String getObsToText() {
        return Artigos.jdoGetobs(this) == null ? "" : FIELDS.artigos_obs.format.format(Artigos.jdoGetobs(this));
    }

    public void setObs(String obs) {
        String string = Artigos.jdoGetobs(this);
        String string2 = obs;
        Artigos.jdoSetobs(this, string2);
        this.firePropertyChange(FIELDS.artigos_obs, (Object)string, (Object)string2);
    }

    public String getCampo1() {
        return Artigos.jdoGetcampo1(this);
    }

    public String getCampo1ToText() {
        return Artigos.jdoGetcampo1(this) == null ? "" : Artigos.jdoGetcampo1(this).toString();
    }

    public void setCampo1(String campo1) {
        String string = Artigos.jdoGetcampo1(this);
        String string2 = campo1;
        Artigos.jdoSetcampo1(this, string2);
        this.firePropertyChange(FIELDS.artigos_campo1, (Object)string, (Object)string2);
    }

    public String getCampo2() {
        return Artigos.jdoGetcampo2(this);
    }

    public String getCampo2ToText() {
        return Artigos.jdoGetcampo2(this) == null ? "" : Artigos.jdoGetcampo2(this).toString();
    }

    public void setCampo2(String campo2) {
        String string = Artigos.jdoGetcampo2(this);
        String string2 = campo2;
        Artigos.jdoSetcampo2(this, string2);
        this.firePropertyChange(FIELDS.artigos_campo2, (Object)string, (Object)string2);
    }

    public String getCampo3() {
        return Artigos.jdoGetcampo3(this);
    }

    public String getCampo3ToText() {
        return Artigos.jdoGetcampo3(this) == null ? "" : Artigos.jdoGetcampo3(this).toString();
    }

    public void setCampo3(String campo3) {
        String string = Artigos.jdoGetcampo3(this);
        String string2 = campo3;
        Artigos.jdoSetcampo3(this, string2);
        this.firePropertyChange(FIELDS.artigos_campo3, (Object)string, (Object)string2);
    }

    public String getCampo4() {
        return Artigos.jdoGetcampo4(this);
    }

    public String getCampo4ToText() {
        return Artigos.jdoGetcampo4(this) == null ? "" : Artigos.jdoGetcampo4(this).toString();
    }

    public void setCampo4(String campo4) {
        String string = Artigos.jdoGetcampo4(this);
        String string2 = campo4;
        Artigos.jdoSetcampo4(this, string2);
        this.firePropertyChange(FIELDS.artigos_campo4, (Object)string, (Object)string2);
    }

    public String getCampo5() {
        return Artigos.jdoGetcampo5(this);
    }

    public String getCampo5ToText() {
        return Artigos.jdoGetcampo5(this) == null ? "" : Artigos.jdoGetcampo5(this).toString();
    }

    public void setCampo5(String campo5) {
        String string = Artigos.jdoGetcampo5(this);
        String string2 = campo5;
        Artigos.jdoSetcampo5(this, string2);
        this.firePropertyChange(FIELDS.artigos_campo5, (Object)string, (Object)string2);
    }

    public String getCampo6() {
        return Artigos.jdoGetcampo6(this);
    }

    public String getCampo6ToText() {
        return Artigos.jdoGetcampo6(this) == null ? "" : Artigos.jdoGetcampo6(this).toString();
    }

    public void setCampo6(String campo6) {
        String string = Artigos.jdoGetcampo6(this);
        String string2 = campo6;
        Artigos.jdoSetcampo6(this, string2);
        this.firePropertyChange(FIELDS.artigos_campo6, (Object)string, (Object)string2);
    }

    public String getCampo7() {
        return Artigos.jdoGetcampo7(this);
    }

    public String getCampo7ToText() {
        return Artigos.jdoGetcampo7(this) == null ? "" : Artigos.jdoGetcampo7(this).toString();
    }

    public void setCampo7(String campo7) {
        String string = Artigos.jdoGetcampo7(this);
        String string2 = campo7;
        Artigos.jdoSetcampo7(this, string2);
        this.firePropertyChange(FIELDS.artigos_campo7, (Object)string, (Object)string2);
    }

    public String getCampo8() {
        return Artigos.jdoGetcampo8(this);
    }

    public String getCampo8ToText() {
        return Artigos.jdoGetcampo8(this) == null ? "" : Artigos.jdoGetcampo8(this).toString();
    }

    public void setCampo8(String campo8) {
        String string = Artigos.jdoGetcampo8(this);
        String string2 = campo8;
        Artigos.jdoSetcampo8(this, string2);
        this.firePropertyChange(FIELDS.artigos_campo8, (Object)string, (Object)string2);
    }

    public String getCampo9() {
        return Artigos.jdoGetcampo9(this);
    }

    public String getCampo9ToText() {
        return Artigos.jdoGetcampo9(this) == null ? "" : Artigos.jdoGetcampo9(this).toString();
    }

    public void setCampo9(String campo9) {
        String string = Artigos.jdoGetcampo9(this);
        String string2 = campo9;
        Artigos.jdoSetcampo9(this, string2);
        this.firePropertyChange(FIELDS.artigos_campo9, (Object)string, (Object)string2);
    }

    public String getCampo10() {
        return Artigos.jdoGetcampo10(this);
    }

    public String getCampo10ToText() {
        return Artigos.jdoGetcampo10(this) == null ? "" : Artigos.jdoGetcampo10(this).toString();
    }

    public void setCampo10(String campo10) {
        String string = Artigos.jdoGetcampo10(this);
        String string2 = campo10;
        Artigos.jdoSetcampo10(this, string2);
        this.firePropertyChange(FIELDS.artigos_campo10, (Object)string, (Object)string2);
    }

    public Integer getTipo() {
        return Artigos.jdoGettipo(this);
    }

    public String getTipoToText() {
        return Artigos.jdoGettipo(this) == null ? "" : FIELDS.artigos_tipo.values[Artigos.jdoGettipo(this)];
    }

    public void setTipo(Integer tipo) {
        Integer n = Artigos.jdoGettipo(this);
        Integer n2 = tipo;
        Artigos.jdoSettipo(this, n2);
        this.firePropertyChange(FIELDS.artigos_tipo, (Object)n, (Object)n2);
    }

    public boolean isTipo(Integer tipo) {
        return Artigos.equals(tipo, Artigos.jdoGettipo(this));
    }

    public Integer getCategoria() {
        return Artigos.jdoGetcategoria(this);
    }

    public String getCategoriaToText() {
        return Artigos.jdoGetcategoria(this) == null ? "" : FIELDS.artigos_categoria.values[Artigos.jdoGetcategoria(this)];
    }

    public void setCategoria(Integer categoria) {
        Integer n = Artigos.jdoGetcategoria(this);
        Integer n2 = categoria;
        Artigos.jdoSetcategoria(this, n2);
        this.firePropertyChange(FIELDS.artigos_categoria, (Object)n, (Object)n2);
    }

    public boolean isCategoria(Integer categoria) {
        return Artigos.equals(categoria, Artigos.jdoGetcategoria(this));
    }

    public Integer getTipocusto() {
        return Artigos.jdoGettipocusto(this);
    }

    public String getTipocustoToText() {
        return Artigos.jdoGettipocusto(this) == null ? "" : FIELDS.artigos_tipocusto.values[Artigos.jdoGettipocusto(this)];
    }

    public void setTipocusto(Integer tipocusto) {
        Integer n = Artigos.jdoGettipocusto(this);
        Integer n2 = tipocusto;
        Artigos.jdoSettipocusto(this, n2);
        boolean changed = this.firePropertyChange(FIELDS.artigos_tipocusto, (Object)n, (Object)n2);
        if (changed && this.cascade) {
            this.setPerclucro$Precopvp();
        }
    }

    public boolean isTipocusto(Integer tipocusto) {
        return Artigos.equals(tipocusto, Artigos.jdoGettipocusto(this));
    }

    public BigDecimal getPrecocusto(BigDecimal factor) {
        switch (Artigos.jdoGettipocusto(this)) {
            case 1: {
                return Artigos.jdoGetcustoproducao(this).multiply(factor);
            }
            case 0: {
                switch (this.manager.getParametros().getPrecocusto()) {
                    case 0: {
                        return Artigos.jdoGetprecopcm(this).multiply(factor);
                    }
                    case 1: {
                        return Artigos.jdoGetprecoupc(this).multiply(factor);
                    }
                }
            }
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal setPrecoscusto(Artigosmovimentos movimento) {
        BigDecimal precocusto = this.getPrecocusto(movimento.getFactor());
        BigDecimal precoliquido = movimento.getPrecobaseliquido();
        BigDecimal precopcm = BusinessRules.averagePrice((BigDecimal)Artigos.jdoGetstockreal(this), (BigDecimal)Artigos.jdoGetprecopcm(this), (BigDecimal)movimento.getEntradas(), (BigDecimal)precoliquido);
        if (movimento.getEntradas().signum() != 0) {
            switch (movimento.getTipodocumento().getActualizaprecoscusto()) {
                case 1: {
                    this.setPrecopcm(precopcm);
                    break;
                }
                case 2: {
                    this.setPrecoupc(precoliquido);
                    break;
                }
                case 3: {
                    this.setPrecopcm(precopcm);
                    this.setPrecoupc(precoliquido);
                }
            }
        }
        return precocusto;
    }

    public void setPrecos(Artigosmovimentos movimento) {
        switch (this.manager.getParametros().getActualizaprecos()) {
            case 1: {
                this.setPrecoscusto(movimento);
                break;
            }
            case 2: {
                BigDecimal precocusto = this.setPrecoscusto(movimento);
                block4 : switch (Artigos.jdoGettipocusto(this)) {
                    case 1: {
                        break;
                    }
                    case 0: {
                        switch (movimento.getTipodocumento().getActualizaprecosvenda()) {
                            case 1: {
                                this.setPrecopvp$Perclucro();
                                break block4;
                            }
                            case 2: {
                                if (NumericUtils.isGreater((BigDecimal)this.getPrecocusto(movimento.getFactor()), (BigDecimal)precocusto)) {
                                    this.setPrecopvp$Perclucro();
                                    break block4;
                                }
                                this.setPerclucro$Precopvp();
                            }
                        }
                    }
                }
                if (movimento.getSaidas().signum() == 0 || movimento.getPreco().signum() == 0) break;
                this.setPrecoupv(movimento.getPrecobase());
            }
        }
    }

    public Integer getBotao() {
        return Artigos.jdoGetbotao(this);
    }

    public String getBotaoToText() {
        return Artigos.jdoGetbotao(this) == null ? "" : FIELDS.artigos_botao.values[Artigos.jdoGetbotao(this)];
    }

    public void setBotao(Integer botao) {
        Integer n = Artigos.jdoGetbotao(this);
        Integer n2 = botao;
        Artigos.jdoSetbotao(this, n2);
        this.firePropertyChange(FIELDS.artigos_botao, (Object)n, (Object)n2);
    }

    public boolean isBotao(Integer botao) {
        return Artigos.equals(botao, Artigos.jdoGetbotao(this));
    }

    public Integer getEstado() {
        return Artigos.jdoGetestado(this);
    }

    public String getEstadoToText() {
        return Artigos.jdoGetestado(this) == null ? "" : FIELDS.artigos_estado.values[Artigos.jdoGetestado(this)];
    }

    public void setEstado(Integer estado) {
        Integer n = Artigos.jdoGetestado(this);
        Integer n2 = estado;
        Artigos.jdoSetestado(this, n2);
        this.firePropertyChange(FIELDS.artigos_estado, (Object)n, (Object)n2);
    }

    public boolean isEstado(Integer estado) {
        return Artigos.equals(estado, Artigos.jdoGetestado(this));
    }

    public BigDecimal getStockminimo() {
        return Artigos.jdoGetstockminimo(this);
    }

    public String getStockminimoToText() {
        return Artigos.jdoGetstockminimo(this) == null ? "" : FIELDS.artigos_stockminimo.format.format(Artigos.jdoGetstockminimo(this));
    }

    public void setStockminimo(BigDecimal stockminimo) {
        BigDecimal bigDecimal = Artigos.jdoGetstockminimo(this);
        BigDecimal bigDecimal2 = stockminimo;
        Artigos.jdoSetstockminimo(this, bigDecimal2);
        this.firePropertyChange(FIELDS.artigos_stockminimo, (Object)bigDecimal, (Object)bigDecimal2);
    }

    public boolean hasStockminimo() {
        return Artigos.jdoGetstockminimo(this).signum() != 0;
    }

    public boolean isStockminimoReached() {
        return this.hasStockminimo() && NumericUtils.isLesser((BigDecimal)Artigos.jdoGetstockreal(this), (BigDecimal)Artigos.jdoGetstockminimo(this));
    }

    public boolean isStocknegativoReached() {
        return NumericUtils.isLesser((BigDecimal)Artigos.jdoGetstockreal(this), (BigDecimal)BigDecimal.ZERO);
    }

    public BigDecimal getSaidas() {
        return Artigos.jdoGetsaidas(this);
    }

    public String getSaidasToText() {
        return Artigos.jdoGetsaidas(this) == null ? "" : FIELDS.artigos_saidas.format.format(Artigos.jdoGetsaidas(this));
    }

    public void setSaidas(BigDecimal saidas) {
        BigDecimal bigDecimal = Artigos.jdoGetsaidas(this);
        BigDecimal bigDecimal2 = saidas;
        Artigos.jdoSetsaidas(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.artigos_saidas, (Object)bigDecimal, (Object)bigDecimal2);
        if (changed && this.cascade) {
            this.setStockreal(Artigos.jdoGetentradas(this).subtract(saidas));
        }
    }

    public boolean hasSaidas() {
        return Artigos.jdoGetsaidas(this).signum() != 0;
    }

    public BigDecimal getEntradas() {
        return Artigos.jdoGetentradas(this);
    }

    public String getEntradasToText() {
        return Artigos.jdoGetentradas(this) == null ? "" : FIELDS.artigos_entradas.format.format(Artigos.jdoGetentradas(this));
    }

    public void setEntradas(BigDecimal entradas) {
        BigDecimal bigDecimal = Artigos.jdoGetentradas(this);
        BigDecimal bigDecimal2 = entradas;
        Artigos.jdoSetentradas(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.artigos_entradas, (Object)bigDecimal, (Object)bigDecimal2);
        if (changed && this.cascade) {
            this.setStockreal(entradas.subtract(Artigos.jdoGetsaidas(this)));
        }
    }

    public boolean hasEntradas() {
        return Artigos.jdoGetentradas(this).signum() != 0;
    }

    public void addAcumulados(BigDecimal saidas, BigDecimal entradas, Integer tipostock, SIGNUM sinal) {
        switch (tipostock) {
            case 0: {
                this.setSaidas(Artigos.jdoGetsaidas(this).add(saidas.multiply(sinal.value)));
                this.setEntradas(Artigos.jdoGetentradas(this).add(entradas.multiply(sinal.value)));
                break;
            }
            case 1: {
                this.setStockexterior(Artigos.jdoGetstockexterior(this).add(entradas.subtract(saidas).multiply(sinal.value)));
                break;
            }
            case 2: {
                this.setStockencomendado(Artigos.jdoGetstockencomendado(this).add(entradas.subtract(saidas).multiply(sinal.value)));
                break;
            }
            case 3: {
                this.setStockreservado(Artigos.jdoGetstockreservado(this).add(entradas.subtract(saidas).multiply(sinal.value)));
            }
        }
    }

    public BigDecimal getStockreal() {
        return Artigos.jdoGetstockreal(this);
    }

    public String getStockrealToText() {
        return Artigos.jdoGetstockreal(this) == null ? "" : FIELDS.artigos_stockreal.format.format(Artigos.jdoGetstockreal(this));
    }

    public void setStockreal(BigDecimal stockreal) {
        BigDecimal bigDecimal = Artigos.jdoGetstockreal(this);
        BigDecimal bigDecimal2 = stockreal;
        Artigos.jdoSetstockreal(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.artigos_stockreal, (Object)bigDecimal, (Object)bigDecimal2);
        if (changed && this.cascade) {
            this.setStockprevisto(stockreal.add(Artigos.jdoGetstockexterior(this)).add(Artigos.jdoGetstockencomendado(this).add(Artigos.jdoGetstockreservado(this))));
        }
    }

    public BigDecimal getStockexterior() {
        return Artigos.jdoGetstockexterior(this);
    }

    public String getStockexteriorToText() {
        return Artigos.jdoGetstockexterior(this) == null ? "" : FIELDS.artigos_stockexterior.format.format(Artigos.jdoGetstockexterior(this));
    }

    public void setStockexterior(BigDecimal stockexterior) {
        BigDecimal bigDecimal = Artigos.jdoGetstockexterior(this);
        BigDecimal bigDecimal2 = stockexterior;
        Artigos.jdoSetstockexterior(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.artigos_stockexterior, (Object)bigDecimal, (Object)bigDecimal2);
        if (changed && this.cascade) {
            this.setStockprevisto(Artigos.jdoGetstockreal(this).add(stockexterior).add(Artigos.jdoGetstockencomendado(this).add(Artigos.jdoGetstockreservado(this))));
        }
    }

    public BigDecimal getStockencomendado() {
        return Artigos.jdoGetstockencomendado(this);
    }

    public String getStockencomendadoToText() {
        return Artigos.jdoGetstockencomendado(this) == null ? "" : FIELDS.artigos_stockencomendado.format.format(Artigos.jdoGetstockencomendado(this));
    }

    public void setStockencomendado(BigDecimal stockencomendado) {
        BigDecimal bigDecimal = Artigos.jdoGetstockencomendado(this);
        BigDecimal bigDecimal2 = stockencomendado;
        Artigos.jdoSetstockencomendado(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.artigos_stockencomendado, (Object)bigDecimal, (Object)bigDecimal2);
        if (changed && this.cascade) {
            this.setStockprevisto(Artigos.jdoGetstockreal(this).add(Artigos.jdoGetstockexterior(this)).add(stockencomendado.add(Artigos.jdoGetstockreservado(this))));
        }
    }

    public BigDecimal getStockreservado() {
        return Artigos.jdoGetstockreservado(this);
    }

    public String getStockreservadoToText() {
        return Artigos.jdoGetstockreservado(this) == null ? "" : FIELDS.artigos_stockreservado.format.format(Artigos.jdoGetstockreservado(this));
    }

    public void setStockreservado(BigDecimal stockreservado) {
        BigDecimal bigDecimal = Artigos.jdoGetstockreservado(this);
        BigDecimal bigDecimal2 = stockreservado;
        Artigos.jdoSetstockreservado(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.artigos_stockreservado, (Object)bigDecimal, (Object)bigDecimal2);
        if (changed && this.cascade) {
            this.setStockprevisto(Artigos.jdoGetstockreal(this).add(Artigos.jdoGetstockexterior(this)).add(Artigos.jdoGetstockencomendado(this).add(stockreservado)));
        }
    }

    public BigDecimal getStockprevisto() {
        return Artigos.jdoGetstockprevisto(this);
    }

    public String getStockprevistoToText() {
        return Artigos.jdoGetstockprevisto(this) == null ? "" : FIELDS.artigos_stockprevisto.format.format(Artigos.jdoGetstockprevisto(this));
    }

    public void setStockprevisto(BigDecimal stockprevisto) {
        BigDecimal bigDecimal = Artigos.jdoGetstockprevisto(this);
        BigDecimal bigDecimal2 = stockprevisto;
        Artigos.jdoSetstockprevisto(this, bigDecimal2);
        this.firePropertyChange(FIELDS.artigos_stockprevisto, (Object)bigDecimal, (Object)bigDecimal2);
    }

    public BigDecimal getPrecoupc() {
        return Artigos.jdoGetprecoupc(this);
    }

    public String getPrecoupcToText() {
        return Artigos.jdoGetprecoupc(this) == null ? "" : FIELDS.artigos_precoupc.format.format(Artigos.jdoGetprecoupc(this));
    }

    public void setPrecoupc(BigDecimal precoupc) {
        BigDecimal bigDecimal = Artigos.jdoGetprecoupc(this);
        BigDecimal bigDecimal2 = precoupc;
        Artigos.jdoSetprecoupc(this, bigDecimal2);
        this.firePropertyChange(FIELDS.artigos_precoupc, (Object)bigDecimal, (Object)bigDecimal2);
    }

    public boolean isPrecoupcEditable() {
        return this.manager.getUtilizador().isGestor();
    }

    public BigDecimal getPrecoupv() {
        return Artigos.jdoGetprecoupv(this);
    }

    public String getPrecoupvToText() {
        return Artigos.jdoGetprecoupv(this) == null ? "" : FIELDS.artigos_precoupv.format.format(Artigos.jdoGetprecoupv(this));
    }

    public void setPrecoupv(BigDecimal precoupv) {
        BigDecimal bigDecimal = Artigos.jdoGetprecoupv(this);
        BigDecimal bigDecimal2 = precoupv;
        Artigos.jdoSetprecoupv(this, bigDecimal2);
        this.firePropertyChange(FIELDS.artigos_precoupv, (Object)bigDecimal, (Object)bigDecimal2);
    }

    public boolean isPrecoupvEditable() {
        return this.manager.getUtilizador().isGestor();
    }

    public BigDecimal getPrecopcm() {
        return Artigos.jdoGetprecopcm(this);
    }

    public String getPrecopcmToText() {
        return Artigos.jdoGetprecopcm(this) == null ? "" : FIELDS.artigos_precopcm.format.format(Artigos.jdoGetprecopcm(this));
    }

    public void setPrecopcm(BigDecimal precopcm) {
        BigDecimal bigDecimal = Artigos.jdoGetprecopcm(this);
        BigDecimal bigDecimal2 = precopcm;
        Artigos.jdoSetprecopcm(this, bigDecimal2);
        this.firePropertyChange(FIELDS.artigos_precopcm, (Object)bigDecimal, (Object)bigDecimal2);
    }

    public boolean isPrecopcmEditable() {
        return !this.hasEntradas() && !this.hasSaidas() || this.manager.getUtilizador().isColibri();
    }

    public BigDecimal getCustoproducao() {
        return Artigos.jdoGetcustoproducao(this);
    }

    public String getCustoproducaoToText() {
        return Artigos.jdoGetcustoproducao(this) == null ? "" : FIELDS.artigos_custoproducao.format.format(Artigos.jdoGetcustoproducao(this));
    }

    public void setCustoproducao(BigDecimal custoproducao) {
        BigDecimal bigDecimal = Artigos.jdoGetcustoproducao(this);
        BigDecimal bigDecimal2 = custoproducao;
        Artigos.jdoSetcustoproducao(this, bigDecimal2);
        this.firePropertyChange(FIELDS.artigos_custoproducao, (Object)bigDecimal, (Object)bigDecimal2);
    }

    public byte[] getImagem() {
        try {
            return Artigos.jdoGetimagem(this);
        }
        catch (JDODetachedFieldAccessException jDODetachedFieldAccessException) {
            return null;
        }
    }

    public void setImagem(byte[] imagem) {
        byte[] byArray = Artigos.jdoGetimagem(this);
        byte[] byArray2 = imagem == null || imagem.length == 0 ? null : imagem;
        Artigos.jdoSetimagem(this, byArray2);
        this.firePropertyChange(FIELDS.artigos_imagem, (Object)byArray, (Object)byArray2);
    }

    public boolean hasImagem() {
        return this.getImagem() != null && Artigos.jdoGetimagem(this).length > 0;
    }

    public int saveImagem(String pathname) {
        return this.hasImagem() ? new ByteFile(pathname, new String[0]).write(Artigos.jdoGetimagem(this)) : 0;
    }

    public Artigosunidades createUnidades() {
        return new Artigosunidades(this, this.manager.getParametros().getUnidademedida(), BigDecimal.ONE);
    }

    public Artigosunidades createUnidades(String unidademedida, BigDecimal factor) {
        return new Artigosunidades(this, this.manager.loadUnidadesmedida(unidademedida), factor);
    }

    public Collection<Artigosunidades> getUnidades() {
        return Collections.unmodifiableList(Artigos.jdoGetunidades(this));
    }

    public Artigosunidades getUnidades(int index) {
        return index >= Artigos.jdoGetunidades(this).size() ? null : (Artigosunidades)Artigos.jdoGetunidades(this).get(index);
    }

    public Artigosunidades getUnidades(String key) {
        for (Artigosunidades linha : Artigos.jdoGetunidades(this)) {
            if (!linha.getKey().equals(key)) continue;
            return linha;
        }
        return null;
    }

    public Artigosunidades getUnidades(Unidadesmedida unidademedida) {
        for (Artigosunidades linha : Artigos.jdoGetunidades(this)) {
            if (!linha.getUnidademedida().equals(unidademedida)) continue;
            return linha;
        }
        return null;
    }

    public boolean containsUnidades(Unidadesmedida unidademedida) {
        return this.getUnidades(unidademedida) != null;
    }

    public void setUnidades(Collection<Artigosunidades> unidades) {
        Artigos.jdoGetunidades(this).clear();
        this.addUnidades(unidades);
    }

    public Artigosunidades addUnidades() {
        return this.addUnidades(this.createUnidades());
    }

    public Artigosunidades addUnidades(String unidademedida, BigDecimal factor) {
        Artigosunidades unidade = this.createUnidades(unidademedida, factor);
        return unidade.getKey() == null ? null : this.addUnidades(unidade);
    }

    public Artigosunidades addUnidades(Artigosunidades unidades) {
        if (unidades != null) {
            this.addUnidades(Arrays.asList(unidades));
        }
        return unidades;
    }

    public void addUnidades(Collection<Artigosunidades> unidades) {
        int index = Artigos.jdoGetunidades(this).size();
        for (Artigosunidades linha : unidades) {
            linha.setNumerolinha(++index);
            linha.setArtigo(this);
        }
        Artigos.jdoGetunidades(this).addAll(unidades);
    }

    public void removeUnidades() {
        this.removeUnidades(Artigos.jdoGetunidades(this));
    }

    public void removeUnidades(int index) {
        this.removeUnidades(this.getUnidades(index));
    }

    public void removeUnidades(Artigosunidades unidades) {
        this.removeUnidades(Arrays.asList(unidades));
    }

    public void removeUnidades(Collection<Artigosunidades> unidades) {
        Artigos.jdoGetunidades(this).removeAll(unidades);
        int index = 0;
        for (Artigosunidades linha : Artigos.jdoGetunidades(this)) {
            linha.setNumerolinha(++index);
        }
    }

    public boolean isUnidadesValid() {
        HashSet<String> col = new HashSet<String>();
        for (Artigosunidades linha : Artigos.jdoGetunidades(this)) {
            if (col.add(linha.getKey())) continue;
            return false;
        }
        return !col.isEmpty();
    }

    public BigDecimal getPrecocusto(Unidadesmedida unidademedida) {
        Artigosunidades unidade = this.getUnidades(unidademedida);
        return unidade == null ? BigDecimal.ZERO : this.getPrecocusto(unidade.getFactor());
    }

    public Artigosprecos createPrecos() {
        return new Artigosprecos(this, this.manager.loadPrecarios(), this.getUnidades(0) == null ? this.manager.getParametros().getUnidademedida() : this.getUnidades(0).getUnidademedida());
    }

    public Artigosprecos createPrecos(String precario, String unidademedida) {
        return new Artigosprecos(this, this.manager.loadPrecarios(precario), this.manager.loadUnidadesmedida(unidademedida));
    }

    public Collection<Artigosprecos> getPrecos() {
        return Collections.unmodifiableList(Artigos.jdoGetprecos(this));
    }

    public Artigosprecos getPrecos(int index) {
        return index >= Artigos.jdoGetprecos(this).size() ? null : (Artigosprecos)Artigos.jdoGetprecos(this).get(index);
    }

    public Artigosprecos getPrecos(String key) {
        for (Artigosprecos linha : Artigos.jdoGetprecos(this)) {
            if (!linha.getKey().equals(key)) continue;
            return linha;
        }
        return null;
    }

    public void setPrecos(Collection<Artigosprecos> precos) {
        Artigos.jdoGetprecos(this).clear();
        this.addPrecos(precos);
    }

    public Artigosprecos addPrecos() {
        return this.addPrecos(this.createPrecos());
    }

    public Artigosprecos addPrecos(String precario, String unidademedida) {
        Artigosprecos preco = this.createPrecos(precario, unidademedida);
        return preco.getKey() == null ? null : this.addPrecos(preco);
    }

    public Artigosprecos addPrecos(Artigosprecos precos) {
        if (precos != null) {
            this.addPrecos(Arrays.asList(precos));
        }
        return precos;
    }

    public void addPrecos(Collection<Artigosprecos> precos) {
        int index = Artigos.jdoGetprecos(this).size();
        for (Artigosprecos linha : precos) {
            linha.setNumerolinha(++index);
            linha.setArtigo(this);
        }
        Artigos.jdoGetprecos(this).addAll(precos);
    }

    public void removePrecos() {
        this.removePrecos(Artigos.jdoGetprecos(this));
    }

    public void removePrecos(int index) {
        this.removePrecos(this.getPrecos(index));
    }

    public void removePrecos(Artigosprecos precos) {
        this.removePrecos(Arrays.asList(precos));
    }

    public void removePrecos(Collection<Artigosprecos> precos) {
        Artigos.jdoGetprecos(this).removeAll(precos);
        int index = 0;
        for (Artigosprecos linha : Artigos.jdoGetprecos(this)) {
            linha.setNumerolinha(++index);
        }
    }

    public boolean isPrecosValid() {
        HashSet<String> col = new HashSet<String>();
        for (Artigosprecos linha : Artigos.jdoGetprecos(this)) {
            if (col.add(linha.getKey())) continue;
            return false;
        }
        return !col.isEmpty();
    }

    private void setPerclucro$Precopvp() {
        for (Artigosprecos linha : Artigos.jdoGetprecos(this)) {
            linha.setPerclucro$Precopvp();
        }
    }

    private void setPrecopvp$Perclucro() {
        for (Artigosprecos linha : Artigos.jdoGetprecos(this)) {
            linha.setPrecopvp$Perclucro();
        }
    }

    private void setPrecoiva$Precopvp() {
        for (Artigosprecos linha : Artigos.jdoGetprecos(this)) {
            linha.setPrecoiva$Precopvp();
        }
    }

    public Artigoscomposicao createComposicao() {
        return new Artigoscomposicao(this);
    }

    public Artigoscomposicao createComposicao(String componente) {
        return new Artigoscomposicao(this, this.manager.loadArtigos(componente));
    }

    public Collection<Artigoscomposicao> getComposicao() {
        return Collections.unmodifiableList(Artigos.jdoGetcomposicao(this));
    }

    public Artigoscomposicao getComposicao(int index) {
        return index >= Artigos.jdoGetcomposicao(this).size() ? null : (Artigoscomposicao)Artigos.jdoGetcomposicao(this).get(index);
    }

    public Artigoscomposicao getComposicao(String key) {
        for (Artigoscomposicao linha : Artigos.jdoGetcomposicao(this)) {
            if (!linha.getKey().equals(key)) continue;
            return linha;
        }
        return null;
    }

    public void setComposicao() {
        for (Artigoscomposicao linha : Artigos.jdoGetcomposicao(this)) {
            Artigos componente = this.manager.loadArtigos(linha.getComponente().getCodigo(), false);
            linha.setComponente(componente, linha.getUnidademedida());
        }
    }

    public void setComposicao(Collection<Artigoscomposicao> composicao) {
        Artigos.jdoGetcomposicao(this).clear();
        this.addComposicao(composicao);
    }

    public Artigoscomposicao addComposicao() {
        return this.addComposicao(this.createComposicao());
    }

    public Artigoscomposicao addComposicao(String componente) {
        Artigoscomposicao composicao = this.createComposicao(componente);
        return composicao.getKey() == null ? null : this.addComposicao(composicao);
    }

    public Artigoscomposicao addComposicao(Artigoscomposicao composicao) {
        this.addComposicao((Collection<Artigoscomposicao>)(composicao == null ? Collections.EMPTY_LIST : Arrays.asList(composicao)));
        return composicao;
    }

    public void addComposicao(Collection<Artigoscomposicao> composicao) {
        int index = Artigos.jdoGetcomposicao(this).size();
        for (Artigoscomposicao linha : composicao) {
            linha.setNumerolinha(++index);
            linha.setArtigo(this);
        }
        boolean changed = Artigos.jdoGetcomposicao(this).addAll(composicao);
        if (changed && this.cascade) {
            this.process();
        }
    }

    public void removeComposicao() {
        this.removeComposicao(Artigos.jdoGetcomposicao(this));
    }

    public void removeComposicao(int index) {
        this.removeComposicao(this.getComposicao(index));
    }

    public void removeComposicao(Artigoscomposicao composicao) {
        this.removeComposicao(Arrays.asList(composicao));
    }

    public void removeComposicao(Collection<Artigoscomposicao> composicao) {
        Artigos.jdoGetcomposicao(this).removeAll(composicao);
        int index = 0;
        for (Artigoscomposicao linha : Artigos.jdoGetcomposicao(this)) {
            linha.setNumerolinha(++index);
        }
        if (this.cascade) {
            this.process();
        }
    }

    public Collection<Artigosexistencias> getExistencias() {
        return Collections.unmodifiableList(Artigos.jdoGetexistencias(this));
    }

    public Artigosexistencias getExistencias(int index) {
        return index >= Artigos.jdoGetexistencias(this).size() ? null : (Artigosexistencias)Artigos.jdoGetexistencias(this).get(index);
    }

    public Artigosexistencias getExistencias(String key) {
        for (Artigosexistencias linha : Artigos.jdoGetexistencias(this)) {
            if (!linha.getKey().equals(key)) continue;
            return linha;
        }
        return null;
    }

    public void setExistencias(Collection<Artigosexistencias> existencias) {
        Artigos.jdoGetexistencias(this).clear();
        this.addExistencias(existencias);
    }

    public Artigosexistencias addExistencias(Artigosexistencias existencias) {
        if (existencias != null) {
            this.addExistencias(Arrays.asList(existencias));
        }
        return existencias;
    }

    public void addExistencias(Collection<Artigosexistencias> existencias) {
        for (Artigosexistencias linha : existencias) {
            linha.setArtigo(this);
        }
        Artigos.jdoGetexistencias(this).addAll(existencias);
    }

    public void removeExistencias() {
        this.removeExistencias(Artigos.jdoGetexistencias(this));
    }

    public void removeExistencias(Artigosexistencias existencias) {
        this.removeExistencias(Arrays.asList(existencias));
    }

    public void removeExistencias(Collection<Artigosexistencias> existencias) {
        Artigos.jdoGetexistencias(this).removeAll(existencias);
    }

    public void addExistencias(Artigosmovimentos movimento, SIGNUM sinal) {
        Armazens[] armazensArray = new Armazens[]{movimento.getArmazem(), movimento.getArmazemdestino()};
        int n = armazensArray.length;
        int n2 = 0;
        while (n2 < n) {
            Armazens armazem = armazensArray[n2];
            if (armazem != null) {
                switch (movimento.getTipostock()) {
                    case 0: {
                        Artigosexistencias existencias = this.getExistencias(Artigosexistencias.generateKey(movimento.getArtigo().getCodigo(), armazem.getCodigo(), movimento.getNumeroserie(), movimento.getTamanho().getCodigo(), movimento.getCor().getCodigo()));
                        if (existencias == null) {
                            existencias = new Artigosexistencias(movimento, armazem);
                            this.addExistencias(existencias);
                        }
                        existencias.addAcumulados(movimento.getSaidas(), movimento.getEntradas(), movimento.getArmazem(), movimento.getArmazemdestino(), sinal);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
            }
            ++n2;
        }
    }

    @Override
    public boolean isEditable(FIELDS field) {
        return !(!super.isEditable(field) || field == FIELDS.artigos_autor || field == FIELDS.artigos_editor || field == FIELDS.artigos_datacriacao || field == FIELDS.artigos_dataalteracao || field == FIELDS.artigos_descricao && this.isEdited() && !this.isDescricaoEditable() || field == FIELDS.artigos_saidas || field == FIELDS.artigos_entradas || field == FIELDS.artigos_stockreal || field == FIELDS.artigos_stockexterior || field == FIELDS.artigos_stockencomendado || field == FIELDS.artigos_stockreservado || field == FIELDS.artigos_stockprevisto || field == FIELDS.artigos_custoproducao || field == FIELDS.artigos_precoupc && !this.isPrecoupcEditable() || field == FIELDS.artigos_precoupv && !this.isPrecoupvEditable() || field == FIELDS.artigos_precopcm && !this.isPrecopcmEditable());
    }

    @Override
    public void attach(DatabaseManager manager) {
        manager.attach(Artigos.jdoGetunidades(this));
        manager.attach(Artigos.jdoGetprecos(this));
        manager.attach(Artigos.jdoGetcomposicao(this));
        manager.attach(Artigos.jdoGetexistencias(this));
        manager.attach(new AbstractModel[]{Artigos.jdoGetautor(this), Artigos.jdoGeteditor(this), Artigos.jdoGetretencao(this), Artigos.jdoGetcodigoiva(this), Artigos.jdoGetisencaoiva(this), Artigos.jdoGetgrupo(this), Artigos.jdoGetfamilia(this), Artigos.jdoGetfamilia2(this)});
    }

    @Override
    public boolean isDirty() {
        return super.isDirty() || this.isDirty(Artigos.jdoGetunidades(this)) || this.isDirty(Artigos.jdoGetprecos(this)) || this.isDirty(Artigos.jdoGetcomposicao(this)) || this.isDirty(Artigos.jdoGetexistencias(this));
    }

    public String toString() {
        return String.valueOf(Artigos.jdoGetcodigo(this)) + " - " + Artigos.jdoGetdescricao(this);
    }

    public int hashCode() {
        return Artigos.jdoGetcodigo(this) == null ? 0 : Artigos.jdoGetcodigo(this).hashCode();
    }

    public boolean equals(Object obj) {
        return this.hashCode() == obj.hashCode();
    }

    public void jdoCopyKeyFieldsFromObjectId(PersistenceCapable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("oid is not instanceof javax.jdo.identity.StringIdentity");
        }
        StringIdentity o = (StringIdentity)oid;
        fc.storeStringField(13, o.getKey());
    }

    protected void jdoCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("key class is not javax.jdo.identity.StringIdentity or null");
        }
        StringIdentity o = (StringIdentity)oid;
        this.codigo = o.getKey();
    }

    public final void jdoCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final void jdoCopyKeyFieldsToObjectId(PersistenceCapable.ObjectIdFieldSupplier fs, Object object) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final Object jdoGetObjectId() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getObjectId((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[0];
    }

    public final Object jdoGetVersion() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getVersion((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[1];
    }

    protected final void jdoPreSerialize() {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.preSerialize((PersistenceCapable)this);
        }
    }

    public final PersistenceManager jdoGetPersistenceManager() {
        return this.jdoStateManager != null ? this.jdoStateManager.getPersistenceManager((PersistenceCapable)this) : null;
    }

    public final Object jdoGetTransactionalObjectId() {
        return this.jdoStateManager != null ? this.jdoStateManager.getTransactionalObjectId((PersistenceCapable)this) : null;
    }

    public final boolean jdoIsDeleted() {
        return this.jdoStateManager != null ? this.jdoStateManager.isDeleted((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsDirty() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.isDirty((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return false;
        }
        return ((BitSet)this.jdoDetachedState[3]).length() > 0;
    }

    public final boolean jdoIsNew() {
        return this.jdoStateManager != null ? this.jdoStateManager.isNew((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsPersistent() {
        return this.jdoStateManager != null ? this.jdoStateManager.isPersistent((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsTransactional() {
        return this.jdoStateManager != null ? this.jdoStateManager.isTransactional((PersistenceCapable)this) : false;
    }

    public void jdoMakeDirty(String fieldName) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.makeDirty((PersistenceCapable)this, fieldName);
        }
        if (this.jdoIsDetached() && fieldName != null) {
            String fldName = null;
            fldName = fieldName.indexOf(46) >= 0 ? fieldName.substring(fieldName.lastIndexOf(46) + 1) : fieldName;
            int i = 0;
            while (i < jdoFieldNames.length) {
                if (jdoFieldNames[i].equals(fldName)) {
                    if (!((BitSet)this.jdoDetachedState[2]).get(i + jdoInheritedFieldCount)) {
                        throw new JDODetachedFieldAccessException("You have just attempted to access a field/property that hasn't been detached. Please detach it first before performing this operation");
                    }
                    ((BitSet)this.jdoDetachedState[3]).set(i + jdoInheritedFieldCount);
                    return;
                }
                ++i;
            }
        }
    }

    public final Object jdoNewObjectIdInstance() {
        return new StringIdentity(this.getClass(), this.codigo);
    }

    public final Object jdoNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new StringIdentity(this.getClass(), (String)key);
        }
        return new StringIdentity(this.getClass(), (String)key);
    }

    public final void jdoProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void jdoReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.jdoReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void jdoReplaceFlags() {
        if (this.jdoStateManager != null) {
            this.jdoFlags = this.jdoStateManager.replacingFlags((PersistenceCapable)this);
        }
    }

    public final synchronized void jdoReplaceStateManager(StateManager sm) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager = this.jdoStateManager.replacingStateManager((PersistenceCapable)this, sm);
        } else {
            JDOImplHelper.checkAuthorizedStateManager((StateManager)sm);
            this.jdoStateManager = sm;
            this.jdoFlags = 1;
        }
    }

    public final synchronized void jdoReplaceDetachedState() {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        this.jdoDetachedState = this.jdoStateManager.replacingDetachedState((Detachable)this, this.jdoDetachedState);
    }

    public boolean jdoIsDetached() {
        return this.jdoStateManager == null && this.jdoDetachedState != null;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm) {
        Artigos result = new Artigos();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        return result;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm, Object obj) {
        Artigos result = new Artigos();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        result.jdoCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void jdoReplaceField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.autor = (Utilizadores)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 1: {
                this.botao = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 2: {
                this.campo1 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 3: {
                this.campo10 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 4: {
                this.campo2 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 5: {
                this.campo3 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 6: {
                this.campo4 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 7: {
                this.campo5 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 8: {
                this.campo6 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 9: {
                this.campo7 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 10: {
                this.campo8 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 11: {
                this.campo9 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 12: {
                this.categoria = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 13: {
                this.codigo = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 14: {
                this.codigoiva = (Codigosiva)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 15: {
                this.composicao = (List)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 16: {
                this.custoproducao = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 17: {
                this.dataalteracao = (Date)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 18: {
                this.datacriacao = (Date)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 19: {
                this.descricao = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 20: {
                this.descricao2 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 21: {
                this.editor = (Utilizadores)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 22: {
                this.entradas = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 23: {
                this.estado = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 24: {
                this.existencias = (List)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 25: {
                this.familia = (Familias)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 26: {
                this.familia2 = (Familias)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 27: {
                this.grupo = (Grupos)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 28: {
                this.imagem = (byte[])this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 29: {
                this.intrastat = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 30: {
                this.isencaoiva = (Isencoesiva)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 31: {
                this.obs = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 32: {
                this.precopcm = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 33: {
                this.precos = (List)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 34: {
                this.precoupc = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 35: {
                this.precoupv = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 36: {
                this.retencao = (Retencoes)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 37: {
                this.saidas = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 38: {
                this.stockencomendado = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 39: {
                this.stockexterior = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 40: {
                this.stockminimo = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 41: {
                this.stockprevisto = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 42: {
                this.stockreal = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 43: {
                this.stockreservado = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 44: {
                this.tipo = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 45: {
                this.tipocusto = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 46: {
                this.unidades = (List)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoProvideField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.autor);
                break;
            }
            case 1: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.botao);
                break;
            }
            case 2: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.campo1);
                break;
            }
            case 3: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.campo10);
                break;
            }
            case 4: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.campo2);
                break;
            }
            case 5: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.campo3);
                break;
            }
            case 6: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.campo4);
                break;
            }
            case 7: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.campo5);
                break;
            }
            case 8: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.campo6);
                break;
            }
            case 9: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.campo7);
                break;
            }
            case 10: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.campo8);
                break;
            }
            case 11: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.campo9);
                break;
            }
            case 12: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.categoria);
                break;
            }
            case 13: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.codigo);
                break;
            }
            case 14: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.codigoiva);
                break;
            }
            case 15: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, this.composicao);
                break;
            }
            case 16: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.custoproducao);
                break;
            }
            case 17: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.dataalteracao);
                break;
            }
            case 18: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.datacriacao);
                break;
            }
            case 19: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.descricao);
                break;
            }
            case 20: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.descricao2);
                break;
            }
            case 21: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.editor);
                break;
            }
            case 22: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.entradas);
                break;
            }
            case 23: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.estado);
                break;
            }
            case 24: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, this.existencias);
                break;
            }
            case 25: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.familia);
                break;
            }
            case 26: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.familia2);
                break;
            }
            case 27: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.grupo);
                break;
            }
            case 28: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.imagem);
                break;
            }
            case 29: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.intrastat);
                break;
            }
            case 30: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.isencaoiva);
                break;
            }
            case 31: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.obs);
                break;
            }
            case 32: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.precopcm);
                break;
            }
            case 33: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, this.precos);
                break;
            }
            case 34: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.precoupc);
                break;
            }
            case 35: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.precoupv);
                break;
            }
            case 36: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.retencao);
                break;
            }
            case 37: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.saidas);
                break;
            }
            case 38: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.stockencomendado);
                break;
            }
            case 39: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.stockexterior);
                break;
            }
            case 40: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.stockminimo);
                break;
            }
            case 41: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.stockprevisto);
                break;
            }
            case 42: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.stockreal);
                break;
            }
            case 43: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.stockreservado);
                break;
            }
            case 44: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.tipo);
                break;
            }
            case 45: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.tipocusto);
                break;
            }
            case 46: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, this.unidades);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void jdoCopyField(Artigos obj, int index) {
        switch (index) {
            case 0: {
                this.autor = obj.autor;
                break;
            }
            case 1: {
                this.botao = obj.botao;
                break;
            }
            case 2: {
                this.campo1 = obj.campo1;
                break;
            }
            case 3: {
                this.campo10 = obj.campo10;
                break;
            }
            case 4: {
                this.campo2 = obj.campo2;
                break;
            }
            case 5: {
                this.campo3 = obj.campo3;
                break;
            }
            case 6: {
                this.campo4 = obj.campo4;
                break;
            }
            case 7: {
                this.campo5 = obj.campo5;
                break;
            }
            case 8: {
                this.campo6 = obj.campo6;
                break;
            }
            case 9: {
                this.campo7 = obj.campo7;
                break;
            }
            case 10: {
                this.campo8 = obj.campo8;
                break;
            }
            case 11: {
                this.campo9 = obj.campo9;
                break;
            }
            case 12: {
                this.categoria = obj.categoria;
                break;
            }
            case 13: {
                this.codigo = obj.codigo;
                break;
            }
            case 14: {
                this.codigoiva = obj.codigoiva;
                break;
            }
            case 15: {
                this.composicao = obj.composicao;
                break;
            }
            case 16: {
                this.custoproducao = obj.custoproducao;
                break;
            }
            case 17: {
                this.dataalteracao = obj.dataalteracao;
                break;
            }
            case 18: {
                this.datacriacao = obj.datacriacao;
                break;
            }
            case 19: {
                this.descricao = obj.descricao;
                break;
            }
            case 20: {
                this.descricao2 = obj.descricao2;
                break;
            }
            case 21: {
                this.editor = obj.editor;
                break;
            }
            case 22: {
                this.entradas = obj.entradas;
                break;
            }
            case 23: {
                this.estado = obj.estado;
                break;
            }
            case 24: {
                this.existencias = obj.existencias;
                break;
            }
            case 25: {
                this.familia = obj.familia;
                break;
            }
            case 26: {
                this.familia2 = obj.familia2;
                break;
            }
            case 27: {
                this.grupo = obj.grupo;
                break;
            }
            case 28: {
                this.imagem = obj.imagem;
                break;
            }
            case 29: {
                this.intrastat = obj.intrastat;
                break;
            }
            case 30: {
                this.isencaoiva = obj.isencaoiva;
                break;
            }
            case 31: {
                this.obs = obj.obs;
                break;
            }
            case 32: {
                this.precopcm = obj.precopcm;
                break;
            }
            case 33: {
                this.precos = obj.precos;
                break;
            }
            case 34: {
                this.precoupc = obj.precoupc;
                break;
            }
            case 35: {
                this.precoupv = obj.precoupv;
                break;
            }
            case 36: {
                this.retencao = obj.retencao;
                break;
            }
            case 37: {
                this.saidas = obj.saidas;
                break;
            }
            case 38: {
                this.stockencomendado = obj.stockencomendado;
                break;
            }
            case 39: {
                this.stockexterior = obj.stockexterior;
                break;
            }
            case 40: {
                this.stockminimo = obj.stockminimo;
                break;
            }
            case 41: {
                this.stockprevisto = obj.stockprevisto;
                break;
            }
            case 42: {
                this.stockreal = obj.stockreal;
                break;
            }
            case 43: {
                this.stockreservado = obj.stockreservado;
                break;
            }
            case 44: {
                this.tipo = obj.tipo;
                break;
            }
            case 45: {
                this.tipocusto = obj.tipocusto;
                break;
            }
            case 46: {
                this.unidades = obj.unidades;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoCopyFields(Object obj, int[] indices) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof Artigos)) {
            throw new IllegalArgumentException("object is not an object of type org.projectocolibri.api.database.model.Artigos");
        }
        Artigos other = (Artigos)obj;
        if (this.jdoStateManager != other.jdoStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __jdoFieldNamesInit() {
        return new String[]{"autor", "botao", "campo1", "campo10", "campo2", "campo3", "campo4", "campo5", "campo6", "campo7", "campo8", "campo9", "categoria", "codigo", "codigoiva", "composicao", "custoproducao", "dataalteracao", "datacriacao", "descricao", "descricao2", "editor", "entradas", "estado", "existencias", "familia", "familia2", "grupo", "imagem", "intrastat", "isencaoiva", "obs", "precopcm", "precos", "precoupc", "precoupv", "retencao", "saidas", "stockencomendado", "stockexterior", "stockminimo", "stockprevisto", "stockreal", "stockreservado", "tipo", "tipocusto", "unidades"};
    }

    private static final Class[] __jdoFieldTypesInit() {
        return new Class[]{Artigos.___jdo$loadClass("org.projectocolibri.api.database.model.Utilizadores"), Artigos.___jdo$loadClass("java.lang.Integer"), Artigos.___jdo$loadClass("java.lang.String"), Artigos.___jdo$loadClass("java.lang.String"), Artigos.___jdo$loadClass("java.lang.String"), Artigos.___jdo$loadClass("java.lang.String"), Artigos.___jdo$loadClass("java.lang.String"), Artigos.___jdo$loadClass("java.lang.String"), Artigos.___jdo$loadClass("java.lang.String"), Artigos.___jdo$loadClass("java.lang.String"), Artigos.___jdo$loadClass("java.lang.String"), Artigos.___jdo$loadClass("java.lang.String"), Artigos.___jdo$loadClass("java.lang.Integer"), Artigos.___jdo$loadClass("java.lang.String"), Artigos.___jdo$loadClass("org.projectocolibri.api.database.model.Codigosiva"), Artigos.___jdo$loadClass("java.util.List"), Artigos.___jdo$loadClass("java.math.BigDecimal"), Artigos.___jdo$loadClass("java.util.Date"), Artigos.___jdo$loadClass("java.util.Date"), Artigos.___jdo$loadClass("java.lang.String"), Artigos.___jdo$loadClass("java.lang.String"), Artigos.___jdo$loadClass("org.projectocolibri.api.database.model.Utilizadores"), Artigos.___jdo$loadClass("java.math.BigDecimal"), Artigos.___jdo$loadClass("java.lang.Integer"), Artigos.___jdo$loadClass("java.util.List"), Artigos.___jdo$loadClass("org.projectocolibri.api.database.model.Familias"), Artigos.___jdo$loadClass("org.projectocolibri.api.database.model.Familias"), Artigos.___jdo$loadClass("org.projectocolibri.api.database.model.Grupos"), Artigos.___jdo$loadClass("[B"), Artigos.___jdo$loadClass("java.lang.String"), Artigos.___jdo$loadClass("org.projectocolibri.api.database.model.Isencoesiva"), Artigos.___jdo$loadClass("java.lang.String"), Artigos.___jdo$loadClass("java.math.BigDecimal"), Artigos.___jdo$loadClass("java.util.List"), Artigos.___jdo$loadClass("java.math.BigDecimal"), Artigos.___jdo$loadClass("java.math.BigDecimal"), Artigos.___jdo$loadClass("org.projectocolibri.api.database.model.Retencoes"), Artigos.___jdo$loadClass("java.math.BigDecimal"), Artigos.___jdo$loadClass("java.math.BigDecimal"), Artigos.___jdo$loadClass("java.math.BigDecimal"), Artigos.___jdo$loadClass("java.math.BigDecimal"), Artigos.___jdo$loadClass("java.math.BigDecimal"), Artigos.___jdo$loadClass("java.math.BigDecimal"), Artigos.___jdo$loadClass("java.math.BigDecimal"), Artigos.___jdo$loadClass("java.lang.Integer"), Artigos.___jdo$loadClass("java.lang.Integer"), Artigos.___jdo$loadClass("java.util.List")};
    }

    private static final byte[] __jdoFieldFlagsInit() {
        return new byte[]{21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 24, 5, 5, 21, 21, 21, 21, 21, 21, 21, 21, 5, 5, 5, 5, 26, 21, 5, 21, 21, 5, 21, 21, 5, 21, 21, 21, 21, 21, 21, 21, 21, 21, 5};
    }

    protected static int __jdoGetInheritedFieldCount() {
        return 0;
    }

    protected static int jdoGetManagedFieldCount() {
        return 47;
    }

    private static Class __jdoPersistenceCapableSuperclassInit() {
        return null;
    }

    public static Class ___jdo$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object jdoSuperClone() throws CloneNotSupportedException {
        Artigos o = (Artigos)super.clone();
        o.jdoFlags = 0;
        o.jdoStateManager = null;
        return o;
    }

    private static Utilizadores jdoGetautor(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 0)) {
            return (Utilizadores)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 0, (Object)objPC.autor);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(0)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"autor\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.autor;
    }

    private static void jdoSetautor(Artigos objPC, Utilizadores val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 0, (Object)objPC.autor, (Object)val);
        } else {
            objPC.autor = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(0);
            }
        }
    }

    private static Integer jdoGetbotao(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 1)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 1, (Object)objPC.botao);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(1)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"botao\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.botao;
    }

    private static void jdoSetbotao(Artigos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 1, (Object)objPC.botao, (Object)val);
        } else {
            objPC.botao = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(1);
            }
        }
    }

    private static String jdoGetcampo1(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 2)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 2, objPC.campo1);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(2)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"campo1\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.campo1;
    }

    private static void jdoSetcampo1(Artigos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 2, objPC.campo1, val);
        } else {
            objPC.campo1 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(2);
            }
        }
    }

    private static String jdoGetcampo10(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 3)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 3, objPC.campo10);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(3)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"campo10\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.campo10;
    }

    private static void jdoSetcampo10(Artigos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 3, objPC.campo10, val);
        } else {
            objPC.campo10 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(3);
            }
        }
    }

    private static String jdoGetcampo2(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 4)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 4, objPC.campo2);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(4)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"campo2\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.campo2;
    }

    private static void jdoSetcampo2(Artigos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 4, objPC.campo2, val);
        } else {
            objPC.campo2 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(4);
            }
        }
    }

    private static String jdoGetcampo3(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 5)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 5, objPC.campo3);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(5)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"campo3\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.campo3;
    }

    private static void jdoSetcampo3(Artigos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 5, objPC.campo3, val);
        } else {
            objPC.campo3 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(5);
            }
        }
    }

    private static String jdoGetcampo4(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 6)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 6, objPC.campo4);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(6)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"campo4\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.campo4;
    }

    private static void jdoSetcampo4(Artigos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 6, objPC.campo4, val);
        } else {
            objPC.campo4 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(6);
            }
        }
    }

    private static String jdoGetcampo5(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 7)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 7, objPC.campo5);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(7)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"campo5\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.campo5;
    }

    private static void jdoSetcampo5(Artigos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 7, objPC.campo5, val);
        } else {
            objPC.campo5 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(7);
            }
        }
    }

    private static String jdoGetcampo6(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 8)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 8, objPC.campo6);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(8)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"campo6\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.campo6;
    }

    private static void jdoSetcampo6(Artigos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 8, objPC.campo6, val);
        } else {
            objPC.campo6 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(8);
            }
        }
    }

    private static String jdoGetcampo7(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 9)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 9, objPC.campo7);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(9)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"campo7\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.campo7;
    }

    private static void jdoSetcampo7(Artigos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 9, objPC.campo7, val);
        } else {
            objPC.campo7 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(9);
            }
        }
    }

    private static String jdoGetcampo8(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 10)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 10, objPC.campo8);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(10)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"campo8\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.campo8;
    }

    private static void jdoSetcampo8(Artigos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 10, objPC.campo8, val);
        } else {
            objPC.campo8 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(10);
            }
        }
    }

    private static String jdoGetcampo9(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 11)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 11, objPC.campo9);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(11)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"campo9\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.campo9;
    }

    private static void jdoSetcampo9(Artigos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 11, objPC.campo9, val);
        } else {
            objPC.campo9 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(11);
            }
        }
    }

    private static Integer jdoGetcategoria(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 12)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 12, (Object)objPC.categoria);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(12)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"categoria\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.categoria;
    }

    private static void jdoSetcategoria(Artigos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 12, (Object)objPC.categoria, (Object)val);
        } else {
            objPC.categoria = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(12);
            }
        }
    }

    private static String jdoGetcodigo(Artigos objPC) {
        return objPC.codigo;
    }

    private static void jdoSetcodigo(Artigos objPC, String val) {
        if (objPC.jdoStateManager == null) {
            objPC.codigo = val;
        } else {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 13, objPC.codigo, val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(13);
        }
    }

    private static Codigosiva jdoGetcodigoiva(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 14)) {
            return (Codigosiva)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 14, (Object)objPC.codigoiva);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(14)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"codigoiva\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.codigoiva;
    }

    private static void jdoSetcodigoiva(Artigos objPC, Codigosiva val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 14, (Object)objPC.codigoiva, (Object)val);
        } else {
            objPC.codigoiva = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(14);
            }
        }
    }

    private static List jdoGetcomposicao(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 15)) {
            return (List)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 15, objPC.composicao);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(15)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"composicao\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.composicao;
    }

    private static void jdoSetcomposicao(Artigos objPC, List val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 15, objPC.composicao, (Object)val);
        } else {
            objPC.composicao = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(15);
            }
        }
    }

    private static BigDecimal jdoGetcustoproducao(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 16)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 16, (Object)objPC.custoproducao);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(16)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"custoproducao\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.custoproducao;
    }

    private static void jdoSetcustoproducao(Artigos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 16, (Object)objPC.custoproducao, (Object)val);
        } else {
            objPC.custoproducao = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(16);
            }
        }
    }

    private static Date jdoGetdataalteracao(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 17)) {
            return (Date)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 17, (Object)objPC.dataalteracao);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(17)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"dataalteracao\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.dataalteracao;
    }

    private static void jdoSetdataalteracao(Artigos objPC, Date val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 17, (Object)objPC.dataalteracao, (Object)val);
        } else {
            objPC.dataalteracao = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(17);
            }
        }
    }

    private static Date jdoGetdatacriacao(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 18)) {
            return (Date)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 18, (Object)objPC.datacriacao);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(18)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"datacriacao\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.datacriacao;
    }

    private static void jdoSetdatacriacao(Artigos objPC, Date val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 18, (Object)objPC.datacriacao, (Object)val);
        } else {
            objPC.datacriacao = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(18);
            }
        }
    }

    private static String jdoGetdescricao(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 19)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 19, objPC.descricao);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(19)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"descricao\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.descricao;
    }

    private static void jdoSetdescricao(Artigos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 19, objPC.descricao, val);
        } else {
            objPC.descricao = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(19);
            }
        }
    }

    private static String jdoGetdescricao2(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 20)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 20, objPC.descricao2);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(20)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"descricao2\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.descricao2;
    }

    private static void jdoSetdescricao2(Artigos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 20, objPC.descricao2, val);
        } else {
            objPC.descricao2 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(20);
            }
        }
    }

    private static Utilizadores jdoGeteditor(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 21)) {
            return (Utilizadores)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 21, (Object)objPC.editor);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(21)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"editor\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.editor;
    }

    private static void jdoSeteditor(Artigos objPC, Utilizadores val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 21, (Object)objPC.editor, (Object)val);
        } else {
            objPC.editor = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(21);
            }
        }
    }

    private static BigDecimal jdoGetentradas(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 22)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 22, (Object)objPC.entradas);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(22)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"entradas\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.entradas;
    }

    private static void jdoSetentradas(Artigos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 22, (Object)objPC.entradas, (Object)val);
        } else {
            objPC.entradas = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(22);
            }
        }
    }

    private static Integer jdoGetestado(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 23)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 23, (Object)objPC.estado);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(23)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"estado\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.estado;
    }

    private static void jdoSetestado(Artigos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 23, (Object)objPC.estado, (Object)val);
        } else {
            objPC.estado = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(23);
            }
        }
    }

    private static List jdoGetexistencias(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 24)) {
            return (List)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 24, objPC.existencias);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(24)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"existencias\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.existencias;
    }

    private static void jdoSetexistencias(Artigos objPC, List val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 24, objPC.existencias, (Object)val);
        } else {
            objPC.existencias = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(24);
            }
        }
    }

    private static Familias jdoGetfamilia(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 25)) {
            return (Familias)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 25, (Object)objPC.familia);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(25)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"familia\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.familia;
    }

    private static void jdoSetfamilia(Artigos objPC, Familias val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 25, (Object)objPC.familia, (Object)val);
        } else {
            objPC.familia = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(25);
            }
        }
    }

    private static Familias jdoGetfamilia2(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 26)) {
            return (Familias)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 26, (Object)objPC.familia2);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(26)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"familia2\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.familia2;
    }

    private static void jdoSetfamilia2(Artigos objPC, Familias val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 26, (Object)objPC.familia2, (Object)val);
        } else {
            objPC.familia2 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(26);
            }
        }
    }

    private static Grupos jdoGetgrupo(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 27)) {
            return (Grupos)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 27, (Object)objPC.grupo);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(27)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"grupo\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.grupo;
    }

    private static void jdoSetgrupo(Artigos objPC, Grupos val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 27, (Object)objPC.grupo, (Object)val);
        } else {
            objPC.grupo = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(27);
            }
        }
    }

    private static byte[] jdoGetimagem(Artigos objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 28)) {
            return (byte[])objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 28, (Object)objPC.imagem);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(28) && !((BitSet)objPC.jdoDetachedState[3]).get(28)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"imagem\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.imagem;
    }

    private static void jdoSetimagem(Artigos objPC, byte[] val) {
        if (objPC.jdoStateManager == null) {
            objPC.imagem = val;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 28, (Object)objPC.imagem, (Object)val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(28);
        }
    }

    private static String jdoGetintrastat(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 29)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 29, objPC.intrastat);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(29)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"intrastat\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.intrastat;
    }

    private static void jdoSetintrastat(Artigos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 29, objPC.intrastat, val);
        } else {
            objPC.intrastat = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(29);
            }
        }
    }

    private static Isencoesiva jdoGetisencaoiva(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 30)) {
            return (Isencoesiva)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 30, (Object)objPC.isencaoiva);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(30)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"isencaoiva\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.isencaoiva;
    }

    private static void jdoSetisencaoiva(Artigos objPC, Isencoesiva val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 30, (Object)objPC.isencaoiva, (Object)val);
        } else {
            objPC.isencaoiva = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(30);
            }
        }
    }

    private static String jdoGetobs(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 31)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 31, objPC.obs);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(31)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"obs\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.obs;
    }

    private static void jdoSetobs(Artigos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 31, objPC.obs, val);
        } else {
            objPC.obs = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(31);
            }
        }
    }

    private static BigDecimal jdoGetprecopcm(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 32)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 32, (Object)objPC.precopcm);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(32)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"precopcm\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.precopcm;
    }

    private static void jdoSetprecopcm(Artigos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 32, (Object)objPC.precopcm, (Object)val);
        } else {
            objPC.precopcm = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(32);
            }
        }
    }

    private static List jdoGetprecos(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 33)) {
            return (List)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 33, objPC.precos);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(33)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"precos\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.precos;
    }

    private static void jdoSetprecos(Artigos objPC, List val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 33, objPC.precos, (Object)val);
        } else {
            objPC.precos = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(33);
            }
        }
    }

    private static BigDecimal jdoGetprecoupc(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 34)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 34, (Object)objPC.precoupc);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(34)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"precoupc\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.precoupc;
    }

    private static void jdoSetprecoupc(Artigos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 34, (Object)objPC.precoupc, (Object)val);
        } else {
            objPC.precoupc = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(34);
            }
        }
    }

    private static BigDecimal jdoGetprecoupv(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 35)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 35, (Object)objPC.precoupv);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(35)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"precoupv\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.precoupv;
    }

    private static void jdoSetprecoupv(Artigos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 35, (Object)objPC.precoupv, (Object)val);
        } else {
            objPC.precoupv = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(35);
            }
        }
    }

    private static Retencoes jdoGetretencao(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 36)) {
            return (Retencoes)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 36, (Object)objPC.retencao);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(36)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"retencao\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.retencao;
    }

    private static void jdoSetretencao(Artigos objPC, Retencoes val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 36, (Object)objPC.retencao, (Object)val);
        } else {
            objPC.retencao = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(36);
            }
        }
    }

    private static BigDecimal jdoGetsaidas(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 37)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 37, (Object)objPC.saidas);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(37)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"saidas\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.saidas;
    }

    private static void jdoSetsaidas(Artigos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 37, (Object)objPC.saidas, (Object)val);
        } else {
            objPC.saidas = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(37);
            }
        }
    }

    private static BigDecimal jdoGetstockencomendado(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 38)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 38, (Object)objPC.stockencomendado);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(38)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"stockencomendado\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.stockencomendado;
    }

    private static void jdoSetstockencomendado(Artigos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 38, (Object)objPC.stockencomendado, (Object)val);
        } else {
            objPC.stockencomendado = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(38);
            }
        }
    }

    private static BigDecimal jdoGetstockexterior(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 39)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 39, (Object)objPC.stockexterior);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(39)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"stockexterior\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.stockexterior;
    }

    private static void jdoSetstockexterior(Artigos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 39, (Object)objPC.stockexterior, (Object)val);
        } else {
            objPC.stockexterior = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(39);
            }
        }
    }

    private static BigDecimal jdoGetstockminimo(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 40)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 40, (Object)objPC.stockminimo);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(40)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"stockminimo\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.stockminimo;
    }

    private static void jdoSetstockminimo(Artigos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 40, (Object)objPC.stockminimo, (Object)val);
        } else {
            objPC.stockminimo = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(40);
            }
        }
    }

    private static BigDecimal jdoGetstockprevisto(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 41)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 41, (Object)objPC.stockprevisto);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(41)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"stockprevisto\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.stockprevisto;
    }

    private static void jdoSetstockprevisto(Artigos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 41, (Object)objPC.stockprevisto, (Object)val);
        } else {
            objPC.stockprevisto = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(41);
            }
        }
    }

    private static BigDecimal jdoGetstockreal(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 42)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 42, (Object)objPC.stockreal);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(42)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"stockreal\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.stockreal;
    }

    private static void jdoSetstockreal(Artigos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 42, (Object)objPC.stockreal, (Object)val);
        } else {
            objPC.stockreal = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(42);
            }
        }
    }

    private static BigDecimal jdoGetstockreservado(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 43)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 43, (Object)objPC.stockreservado);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(43)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"stockreservado\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.stockreservado;
    }

    private static void jdoSetstockreservado(Artigos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 43, (Object)objPC.stockreservado, (Object)val);
        } else {
            objPC.stockreservado = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(43);
            }
        }
    }

    private static Integer jdoGettipo(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 44)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 44, (Object)objPC.tipo);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(44)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"tipo\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.tipo;
    }

    private static void jdoSettipo(Artigos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 44, (Object)objPC.tipo, (Object)val);
        } else {
            objPC.tipo = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(44);
            }
        }
    }

    private static Integer jdoGettipocusto(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 45)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 45, (Object)objPC.tipocusto);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(45)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"tipocusto\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.tipocusto;
    }

    private static void jdoSettipocusto(Artigos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 45, (Object)objPC.tipocusto, (Object)val);
        } else {
            objPC.tipocusto = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(45);
            }
        }
    }

    private static List jdoGetunidades(Artigos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 46)) {
            return (List)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 46, objPC.unidades);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(46)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"unidades\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.unidades;
    }

    private static void jdoSetunidades(Artigos objPC, List val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 46, objPC.unidades, (Object)val);
        } else {
            objPC.unidades = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(46);
            }
        }
    }
}

