/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.mapper.tree;

import java.util.ArrayList;
import org.dma.java.util.StringList;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.mapper.tree.TreeBranchModel;
import org.projectocolibri.api.database.model.Entidadestipos;
import org.projectocolibri.api.language.LABELS;

public class TreeGroupModel
extends ArrayList<TreeBranchModel> {
    private static final long serialVersionUID = 1L;
    public final GROUPS group;
    public final Entidadestipos tipoentidade;

    public TreeGroupModel(GROUPS group) {
        this(group, null);
    }

    public TreeGroupModel(GROUPS group, Entidadestipos tipoentidade) {
        this.group = group;
        this.tipoentidade = tipoentidade;
    }

    public String label() {
        switch (this.group) {
            case ARTIGOS: {
                return LABELS.menutree_artigos.toString();
            }
            case ENTIDADES: {
                return this.tipoentidade.getDescricao();
            }
        }
        return null;
    }

    public Colibri.ICONS icon() {
        return new TreeBranchModel(this.group, TreeBranchModel.BRANCHES.FICHEIRO, this.tipoentidade, null).icon();
    }

    @Override
    public String toString() {
        StringList list = new StringList(new String[]{this.group.name()});
        if (this.tipoentidade != null) {
            list.add((Object)this.tipoentidade.getCodigo());
        }
        return list.concat(":");
    }

    public static enum GROUPS {
        ARTIGOS,
        ENTIDADES;

    }
}

