/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.mapper;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.IFieldProperties;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.mapper.TableFieldKey;
import org.projectocolibri.api.database.mapper.TableFieldMap;
import org.projectocolibri.api.database.mapper.TableLayout;

public class TableMap
extends TreeMap<TableFieldKey, TableFieldMap>
implements IFieldProperties {
    private static final long serialVersionUID = 1L;
    public static final int MAX_KEY_SIZE = 255;
    public static final Collection<List<FIELDS.TYPES>> TABLE_SYNTAX = Arrays.asList(Arrays.asList(FIELDS.TYPES.TABLE), Arrays.asList(FIELDS.TYPES.TABLE, FIELDS.TYPES.TABLE), Arrays.asList(FIELDS.TYPES.SET), Arrays.asList(FIELDS.TYPES.SET, FIELDS.TYPES.TABLE));
    private final TABLES table;
    private FIELDS index;
    private FIELDS key;

    public void print() {
        System.out.println();
        System.out.print(String.valueOf(this.table.name()) + "=" + this.size());
        if (this.key != null) {
            System.out.print(", KEY=" + this.key);
        }
        if (this.index != null) {
            System.out.print(", INDEX=" + this.index);
        }
        System.out.println();
        for (TableFieldKey fieldKey : this.keySet()) {
            TableFieldMap fieldMap = this.get(fieldKey);
            System.out.println("\t" + fieldKey + ": " + fieldMap);
        }
    }

    public TableFieldMap get(TableFieldKey key) {
        TableFieldMap value = (TableFieldMap)super.get(key);
        if (value == null) {
            throw new UnsupportedOperationException(String.valueOf(this.table.name()) + ":" + key.toString());
        }
        return value;
    }

    public TableFieldMap get(String key) {
        return this.get(TableFieldKey.valueOf(key));
    }

    public FIELDS getIndex() {
        return this.index;
    }

    public FIELDS getKey() {
        return this.key;
    }

    public TableMap(TABLES table) {
        this.table = table;
    }

    int compile() {
        this.clear();
        FIELDS[] fIELDSArray = this.table.fields();
        int n = fIELDSArray.length;
        int n2 = 0;
        while (n2 < n) {
            FIELDS rootField = fIELDSArray[n2];
            this.compile(this.table, rootField, new TableFieldKey(rootField), new TableFieldMap(rootField), new ArrayList<FIELDS.TYPES>());
            ++n2;
        }
        if (!this.isEmpty() && this.key.format.getSize().size > 255) {
            throw new InvalidParameterException("INVALID KEY SIZE: " + this.key.name());
        }
        return this.size();
    }

    private void compile(TABLES table, FIELDS field, TableFieldKey fieldKey, TableFieldMap fieldMap, Collection<FIELDS.TYPES> tables) {
        if (field.type == FIELDS.TYPES.SET || field.type == FIELDS.TYPES.TABLE) {
            tables.add(field.type);
        }
        if (tables.isEmpty() || TABLE_SYNTAX.contains(tables)) {
            this.put(fieldKey, fieldMap);
            fieldMap.add(field);
            if (tables.isEmpty() && field.format.isKey()) {
                this.key = field;
            }
            if (tables.isEmpty() && field.format.isIndex()) {
                this.index = field;
            }
            if (field.childTable != null) {
                FIELDS[] fIELDSArray = field.childTable.fields();
                int n = fIELDSArray.length;
                int n2 = 0;
                while (n2 < n) {
                    FIELDS childField = fIELDSArray[n2];
                    if (!field.format.isLocal() || childField.format.isKey()) {
                        this.compile(field.childTable, childField, TableFieldKey.valueOf(String.valueOf(fieldKey.name()) + "." + childField.name), new TableFieldMap(childField, fieldMap), new ArrayList<FIELDS.TYPES>(tables));
                    }
                    ++n2;
                }
            }
        }
    }

    public Collection<TableFieldKey> cleanCopy(Collection<TableFieldKey> layout) {
        ArrayList<TableFieldKey> col = new ArrayList<TableFieldKey>(layout);
        col.retainAll(this.keySet());
        return col;
    }

    public TableLayout createLayout(boolean createSetIndexes) {
        ArrayList<TableFieldKey> fields = new ArrayList<TableFieldKey>();
        ArrayList<TableFieldKey> tables = new ArrayList<TableFieldKey>();
        ArrayList<TableFieldKey> sets = new ArrayList<TableFieldKey>();
        block4: for (TableFieldKey fieldKey : this.keySet()) {
            FIELDS field = this.get((TableFieldKey)fieldKey).field;
            FIELDS rootField = this.get((TableFieldKey)fieldKey.root()).field;
            if (field.format.isInternal()) continue;
            switch (rootField.type) {
                default: {
                    fields.add(fieldKey);
                    break;
                }
                case TABLE: {
                    tables.add(fieldKey);
                    break;
                }
                case SET: {
                    sets.add(fieldKey);
                    if (!createSetIndexes || fieldKey.size() <= 1) continue block4;
                    int i = 1;
                    while (i < rootField.format.getSize().size) {
                        sets.add(fieldKey.cloneCopy(i + 1));
                        ++i;
                    }
                    continue block4;
                }
            }
        }
        fields.addAll(tables);
        fields.addAll(sets);
        return new TableLayout(this.table, fields);
    }
}

