/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.mapper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.dma.java.util.StringList;
import org.dma.java.util.StringUtils;
import org.projectocolibri.api.database.filter.FilterMap;
import org.projectocolibri.api.database.mapper.TableFieldKey;

public class TableLayoutArray
extends ArrayList<TableFieldKey> {
    private static final long serialVersionUID = 1L;

    public static TableLayoutArray valueOf(String layout) {
        TableLayoutArray array = new TableLayoutArray();
        for (String fieldName : StringUtils.split((String)layout, (String)FilterMap.LINE_SEPARATOR).trim()) {
            if (fieldName.isEmpty()) continue;
            array.add(TableFieldKey.valueOf(fieldName));
        }
        return array;
    }

    public TableLayoutArray remove(TableFieldKey fieldKey) {
        super.remove(fieldKey);
        return this;
    }

    public TableLayoutArray move(int index, TableFieldKey fieldKey) {
        if (super.remove(fieldKey)) {
            this.add(index, fieldKey);
        }
        return this;
    }

    public TableLayoutArray() {
        this(new TableFieldKey[0]);
    }

    public TableLayoutArray(TableFieldKey[] array) {
        this((Collection<TableFieldKey>)Arrays.asList(array));
    }

    public TableLayoutArray(Collection<TableFieldKey> layout) {
        super(layout);
    }

    public StringList toStringList() {
        return StringList.valueOf((Collection)this);
    }

    public String toText() {
        return this.toStringList().concat(String.valueOf(FilterMap.LINE_SEPARATOR) + "\n");
    }

    @Override
    public String toString() {
        return this.toStringList().concat(FilterMap.LINE_SEPARATOR);
    }
}

