/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.mapper;

import com.csvreader.CsvWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.dma.java.io.CustomFile;
import org.dma.java.io.FileParameters;
import org.dma.java.io.Folder;
import org.dma.java.util.ArrayUtils;
import org.projectocolibri.api.database.IDatabaseModel;
import org.projectocolibri.api.database.ILabelFormatter;
import org.projectocolibri.api.database.ILayoutModel;
import org.projectocolibri.api.database.filter.FilterMap;
import org.projectocolibri.api.database.filter.FilterMapRule;
import org.projectocolibri.api.database.filter.FilterOperandMap;
import org.projectocolibri.api.database.filter.OPERATORS;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.mapper.TableFieldKey;
import org.projectocolibri.api.database.mapper.TableLayoutArray;

public class TableLayout<T extends IDatabaseModel>
extends TableLayoutArray {
    private static final long serialVersionUID = 1L;
    public final TABLES table;

    public TableLayout(ILayoutModel model) {
        this(model.table(), model.getLayoutArray());
    }

    public TableLayout(TABLES table, Collection<TableFieldKey> layout) {
        this(table, layout, true);
    }

    private TableLayout(TABLES table, Collection<TableFieldKey> layout, boolean clean) {
        super(clean ? table.map.cleanCopy(layout) : layout);
        this.table = table;
    }

    public TableLayout<T> exclude(Collection<TableFieldKey> col) {
        ArrayList<TableFieldKey> layout = new ArrayList<TableFieldKey>();
        for (TableFieldKey fieldKey : this) {
            if (col.contains(fieldKey)) continue;
            layout.add(fieldKey);
        }
        return new TableLayout<T>(this.table, layout, false);
    }

    public TableLayout<T> exclude(FIELDS.TYPES ... type) {
        ArrayList<TableFieldKey> layout = new ArrayList<TableFieldKey>();
        for (TableFieldKey fieldKey : this) {
            FIELDS field = this.table.map.get((TableFieldKey)fieldKey).field;
            if (ArrayUtils.contains((Object[])type, (Object)((Object)field.type))) continue;
            layout.add(fieldKey);
        }
        return new TableLayout<T>(this.table, layout, false);
    }

    public TableLayout<T> exclude(int properties) {
        ArrayList<TableFieldKey> layout = new ArrayList<TableFieldKey>();
        for (TableFieldKey fieldKey : this) {
            FIELDS field = this.table.map.get((TableFieldKey)fieldKey).field;
            if (field.format.is(properties)) continue;
            layout.add(fieldKey);
        }
        return new TableLayout<T>(this.table, layout, false);
    }

    public TableFieldKey findFirst(FIELDS.TYPES type) {
        for (TableFieldKey fieldKey : this) {
            if (this.table.map.get((TableFieldKey)fieldKey).field.type != type) continue;
            return fieldKey;
        }
        return null;
    }

    public FilterMap createFilterMap(int columnIndex, OPERATORS.MATH operator, String value) {
        FIELDS tableIndex;
        FilterMap filterMap = new FilterMap(this.table);
        TableFieldKey fieldKey = (TableFieldKey)this.get(columnIndex);
        FilterMapRule rule = new FilterMapRule(fieldKey).unaccent();
        rule.add(new FilterOperandMap(operator, value));
        filterMap.addRule(rule);
        FIELDS rootField = this.table.map.get((TableFieldKey)fieldKey.root()).field;
        if (rootField.type == FIELDS.TYPES.SET && (tableIndex = rootField.childTable.map.getIndex()) != null && fieldKey.index() > 1) {
            filterMap.addRule(new FilterMapRule(rootField, tableIndex).equal(fieldKey.index()));
        }
        return filterMap;
    }

    public void export(Collection<T> col, File file) throws Exception {
        CsvWriter writer = new CsvWriter(file.toString(), ';', CustomFile.UTF8_CHARSET);
        try {
            for (TableFieldKey fieldKey : this) {
                writer.write(fieldKey.toString());
            }
            writer.endRecord();
            for (IDatabaseModel element : col) {
                int i = 0;
                while (i < this.size()) {
                    String content = this.getColumnText(element, i);
                    writer.write(content);
                    ++i;
                }
                writer.endRecord();
            }
        }
        finally {
            writer.close();
        }
    }

    public FileParameters getFileParameters(Folder folder) {
        return new FileParameters(this.table.name(), "csv", (File)folder);
    }

    public String getColumnText(T model, TableFieldKey fieldKey) {
        return this.table.map.get((TableFieldKey)fieldKey).field.format(model.getValue(fieldKey));
    }

    public String getColumnText(Object element, int columnIndex) {
        return this.isEmpty() ? "" : this.getColumnText((IDatabaseModel)element, (TableFieldKey)this.get(columnIndex));
    }

    public String getColumnLabel(int columnIndex, ILabelFormatter formatter) {
        TableFieldKey fieldKey = (TableFieldKey)this.get(columnIndex);
        String label = this.table.map.get(fieldKey).label(formatter);
        return fieldKey.index() > 1 ? String.valueOf(label) + " #" + fieldKey.index() : label;
    }

    public String[] getColumnLabel(ILabelFormatter formatter) {
        String[] array = new String[this.size()];
        int i = 0;
        while (i < this.size()) {
            array[i] = this.getColumnLabel(i, formatter);
            ++i;
        }
        return array;
    }
}

