/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.manager.tasks;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import org.dma.java.util.MessageList;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.model.Utilizadores;
import org.projectocolibri.api.database.model.Utilizadoresicones;

public class UtilizadoresiconesTask {
    private final DatabaseManager manager;

    public UtilizadoresiconesTask(DatabaseManager manager) {
        this.manager = manager;
    }

    public MessageList exportTo(File file) {
        return this.exportTo(this.manager.getUtilizador(), file);
    }

    public MessageList exportTo(Utilizadores utilizador, File file) {
        MessageList error = new MessageList();
        if (file != null) {
            try {
                ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file));
                try {
                    Collection<Utilizadoresicones> col = this.manager.getUtilizadoresiconesCollection(utilizador.getUser(), true);
                    out.writeObject(col);
                }
                finally {
                    out.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                error.add((Throwable)e);
            }
        }
        return error;
    }

    public MessageList importFrom(File file) {
        return this.importFrom(this.manager.getUtilizador(), file);
    }

    public MessageList importFrom(Utilizadores utilizador, File file) {
        MessageList error = new MessageList();
        if (file != null) {
            try {
                ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));
                try {
                    Collection col = this.manager.attach((Collection)in.readObject());
                    this.manager.deleteUtilizadoresicones$User(utilizador.getUser());
                    for (Utilizadoresicones icone : col) {
                        error.add(this.manager.storeUtilizadoresicones(icone.cloneCopy(utilizador)));
                    }
                }
                finally {
                    in.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                error.add((Throwable)e);
            }
        }
        return error;
    }
}

