/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.manager.tasks;

import java.io.File;
import org.dma.java.util.MessageList;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.model.Templates;

public class TemplatesTask {
    private final DatabaseManager manager;

    public TemplatesTask(DatabaseManager manager) {
        this.manager = manager;
    }

    public MessageList importDesign(File designFile, String codigo) {
        MessageList error = new MessageList();
        Templates template = this.manager.loadTemplates(codigo);
        if (template != null) {
            try {
                template.importDesign(designFile, true);
                error.add(this.manager.storeTemplates(template));
            }
            catch (Exception e) {
                error.add((Throwable)e);
            }
        }
        return error;
    }

    public MessageList importFrom(File folder, String codigo) {
        MessageList error = new MessageList();
        Templates template = this.manager.loadTemplates(codigo);
        if (template != null) {
            try {
                template.importDesign(folder, Colibri.FILES.TEMPLATES.parameters.wildcards, true);
                error.add(this.manager.storeTemplates(template));
            }
            catch (Exception e) {
                error.add((Throwable)e);
            }
        }
        return error;
    }

    public MessageList exportTo(File folder, String codigo) {
        MessageList error = new MessageList();
        Templates template = this.manager.loadTemplates(codigo);
        if (template != null) {
            try {
                template.exportDesign(folder);
            }
            catch (Exception e) {
                error.add((Throwable)e);
            }
        }
        return error;
    }
}

