/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.manager.tasks;

import com.csvreader.CsvReader;
import java.io.File;
import org.dma.java.util.MessageList;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.model.Codigospostais;

public abstract class CodigospostaisTask {
    private final DatabaseManager manager;

    public abstract boolean cancel();

    public CodigospostaisTask(DatabaseManager manager) {
        this.manager = manager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MessageList importFrom(File file) {
        MessageList error = new MessageList();
        try {
            CsvReader reader = new CsvReader(file.getAbsolutePath(), ';');
            try {
                while (!this.cancel()) {
                    if (!reader.readRecord()) {
                        return error;
                    }
                    String codigo = String.valueOf(reader.get(14)) + "-" + reader.get(15);
                    Codigospostais codigopostal = new Codigospostais(this.manager, codigo, reader.get(16));
                    codigopostal.setLocalidade(reader.get(3));
                    if (codigopostal.isValid(this.manager.getParametros().getPais())) {
                        codigopostal.create();
                        continue;
                    }
                    System.out.println("INVALID: " + codigopostal);
                }
                return error;
            }
            finally {
                reader.close();
            }
        }
        catch (Exception e) {
            error.add((Throwable)e);
        }
        return error;
    }
}

