/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.manager.tasks;

import java.util.Calendar;
import javax.jdo.PersistenceManager;
import org.dma.java.util.MessageList;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.SerializedTransaction;
import org.projectocolibri.api.database.filter.FilterMapRule;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Artigos;
import org.projectocolibri.api.database.model.Codigosiva;
import org.projectocolibri.api.database.query.TransactionalQuery;
import org.projectocolibri.xml.beans.stocks.StocksMap;

public class ArtigosTask {
    private final DatabaseManager manager;

    public ArtigosTask(DatabaseManager manager) {
        this.manager = manager;
    }

    public MessageList convert(Codigosiva codigoiva, final Codigosiva codigoiva2) {
        MessageList error = new MessageList();
        TransactionalQuery<Artigos> query = new TransactionalQuery<Artigos>(TABLES.artigos, this.manager){

            @Override
            public void process(Artigos artigo) throws Exception {
                artigo.setCascade(true);
                artigo.setCodigoiva(codigoiva2);
                if (artigo.isCodigoivaValid()) {
                    this.store(artigo);
                }
            }
        };
        query.addRule(new FilterMapRule(FIELDS.artigos_codigoiva, FIELDS.codigosiva_codigo).equal(codigoiva.getCodigo()));
        try {
            query.execute();
        }
        catch (Exception e) {
            error.add((Throwable)e);
        }
        return error;
    }

    public MessageList setPrecopcm(Calendar endDate) {
        MessageList error = new MessageList();
        for (Artigos element : new StocksMap(this.manager, endDate).values()) {
            PersistenceManager pm = this.manager.getPersistenceManager();
            SerializedTransaction tx = new SerializedTransaction(pm);
            try {
                try {
                    tx.begin();
                    Artigos artigo = (Artigos)TABLES.artigos.getObject(pm, element.getCodigo());
                    artigo.setPrecopcm(element.getPrecopcm());
                    pm.makePersistent((Object)artigo);
                    tx.commit();
                }
                catch (Exception e) {
                    error.add((Throwable)e);
                    if (tx.isActive()) {
                        tx.rollback();
                    }
                    pm.close();
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (tx.isActive()) {
                    tx.rollback();
                }
                pm.close();
                throw throwable;
            }
            if (tx.isActive()) {
                tx.rollback();
            }
            pm.close();
        }
        return error;
    }
}

