/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.manager;

import java.util.Collection;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.JDOOptimisticVerificationException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import org.dma.java.util.MessageList;
import org.projectocolibri.api.database.DatabaseException;
import org.projectocolibri.api.database.IDatabaseModel;
import org.projectocolibri.api.database.MethodCallback;
import org.projectocolibri.api.database.SerializedTransaction;
import org.projectocolibri.api.database.manager.AbstractManager;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Empresa;

public class EmpresaManager
extends AbstractManager<Empresa> {
    public EmpresaManager(PersistenceManagerFactory factory) {
        super(TABLES.empresa, factory);
    }

    @Override
    public synchronized MessageList store(Empresa empresa, MethodCallback ... preCommit) {
        MessageList error = new MessageList();
        PersistenceManager pm = this.factory.getPersistenceManager();
        SerializedTransaction tx = new SerializedTransaction(pm);
        try {
            tx.begin();
            Empresa stored = (Empresa)this.table.getObjectOrNull(pm, empresa.getId());
            if (error.add(empresa.validate(IDatabaseModel.ACTION.STORE, stored))) {
                MessageList messageList = error;
                return messageList;
            }
            try {
                pm.makePersistent((Object)empresa);
                tx.commit();
            }
            catch (DatabaseException e) {
                error.add((Throwable)e);
            }
            catch (JDOOptimisticVerificationException e) {
                error.add((Throwable)new DatabaseException(e));
            }
            catch (Exception e) {
                error.add((Throwable)new DatabaseException(e));
            }
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            pm.close();
        }
        return error;
    }

    @Override
    public synchronized MessageList delete(Object id) {
        MessageList error = new MessageList();
        PersistenceManager pm = this.factory.getPersistenceManager();
        SerializedTransaction tx = new SerializedTransaction(pm);
        try {
            tx.begin();
            Empresa empresa = (Empresa)this.table.getObject(pm, id);
            if (error.add(empresa.validate(IDatabaseModel.ACTION.DELETE, empresa))) {
                MessageList messageList = error;
                return messageList;
            }
            try {
                pm.deletePersistent((Object)empresa);
                tx.commit();
            }
            catch (JDOOptimisticVerificationException e) {
                error.add((Throwable)new DatabaseException(e));
            }
            catch (JDOObjectNotFoundException e) {
                error.add((Throwable)new DatabaseException(e));
            }
            catch (Exception e) {
                error.add((Throwable)new DatabaseException(e));
            }
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            pm.close();
        }
        return error;
    }

    @Override
    public synchronized Collection<Empresa> getCollection() {
        return null;
    }

    @Override
    public synchronized Collection<Empresa> getCollection(Object id) {
        return null;
    }
}

