/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.manager;

import java.util.ArrayList;
import java.util.Collection;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.JDOOptimisticVerificationException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.xml.ws.WebServiceException;
import org.dma.java.util.Debug;
import org.dma.java.util.MessageList;
import org.dma.java.util.StringUtils;
import org.projectocolibri.api.database.DatabaseException;
import org.projectocolibri.api.database.IDatabaseModel;
import org.projectocolibri.api.database.MethodCallback;
import org.projectocolibri.api.database.SerializedTransaction;
import org.projectocolibri.api.database.manager.AbstractManager;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Documentosseries;
import org.projectocolibri.api.database.model.Documentostipos;
import org.projectocolibri.api.database.query.QueryOrdering;
import org.projectocolibri.api.language.LABELS;

public class DocumentostiposManager
extends AbstractManager<Documentostipos> {
    public DocumentostiposManager(PersistenceManagerFactory factory) {
        super(TABLES.documentostipos, factory);
    }

    @Override
    public synchronized MessageList store(Documentostipos tipodocumento, MethodCallback ... preCommit) {
        MessageList error = new MessageList();
        PersistenceManager pm = this.factory.getPersistenceManager();
        SerializedTransaction tx = new SerializedTransaction(pm);
        boolean cascade = tipodocumento.setCascade(false);
        try {
            tx.begin();
            boolean exists = this.exists(tipodocumento.getCodigo());
            if (!tipodocumento.isEdited()) {
                if (exists) {
                    throw new DatabaseException(LABELS.erro_database_registoexistente.toString());
                }
            } else if (!exists) {
                throw new DatabaseException(LABELS.erro_database_registoinexistente.toString());
            }
            Documentostipos stored = (Documentostipos)this.table.getObjectOrNull(pm, tipodocumento.getCodigo());
            if (error.add(tipodocumento.validate(IDatabaseModel.ACTION.STORE))) {
                MessageList messageList = error;
                return messageList;
            }
            try {
                ArrayList<Documentosseries> anular = new ArrayList<Documentosseries>();
                ArrayList<Documentosseries> finalizar = new ArrayList<Documentosseries>();
                if (stored != null) {
                    ArrayList<Documentosseries> delete = new ArrayList<Documentosseries>();
                    for (Documentosseries element : stored.getSeries()) {
                        Documentosseries serie = tipodocumento.getSeries(element.getKey());
                        if (serie == null) {
                            if (element.hasService() && element.service().consultar().getInfoSerie().size() > 0) {
                                throw new WebServiceException("N\u00e3o \u00e9 poss\u00edvel remover s\u00e9ries registadas");
                            }
                            if (element.hasCodigovalidacao()) {
                                throw new WebServiceException("N\u00e3o \u00e9 poss\u00edvel remover s\u00e9ries com c\u00f3digo de valida\u00e7\u00e3o");
                            }
                            delete.add(element);
                            continue;
                        }
                        if (serie.isEstado(element.getEstado())) continue;
                        switch (serie.getEstado()) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                break;
                            }
                            case 2: {
                                anular.add(serie);
                                break;
                            }
                            case 3: {
                                finalizar.add(serie);
                            }
                        }
                    }
                    Debug.out((String)"DELETE", delete);
                    tipodocumento.removeSeries(delete);
                    pm.deletePersistentAll(delete);
                }
                MethodCallback[] methodCallbackArray = preCommit;
                int n = preCommit.length;
                int n2 = 0;
                while (n2 < n) {
                    MethodCallback callback = methodCallbackArray[n2];
                    if (!callback.run(pm, tipodocumento.cloneCopy())) {
                        throw new InterruptedException();
                    }
                    ++n2;
                }
                pm.makePersistent((Object)tipodocumento);
                pm.checkConsistency();
                if (anular.size() + finalizar.size() > 1) {
                    throw new WebServiceException("N\u00e3o \u00e9 poss\u00edvel manipular mais de uma s\u00e9rie em simult\u00e2neo");
                }
                for (Documentosseries serie : anular) {
                    serie.service().anular();
                }
                for (Documentosseries serie : finalizar) {
                    serie.service().finalizar();
                }
                tx.commit();
            }
            catch (DatabaseException e) {
                error.add((Throwable)e);
            }
            catch (InterruptedException e) {
                error.add((Throwable)new DatabaseException(e));
            }
            catch (JDOOptimisticVerificationException e) {
                error.add((Throwable)new DatabaseException(e));
            }
            catch (WebServiceException e) {
                error.add((Throwable)new DatabaseException(e));
            }
            catch (Exception e) {
                error.add((Throwable)new DatabaseException(e));
            }
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            } else if (!tipodocumento.isEdited()) {
                pm.refresh((Object)tipodocumento);
            }
            tipodocumento.setCascade(cascade);
            pm.close();
        }
        return error;
    }

    @Override
    public synchronized MessageList delete(Object key) {
        MessageList error = new MessageList();
        PersistenceManager pm = this.factory.getPersistenceManager();
        SerializedTransaction tx = new SerializedTransaction(pm);
        try {
            tx.begin();
            Documentostipos tipodocumento = (Documentostipos)this.table.getObject(pm, key);
            if (error.add(tipodocumento.validate(IDatabaseModel.ACTION.DELETE))) {
                MessageList messageList = error;
                return messageList;
            }
            try {
                pm.deletePersistentAll(tipodocumento.getSeries());
                pm.deletePersistent((Object)tipodocumento);
                tx.commit();
            }
            catch (JDOOptimisticVerificationException e) {
                error.add((Throwable)new DatabaseException(e));
            }
            catch (JDOObjectNotFoundException e) {
                error.add((Throwable)new DatabaseException(e));
            }
            catch (WebServiceException e) {
                error.add((Throwable)new DatabaseException(e));
            }
            catch (Exception e) {
                error.add((Throwable)new DatabaseException(e));
            }
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            pm.close();
        }
        return error;
    }

    @Override
    public synchronized Collection<Documentostipos> getCollection() {
        PersistenceManager pm = this.factory.getPersistenceManager();
        Query query = this.table.newQuery(pm);
        try {
            query.setOrdering(String.valueOf(FIELDS.documentostipos_codigo.name) + " " + (Object)((Object)QueryOrdering.DIRECTION.ASCENDING));
            Collection collection = pm.detachCopyAll((Collection)query.execute());
            return collection;
        }
        finally {
            query.closeAll();
            pm.close();
        }
    }

    public synchronized Collection<Documentostipos> getCollection(Integer tabela) {
        PersistenceManager pm = this.factory.getPersistenceManager();
        Query query = this.table.newQuery(pm);
        try {
            query.setFilter(String.valueOf(FIELDS.documentostipos_tabela.name) + "==" + tabela + " && " + FIELDS.documentostipos_estado.name + "==" + 1);
            query.setOrdering(String.valueOf(FIELDS.documentostipos_codigo.name) + " " + (Object)((Object)QueryOrdering.DIRECTION.ASCENDING));
            Collection collection = pm.detachCopyAll((Collection)query.execute());
            return collection;
        }
        finally {
            query.closeAll();
            pm.close();
        }
    }

    @Override
    public synchronized Collection<Documentostipos> getCollection(Object tipoentidade) {
        PersistenceManager pm = this.factory.getPersistenceManager();
        Query query = this.table.newQuery(pm);
        try {
            query.setFilter(String.valueOf(FIELDS.documentostipos_tipoentidade.name) + "." + FIELDS.entidadestipos_codigo.name + "==" + StringUtils.quote((String)tipoentidade.toString(), (char[])new char[0]) + " && " + FIELDS.documentostipos_estado.name + "==" + 1);
            query.setOrdering(String.valueOf(FIELDS.documentostipos_codigo.name) + " " + (Object)((Object)QueryOrdering.DIRECTION.ASCENDING));
            Collection collection = pm.detachCopyAll((Collection)query.execute());
            return collection;
        }
        finally {
            query.closeAll();
            pm.close();
        }
    }
}

