/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.manager;

import java.util.Collection;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import org.dma.java.util.StringUtils;
import org.projectocolibri.api.database.ILabelFormatter;
import org.projectocolibri.api.database.manager.AbstractManager;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Campos;
import org.projectocolibri.api.database.query.QueryOrdering;

public class CamposManager
extends AbstractManager<Campos>
implements ILabelFormatter {
    public CamposManager(PersistenceManagerFactory factory) {
        super(TABLES.campos, factory);
    }

    public synchronized Campos load(int index) {
        PersistenceManager pm = this.factory.getPersistenceManager();
        Query query = this.table.newQuery(pm);
        try {
            query.setOrdering(String.valueOf(FIELDS.campos_codigo.name) + " " + (Object)((Object)QueryOrdering.DIRECTION.ASCENDING));
            query.setRange((long)index, (long)(index + 1));
            query.setUnique(true);
            Campos campos = (Campos)pm.detachCopy(query.execute());
            return campos;
        }
        finally {
            query.closeAll();
            pm.close();
        }
    }

    @Override
    public synchronized Collection<Campos> getCollection() {
        PersistenceManager pm = this.factory.getPersistenceManager();
        Query query = this.table.newQuery(pm);
        try {
            query.setOrdering(String.valueOf(FIELDS.campos_codigo.name) + " " + (Object)((Object)QueryOrdering.DIRECTION.ASCENDING));
            Collection collection = pm.detachCopyAll((Collection)query.execute());
            return collection;
        }
        finally {
            query.closeAll();
            pm.close();
        }
    }

    @Override
    public synchronized Collection<Campos> getCollection(Object tabela) {
        PersistenceManager pm = this.factory.getPersistenceManager();
        Query query = this.table.newQuery(pm);
        try {
            query.setFilter(String.valueOf(FIELDS.campos_tabela.name) + "==" + tabela);
            query.setOrdering(String.valueOf(FIELDS.campos_codigo.name) + " " + (Object)((Object)QueryOrdering.DIRECTION.ASCENDING));
            Collection collection = pm.detachCopyAll((Collection)query.execute());
            return collection;
        }
        finally {
            query.closeAll();
            pm.close();
        }
    }

    @Override
    public synchronized String format(String label) {
        String codigo = StringUtils.unquote((String)label, (char[])new char[]{'<', '>'});
        if (label.equals(codigo)) {
            return label;
        }
        Campos campo = (Campos)this.load(codigo);
        return campo == null ? codigo : campo.getDescricaoToText();
    }
}

