/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.manager;

import java.util.Collection;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.JDOOptimisticVerificationException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import org.dma.java.util.Debug;
import org.dma.java.util.MessageList;
import org.dma.java.util.StringUtils;
import org.projectocolibri.api.database.DatabaseException;
import org.projectocolibri.api.database.IDatabaseModel;
import org.projectocolibri.api.database.MethodCallback;
import org.projectocolibri.api.database.SerializedTransaction;
import org.projectocolibri.api.database.manager.AbstractManager;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Artigos;
import org.projectocolibri.api.database.model.Artigosdocumentos;
import org.projectocolibri.api.database.model.Artigosdocumentoslinhas;
import org.projectocolibri.api.database.model.Documentosseries;
import org.projectocolibri.api.database.model.Documentostipos;
import org.projectocolibri.api.database.model.persistence.ArtigosdocumentosPersistence;
import org.projectocolibri.api.database.query.QueryOrdering;
import org.projectocolibri.api.language.LABELS;

public class ArtigosdocumentosManager
extends AbstractManager<Artigosdocumentos> {
    public ArtigosdocumentosManager(PersistenceManagerFactory factory) {
        super(TABLES.artigosdocumentos, factory);
    }

    @Override
    public synchronized MessageList store(Artigosdocumentos documento, MethodCallback ... preCommit) {
        MessageList error = new MessageList();
        PersistenceManager pm = this.factory.getPersistenceManager();
        SerializedTransaction tx = new SerializedTransaction(pm);
        boolean cascade = documento.setCascade(false);
        try {
            tx.begin();
            if (documento.getTipodocumento() == null) {
                error.add(LABELS.entidadesdocumentos_tipodocumento.toString());
            }
            if (documento.getSeriedocumento() == null) {
                error.add(LABELS.entidadesdocumentos_seriedocumento.toString());
            }
            if (!error.isEmpty()) {
                MessageList messageList = error;
                return messageList;
            }
            documento.setTipodocumento((Documentostipos)TABLES.documentostipos.getObject(pm, documento.getTipodocumento().getCodigo()));
            documento.setSeriedocumento((Documentosseries)TABLES.documentosseries.getObject(pm, documento.getSeriedocumento().getKey()));
            for (Artigosdocumentoslinhas linha : documento.getLinhasdocumento()) {
                if (!linha.hasArtigo()) continue;
                linha.setArtigo((Artigos)TABLES.artigos.getObject(pm, linha.getArtigo().getCodigo()));
            }
            boolean exists = this.exists(documento.getKey());
            if (!documento.isEdited()) {
                documento.setNumerodocumento(documento.getNumerodocumento$Next());
                documento.setDatasistema();
            } else if (!exists) {
                throw new DatabaseException(LABELS.erro_database_registoinexistente.toString());
            }
            Artigosdocumentos stored = (Artigosdocumentos)this.table.getObjectOrNull(pm, documento.getKey());
            if (error.add(documento.validate(IDatabaseModel.ACTION.STORE))) {
                MessageList messageList = error;
                return messageList;
            }
            try {
                ArtigosdocumentosPersistence persistence = new ArtigosdocumentosPersistence(pm);
                if (stored == null) {
                    persistence.store(documento);
                    Debug.out((String)"GRAVOU");
                } else {
                    persistence.delete(stored);
                    Debug.out((String)"APAGOU");
                    Artigosdocumentos clone = documento.cloneCopy();
                    documento.setLinhasdocumento(clone.getLinhasdocumento());
                    persistence.store(documento);
                    Debug.out((String)"REGRAVOU");
                }
                MethodCallback[] methodCallbackArray = preCommit;
                int n = preCommit.length;
                int n2 = 0;
                while (n2 < n) {
                    MethodCallback callback = methodCallbackArray[n2];
                    if (!callback.run(pm, documento.cloneCopy())) {
                        throw new InterruptedException();
                    }
                    ++n2;
                }
                pm.makePersistent((Object)documento);
                tx.commit();
            }
            catch (DatabaseException e) {
                error.add((Throwable)e);
            }
            catch (InterruptedException e) {
                error.add((Throwable)new DatabaseException(e));
            }
            catch (JDOOptimisticVerificationException e) {
                error.add((Throwable)new DatabaseException(e));
            }
            catch (Exception e) {
                error.add((Throwable)new DatabaseException(e));
            }
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            } else if (!documento.isEdited()) {
                pm.refresh((Object)documento);
            }
            documento.setCascade(cascade);
            pm.close();
        }
        return error;
    }

    @Override
    public synchronized MessageList delete(Object key) {
        MessageList error = new MessageList();
        PersistenceManager pm = this.factory.getPersistenceManager();
        SerializedTransaction tx = new SerializedTransaction(pm);
        try {
            tx.begin();
            Artigosdocumentos documento = (Artigosdocumentos)this.table.getObject(pm, key);
            if (error.add(documento.validate(IDatabaseModel.ACTION.DELETE))) {
                MessageList messageList = error;
                return messageList;
            }
            try {
                ArtigosdocumentosPersistence persistence = new ArtigosdocumentosPersistence(pm);
                persistence.remove(documento);
                Debug.out((String)"REMOVEU");
                tx.commit();
            }
            catch (JDOOptimisticVerificationException e) {
                error.add((Throwable)new DatabaseException(e));
            }
            catch (JDOObjectNotFoundException e) {
                error.add((Throwable)new DatabaseException(e));
            }
            catch (Exception e) {
                error.add((Throwable)new DatabaseException(e));
            }
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            pm.close();
        }
        return error;
    }

    public synchronized Integer getPreviousNumero(String tipodocumento, String serie, Integer numerodocumento) {
        PersistenceManager pm = this.factory.getPersistenceManager();
        Query query = this.table.newQuery(pm);
        try {
            query.setFilter(String.valueOf(FIELDS.artigosdocumentos_tipodocumento.name) + "." + FIELDS.documentostipos_codigo.name + "==" + StringUtils.quote((String)tipodocumento, (char[])new char[0]) + " && " + FIELDS.artigosdocumentos_seriedocumento.name + "." + FIELDS.documentosseries_serie.name + "==" + StringUtils.quote((String)serie, (char[])new char[0]) + " && " + FIELDS.artigosdocumentos_numerodocumento.name + "<" + (numerodocumento < 0 ? Integer.MAX_VALUE : numerodocumento));
            query.setResult("max(" + FIELDS.artigosdocumentos_numerodocumento.name + ")");
            Integer n = (Integer)query.execute();
            return n;
        }
        finally {
            query.closeAll();
            pm.close();
        }
    }

    public synchronized Integer getNextNumero(String tipodocumento, String serie, Integer numerodocumento) {
        PersistenceManager pm = this.factory.getPersistenceManager();
        Query query = this.table.newQuery(pm);
        try {
            query.setFilter(String.valueOf(FIELDS.artigosdocumentos_tipodocumento.name) + "." + FIELDS.documentostipos_codigo.name + "==" + StringUtils.quote((String)tipodocumento, (char[])new char[0]) + " && " + FIELDS.artigosdocumentos_seriedocumento.name + "." + FIELDS.documentosseries_serie.name + "==" + StringUtils.quote((String)serie, (char[])new char[0]) + " && " + FIELDS.artigosdocumentos_numerodocumento.name + ">" + numerodocumento);
            query.setResult("min(" + FIELDS.artigosdocumentos_numerodocumento.name + ")");
            Integer n = (Integer)query.execute();
            return n;
        }
        finally {
            query.closeAll();
            pm.close();
        }
    }

    @Override
    public synchronized Collection<Artigosdocumentos> getCollection() {
        PersistenceManager pm = this.factory.getPersistenceManager();
        Query query = this.table.newQuery(pm);
        try {
            query.setOrdering(String.valueOf(FIELDS.artigosdocumentos_numerodocumento.name) + " " + (Object)((Object)QueryOrdering.DIRECTION.ASCENDING));
            Collection collection = pm.detachCopyAll((Collection)query.execute());
            return collection;
        }
        finally {
            query.closeAll();
            pm.close();
        }
    }

    @Override
    public synchronized Collection<Artigosdocumentos> getCollection(Object id) {
        return null;
    }
}

