/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.filter;

import java.util.Calendar;
import org.dma.java.util.ArrayUtils;
import org.dma.java.util.TimeDateUtils;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.language.LABELS;

public enum OPERANDS {
    OPERANDS;

    public static final String VAR_PREFIX = "#";

    public static enum METHODS {
        UNACCENT,
        COMPACT,
        LOWERCASE,
        TRIM;

    }

    public static enum TYPES {
        VALUE,
        VAR,
        FIELD;

    }

    public static enum VALUES {
        VALUES;


        public static enum BINARY {
            EMPTY(LABELS.valor_vazio, "null");

            public static final String[] ITEMS;
            public final LABELS label;
            public final String value;

            static {
                ITEMS = new String[BINARY.values().length];
                BINARY[] bINARYArray = BINARY.values();
                int n = bINARYArray.length;
                int n2 = 0;
                while (n2 < n) {
                    BINARY e = bINARYArray[n2];
                    BINARY.ITEMS[e.ordinal()] = e.label.toString();
                    ++n2;
                }
            }

            private BINARY(LABELS label, String value) {
                this.label = label;
                this.value = value;
            }

            public static boolean isValid(String value) {
                BINARY[] bINARYArray = BINARY.values();
                int n = bINARYArray.length;
                int n2 = 0;
                while (n2 < n) {
                    BINARY element = bINARYArray[n2];
                    if (element.value.equals(value)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        }

        public static enum BOOLEAN {
            FALSE(LABELS.valor_nao, "false"),
            TRUE(LABELS.valor_sim, "true");

            public static final String[] ITEMS;
            public final LABELS label;
            public final String value;

            static {
                ITEMS = new String[BOOLEAN.values().length];
                BOOLEAN[] bOOLEANArray = BOOLEAN.values();
                int n = bOOLEANArray.length;
                int n2 = 0;
                while (n2 < n) {
                    BOOLEAN e = bOOLEANArray[n2];
                    BOOLEAN.ITEMS[e.ordinal()] = e.label.toString();
                    ++n2;
                }
            }

            private BOOLEAN(LABELS label, String value) {
                this.label = label;
                this.value = value;
            }

            public static BOOLEAN get(boolean value) {
                return value ? TRUE : FALSE;
            }

            public static boolean isValid(String value) {
                BOOLEAN[] bOOLEANArray = BOOLEAN.values();
                int n = bOOLEANArray.length;
                int n2 = 0;
                while (n2 < n) {
                    BOOLEAN element = bOOLEANArray[n2];
                    if (element.value.equals(value)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        }
    }

    public static enum VARS {
        SYSTEM_TIME("#time", FIELDS.TYPES.TIME),
        SYSTEM_DATE("#date", FIELDS.TYPES.DATE),
        PREVIOUS_DAY("#-day", FIELDS.TYPES.DATE),
        CURRENT_WEEK1("#week1", FIELDS.TYPES.DATE),
        CURRENT_WEEK2("#week2", FIELDS.TYPES.DATE),
        CURRENT_MONTH1("#month1", FIELDS.TYPES.DATE),
        CURRENT_MONTH2("#month2", FIELDS.TYPES.DATE),
        PREVIOUS_MONTH1("#-month1", FIELDS.TYPES.DATE),
        PREVIOUS_MONTH2("#-month2", FIELDS.TYPES.DATE),
        CURRENT_YEAR1("#year1", FIELDS.TYPES.DATE),
        CURRENT_YEAR2("#year2", FIELDS.TYPES.DATE);

        public static final String[] NAMES;
        public String name;
        public FIELDS.TYPES type;

        static {
            NAMES = new String[VARS.values().length];
            VARS[] vARSArray = VARS.values();
            int n = vARSArray.length;
            int n2 = 0;
            while (n2 < n) {
                VARS e = vARSArray[n2];
                VARS.NAMES[e.ordinal()] = e.name;
                ++n2;
            }
        }

        public static VARS get(int index) {
            return VARS.values()[index];
        }

        private VARS(String name, FIELDS.TYPES type) {
            this.name = name;
            this.type = type;
        }

        public static VARS find(String name) {
            int index = ArrayUtils.indexOf((Object[])NAMES, (Object)name);
            return index == -1 ? null : VARS.get(index);
        }

        public Object getValue() {
            switch (this) {
                case SYSTEM_TIME: {
                    return TimeDateUtils.getCurrentTime();
                }
                case SYSTEM_DATE: {
                    return TimeDateUtils.getCurrentDate();
                }
                case PREVIOUS_DAY: {
                    return TimeDateUtils.addDays((Calendar)TimeDateUtils.getCalendar(), (int)-1).getTime();
                }
                case CURRENT_WEEK1: {
                    return TimeDateUtils.getCurrentWeekMin();
                }
                case CURRENT_WEEK2: {
                    return TimeDateUtils.getCurrentWeekMax();
                }
                case CURRENT_MONTH1: {
                    return TimeDateUtils.getCurrentMonthMin();
                }
                case CURRENT_MONTH2: {
                    return TimeDateUtils.getCurrentMonthMax();
                }
                case PREVIOUS_MONTH1: {
                    return TimeDateUtils.getCalendarWithDay((Calendar)TimeDateUtils.addMonths((Calendar)TimeDateUtils.getCalendar(), (int)-1), (int)1).getTime();
                }
                case PREVIOUS_MONTH2: {
                    return TimeDateUtils.getCalendarDayMax((Calendar)TimeDateUtils.addMonths((Calendar)TimeDateUtils.getCalendar(), (int)-1)).getTime();
                }
                case CURRENT_YEAR1: {
                    return TimeDateUtils.getCurrentYearMin();
                }
                case CURRENT_YEAR2: {
                    return TimeDateUtils.getCurrentYearMax();
                }
            }
            return null;
        }
    }
}

