/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.filter;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.lang.ObjectUtils;
import org.dma.java.util.StringUtils;
import org.dma.java.util.TimeDateUtils;
import org.dma.java.util.UniqueArrayList;
import org.projectocolibri.api.database.filter.OPERANDS;
import org.projectocolibri.api.database.filter.OPERATORS;
import org.projectocolibri.api.database.mapper.FIELDS;

public class FilterOperandMap
extends UniqueArrayList<OPERANDS.METHODS> {
    private static final long serialVersionUID = 1L;
    private Object converted;
    private final OPERATORS.MATH operator;
    private final String value;
    private final OPERANDS.TYPES type;

    public void print() {
        System.out.print(this.operator == null ? "?" : this.operator);
        System.out.print(" " + (Object)((Object)this.type) + " ");
        System.out.print(this.value == null ? "null" : this.value);
        if (this.type == OPERANDS.TYPES.VAR) {
            System.out.print(" (" + this.converted + ")");
        }
        System.out.println();
    }

    public Object getConverted() {
        return this.converted;
    }

    public OPERATORS.MATH getOperator() {
        return this.operator;
    }

    public String getValue() {
        return this.value;
    }

    public OPERANDS.TYPES getType() {
        return this.type;
    }

    public FilterOperandMap() {
        this(null);
    }

    public FilterOperandMap(OPERATORS.MATH operator) {
        this(operator, null, OPERANDS.TYPES.VALUE);
    }

    public FilterOperandMap(OPERATORS.MATH operator, Calendar value) {
        this(operator, TimeDateUtils.getDate((Calendar)value));
    }

    public FilterOperandMap(OPERATORS.MATH operator, Date value) {
        this(operator, TimeDateUtils.getDateFormatted((Date)value), OPERANDS.TYPES.VALUE);
    }

    public FilterOperandMap(OPERATORS.MATH operator, Integer value) {
        this(operator, value.toString(), OPERANDS.TYPES.VALUE);
    }

    public FilterOperandMap(OPERATORS.MATH operator, String value) {
        this(operator, value, OPERANDS.TYPES.VALUE);
    }

    public FilterOperandMap(OPERATORS.MATH operator, OPERANDS.VARS value) {
        this(operator, value.name, OPERANDS.TYPES.VAR);
    }

    public FilterOperandMap(OPERATORS.MATH operator, String value, OPERANDS.TYPES type) {
        this.operator = operator;
        this.value = value;
        this.type = type;
    }

    public FilterOperandMap cloneCopy() {
        FilterOperandMap clone = new FilterOperandMap(this.operator, this.value, this.type);
        clone.converted = this.converted;
        clone.addAll((Collection)((Object)this));
        return clone;
    }

    public void process(FIELDS.TYPES type) {
        this.converted = this.value;
        block0 : switch (this.type) {
            case VALUE: {
                switch (type) {
                    default: {
                        break block0;
                    }
                    case TIME: {
                        if (this.value == null) break block0;
                        this.converted = TimeDateUtils.getTime((String)this.value);
                        break block0;
                    }
                    case DATE: {
                        if (this.value == null) break block0;
                        this.converted = TimeDateUtils.getDate((String)this.value);
                        break block0;
                    }
                    case DECIMAL: {
                        if (this.value == null) break block0;
                        this.converted = new BigDecimal(this.value);
                        break block0;
                    }
                    case INTEGER: {
                        if (this.value == null) break block0;
                        this.converted = Integer.valueOf(this.value);
                        break block0;
                    }
                    case BOOLEAN: {
                        this.converted = Boolean.valueOf(this.value);
                        break block0;
                    }
                    case BINARY: 
                }
                if (!"null".equals(this.value)) break;
                this.converted = null;
                break;
            }
            case VAR: {
                OPERANDS.VARS var = OPERANDS.VARS.find(this.value);
                if (var == null) break;
                this.converted = var.getValue();
                break;
            }
        }
    }

    public String getStringValue() {
        if (this.converted == null) {
            throw new UnsupportedOperationException("Operand not converted");
        }
        String value = StringUtils.escape((String)this.converted.toString(), (char[])new char[]{'\\', '\"'});
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            OPERANDS.METHODS method = (OPERANDS.METHODS)((Object)iterator.next());
            switch (method) {
                case UNACCENT: {
                    value = StringUtils.unaccent((String)value);
                    break;
                }
                case COMPACT: {
                    value = StringUtils.replaceAll((String)value, (String)" ", (String)"");
                    break;
                }
                case LOWERCASE: {
                    value = value.toLowerCase();
                    break;
                }
                case TRIM: {
                    value = value.trim();
                }
            }
        }
        return value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.operator.symbol);
        switch (this.type) {
            case VALUE: {
                if (this.value == null) break;
                sb.append('\'').append(this.value).append('\'');
                break;
            }
            case VAR: {
                sb.append(this.value);
                break;
            }
            case FIELD: {
                sb.append(this.value);
            }
        }
        return sb.toString();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof FilterOperandMap) {
            return this.equals((FilterOperandMap)((Object)obj));
        }
        return false;
    }

    public boolean equals(FilterOperandMap other) {
        return this.operator.equals((Object)other.operator) && ObjectUtils.equals((Object)this.value, (Object)other.value) && this.type.equals((Object)other.type);
    }
}

