/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.filter;

import java.util.Collection;
import java.util.LinkedHashMap;
import org.dma.java.util.StringUtils;
import org.dma.java.util.TimeDateUtils;
import org.projectocolibri.api.database.filter.FilterFieldMap;
import org.projectocolibri.api.database.filter.FilterMap;
import org.projectocolibri.api.database.filter.FilterOperandMap;
import org.projectocolibri.api.database.filter.OPERANDS;
import org.projectocolibri.api.database.filter.OPERATORS;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TableFieldKey;
import org.projectocolibri.api.language.LABELS;

public class FilterMapValidator
extends LinkedHashMap<Integer, ERRORS> {
    private static final long serialVersionUID = 1L;
    private final FilterMap filterMap;
    private final Collection<TableFieldKey> layout;

    FilterMapValidator(FilterMap filterMap) {
        this.filterMap = filterMap;
        this.layout = filterMap.table.map.createLayout(false).exclude(FIELDS.TYPES.TABLE, FIELDS.TYPES.SET).exclude(16384);
    }

    private ERRORS checkField(TableFieldKey fieldKey, int maxLogicalOperators) {
        if (!this.layout.contains(fieldKey)) {
            return ERRORS.FIELD;
        }
        FIELDS field = this.filterMap.table.map.get((TableFieldKey)fieldKey).field;
        FilterFieldMap fieldMap = (FilterFieldMap)this.filterMap.get(fieldKey);
        int index = 0;
        for (FilterOperandMap operand : fieldMap) {
            if (operand.getOperator() == null || OPERATORS.MATH.GROUPS.find(field.type).indexOf(operand.getOperator()) == -1) {
                return ERRORS.OPERATOR_MATH;
            }
            block0 : switch (operand.getType()) {
                case VALUE: {
                    if (operand.getValue() == null) break;
                    switch (field.type) {
                        default: {
                            break block0;
                        }
                        case TIME: {
                            if (TimeDateUtils.isTimeValid((String)operand.getValue())) break block0;
                            return ERRORS.OPERAND;
                        }
                        case DATE: {
                            if (TimeDateUtils.isDateValid((String)operand.getValue())) break block0;
                            return ERRORS.OPERAND;
                        }
                        case DECIMAL: {
                            if (StringUtils.isDecimal((String)operand.getValue())) break block0;
                            return ERRORS.OPERAND;
                        }
                        case INTEGER: {
                            if (StringUtils.isNumeric((String)operand.getValue())) break block0;
                            return ERRORS.OPERAND;
                        }
                        case BOOLEAN: {
                            if (OPERANDS.VALUES.BOOLEAN.isValid(operand.getValue())) break block0;
                            return ERRORS.OPERAND;
                        }
                        case BINARY: 
                    }
                    if (OPERANDS.VALUES.BINARY.isValid(operand.getValue())) break;
                    return ERRORS.OPERAND;
                }
                case VAR: {
                    OPERANDS.VARS var = OPERANDS.VARS.find(operand.getValue());
                    if (var != null && var.type == field.type) break;
                    return ERRORS.OPERAND;
                }
                case FIELD: {
                    TableFieldKey operandKey;
                    TableFieldKey tableFieldKey = operandKey = operand.getValue() == null ? null : TableFieldKey.valueOf(operand.getValue());
                    if (operandKey != null && operandKey.index() == 1 && operandKey.size() <= 1 && !operandKey.equals(fieldKey) && this.layout.contains(operandKey) && this.filterMap.table.map.get((TableFieldKey)operandKey).field.type.type == field.type.type) break;
                    return ERRORS.OPERAND;
                }
            }
            if (fieldMap.getLogicalOperators().size() > index && fieldMap.getLogicalOperators(index) == null) {
                return ERRORS.OPERATOR_LOGICAL;
            }
            ++index;
        }
        if (maxLogicalOperators != -1 && fieldMap.getLogicalOperators().size() > maxLogicalOperators) {
            return ERRORS.OPERATOR_LOGICAL;
        }
        if (fieldMap.size() <= fieldMap.getLogicalOperators().size()) {
            return ERRORS.OPERATOR_MATH;
        }
        return null;
    }

    public boolean checkErrors(int maxLogicalOperators) {
        this.clear();
        int line = 0;
        for (TableFieldKey fieldKey : this.filterMap.keySet()) {
            try {
                ERRORS error = this.checkField(fieldKey, maxLogicalOperators);
                if (error != null) {
                    this.put(line, error);
                }
                ++line;
            }
            catch (Exception e) {
                this.put(line, ERRORS.INTERNAL);
                e.printStackTrace();
            }
        }
        return this.hasErrors();
    }

    public boolean checkErrors(String filter, int maxLogicalOperators) {
        this.filterMap.put(filter);
        return this.checkErrors(maxLogicalOperators);
    }

    public boolean checkErrors() {
        return this.checkErrors(-1);
    }

    public boolean hasErrors() {
        return !this.isEmpty();
    }

    public boolean hasError(int line) {
        return this.containsKey(line);
    }

    private String toString(Integer line) {
        return String.valueOf(LABELS.erro_filtro_linha.toString()) + " " + (line + 1) + ": " + ((ERRORS)((Object)this.get((Object)line))).label;
    }

    public String toText() {
        StringBuilder sb = new StringBuilder();
        for (Integer line : this.keySet()) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(this.toString(line));
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.hasErrors() ? this.toString((Integer)this.keySet().iterator().next()) : "";
    }

    public static enum ERRORS {
        INTERNAL(LABELS.erro_interno.toString()),
        TABLE(LABELS.erro_filtro_tabela.toString()),
        FIELD(LABELS.erro_filtro_campo.toString()),
        OPERAND(LABELS.erro_filtro_operando.toString()),
        OPERATOR_MATH(LABELS.erro_filtro_operadormatematico.toString()),
        OPERATOR_LOGICAL(LABELS.erro_filtro_operadorlogico.toString());

        public final String label;

        private ERRORS(String label) {
            this.label = label;
        }
    }
}

