/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.filter;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.projectocolibri.api.database.filter.FilterFieldMap;
import org.projectocolibri.api.database.filter.FilterOperandMap;
import org.projectocolibri.api.database.filter.OPERANDS;
import org.projectocolibri.api.database.filter.OPERATORS;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TableFieldKey;

public class FilterMapRule
extends FilterFieldMap {
    private static final long serialVersionUID = 1L;
    private final Collection<OPERANDS.METHODS> methods = new ArrayList<OPERANDS.METHODS>();
    public final TableFieldKey fieldKey;

    @Override
    public boolean add(FilterOperandMap operand) {
        operand.addAll(this.methods);
        return super.add(operand);
    }

    public FilterMapRule(FIELDS ... array) {
        this(new TableFieldKey(array));
    }

    public FilterMapRule(TableFieldKey fieldKey) {
        this.fieldKey = fieldKey;
    }

    public FilterMapRule and() {
        this.add(OPERATORS.LOGICAL.AND);
        return this;
    }

    public FilterMapRule or() {
        this.add(OPERATORS.LOGICAL.OR);
        return this;
    }

    public FilterMapRule unaccent() {
        this.methods.add(OPERANDS.METHODS.UNACCENT);
        return this;
    }

    public FilterMapRule compact() {
        this.methods.add(OPERANDS.METHODS.COMPACT);
        return this;
    }

    @Deprecated
    public FilterMapRule lowercase() {
        this.methods.add(OPERANDS.METHODS.LOWERCASE);
        return this;
    }

    public FilterMapRule trim() {
        this.methods.add(OPERANDS.METHODS.TRIM);
        return this;
    }

    public FilterMapRule contains() {
        this.add(new FilterOperandMap(OPERATORS.MATH.CONTAINS));
        return this;
    }

    public FilterMapRule contains(OPERANDS.VARS value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.CONTAINS, value));
        return this;
    }

    public FilterMapRule contains(Calendar value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.CONTAINS, value));
        return this;
    }

    public FilterMapRule contains(Date value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.CONTAINS, value));
        return this;
    }

    public FilterMapRule contains(Integer value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.CONTAINS, value));
        return this;
    }

    public FilterMapRule contains(String value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.CONTAINS, value));
        return this;
    }

    public FilterMapRule contains(FIELDS field) {
        this.add(new FilterOperandMap(OPERATORS.MATH.CONTAINS, field.name, OPERANDS.TYPES.FIELD));
        return this;
    }

    public FilterMapRule startsWith() {
        this.add(new FilterOperandMap(OPERATORS.MATH.STARTS_WITH));
        return this;
    }

    public FilterMapRule startsWith(OPERANDS.VARS value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.STARTS_WITH, value));
        return this;
    }

    public FilterMapRule startsWith(Calendar value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.STARTS_WITH, value));
        return this;
    }

    public FilterMapRule startsWith(Date value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.STARTS_WITH, value));
        return this;
    }

    public FilterMapRule startsWith(Integer value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.STARTS_WITH, value));
        return this;
    }

    public FilterMapRule startsWith(String value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.STARTS_WITH, value));
        return this;
    }

    public FilterMapRule startsWith(FIELDS field) {
        this.add(new FilterOperandMap(OPERATORS.MATH.STARTS_WITH, field.name, OPERANDS.TYPES.FIELD));
        return this;
    }

    public FilterMapRule endsWith() {
        this.add(new FilterOperandMap(OPERATORS.MATH.ENDS_WITH));
        return this;
    }

    public FilterMapRule endsWith(OPERANDS.VARS value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.ENDS_WITH, value));
        return this;
    }

    public FilterMapRule endsWith(Calendar value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.ENDS_WITH, value));
        return this;
    }

    public FilterMapRule endsWith(Date value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.ENDS_WITH, value));
        return this;
    }

    public FilterMapRule endsWith(Integer value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.ENDS_WITH, value));
        return this;
    }

    public FilterMapRule endsWith(String value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.ENDS_WITH, value));
        return this;
    }

    public FilterMapRule endsWith(FIELDS field) {
        this.add(new FilterOperandMap(OPERATORS.MATH.ENDS_WITH, field.name, OPERANDS.TYPES.FIELD));
        return this;
    }

    public FilterMapRule equal() {
        this.add(new FilterOperandMap(OPERATORS.MATH.EQUAL));
        return this;
    }

    public FilterMapRule equal(OPERANDS.VARS value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.EQUAL, value));
        return this;
    }

    public FilterMapRule equal(Calendar value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.EQUAL, value));
        return this;
    }

    public FilterMapRule equal(Date value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.EQUAL, value));
        return this;
    }

    public FilterMapRule equal(Integer value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.EQUAL, value));
        return this;
    }

    public FilterMapRule equal(String value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.EQUAL, value));
        return this;
    }

    public FilterMapRule equal(FIELDS field) {
        this.add(new FilterOperandMap(OPERATORS.MATH.EQUAL, field.name, OPERANDS.TYPES.FIELD));
        return this;
    }

    public FilterMapRule equalNull() {
        this.add(new FilterOperandMap(OPERATORS.MATH.EQUAL, null, OPERANDS.TYPES.FIELD));
        return this;
    }

    public FilterMapRule notEqual() {
        this.add(new FilterOperandMap(OPERATORS.MATH.NOT_EQUAL));
        return this;
    }

    public FilterMapRule notEqual(OPERANDS.VARS value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.NOT_EQUAL, value));
        return this;
    }

    public FilterMapRule notEqual(Calendar value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.NOT_EQUAL, value));
        return this;
    }

    public FilterMapRule notEqual(Date value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.NOT_EQUAL, value));
        return this;
    }

    public FilterMapRule notEqual(Integer value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.NOT_EQUAL, value));
        return this;
    }

    public FilterMapRule notEqual(String value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.NOT_EQUAL, value));
        return this;
    }

    public FilterMapRule notEqual(FIELDS field) {
        this.add(new FilterOperandMap(OPERATORS.MATH.NOT_EQUAL, field.name, OPERANDS.TYPES.FIELD));
        return this;
    }

    public FilterMapRule notEqualNull() {
        this.add(new FilterOperandMap(OPERATORS.MATH.NOT_EQUAL, null, OPERANDS.TYPES.FIELD));
        return this;
    }

    public FilterMapRule biggerThan() {
        this.add(new FilterOperandMap(OPERATORS.MATH.BIGGER_THAN));
        return this;
    }

    public FilterMapRule biggerThan(OPERANDS.VARS value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.BIGGER_THAN, value));
        return this;
    }

    public FilterMapRule biggerThan(Calendar value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.BIGGER_THAN, value));
        return this;
    }

    public FilterMapRule biggerThan(Date value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.BIGGER_THAN, value));
        return this;
    }

    public FilterMapRule biggerThan(Integer value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.BIGGER_THAN, value));
        return this;
    }

    public FilterMapRule biggerThan(String value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.BIGGER_THAN, value));
        return this;
    }

    public FilterMapRule biggerThan(FIELDS field) {
        this.add(new FilterOperandMap(OPERATORS.MATH.BIGGER_THAN, field.name, OPERANDS.TYPES.FIELD));
        return this;
    }

    public FilterMapRule smallerThan() {
        this.add(new FilterOperandMap(OPERATORS.MATH.SMALLER_THAN));
        return this;
    }

    public FilterMapRule smallerThan(OPERANDS.VARS value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.SMALLER_THAN, value));
        return this;
    }

    public FilterMapRule smallerThan(Calendar value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.SMALLER_THAN, value));
        return this;
    }

    public FilterMapRule smallerThan(Date value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.SMALLER_THAN, value));
        return this;
    }

    public FilterMapRule smallerThan(Integer value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.SMALLER_THAN, value));
        return this;
    }

    public FilterMapRule smallerThan(String value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.SMALLER_THAN, value));
        return this;
    }

    public FilterMapRule smallerThan(FIELDS field) {
        this.add(new FilterOperandMap(OPERATORS.MATH.SMALLER_THAN, field.name, OPERANDS.TYPES.FIELD));
        return this;
    }

    public FilterMapRule biggerEqual() {
        this.add(new FilterOperandMap(OPERATORS.MATH.BIGGER_EQUAL));
        return this;
    }

    public FilterMapRule biggerEqual(OPERANDS.VARS value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.BIGGER_EQUAL, value));
        return this;
    }

    public FilterMapRule biggerEqual(Calendar value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.BIGGER_EQUAL, value));
        return this;
    }

    public FilterMapRule biggerEqual(Date value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.BIGGER_EQUAL, value));
        return this;
    }

    public FilterMapRule biggerEqual(Integer value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.BIGGER_EQUAL, value));
        return this;
    }

    public FilterMapRule biggerEqual(String value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.BIGGER_EQUAL, value));
        return this;
    }

    public FilterMapRule biggerEqual(FIELDS field) {
        this.add(new FilterOperandMap(OPERATORS.MATH.BIGGER_EQUAL, field.name, OPERANDS.TYPES.FIELD));
        return this;
    }

    public FilterMapRule smallerEqual() {
        this.add(new FilterOperandMap(OPERATORS.MATH.SMALLER_EQUAL));
        return this;
    }

    public FilterMapRule smallerEqual(OPERANDS.VARS value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.SMALLER_EQUAL, value));
        return this;
    }

    public FilterMapRule smallerEqual(Calendar value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.SMALLER_EQUAL, value));
        return this;
    }

    public FilterMapRule smallerEqual(Date value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.SMALLER_EQUAL, value));
        return this;
    }

    public FilterMapRule smallerEqual(Integer value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.SMALLER_EQUAL, value));
        return this;
    }

    public FilterMapRule smallerEqual(String value) {
        this.add(new FilterOperandMap(OPERATORS.MATH.SMALLER_EQUAL, value));
        return this;
    }

    public FilterMapRule smallerEqual(FIELDS field) {
        this.add(new FilterOperandMap(OPERATORS.MATH.SMALLER_EQUAL, field.name, OPERANDS.TYPES.FIELD));
        return this;
    }
}

