/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.projectocolibri.api.database.filter.FilterOperandMap;
import org.projectocolibri.api.database.filter.OPERATORS;

public class FilterFieldMap
extends LinkedList<FilterOperandMap> {
    private static final long serialVersionUID = 1L;
    private final List<OPERATORS.LOGICAL> logicalOperators = new ArrayList<OPERATORS.LOGICAL>();

    public void print() {
        System.out.println("LOGICAL=" + this.logicalOperators);
        int index = 0;
        for (FilterOperandMap operand : this) {
            System.out.print(String.valueOf(index) + ": ");
            operand.print();
            ++index;
        }
    }

    public List<OPERATORS.LOGICAL> getLogicalOperators() {
        return this.logicalOperators;
    }

    public OPERATORS.LOGICAL getLogicalOperators(int index) {
        return this.logicalOperators.get(index);
    }

    public FilterFieldMap() {
    }

    @Deprecated
    FilterFieldMap(FilterOperandMap operand, OPERATORS.LOGICAL ... logicalOperators) {
        this(Arrays.asList(operand), logicalOperators);
    }

    @Deprecated
    FilterFieldMap(List<FilterOperandMap> operands, OPERATORS.LOGICAL ... logicalOperators) {
        this(operands, Arrays.asList(logicalOperators));
    }

    public FilterFieldMap(List<FilterOperandMap> operands, List<OPERATORS.LOGICAL> logicalOperators) {
        super(operands);
        this.logicalOperators.addAll(logicalOperators);
    }

    public FilterFieldMap cloneCopy() {
        return new FilterFieldMap((List<FilterOperandMap>)this, this.logicalOperators);
    }

    public int indexOf(OPERATORS.MATH operator) {
        int index = 0;
        for (FilterOperandMap element : this) {
            if (element.getOperator() == operator) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public FilterOperandMap remove(int index) {
        if (!this.logicalOperators.isEmpty()) {
            this.logicalOperators.remove(index == 0 ? 0 : index - 1);
        }
        return (FilterOperandMap)((Object)super.remove(index));
    }

    public FilterOperandMap remove(FilterOperandMap operand) {
        int index = this.indexOf((Object)operand);
        return index == -1 ? null : this.remove(index);
    }

    @Override
    public boolean add(OPERATORS.LOGICAL logicalOperator) {
        return this.logicalOperators.add(logicalOperator);
    }

    public boolean add(FilterOperandMap operand, OPERATORS.LOGICAL logicalOperator) {
        if (this.logicalOperators.size() < this.size()) {
            this.add(logicalOperator);
        }
        return super.add(operand);
    }

    @Override
    public boolean add(FilterOperandMap operand) {
        return this.add(operand, OPERATORS.LOGICAL.AND);
    }
}

