/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database;

import com.csvreader.CsvReader;
import java.io.File;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import org.dma.eclipse.jface.dialogs.progress.IProgressAction;
import org.dma.java.io.AbstractCSVReader;
import org.dma.java.util.Debug;
import org.dma.java.util.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Armazens;
import org.projectocolibri.api.database.model.Campos;
import org.projectocolibri.api.database.model.Codigosiva;
import org.projectocolibri.api.database.model.Codigospostais;
import org.projectocolibri.api.database.model.Condicoesentrega;
import org.projectocolibri.api.database.model.Condicoespagamento;
import org.projectocolibri.api.database.model.Contasbancarias;
import org.projectocolibri.api.database.model.Cores;
import org.projectocolibri.api.database.model.Documentostipos;
import org.projectocolibri.api.database.model.Empresa;
import org.projectocolibri.api.database.model.Entidades;
import org.projectocolibri.api.database.model.Entidadestipos;
import org.projectocolibri.api.database.model.Familias;
import org.projectocolibri.api.database.model.Grupos;
import org.projectocolibri.api.database.model.Isencoesiva;
import org.projectocolibri.api.database.model.Layouts;
import org.projectocolibri.api.database.model.Metodospagamento;
import org.projectocolibri.api.database.model.Metodostransporte;
import org.projectocolibri.api.database.model.Moedas;
import org.projectocolibri.api.database.model.Paises;
import org.projectocolibri.api.database.model.Parametros;
import org.projectocolibri.api.database.model.Parametrospos;
import org.projectocolibri.api.database.model.Pesquisas;
import org.projectocolibri.api.database.model.Precarios;
import org.projectocolibri.api.database.model.Retencoes;
import org.projectocolibri.api.database.model.Tamanhos;
import org.projectocolibri.api.database.model.Templates;
import org.projectocolibri.api.database.model.Tiposmorada;
import org.projectocolibri.api.database.model.Tiposmovimento;
import org.projectocolibri.api.database.model.Unidadesmedida;
import org.projectocolibri.api.database.model.Utilizadores;
import org.projectocolibri.api.database.model.Utilizadoresicones;
import org.projectocolibri.api.database.model.Vendedores;
import org.projectocolibri.api.database.model.Viaturas;

public class PopulateTableMap
extends LinkedHashMap<TABLES, IProgressAction> {
    private static final long serialVersionUID = 1L;
    public final DatabaseManager manager;

    public IProgressAction get(TABLES table) {
        IProgressAction value = (IProgressAction)super.get((Object)table);
        if (value == null) {
            throw new UnsupportedOperationException(table.name());
        }
        return value;
    }

    public PopulateTableMap(final DatabaseManager manager) {
        this.manager = manager;
        this.put(TABLES.codigosiva, new IProgressAction(){

            public void run(IProgressMonitor monitor) throws Exception {
                new AbstractCSVReader(TABLES.codigosiva.file){

                    public void postRead(CsvReader reader) throws Exception {
                        new Codigosiva(manager, reader.get(FIELDS.codigosiva_codigo.name), reader.get(FIELDS.codigosiva_descricao.name), Integer.valueOf(reader.get(FIELDS.codigosiva_tipotaxa.name)), Integer.valueOf(reader.get(FIELDS.codigosiva_espacofiscal.name)), new BigDecimal(reader.get(FIELDS.codigosiva_taxa.name))).create();
                    }
                }.readRecords();
            }
        });
        this.put(TABLES.isencoesiva, new IProgressAction(){

            public void run(IProgressMonitor monitor) throws Exception {
                if (Colibri.MARKET_TYPE == Colibri.MARKETS.INTERNAL) {
                    new AbstractCSVReader(TABLES.isencoesiva.file){

                        public void postRead(CsvReader reader) throws Exception {
                            String codigo = reader.get(FIELDS.isencoesiva_codigo.name);
                            if (Isencoesiva.MOTIVOS_AT.get(codigo) == null) {
                                throw new Exception("MOTIVO INVALIDO: " + codigo);
                            }
                            new Isencoesiva(manager, codigo, reader.get(FIELDS.isencoesiva_descricao.name), reader.get(FIELDS.isencoesiva_artigolegal.name)).create();
                        }
                    }.readRecords();
                }
            }
        });
        this.put(TABLES.retencoes, new IProgressAction(){

            public void run(IProgressMonitor monitor) throws Exception {
                new AbstractCSVReader(TABLES.retencoes.file){

                    public void postRead(CsvReader reader) throws Exception {
                        new Retencoes(manager, reader.get(FIELDS.retencoes_codigo.name), reader.get(FIELDS.retencoes_descricao.name), new BigDecimal(reader.get(FIELDS.retencoes_taxa.name))).create();
                    }
                }.readRecords();
            }
        });
        this.put(TABLES.unidadesmedida, new IProgressAction(){

            public void run(IProgressMonitor monitor) throws Exception {
                new AbstractCSVReader(TABLES.unidadesmedida.file){

                    public void postRead(CsvReader reader) throws Exception {
                        new Unidadesmedida(manager, reader.get(FIELDS.unidadesmedida_codigo.name), reader.get(FIELDS.unidadesmedida_unecerec20.name), reader.get(FIELDS.unidadesmedida_descricao.name), Integer.valueOf(reader.get(FIELDS.unidadesmedida_grandeza.name))).create();
                    }
                }.readRecords();
            }
        });
        this.put(TABLES.grupos, new IProgressAction(){

            public void run(IProgressMonitor monitor) throws Exception {
                new AbstractCSVReader(TABLES.grupos.file){

                    public void postRead(CsvReader reader) throws Exception {
                        new Grupos(manager, Integer.valueOf(reader.get(FIELDS.grupos_tabela.name)), reader.get(FIELDS.grupos_codigo.name), reader.get(FIELDS.grupos_descricao.name)).create();
                    }
                }.readRecords();
            }
        });
        this.put(TABLES.familias, new IProgressAction(){

            public void run(IProgressMonitor monitor) throws Exception {
                new AbstractCSVReader(TABLES.familias.file){

                    public void postRead(CsvReader reader) throws Exception {
                        new Familias(manager, Integer.valueOf(reader.get(FIELDS.familias_tabela.name)), reader.get(FIELDS.familias_codigo.name), reader.get(FIELDS.familias_descricao.name)).create();
                    }
                }.readRecords();
            }
        });
        this.put(TABLES.precarios, new IProgressAction(){

            public void run(IProgressMonitor monitor) throws Exception {
                new AbstractCSVReader(TABLES.precarios.file){

                    public void postRead(CsvReader reader) throws Exception {
                        new Precarios(manager, reader.get(FIELDS.precarios_codigo.name), reader.get(FIELDS.precarios_descricao.name)).create();
                    }
                }.readRecords();
            }
        });
        this.put(TABLES.tamanhos, new IProgressAction(){

            public void run(IProgressMonitor monitor) throws Exception {
                new AbstractCSVReader(TABLES.tamanhos.file){

                    public void postRead(CsvReader reader) throws Exception {
                        new Tamanhos(manager, reader.get(FIELDS.tamanhos_codigo.name), reader.get(FIELDS.tamanhos_descricao.name)).create();
                    }
                }.readRecords();
            }
        });
        this.put(TABLES.cores, new IProgressAction(){

            public void run(IProgressMonitor monitor) throws Exception {
                new AbstractCSVReader(TABLES.cores.file){

                    public void postRead(CsvReader reader) throws Exception {
                        new Cores(manager, reader.get(FIELDS.cores_codigo.name), reader.get(FIELDS.cores_descricao.name)).create();
                    }
                }.readRecords();
            }
        });
        this.put(TABLES.condicoespagamento, new IProgressAction(){

            public void run(IProgressMonitor monitor) throws Exception {
                new AbstractCSVReader(TABLES.condicoespagamento.file){

                    public void postRead(CsvReader reader) throws Exception {
                        new Condicoespagamento(manager, reader.get(FIELDS.condicoespagamento_codigo.name), reader.get(FIELDS.condicoespagamento_descricao.name), Integer.valueOf(reader.get(FIELDS.condicoespagamento_periodo.name))).create();
                    }
                }.readRecords();
            }
        });
        this.put(TABLES.metodospagamento, new IProgressAction(){

            public void run(IProgressMonitor monitor) throws Exception {
                new AbstractCSVReader(TABLES.metodospagamento.file){

                    public void postRead(CsvReader reader) throws Exception {
                        new Metodospagamento(manager, reader.get(FIELDS.metodospagamento_codigo.name), reader.get(FIELDS.metodospagamento_descricao.name), Integer.valueOf(reader.get(FIELDS.metodospagamento_tipo.name)), new BigDecimal(reader.get(FIELDS.metodospagamento_comissao.name))).create();
                    }
                }.readRecords();
            }
        });
        this.put(TABLES.condicoesentrega, new IProgressAction(){

            public void run(IProgressMonitor monitor) throws Exception {
                new AbstractCSVReader(TABLES.condicoesentrega.file){

                    public void postRead(CsvReader reader) throws Exception {
                        new Condicoesentrega(manager, reader.get(FIELDS.condicoesentrega_codigo.name), reader.get(FIELDS.condicoesentrega_descricao.name)).create();
                    }
                }.readRecords();
            }
        });
        this.put(TABLES.metodostransporte, new IProgressAction(){

            public void run(IProgressMonitor monitor) throws Exception {
                new AbstractCSVReader(TABLES.metodostransporte.file){

                    public void postRead(CsvReader reader) throws Exception {
                        new Metodostransporte(manager, reader.get(FIELDS.metodostransporte_codigo.name), reader.get(FIELDS.metodostransporte_descricao.name), Integer.valueOf(reader.get(FIELDS.metodostransporte_tipo.name))).create();
                    }
                }.readRecords();
            }
        });
        this.put(TABLES.tiposmorada, new IProgressAction(){

            public void run(IProgressMonitor monitor) throws Exception {
                new AbstractCSVReader(TABLES.tiposmorada.file){

                    public void postRead(CsvReader reader) throws Exception {
                        new Tiposmorada(manager, reader.get(FIELDS.tiposmorada_codigo.name), reader.get(FIELDS.tiposmorada_descricao.name), Integer.valueOf(reader.get(FIELDS.tiposmorada_tipo.name))).create();
                    }
                }.readRecords();
            }
        });
        this.put(TABLES.codigospostais, new IProgressAction(){

            public void run(IProgressMonitor monitor) throws Exception {
                new AbstractCSVReader(TABLES.codigospostais.file){

                    public void postRead(CsvReader reader) throws Exception {
                        new Codigospostais(manager, reader.get(FIELDS.codigospostais_codigo.name), reader.get(FIELDS.codigospostais_descricao.name)).create();
                    }
                }.readRecords();
                new Codigospostais(manager, manager.getLicenca().xml.getTitular().getCodigopostal(), manager.getLicenca().xml.getTitular().getLocalidade()).create();
            }
        });
        this.put(TABLES.paises, new IProgressAction(){

            public void run(IProgressMonitor monitor) throws Exception {
                new AbstractCSVReader(TABLES.paises.file){

                    public void postRead(CsvReader reader) throws Exception {
                        String codigo = reader.get(FIELDS.paises_codigo.name);
                        if (!Paises.ISO3166_CODES.contains(codigo)) {
                            throw new Exception("INVALID COUNTRY: " + codigo);
                        }
                        new Paises(manager, codigo, reader.get(FIELDS.paises_descricao.name)).create();
                    }
                }.readRecords();
            }
        });
        this.put(TABLES.armazens, new IProgressAction(){

            public void run(IProgressMonitor monitor) throws Exception {
                new AbstractCSVReader(TABLES.armazens.file){

                    public void postRead(CsvReader reader) throws Exception {
                        String codigo = reader.get(FIELDS.armazens_codigo.name);
                        if (codigo.equals(TABLES.armazens.defaultKey())) {
                            Armazens armazem = new Armazens(manager, codigo, reader.get(FIELDS.armazens_descricao.name));
                            armazem.setMorada(manager.getLicenca().xml.getTitular().getMorada());
                            armazem.setTelefone(manager.getLicenca().xml.getTitular().getTelefone());
                            armazem.setEmail(manager.getLicenca().xml.getTitular().getEmail());
                            armazem.create();
                        }
                    }
                }.readRecords();
            }
        });
        this.put(TABLES.vendedores, new IProgressAction(){

            public void run(IProgressMonitor monitor) throws Exception {
                new AbstractCSVReader(TABLES.vendedores.file){

                    public void postRead(CsvReader reader) throws Exception {
                        new Vendedores(manager, reader.get(FIELDS.vendedores_codigo.name), reader.get(FIELDS.vendedores_nome.name), 1, BigDecimal.ZERO).create();
                    }
                }.readRecords();
            }
        });
        this.put(TABLES.viaturas, new IProgressAction(){

            public void run(IProgressMonitor monitor) throws Exception {
                new AbstractCSVReader(TABLES.viaturas.file){

                    public void postRead(CsvReader reader) throws Exception {
                        new Viaturas(manager, reader.get(FIELDS.viaturas_codigo.name), reader.get(FIELDS.viaturas_descricao.name)).create();
                    }
                }.readRecords();
            }
        });
        this.put(TABLES.contasbancarias, new IProgressAction(){

            public void run(IProgressMonitor monitor) throws Exception {
                for (Contasbancarias model : Contasbancarias.RECORDS.create(manager)) {
                    model.create();
                }
            }
        });
        this.put(TABLES.tiposmovimento, new IProgressAction(){

            public void run(IProgressMonitor monitor) throws Exception {
                new AbstractCSVReader(TABLES.tiposmovimento.file){

                    public void postRead(CsvReader reader) throws Exception {
                        new Tiposmovimento(manager, reader.get(FIELDS.tiposmovimento_codigo.name), reader.get(FIELDS.tiposmovimento_descricao.name)).create();
                    }
                }.readRecords();
            }
        });
        this.put(TABLES.moedas, new IProgressAction(){

            public void run(IProgressMonitor monitor) throws Exception {
                new AbstractCSVReader(TABLES.moedas.file){

                    public void postRead(CsvReader reader) throws Exception {
                        String codigo = reader.get(FIELDS.moedas_codigo.name);
                        if (!Moedas.ISO4217_CODES.contains(codigo)) {
                            throw new Exception("INVALID CURRENCY: " + codigo);
                        }
                        Moedas moeda = new Moedas(manager, codigo, reader.get(FIELDS.moedas_descricao.name));
                        if (moeda.equals("EUR")) {
                            moeda.setUnidadeprincipal("Euros");
                            moeda.setUnidadefraccionaria("C\u00eantimos");
                            moeda.create();
                        }
                    }
                }.readRecords();
            }
        });
        this.put(TABLES.campos, new IProgressAction(){

            public void run(IProgressMonitor monitor) throws Exception {
                for (Campos model : Campos.RECORDS.create(manager)) {
                    model.create();
                }
            }
        });
        this.put(TABLES.layouts, new IProgressAction(){

            public void run(IProgressMonitor monitor) throws Exception {
                new AbstractCSVReader(TABLES.layouts.file){

                    public void postRead(CsvReader reader) throws Exception {
                        Layouts.RECORDS.create(manager, reader.get(FIELDS.layouts_codigo.name), reader.get(FIELDS.layouts_descricao.name)).create();
                    }
                }.readRecords();
            }
        });
        this.put(TABLES.pesquisas, new IProgressAction(){

            public void run(IProgressMonitor monitor) throws Exception {
                new AbstractCSVReader(TABLES.pesquisas.file){

                    public void postRead(CsvReader reader) throws Exception {
                        Pesquisas model = Pesquisas.RECORDS.create(manager, reader.get(FIELDS.pesquisas_codigo.name), reader.get(FIELDS.pesquisas_descricao.name));
                        model.validateFiltro();
                        model.create();
                    }
                }.readRecords();
            }
        });
        this.put(TABLES.templates, new IProgressAction(){

            public void run(IProgressMonitor monitor) throws Exception {
                File[] fileArray = Colibri.FOLDERS.POPULATE_TEMPLATES.folder.listFiles(Colibri.FILES.TEMPLATES.parameters.wildcards);
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    String codigo = StringUtils.left((String)file.getName(), (int)FIELDS.templates_codigo.format.getSize().size);
                    Debug.out((String)("FOUND: " + codigo));
                    Templates template = new Templates(manager, codigo, file.getName());
                    if (!template.isCodigoValid()) {
                        throw new IllegalArgumentException(file.toString());
                    }
                    if (!manager.existsTemplates(codigo)) {
                        template.importDesign(file, false);
                    }
                    if (!template.isEmpty() && !template.isLegal()) {
                        throw new IllegalArgumentException(file.toString());
                    }
                    template.create();
                    ++n2;
                }
            }
        });
        this.put(TABLES.entidadestipos, new IProgressAction(){

            public void run(IProgressMonitor monitor) throws Exception {
                new AbstractCSVReader(TABLES.entidadestipos.file){

                    public void postRead(CsvReader reader) throws Exception {
                        Entidadestipos.RECORDS.create(manager, reader.get(FIELDS.entidadestipos_codigo.name), reader.get(FIELDS.entidadestipos_descricao.name)).create();
                    }
                }.readRecords();
            }
        });
        this.put(TABLES.documentostipos, new IProgressAction(){

            public void run(IProgressMonitor monitor) throws Exception {
                new AbstractCSVReader(TABLES.documentostipos.file){

                    public void postRead(CsvReader reader) throws Exception {
                        Documentostipos.RECORDS.create(manager, reader.get(FIELDS.documentostipos_codigo.name), reader.get(FIELDS.documentostipos_descricao.name), reader.get(FIELDS.documentostipos_titulo.name)).create();
                    }
                }.readRecords();
            }
        });
        this.put(TABLES.empresa, new IProgressAction(){

            public void run(IProgressMonitor monitor) throws Exception {
                new Empresa(manager).create();
            }
        });
        this.put(TABLES.parametros, new IProgressAction(){

            public void run(IProgressMonitor monitor) throws Exception {
                new Parametros(manager).create();
            }
        });
        this.put(TABLES.entidades, new IProgressAction(){

            public void run(IProgressMonitor monitor) throws Exception {
                for (Entidades model : Entidades.RECORDS.create(manager)) {
                    model.create();
                }
            }
        });
        this.put(TABLES.parametrospos, new IProgressAction(){

            public void run(IProgressMonitor monitor) throws Exception {
                new Parametrospos(manager).create();
            }
        });
        this.put(TABLES.utilizadoresicones, new IProgressAction(){

            public void run(IProgressMonitor monitor) throws Exception {
                for (Utilizadores utilizador : manager.getUtilizadoresCollection()) {
                    for (Utilizadoresicones model : Utilizadoresicones.RECORDS.create(utilizador)) {
                        model.create();
                    }
                }
            }
        });
    }
}

