/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database;

import java.util.LinkedHashMap;
import org.dma.drivers.jdbc.DRIVERS;
import org.dma.java.util.ArrayUtils;
import org.projectocolibri.api.Activator;
import org.projectocolibri.api.database.DatabaseParameters;

public final class JDOPropertiesMap
extends LinkedHashMap<String, Object> {
    private static final long serialVersionUID = 1L;

    public JDOPropertiesMap(DatabaseParameters parameters, String ... classNames) {
        try {
            this.put("javax.jdo.PersistenceManagerFactoryClass", "org.datanucleus.jdo.JDOPersistenceManagerFactory");
            this.put("datanucleus.ConnectionDriverName", parameters.driver.name);
            this.put("datanucleus.ConnectionURL", parameters.getConnectionUrl());
            this.put("datanucleus.ConnectionUserName", parameters.username);
            this.put("datanucleus.ConnectionPassword", parameters.password);
            switch (parameters.pool) {
                case NONE: {
                    this.put("datanucleus.connectionPoolingType", "None");
                    break;
                }
                case DBCP: {
                    break;
                }
                case C3P0: {
                    this.put("datanucleus.connectionPoolingType", "C3P0");
                    this.put("datanucleus.connectionPool.maxPoolSize", "5");
                    this.put("datanucleus.connectionPool.minPoolSize", "3");
                    this.put("datanucleus.connectionPool.initialPoolSize", "3");
                    this.put("datanucleus.connectionPool.maxStatements", "20");
                    break;
                }
                case BONECP: {
                    this.put("datanucleus.connectionPoolingType", "BoneCP");
                    this.put("datanucleus.connectionPool.maxPoolSize", "5");
                    this.put("datanucleus.connectionPool.minPoolSize", "3");
                    this.put("datanucleus.connectionPool.maxStatements", "20");
                }
            }
            this.put("datanucleus.IgnoreCache", "true");
            this.put("datanucleus.Multithreaded", "false");
            this.put("datanucleus.NontransactionalRead", "true");
            this.put("datanucleus.NontransactionalWrite", "false");
            this.put("datanucleus.Optimistic", "false");
            this.put("datanucleus.RetainValues", "true");
            this.put("datanucleus.RestoreValues", "true");
            this.put("datanucleus.DetachAllOnCommit", "false");
            this.put("datanucleus.detachAllOnRollback", "false");
            this.put("datanucleus.CopyOnAttach", "true");
            this.put("datanucleus.mapping.Schema", parameters.driver.driver == DRIVERS.SQLServer ? "dbo" : null);
            this.put("datanucleus.storeManagerType", "rdbms");
            this.put("datanucleus.deletionPolicy", "JDO2");
            this.put("datanucleus.attachSameDatastore", "true");
            this.put("datanucleus.attachPolicy", "attach-dirty");
            this.put("datanucleus.detachAsWrapped", "false");
            this.put("datanucleus.DetachOnClose", "false");
            this.put("datanucleus.detachmentFields", "load-unload-fields");
            this.put("datanucleus.manageRelationships", "false");
            this.put("datanucleus.manageRelationshipsChecks", "true");
            this.put("datanucleus.persistenceByReachabilityAtCommit", "false");
            this.put("datanucleus.maxFetchDepth", "1");
            this.put("datanucleus.primaryClassLoader", Activator.classForName(parameters.driver.name).getClassLoader());
            this.put("datanucleus.autoCreateSchema", "false");
            this.put("datanucleus.autoCreateTables", "true");
            this.put("datanucleus.autoCreateColumns", "true");
            this.put("datanucleus.autoCreateConstraints", "true");
            this.put("datanucleus.validateTables", Boolean.toString(false));
            this.put("datanucleus.validateColumns", Boolean.toString(false));
            this.put("datanucleus.validateConstraints", Boolean.toString(false));
            this.put("datanucleus.identifier.case", "UpperCase");
            this.put("datanucleus.transactionIsolation", "read-committed");
            this.put("datanucleus.SerializeRead", "false");
            this.put("datanucleus.cache.collections", "true");
            this.put("datanucleus.cache.collections.lazy", "false");
            this.put("datanucleus.cache.level1.type", "strong");
            this.put("datanucleus.cache.level2.type", "none");
            this.put("datanucleus.cache.queryCompilation.type", "soft");
            this.put("datanucleus.cache.queryCompilationDatastore.type", "soft");
            this.put("datanucleus.cache.queryResults.type", "soft");
            this.put("datanucleus.valuegeneration.transactionAttribute", "New");
            this.put("datanucleus.valuegeneration.transactionIsolation", "read-committed");
            this.put("datanucleus.metadata.autoregistration", "false");
            this.put("datanucleus.autoStartMechanism", "Classes");
            this.put("datanucleus.autoStartMechanismMode", "Checked");
            this.put("datanucleus.autoStartClassNames", ArrayUtils.concat((String[])classNames, (String)","));
            this.put("datanucleus.query.flushBeforeExecution", "false");
            this.put("datanucleus.query.useFetchPlan", "true");
            this.put("datanucleus.query.sql.allowAll", "true");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

