/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.listener.InstanceLifecycleListener;
import org.datanucleus.jdo.JDOPersistenceManagerFactory;
import org.dma.drivers.jdbc.BackupParameters;
import org.dma.drivers.jdbc.POOLMANAGERS;
import org.h2.constant.SysProperties;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.DRIVERS;
import org.projectocolibri.api.database.model.Utilizadores;
import org.projectocolibri.xml.beans.licencas.ColibriLicenca;
import org.projectocolibri.xml.empresas.EmpresaDocument;

public class DatabaseParameters
extends org.dma.drivers.jdbc.DatabaseParameters {
    public final DRIVERS driver;
    public final String connectionUrl;

    public DatabaseParameters() {
        this(DRIVERS.H2, "", "sa", "");
    }

    public DatabaseParameters(EmpresaDocument.Empresa empresa) {
        this(empresa.getDbcolibri());
    }

    public DatabaseParameters(EmpresaDocument.Empresa.Dbcolibri dbcolibri) {
        this(DRIVERS.valueOf(dbcolibri.getDriver()), dbcolibri.getHost(), dbcolibri.getDatabase(), dbcolibri.getProperties(), dbcolibri.getUtilizador(), Colibri.PASSWORD_CIPHER.decode(dbcolibri.getPassword()), dbcolibri.getBackups());
    }

    public DatabaseParameters(DRIVERS driver, String database, String username, String password) {
        this(driver, "", database, username, password);
    }

    public DatabaseParameters(DRIVERS driver, String host, String database, String username, String password) {
        this(driver, host, database, "", username, password);
    }

    public DatabaseParameters(DRIVERS driver, String host, String database, String properties, String username, String password) {
        this(driver, host, database, properties, username, password, new BackupParameters());
    }

    public DatabaseParameters(DRIVERS driver, String host, String database, String properties, String username, String password, EmpresaDocument.Empresa.Dbcolibri.Backups backup) {
        this(driver, host, database, properties, username, password, backup == null ? new BackupParameters() : driver.parseBackup(backup));
    }

    public DatabaseParameters(DRIVERS driver, String host, String database, String properties, String username, String password, BackupParameters backup) {
        super(driver.driver, host, driver.parseDatabase(database), driver.getFolder(database), properties, username, password, POOLMANAGERS.DBCP, backup.isEmpty() ? driver.backup : backup);
        this.driver = driver;
        this.connectionUrl = this.getConnectionUrl();
    }

    public boolean isHostValid(ColibriLicenca licenca) {
        switch (this.driver) {
            case H2: {
                if (!this.isH2Embedded()) break;
                return true;
            }
            case MySQL: 
            case PostgreSQL: 
            case SQLServer: {
                if (!this.host.isEmpty()) break;
                return false;
            }
        }
        return this.isLocalhost() || licenca.allows(Colibri.FUNCIONALIDADES.BASE_DADOS_REMOTA);
    }

    public PersistenceManagerFactory createFactory(InstanceLifecycleListener listener, Map<String, Object> props) throws Exception {
        JDOPersistenceManagerFactory factory = new JDOPersistenceManagerFactory(props);
        factory.addInstanceLifecycleListener(listener, null);
        this.configureDatabase((PersistenceManagerFactory)factory);
        return factory;
    }

    public void configureDatabase(PersistenceManagerFactory factory) throws Exception {
        ArrayList<String> commands = new ArrayList<String>();
        switch (this.driver) {
            case H2: {
                if (!SysProperties.STORE_LOCAL_TIME) {
                    throw new IllegalStateException("h2.storeLocalTime");
                }
                commands.add("CREATE USER IF NOT EXISTS " + Utilizadores.USERS.COLIBRI.user.toUpperCase() + " PASSWORD '" + Utilizadores.USERS.COLIBRI.password + "' ADMIN");
                switch (Colibri.VERSION_TYPE) {
                    case INTERNAL: {
                        commands.add("SET TRACE_LEVEL_FILE 0");
                        commands.add("SET TRACE_LEVEL_SYSTEM_OUT 1");
                        break;
                    }
                    case SERVER: 
                    case PLUGIN: 
                    case DESKTOP: {
                        commands.add("SET TRACE_LEVEL_FILE 1");
                        commands.add("SET TRACE_LEVEL_SYSTEM_OUT 2");
                    }
                }
                break;
            }
            case MySQL: {
                break;
            }
            case PostgreSQL: {
                break;
            }
        }
        Iterator iterator = commands.iterator();
        if (iterator.hasNext()) {
            String sql = (String)iterator.next();
            this.driver.executeSQLUpdate(factory, sql);
        }
    }

    public String toString() {
        return this.connectionUrl;
    }

    public int hashCode() {
        return this.connectionUrl.hashCode();
    }

    public boolean equals(Object obj) {
        return this.hashCode() == obj.hashCode();
    }
}

