/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database;

import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.JDOOptimisticVerificationException;
import javax.xml.ws.WebServiceException;
import org.dma.eclipse.core.DebugLogger;
import org.dma.java.util.MessageList;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.language.LABELS;

public class DatabaseException
extends RuntimeException {
    private static final long serialVersionUID = 1L;

    public DatabaseException(MessageList error) {
        this(error.toString());
    }

    public DatabaseException(String message) {
        super(message);
    }

    public DatabaseException(InterruptedException cause) {
        super(LABELS.info_database_gravacaocancelada.toString(), cause);
    }

    public DatabaseException(JDOOptimisticVerificationException cause) {
        super(LABELS.erro_database_registoinconsistente.toString(), (Throwable)cause);
        Colibri.logger().log(DebugLogger.SEVERITY.ERROR, (Throwable)this);
    }

    public DatabaseException(JDOObjectNotFoundException cause) {
        super(LABELS.erro_database_registoinexistente.toString(), (Throwable)cause);
        Colibri.logger().log(DebugLogger.SEVERITY.ERROR, (Throwable)this);
    }

    public DatabaseException(WebServiceException cause) {
        super(cause.getMessage(), (Throwable)cause);
        Colibri.logger().log(DebugLogger.SEVERITY.ERROR, (Throwable)this);
    }

    public DatabaseException(Exception cause) {
        super(LABELS.erro_database_operacaofalhada.toString(), cause);
        Colibri.logger().log(DebugLogger.SEVERITY.ERROR, (Throwable)this);
    }
}

