/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database;

import java.io.File;
import java.sql.Connection;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.datastore.JDOConnection;
import org.dma.drivers.jdbc.BackupParameters;
import org.dma.java.io.Folder;
import org.dma.java.util.StringList;
import org.dma.java.util.StringUtils;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.xml.empresas.EmpresaDocument;

public enum DRIVERS {
    H2(org.dma.drivers.jdbc.DRIVERS.H2, new BackupParameters(Colibri.FOLDERS.BACKUPS.folder.getName(), "java", new BackupParameters.Arguments(new String[]{"-cp", "h2-" + org.dma.drivers.jdbc.DRIVERS.H2_VERSION.toString(3) + ".jar", "org.h2.tools.Script", "-url", "[database]", "-user", StringUtils.quote((String)"[user]", (char[])new char[0]), "-password", StringUtils.quote((String)"[password]", (char[])new char[0]), "-script", "[dump]"}))),
    MySQL(org.dma.drivers.jdbc.DRIVERS.MySQL, new BackupParameters(Colibri.FOLDERS.BACKUPS.folder.getName(), "mysqldump", new BackupParameters.Arguments(new String[]{"-u[user]", "-p[password]", "-r[dump]", "-v", "[database]"}))),
    PostgreSQL(org.dma.drivers.jdbc.DRIVERS.PostgreSQL, new BackupParameters(Colibri.FOLDERS.BACKUPS.folder.getName(), "pg_dump", new BackupParameters.Arguments(new String[]{"-U[user]", "-f[dump]", "-b", "-v", "[database]"}))),
    SQLServer(org.dma.drivers.jdbc.DRIVERS.SQLServer, new BackupParameters());

    public static final String DEFAULT_DATABASE;
    public static final String[] NAMES;
    public final org.dma.drivers.jdbc.DRIVERS driver;
    public final BackupParameters backup;
    public final String name;

    static {
        DEFAULT_DATABASE = Colibri.FILES.DATABASES.COLIBRI.parameters.prefix;
        NAMES = StringList.valueOf((Object[])DRIVERS.values()).toArray();
    }

    private DRIVERS(org.dma.drivers.jdbc.DRIVERS driver, BackupParameters backup) {
        this.driver = driver;
        this.backup = backup;
        this.name = driver.name;
    }

    public String parseDatabase(String database) {
        String parsed = database.isEmpty() ? DEFAULT_DATABASE : database;
        switch (this) {
            case H2: {
                return new File(parsed).getName();
            }
        }
        return parsed;
    }

    public Folder getFolder(String database) {
        String parent = new File(database).getParent();
        switch (this) {
            case H2: {
                return parent == null ? Colibri.FOLDERS.DATABASES.folder : new Folder(parent, new String[0]);
            }
        }
        return null;
    }

    public BackupParameters parseBackup(EmpresaDocument.Empresa.Dbcolibri.Backups backup) {
        String folder = backup.getFolder() == null || backup.getFolder().isEmpty() ? this.backup.folder : backup.getFolder();
        String command = backup.getCommand() == null || backup.getCommand().isEmpty() ? this.backup.command : backup.getCommand();
        BackupParameters.Arguments arguments = backup.getArguments() == null || backup.getArguments().isEmpty() ? this.backup.arguments : new BackupParameters.Arguments(backup.getArguments());
        return new BackupParameters(folder, command, arguments);
    }

    public void executeAlterDataType(PersistenceManagerFactory factory, String tableName, String columnName, String dataType) throws Exception {
        PersistenceManager pm = factory.getPersistenceManager();
        JDOConnection JDOConnection2 = pm.getDataStoreConnection();
        Connection connection = (Connection)JDOConnection2.getNativeConnection();
        this.driver.manager.executeAlterDataType(connection, tableName.toUpperCase(), columnName.toUpperCase(), dataType);
        connection.close();
        pm.close();
    }

    public void executeDropColumn(PersistenceManagerFactory factory, String tableName, String columnName) throws Exception {
        PersistenceManager pm = factory.getPersistenceManager();
        JDOConnection JDOConnection2 = pm.getDataStoreConnection();
        Connection connection = (Connection)JDOConnection2.getNativeConnection();
        this.driver.manager.executeDropColumn(connection, tableName.toUpperCase(), columnName.toUpperCase());
        connection.close();
        pm.close();
    }

    public void executeDropTable(PersistenceManagerFactory factory, String tableName) throws Exception {
        PersistenceManager pm = factory.getPersistenceManager();
        JDOConnection JDOConnection2 = pm.getDataStoreConnection();
        Connection connection = (Connection)JDOConnection2.getNativeConnection();
        this.driver.manager.executeDropTable(connection, tableName.toUpperCase());
        connection.close();
        pm.close();
    }

    public void executeSQLUpdate(PersistenceManagerFactory factory, String sql) throws Exception {
        PersistenceManager pm = factory.getPersistenceManager();
        JDOConnection JDOConnection2 = pm.getDataStoreConnection();
        Connection connection = (Connection)JDOConnection2.getNativeConnection();
        this.driver.manager.executeSQLUpdate(connection, sql);
        connection.close();
        pm.close();
    }
}

