/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database;

import org.dma.java.util.ErrorList;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.DatabaseParameters;
import org.projectocolibri.xml.beans.empresas.ColibriEmpresa;
import org.projectocolibri.xml.beans.licencas.ColibriLicenca;
import org.projectocolibri.xml.empresas.EmpresaDocument;

public final class ColibriDatabase {
    private static DatabaseManager manager;

    public static DatabaseManager getManager() {
        if (manager == null) {
            throw new RuntimeException("There is no active instance");
        }
        return manager;
    }

    public static void logout() {
        if (manager != null) {
            manager.close();
        }
    }

    public static ErrorList login(ColibriLicenca licenca, String user, String password) {
        return ColibriDatabase.login(licenca, 0, user, password);
    }

    public static ErrorList login(ColibriLicenca licenca, int index, String user, String password) {
        return ColibriDatabase.login(licenca, (EmpresaDocument.Empresa)ColibriEmpresa.getDatabase().get(index), user, password);
    }

    public static ErrorList login(ColibriLicenca licenca, EmpresaDocument.Empresa empresa, String user, String password) {
        return ColibriDatabase.login(licenca, new DatabaseParameters(empresa), user, password);
    }

    public static ErrorList login(ColibriLicenca licenca, DatabaseParameters parameters, String user, String password) {
        ErrorList error = new ErrorList();
        try {
            manager = new DatabaseManager(licenca, parameters);
            error.add(manager.authenticate(user, password)).add(manager.populate()).add(manager.update());
        }
        catch (Exception e) {
            ColibriDatabase.logout();
            error.errors().add((Throwable)e);
        }
        return error;
    }

    public static enum LOGIN_RESULT {
        LOGIN,
        RESTART,
        EXIT;

    }
}

