/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.birt.report;

import java.math.BigDecimal;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;
import org.dma.java.time.DatePeriod;
import org.dma.java.util.TimeDateUtils;
import org.dma.services.mb.MultibancoRef;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.IDocumentoModel;
import org.projectocolibri.api.database.filter.FilterMap;
import org.projectocolibri.api.database.model.Empresa;
import org.projectocolibri.api.database.model.Parametros;
import org.projectocolibri.api.database.model.Templates;
import org.projectocolibri.xml.beans.licencas.ColibriLicenca;

public class BIRTReportParameters {
    private final DatabaseManager manager;
    private final String filtro;
    private final String titulo;
    private final String mensagem;
    private final String ATCUD;
    private final String ATQRCode;
    private final String ATDocumentCode;
    private final String dataDocumento;
    private final BigDecimal totalCambio;
    private final String totalExtenso;
    private final MultibancoRef multibanco;
    private final DatePeriod periodo;

    public Empresa getEmpresa() {
        return this.manager.getEmpresa();
    }

    public Parametros getParametros() {
        return this.manager.getParametros();
    }

    public ColibriLicenca getLicenca() {
        return this.manager.getLicenca();
    }

    public String getFiltro() {
        return this.filtro;
    }

    public String getTitulo() {
        return this.titulo;
    }

    public String getMensagem() {
        return this.mensagem;
    }

    public String getATCUD() {
        return this.ATCUD;
    }

    public String getATQRCode() {
        return this.ATQRCode;
    }

    public String getATDocumentCode() {
        return this.ATDocumentCode;
    }

    public String getDataDocumento() {
        return this.dataDocumento;
    }

    public BigDecimal getTotalCambio() {
        return this.totalCambio;
    }

    public String getTotalExtenso() {
        return this.totalExtenso;
    }

    public MultibancoRef getMultibanco() {
        return this.multibanco;
    }

    public DatePeriod getPeriodo() {
        return this.periodo;
    }

    public BIRTReportParameters(IDocumentoModel model) {
        this(model.getTemplate(), model.createReport().getFilterMap(), model.getReportTtitle(), model.getReportMessage(), model.getATCUD(), model.getATQRCode(), model.getDocumentcode(), model.getDatacriacao(), model.getTotalcambio(), model.getTotalextenso(), model.getMultibanco(), new DatePeriod());
    }

    public BIRTReportParameters(Templates template, FilterMap filterMap, DatePeriod periodo) {
        this(template, filterMap, template.getDescricao(), "", "", null, "", TimeDateUtils.getCurrentDate(), BigDecimal.ZERO, "", MultibancoRef.DEFAULT, periodo);
    }

    public BIRTReportParameters(Templates template, FilterMap filterMap, String titulo, String mensagem, String ATCUD, byte[] ATQRCode, String ATDocumentCode, Date dataDocumento, BigDecimal totalCambio, String totalExtenso, MultibancoRef multibanco, DatePeriod periodo) {
        this.manager = template.getManager();
        this.filtro = filterMap.toReadable(this.manager.getCampos());
        this.titulo = titulo;
        this.mensagem = mensagem;
        this.ATCUD = ATCUD.equals("0") ? ATCUD : "ATCUD:" + ATCUD;
        this.ATQRCode = ATQRCode == null ? "" : new String(Base64.encodeBase64((byte[])ATQRCode));
        this.ATDocumentCode = ATDocumentCode;
        this.dataDocumento = TimeDateUtils.getDateFormatted((Date)dataDocumento, (String)(String.valueOf(TimeDateUtils.DATE_YEAR_PATTERN) + ',' + TimeDateUtils.DATE_MONTH_PATTERN + ',' + TimeDateUtils.DATE_DAY_PATTERN));
        this.totalCambio = totalCambio;
        this.totalExtenso = totalExtenso;
        this.multibanco = multibanco;
        this.periodo = periodo;
    }
}

