/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.birt.report;

import java.io.File;
import org.dma.java.awt.PrinterHandler;
import org.dma.java.io.HugePdfFile;
import org.dma.java.security.PdfSignature;
import org.dma.java.time.Chronograph;
import org.dma.java.util.Debug;
import org.dma.java.util.MessageList;
import org.eclipse.swt.program.Program;
import org.projectocolibri.api.birt.report.BIRTEmailParameters;
import org.projectocolibri.api.birt.report.BIRTReport;
import org.projectocolibri.core.support.printer.PrinterSupport;

public class BIRTReportFile
extends HugePdfFile {
    public static final String PDF_SIGNATURE_REASON = "Artigo 3\u00ba alinea a) do Decreto-Lei 196/2007";
    private final BIRTReport.REPORT_FORMATS format;

    public BIRTReportFile(File file, BIRTReport.REPORT_FORMATS format) {
        super(file);
        this.format = format;
    }

    public void stamp(PdfSignature signature) throws Exception {
        signature.setReason(PDF_SIGNATURE_REASON);
        if (this.length() > 0L && this.format == BIRTReport.REPORT_FORMATS.PDF) {
            super.stamp(signature);
        }
    }

    public BIRTReportFile sign(PdfSignature signature) throws Exception {
        Chronograph time = new Chronograph().start();
        this.stamp(signature);
        Debug.out((String)"STAMP EXECUTED", (Object)time.stop());
        return this;
    }

    public boolean open() {
        if (this.exists()) {
            try {
                return super.open() || Program.launch((String)this.getPath());
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public MessageList print() {
        return this.print(PrinterHandler.lookupDefaultPrinterName());
    }

    public MessageList print(String printerName) {
        PrinterSupport printer = new PrinterSupport(printerName);
        Debug.out((String)"PRINT STARTED", (Object)printerName);
        if (printer.isEmpty()) {
            switch (this.format) {
                case PDF: {
                    printer.printPdf((File)((Object)this));
                    break;
                }
                case WEB: 
                case XLS: {
                    printer.printFile((File)((Object)this));
                }
            }
        }
        Debug.out((String)"PRINT FINISHED");
        return printer;
    }

    public MessageList send(BIRTEmailParameters email) {
        MessageList error = new MessageList();
        Debug.out((String)"SEND STARTED", (Object)((Object)email));
        error.add(email.send((File)((Object)this)));
        Debug.out((String)"SEND FINISHED");
        return error;
    }
}

