/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.birt.design;

import java.io.File;
import java.util.List;
import org.dma.java.util.Debug;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.HideRuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.projectocolibri.api.birt.design.BIRTParametersMap;

public class BIRTDesignHandler {
    private ReportDesignHandle design;
    protected final File designFile;
    protected final int reportType;

    public ReportDesignHandle getDesign() {
        return this.design;
    }

    public BIRTDesignHandler(File designFile, int reportType) {
        this.designFile = designFile;
        this.reportType = reportType;
    }

    public boolean openDesign() {
        if (this.designFile.length() > 0L) {
            try {
                this.design = new DesignEngine(new DesignConfig()).newSessionHandle(null).openDesign(this.designFile.getAbsolutePath());
                return true;
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
        return false;
    }

    public void updateDesign() throws Exception {
        this.removeOldParameters(this.reportType);
        this.createNewParameters(this.reportType);
        this.changeParameterTypes(this.reportType);
    }

    public File saveDesign() throws Exception {
        if (this.design != null && this.design.needsSave()) {
            Debug.out((String)("SAVING: " + this.design.getFileName()));
            this.design.save();
        }
        return this.designFile;
    }

    public void closeDesign() {
        if (this.design != null) {
            this.design.close();
        }
    }

    public void checkDesign() throws Exception {
        DataItemHandle dataItem = (DataItemHandle)this.design.findElement(BIRTParametersMap.PARAMETERS_TYPES.legal_statement.name);
        if (dataItem == null) {
            throw new Exception("Invalid message element!");
        }
        ComputedColumnHandle computedColumn = (ComputedColumnHandle)dataItem.getColumnBindings().iterator().next();
        String expression = computedColumn.getExpression();
        Debug.out((String)"EXPRESSION", (Object)expression);
        if (expression == null || !expression.contains(BIRTParametersMap.PARAMETERS_TYPES.legal_statement.expression)) {
            throw new Exception("Invalid message expression!");
        }
        PropertyHandle property = dataItem.getPropertyHandle("color");
        String color = property.getStringValue();
        Debug.out((String)"COLOR", (Object)color);
        if (!color.equals("black")) {
            throw new Exception("Invalid message color!");
        }
        property = dataItem.getPropertyHandle("visibility");
        if (property.getValue() != null) {
            HideRuleHandle hideRule = (HideRuleHandle)property.iterator().next();
            Debug.out((String)"VISIBILITY", (Object)hideRule.getExpression());
            if (hideRule.getExpression().equals("true")) {
                throw new Exception("Invalid message visibility!");
            }
        }
    }

    private void removeOldParameters(int reportType) throws Exception {
        List list = this.design.getAllParameters();
        for (ScalarParameterHandle handle : list) {
            String parameterName = handle.getName();
            BIRTParametersMap.PARAMETERS_TYPES parameter = BIRTParametersMap.PARAMETERS.get(reportType, parameterName);
            if (parameter != null) continue;
            Debug.out((String)("DROPPING <" + parameterName + ">"));
            this.design.getParameters().dropAndClear((DesignElementHandle)handle);
        }
    }

    private void createNewParameters(int reportType) throws Exception {
        BIRTParametersMap.PARAMETERS_TYPES[] pARAMETERS_TYPESArray = BIRTParametersMap.PARAMETERS.get((int)reportType).array;
        int n = BIRTParametersMap.PARAMETERS.get((int)reportType).array.length;
        int n2 = 0;
        while (n2 < n) {
            BIRTParametersMap.PARAMETERS_TYPES parameter = pARAMETERS_TYPESArray[n2];
            ScalarParameterHandle handle = (ScalarParameterHandle)this.design.findParameter(parameter.name);
            if (handle == null) {
                handle = this.design.getElementFactory().newScalarParameter(parameter.name);
                handle.setValueType("static");
                handle.setDataType(parameter.type.birt);
                handle.setIsRequired(false);
                Debug.out((String)("ADDING <" + parameter.name + ">"));
                this.design.getParameters().add((DesignElementHandle)handle);
            }
            ++n2;
        }
    }

    private void changeParameterTypes(int reportType) throws Exception {
        BIRTParametersMap.PARAMETERS_TYPES[] pARAMETERS_TYPESArray = BIRTParametersMap.PARAMETERS.get((int)reportType).array;
        int n = BIRTParametersMap.PARAMETERS.get((int)reportType).array.length;
        int n2 = 0;
        while (n2 < n) {
            BIRTParametersMap.PARAMETERS_TYPES parameter = pARAMETERS_TYPESArray[n2];
            ScalarParameterHandle handle = (ScalarParameterHandle)this.design.findParameter(parameter.name);
            if (handle != null && !handle.getDataType().equals(parameter.type.birt)) {
                Debug.out((String)("CHANGING <" + parameter.name + "> from <" + handle.getDataType() + "> to <" + parameter.type.birt + ">"));
                handle.setDataType(parameter.type.birt);
            }
            ++n2;
        }
    }
}

